/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.AsyncMessageCallback;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.Message;
import freenet.io.comm.NotConnectedException;
import freenet.node.PeerNode;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;

public class SendMessageOnErrorCallback
implements AsyncMessageCallback {
    private static volatile boolean logMINOR;
    Message msg;
    PeerNode dest;
    ByteCounter ctr;

    public String toString() {
        return super.toString() + ": " + this.msg + ' ' + this.dest;
    }

    public SendMessageOnErrorCallback(Message message, PeerNode pn, ByteCounter ctr) {
        this.msg = message;
        this.dest = pn;
        this.ctr = ctr;
        if (logMINOR) {
            Logger.minor(this, "Created " + this);
        }
    }

    public void sent() {
    }

    public void acknowledged() {
    }

    public void disconnected() {
        block3: {
            if (logMINOR) {
                Logger.minor(this, "Disconnect trigger: " + this);
            }
            try {
                this.dest.sendAsync(this.msg, null, this.ctr);
            }
            catch (NotConnectedException e) {
                if (!logMINOR) break block3;
                Logger.minor(this, "Both source and destination disconnected: " + this.msg + " for " + this);
            }
        }
    }

    public void fatalError() {
        this.disconnected();
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }
}

