/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.node.NodeCrypto;
import freenet.node.OutgoingPacketMangler;
import freenet.node.PeerManager;
import freenet.node.SeedServerPeerNode;
import freenet.support.SimpleFieldSet;

public class SeedServerTestPeerNode
extends SeedServerPeerNode {
    public SeedServerTestPeerNode(SimpleFieldSet fs, Node node2, NodeCrypto crypto, PeerManager peers, boolean fromLocal, OutgoingPacketMangler mangler) throws FSParseException, PeerParseException, ReferenceSignatureVerificationException {
        super(fs, node2, crypto, peers, fromLocal, mangler);
    }

    public SimpleFieldSet exportFieldSet() {
        SimpleFieldSet sfs = super.exportFieldSet();
        sfs.putOverwrite("opennet", "true");
        return sfs;
    }

    public boolean shouldDisconnectAndRemoveNow() {
        return false;
    }

    protected void sendInitialMessages() {
    }

    public void onRemove() {
        long lastReceivedDataPacketTime = this.lastReceivedDataPacketTime();
        if (lastReceivedDataPacketTime <= 0L && this.timeLastConnectionCompleted() > 0L) {
            System.err.println(this.getIdentityString() + " : REMOVED: TIMEOUT: NO PACKETS RECEIVED AFTER SUCCESSFUL CONNECTION SETUP");
        } else if (this.timeLastConnectionCompleted() <= 0L) {
            System.err.println(this.getIdentityString() + " : REMOVED: NEVER CONNECTED");
        } else {
            System.err.println(this.getIdentityString() + " : REMOVED: UNKNOWN CAUSE");
        }
        super.onRemove();
    }

    public FATE getFate() {
        long lastReceivedDataPacketTime = this.lastReceivedDataPacketTime();
        if (this.isConnected()) {
            if (lastReceivedDataPacketTime <= 0L) {
                return FATE.CONNECTED_NO_PACKETS_RECEIVED;
            }
            if (this.isUnroutableOlderVersion()) {
                return FATE.CONNECTED_TOO_OLD;
            }
            return FATE.CONNECTED_SUCCESS;
        }
        long lastConnectionTime = this.timeLastConnectionCompleted();
        if (lastConnectionTime <= 0L) {
            return FATE.NEVER_CONNECTED;
        }
        if (lastReceivedDataPacketTime <= 0L) {
            return FATE.CONNECTED_TIMEOUT_NO_PACKETS_RECEIVED;
        }
        return FATE.CONNECTED_DISCONNECTED_UNKNOWN;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FATE {
        NEVER_CONNECTED,
        CONNECTED_NO_PACKETS_RECEIVED,
        CONNECTED_TOO_OLD,
        CONNECTED_SUCCESS,
        CONNECTED_TIMEOUT_NO_PACKETS_RECEIVED,
        CONNECTED_DISCONNECTED_UNKNOWN;

    }
}

