/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.FreenetInetAddress;
import freenet.io.comm.Peer;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.node.NodeCrypto;
import freenet.node.OpennetManager;
import freenet.node.OutgoingPacketMangler;
import freenet.node.PeerManager;
import freenet.node.PeerNode;
import freenet.node.PeerNodeStatus;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import java.net.InetAddress;
import java.util.ArrayList;

public class SeedServerPeerNode
extends PeerNode {
    public SeedServerPeerNode(SimpleFieldSet fs, Node node2, NodeCrypto crypto, PeerManager peers, boolean fromLocal, OutgoingPacketMangler mangler) throws FSParseException, PeerParseException, ReferenceSignatureVerificationException {
        super(fs, node2, crypto, peers, fromLocal, false, mangler, true);
    }

    public PeerNodeStatus getStatus(boolean noHeavy) {
        return new PeerNodeStatus(this, noHeavy);
    }

    public boolean isDarknet() {
        return false;
    }

    public boolean isOpennet() {
        return false;
    }

    public boolean isSeed() {
        return true;
    }

    public boolean isRealConnection() {
        return false;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SeedServerPeerNode) {
            return super.equals(o);
        }
        return false;
    }

    public void onSuccess(boolean insert, boolean ssk) {
    }

    public boolean isRoutingCompatible() {
        return false;
    }

    public boolean recordStatus() {
        return false;
    }

    protected void sendInitialMessages() {
        super.sendInitialMessages();
        final OpennetManager om = this.node.getOpennet();
        if (om == null) {
            Logger.normal(this, "Opennet turned off while connecting to seednodes");
            this.node.peers.disconnect(this, true, true, true);
        } else {
            this.node.getTicker().queueTimedJob(new Runnable(){

                public void run() {
                    try {
                        om.announcer.maybeSendAnnouncement();
                    }
                    catch (Throwable t) {
                        Logger.error(this, "Caught " + t, t);
                    }
                }
            }, 5000L);
        }
    }

    public InetAddress[] getInetAddresses() {
        Peer[] peers = this.getHandshakeIPs();
        ArrayList<InetAddress> v = new ArrayList<InetAddress>();
        for (int i = 0; i < peers.length; ++i) {
            InetAddress ia;
            FreenetInetAddress fa = peers[i].getFreenetAddress().dropHostname();
            if (fa == null || v.contains(ia = fa.getAddress())) continue;
            v.add(ia);
        }
        if (v.isEmpty()) {
            Logger.error(this, "No valid addresses for seed node " + this);
        }
        return v.toArray(new InetAddress[v.size()]);
    }

    public boolean handshakeUnknownInitiator() {
        return true;
    }

    public int handshakeSetupType() {
        return 1;
    }

    public boolean disconnected(boolean dumpMessageQueue, boolean dumpTrackers) {
        boolean ret = super.disconnected(dumpMessageQueue, dumpTrackers);
        this.node.peers.disconnect(this, false, false, false);
        return ret;
    }

    protected boolean generateIdentityFromPubkey() {
        return false;
    }

    public boolean shouldDisconnectAndRemoveNow() {
        OpennetManager om = this.node.getOpennet();
        if (om == null) {
            return true;
        }
        if (!om.announcer.enoughPeers()) {
            return false;
        }
        return System.currentTimeMillis() - om.announcer.timeGotEnoughPeers() > 300000L;
    }
}

