/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.node.NodeCrypto;
import freenet.node.OutgoingPacketMangler;
import freenet.node.PeerManager;
import freenet.node.PeerNode;
import freenet.node.PeerNodeStatus;
import freenet.support.SimpleFieldSet;

public class SeedClientPeerNode
extends PeerNode {
    public SeedClientPeerNode(SimpleFieldSet fs, Node node2, NodeCrypto crypto, PeerManager peers, boolean fromLocal, boolean noSig, OutgoingPacketMangler mangler) throws FSParseException, PeerParseException, ReferenceSignatureVerificationException {
        super(fs, node2, crypto, peers, fromLocal, noSig, mangler, true);
    }

    public PeerNodeStatus getStatus(boolean noHeavy) {
        return new PeerNodeStatus(this, noHeavy);
    }

    public boolean isDarknet() {
        return false;
    }

    public boolean isOpennet() {
        return false;
    }

    public boolean isSeed() {
        return true;
    }

    public boolean isRealConnection() {
        return false;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SeedClientPeerNode) {
            return super.equals(o);
        }
        return false;
    }

    public void onSuccess(boolean insert, boolean ssk) {
    }

    public boolean isRoutingCompatible() {
        return false;
    }

    public boolean canAcceptAnnouncements() {
        return true;
    }

    public boolean recordStatus() {
        return false;
    }

    public boolean handshakeUnknownInitiator() {
        return true;
    }

    public int handshakeSetupType() {
        return 1;
    }

    public boolean shouldSendHandshake() {
        return false;
    }

    public boolean disconnected(boolean dumpMessageQueue, boolean dumpTrackers) {
        boolean ret = super.disconnected(dumpMessageQueue, dumpTrackers);
        this.node.peers.disconnect(this, false, false, false);
        return ret;
    }

    protected boolean generateIdentityFromPubkey() {
        return true;
    }

    protected boolean ignoreLastGoodVersion() {
        return true;
    }

    void startARKFetcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldDisconnectAndRemoveNow() {
        if (!this.isConnected()) {
            SeedClientPeerNode seedClientPeerNode = this;
            synchronized (seedClientPeerNode) {
                if (this.timeLastConnectionCompleted() > 0L && System.currentTimeMillis() - this.lastReceivedPacketTime() > 60000L) {
                    return true;
                }
            }
        } else if (System.currentTimeMillis() - this.timeLastConnectionCompleted() > 3600000L) {
            return true;
        }
        return false;
    }
}

