/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.config.EnumerableOptionCallback;
import freenet.config.InvalidConfigValueException;
import freenet.config.NodeNeedRestartException;
import freenet.config.PersistentConfig;
import freenet.config.SubConfig;
import freenet.l10n.L10n;
import freenet.node.Node;
import freenet.node.SecurityLevelListener;
import freenet.node.useralerts.UserAlert;
import freenet.node.useralerts.UserAlertManager;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.api.StringCallback;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityLevels {
    private final Node node;
    NETWORK_THREAT_LEVEL networkThreatLevel;
    FRIENDS_THREAT_LEVEL friendsThreatLevel;
    PHYSICAL_THREAT_LEVEL physicalThreatLevel;
    private MyCallback<NETWORK_THREAT_LEVEL> networkThreatLevelCallback;
    private MyCallback<FRIENDS_THREAT_LEVEL> friendsThreatLevelCallback;
    private MyCallback<PHYSICAL_THREAT_LEVEL> physicalThreatLevelCallback;

    public SecurityLevels(Node node, PersistentConfig config) {
        this.node = node;
        SubConfig myConfig = new SubConfig("security-levels", config);
        int sortOrder = 0;
        this.networkThreatLevelCallback = new MyCallback<NETWORK_THREAT_LEVEL>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String get() {
                SecurityLevels securityLevels = SecurityLevels.this;
                synchronized (securityLevels) {
                    return SecurityLevels.this.networkThreatLevel.name();
                }
            }

            @Override
            public String[] getPossibleValues() {
                NETWORK_THREAT_LEVEL[] values = NETWORK_THREAT_LEVEL.values();
                String[] names = new String[values.length];
                for (int i = 0; i < names.length; ++i) {
                    names[i] = values[i].name();
                }
                return names;
            }

            @Override
            protected NETWORK_THREAT_LEVEL getValue() {
                return SecurityLevels.this.networkThreatLevel;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void setValue(String val) throws InvalidConfigValueException {
                NETWORK_THREAT_LEVEL newValue = SecurityLevels.parseNetworkThreatLevel(val);
                if (newValue == null) {
                    throw new InvalidConfigValueException("Invalid value for network threat level: " + val);
                }
                SecurityLevels securityLevels = SecurityLevels.this;
                synchronized (securityLevels) {
                    SecurityLevels.this.networkThreatLevel = newValue;
                }
            }
        };
        myConfig.register("networkThreatLevel", "HIGH", sortOrder++, false, true, "SecurityLevels.networkThreatLevelShort", "SecurityLevels.networkThreatLevel", this.networkThreatLevelCallback);
        NETWORK_THREAT_LEVEL netLevel = NETWORK_THREAT_LEVEL.valueOf(myConfig.getString("networkThreatLevel"));
        if (myConfig.getRawOption("networkThreatLevel") != null) {
            this.networkThreatLevel = netLevel;
        } else {
            this.setThreatLevel(netLevel);
        }
        this.friendsThreatLevelCallback = new MyCallback<FRIENDS_THREAT_LEVEL>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String get() {
                SecurityLevels securityLevels = SecurityLevels.this;
                synchronized (securityLevels) {
                    return SecurityLevels.this.friendsThreatLevel.name();
                }
            }

            @Override
            public String[] getPossibleValues() {
                FRIENDS_THREAT_LEVEL[] values = FRIENDS_THREAT_LEVEL.values();
                String[] names = new String[values.length];
                for (int i = 0; i < names.length; ++i) {
                    names[i] = values[i].name();
                }
                return names;
            }

            @Override
            protected FRIENDS_THREAT_LEVEL getValue() {
                return SecurityLevels.this.friendsThreatLevel;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void setValue(String val) throws InvalidConfigValueException {
                FRIENDS_THREAT_LEVEL newValue = FRIENDS_THREAT_LEVEL.valueOf(val);
                if (newValue != null) {
                    throw new InvalidConfigValueException("Invalid value for friends threat level: " + val);
                }
                SecurityLevels securityLevels = SecurityLevels.this;
                synchronized (securityLevels) {
                    SecurityLevels.this.friendsThreatLevel = newValue;
                }
            }
        };
        myConfig.register("friendsThreatLevel", "NORMAL", sortOrder++, false, true, "SecurityLevels.friendsThreatLevelShort", "SecurityLevels.friendsThreatLevel", this.friendsThreatLevelCallback);
        FRIENDS_THREAT_LEVEL friendsLevel = FRIENDS_THREAT_LEVEL.valueOf(myConfig.getString("friendsThreatLevel"));
        if (myConfig.getRawOption("friendsThreatLevel") != null) {
            this.friendsThreatLevel = friendsLevel;
        } else {
            this.setThreatLevel(friendsLevel);
        }
        this.physicalThreatLevelCallback = new MyCallback<PHYSICAL_THREAT_LEVEL>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String get() {
                SecurityLevels securityLevels = SecurityLevels.this;
                synchronized (securityLevels) {
                    return SecurityLevels.this.physicalThreatLevel.name();
                }
            }

            @Override
            public String[] getPossibleValues() {
                PHYSICAL_THREAT_LEVEL[] values = PHYSICAL_THREAT_LEVEL.values();
                String[] names = new String[values.length];
                for (int i = 0; i < names.length; ++i) {
                    names[i] = values[i].name();
                }
                return names;
            }

            @Override
            protected PHYSICAL_THREAT_LEVEL getValue() {
                return SecurityLevels.this.physicalThreatLevel;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void setValue(String val) throws InvalidConfigValueException {
                PHYSICAL_THREAT_LEVEL newValue = PHYSICAL_THREAT_LEVEL.valueOf(val);
                if (newValue != null) {
                    throw new InvalidConfigValueException("Invalid value for physical threat level: " + val);
                }
                SecurityLevels securityLevels = SecurityLevels.this;
                synchronized (securityLevels) {
                    SecurityLevels.this.physicalThreatLevel = newValue;
                }
            }
        };
        myConfig.register("physicalThreatLevel", "NORMAL", sortOrder++, false, true, "SecurityLevels.physicalThreatLevelShort", "SecurityLevels.physicalThreatLevel", this.physicalThreatLevelCallback);
        PHYSICAL_THREAT_LEVEL physLevel = PHYSICAL_THREAT_LEVEL.valueOf(myConfig.getString("physicalThreatLevel"));
        if (myConfig.getRawOption("physicalThreatLevel") != null) {
            this.physicalThreatLevel = physLevel;
        } else {
            this.setThreatLevel(physLevel);
        }
        myConfig.finishedInitialization();
    }

    public synchronized void addNetworkThreatLevelListener(SecurityLevelListener<NETWORK_THREAT_LEVEL> listener) {
        this.networkThreatLevelCallback.addListener(listener);
    }

    public synchronized void addFriendsThreatLevelListener(SecurityLevelListener<FRIENDS_THREAT_LEVEL> listener) {
        this.friendsThreatLevelCallback.addListener(listener);
    }

    public synchronized void addPhysicalThreatLevelListener(SecurityLevelListener<PHYSICAL_THREAT_LEVEL> listener) {
        this.physicalThreatLevelCallback.addListener(listener);
    }

    public NETWORK_THREAT_LEVEL getNetworkThreatLevel() {
        return this.networkThreatLevel;
    }

    public FRIENDS_THREAT_LEVEL getFriendsThreatLevel() {
        return this.friendsThreatLevel;
    }

    public PHYSICAL_THREAT_LEVEL getPhysicalThreatLevel() {
        return this.physicalThreatLevel;
    }

    public static NETWORK_THREAT_LEVEL parseNetworkThreatLevel(String arg) {
        try {
            return NETWORK_THREAT_LEVEL.valueOf(arg);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static FRIENDS_THREAT_LEVEL parseFriendsThreatLevel(String arg) {
        try {
            return FRIENDS_THREAT_LEVEL.valueOf(arg);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static PHYSICAL_THREAT_LEVEL parsePhysicalThreatLevel(String arg) {
        try {
            return PHYSICAL_THREAT_LEVEL.valueOf(arg);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public HTMLNode getConfirmWarning(NETWORK_THREAT_LEVEL newThreatLevel, String checkboxName) {
        if (newThreatLevel == this.networkThreatLevel) {
            return null;
        }
        HTMLNode parent = new HTMLNode("div");
        if (newThreatLevel == NETWORK_THREAT_LEVEL.HIGH && this.networkThreatLevel != NETWORK_THREAT_LEVEL.MAXIMUM || newThreatLevel == NETWORK_THREAT_LEVEL.MAXIMUM) {
            if (this.node.peers.getDarknetPeers().length == 0) {
                parent.addChild("p", this.l10n("noFriendsWarning"));
                if (newThreatLevel == NETWORK_THREAT_LEVEL.MAXIMUM) {
                    HTMLNode p = parent.addChild("p");
                    L10n.addL10nSubstitution(p, "SecurityLevels.maximumNetworkThreatLevelWarning", new String[]{"bold", "/bold"}, new String[]{"<b>", "</b>"});
                }
                parent.addChild("input", new String[]{"type", "name", "value"}, new String[]{"checkbox", checkboxName, "off"}, this.l10n("noFriendsCheckbox"));
                return parent;
            }
            if (this.node.peers.countConnectedDarknetPeers() == 0) {
                parent.addChild("p", this.l10n("noConnectedFriendsWarning", "added", Integer.toString(this.node.peers.getDarknetPeers().length)));
                if (newThreatLevel == NETWORK_THREAT_LEVEL.MAXIMUM) {
                    HTMLNode p = parent.addChild("p");
                    L10n.addL10nSubstitution(p, "SecurityLevels.maximumNetworkThreatLevelWarning", new String[]{"bold", "/bold"}, new String[]{"<b>", "</b>"});
                }
                parent.addChild("input", new String[]{"type", "name", "value"}, new String[]{"checkbox", checkboxName, "off"}, this.l10n("noConnectedFriendsCheckbox"));
                return parent;
            }
            if (this.node.peers.countConnectedDarknetPeers() < 10) {
                parent.addChild("p", this.l10n("fewConnectedFriendsWarning", new String[]{"connected", "added"}, new String[]{Integer.toString(this.node.peers.countConnectedDarknetPeers()), Integer.toString(this.node.peers.getDarknetPeers().length)}));
                if (newThreatLevel == NETWORK_THREAT_LEVEL.MAXIMUM) {
                    HTMLNode p = parent.addChild("p");
                    L10n.addL10nSubstitution(p, "SecurityLevels.maximumNetworkThreatLevelWarning", new String[]{"bold", "/bold"}, new String[]{"<b>", "</b>"});
                }
                parent.addChild("input", new String[]{"type", "name", "value"}, new String[]{"checkbox", checkboxName, "off"}, this.l10n("fewConnectedFriendsCheckbox"));
                return parent;
            }
        } else if (newThreatLevel == NETWORK_THREAT_LEVEL.LOW) {
            parent.addChild("p", this.l10n("networkThreatLevelLowWarning"));
            parent.addChild("input", new String[]{"type", "name", "value"}, new String[]{"checkbox", checkboxName, "off"}, this.l10n("networkThreatLevelLowCheckbox"));
            return parent;
        }
        if (newThreatLevel == NETWORK_THREAT_LEVEL.MAXIMUM) {
            HTMLNode p = parent.addChild("p");
            L10n.addL10nSubstitution(p, "SecurityLevels.maximumNetworkThreatLevelWarning", new String[]{"bold", "/bold"}, new String[]{"<b>", "</b>"});
            p.addChild("#", " ");
            L10n.addL10nSubstitution(p, "SecurityLevels.maxSecurityYouNeedFriends", new String[]{"bold", "/bold"}, new String[]{"<b>", "</b>"});
            parent.addChild("input", new String[]{"type", "name", "value"}, new String[]{"checkbox", checkboxName, "off"}, this.l10n("maximumNetworkThreatLevelCheckbox"));
            return parent;
        }
        return null;
    }

    public HTMLNode getConfirmWarning(FRIENDS_THREAT_LEVEL newFriendsLevel, String checkboxName) {
        if (newFriendsLevel == this.friendsThreatLevel) {
            return null;
        }
        if (newFriendsLevel == FRIENDS_THREAT_LEVEL.HIGH) {
            HTMLNode parent = new HTMLNode("div");
            parent.addChild("p", this.l10n("highFriendsThreatLevelWarning"));
            parent.addChild("input", new String[]{"type", "name", "value"}, new String[]{"checkbox", checkboxName, "off"}, this.l10n("highFriendsThreatLevelCheckbox"));
            return parent;
        }
        return null;
    }

    private String l10n(String string) {
        return L10n.getString("SecurityLevels." + string);
    }

    private String l10n(String string, String pattern, String value) {
        return L10n.getString("SecurityLevels." + string, pattern, value);
    }

    private String l10n(String string, String[] patterns, String[] values) {
        return L10n.getString("SecurityLevels." + string, patterns, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreatLevel(NETWORK_THREAT_LEVEL newThreatLevel) {
        NETWORK_THREAT_LEVEL oldLevel;
        if (newThreatLevel == null) {
            throw new NullPointerException();
        }
        SecurityLevels securityLevels = this;
        synchronized (securityLevels) {
            oldLevel = this.networkThreatLevel;
            this.networkThreatLevel = newThreatLevel;
        }
        this.networkThreatLevelCallback.onSet(oldLevel, newThreatLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreatLevel(FRIENDS_THREAT_LEVEL newThreatLevel) {
        FRIENDS_THREAT_LEVEL oldLevel;
        if (newThreatLevel == null) {
            throw new NullPointerException();
        }
        SecurityLevels securityLevels = this;
        synchronized (securityLevels) {
            oldLevel = this.friendsThreatLevel;
            this.friendsThreatLevel = newThreatLevel;
        }
        this.friendsThreatLevelCallback.onSet(oldLevel, newThreatLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreatLevel(PHYSICAL_THREAT_LEVEL newThreatLevel) {
        PHYSICAL_THREAT_LEVEL oldLevel;
        if (newThreatLevel == null) {
            throw new NullPointerException();
        }
        SecurityLevels securityLevels = this;
        synchronized (securityLevels) {
            oldLevel = this.physicalThreatLevel;
            this.physicalThreatLevel = newThreatLevel;
        }
        this.physicalThreatLevelCallback.onSet(oldLevel, newThreatLevel);
    }

    public static String localisedName(NETWORK_THREAT_LEVEL newThreatLevel) {
        return L10n.getString("SecurityLevels.networkThreatLevel.name." + newThreatLevel.name());
    }

    public static String localisedName(FRIENDS_THREAT_LEVEL newFriendsLevel) {
        return L10n.getString("SecurityLevels.friendsThreatLevel.name." + newFriendsLevel.name());
    }

    public static String localisedName(PHYSICAL_THREAT_LEVEL newPhysicalLevel) {
        return L10n.getString("SecurityLevels.physicalThreatLevel.name." + newPhysicalLevel.name());
    }

    public void registerUserAlert(UserAlertManager alerts) {
        alerts.register(new UserAlert(){

            public String anchor() {
                return "seclevels";
            }

            public String dismissButtonText() {
                return L10n.getString("UserAlert.hide");
            }

            public HTMLNode getHTMLText() {
                HTMLNode div = new HTMLNode("div");
                HTMLNode ul = div.addChild("ul");
                ul.addChild("li", SecurityLevels.this.l10n("userAlertNetworkThreatLevel", "level", SecurityLevels.localisedName(SecurityLevels.this.networkThreatLevel)));
                ul.addChild("li", SecurityLevels.this.l10n("userAlertFriendsThreatLevel", "level", SecurityLevels.localisedName(SecurityLevels.this.friendsThreatLevel)));
                ul.addChild("li", SecurityLevels.this.l10n("userAlertPhysicalThreatLevel", "level", SecurityLevels.localisedName(SecurityLevels.this.physicalThreatLevel)));
                div.addChild("br");
                L10n.addL10nSubstitution(div, "SecurityLevels.userAlertExtro", new String[]{"link", "/link"}, new String[]{"<a href=\"/seclevels/\">", "</a>"});
                return div;
            }

            public short getPriorityClass() {
                return 2;
            }

            public String getShortText() {
                return SecurityLevels.this.l10n("userAlertShortText", new String[]{"network", "friends", "physical"}, new String[]{SecurityLevels.localisedName(SecurityLevels.this.networkThreatLevel), SecurityLevels.localisedName(SecurityLevels.this.friendsThreatLevel), SecurityLevels.localisedName(SecurityLevels.this.physicalThreatLevel)});
            }

            public String getText() {
                return this.getHTMLText().getContent();
            }

            public String getTitle() {
                return SecurityLevels.this.l10n("title");
            }

            public Object getUserIdentifier() {
                return null;
            }

            public boolean isEventNotification() {
                return false;
            }

            public boolean isValid() {
                return true;
            }

            public void isValid(boolean validity) {
            }

            public void onDismiss() {
            }

            public boolean shouldUnregisterOnDismiss() {
                return true;
            }

            public boolean userCanDismiss() {
                return true;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class MyCallback<T>
    extends StringCallback
    implements EnumerableOptionCallback {
        private final ArrayList<SecurityLevelListener<T>> listeners = new ArrayList();

        MyCallback() {
        }

        public void addListener(SecurityLevelListener<T> listener) {
            if (this.listeners.contains(listener)) {
                Logger.error(this, "Already have listener " + listener + " in " + this);
                return;
            }
            this.listeners.add(listener);
        }

        @Override
        public void set(String val) throws InvalidConfigValueException, NodeNeedRestartException {
            T oldLevel = this.getValue();
            this.setValue(val);
            T newLevel = this.getValue();
            this.onSet(oldLevel, newLevel);
        }

        void onSet(T oldLevel, T newLevel) {
            for (SecurityLevelListener<T> listener : this.listeners) {
                listener.onChange(oldLevel, newLevel);
            }
        }

        protected abstract void setValue(String var1) throws InvalidConfigValueException;

        protected abstract T getValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PHYSICAL_THREAT_LEVEL {
        LOW,
        NORMAL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FRIENDS_THREAT_LEVEL {
        LOW,
        NORMAL,
        HIGH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NETWORK_THREAT_LEVEL {
        LOW,
        NORMAL,
        HIGH,
        MAXIMUM;

    }
}

