/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.crypt.DSAPublicKey;
import freenet.crypt.SHA256;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.io.xfer.WaitedTooLongException;
import freenet.keys.NodeSSK;
import freenet.keys.SSKBlock;
import freenet.keys.SSKVerifyException;
import freenet.node.AnyInsertSender;
import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.node.PrioRunnable;
import freenet.node.SyncSendWaitedTooLongException;
import freenet.support.Logger;
import freenet.support.OOMHandler;
import freenet.support.ShortBuffer;
import java.util.HashSet;

public class SSKInsertSender
implements PrioRunnable,
AnyInsertSender,
ByteCounter {
    static final int ACCEPTED_TIMEOUT = 10000;
    static final int SEARCH_TIMEOUT = 60000;
    final NodeSSK myKey;
    final double target;
    final long uid;
    short htl;
    final PeerNode source;
    final Node node;
    final DSAPublicKey pubKey;
    final byte[] pubKeyHash;
    byte[] data;
    byte[] headers;
    final boolean fromStore;
    final long startTime;
    private boolean sentRequest;
    private boolean hasCollided;
    private boolean hasRecentlyCollided;
    private SSKBlock block;
    private static boolean logMINOR;
    private int status = -1;
    static final int NOT_FINISHED = -1;
    static final int SUCCESS = 0;
    static final int ROUTE_NOT_FOUND = 1;
    static final int INTERNAL_ERROR = 3;
    static final int TIMED_OUT = 4;
    static final int GENERATED_REJECTED_OVERLOAD = 5;
    static final int ROUTE_REALLY_NOT_FOUND = 6;
    private boolean hasForwardedRejectedOverload;
    private final Object totalBytesSync = new Object();
    private int totalBytesSent;
    private int totalBytesReceived;

    SSKInsertSender(SSKBlock block, long uid, short htl, PeerNode source, Node node, boolean fromStore) {
        logMINOR = Logger.shouldLog(4, this);
        this.fromStore = fromStore;
        this.node = node;
        this.source = source;
        this.htl = htl;
        this.uid = uid;
        this.myKey = block.getKey();
        this.data = block.getRawData();
        this.headers = block.getRawHeaders();
        this.target = this.myKey.toNormalizedDouble();
        this.pubKey = this.myKey.getPubKey();
        if (this.pubKey == null) {
            throw new IllegalArgumentException("Must have pubkey to insert data!!");
        }
        byte[] pubKeyAsBytes = this.pubKey.asBytes();
        this.pubKeyHash = SHA256.digest(pubKeyAsBytes);
        this.block = block;
        this.startTime = System.currentTimeMillis();
    }

    void start() {
        this.node.executor.execute(this, "SSKInsertSender for UID " + this.uid + " on " + this.node.getDarknetPortNumber() + " at " + System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        short origHTL;
        block15: {
            Logger.OSThread.logPID(this);
            origHTL = this.htl;
            this.node.addInsertSender(this.myKey, this.htl, this);
            try {
                try {
                    this.realRun();
                }
                catch (OutOfMemoryError e) {
                    OOMHandler.handleOOM(e);
                    if (this.status == -1) {
                        this.finish(3, null);
                    }
                    Object var4_3 = null;
                    if (logMINOR) {
                        Logger.minor(this, "Finishing " + this);
                    }
                    if (this.status == -1) {
                        this.finish(3, null);
                    }
                    this.node.removeInsertSender(this.myKey, origHTL, this);
                    return;
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught " + t, t);
                    if (this.status == -1) {
                        this.finish(3, null);
                    }
                    Object var4_4 = null;
                    if (logMINOR) {
                        Logger.minor(this, "Finishing " + this);
                    }
                    if (this.status == -1) {
                        this.finish(3, null);
                    }
                    this.node.removeInsertSender(this.myKey, origHTL, this);
                    return;
                }
                Object var4_2 = null;
                if (!logMINOR) break block15;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (logMINOR) {
                    Logger.minor(this, "Finishing " + this);
                }
                if (this.status == -1) {
                    this.finish(3, null);
                }
                this.node.removeInsertSender(this.myKey, origHTL, this);
                throw throwable;
            }
            Logger.minor(this, "Finishing " + this);
        }
        if (this.status == -1) {
            this.finish(3, null);
        }
        this.node.removeInsertSender(this.myKey, origHTL, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realRun() {
        Message msg;
        HashSet<PeerNode> nodesRoutedTo = new HashSet<PeerNode>();
        PeerNode next = null;
        block21: while (true) {
            MessageFilter mf;
            MessageFilter mfRejectedOverload;
            block49: {
                this.htl = this.node.decrementHTL(this.sentRequest ? next : this.source, this.htl);
                if (this.htl == 0) {
                    this.finish(0, null);
                    return;
                }
                next = this.node.peers.closerPeer(this.source, nodesRoutedTo, this.target, true, this.node.isAdvancedModeEnabled(), -1, null, null);
                if (next == null) {
                    this.finish(1, null);
                    return;
                }
                if (logMINOR) {
                    Logger.minor(this, "Routing insert to " + next);
                }
                nodesRoutedTo.add(next);
                Message request = DMT.createFNPSSKInsertRequestNew(this.uid, this.htl, this.myKey);
                MessageFilter mfAccepted = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(10000).setType(DMT.FNPSSKAccepted);
                MessageFilter mfRejectedLoop = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(10000).setType(DMT.FNPRejectedLoop);
                mfRejectedOverload = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(10000).setType(DMT.FNPRejectedOverload);
                mfRejectedOverload.clearOr();
                mf = mfAccepted.or(mfRejectedLoop.or(mfRejectedOverload));
                try {
                    next.sendAsync(request, null, this);
                }
                catch (NotConnectedException e1) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "Not connected to " + next);
                    continue;
                }
                this.sentRequest = true;
                msg = null;
                while (true) {
                    try {
                        msg = this.node.usm.waitFor(mf, this);
                    }
                    catch (DisconnectedException e) {
                        Logger.normal(this, "Disconnected from " + next + " while waiting for Accepted");
                        break block49;
                    }
                    if (msg == null) {
                        if (logMINOR) {
                            Logger.minor(this, "Timeout");
                        }
                        next.localRejectedOverload("Timeout");
                        this.forwardRejectedOverload();
                        break block49;
                    }
                    if (msg.getSpec() != DMT.FNPRejectedOverload) break;
                    if (msg.getBoolean("isLocal")) {
                        next.localRejectedOverload("ForwardRejectedOverload3");
                        if (logMINOR) {
                            Logger.minor(this, "Local RejectedOverload, moving on to next peer");
                        }
                        break block49;
                    }
                    this.forwardRejectedOverload();
                }
                if (msg.getSpec() == DMT.FNPRejectedLoop) {
                    next.successNotOverload();
                } else if (msg.getSpec() != DMT.FNPSSKAccepted) {
                    Logger.error(this, "Unexpected message waiting for SSKAccepted: " + msg);
                }
            }
            if (msg == null || msg.getSpec() != DMT.FNPSSKAccepted) continue;
            if (logMINOR) {
                Logger.minor(this, "Got Accepted on " + this);
            }
            Message headersMsg = DMT.createFNPSSKInsertRequestHeaders(this.uid, this.headers);
            Message dataMsg = DMT.createFNPSSKInsertRequestData(this.uid, this.data);
            try {
                next.sendAsync(headersMsg, null, this);
                next.sendThrottledMessage(dataMsg, this.data.length, this, 30000, false, null);
            }
            catch (NotConnectedException e1) {
                if (!logMINOR) continue;
                Logger.minor(this, "Not connected to " + next);
                continue;
            }
            catch (WaitedTooLongException e) {
                Logger.error(this, "Waited too long to send " + dataMsg + " to " + next + " on " + this);
                continue;
            }
            catch (SyncSendWaitedTooLongException e) {
                // empty catch block
            }
            if (msg.getBoolean("needPubKey")) {
                Message newAck;
                Message pkMsg = DMT.createFNPSSKPubKey(this.uid, this.pubKey);
                try {
                    next.sendAsync(pkMsg, null, this);
                }
                catch (NotConnectedException e) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "Node disconnected while sending pubkey: " + next);
                    continue;
                }
                MessageFilter mf1 = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(10000).setType(DMT.FNPSSKPubKeyAccepted);
                try {
                    newAck = this.node.usm.waitFor(mf1, this);
                }
                catch (DisconnectedException e) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "Disconnected from " + next);
                    continue;
                }
                if (newAck == null) {
                    if (logMINOR) {
                        Logger.minor(this, "Timeout");
                    }
                    next.localRejectedOverload("Timeout2");
                    this.forwardRejectedOverload();
                    continue;
                }
            }
            MessageFilter mfInsertReply = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(60000).setType(DMT.FNPInsertReply);
            mfRejectedOverload.setTimeout(60000);
            mfRejectedOverload.clearOr();
            MessageFilter mfRouteNotFound = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(60000).setType(DMT.FNPRouteNotFound);
            MessageFilter mfDataInsertRejected = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(60000).setType(DMT.FNPDataInsertRejected);
            mf = mfRouteNotFound.or(mfInsertReply.or(mfRejectedOverload.or(mfDataInsertRejected)));
            while (true) {
                Message dataMessage;
                try {
                    msg = this.node.usm.waitFor(mf, this);
                }
                catch (DisconnectedException e) {
                    Logger.normal(this, "Disconnected from " + next + " while waiting for InsertReply on " + this);
                    continue block21;
                }
                if (msg == null) {
                    Logger.error(this, "Timeout (" + msg + ") after Accepted in insert; to (" + next + ")");
                    next.localRejectedOverload("AfterInsertAcceptedTimeout");
                    this.finish(4, next);
                    return;
                }
                if (msg.getSpec() == DMT.FNPRejectedOverload) {
                    if (msg.getBoolean("isLocal")) {
                        next.localRejectedOverload("ForwardRejectedOverload4");
                        if (!logMINOR) continue block21;
                        Logger.minor(this, "Local RejectedOverload, moving on to next peer");
                        continue block21;
                    }
                    this.forwardRejectedOverload();
                    continue;
                }
                if (msg.getSpec() == DMT.FNPRouteNotFound) {
                    short newHtl;
                    if (logMINOR) {
                        Logger.minor(this, "Rejected: RNF");
                    }
                    if (this.htl > (newHtl = msg.getShort("hopsToLive"))) {
                        this.htl = newHtl;
                    }
                    next.successNotOverload();
                    continue block21;
                }
                if (msg.getSpec() == DMT.FNPDataInsertRejected) {
                    next.successNotOverload();
                    short reason = msg.getShort("dataInsertRejectedReason");
                    if (logMINOR) {
                        Logger.minor(this, "DataInsertRejected: " + reason);
                    }
                    if (reason == 1 && this.fromStore) {
                        Logger.error(this, "Verify failed on next node " + next + " for DataInsert but we were sending from the store!");
                    }
                    Logger.error(this, "SSK insert rejected! Reason=" + DMT.getDataInsertRejectedReason(reason));
                    continue block21;
                }
                if (msg.getSpec() != DMT.FNPSSKDataFoundHeaders) break block21;
                Logger.normal(this, "Got collision on " + this.myKey + " (" + this.uid + ") sending to " + next.getPeer());
                this.headers = ((ShortBuffer)msg.getObject("blockHeaders")).getData();
                MessageFilter mfData = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(120000).setType(DMT.FNPSSKDataFoundData);
                try {
                    dataMessage = this.node.usm.waitFor(mfData, this);
                }
                catch (DisconnectedException e) {
                    if (!logMINOR) continue block21;
                    Logger.minor(this, "Disconnected: " + next + " getting datareply for " + this);
                    continue block21;
                }
                if (dataMessage == null) {
                    Logger.error(this, "Got headers but not data for datareply for insert from " + this);
                    continue block21;
                }
                try {
                    this.data = ((ShortBuffer)dataMessage.getObject("data")).getData();
                    this.block = new SSKBlock(this.data, this.block.getRawHeaders(), this.block.getKey(), false);
                    SSKInsertSender e = this;
                    synchronized (e) {
                        this.hasRecentlyCollided = true;
                        this.hasCollided = true;
                        this.notifyAll();
                        continue;
                    }
                }
                catch (SSKVerifyException e) {
                    Logger.error(this, "Invalid SSK from remote on collusion: " + this + ":" + this.block);
                    this.finish(3, next);
                    continue;
                }
                break;
            }
            break;
        }
        if (msg.getSpec() != DMT.FNPInsertReply) {
            Logger.error(this, "Unknown reply: " + msg);
            this.finish(3, next);
        }
        next.successNotOverload();
        this.finish(0, next);
    }

    synchronized boolean receivedRejectedOverload() {
        return this.hasForwardedRejectedOverload;
    }

    private synchronized void forwardRejectedOverload() {
        if (this.hasForwardedRejectedOverload) {
            return;
        }
        this.hasForwardedRejectedOverload = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(int code, PeerNode next) {
        if (logMINOR) {
            Logger.minor(this, "Finished: " + code + " on " + this, (Throwable)new Exception("debug"));
        }
        SSKInsertSender sSKInsertSender = this;
        synchronized (sSKInsertSender) {
            if (this.status != -1) {
                throw new IllegalStateException("finish() called with " + code + " when was already " + this.status);
            }
            if (code == 1 && !this.sentRequest) {
                code = 6;
            }
            this.status = code;
            this.notifyAll();
        }
        if (code == 0 && next != null) {
            next.onSuccess(true, true);
        }
        if (logMINOR) {
            Logger.minor(this, "Set status code: " + this.getStatusString());
        }
    }

    public synchronized int getStatus() {
        return this.status;
    }

    public synchronized short getHTL() {
        return this.htl;
    }

    public synchronized String getStatusString() {
        if (this.status == 0) {
            return "SUCCESS";
        }
        if (this.status == 1) {
            return "ROUTE NOT FOUND";
        }
        if (this.status == -1) {
            return "NOT FINISHED";
        }
        if (this.status == 3) {
            return "INTERNAL ERROR";
        }
        if (this.status == 4) {
            return "TIMED OUT";
        }
        if (this.status == 5) {
            return "GENERATED REJECTED OVERLOAD";
        }
        if (this.status == 6) {
            return "ROUTE REALLY NOT FOUND";
        }
        return "UNKNOWN STATUS CODE: " + this.status;
    }

    public boolean sentRequest() {
        return this.sentRequest;
    }

    public synchronized boolean hasRecentlyCollided() {
        boolean status = this.hasRecentlyCollided;
        this.hasRecentlyCollided = false;
        return status;
    }

    public boolean hasCollided() {
        return this.hasCollided;
    }

    public byte[] getPubkeyHash() {
        return this.headers;
    }

    public byte[] getHeaders() {
        return this.headers;
    }

    public byte[] getData() {
        return this.data;
    }

    public SSKBlock getBlock() {
        return this.block;
    }

    public long getUID() {
        return this.uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sentBytes(int x) {
        Object object = this.totalBytesSync;
        synchronized (object) {
            this.totalBytesSent += x;
        }
        this.node.nodeStats.insertSentBytes(true, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalSentBytes() {
        Object object = this.totalBytesSync;
        synchronized (object) {
            return this.totalBytesSent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedBytes(int x) {
        Object object = this.totalBytesSync;
        synchronized (object) {
            this.totalBytesReceived += x;
        }
        this.node.nodeStats.insertReceivedBytes(true, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalReceivedBytes() {
        Object object = this.totalBytesSync;
        synchronized (object) {
            return this.totalBytesReceived;
        }
    }

    public void sentPayload(int x) {
        this.node.sentPayload(x);
        this.node.nodeStats.insertSentBytes(true, -x);
    }

    public int getPriority() {
        return 7;
    }

    public String toString() {
        return "SSKInsertSender:" + this.myKey;
    }
}

