/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.crypt.CryptFormatException;
import freenet.crypt.DSAPublicKey;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.io.xfer.WaitedTooLongException;
import freenet.keys.NodeSSK;
import freenet.keys.SSKBlock;
import freenet.keys.SSKVerifyException;
import freenet.node.InsertTag;
import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.node.PrioRunnable;
import freenet.node.RequestHandler;
import freenet.node.SSKInsertSender;
import freenet.store.KeyCollisionException;
import freenet.support.Logger;
import freenet.support.OOMHandler;
import freenet.support.ShortBuffer;

public class SSKInsertHandler
implements PrioRunnable,
ByteCounter {
    private static boolean logMINOR;
    static final int PUBKEY_TIMEOUT = 10000;
    static final int DATA_INSERT_TIMEOUT = 30000;
    final Node node;
    final long uid;
    final PeerNode source;
    final NodeSSK key;
    final long startTime;
    private SSKBlock block;
    private DSAPublicKey pubKey;
    private short htl;
    private SSKInsertSender sender;
    private byte[] data;
    private byte[] headers;
    private boolean canCommit;
    final InsertTag tag;
    private boolean collided = false;
    private final Object totalBytesSync = new Object();
    private int totalBytesSent;
    private int totalBytesReceived;

    SSKInsertHandler(NodeSSK key, byte[] data, byte[] headers, short htl, PeerNode source, long id, Node node, long startTime, InsertTag tag) {
        this.node = node;
        this.uid = id;
        this.source = source;
        this.startTime = startTime;
        this.key = key;
        this.htl = htl;
        this.data = data;
        this.headers = headers;
        this.tag = tag;
        if (htl <= 0) {
            htl = 1;
        }
        byte[] pubKeyHash = key.getPubKeyHash();
        this.pubKey = node.getPubKey.getKey(pubKeyHash);
        this.canCommit = false;
        logMINOR = Logger.shouldLog(4, this);
    }

    public String toString() {
        return super.toString() + " for " + this.uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block9: {
            Logger.OSThread.logPID(this);
            try {
                try {
                    this.realRun();
                }
                catch (OutOfMemoryError e) {
                    OOMHandler.handleOOM(e);
                    Object var3_2 = null;
                    if (logMINOR) {
                        Logger.minor(this, "Exiting InsertHandler.run() for " + this.uid);
                    }
                    this.node.unlockUID(this.uid, true, true, false, false, false, this.tag);
                    return;
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught " + t, t);
                    Object var3_3 = null;
                    if (logMINOR) {
                        Logger.minor(this, "Exiting InsertHandler.run() for " + this.uid);
                    }
                    this.node.unlockUID(this.uid, true, true, false, false, false, this.tag);
                    return;
                }
                Object var3_1 = null;
                if (!logMINOR) break block9;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                if (logMINOR) {
                    Logger.minor(this, "Exiting InsertHandler.run() for " + this.uid);
                }
                this.node.unlockUID(this.uid, true, true, false, false, false, this.tag);
                throw throwable;
            }
            Logger.minor(this, "Exiting InsertHandler.run() for " + this.uid);
        }
        this.node.unlockUID(this.uid, true, true, false, false, false, this.tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realRun() {
        Message msg;
        int status;
        Message msg2;
        MessageFilter mf;
        Message accepted = DMT.createFNPSSKAccepted(this.uid, this.pubKey == null);
        try {
            this.source.sendAsync(accepted, null, this);
        }
        catch (NotConnectedException e1) {
            if (logMINOR) {
                Logger.minor(this, "Lost connection to source");
            }
            return;
        }
        if (this.headers == null) {
            try {
                mf = MessageFilter.create().setType(DMT.FNPSSKInsertRequestHeaders).setField("uid", this.uid).setSource(this.source).setTimeout(30000);
                msg2 = this.node.usm.waitFor(mf, this);
                if (msg2 == null) {
                    Logger.normal(this, "Failed to receive FNPSSKInsertRequestHeaders for " + this.uid);
                    return;
                }
                this.headers = ((ShortBuffer)msg2.getObject("blockHeaders")).getData();
            }
            catch (DisconnectedException e) {
                if (logMINOR) {
                    Logger.minor(this, "Lost connection to source on " + this.uid);
                }
                return;
            }
        }
        if (this.data == null) {
            try {
                mf = MessageFilter.create().setType(DMT.FNPSSKInsertRequestData).setField("uid", this.uid).setSource(this.source).setTimeout(30000);
                msg2 = this.node.usm.waitFor(mf, this);
                if (msg2 == null) {
                    Logger.normal(this, "Failed to receive FNPSSKInsertRequestData for " + this.uid);
                    return;
                }
                this.data = ((ShortBuffer)msg2.getObject("data")).getData();
            }
            catch (DisconnectedException e) {
                if (logMINOR) {
                    Logger.minor(this, "Lost connection to source on " + this.uid);
                }
                return;
            }
        }
        if (this.pubKey == null) {
            if (logMINOR) {
                Logger.minor(this, "Waiting for pubkey on " + this.uid);
            }
            MessageFilter mfPK = MessageFilter.create().setType(DMT.FNPSSKPubKey).setField("uid", this.uid).setSource(this.source).setTimeout(10000);
            try {
                Message pk = this.node.usm.waitFor(mfPK, this);
                if (pk == null) {
                    Logger.normal(this, "Failed to receive FNPSSKPubKey for " + this.uid);
                    return;
                }
                byte[] pubkeyAsBytes = ((ShortBuffer)pk.getObject("pubkeyAsBytes")).getData();
                try {
                    this.pubKey = DSAPublicKey.create(pubkeyAsBytes);
                    if (logMINOR) {
                        Logger.minor(this, "Got pubkey on " + this.uid + " : " + this.pubKey);
                    }
                    Message confirm = DMT.createFNPSSKPubKeyAccepted(this.uid);
                    try {
                        this.source.sendAsync(confirm, null, this);
                    }
                    catch (NotConnectedException e) {
                        if (logMINOR) {
                            Logger.minor(this, "Lost connection to source on " + this.uid);
                        }
                        return;
                    }
                }
                catch (CryptFormatException e) {
                    Logger.error(this, "Invalid pubkey from " + this.source + " on " + this.uid);
                    Message msg3 = DMT.createFNPDataInsertRejected(this.uid, (short)3);
                    try {
                        this.source.sendSync(msg3, this);
                    }
                    catch (NotConnectedException ee) {
                        // empty catch block
                    }
                    return;
                }
            }
            catch (DisconnectedException e) {
                if (logMINOR) {
                    Logger.minor(this, "Lost connection to source on " + this.uid);
                }
                return;
            }
        }
        try {
            this.key.setPubKey(this.pubKey);
            this.block = new SSKBlock(this.data, this.headers, this.key, false);
        }
        catch (SSKVerifyException e1) {
            Logger.error(this, "Invalid SSK from " + this.source, e1);
            msg2 = DMT.createFNPDataInsertRejected(this.uid, (short)3);
            try {
                this.source.sendSync(msg2, this);
            }
            catch (NotConnectedException e) {
                // empty catch block
            }
            return;
        }
        SSKBlock storedBlock = this.node.fetch(this.key, false);
        if (storedBlock != null && !storedBlock.equals(this.block)) {
            try {
                RequestHandler.sendSSK(storedBlock.getRawHeaders(), storedBlock.getRawData(), false, this.pubKey, this.source, this.uid, this);
            }
            catch (NotConnectedException e1) {
                if (logMINOR) {
                    Logger.minor(this, "Lost connection to source on " + this.uid);
                }
                return;
            }
            catch (WaitedTooLongException e1) {
                Logger.error(this, "Took too long to send ssk datareply to " + this.uid + " (because of throttling)");
                return;
            }
            this.block = storedBlock;
        }
        if (logMINOR) {
            Logger.minor(this, "Got block for " + this.key + " for " + this.uid);
        }
        if (this.htl == 0) {
            msg2 = DMT.createFNPInsertReply(this.uid);
            try {
                this.source.sendSync(msg2, this);
            }
            catch (NotConnectedException e) {
                // empty catch block
            }
            this.canCommit = true;
            this.finish(0);
            return;
        }
        if (this.htl > 0) {
            this.sender = this.node.makeInsertSender(this.block, this.htl, this.uid, this.source, false, true);
        }
        boolean receivedRejectedOverload = false;
        do {
            SSKInsertSender e = this.sender;
            synchronized (e) {
                try {
                    if (this.sender.getStatus() == -1) {
                        this.sender.wait(5000L);
                    }
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
            }
            if (!receivedRejectedOverload && this.sender.receivedRejectedOverload()) {
                receivedRejectedOverload = true;
                Message m = DMT.createFNPRejectedOverload(this.uid, false);
                try {
                    this.source.sendSync(m, this);
                }
                catch (NotConnectedException e3) {
                    if (logMINOR) {
                        Logger.minor(this, "Lost connection to source");
                    }
                    return;
                }
            }
            if (!this.sender.hasRecentlyCollided()) continue;
            this.data = this.sender.getData();
            this.headers = this.sender.getHeaders();
            this.collided = true;
            try {
                this.block = new SSKBlock(this.data, this.headers, this.key, true);
            }
            catch (SSKVerifyException e1) {
                throw new Error("Impossible: " + e1, e1);
            }
            try {
                RequestHandler.sendSSK(this.headers, this.data, false, this.pubKey, this.source, this.uid, this);
            }
            catch (NotConnectedException e1) {
                if (logMINOR) {
                    Logger.minor(this, "Lost connection to source on " + this.uid);
                }
                return;
            }
            catch (WaitedTooLongException e1) {
                Logger.error(this, "Took too long to send ssk datareply to " + this.uid + " because of bwlimiting");
                return;
            }
        } while ((status = this.sender.getStatus()) == -1);
        if (status == 4 || status == 5 || status == 3) {
            msg = DMT.createFNPRejectedOverload(this.uid, true);
            try {
                this.source.sendSync(msg, this);
            }
            catch (NotConnectedException e) {
                if (logMINOR) {
                    Logger.minor(this, "Lost connection to source");
                }
                return;
            }
            if (status == 4 || status == 5) {
                this.canCommit = true;
            }
            this.finish(status);
            return;
        }
        if (status == 1 || status == 6) {
            msg = DMT.createFNPRouteNotFound(this.uid, this.sender.getHTL());
            try {
                this.source.sendSync(msg, this);
            }
            catch (NotConnectedException e) {
                if (logMINOR) {
                    Logger.minor(this, "Lost connection to source");
                }
                return;
            }
            this.canCommit = true;
            this.finish(status);
            return;
        }
        if (status == 0) {
            msg = DMT.createFNPInsertReply(this.uid);
            try {
                this.source.sendSync(msg, this);
            }
            catch (NotConnectedException e) {
                if (logMINOR) {
                    Logger.minor(this, "Lost connection to source");
                }
                return;
            }
            this.canCommit = true;
            this.finish(status);
            return;
        }
        Logger.error(this, "Unknown status code: " + this.sender.getStatusString());
        msg = DMT.createFNPRejectedOverload(this.uid, true);
        try {
            this.source.sendSync(msg, this);
        }
        catch (NotConnectedException e) {
            // empty catch block
        }
        this.finish(status);
    }

    private void finish(int code) {
        if (logMINOR) {
            Logger.minor(this, "Finishing");
        }
        if (this.canCommit) {
            try {
                this.node.store(this.block, this.block.getKey().toNormalizedDouble(), this.collided);
            }
            catch (KeyCollisionException e) {
                Logger.normal(this, "Collision on " + this);
            }
        }
        if (code != 4 && code != 5 && code != 3 && code != 6) {
            int totalSent = this.getTotalSentBytes();
            int totalReceived = this.getTotalReceivedBytes();
            if (this.sender != null) {
                totalSent += this.sender.getTotalSentBytes();
                totalReceived += this.sender.getTotalReceivedBytes();
            }
            if (logMINOR) {
                Logger.minor(this, "Remote SSK insert cost " + totalSent + '/' + totalReceived + " bytes (" + code + ')');
            }
            this.node.nodeStats.remoteSskInsertBytesSentAverage.report(totalSent);
            this.node.nodeStats.remoteSskInsertBytesReceivedAverage.report(totalReceived);
            if (code == 0) {
                this.node.nodeStats.successfulSskInsertBytesSentAverage.report(totalSent);
                this.node.nodeStats.successfulSskInsertBytesReceivedAverage.report(totalReceived);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sentBytes(int x) {
        Object object = this.totalBytesSync;
        synchronized (object) {
            this.totalBytesSent += x;
        }
        this.node.nodeStats.insertSentBytes(true, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedBytes(int x) {
        Object object = this.totalBytesSync;
        synchronized (object) {
            this.totalBytesReceived += x;
        }
        this.node.nodeStats.insertReceivedBytes(true, x);
    }

    public int getTotalSentBytes() {
        return this.totalBytesSent;
    }

    public int getTotalReceivedBytes() {
        return this.totalBytesReceived;
    }

    public void sentPayload(int x) {
        this.node.sentPayload(x);
        this.node.nodeStats.insertSentBytes(true, -x);
    }

    public int getPriority() {
        return 7;
    }
}

