/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.node.RequestSender;
import freenet.node.UIDTag;
import freenet.support.Logger;
import freenet.support.TimeUtil;
import java.lang.ref.WeakReference;

public class RequestTag
extends UIDTag {
    final START start;
    final boolean isSSK;
    boolean servedFromDatastore;
    WeakReference<RequestSender> sender;
    int requestSenderFinishedCode;
    Throwable handlerThrew;
    boolean rejected;
    boolean abortedDownstreamTransfer;
    int abortedDownstreamReason;
    String abortedDownstreamDesc;
    boolean handlerDisconnected;

    public RequestTag(boolean isSSK, START start) {
        this.start = start;
        this.isSSK = isSSK;
    }

    public void setRequestSenderFinished(int status) {
        this.requestSenderFinishedCode = status;
    }

    public void setSender(RequestSender rs) {
        this.sender = new WeakReference<RequestSender>(rs);
    }

    public void handlerThrew(Throwable t) {
        this.handlerThrew = t;
    }

    public void setServedFromDatastore() {
        this.servedFromDatastore = true;
    }

    public void setRejected() {
        this.rejected = true;
    }

    public void logStillPresent(Long uid) {
        StringBuffer sb = new StringBuffer();
        sb.append("Still present after ").append(TimeUtil.formatTime(this.age()));
        sb.append(" : ").append(uid).append(" : start=").append((Object)this.start);
        sb.append(" ssk=").append(this.isSSK).append(" from store=").append(this.servedFromDatastore);
        if (this.sender == null) {
            sb.append(" sender hasn't been set!");
        } else {
            RequestSender s = (RequestSender)this.sender.get();
            if (s == null) {
                sb.append(" sender=null");
            } else {
                sb.append(" sender=").append(s);
                sb.append(" status=");
                sb.append(s.getStatusString());
            }
        }
        sb.append(" finishedCode=").append(this.requestSenderFinishedCode);
        sb.append(" rejected=").append(this.rejected);
        sb.append(" thrown=").append(this.handlerThrew);
        if (this.abortedDownstreamTransfer) {
            sb.append(" abortedDownstreamTransfer reason=");
            sb.append(this.abortedDownstreamReason);
            sb.append(" desc=");
            sb.append(this.abortedDownstreamDesc);
        }
        if (this.handlerDisconnected) {
            sb.append(" handlerDisconnected=true");
        }
        if (this.handlerThrew != null) {
            Logger.error(this, sb.toString(), this.handlerThrew);
        } else {
            Logger.error(this, sb.toString());
        }
    }

    public void onAbortDownstreamTransfers(int reason, String desc) {
        this.abortedDownstreamTransfer = true;
        this.abortedDownstreamReason = reason;
        this.abortedDownstreamDesc = desc;
    }

    public void handlerDisconnected() {
        this.handlerDisconnected = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum START {
        ASYNC_GET,
        LOCAL,
        REMOTE;

    }
}

