/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestScheduler;
import freenet.config.Config;
import freenet.config.SubConfig;
import freenet.crypt.RandomSource;
import freenet.keys.Key;
import freenet.node.BaseRequestThrottle;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.NodeStats;
import freenet.node.RequestStarter;
import freenet.node.ThrottleWindowManager;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.TimeUtil;
import freenet.support.math.BootstrappingDecayingRunningAverage;

public class RequestStarterGroup {
    private final ThrottleWindowManager throttleWindow;
    private final ThrottleWindowManager throttleWindowCHK;
    private final ThrottleWindowManager throttleWindowSSK;
    private final ThrottleWindowManager throttleWindowInsert;
    private final ThrottleWindowManager throttleWindowRequest;
    final MyRequestThrottle chkRequestThrottle;
    final RequestStarter chkRequestStarter;
    final MyRequestThrottle chkInsertThrottle;
    final RequestStarter chkInsertStarter;
    final MyRequestThrottle sskRequestThrottle;
    final RequestStarter sskRequestStarter;
    final MyRequestThrottle sskInsertThrottle;
    final RequestStarter sskInsertStarter;
    public final ClientRequestScheduler chkFetchScheduler;
    public final ClientRequestScheduler chkPutScheduler;
    public final ClientRequestScheduler sskFetchScheduler;
    public final ClientRequestScheduler sskPutScheduler;
    private final NodeStats stats;

    RequestStarterGroup(Node node, NodeClientCore core, int portNumber, RandomSource random, Config config, SimpleFieldSet fs, ClientContext ctx) {
        SubConfig schedulerConfig = new SubConfig("node.scheduler", config);
        this.stats = core.nodeStats;
        this.throttleWindow = new ThrottleWindowManager(2.0, fs == null ? null : fs.subset("ThrottleWindow"), node);
        this.throttleWindowCHK = new ThrottleWindowManager(2.0, fs == null ? null : fs.subset("ThrottleWindowCHK"), node);
        this.throttleWindowSSK = new ThrottleWindowManager(2.0, fs == null ? null : fs.subset("ThrottleWindowSSK"), node);
        this.throttleWindowInsert = new ThrottleWindowManager(2.0, fs == null ? null : fs.subset("ThrottleWindowInsert"), node);
        this.throttleWindowRequest = new ThrottleWindowManager(2.0, fs == null ? null : fs.subset("ThrottleWindowRequest"), node);
        this.chkRequestThrottle = new MyRequestThrottle(this.throttleWindow, 5000, "CHK Request", fs == null ? null : fs.subset("CHKRequestThrottle"), 32768);
        this.chkRequestStarter = new RequestStarter(core, this.chkRequestThrottle, "CHK Request starter (" + portNumber + ')', this.stats.requestOutputThrottle, this.stats.requestInputThrottle, this.stats.localChkFetchBytesSentAverage, this.stats.localChkFetchBytesReceivedAverage, false, false);
        this.chkFetchScheduler = new ClientRequestScheduler(false, false, random, this.chkRequestStarter, node, core, schedulerConfig, "CHKrequester", ctx);
        this.chkRequestStarter.setScheduler(this.chkFetchScheduler);
        this.chkRequestStarter.start();
        this.chkInsertThrottle = new MyRequestThrottle(this.throttleWindow, 20000, "CHK Insert", fs == null ? null : fs.subset("CHKInsertThrottle"), 32768);
        this.chkInsertStarter = new RequestStarter(core, this.chkInsertThrottle, "CHK Insert starter (" + portNumber + ')', this.stats.requestOutputThrottle, this.stats.requestInputThrottle, this.stats.localChkInsertBytesSentAverage, this.stats.localChkInsertBytesReceivedAverage, true, false);
        this.chkPutScheduler = new ClientRequestScheduler(true, false, random, this.chkInsertStarter, node, core, schedulerConfig, "CHKinserter", ctx);
        this.chkInsertStarter.setScheduler(this.chkPutScheduler);
        this.chkInsertStarter.start();
        this.sskRequestThrottle = new MyRequestThrottle(this.throttleWindow, 5000, "SSK Request", fs == null ? null : fs.subset("SSKRequestThrottle"), 1024);
        this.sskRequestStarter = new RequestStarter(core, this.sskRequestThrottle, "SSK Request starter (" + portNumber + ')', this.stats.requestOutputThrottle, this.stats.requestInputThrottle, this.stats.localSskFetchBytesSentAverage, this.stats.localSskFetchBytesReceivedAverage, false, true);
        this.sskFetchScheduler = new ClientRequestScheduler(false, true, random, this.sskRequestStarter, node, core, schedulerConfig, "SSKrequester", ctx);
        this.sskRequestStarter.setScheduler(this.sskFetchScheduler);
        this.sskRequestStarter.start();
        this.sskInsertThrottle = new MyRequestThrottle(this.throttleWindow, 20000, "SSK Insert", fs == null ? null : fs.subset("SSKInsertThrottle"), 1024);
        this.sskInsertStarter = new RequestStarter(core, this.sskInsertThrottle, "SSK Insert starter (" + portNumber + ')', this.stats.requestOutputThrottle, this.stats.requestInputThrottle, this.stats.localSskInsertBytesSentAverage, this.stats.localSskFetchBytesReceivedAverage, true, true);
        this.sskPutScheduler = new ClientRequestScheduler(true, true, random, this.sskInsertStarter, node, core, schedulerConfig, "SSKinserter", ctx);
        this.sskInsertStarter.setScheduler(this.sskPutScheduler);
        this.sskInsertStarter.start();
        schedulerConfig.finishedInitialization();
    }

    public BaseRequestThrottle getCHKRequestThrottle() {
        return this.chkRequestThrottle;
    }

    public BaseRequestThrottle getCHKInsertThrottle() {
        return this.chkInsertThrottle;
    }

    public BaseRequestThrottle getSSKRequestThrottle() {
        return this.sskRequestThrottle;
    }

    public BaseRequestThrottle getSSKInsertThrottle() {
        return this.sskInsertThrottle;
    }

    public void requestCompleted(boolean isSSK, boolean isInsert, Key key) {
        this.throttleWindow.requestCompleted();
        (isSSK ? this.throttleWindowSSK : this.throttleWindowCHK).requestCompleted();
        (isInsert ? this.throttleWindowInsert : this.throttleWindowRequest).requestCompleted();
        this.stats.reportOutgoingRequestLocation(key.toNormalizedDouble());
    }

    public void rejectedOverload(boolean isSSK, boolean isInsert) {
        this.throttleWindow.rejectedOverload();
        (isSSK ? this.throttleWindowSSK : this.throttleWindowCHK).rejectedOverload();
        (isInsert ? this.throttleWindowInsert : this.throttleWindowRequest).rejectedOverload();
    }

    SimpleFieldSet persistToFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(false);
        fs.put("ThrottleWindow", this.throttleWindow.exportFieldSet(false));
        fs.put("ThrottleWindowCHK", this.throttleWindowCHK.exportFieldSet(false));
        fs.put("ThrottleWindowSSK", this.throttleWindowCHK.exportFieldSet(false));
        fs.put("CHKRequestThrottle", this.chkRequestThrottle.exportFieldSet());
        fs.put("SSKRequestThrottle", this.sskRequestThrottle.exportFieldSet());
        fs.put("CHKInsertThrottle", this.chkInsertThrottle.exportFieldSet());
        fs.put("SSKInsertThrottle", this.sskInsertThrottle.exportFieldSet());
        return fs;
    }

    public double getWindow() {
        return this.throttleWindow.currentValue();
    }

    public double getRTT(boolean isSSK, boolean isInsert) {
        return this.getThrottle(isSSK, isInsert).getRTT();
    }

    public double getDelay(boolean isSSK, boolean isInsert) {
        return this.getThrottle(isSSK, isInsert).getDelay();
    }

    MyRequestThrottle getThrottle(boolean isSSK, boolean isInsert) {
        if (isSSK) {
            if (isInsert) {
                return this.sskInsertThrottle;
            }
            return this.sskRequestThrottle;
        }
        if (isInsert) {
            return this.chkInsertThrottle;
        }
        return this.chkRequestThrottle;
    }

    public String statsPageLine(boolean isSSK, boolean isInsert) {
        StringBuilder sb = new StringBuilder(100);
        sb.append(isSSK ? "SSK" : "CHK");
        sb.append(' ');
        sb.append(isInsert ? "Insert" : "Request");
        sb.append(" RTT=");
        MyRequestThrottle throttle = this.getThrottle(isSSK, isInsert);
        sb.append(TimeUtil.formatTime((long)throttle.getRTT(), 2, true));
        sb.append(" delay=");
        sb.append(TimeUtil.formatTime(throttle.getDelay(), 2, true));
        sb.append(" bw=");
        sb.append(throttle.getRate());
        sb.append("B/sec");
        return sb.toString();
    }

    public String diagnosticThrottlesLine(boolean mode) {
        StringBuilder sb = new StringBuilder();
        if (mode) {
            sb.append("Request window: ");
            sb.append(this.throttleWindowRequest.toString());
            sb.append(", Insert window: ");
            sb.append(this.throttleWindowInsert.toString());
        } else {
            sb.append("CHK window: ");
            sb.append(this.throttleWindowCHK.toString());
            sb.append(", SSK window: ");
            sb.append(this.throttleWindowSSK.toString());
        }
        return sb.toString();
    }

    public double getRealWindow() {
        return this.throttleWindow.realCurrentValue();
    }

    public long countTransientQueuedRequests() {
        return this.chkFetchScheduler.countTransientQueuedRequests() + this.sskFetchScheduler.countTransientQueuedRequests() + this.chkPutScheduler.countTransientQueuedRequests() + this.sskPutScheduler.countTransientQueuedRequests();
    }

    public class MyRequestThrottle
    implements BaseRequestThrottle {
        private final BootstrappingDecayingRunningAverage roundTripTime;
        private final int size;

        public MyRequestThrottle(ThrottleWindowManager throttleWindow, int rtt, String string, SimpleFieldSet fs, int size) {
            this.roundTripTime = new BootstrappingDecayingRunningAverage(rtt, 10.0, 300000.0, 10, fs == null ? null : fs.subset("RoundTripTime"));
            this.size = size;
        }

        public synchronized long getDelay() {
            double rtt = this.roundTripTime.currentValue();
            double winSizeForMinPacketDelay = rtt / 20.0;
            double _simulatedWindowSize = RequestStarterGroup.this.throttleWindow.currentValue();
            if (_simulatedWindowSize > winSizeForMinPacketDelay) {
                _simulatedWindowSize = winSizeForMinPacketDelay;
            }
            if (_simulatedWindowSize < 1.0) {
                _simulatedWindowSize = 1.0;
            }
            return Math.max(20L, Math.min((long)(rtt / _simulatedWindowSize), 300000L));
        }

        public synchronized void successfulCompletion(long rtt) {
            this.roundTripTime.report(Math.max(rtt, 10L));
            if (Logger.shouldLog(4, this)) {
                Logger.minor(this, "Reported successful completion: " + rtt + " on " + this + " avg " + this.roundTripTime.currentValue());
            }
        }

        public String toString() {
            return "rtt: " + this.roundTripTime.currentValue() + " _s=" + RequestStarterGroup.this.throttleWindow.currentValue();
        }

        public SimpleFieldSet exportFieldSet() {
            SimpleFieldSet fs = new SimpleFieldSet(false);
            fs.put("RoundTripTime", this.roundTripTime.exportFieldSet(false));
            return fs;
        }

        public double getRTT() {
            return this.roundTripTime.currentValue();
        }

        public long getRate() {
            return (long)(1000.0 / (double)this.getDelay() * (double)this.size);
        }
    }
}

