/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import com.db4o.ObjectContainer;
import freenet.client.async.ChosenBlock;
import freenet.client.async.ClientContext;
import freenet.client.async.TransientChosenBlock;
import freenet.keys.Key;
import freenet.node.BaseRequestThrottle;
import freenet.node.BaseSendableGet;
import freenet.node.NodeClientCore;
import freenet.node.NodeStats;
import freenet.node.OpennetManager;
import freenet.node.RequestScheduler;
import freenet.node.SendableInsert;
import freenet.node.SendableRequest;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.OOMHandler;
import freenet.support.RandomGrabArrayItem;
import freenet.support.RandomGrabArrayItemExclusionList;
import freenet.support.TokenBucket;
import freenet.support.math.RunningAverage;

public class RequestStarter
implements Runnable,
RandomGrabArrayItemExclusionList {
    private static volatile boolean logMINOR;
    public static final short MAXIMUM_PRIORITY_CLASS = 0;
    public static final short INTERACTIVE_PRIORITY_CLASS = 1;
    public static final short IMMEDIATE_SPLITFILE_PRIORITY_CLASS = 2;
    public static final short UPDATE_PRIORITY_CLASS = 3;
    public static final short BULK_SPLITFILE_PRIORITY_CLASS = 4;
    public static final short PREFETCH_PRIORITY_CLASS = 5;
    public static final short MINIMUM_PRIORITY_CLASS = 6;
    public static final short NUMBER_OF_PRIORITY_CLASSES = 7;
    private static final boolean LOCAL_REQUESTS_COMPETE_FAIRLY = true;
    final BaseRequestThrottle throttle;
    final TokenBucket inputBucket;
    final TokenBucket outputBucket;
    final RunningAverage averageInputBytesPerRequest;
    final RunningAverage averageOutputBytesPerRequest;
    RequestScheduler sched;
    final NodeClientCore core;
    final NodeStats stats;
    private long sentRequestTime;
    private final boolean isInsert;
    private final boolean isSSK;
    final String name;

    public static boolean isValidPriorityClass(int prio) {
        return prio >= 0 && prio <= 6;
    }

    public RequestStarter(NodeClientCore node, BaseRequestThrottle throttle, String name, TokenBucket outputBucket, TokenBucket inputBucket, RunningAverage averageOutputBytesPerRequest, RunningAverage averageInputBytesPerRequest, boolean isInsert, boolean isSSK) {
        this.core = node;
        this.stats = this.core.nodeStats;
        this.throttle = throttle;
        this.name = name;
        this.outputBucket = outputBucket;
        this.inputBucket = inputBucket;
        this.averageOutputBytesPerRequest = averageOutputBytesPerRequest;
        this.averageInputBytesPerRequest = averageInputBytesPerRequest;
        this.isInsert = isInsert;
        this.isSSK = isSSK;
    }

    void setScheduler(RequestScheduler sched) {
        this.sched = sched;
    }

    void start() {
        this.sched.start(this.core);
        this.core.getExecutor().execute(this, this.name);
        this.sched.queueFillRequestStarterQueue();
    }

    public String toString() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void realRun() {
        ChosenBlock req = null;
        long cycleTime = this.sentRequestTime = System.currentTimeMillis();
        while (true) {
            OpennetManager om;
            if (this.core.node.peers.countConnectedPeers() < 3 && (om = this.core.node.getOpennet()) != null && System.currentTimeMillis() - om.getCreationTime() < 300000L) {
                try {
                    RequestStarter requestStarter = this;
                    synchronized (requestStarter) {
                        this.wait(1000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (req == null) {
                req = this.sched.grabRequest();
            }
            if (req != null) {
                long now;
                if (logMINOR) {
                    Logger.minor(this, "Running " + req + " priority " + req.getPriority());
                }
                long delay = this.throttle.getDelay();
                if (logMINOR) {
                    Logger.minor(this, "Delay=" + delay + " from " + this.throttle);
                }
                long sleepUntil = cycleTime + delay;
                do {
                    if ((now = System.currentTimeMillis()) >= sleepUntil) continue;
                    try {
                        Thread.sleep(sleepUntil - now);
                        if (!logMINOR) continue;
                        Logger.minor(this, "Slept: " + (sleepUntil - now) + "ms");
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                } while (now < sleepUntil);
                String reason = this.stats.shouldRejectRequest(true, this.isInsert, this.isSSK, true, false, null);
                if (reason != null) {
                    if (logMINOR) {
                        Logger.minor(this, "Not sending local request: " + reason);
                    }
                    cycleTime = System.currentTimeMillis();
                    continue;
                }
            } else {
                if (logMINOR) {
                    Logger.minor(this, "Waiting...");
                }
                RequestStarter requestStarter = this;
                synchronized (requestStarter) {
                    req = this.sched.grabRequest();
                    if (req == null) {
                        try {
                            this.wait(100000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
            }
            if (req == null) continue;
            if (!(this.startRequest(req, logMINOR) || !req.isPersistent() && req.isCancelled())) {
                Logger.normal(this, "No requests to start on " + req);
            }
            req = null;
            cycleTime = this.sentRequestTime = System.currentTimeMillis();
        }
    }

    private boolean startRequest(ChosenBlock req, boolean logMINOR) {
        if (!req.isPersistent() && req.isCancelled()) {
            req.onDumped();
            return false;
        }
        if (req.key != null) {
            if (!this.sched.addToFetching(req.key)) {
                req.onDumped();
                return false;
            }
        } else if (!req.isPersistent() && ((TransientChosenBlock)req).request instanceof SendableInsert && !this.sched.addTransientInsertFetching((SendableInsert)((TransientChosenBlock)req).request, req.token)) {
            req.onDumped();
            return false;
        }
        if (logMINOR) {
            Logger.minor(this, "Running request " + req + " priority " + req.getPriority());
        }
        this.core.getExecutor().execute(new SenderThread(req, req.key), "RequestStarter$SenderThread for " + req);
        return true;
    }

    public void run() {
        Logger.OSThread.logPID(this);
        while (true) {
            try {
                while (true) {
                    this.realRun();
                }
            }
            catch (OutOfMemoryError e) {
                OOMHandler.handleOOM(e);
                continue;
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t, t);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp() {
        RequestStarter requestStarter = this;
        synchronized (requestStarter) {
            this.notifyAll();
        }
    }

    public boolean exclude(RandomGrabArrayItem item, ObjectContainer container, ClientContext context) {
        if (this.sched.isRunningOrQueuedPersistentRequest((SendableRequest)item)) {
            Logger.normal(this, "Excluding already-running request: " + item, new Exception("debug"));
            return true;
        }
        if (this.isInsert) {
            return false;
        }
        if (!(item instanceof BaseSendableGet)) {
            Logger.error(this, "On a request scheduler, exclude() called with " + item, new Exception("error"));
            return false;
        }
        BaseSendableGet get = (BaseSendableGet)item;
        if (get.hasValidKeys(this.sched.fetchingKeys(), container, context)) {
            return false;
        }
        Logger.normal(this, "Excluding (no valid keys): " + get);
        return true;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }

    private class SenderThread
    implements Runnable {
        private final ChosenBlock req;
        private final Key key;

        public SenderThread(ChosenBlock req, Key key) {
            this.req = req;
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block11: {
                try {
                    Logger.OSThread.logPID(this);
                    if (this.key != null) {
                        RequestStarter.this.stats.reportOutgoingLocalRequestLocation(this.key.toNormalizedDouble());
                    }
                    if (!this.req.send(RequestStarter.this.core, RequestStarter.this.sched)) {
                        if (this.req.isPersistent() || !this.req.isCancelled()) {
                            Logger.error(this, "run() not able to send a request on " + this.req);
                        } else {
                            Logger.normal(this, "run() not able to send a request on " + this.req + " - request was cancelled");
                        }
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Finished " + this.req);
                    }
                    Object var2_1 = null;
                    if (this.key == null) break block11;
                    RequestStarter.this.sched.removeFetchingKey(this.key);
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    if (this.key != null) {
                        RequestStarter.this.sched.removeFetchingKey(this.key);
                    } else if (!this.req.isPersistent() && ((TransientChosenBlock)this.req).request instanceof SendableInsert) {
                        RequestStarter.this.sched.removeTransientInsertFetching((SendableInsert)((TransientChosenBlock)this.req).request, this.req.token);
                    }
                    throw throwable;
                }
            }
            if (!this.req.isPersistent() && ((TransientChosenBlock)this.req).request instanceof SendableInsert) {
                RequestStarter.this.sched.removeTransientInsertFetching((SendableInsert)((TransientChosenBlock)this.req).request, this.req.token);
            }
        }
    }
}

