/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.crypt.CryptFormatException;
import freenet.crypt.DSAPublicKey;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.NullAsyncMessageFilterCallback;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.io.comm.RetrievalException;
import freenet.io.xfer.BlockReceiver;
import freenet.io.xfer.PartiallyReceivedBlock;
import freenet.keys.CHKBlock;
import freenet.keys.Key;
import freenet.keys.KeyVerifyException;
import freenet.keys.NodeCHK;
import freenet.keys.NodeSSK;
import freenet.keys.SSKBlock;
import freenet.keys.SSKVerifyException;
import freenet.node.FSParseException;
import freenet.node.FailureTable;
import freenet.node.Node;
import freenet.node.OpennetManager;
import freenet.node.PeerNode;
import freenet.node.PrioRunnable;
import freenet.store.KeyCollisionException;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.ShortBuffer;
import freenet.support.SimpleFieldSet;
import freenet.support.TimeUtil;
import freenet.support.math.MedianMeanRunningAverage;
import java.util.ArrayList;
import java.util.HashSet;

public final class RequestSender
implements PrioRunnable,
ByteCounter {
    static final int ACCEPTED_TIMEOUT = 10000;
    static final int GET_OFFER_TIMEOUT = 10000;
    static final int FETCH_TIMEOUT = 120000;
    static final int OPENNET_TIMEOUT = 120000;
    static final int RANDOM_REINSERT_INTERVAL = 200;
    final Key key;
    final double target;
    private short htl;
    final long uid;
    final Node node;
    final PeerNode source;
    private PartiallyReceivedBlock prb;
    private DSAPublicKey pubKey;
    private byte[] headers;
    private byte[] sskData;
    private SSKBlock block;
    private boolean hasForwarded;
    private PeerNode transferringFrom;
    private boolean turtleMode;
    private boolean sentBackoffTurtle;
    private boolean tryTurtle;
    private boolean tryOffersOnly;
    private ArrayList<Listener> listeners = new ArrayList();
    private int status = -1;
    static final int NOT_FINISHED = -1;
    static final int SUCCESS = 0;
    static final int ROUTE_NOT_FOUND = 1;
    static final int DATA_NOT_FOUND = 3;
    static final int TRANSFER_FAILED = 4;
    static final int VERIFY_FAILURE = 5;
    static final int TIMED_OUT = 6;
    static final int GENERATED_REJECTED_OVERLOAD = 7;
    static final int INTERNAL_ERROR = 8;
    static final int RECENTLY_FAILED = 9;
    static final int GET_OFFER_VERIFY_FAILURE = 10;
    static final int GET_OFFER_TRANSFER_FAILED = 11;
    private PeerNode successFrom;
    private PeerNode lastNode;
    private final long startTime;
    private static volatile boolean logMINOR;
    private volatile boolean hasForwardedRejectedOverload;
    static final short WAIT_REJECTED_OVERLOAD = 1;
    static final short WAIT_TRANSFERRING_DATA = 2;
    static final short WAIT_FINISHED = 4;
    static final short WAIT_ALL = 7;
    private static MedianMeanRunningAverage avgTimeTaken;
    private static MedianMeanRunningAverage avgTimeTakenTurtle;
    private static MedianMeanRunningAverage avgTimeTakenTransfer;
    private long transferTime;
    private boolean opennetFinished;
    private byte[] opennetNoderef;
    private volatile Object totalBytesSync = new Object();
    private int totalBytesSent;
    private int totalBytesReceived;
    private int recentlyFailedTimeLeft;
    private boolean sentReceivedRejectOverload;
    private boolean sentCHKTransferBegins;
    private boolean sentRequestSenderFinished;
    private boolean sentAbortDownstreamTransfers;
    private int abortDownstreamTransfersReason;
    private String abortDownstreamTransfersDesc;

    static String getStatusString(int status) {
        switch (status) {
            case -1: {
                return "NOT FINISHED";
            }
            case 0: {
                return "SUCCESS";
            }
            case 1: {
                return "ROUTE NOT FOUND";
            }
            case 3: {
                return "DATA NOT FOUND";
            }
            case 4: {
                return "TRANSFER FAILED";
            }
            case 11: {
                return "GET OFFER TRANSFER FAILED";
            }
            case 5: {
                return "VERIFY FAILURE";
            }
            case 10: {
                return "GET OFFER VERIFY FAILURE";
            }
            case 6: {
                return "TIMED OUT";
            }
            case 7: {
                return "GENERATED REJECTED OVERLOAD";
            }
            case 8: {
                return "INTERNAL ERROR";
            }
            case 9: {
                return "RECENTLY FAILED";
            }
        }
        return "UNKNOWN STATUS CODE: " + status;
    }

    String getStatusString() {
        return RequestSender.getStatusString(this.getStatus());
    }

    public String toString() {
        return super.toString() + " for " + this.uid;
    }

    public RequestSender(Key key, DSAPublicKey pubKey, short htl, long uid, Node n, PeerNode source, boolean offersOnly) {
        if (key.getRoutingKey() == null) {
            throw new NullPointerException();
        }
        this.startTime = System.currentTimeMillis();
        this.key = key;
        this.pubKey = pubKey;
        this.htl = htl;
        this.uid = uid;
        this.node = n;
        this.source = source;
        this.tryOffersOnly = offersOnly;
        this.target = key.toNormalizedDouble();
        this.node.addRequestSender(key, htl, this);
    }

    public void start() {
        this.node.executor.execute(this, "RequestSender for UID " + this.uid + " on " + this.node.getDarknetPortNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        short origHTL;
        block7: {
            origHTL = this.htl;
            try {
                try {
                    this.realRun();
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught " + t, t);
                    this.finish(8, null, false);
                    Object var4_3 = null;
                    if (logMINOR) {
                        Logger.minor(this, "Leaving RequestSender.run() for " + this.uid);
                    }
                    this.node.removeRequestSender(this.key, origHTL, this);
                    return;
                }
                Object var4_2 = null;
                if (!logMINOR) break block7;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (logMINOR) {
                    Logger.minor(this, "Leaving RequestSender.run() for " + this.uid);
                }
                this.node.removeRequestSender(this.key, origHTL, this);
                throw throwable;
            }
            Logger.minor(this, "Leaving RequestSender.run() for " + this.uid);
        }
        this.node.removeRequestSender(this.key, origHTL, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realRun() {
        Object mfGetInvalid;
        FailureTable.OfferList offers;
        Logger.OSThread.logPID(this);
        if (this.key instanceof NodeSSK && this.pubKey == null) {
            this.pubKey = ((NodeSSK)this.key).getPubKey();
        }
        if ((offers = this.node.failureTable.getOffers(this.key)) != null) {
            while (true) {
                Message dataMessage;
                Message reply;
                FailureTable.BlockOffer offer;
                if ((offer = offers.getFirstOffer()) == null) {
                    if (!logMINOR) break;
                    Logger.minor(this, "No more offers");
                    break;
                }
                PeerNode pn = offer.getPeerNode();
                if (pn == null) {
                    offers.deleteLastOffer();
                    if (!logMINOR) continue;
                    Logger.minor(this, "Null offer");
                    continue;
                }
                if (pn.getBootID() != offer.bootID) {
                    offers.deleteLastOffer();
                    if (!logMINOR) continue;
                    Logger.minor(this, "Restarted node");
                    continue;
                }
                Message msg = DMT.createFNPGetOfferedKey(this.key, offer.authenticator, this.pubKey == null, this.uid);
                try {
                    pn.sendAsync(msg, null, this);
                }
                catch (NotConnectedException e2) {
                    if (logMINOR) {
                        Logger.minor(this, "Disconnected: " + pn + " getting offer for " + this.key);
                    }
                    offers.deleteLastOffer();
                    continue;
                }
                MessageFilter mfRO = MessageFilter.create().setSource(pn).setField("uid", this.uid).setTimeout(10000).setType(DMT.FNPRejectedOverload);
                mfGetInvalid = MessageFilter.create().setSource(pn).setField("uid", this.uid).setTimeout(10000).setType(DMT.FNPGetOfferedKeyInvalid);
                if (this.key instanceof NodeCHK) {
                    Object var13_28;
                    MessageFilter mfDF = MessageFilter.create().setSource(pn).setField("uid", this.uid).setTimeout(10000).setType(DMT.FNPCHKDataFound);
                    try {
                        reply = this.node.usm.waitFor(mfDF.or(mfRO.or((MessageFilter)mfGetInvalid)), this);
                    }
                    catch (DisconnectedException e2) {
                        if (logMINOR) {
                            Logger.minor(this, "Disconnected: " + pn + " getting offer for " + this.key);
                        }
                        offers.deleteLastOffer();
                        continue;
                    }
                    if (reply == null) {
                        offers.deleteLastOffer();
                        continue;
                    }
                    if (reply.getSpec() == DMT.FNPRejectedOverload) {
                        if (logMINOR) {
                            Logger.minor(this, "Node " + pn + " rejected FNPGetOfferedKey for " + this.key + " (expired=" + offer.isExpired());
                        }
                        offers.keepLastOffer();
                        continue;
                    }
                    if (reply.getSpec() == DMT.FNPGetOfferedKeyInvalid) {
                        if (logMINOR) {
                            Logger.minor(this, "Node " + pn + " rejected FNPGetOfferedKey as invalid with reason " + reply.getShort("reason"));
                        }
                        offers.deleteLastOffer();
                        continue;
                    }
                    if (reply.getSpec() != DMT.FNPCHKDataFound) continue;
                    this.headers = ((ShortBuffer)reply.getObject("blockHeaders")).getData();
                    this.node.addTransferringSender((NodeCHK)this.key, this);
                    try {
                        this.prb = new PartiallyReceivedBlock(32, 1024);
                        RequestSender e2 = this;
                        synchronized (e2) {
                            this.notifyAll();
                        }
                        this.fireCHKTransferBegins();
                        BlockReceiver br = new BlockReceiver(this.node.usm, pn, this.uid, this.prb, this, this.node.getTicker(), true);
                        try {
                            if (logMINOR) {
                                Logger.minor(this, "Receiving data");
                            }
                            byte[] data = br.receive();
                            pn.transferSuccess();
                            if (logMINOR) {
                                Logger.minor(this, "Received data");
                            }
                            try {
                                this.verifyAndCommit(data);
                            }
                            catch (KeyVerifyException e1) {
                                Logger.normal(this, "Got data but verify failed: " + e1, e1);
                                this.finish(10, pn, true);
                                offers.deleteLastOffer();
                                var13_28 = null;
                                this.node.removeTransferringSender((NodeCHK)this.key, this);
                                return;
                            }
                        }
                        catch (RetrievalException e) {
                            if (e.getReason() == 7) {
                                Logger.normal(this, "Transfer failed (disconnect): " + e, e);
                            } else {
                                Logger.normal(this, "Transfer for offer failed (" + e.getReason() + "/" + RetrievalException.getErrString(e.getReason()) + "): " + e + " from " + pn, e);
                            }
                            this.finish(11, pn, true);
                            pn.transferFailed("RequestSenderGetOfferedTransferFailed");
                            offers.deleteLastOffer();
                            this.node.nodeStats.failedBlockReceive(false, false, false);
                            var13_28 = null;
                            this.node.removeTransferringSender((NodeCHK)this.key, this);
                            return;
                        }
                        this.finish(0, pn, true);
                        this.node.nodeStats.successfulBlockReceive();
                        var13_28 = null;
                        this.node.removeTransferringSender((NodeCHK)this.key, this);
                        return;
                    }
                    catch (Throwable throwable) {
                        var13_28 = null;
                        this.node.removeTransferringSender((NodeCHK)this.key, this);
                        throw throwable;
                    }
                }
                MessageFilter mfAltDF = MessageFilter.create().setSource(pn).setField("uid", this.uid).setTimeout(10000).setType(DMT.FNPSSKDataFoundHeaders);
                try {
                    reply = this.node.usm.waitFor(mfRO.or(((MessageFilter)mfGetInvalid).or(mfAltDF)), this);
                }
                catch (DisconnectedException e) {
                    if (logMINOR) {
                        Logger.minor(this, "Disconnected: " + pn + " getting offer for " + this.key);
                    }
                    offers.deleteLastOffer();
                    continue;
                }
                if (reply == null) {
                    offers.deleteLastOffer();
                    continue;
                }
                if (reply.getSpec() == DMT.FNPRejectedOverload) {
                    if (logMINOR) {
                        Logger.minor(this, "Node " + pn + " rejected FNPGetOfferedKey for " + this.key + " (expired=" + offer.isExpired());
                    }
                    offers.keepLastOffer();
                    continue;
                }
                if (reply.getSpec() == DMT.FNPGetOfferedKeyInvalid) {
                    if (logMINOR) {
                        Logger.minor(this, "Node " + pn + " rejected FNPGetOfferedKey as invalid with reason " + reply.getShort("reason"));
                    }
                    offers.deleteLastOffer();
                    continue;
                }
                if (reply.getSpec() != DMT.FNPSSKDataFoundHeaders) continue;
                this.headers = ((ShortBuffer)reply.getObject("blockHeaders")).getData();
                MessageFilter mfData = MessageFilter.create().setSource(pn).setField("uid", this.uid).setTimeout(10000).setType(DMT.FNPSSKDataFoundData);
                try {
                    dataMessage = this.node.usm.waitFor(mfData, this);
                }
                catch (DisconnectedException e) {
                    if (logMINOR) {
                        Logger.minor(this, "Disconnected: " + pn + " getting data for offer for " + this.key);
                    }
                    offers.deleteLastOffer();
                    continue;
                }
                if (dataMessage == null) {
                    Logger.error(this, "Got headers but not data from " + pn + " for offer for " + this.key);
                    offers.deleteLastOffer();
                    continue;
                }
                this.sskData = ((ShortBuffer)dataMessage.getObject("data")).getData();
                if (this.pubKey == null) {
                    Message pk;
                    MessageFilter mfPK = MessageFilter.create().setSource(pn).setField("uid", this.uid).setTimeout(10000).setType(DMT.FNPSSKPubKey);
                    try {
                        pk = this.node.usm.waitFor(mfPK, this);
                    }
                    catch (DisconnectedException e) {
                        if (logMINOR) {
                            Logger.minor(this, "Disconnected: " + pn + " getting pubkey for offer for " + this.key);
                        }
                        offers.deleteLastOffer();
                        continue;
                    }
                    if (pk == null) {
                        Logger.error(this, "Got data but not pubkey from " + pn + " for offer for " + this.key);
                        offers.deleteLastOffer();
                        continue;
                    }
                    try {
                        this.pubKey = DSAPublicKey.create(((ShortBuffer)pk.getObject("pubkeyAsBytes")).getData());
                    }
                    catch (CryptFormatException e) {
                        Logger.error(this, "Bogus pubkey from " + pn + " for offer for " + this.key + " : " + e, e);
                        offers.deleteLastOffer();
                        continue;
                    }
                    try {
                        ((NodeSSK)this.key).setPubKey(this.pubKey);
                    }
                    catch (SSKVerifyException e) {
                        Logger.error(this, "Bogus SSK data from " + pn + " for offer for " + this.key + " : " + e, e);
                        offers.deleteLastOffer();
                        continue;
                    }
                }
                if (this.finishSSKFromGetOffer(pn)) {
                    if (logMINOR) {
                        Logger.minor(this, "Successfully fetched SSK from offer from " + pn + " for " + this.key);
                    }
                    return;
                }
                offers.deleteLastOffer();
            }
        }
        if (this.tryOffersOnly) {
            if (logMINOR) {
                Logger.minor(this, "Tried all offers, not doing a regular request for key");
            }
            this.finish(3, null, true);
            return;
        }
        int routeAttempts = 0;
        int rejectOverloads = 0;
        HashSet<PeerNode> nodesRoutedTo = new HashSet<PeerNode>();
        PeerNode next = null;
        block66: while (true) {
            this.htl = this.node.decrementHTL(this.hasForwarded ? next : this.source, this.htl);
            if (logMINOR) {
                Logger.minor(this, "htl=" + this.htl);
            }
            if (this.htl == 0) {
                this.finish(3, null, false);
                this.node.failureTable.onFinalFailure(this.key, null, this.htl, 600000, this.source);
                return;
            }
            ++routeAttempts;
            next = this.node.peers.closerPeer(this.source, nodesRoutedTo, this.target, true, this.node.isAdvancedModeEnabled(), -1, null, this.key);
            if (next == null) {
                if (logMINOR && rejectOverloads > 0) {
                    Logger.minor(this, "no more peers, but overloads (" + rejectOverloads + "/" + routeAttempts + " overloaded)");
                }
                this.finish(1, null, false);
                this.node.failureTable.onFinalFailure(this.key, null, this.htl, -1, this.source);
                return;
            }
            mfGetInvalid = this;
            synchronized (mfGetInvalid) {
                this.lastNode = next;
            }
            if (logMINOR) {
                Logger.minor(this, "Routing request to " + next);
            }
            nodesRoutedTo.add(next);
            Message req = this.createDataRequest();
            long timeSentRequest = System.currentTimeMillis();
            try {
                next.sendSync(req, this);
            }
            catch (NotConnectedException e) {
                Logger.minor(this, "Not connected");
                continue;
            }
            RequestSender e = this;
            synchronized (e) {
                this.hasForwarded = true;
            }
            Message msg = null;
            while (true) {
                block149: {
                    MessageFilter mfAccepted = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(10000).setType(DMT.FNPAccepted);
                    MessageFilter mfRejectedLoop = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(10000).setType(DMT.FNPRejectedLoop);
                    MessageFilter mfRejectedOverload = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(10000).setType(DMT.FNPRejectedOverload);
                    MessageFilter mf = mfAccepted.or(mfRejectedLoop.or(mfRejectedOverload));
                    try {
                        msg = this.node.usm.waitFor(mf, this);
                        if (!logMINOR) break block149;
                        Logger.minor(this, "first part got " + msg);
                    }
                    catch (DisconnectedException e2) {
                        Logger.normal(this, "Disconnected from " + next + " while waiting for Accepted on " + this.uid);
                        break;
                    }
                }
                if (msg == null) {
                    if (logMINOR) {
                        Logger.minor(this, "Timeout waiting for Accepted");
                    }
                    next.localRejectedOverload("AcceptedTimeout");
                    this.forwardRejectedOverload();
                    this.node.failureTable.onFailed(this.key, next, this.htl, (int)(System.currentTimeMillis() - timeSentRequest));
                    break;
                }
                if (msg.getSpec() == DMT.FNPRejectedLoop) {
                    if (logMINOR) {
                        Logger.minor(this, "Rejected loop");
                    }
                    next.successNotOverload();
                    this.node.failureTable.onFailed(this.key, next, this.htl, (int)(System.currentTimeMillis() - timeSentRequest));
                    break;
                }
                if (msg.getSpec() == DMT.FNPRejectedOverload) {
                    if (logMINOR) {
                        Logger.minor(this, "Rejected: overload");
                    }
                    this.forwardRejectedOverload();
                    if (!msg.getBoolean("isLocal")) continue;
                    if (logMINOR) {
                        Logger.minor(this, "Is local");
                    }
                    next.localRejectedOverload("ForwardRejectedOverload");
                    this.node.failureTable.onFailed(this.key, next, this.htl, (int)(System.currentTimeMillis() - timeSentRequest));
                    if (!logMINOR) break;
                    Logger.minor(this, "Local RejectedOverload, moving on to next peer");
                    break;
                }
                if (msg.getSpec() == DMT.FNPAccepted) break;
                Logger.error(this, "Unrecognized message: " + msg);
            }
            if (msg == null || msg.getSpec() != DMT.FNPAccepted) continue;
            if (logMINOR) {
                Logger.minor(this, "Got Accepted");
            }
            int gotMessages = 0;
            String lastMessage = null;
            while (true) {
                MessageFilter mfDNF = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(120000).setType(DMT.FNPDataNotFound);
                MessageFilter mfRF = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(120000).setType(DMT.FNPRecentlyFailed);
                MessageFilter mfRouteNotFound = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(120000).setType(DMT.FNPRouteNotFound);
                MessageFilter mfRejectedOverload = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(120000).setType(DMT.FNPRejectedOverload);
                MessageFilter mfPubKey = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(120000).setType(DMT.FNPSSKPubKey);
                MessageFilter mfRealDFCHK = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(120000).setType(DMT.FNPCHKDataFound);
                MessageFilter mfAltDFSSKHeaders = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(120000).setType(DMT.FNPSSKDataFoundHeaders);
                MessageFilter mfAltDFSSKData = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(120000).setType(DMT.FNPSSKDataFoundData);
                MessageFilter mf = mfDNF.or(mfRF.or(mfRouteNotFound.or(mfRejectedOverload)));
                mf = this.key instanceof NodeCHK ? mfRealDFCHK.or(mf) : mfPubKey.or(mfAltDFSSKHeaders.or(mfAltDFSSKData.or(mf)));
                try {
                    msg = this.node.usm.waitFor(mf, this);
                }
                catch (DisconnectedException e3) {
                    Logger.normal(this, "Disconnected from " + next + " while waiting for data on " + this.uid);
                    continue block66;
                }
                if (logMINOR) {
                    Logger.minor(this, "second part got " + msg);
                }
                if (msg == null) {
                    Logger.normal(this, "request fatal-timeout (null) after accept (" + gotMessages + " messages; last=" + lastMessage + ")");
                    next.localRejectedOverload("FatalTimeout");
                    this.forwardRejectedOverload();
                    this.finish(6, next, false);
                    this.node.failureTable.onFinalFailure(this.key, next, this.htl, 600000, this.source);
                    return;
                }
                ++gotMessages;
                lastMessage = msg.getSpec().getName();
                if (msg.getSpec() == DMT.FNPDataNotFound) {
                    next.successNotOverload();
                    this.finish(3, next, false);
                    this.node.failureTable.onFinalFailure(this.key, next, this.htl, 600000, this.source);
                    return;
                }
                if (msg.getSpec() == DMT.FNPRecentlyFailed) {
                    int timeLeft;
                    next.successNotOverload();
                    int origTimeLeft = timeLeft = msg.getInt("timeLeft");
                    if (timeLeft <= 0) {
                        Logger.error(this, "Impossible: timeLeft=" + timeLeft);
                        origTimeLeft = 0;
                        timeLeft = 1000;
                    }
                    long timeSinceSent = Math.max(0L, System.currentTimeMillis() - timeSentRequest);
                    timeLeft = (int)((long)timeLeft - timeSinceSent);
                    this.recentlyFailedTimeLeft = timeLeft -= origTimeLeft / 100;
                    this.finish(9, next, false);
                    this.node.failureTable.onFinalFailure(this.key, next, this.htl, timeLeft, this.source);
                    return;
                }
                if (msg.getSpec() == DMT.FNPRouteNotFound) {
                    short newHtl = msg.getShort("hopsToLive");
                    if (newHtl < this.htl) {
                        this.htl = newHtl;
                    }
                    next.successNotOverload();
                    this.node.failureTable.onFailed(this.key, next, this.htl, (int)(System.currentTimeMillis() - timeSentRequest));
                    continue block66;
                }
                if (msg.getSpec() == DMT.FNPRejectedOverload) {
                    this.forwardRejectedOverload();
                    ++rejectOverloads;
                    if (!msg.getBoolean("isLocal")) continue;
                    this.node.failureTable.onFailed(this.key, next, this.htl, (int)(System.currentTimeMillis() - timeSentRequest));
                    next.localRejectedOverload("ForwardRejectedOverload2");
                    Logger.normal(this, "Local RejectedOverload after Accepted, moving on to next peer");
                    continue block66;
                }
                if (msg.getSpec() == DMT.FNPCHKDataFound) {
                    if (!(this.key instanceof NodeCHK)) {
                        Logger.error(this, "Got " + msg + " but expected a different key type from " + next);
                        continue block66;
                    }
                    this.headers = ((ShortBuffer)msg.getObject("blockHeaders")).getData();
                    this.node.addTransferringSender((NodeCHK)this.key, this);
                    try {
                        this.prb = new PartiallyReceivedBlock(32, 1024);
                        RequestSender newHtl = this;
                        synchronized (newHtl) {
                            this.notifyAll();
                        }
                        this.fireCHKTransferBegins();
                        long tStart = System.currentTimeMillis();
                        BlockReceiver br = new BlockReceiver(this.node.usm, next, this.uid, this.prb, this, this.node.getTicker(), true);
                        try {
                            boolean turtleBackedOff;
                            boolean turtle;
                            RequestSender requestSender;
                            byte[] data;
                            if (logMINOR) {
                                Logger.minor(this, "Receiving data");
                            }
                            final PeerNode from = next;
                            RequestSender requestSender2 = this;
                            synchronized (requestSender2) {
                                this.transferringFrom = next;
                            }
                            this.node.getTicker().queueTimedJob(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() {
                                    RequestSender requestSender = RequestSender.this;
                                    synchronized (requestSender) {
                                        if (RequestSender.this.transferringFrom != from) {
                                            return;
                                        }
                                    }
                                    RequestSender.this.makeTurtle();
                                }
                            }, 60000L);
                            try {
                                data = br.receive();
                                Object var28_63 = null;
                                requestSender = this;
                            }
                            catch (Throwable throwable) {
                                Object var28_64 = null;
                                RequestSender requestSender3 = this;
                                synchronized (requestSender3) {
                                    this.transferringFrom = null;
                                }
                                throw throwable;
                            }
                            synchronized (requestSender) {
                                this.transferringFrom = null;
                            }
                            long tEnd = System.currentTimeMillis();
                            this.transferTime = tEnd - tStart;
                            RequestSender requestSender4 = this;
                            synchronized (requestSender4) {
                                turtle = this.turtleMode;
                                turtleBackedOff = this.sentBackoffTurtle;
                                this.sentBackoffTurtle = true;
                            }
                            if (!turtle) {
                                next.transferSuccess();
                            } else {
                                Logger.normal(this, "TURTLE SUCCEEDED: " + this.key + " for " + this + " in " + TimeUtil.formatTime(this.transferTime, 2, true));
                                if (!turtleBackedOff) {
                                    next.transferFailed("TurtledTransfer");
                                }
                                this.node.nodeStats.turtleSucceeded();
                            }
                            next.successNotOverload();
                            if (turtle) {
                                next.unregisterTurtleTransfer(this);
                                this.node.unregisterTurtleTransfer(this);
                            }
                            this.node.nodeStats.successfulBlockReceive();
                            if (logMINOR) {
                                Logger.minor(this, "Received data");
                            }
                            try {
                                this.verifyAndCommit(data);
                            }
                            catch (KeyVerifyException e1) {
                                Logger.normal(this, "Got data but verify failed: " + e1, e1);
                                this.finish(5, next, false);
                                this.node.failureTable.onFinalFailure(this.key, next, this.htl, 600000, this.source);
                                Object var34_76 = null;
                                this.node.removeTransferringSender((NodeCHK)this.key, this);
                                return;
                            }
                        }
                        catch (RetrievalException e4) {
                            boolean timeout;
                            boolean turtle;
                            RequestSender tEnd = this;
                            synchronized (tEnd) {
                                turtle = this.turtleMode;
                            }
                            if (turtle) {
                                if (e4.getReason() != 13) {
                                    Logger.normal(this, "TURTLE FAILED: " + this.key + " for " + this + " : " + e4);
                                    this.node.nodeStats.turtleFailed();
                                } else if (logMINOR) {
                                    Logger.minor(this, "Upstream turtled for " + this + " from " + next);
                                }
                                next.unregisterTurtleTransfer(this);
                                this.node.unregisterTurtleTransfer(this);
                            }
                            if (e4.getReason() == 7) {
                                Logger.normal(this, "Transfer failed (disconnect): " + e4, e4);
                            } else {
                                Logger.normal(this, "Transfer failed (" + e4.getReason() + "/" + RetrievalException.getErrString(e4.getReason()) + "): " + e4 + " from " + next, e4);
                            }
                            next.localRejectedOverload("TransferFailedRequest" + e4.getReason());
                            this.finish(4, next, false);
                            this.node.failureTable.onFinalFailure(this.key, next, this.htl, 600000, this.source);
                            int reason = e4.getReason();
                            boolean bl = timeout = !br.senderAborted() && (reason == 5 || reason == 11 || reason == 4 || reason == 12);
                            if (timeout) {
                                if (logMINOR) {
                                    Logger.minor(this, "Timeout transferring data : " + e4, (Throwable)e4);
                                }
                                next.transferFailed(e4.getErrString());
                            } else {
                                this.node.failureTable.onFinalFailure(this.key, next, this.htl, 600000, this.source);
                            }
                            this.node.nodeStats.failedBlockReceive(true, timeout, reason == 13);
                            Object var34_78 = null;
                            this.node.removeTransferringSender((NodeCHK)this.key, this);
                            return;
                        }
                        this.finish(0, next, false);
                        Object var34_77 = null;
                        this.node.removeTransferringSender((NodeCHK)this.key, this);
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var34_79 = null;
                        this.node.removeTransferringSender((NodeCHK)this.key, this);
                        throw throwable;
                    }
                }
                if (msg.getSpec() == DMT.FNPSSKPubKey) {
                    if (logMINOR) {
                        Logger.minor(this, "Got pubkey on " + this.uid);
                    }
                    if (!(this.key instanceof NodeSSK)) {
                        Logger.error(this, "Got " + msg + " but expected a different key type from " + next);
                        this.node.failureTable.onFailed(this.key, next, this.htl, (int)(System.currentTimeMillis() - timeSentRequest));
                        continue block66;
                    }
                    byte[] pubkeyAsBytes = ((ShortBuffer)msg.getObject("pubkeyAsBytes")).getData();
                    try {
                        if (this.pubKey == null) {
                            this.pubKey = DSAPublicKey.create(pubkeyAsBytes);
                        }
                        ((NodeSSK)this.key).setPubKey(this.pubKey);
                    }
                    catch (SSKVerifyException e5) {
                        this.pubKey = null;
                        Logger.error(this, "Invalid pubkey from " + this.source + " on " + this.uid + " (" + e5.getMessage() + ')', e5);
                        this.node.failureTable.onFailed(this.key, next, this.htl, (int)(System.currentTimeMillis() - timeSentRequest));
                        continue block66;
                    }
                    catch (CryptFormatException e6) {
                        Logger.error(this, "Invalid pubkey from " + this.source + " on " + this.uid + " (" + e6 + ')');
                        this.node.failureTable.onFailed(this.key, next, this.htl, (int)(System.currentTimeMillis() - timeSentRequest));
                        continue block66;
                    }
                    if (this.sskData == null || this.headers == null) continue;
                    this.finishSSK(next);
                    return;
                }
                if (msg.getSpec() == DMT.FNPSSKDataFoundData) {
                    if (logMINOR) {
                        Logger.minor(this, "Got data on " + this.uid);
                    }
                    this.sskData = ((ShortBuffer)msg.getObject("data")).getData();
                    if (!(this.key instanceof NodeSSK)) {
                        Logger.error(this, "Got " + msg + " but expected a different key type from " + next);
                        this.node.failureTable.onFailed(this.key, next, this.htl, (int)(System.currentTimeMillis() - timeSentRequest));
                        continue block66;
                    }
                    if (this.pubKey == null || this.headers == null) continue;
                    this.finishSSK(next);
                    return;
                }
                if (msg.getSpec() == DMT.FNPSSKDataFoundHeaders) {
                    if (logMINOR) {
                        Logger.minor(this, "Got headers on " + this.uid);
                    }
                    if (!(this.key instanceof NodeSSK)) {
                        Logger.error(this, "Got " + msg + " but expected a different key type from " + next);
                        this.node.failureTable.onFailed(this.key, next, this.htl, (int)(System.currentTimeMillis() - timeSentRequest));
                        continue block66;
                    }
                    this.headers = ((ShortBuffer)msg.getObject("blockHeaders")).getData();
                    if (this.pubKey == null || this.sskData == null) continue;
                    this.finishSSK(next);
                    return;
                }
                Logger.error(this, "Unexpected message: " + msg);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeTurtle() {
        RequestSender requestSender = this;
        synchronized (requestSender) {
            if (this.tryTurtle) {
                return;
            }
            this.tryTurtle = true;
        }
        this.node.makeTurtle(this);
    }

    private void finishSSK(PeerNode next) {
        try {
            this.block = new SSKBlock(this.sskData, this.headers, (NodeSSK)this.key, false);
            this.node.storeShallow(this.block);
            if (this.node.random.nextInt(200) == 0) {
                this.node.queueRandomReinsert(this.block);
            }
            this.finish(0, next, false);
        }
        catch (SSKVerifyException e) {
            Logger.error(this, "Failed to verify: " + e + " from " + next, e);
            this.finish(5, next, false);
            return;
        }
        catch (KeyCollisionException e) {
            Logger.normal(this, "Collision on " + this);
            this.finish(0, next, false);
        }
    }

    private boolean finishSSKFromGetOffer(PeerNode next) {
        try {
            this.block = new SSKBlock(this.sskData, this.headers, (NodeSSK)this.key, false);
            this.node.storeShallow(this.block);
            if (this.node.random.nextInt(200) == 0) {
                this.node.queueRandomReinsert(this.block);
            }
            this.finish(0, next, true);
            return true;
        }
        catch (SSKVerifyException e) {
            Logger.error(this, "Failed to verify (from get offer): " + e + " from " + next, e);
            return false;
        }
        catch (KeyCollisionException e) {
            Logger.normal(this, "Collision (from get offer) on " + this);
            this.finish(0, next, true);
            return false;
        }
    }

    private Message createDataRequest() {
        if (this.key instanceof NodeCHK) {
            return DMT.createFNPCHKDataRequest(this.uid, this.htl, (NodeCHK)this.key);
        }
        if (this.key instanceof NodeSSK) {
            return DMT.createFNPSSKDataRequest(this.uid, this.htl, (NodeSSK)this.key, this.pubKey == null);
        }
        throw new IllegalStateException("Unknown keytype: " + this.key);
    }

    private void verifyAndCommit(byte[] data) throws KeyVerifyException {
        if (this.key instanceof NodeCHK) {
            CHKBlock block = new CHKBlock(data, this.headers, (NodeCHK)this.key);
            this.node.storeShallow(block);
            if (this.node.random.nextInt(200) == 0) {
                this.node.queueRandomReinsert(block);
            }
        } else if (this.key instanceof NodeSSK) {
            try {
                this.node.storeShallow(new SSKBlock(data, this.headers, (NodeSSK)this.key, false));
            }
            catch (KeyCollisionException e) {
                Logger.normal(this, "Collision on " + this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardRejectedOverload() {
        RequestSender requestSender = this;
        synchronized (requestSender) {
            if (this.hasForwardedRejectedOverload) {
                return;
            }
            this.hasForwardedRejectedOverload = true;
            this.notifyAll();
        }
        this.fireReceivedRejectOverload();
    }

    public PartiallyReceivedBlock getPRB() {
        return this.prb;
    }

    public boolean transferStarted() {
        return this.prb != null;
    }

    public synchronized short waitUntilStatusChange(short mask) {
        if (mask == 7) {
            throw new IllegalArgumentException("Cannot ignore all!");
        }
        block2: while (true) {
            long deadline = System.currentTimeMillis() + 300000L;
            while (true) {
                short current = mask;
                if (this.hasForwardedRejectedOverload) {
                    current = (short)(current | 1);
                }
                if (this.prb != null) {
                    current = (short)(current | 2);
                }
                if (this.status != -1 || this.sentAbortDownstreamTransfers) {
                    current = (short)(current | 4);
                }
                if (current != mask) {
                    return current;
                }
                try {
                    long now = System.currentTimeMillis();
                    if (now >= deadline) {
                        Logger.error(this, "Waited more than 5 minutes for status change on " + this + " current = " + current);
                        continue block2;
                    }
                    this.wait(deadline - now);
                }
                catch (InterruptedException e) {
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(int code, PeerNode next, boolean fromOfferedKey) {
        boolean turtle;
        if (logMINOR) {
            Logger.minor(this, "finish(" + code + ')');
        }
        RequestSender requestSender = this;
        synchronized (requestSender) {
            this.status = code;
            this.notifyAll();
            turtle = this.turtleMode;
            if (this.status == 0) {
                this.successFrom = next;
            }
        }
        if (this.status == 0) {
            if (this.key instanceof NodeCHK && this.transferTime > 0L && logMINOR) {
                long timeTaken = System.currentTimeMillis() - this.startTime;
                MedianMeanRunningAverage medianMeanRunningAverage = avgTimeTaken;
                synchronized (medianMeanRunningAverage) {
                    if (turtle) {
                        avgTimeTakenTurtle.report(timeTaken);
                    } else {
                        avgTimeTaken.report(timeTaken);
                        avgTimeTakenTransfer.report(this.transferTime);
                    }
                    if (turtle) {
                        if (logMINOR) {
                            Logger.minor(this, "Successful CHK turtle request took " + timeTaken + " average " + avgTimeTakenTurtle);
                        }
                    } else {
                        if (logMINOR) {
                            Logger.minor(this, "Successful CHK request took " + timeTaken + " average " + avgTimeTaken);
                        }
                        if (logMINOR) {
                            Logger.minor(this, "Successful CHK request transfer " + this.transferTime + " average " + avgTimeTakenTransfer);
                        }
                        if (logMINOR) {
                            Logger.minor(this, "Search phase: median " + (avgTimeTaken.currentValue() - avgTimeTakenTransfer.currentValue()) + "ms, mean " + (avgTimeTaken.meanValue() - avgTimeTakenTransfer.meanValue()) + "ms");
                        }
                    }
                }
            }
            if (next != null) {
                next.onSuccess(false, this.key instanceof NodeSSK);
            }
            this.node.nodeStats.requestCompleted(true, this.source != null, this.key instanceof NodeSSK);
            this.fireRequestSenderFinished(code);
            if (!fromOfferedKey) {
                if (this.key instanceof NodeCHK && next != null && (next.isOpennet() || this.node.passOpennetRefsThroughDarknet())) {
                    this.finishOpennet(next);
                } else {
                    this.finishOpennetNull(next);
                }
            }
        } else {
            this.node.nodeStats.requestCompleted(false, this.source != null, this.key instanceof NodeSSK);
            this.fireRequestSenderFinished(code);
        }
        RequestSender requestSender2 = this;
        synchronized (requestSender2) {
            this.opennetFinished = true;
            this.notifyAll();
        }
    }

    private void finishOpennetNull(PeerNode next) {
        MessageFilter mf = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(120000).setType(DMT.FNPOpennetCompletedAck);
        try {
            this.node.usm.addAsyncFilter(mf, new NullAsyncMessageFilterCallback());
        }
        catch (DisconnectedException disconnectedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void finishOpennet(PeerNode next) {
        block30: {
            block29: {
                block28: {
                    block27: {
                        RequestSender requestSender;
                        block26: {
                            try {
                                try {
                                    OpennetManager om = this.node.getOpennet();
                                    if (om == null) {
                                        Object var8_3 = null;
                                        requestSender = this;
                                        break block26;
                                    }
                                    byte[] noderef = om.waitForOpennetNoderef(false, next, this.uid, this);
                                    if (noderef == null) {
                                        break block27;
                                    }
                                    SimpleFieldSet ref = om.validateNoderef(noderef, 0, noderef.length, next, false);
                                    if (ref == null) {
                                        break block28;
                                    }
                                    if (this.node.addNewOpennetNode(ref) == null) {
                                        RequestSender requestSender2 = this;
                                        synchronized (requestSender2) {
                                            this.opennetNoderef = noderef;
                                        }
                                        break block29;
                                    }
                                    Logger.normal(this, "Added opennet noderef in " + this + " from " + next);
                                    om.sendOpennetRef(true, this.uid, next, om.crypto.myCompressedFullRef(), this);
                                    break block30;
                                }
                                catch (FSParseException e) {
                                    Logger.error(this, "Could not parse opennet noderef for " + this + " from " + next, e);
                                    Object var8_8 = null;
                                    RequestSender requestSender3 = this;
                                    synchronized (requestSender3) {
                                        this.opennetFinished = true;
                                        this.notifyAll();
                                        return;
                                    }
                                }
                                catch (PeerParseException e) {
                                    Logger.error(this, "Could not parse opennet noderef for " + this + " from " + next, e);
                                    Object var8_9 = null;
                                    RequestSender requestSender4 = this;
                                    synchronized (requestSender4) {
                                        this.opennetFinished = true;
                                        this.notifyAll();
                                        return;
                                    }
                                }
                                catch (ReferenceSignatureVerificationException e) {
                                    Logger.error(this, "Bad signature on opennet noderef for " + this + " from " + next + " : " + e, e);
                                    Object var8_10 = null;
                                    RequestSender requestSender5 = this;
                                    synchronized (requestSender5) {
                                        this.opennetFinished = true;
                                        this.notifyAll();
                                        return;
                                    }
                                }
                                catch (NotConnectedException e) {
                                    if (logMINOR) {
                                        Logger.minor(this, "Not connected sending ConnectReply on " + this + " to " + next);
                                    }
                                    Object var8_11 = null;
                                    RequestSender requestSender6 = this;
                                    synchronized (requestSender6) {
                                        this.opennetFinished = true;
                                        this.notifyAll();
                                        return;
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                Object var8_12 = null;
                                RequestSender requestSender7 = this;
                                synchronized (requestSender7) {
                                    this.opennetFinished = true;
                                    this.notifyAll();
                                    throw throwable;
                                }
                            }
                        }
                        synchronized (requestSender) {
                            this.opennetFinished = true;
                            this.notifyAll();
                            return;
                        }
                    }
                    Object var8_4 = null;
                    RequestSender requestSender = this;
                    synchronized (requestSender) {
                        this.opennetFinished = true;
                        this.notifyAll();
                        return;
                    }
                }
                Object var8_5 = null;
                RequestSender requestSender = this;
                synchronized (requestSender) {
                    this.opennetFinished = true;
                    this.notifyAll();
                    return;
                }
            }
            Object var8_6 = null;
            RequestSender requestSender = this;
            synchronized (requestSender) {
                this.opennetFinished = true;
                this.notifyAll();
                return;
            }
        }
        Object var8_7 = null;
        RequestSender requestSender = this;
        synchronized (requestSender) {
            this.opennetFinished = true;
            this.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] waitForOpennetNoderef() {
        RequestSender requestSender = this;
        synchronized (requestSender) {
            while (true) {
                if (this.opennetFinished) {
                    byte[] ref = this.opennetNoderef;
                    this.opennetNoderef = null;
                    return ref;
                }
                try {
                    this.wait(120000L);
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
            return null;
        }
    }

    public PeerNode successFrom() {
        return this.successFrom;
    }

    public synchronized PeerNode routedLast() {
        return this.lastNode;
    }

    public byte[] getHeaders() {
        return this.headers;
    }

    public int getStatus() {
        return this.status;
    }

    public short getHTL() {
        return this.htl;
    }

    final byte[] getSSKData() {
        return this.sskData;
    }

    public SSKBlock getSSKBlock() {
        return this.block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sentBytes(int x) {
        Object object = this.totalBytesSync;
        synchronized (object) {
            this.totalBytesSent += x;
        }
        this.node.nodeStats.requestSentBytes(this.key instanceof NodeSSK, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalSentBytes() {
        Object object = this.totalBytesSync;
        synchronized (object) {
            return this.totalBytesSent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedBytes(int x) {
        Object object = this.totalBytesSync;
        synchronized (object) {
            this.totalBytesReceived += x;
        }
        this.node.nodeStats.requestReceivedBytes(this.key instanceof NodeSSK, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalReceivedBytes() {
        Object object = this.totalBytesSync;
        synchronized (object) {
            return this.totalBytesReceived;
        }
    }

    synchronized boolean hasForwarded() {
        return this.hasForwarded;
    }

    public void sentPayload(int x) {
        this.node.sentPayload(x);
        this.node.nodeStats.requestSentBytes(this.key instanceof NodeSSK, -x);
    }

    synchronized int getRecentlyFailedTimeLeft() {
        return this.recentlyFailedTimeLeft;
    }

    public boolean isLocalRequestSearch() {
        return this.source == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener l) {
        int status;
        boolean sentFinished;
        boolean reject = false;
        boolean transfer = false;
        boolean sentTransferCancel = false;
        RequestSender requestSender = this;
        synchronized (requestSender) {
            ArrayList<Listener> arrayList = this.listeners;
            synchronized (arrayList) {
                sentTransferCancel = this.sentAbortDownstreamTransfers;
                if (!sentTransferCancel) {
                    this.listeners.add(l);
                }
                reject = this.sentReceivedRejectOverload;
                transfer = this.sentCHKTransferBegins;
                sentFinished = this.sentRequestSenderFinished;
            }
            reject = reject && this.hasForwardedRejectedOverload;
            transfer = transfer && this.transferStarted();
            status = this.status;
        }
        if (reject) {
            l.onReceivedRejectOverload();
        }
        if (transfer) {
            l.onCHKTransferBegins();
        }
        if (sentTransferCancel) {
            l.onAbortDownstreamTransfers(this.abortDownstreamTransfersReason, this.abortDownstreamTransfersDesc);
        }
        if (status != -1 && sentFinished) {
            l.onRequestSenderFinished(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireReceivedRejectOverload() {
        ArrayList<Listener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (this.sentReceivedRejectOverload) {
                return;
            }
            this.sentReceivedRejectOverload = true;
            for (Listener l : this.listeners) {
                try {
                    l.onReceivedRejectOverload();
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught: " + t, t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCHKTransferBegins() {
        ArrayList<Listener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.sentCHKTransferBegins = true;
            for (Listener l : this.listeners) {
                try {
                    l.onCHKTransferBegins();
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught: " + t, t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRequestSenderFinished(int status) {
        ArrayList<Listener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.sentRequestSenderFinished = true;
            for (Listener l : this.listeners) {
                try {
                    l.onRequestSenderFinished(status);
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught: " + t, t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAbortDownstreamTransfers(int reason, String desc) {
        Object object = this.listeners;
        synchronized (object) {
            this.abortDownstreamTransfersReason = reason;
            this.abortDownstreamTransfersDesc = desc;
            this.sentAbortDownstreamTransfers = true;
            for (Listener l : this.listeners) {
                try {
                    l.onAbortDownstreamTransfers(reason, desc);
                    l.onRequestSenderFinished(4);
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught: " + t, t);
                }
            }
            this.listeners.clear();
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    public int getPriority() {
        return 7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTurtle() {
        RequestSender requestSender = this;
        synchronized (requestSender) {
            this.turtleMode = true;
        }
        this.sendAbortDownstreamTransfers(13, "Turtling");
        this.node.getTicker().queueTimedJob(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                PeerNode from;
                RequestSender requestSender = RequestSender.this;
                synchronized (requestSender) {
                    if (RequestSender.this.sentBackoffTurtle) {
                        return;
                    }
                    RequestSender.this.sentBackoffTurtle = true;
                    from = RequestSender.this.transferringFrom;
                    if (from == null) {
                        return;
                    }
                }
                from.transferFailed("TurtledTransfer");
            }
        }, 30000L);
    }

    public PeerNode transferringFrom() {
        return this.transferringFrom;
    }

    public void killTurtle() {
        this.prb.abort(14, "Too many turtles / already have turtles for this key");
        this.node.failureTable.onFinalFailure(this.key, this.transferringFrom(), this.htl, 600000, this.source);
    }

    public boolean abortedDownstreamTransfers() {
        return this.sentAbortDownstreamTransfers;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
        avgTimeTaken = new MedianMeanRunningAverage();
        avgTimeTakenTurtle = new MedianMeanRunningAverage();
        avgTimeTakenTransfer = new MedianMeanRunningAverage();
    }

    static interface Listener {
        public void onReceivedRejectOverload();

        public void onCHKTransferBegins();

        public void onRequestSenderFinished(int var1);

        public void onAbortDownstreamTransfers(int var1, String var2);
    }
}

