/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.crypt.DSAPublicKey;
import freenet.io.comm.AsyncMessageCallback;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.Message;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.io.xfer.BlockTransmitter;
import freenet.io.xfer.PartiallyReceivedBlock;
import freenet.io.xfer.WaitedTooLongException;
import freenet.keys.CHKBlock;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.NodeCHK;
import freenet.keys.NodeSSK;
import freenet.keys.SSKBlock;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.node.OpennetManager;
import freenet.node.PeerNode;
import freenet.node.PrioRunnable;
import freenet.node.RequestSender;
import freenet.node.RequestTag;
import freenet.node.SyncSendWaitedTooLongException;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.TimeUtil;

public class RequestHandler
implements PrioRunnable,
ByteCounter,
RequestSender.Listener {
    private static volatile boolean logMINOR;
    final Message req;
    final Node node;
    final long uid;
    private short htl;
    final PeerNode source;
    private boolean needsPubKey;
    final Key key;
    private boolean finalTransferFailed = false;
    private RequestSender rs;
    private int status = -1;
    private boolean appliedByteCounts = false;
    private boolean sentRejectedOverload = false;
    private long searchStartTime;
    private long responseDeadline;
    private BlockTransmitter bt;
    private final RequestTag tag;
    private Exception previousApplyByteCountCall;
    private boolean disconnected = false;
    boolean sendTerminalCalled = false;
    private int sentBytes;
    private int receivedBytes;
    private volatile Object bytesSync = new Object();

    public String toString() {
        return super.toString() + " for " + this.uid;
    }

    public RequestHandler(Message m, PeerNode source, long id, Node n, short htl, Key key, RequestTag tag) {
        this.req = m;
        this.node = n;
        this.uid = id;
        this.source = source;
        this.htl = htl;
        this.tag = tag;
        if (htl <= 0) {
            htl = 1;
        }
        this.key = key;
        if (key instanceof NodeSSK) {
            this.needsPubKey = m.getBoolean("needPubKey");
        }
        this.receivedBytes(m.receivedByteCount());
    }

    public void run() {
        Logger.OSThread.logPID(this);
        try {
            this.realRun();
        }
        catch (NotConnectedException e) {
            Logger.normal(this, "requestor gone, could not start request handler wait");
            this.node.removeTransferringRequestHandler(this.uid);
            this.tag.handlerThrew(e);
            this.node.unlockUID(this.uid, this.key instanceof NodeSSK, false, false, false, false, this.tag);
        }
        catch (Throwable t) {
            Logger.error(this, "Caught " + t, t);
            this.node.removeTransferringRequestHandler(this.uid);
            this.tag.handlerThrew(t);
            this.node.unlockUID(this.uid, this.key instanceof NodeSSK, false, false, false, false, this.tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyByteCounts() {
        if (this.disconnected) {
            Logger.normal(this, "Not applying byte counts as request source disconnected during receive");
            return;
        }
        if (this.appliedByteCounts) {
            Logger.error(this, "applyByteCounts already called", new Exception("error"));
            Logger.error(this, "first called here", this.previousApplyByteCountCall);
            return;
        }
        this.previousApplyByteCountCall = new Exception("first call to applyByteCounts");
        this.appliedByteCounts = true;
        if (!this.finalTransferFailed && this.rs != null && this.status != 6 && this.status != 7 && this.status != 8) {
            int rcvd;
            int sent;
            Object object = this.bytesSync;
            synchronized (object) {
                sent = this.sentBytes;
                rcvd = this.receivedBytes;
            }
            sent += this.rs.getTotalSentBytes();
            rcvd += this.rs.getTotalReceivedBytes();
            if (this.key instanceof NodeSSK) {
                if (logMINOR) {
                    Logger.minor(this, "Remote SSK fetch cost " + sent + '/' + rcvd + " bytes (" + this.status + ')');
                }
                this.node.nodeStats.remoteSskFetchBytesSentAverage.report(sent);
                this.node.nodeStats.remoteSskFetchBytesReceivedAverage.report(rcvd);
                if (this.status == 0) {
                    this.node.nodeStats.successfulSskFetchBytesSentAverage.report(sent);
                    this.node.nodeStats.successfulSskFetchBytesReceivedAverage.report(rcvd);
                }
            } else {
                if (logMINOR) {
                    Logger.minor(this, "Remote CHK fetch cost " + sent + '/' + rcvd + " bytes (" + this.status + ')');
                }
                this.node.nodeStats.remoteChkFetchBytesSentAverage.report(sent);
                this.node.nodeStats.remoteChkFetchBytesReceivedAverage.report(rcvd);
                if (this.status == 0) {
                    this.node.nodeStats.successfulChkFetchBytesSentAverage.report(sent);
                    this.node.nodeStats.successfulChkFetchBytesReceivedAverage.report(rcvd);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realRun() throws NotConnectedException {
        if (logMINOR) {
            Logger.minor(this, "Handling a request: " + this.uid);
        }
        Message accepted = DMT.createFNPAccepted(this.uid);
        this.source.sendAsync(accepted, null, this);
        Object o = this.node.makeRequestSender(this.key, this.htl, this.uid, this.source, false, true, false, false);
        if (o instanceof KeyBlock) {
            this.tag.setServedFromDatastore();
            this.returnLocalData((KeyBlock)o);
            return;
        }
        if (o == null) {
            Message dnf = DMT.createFNPDataNotFound(this.uid);
            this.status = 3;
            this.node.failureTable.onFinalFailure(this.key, null, this.htl, 600000, this.source);
            this.sendTerminal(dnf);
            return;
        }
        long queueTime = this.source.getProbableSendQueueTime();
        RequestHandler requestHandler = this;
        synchronized (requestHandler) {
            this.rs = (RequestSender)o;
            this.searchStartTime = System.currentTimeMillis();
            this.responseDeadline = this.searchStartTime + 120000L + queueTime;
        }
        this.rs.addListener(this);
    }

    public void onReceivedRejectOverload() {
        try {
            if (!this.sentRejectedOverload) {
                Message msg = DMT.createFNPRejectedOverload(this.uid, false);
                this.source.sendAsync(msg, null, this);
                this.sentRejectedOverload = true;
            }
        }
        catch (NotConnectedException e) {
            Logger.normal(this, "requestor is gone, can't forward reject overload");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCHKTransferBegins() {
        try {
            Message df = DMT.createFNPCHKDataFound(this.uid, this.rs.getHeaders());
            this.source.sendAsync(df, null, this);
            PartiallyReceivedBlock prb = this.rs.getPRB();
            this.bt = new BlockTransmitter(this.node.usm, this.source, this.uid, prb, this);
            this.node.addTransferringRequestHandler(this.uid);
            this.bt.sendAsync(this.node.executor);
        }
        catch (NotConnectedException e) {
            RequestHandler requestHandler = this;
            synchronized (requestHandler) {
                this.disconnected = true;
            }
            this.tag.handlerDisconnected();
            Logger.normal(this, "requestor is gone, can't begin CHK transfer");
        }
    }

    public void onAbortDownstreamTransfers(int reason, String desc) {
        if (this.bt == null) {
            Logger.error(this, "No downstream transfer to abort! on " + this);
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Aborting downstream transfer on " + this);
        }
        this.tag.onAbortDownstreamTransfers(reason, desc);
        try {
            this.bt.abortSend(reason, desc);
        }
        catch (NotConnectedException notConnectedException) {
            // empty catch block
        }
    }

    private void waitAndFinishCHKTransferOffThread() {
        this.node.executor.execute(new Runnable(){

            public void run() {
                try {
                    RequestHandler.this.waitAndFinishCHKTransfer();
                }
                catch (NotConnectedException e) {
                    RequestHandler.this.applyByteCounts();
                    RequestHandler.this.unregisterRequestHandlerWithNode();
                }
            }
        }, "Finish CHK transfer for " + this.key + " for " + this);
    }

    private void waitAndFinishCHKTransfer() throws NotConnectedException {
        if (logMINOR) {
            Logger.minor(this, "Waiting for CHK transfer to finish");
        }
        if (this.bt.getAsyncExitStatus()) {
            this.status = this.rs.getStatus();
            this.finishOpennetChecked();
        } else {
            this.finalTransferFailed = true;
            this.status = this.rs.getStatus();
            this.applyByteCounts();
            this.unregisterRequestHandlerWithNode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestSenderFinished(int status) {
        boolean tooLate;
        if (logMINOR) {
            Logger.minor(this, "onRequestSenderFinished(" + status + ") on " + this);
        }
        long now = System.currentTimeMillis();
        this.status = status;
        RequestHandler requestHandler = this;
        synchronized (requestHandler) {
            tooLate = this.responseDeadline > 0L && now > this.responseDeadline;
        }
        if (tooLate) {
            this.node.failureTable.onFinalFailure(this.key, null, this.htl, -1, this.source);
            PeerNode routedLast = this.rs == null ? null : this.rs.routedLast();
            Logger.normal(this, "requestsender took too long to respond to requestor (" + TimeUtil.formatTime(now - this.searchStartTime, 2, true) + "/" + (this.rs == null ? "null" : this.rs.getStatusString()) + ") routed to " + (routedLast == null ? "null" : routedLast.shortToString()));
            this.applyByteCounts();
            this.unregisterRequestHandlerWithNode();
            return;
        }
        if (status == -1) {
            Logger.error(this, "onFinished() but not finished?");
        }
        try {
            switch (status) {
                case -1: 
                case 3: {
                    Message dnf = DMT.createFNPDataNotFound(this.uid);
                    this.sendTerminal(dnf);
                    return;
                }
                case 9: {
                    Message rf = DMT.createFNPRecentlyFailed(this.uid, this.rs.getRecentlyFailedTimeLeft());
                    this.sendTerminal(rf);
                    return;
                }
                case 6: 
                case 7: 
                case 8: {
                    Message reject = DMT.createFNPRejectedOverload(this.uid, true);
                    this.sendTerminal(reject);
                    return;
                }
                case 1: {
                    Message rnf = DMT.createFNPRouteNotFound(this.uid, this.rs.getHTL());
                    this.sendTerminal(rnf);
                    return;
                }
                case 0: {
                    if (this.key instanceof NodeSSK) {
                        this.sendSSK(this.rs.getHeaders(), this.rs.getSSKData(), this.needsPubKey, this.rs.getSSKBlock().getKey().getPubKey());
                    } else if (this.bt == null && !this.disconnected) {
                        Logger.error(this, "Status is SUCCESS but we never started a transfer on " + this.uid);
                        Message reject = DMT.createFNPRejectedOverload(this.uid, true);
                        this.sendTerminal(reject);
                    } else if (!this.disconnected) {
                        this.waitAndFinishCHKTransferOffThread();
                    } else {
                        this.unregisterRequestHandlerWithNode();
                    }
                    return;
                }
                case 5: 
                case 10: {
                    if (this.key instanceof NodeCHK) {
                        if (this.bt == null && !this.disconnected) {
                            Logger.error(this, "Status is VERIFY_FAILURE but we never started a transfer on " + this.uid);
                            Message reject = DMT.createFNPRejectedOverload(this.uid, true);
                            this.sendTerminal(reject);
                        } else if (!this.disconnected) {
                            this.waitAndFinishCHKTransferOffThread();
                        } else {
                            this.unregisterRequestHandlerWithNode();
                        }
                        return;
                    }
                    Message reject = DMT.createFNPRejectedOverload(this.uid, true);
                    this.sendTerminal(reject);
                    return;
                }
                case 4: 
                case 11: {
                    if (this.key instanceof NodeCHK) {
                        if (this.bt == null && !this.disconnected) {
                            Logger.error(this, "Status is TRANSFER_FAILED but we never started a transfer on " + this.uid);
                            Message reject = DMT.createFNPRejectedOverload(this.uid, true);
                            this.sendTerminal(reject);
                        } else if (!this.disconnected) {
                            this.waitAndFinishCHKTransferOffThread();
                        } else {
                            this.unregisterRequestHandlerWithNode();
                        }
                        return;
                    }
                    Logger.error(this, "finish(TRANSFER_FAILED) should not be called on SSK?!?!", new Exception("error"));
                    return;
                }
            }
            Message reject = DMT.createFNPRejectedOverload(this.uid, true);
            this.sendTerminal(reject);
            throw new IllegalStateException("Unknown status code " + status);
        }
        catch (NotConnectedException e) {
            Logger.normal(this, "requestor is gone, can't send terminal message");
            this.applyByteCounts();
            this.unregisterRequestHandlerWithNode();
            return;
        }
    }

    private void sendSSK(byte[] headers, final byte[] data, boolean needsPubKey2, DSAPublicKey pubKey) throws NotConnectedException {
        Message headersMsg = DMT.createFNPSSKDataFoundHeaders(this.uid, headers);
        this.source.sendAsync(headersMsg, null, this);
        final Message dataMsg = DMT.createFNPSSKDataFoundData(this.uid, data);
        this.node.executor.execute(new PrioRunnable(){

            public int getPriority() {
                return RequestHandler.this.getPriority();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        RequestHandler.this.source.sendThrottledMessage(dataMsg, data.length, RequestHandler.this, 60000, true, null);
                        RequestHandler.this.applyByteCounts();
                    }
                    catch (NotConnectedException e) {
                        Object var3_2 = null;
                        RequestHandler.this.unregisterRequestHandlerWithNode();
                        return;
                    }
                    catch (WaitedTooLongException e) {
                        Logger.error(this, "Waited too long to send SSK data on " + RequestHandler.this + " because of bwlimiting");
                        Object var3_3 = null;
                        RequestHandler.this.unregisterRequestHandlerWithNode();
                        return;
                    }
                    catch (SyncSendWaitedTooLongException e) {
                        Logger.error(this, "Waited too long to send SSK data on " + RequestHandler.this + " because of peer");
                        Object var3_4 = null;
                        RequestHandler.this.unregisterRequestHandlerWithNode();
                        return;
                    }
                    Object var3_1 = null;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    RequestHandler.this.unregisterRequestHandlerWithNode();
                    throw throwable;
                }
                RequestHandler.this.unregisterRequestHandlerWithNode();
            }
        }, "Send throttled SSK data for " + this);
        if (this.needsPubKey) {
            Message pk = DMT.createFNPSSKPubKey(this.uid, pubKey);
            this.source.sendAsync(pk, null, this);
        }
    }

    static void sendSSK(byte[] headers, byte[] data, boolean needsPubKey, DSAPublicKey pubKey, PeerNode source, long uid, ByteCounter ctr) throws NotConnectedException, WaitedTooLongException {
        Message headersMsg = DMT.createFNPSSKDataFoundHeaders(uid, headers);
        source.sendAsync(headersMsg, null, ctr);
        Message dataMsg = DMT.createFNPSSKDataFoundData(uid, data);
        try {
            source.sendThrottledMessage(dataMsg, data.length, ctr, 60000, false, null);
        }
        catch (SyncSendWaitedTooLongException e) {
            throw new Error(e);
        }
        if (needsPubKey) {
            Message pk = DMT.createFNPSSKPubKey(uid, pubKey);
            source.sendAsync(pk, null, ctr);
        }
    }

    private void returnLocalData(KeyBlock block) throws NotConnectedException {
        if (this.key instanceof NodeSSK) {
            this.sendSSK(block.getRawHeaders(), block.getRawData(), this.needsPubKey, ((SSKBlock)block).getPubKey());
            this.status = 0;
        } else if (block instanceof CHKBlock) {
            Message df = DMT.createFNPCHKDataFound(this.uid, block.getRawHeaders());
            PartiallyReceivedBlock prb = new PartiallyReceivedBlock(32, 1024, block.getRawData());
            BlockTransmitter bt = new BlockTransmitter(this.node.usm, this.source, this.uid, prb, this);
            this.node.addTransferringRequestHandler(this.uid);
            this.source.sendAsync(df, null, this);
            if (bt.send(this.node.executor)) {
                this.status = 0;
                this.finishOpennetNoRelay();
            } else {
                this.applyByteCounts();
                this.unregisterRequestHandlerWithNode();
            }
        } else {
            throw new IllegalStateException();
        }
    }

    private void unregisterRequestHandlerWithNode() {
        this.node.removeTransferringRequestHandler(this.uid);
        this.node.unlockUID(this.uid, this.key instanceof NodeSSK, false, false, false, false, this.tag);
    }

    private void sendTerminal(Message msg) throws NotConnectedException {
        if (logMINOR) {
            Logger.minor(this, "sendTerminal(" + msg + ")", (Throwable)new Exception("debug"));
        }
        if (this.sendTerminalCalled) {
            throw new IllegalStateException("sendTerminal should only be called once");
        }
        this.sendTerminalCalled = true;
        this.source.sendAsync(msg, new TerminalMessageByteCountCollector(), this);
    }

    private void finishOpennetChecked() throws NotConnectedException {
        OpennetManager om = this.node.getOpennet();
        if (om != null && (this.node.passOpennetRefsThroughDarknet() || this.source.isOpennet()) && this.finishOpennetInner(om)) {
            this.applyByteCounts();
            this.unregisterRequestHandlerWithNode();
            return;
        }
        Message msg = DMT.createFNPOpennetCompletedAck(this.uid);
        this.sendTerminal(msg);
    }

    private void finishOpennetNoRelay() throws NotConnectedException {
        OpennetManager om = this.node.getOpennet();
        if (om != null && (this.source.isOpennet() || this.node.passOpennetRefsThroughDarknet()) && this.finishOpennetNoRelayInner(om)) {
            this.applyByteCounts();
            this.unregisterRequestHandlerWithNode();
            return;
        }
        Message msg = DMT.createFNPOpennetCompletedAck(this.uid);
        this.sendTerminal(msg);
    }

    private boolean finishOpennetInner(OpennetManager om) {
        byte[] noderef = this.rs.waitForOpennetNoderef();
        if (noderef == null) {
            return this.finishOpennetNoRelayInner(om);
        }
        if (this.node.random.nextInt(20) == 0) {
            return this.finishOpennetNoRelayInner(om);
        }
        this.finishOpennetRelay(noderef, om);
        return true;
    }

    private boolean finishOpennetNoRelayInner(OpennetManager om) {
        if (logMINOR) {
            Logger.minor(this, "Finishing opennet: sending own reference");
        }
        if (!om.wantPeer(null, false, false, false)) {
            return false;
        }
        try {
            om.sendOpennetRef(false, this.uid, this.source, om.crypto.myCompressedFullRef(), this);
        }
        catch (NotConnectedException e) {
            Logger.normal(this, "Can't send opennet ref because node disconnected on " + this);
            return true;
        }
        byte[] noderef = om.waitForOpennetNoderef(true, this.source, this.uid, this);
        if (noderef == null) {
            return false;
        }
        SimpleFieldSet ref = om.validateNoderef(noderef, 0, noderef.length, this.source, false);
        if (ref == null) {
            return false;
        }
        try {
            if (this.node.addNewOpennetNode(ref) == null) {
                Logger.normal(this, "Asked for opennet ref but didn't want it for " + this + " :\n" + ref);
            } else {
                Logger.normal(this, "Added opennet noderef in " + this);
            }
        }
        catch (FSParseException e) {
            Logger.error(this, "Could not parse opennet noderef for " + this + " from " + this.source, e);
        }
        catch (PeerParseException e) {
            Logger.error(this, "Could not parse opennet noderef for " + this + " from " + this.source, e);
        }
        catch (ReferenceSignatureVerificationException e) {
            Logger.error(this, "Bad signature on opennet noderef for " + this + " from " + this.source + " : " + e, e);
        }
        return true;
    }

    private void finishOpennetRelay(byte[] noderef, OpennetManager om) {
        if (logMINOR) {
            Logger.minor(this, "Finishing opennet: relaying reference from " + this.rs.successFrom());
        }
        PeerNode dataSource = this.rs.successFrom();
        try {
            om.sendOpennetRef(false, this.uid, this.source, noderef, this);
        }
        catch (NotConnectedException e) {
            return;
        }
        byte[] newNoderef = om.waitForOpennetNoderef(true, this.source, this.uid, this);
        if (newNoderef == null) {
            return;
        }
        if (om.validateNoderef(newNoderef, 0, newNoderef.length, this.source, false) != null) {
            try {
                om.sendOpennetRef(true, this.uid, dataSource, newNoderef, this);
            }
            catch (NotConnectedException e) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sentBytes(int x) {
        Object object = this.bytesSync;
        synchronized (object) {
            this.sentBytes += x;
        }
        this.node.nodeStats.requestSentBytes(this.key instanceof NodeSSK, x);
        if (logMINOR) {
            Logger.minor(this, "sentBytes(" + x + ") on " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedBytes(int x) {
        Object object = this.bytesSync;
        synchronized (object) {
            this.receivedBytes += x;
        }
        this.node.nodeStats.requestReceivedBytes(this.key instanceof NodeSSK, x);
    }

    public void sentPayload(int x) {
        this.node.sentPayload(x);
        this.node.nodeStats.requestSentBytes(this.key instanceof NodeSSK, -x);
        if (logMINOR) {
            Logger.minor(this, "sentPayload(" + x + ") on " + this);
        }
    }

    public int getPriority() {
        return 7;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }

    private class TerminalMessageByteCountCollector
    implements AsyncMessageCallback {
        private boolean completed = false;

        private TerminalMessageByteCountCollector() {
        }

        public void acknowledged() {
            if (logMINOR) {
                Logger.minor(this, "Acknowledged terminal message: " + RequestHandler.this);
            }
            this.complete();
        }

        public void disconnected() {
            if (logMINOR) {
                Logger.minor(this, "Peer disconnected before terminal message sent for " + RequestHandler.this);
            }
            this.complete();
        }

        public void fatalError() {
            Logger.error(this, "Error sending terminal message?! for " + RequestHandler.this);
            this.complete();
        }

        public void sent() {
            if (logMINOR) {
                Logger.minor(this, "Sent terminal message: " + RequestHandler.this);
            }
            this.complete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void complete() {
            TerminalMessageByteCountCollector terminalMessageByteCountCollector = this;
            synchronized (terminalMessageByteCountCollector) {
                if (this.completed) {
                    return;
                }
                this.completed = true;
            }
            if (logMINOR) {
                Logger.minor(this, "Completing: " + RequestHandler.this);
            }
            RequestHandler.this.applyByteCounts();
            RequestHandler.this.unregisterRequestHandlerWithNode();
        }
    }
}

