/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.node.Location;
import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.node.PrioRunnable;
import freenet.support.Logger;
import freenet.support.ShortBuffer;
import java.util.ArrayList;
import java.util.HashSet;

public class ProbeRequestSender
implements PrioRunnable,
ByteCounter {
    static final int ACCEPTED_TIMEOUT = 5000;
    static final int FETCH_TIMEOUT = 120000;
    final double target;
    private short htl;
    private double best;
    private short counter;
    private short linearCounter;
    private short uniqueCounter;
    final long uid;
    final Node node;
    private double nearestLoc;
    final PeerNode source;
    private boolean hasForwarded;
    private ArrayList<Listener> listeners = new ArrayList();
    private static boolean logMINOR;
    private volatile boolean hasForwardedRejectedOverload;
    static final short WAIT_REJECTED_OVERLOAD = 1;
    static final short WAIT_FINISHED = 4;
    static final short WAIT_ALL = 5;
    private volatile Object totalBytesSync = new Object();
    private int totalBytesSent;
    private int totalBytesReceived;

    public String toString() {
        return super.toString() + " for " + this.uid;
    }

    public ProbeRequestSender(double target, short htl, long uid, Node n, double nearestLoc, PeerNode source, double best) {
        this.htl = htl;
        this.uid = uid;
        this.node = n;
        this.source = source;
        this.nearestLoc = nearestLoc;
        this.target = target;
        this.best = best;
        this.counter = 1;
        this.linearCounter = 1;
        this.uniqueCounter = 1;
        logMINOR = Logger.shouldLog(4, this);
        this.updateBest();
        if (target < 0.0 || target > 1.0) {
            throw new IllegalArgumentException();
        }
    }

    public void start() {
        this.node.executor.execute(this, "ResettingHTLProbeRequestSender for UID " + this.uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                this.realRun();
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t, t);
                this.fireTimeout("Internal error");
                Object var3_2 = null;
                if (!logMINOR) return;
                Logger.minor(this, "Leaving RequestSender.run() for " + this.uid);
                return;
            }
            Object var3_1 = null;
            if (!logMINOR) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!logMINOR) throw throwable;
            Logger.minor(this, "Leaving RequestSender.run() for " + this.uid);
            throw throwable;
        }
        Logger.minor(this, "Leaving RequestSender.run() for " + this.uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realRun() {
        int routeAttempts = 0;
        int rejectOverloads = 0;
        HashSet<PeerNode> nodesRoutedTo = new HashSet<PeerNode>();
        block9: while (true) {
            if (logMINOR) {
                Logger.minor(this, "htl=" + this.htl);
            }
            if (this.htl == 0) {
                this.fireCompletion();
                return;
            }
            ++routeAttempts;
            PeerNode next = this.node.peers.closerPeer(this.source, nodesRoutedTo, this.target, true, this.node.isAdvancedModeEnabled(), -1, null, null);
            if (next == null) {
                if (logMINOR && rejectOverloads > 0) {
                    Logger.minor(this, "no more peers, but overloads (" + rejectOverloads + "/" + routeAttempts + " overloaded)");
                }
                this.fireRNF();
                return;
            }
            if (logMINOR) {
                Logger.minor(this, "Routing request to " + next);
            }
            nodesRoutedTo.add(next);
            this.htl = this.node.decrementHTL(this.hasForwarded ? next : this.source, this.htl);
            Message req = this.createDataRequest();
            try {
                next.sendSync(req, this);
            }
            catch (NotConnectedException e) {
                Logger.minor(this, "Not connected");
                continue;
            }
            ProbeRequestSender e = this;
            synchronized (e) {
                this.hasForwarded = true;
            }
            Message msg = null;
            while (true) {
                block36: {
                    MessageFilter mfAccepted = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(5000).setType(DMT.FNPAccepted);
                    MessageFilter mfRejectedLoop = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(5000).setType(DMT.FNPRejectedLoop);
                    MessageFilter mfRejectedOverload = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(5000).setType(DMT.FNPRejectedOverload);
                    MessageFilter mf = mfAccepted.or(mfRejectedLoop.or(mfRejectedOverload));
                    try {
                        msg = this.node.usm.waitFor(mf, this);
                        if (!logMINOR) break block36;
                        Logger.minor(this, "first part got " + msg);
                    }
                    catch (DisconnectedException e2) {
                        Logger.normal(this, "Disconnected from " + next + " while waiting for Accepted on " + this.uid);
                        break;
                    }
                }
                if (msg == null) {
                    this.counter = (short)(this.counter + 1);
                    if (logMINOR) {
                        Logger.minor(this, "Timeout waiting for Accepted");
                    }
                    next.localRejectedOverload("AcceptedTimeout");
                    this.forwardRejectedOverload();
                    break;
                }
                if (msg.getSpec() == DMT.FNPRejectedLoop) {
                    this.counter = (short)(this.counter + 1);
                    if (!logMINOR) break;
                    Logger.minor(this, "Rejected loop");
                    break;
                }
                if (msg.getSpec() == DMT.FNPRejectedOverload) {
                    this.uniqueCounter = (short)(this.uniqueCounter + 1);
                    this.counter = (short)(this.counter + 1);
                    if (logMINOR) {
                        Logger.minor(this, "Rejected: overload");
                    }
                    this.forwardRejectedOverload();
                    if (!msg.getBoolean("isLocal")) continue;
                    if (!logMINOR) break;
                    Logger.minor(this, "Local RejectedOverload, moving on to next peer");
                    break;
                }
                if (msg.getSpec() == DMT.FNPAccepted) break;
                Logger.error(this, "Unrecognized message: " + msg);
            }
            if (msg == null || msg.getSpec() != DMT.FNPAccepted) continue;
            if (logMINOR) {
                Logger.minor(this, "Got Accepted");
            }
            int gotMessages = 0;
            String lastMessage = null;
            while (true) {
                MessageFilter mfDF = this.makeDataFoundFilter(next);
                MessageFilter mfRouteNotFound = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(120000).setType(DMT.FNPRouteNotFound);
                MessageFilter mfRejectedOverload = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(120000).setType(DMT.FNPRejectedOverload);
                MessageFilter mfPubKey = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(120000).setType(DMT.FNPSSKPubKey);
                MessageFilter mfTrace = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(120000).setType(DMT.FNPRHProbeTrace);
                MessageFilter mf = mfRouteNotFound.or(mfRejectedOverload.or(mfDF.or(mfPubKey.or(mfTrace))));
                try {
                    msg = this.node.usm.waitFor(mf, this);
                }
                catch (DisconnectedException e3) {
                    Logger.normal(this, "Disconnected from " + next + " while waiting for data on " + this.uid);
                    continue block9;
                }
                if (logMINOR) {
                    Logger.minor(this, "second part got " + msg);
                }
                if (msg == null) {
                    Logger.normal(this, "request fatal-timeout (null) after accept (" + gotMessages + " messages; last=" + lastMessage + ")");
                    this.forwardRejectedOverload();
                    this.fireTimeout("Timeout");
                    return;
                }
                ++gotMessages;
                lastMessage = msg.getSpec().getName();
                if (msg.getSpec() == DMT.FNPRouteNotFound) {
                    Message sub;
                    short newHtl = msg.getShort("hopsToLive");
                    if (newHtl < this.htl) {
                        this.htl = newHtl;
                    }
                    if ((sub = msg.getSubMessage(DMT.FNPRHReturnSubMessage)) != null) {
                        double newBest = sub.getDouble("bestLocation");
                        if (newBest > this.target && newBest < this.best) {
                            this.best = newBest;
                        }
                        this.counter = (short)(this.counter + Math.max(0, sub.getShort("counter")));
                        this.uniqueCounter = (short)(this.uniqueCounter + Math.max(0, sub.getShort("uniqueCounter")));
                        continue block9;
                    }
                    this.counter = (short)(this.counter + 1);
                    this.uniqueCounter = (short)(this.uniqueCounter + 1);
                    this.htl = (short)(this.htl - 1);
                    continue block9;
                }
                if (msg.getSpec() == DMT.FNPRejectedOverload) {
                    this.forwardRejectedOverload();
                    ++rejectOverloads;
                    Message sub = msg.getSubMessage(DMT.FNPRHReturnSubMessage);
                    if (sub != null) {
                        double newBest = sub.getDouble("bestLocation");
                        if (newBest > this.target && newBest < this.best) {
                            this.best = newBest;
                        }
                        this.counter = (short)(this.counter + Math.max(0, sub.getShort("counter")));
                        this.uniqueCounter = (short)(this.uniqueCounter + Math.max(0, sub.getShort("uniqueCounter")));
                    }
                    if (!msg.getBoolean("isLocal")) continue;
                    if (!logMINOR) continue block9;
                    Logger.minor(this, "Local RejectedOverload, moving on to next peer");
                    continue block9;
                }
                if (msg.getSpec() == DMT.FNPRHProbeReply) {
                    double hisBest;
                    double hisNearest = msg.getDouble("nearestLocation");
                    if (Location.distance(hisNearest, this.target, true) < Location.distance(this.nearestLoc, this.target, true)) {
                        this.nearestLoc = hisNearest;
                    }
                    if ((hisBest = msg.getDouble("bestLocation")) > this.target && hisBest < this.best) {
                        this.best = hisBest;
                    }
                    this.counter = (short)(this.counter + (short)Math.max(0, msg.getShort("counter")));
                    this.uniqueCounter = (short)(this.uniqueCounter + (short)Math.max(0, msg.getShort("uniqueCounter")));
                    this.linearCounter = (short)(this.linearCounter + (short)Math.max(0, msg.getShort("linearCounter")));
                    this.fireCompletion();
                    return;
                }
                if (msg.getSpec() == DMT.FNPRHProbeTrace) {
                    this.fireTrace(msg.getDouble("nearestLocation"), msg.getDouble("bestLocation"), msg.getShort("hopsToLive"), msg.getShort("counter"), msg.getShort("uniqueCounter"), msg.getDouble("location"), msg.getLong("myUID"), (ShortBuffer)msg.getObject("peerLocations"), (ShortBuffer)msg.getObject("peerUIDs"), msg.getShort("linearCounter"), msg.getString("reason"), msg.getLong("prevUID"));
                    continue;
                }
                Logger.error(this, "Unexpected message: " + msg);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTrace(double nearest, double best, short htl, short counter, short uniqueCounter, double location, long myUID, ShortBuffer peerLocs, ShortBuffer peerUIDs, short linearCounter, String reason, long prevUID) {
        if (this.best > this.target && this.best < best) {
            best = this.best;
        }
        if (Location.distance(nearest, this.target, true) < Location.distance(this.nearestLoc, this.target, true)) {
            nearest = this.nearestLoc;
        }
        counter = (short)(counter + this.counter);
        uniqueCounter = (short)(uniqueCounter + this.uniqueCounter);
        linearCounter = (short)(linearCounter + this.linearCounter);
        ArrayList<Listener> arrayList = this.listeners;
        synchronized (arrayList) {
            for (Listener l : this.listeners) {
                try {
                    l.onTrace(this.uid, nearest, best, htl, counter, uniqueCounter, location, myUID, peerLocs, peerUIDs, (short)0, linearCounter, reason, prevUID);
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught: " + t, t);
                }
            }
        }
    }

    private MessageFilter makeDataFoundFilter(PeerNode next) {
        return MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(120000).setType(DMT.FNPRHProbeReply);
    }

    private Message createDataRequest() {
        return DMT.createFNPRHProbeRequest(this.uid, this.target, this.nearestLoc, this.best, this.htl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardRejectedOverload() {
        ProbeRequestSender probeRequestSender = this;
        synchronized (probeRequestSender) {
            if (this.hasForwardedRejectedOverload) {
                return;
            }
            this.hasForwardedRejectedOverload = true;
            this.notifyAll();
        }
        this.fireReceivedRejectOverload(this.nearestLoc, this.best, this.counter, this.uniqueCounter, this.linearCounter, "");
    }

    public short getHTL() {
        return this.htl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sentBytes(int x) {
        Object object = this.totalBytesSync;
        synchronized (object) {
            this.totalBytesSent += x;
        }
        this.node.nodeStats.probeRequestCtr.sentBytes(x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalSentBytes() {
        Object object = this.totalBytesSync;
        synchronized (object) {
            return this.totalBytesSent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedBytes(int x) {
        Object object = this.totalBytesSync;
        synchronized (object) {
            this.totalBytesReceived += x;
        }
        this.node.nodeStats.probeRequestCtr.receivedBytes(x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalReceivedBytes() {
        Object object = this.totalBytesSync;
        synchronized (object) {
            return this.totalBytesReceived;
        }
    }

    synchronized boolean hasForwarded() {
        return this.hasForwarded;
    }

    public void sentPayload(int x) {
        Logger.error(this, "sentPayload(" + x + ") in ResettingHTLProbeRequestSender ?!?!? for " + this, new Exception("error"));
    }

    public boolean isLocalRequestSearch() {
        return this.source == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener l) {
        ProbeRequestSender probeRequestSender = this;
        synchronized (probeRequestSender) {
            ArrayList<Listener> arrayList = this.listeners;
            synchronized (arrayList) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireReceivedRejectOverload(double nearest, double best, short counter, short uniqueCounter, short linearCounter, String reason) {
        ArrayList<Listener> arrayList = this.listeners;
        synchronized (arrayList) {
            for (Listener l : this.listeners) {
                try {
                    l.onReceivedRejectOverload(nearest, best, counter, uniqueCounter, linearCounter, reason);
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught: " + t, t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCompletion() {
        ArrayList<Listener> arrayList = this.listeners;
        synchronized (arrayList) {
            for (Listener l : this.listeners) {
                try {
                    l.onCompletion(this.nearestLoc, this.best, this.counter, this.uniqueCounter, this.linearCounter);
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught: " + t, t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRNF() {
        ArrayList<Listener> arrayList = this.listeners;
        synchronized (arrayList) {
            for (Listener l : this.listeners) {
                try {
                    l.onRNF(this.htl, this.nearestLoc, this.best, this.counter, this.uniqueCounter, this.linearCounter);
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught: " + t, t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTimeout(String reason) {
        ArrayList<Listener> arrayList = this.listeners;
        synchronized (arrayList) {
            for (Listener l : this.listeners) {
                try {
                    l.onTimeout(this.nearestLoc, this.best, this.counter, this.uniqueCounter, this.linearCounter, reason);
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught: " + t, t);
                }
            }
        }
    }

    private void updateBest() {
        PeerNode[] nodes;
        for (PeerNode node : nodes = this.node.peers.myPeers) {
            double loc;
            if (!node.isConnected() || (loc = node.getLocation()) < this.target || !(loc > this.target) || !(loc < this.best)) continue;
            this.best = loc;
        }
    }

    public int getPriority() {
        return 7;
    }

    double getBest() {
        return this.best;
    }

    public double getNearestLoc() {
        return this.nearestLoc;
    }

    static interface Listener {
        public void onReceivedRejectOverload(double var1, double var3, short var5, short var6, short var7, String var8) throws NotConnectedException;

        public void onTrace(long var1, double var3, double var5, short var7, short var8, short var9, double var10, long var12, ShortBuffer var14, ShortBuffer var15, short var16, short var17, String var18, long var19) throws NotConnectedException;

        public void onCompletion(double var1, double var3, short var5, short var6, short var7) throws NotConnectedException;

        public void onRNF(short var1, double var2, double var4, short var6, short var7, short var8) throws NotConnectedException;

        public void onTimeout(double var1, double var3, short var5, short var6, short var7, String var8) throws NotConnectedException;
    }
}

