/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.DMT;
import freenet.io.comm.Message;
import freenet.io.comm.NotConnectedException;
import freenet.node.LocationManager;
import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.node.ProbeRequestSender;
import freenet.support.ShortBuffer;

public class ProbeRequestHandler
implements ProbeRequestSender.Listener {
    final PeerNode source;
    final long uid;
    final ProbeRequestSender sender;

    ProbeRequestHandler(PeerNode source, long uid, ProbeRequestSender sender) {
        this.source = source;
        this.uid = uid;
        this.sender = sender;
    }

    static void start(Message m, PeerNode source, Node n, double target) {
        long uid = m.getLong("uid");
        double nearestLoc = m.getDouble("nearestLocation");
        double best = m.getDouble("bestLocation");
        short htl = m.getShort("hopsToLive");
        ProbeRequestSender sender = new ProbeRequestSender(target, htl, uid, n, nearestLoc, source, best);
        ProbeRequestHandler handler = new ProbeRequestHandler(source, uid, sender);
        sender.addListener(handler);
        PeerNode[] peers = n.peers.connectedPeers;
        Message accepted = DMT.createFNPAccepted(uid);
        Message trace = DMT.createFNPRHProbeTrace(uid, sender.getNearestLoc(), sender.getBest(), htl, (short)1, (short)1, n.getLocation(), n.swapIdentifier, LocationManager.extractLocs(peers, true), LocationManager.extractUIDs(peers), (short)0, (short)1, "", source.swapIdentifier);
        try {
            source.sendAsync(accepted, null, sender);
            source.sendAsync(trace, null, sender);
        }
        catch (NotConnectedException e) {
            return;
        }
        sender.start();
    }

    public void onCompletion(double nearest, double best, short counter, short uniqueCounter, short linearCounter) throws NotConnectedException {
        this.source.sendAsync(DMT.createFNPRHProbeReply(this.uid, nearest, best, counter, uniqueCounter, linearCounter), null, this.sender);
    }

    public void onRNF(short htl, double nearest, double best, short counter, short uniqueCounter, short linearCounter) throws NotConnectedException {
        Message rnf = DMT.createFNPRouteNotFound(this.uid, htl);
        Message sub = DMT.createFNPRHReturnSubMessage(nearest, best, counter, uniqueCounter, linearCounter, "rnf");
        rnf.addSubMessage(sub);
        this.source.sendAsync(rnf, null, this.sender);
    }

    public void onReceivedRejectOverload(double nearest, double best, short counter, short uniqueCounter, short linearCounter, String reason) throws NotConnectedException {
        Message ro = DMT.createFNPRejectedOverload(this.uid, false);
        Message sub = DMT.createFNPRHReturnSubMessage(nearest, best, counter, uniqueCounter, linearCounter, reason);
        ro.addSubMessage(sub);
        this.source.sendAsync(ro, null, this.sender);
    }

    public void onTimeout(double nearest, double best, short counter, short uniqueCounter, short linearCounter, String reason) throws NotConnectedException {
        Message ro = DMT.createFNPRejectedOverload(this.uid, true);
        Message sub = DMT.createFNPRHReturnSubMessage(nearest, best, counter, uniqueCounter, linearCounter, reason);
        ro.addSubMessage(sub);
        this.source.sendAsync(ro, null, this.sender);
    }

    public void onTrace(long uid, double nearest, double best, short htl, short counter, short uniqueCounter, double location, long myUID, ShortBuffer peerLocs, ShortBuffer peerUIDs, short forkCount, short linearCounter, String reason, long prevUID) throws NotConnectedException {
        Message trace = DMT.createFNPRHProbeTrace(uid, nearest, best, htl, counter, uniqueCounter, location, myUID, peerLocs, peerUIDs, forkCount, linearCounter, reason, prevUID);
        this.source.sendAsync(trace, null, this.sender);
    }
}

