/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.Peer;
import freenet.io.xfer.PacketThrottle;
import freenet.node.PeerNode;
import freenet.node.SeedClientPeerNode;
import freenet.node.SeedServerPeerNode;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeerNodeStatus {
    private final String peerAddress;
    private final int peerPort;
    private final int statusValue;
    private final String statusName;
    private final String statusCSSName;
    private final double location;
    private final double[] peersLocation;
    private final String version;
    private final int simpleVersion;
    private final int routingBackoffLength;
    private final long routingBackedOffUntil;
    private final boolean connected;
    private final boolean routable;
    private final boolean isFetchingARK;
    private final boolean isOpennet;
    private final double averagePingTime;
    private final boolean publicInvalidVersion;
    private final boolean publicReverseInvalidVersion;
    private final double backedOffPercent;
    private String lastBackoffReason;
    private long timeLastRoutable;
    private long timeLastConnectionCompleted;
    private long peerAddedTime;
    private Map<String, Long> localMessagesReceived;
    private Map<String, Long> localMessagesSent;
    private final int hashCode;
    private final double pReject;
    private long totalBytesIn;
    private long totalBytesOut;
    private long totalBytesInSinceStartup;
    private long totalBytesOutSinceStartup;
    private double percentTimeRoutableConnection;
    private PacketThrottle throttle;
    private long clockDelta;
    private final boolean recordStatus;
    private final boolean isSeedServer;
    private final boolean isSeedClient;
    private final boolean isSearchable;
    private final long resendBytesSent;
    private final int reportedUptimePercentage;
    private final double selectionRate;

    PeerNodeStatus(PeerNode peerNode, boolean noHeavy) {
        Peer p = peerNode.getPeer();
        if (p == null) {
            this.peerAddress = null;
            this.peerPort = -1;
        } else {
            this.peerAddress = p.getFreenetAddress().toString();
            this.peerPort = p.getPort();
        }
        this.selectionRate = peerNode.selectionRate();
        this.statusValue = peerNode.getPeerNodeStatus();
        this.statusName = peerNode.getPeerNodeStatusString();
        this.statusCSSName = peerNode.getPeerNodeStatusCSSClassName();
        this.location = peerNode.getLocation();
        this.peersLocation = peerNode.getPeersLocation();
        this.version = peerNode.getVersion();
        this.simpleVersion = peerNode.getSimpleVersion();
        this.routingBackoffLength = peerNode.getRoutingBackoffLength();
        this.routingBackedOffUntil = peerNode.getRoutingBackedOffUntil();
        this.connected = peerNode.isConnected();
        this.routable = peerNode.isRoutable();
        this.isFetchingARK = peerNode.isFetchingARK();
        this.isOpennet = peerNode.isOpennet();
        this.averagePingTime = peerNode.averagePingTime();
        this.publicInvalidVersion = peerNode.publicInvalidVersion();
        this.publicReverseInvalidVersion = peerNode.publicReverseInvalidVersion();
        this.backedOffPercent = peerNode.backedOffPercent.currentValue();
        this.lastBackoffReason = peerNode.getLastBackoffReason();
        this.timeLastRoutable = peerNode.timeLastRoutable();
        this.timeLastConnectionCompleted = peerNode.timeLastConnectionCompleted();
        this.peerAddedTime = peerNode.getPeerAddedTime();
        if (!noHeavy) {
            this.localMessagesReceived = peerNode.getLocalNodeReceivedMessagesFromStatistic();
            this.localMessagesSent = peerNode.getLocalNodeSentMessagesToStatistic();
        } else {
            this.localMessagesReceived = null;
            this.localMessagesSent = null;
        }
        this.hashCode = peerNode.hashCode;
        this.pReject = peerNode.getPRejected();
        this.totalBytesIn = peerNode.getTotalInputBytes();
        this.totalBytesOut = peerNode.getTotalOutputBytes();
        this.totalBytesInSinceStartup = peerNode.getTotalInputSinceStartup();
        this.totalBytesOutSinceStartup = peerNode.getTotalOutputSinceStartup();
        this.percentTimeRoutableConnection = peerNode.getPercentTimeRoutableConnection();
        this.throttle = peerNode.getThrottle();
        this.clockDelta = peerNode.getClockDelta();
        this.recordStatus = peerNode.recordStatus();
        this.isSeedClient = peerNode instanceof SeedClientPeerNode;
        this.isSeedServer = peerNode instanceof SeedServerPeerNode;
        this.isSearchable = peerNode.isRealConnection();
        this.resendBytesSent = peerNode.getResendBytesSent();
        this.reportedUptimePercentage = peerNode.getUptime();
    }

    public Map<String, Long> getLocalMessagesReceived() {
        return this.localMessagesReceived;
    }

    public Map<String, Long> getLocalMessagesSent() {
        return this.localMessagesSent;
    }

    public long getPeerAddedTime() {
        return this.peerAddedTime;
    }

    public static int getPeerStatusCount(PeerNodeStatus[] peerNodeStatuses, int status) {
        int count = 0;
        int peerCount = peerNodeStatuses.length;
        for (int peerIndex = 0; peerIndex < peerCount; ++peerIndex) {
            if (peerNodeStatuses[peerIndex].getStatusValue() != status) continue;
            ++count;
        }
        return count;
    }

    public long getTimeLastConnectionCompleted() {
        return this.timeLastConnectionCompleted;
    }

    public double getBackedOffPercent() {
        return this.backedOffPercent;
    }

    public String getLastBackoffReason() {
        return this.lastBackoffReason;
    }

    public long getTimeLastRoutable() {
        return this.timeLastRoutable;
    }

    public boolean isPublicInvalidVersion() {
        return this.publicInvalidVersion;
    }

    public boolean isPublicReverseInvalidVersion() {
        return this.publicReverseInvalidVersion;
    }

    public double getAveragePingTime() {
        return this.averagePingTime;
    }

    public long getRoutingBackedOffUntil() {
        return this.routingBackedOffUntil;
    }

    public double getLocation() {
        return this.location;
    }

    public double[] getPeersLocation() {
        return this.peersLocation;
    }

    public String getPeerAddress() {
        return this.peerAddress;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public int getRoutingBackoffLength() {
        return this.routingBackoffLength;
    }

    public String getStatusCSSName() {
        return this.statusCSSName;
    }

    public String getStatusName() {
        return this.statusName;
    }

    public int getStatusValue() {
        return this.statusValue;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isRoutable() {
        return this.routable;
    }

    public boolean isFetchingARK() {
        return this.isFetchingARK;
    }

    public boolean isOpennet() {
        return this.isOpennet;
    }

    public int getSimpleVersion() {
        return this.simpleVersion;
    }

    public String toString() {
        return this.statusName + ' ' + this.peerAddress + ':' + this.peerPort + ' ' + this.location + ' ' + this.version + " backoff: " + this.routingBackoffLength + " (" + Math.max(this.routingBackedOffUntil - System.currentTimeMillis(), 0L) + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public double getPReject() {
        return this.pReject;
    }

    public long getTotalInputBytes() {
        return this.totalBytesIn;
    }

    public long getTotalOutputBytes() {
        return this.totalBytesOut;
    }

    public long getTotalInputSinceStartup() {
        return this.totalBytesInSinceStartup;
    }

    public long getTotalOutputSinceStartup() {
        return this.totalBytesOutSinceStartup;
    }

    public double getPercentTimeRoutableConnection() {
        return this.percentTimeRoutableConnection;
    }

    public PacketThrottle getThrottle() {
        return this.throttle;
    }

    public long getClockDelta() {
        return this.clockDelta;
    }

    public boolean recordStatus() {
        return this.recordStatus;
    }

    public boolean isSeedServer() {
        return this.isSeedServer;
    }

    public boolean isSeedClient() {
        return this.isSeedClient;
    }

    public boolean isSearchable() {
        return this.isSearchable;
    }

    public long getResendBytesSent() {
        return this.resendBytesSent;
    }

    public int getReportedUptimePercentage() {
        return this.reportedUptimePercentage;
    }

    public double getSelectionRate() {
        return this.selectionRate;
    }
}

