/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.client.FetchResult;
import freenet.client.async.USKRetriever;
import freenet.client.async.USKRetrieverCallback;
import freenet.crypt.BlockCipher;
import freenet.crypt.DSA;
import freenet.crypt.DSAGroup;
import freenet.crypt.DSAPublicKey;
import freenet.crypt.DSASignature;
import freenet.crypt.Global;
import freenet.crypt.HMAC;
import freenet.crypt.KeyAgreementSchemeContext;
import freenet.crypt.SHA256;
import freenet.crypt.UnsupportedCipherException;
import freenet.crypt.ciphers.Rijndael;
import freenet.io.comm.AsyncMessageCallback;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.FreenetInetAddress;
import freenet.io.comm.Message;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.PacketSocketHandler;
import freenet.io.comm.Peer;
import freenet.io.comm.PeerContext;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.io.comm.SocketHandler;
import freenet.io.xfer.PacketThrottle;
import freenet.io.xfer.ThrottleDeprecatedException;
import freenet.io.xfer.WaitedTooLongException;
import freenet.keys.ClientSSK;
import freenet.keys.FreenetURI;
import freenet.keys.Key;
import freenet.keys.USK;
import freenet.node.BlockedTooLongException;
import freenet.node.DarknetPeerNode;
import freenet.node.FSParseException;
import freenet.node.KeyChangedException;
import freenet.node.Location;
import freenet.node.MessageItem;
import freenet.node.NetworkIDManager;
import freenet.node.Node;
import freenet.node.NodeCrypto;
import freenet.node.OpennetManager;
import freenet.node.OpennetPeerNode;
import freenet.node.OutgoingPacketMangler;
import freenet.node.PacketSequenceException;
import freenet.node.PacketTracker;
import freenet.node.PeerManager;
import freenet.node.PeerMessageQueue;
import freenet.node.PeerNodeStatus;
import freenet.node.RequestSender;
import freenet.node.ResendPacketItem;
import freenet.node.SessionKey;
import freenet.node.SyncSendWaitedTooLongException;
import freenet.node.Version;
import freenet.node.VersionParseException;
import freenet.support.Base64;
import freenet.support.Fields;
import freenet.support.HexUtil;
import freenet.support.IllegalBase64Exception;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.TimeUtil;
import freenet.support.WouldBlockException;
import freenet.support.math.RunningAverage;
import freenet.support.math.SimpleRunningAverage;
import freenet.support.math.TimeDecayingRunningAverage;
import freenet.support.transport.ip.HostnameSyntaxException;
import freenet.support.transport.ip.IPUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.i2p.util.NativeBigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PeerNode
implements PeerContext,
USKRetrieverCallback {
    private String lastGoodVersion;
    protected boolean unroutableOlderVersion;
    protected boolean unroutableNewerVersion;
    protected boolean disableRouting;
    protected boolean disableRoutingHasBeenSetLocally;
    protected boolean disableRoutingHasBeenSetRemotely;
    private byte[] jfkBuffer;
    protected byte[] jfkKa;
    protected byte[] jfkKe;
    protected byte[] jfkKs;
    protected byte[] jfkMyRef;
    protected long jfkContextLifetime;
    private Peer detectedPeer;
    private final OutgoingPacketMangler outgoingMangler;
    protected Vector<Peer> nominalPeer;
    private Peer remoteDetectedPeer;
    public final boolean testnetEnabled;
    private SessionKey currentTracker;
    private SessionKey previousTracker;
    private long timeLastRekeyed;
    private long totalBytesExchangedWithCurrentTracker;
    private boolean isRekeying;
    private SessionKey unverifiedTracker;
    private long timeLastSentPacket;
    private long timeLastReceivedPacket;
    private long timeLastReceivedDataPacket;
    private long timeLastConnected;
    private long timeLastRoutable;
    private long timeAddedOrRestarted;
    private long countSelectionsSinceConnected;
    public static final int SELECTION_SAMPLING_PERIOD = 300000;
    public static final int SELECTION_PERCENTAGE_WARNING = 30;
    public static final int SELECTION_MIN_PEERS = 5;
    public static final int SELECTION_MAX_SAMPLES = 3000;
    private boolean isConnected;
    private boolean isRoutable;
    private boolean wasDisconnected;
    private USKRetriever arkFetcher;
    private USK myARK;
    private int handshakeCount;
    private static final int MAX_HANDSHAKE_COUNT = 2;
    private double currentLocation;
    private double[] currentPeersLocation;
    private long locSetTime;
    final byte[] identity;
    final String identityAsBase64String;
    final byte[] identityHash;
    final byte[] identityHashHash;
    final long swapIdentifier;
    int[] negTypes;
    final int hashCode;
    final Node node;
    final PeerManager peers;
    private final PeerMessageQueue messageQueue;
    private long timeLastReceivedSwapRequest;
    private final RunningAverage swapRequestsInterval;
    private long timeLastReceivedProbeRequest;
    private final RunningAverage probeRequestsInterval;
    final boolean decrementHTLAtMaximum;
    final boolean decrementHTLAtMinimum;
    protected long sendHandshakeTime;
    private long nextMessageRequeueLogTime;
    private long messageRequeueLogRateLimitInterval;
    private int messageRequeueLogRateLimitThreshold;
    private String version;
    private long totalInputSinceStartup;
    private long totalOutputSinceStartup;
    final DSAGroup peerCryptoGroup;
    final DSAPublicKey peerPubKey;
    private boolean isSignatureVerificationSuccessfull;
    final byte[] incomingSetupKey;
    final byte[] outgoingSetupKey;
    final BlockCipher incomingSetupCipher;
    final BlockCipher outgoingSetupCipher;
    final BlockCipher anonymousInitiatorSetupCipher;
    private KeyAgreementSchemeContext ctx;
    private long bootID;
    private boolean bogusNoderef;
    private long connectedTime;
    public int peerNodeStatus;
    static final int CHECK_FOR_SWAPPED_TRACKERS_INTERVAL = 120000;
    static final byte[] TEST_AS_BYTES;
    private final Hashtable<String, Long> localNodeSentMessageTypes;
    private final Hashtable<String, Long> localNodeReceivedMessageTypes;
    private Peer[] handshakeIPs;
    private long lastAttemptedHandshakeIPUpdateTime;
    private boolean neverConnected;
    private long peerAddedTime;
    private TimeDecayingRunningAverage pRejected;
    private long totalBytesIn;
    private long totalBytesOut;
    private long hadRoutableConnectionCount;
    private long routableConnectionCheckCount;
    private long clockDelta;
    private byte uptime;
    private static final long MAX_CLOCK_DELTA = 86400000L;
    private static final long CLEAR_MESSAGE_QUEUE_AFTER = 3600000L;
    final WeakReference<PeerNode> myRef;
    private boolean disconnecting;
    long timeLastDisconnect;
    long timePrevDisconnect;
    private boolean isBursting;
    private int listeningHandshakeBurstCount;
    private int listeningHandshakeBurstSize;
    protected NodeCrypto crypto;
    public static final int BLACK_MAGIC_BACKOFF_PRUNING_TIME = 300000;
    public static final double BLACK_MAGIC_BACKOFF_PRUNING_PERCENTAGE = 0.9;
    protected final HashMap<Peer, byte[]> jfkNoncesSent;
    private static volatile boolean logMINOR;
    private boolean forceDisconnectCalled;
    boolean firstHandshake;
    private boolean burstNow;
    private long timeSetBurstNow;
    static final int UPDATE_BURST_NOW_PERIOD = 300000;
    static final int P_BURST_IF_DEFINITELY_FORWARDED = 20;
    private String shortToString;
    private volatile Object arkFetcherSync;
    boolean sentInitialMessages;
    private int simpleVersion;
    long routingBackedOffUntil;
    static final int INITIAL_ROUTING_BACKOFF_LENGTH = 1000;
    static final int BACKOFF_MULTIPLIER = 2;
    static final int MAX_ROUTING_BACKOFF_LENGTH = 10800000;
    long transferBackedOffUntil;
    static final int INITIAL_TRANSFER_BACKOFF_LENGTH = 30000;
    static final int TRANSFER_BACKOFF_MULTIPLIER = 2;
    static final int MAX_TRANSFER_BACKOFF_LENGTH = 10800000;
    int transferBackoffLength;
    int routingBackoffLength;
    String lastRoutingBackoffReason;
    String previousRoutingBackoffReason;
    public final RunningAverage backedOffPercent;
    private long lastSampleTime;
    Object pingSync;
    static final int MAX_PINGS = 5;
    long pingNumber;
    private final RunningAverage pingAverage;
    private PacketThrottle _lastThrottle;
    static final short TRACK_PACKETS = 64;
    private final long[] packetsSentTimes;
    private final long[] packetsRecvTimes;
    private final long[] packetsSentHashes;
    private final long[] packetsRecvHashes;
    private short sentPtr;
    private short recvPtr;
    private boolean sentTrackPackets;
    private boolean recvTrackPackets;
    static final int SENT_PACKETS_MAX_TIME_AFTER_CONNECT = 300000;
    private boolean manyPacketsClaimedSentNotReceived;
    static final int MAX_SIMULTANEOUS_ANNOUNCEMENTS = 1;
    static final int MAX_ANNOUNCE_DELAY = 1000;
    private long timeLastAcceptedAnnouncement;
    private long[] runningAnnounceUIDs;
    private int handshakeIPAlternator;
    int assignedNetworkID;
    int providedNetworkID;
    NetworkIDManager.PeerNetworkGroup networkGroup;
    private long resendBytesSent;
    public final ByteCounter resendByteCounter;
    private volatile long offeredMainJarVersion;
    private volatile long offeredExtJarVersion;
    static final int MAX_TURTLES_PER_PEER = 3;
    private HashMap<Key, RequestSender> turtlingTransfers;

    protected abstract boolean generateIdentityFromPubkey();

    protected boolean ignoreLastGoodVersion() {
        return false;
    }

    public PeerNode(SimpleFieldSet fs, Node node2, NodeCrypto crypto, PeerManager peers, boolean fromLocal, boolean fromAnonymousInitiator, OutgoingPacketMangler mangler, boolean isOpennet) throws FSParseException, PeerParseException, ReferenceSignatureVerificationException {
        block62: {
            int i;
            block61: {
                this.jfkContextLifetime = 0L;
                this.totalBytesExchangedWithCurrentTracker = 0L;
                this.isRekeying = false;
                this.countSelectionsSinceConnected = 0L;
                this.wasDisconnected = true;
                this.messageRequeueLogRateLimitInterval = 1000L;
                this.messageRequeueLogRateLimitThreshold = 15;
                this.peerNodeStatus = 5;
                this.localNodeSentMessageTypes = new Hashtable();
                this.localNodeReceivedMessageTypes = new Hashtable();
                this.peerAddedTime = 1L;
                this.jfkNoncesSent = new HashMap();
                this.forceDisconnectCalled = false;
                this.firstHandshake = true;
                this.arkFetcherSync = new Object();
                this.routingBackedOffUntil = -1L;
                this.transferBackedOffUntil = -1L;
                this.transferBackoffLength = 30000;
                this.routingBackoffLength = 1000;
                this.lastSampleTime = Long.MAX_VALUE;
                this.pingSync = new Object();
                this.packetsSentTimes = new long[64];
                this.packetsRecvTimes = new long[64];
                this.packetsSentHashes = new long[64];
                this.packetsRecvHashes = new long[64];
                this.manyPacketsClaimedSentNotReceived = false;
                this.runningAnnounceUIDs = new long[0];
                this.resendByteCounter = new ByteCounter(){

                    public void receivedBytes(int x) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void sentBytes(int x) {
                        PeerNode peerNode = PeerNode.this;
                        synchronized (peerNode) {
                            PeerNode.this.resendBytesSent += x;
                        }
                        PeerNode.this.node.nodeStats.resendByteCounter.sentBytes(x);
                    }

                    public void sentPayload(int x) {
                    }
                };
                this.turtlingTransfers = new HashMap();
                boolean noSig = false;
                if (fromLocal || fromAnonymousInitiator) {
                    noSig = true;
                }
                this.myRef = new WeakReference<PeerNode>(this);
                this.outgoingMangler = mangler;
                this.node = node2;
                this.crypto = crypto;
                this.peers = peers;
                this.backedOffPercent = new TimeDecayingRunningAverage(0.0, 180000L, 0.0, 1.0, this.node);
                this.version = fs.get("version");
                Version.seenVersion(this.version);
                try {
                    this.simpleVersion = Version.getArbitraryBuildNumber(this.version);
                }
                catch (VersionParseException e2) {
                    throw new FSParseException("Invalid version " + this.version + " : " + e2);
                }
                String locationString = fs.get("location");
                String[] peerLocationsString = fs.getAll("peersLocation");
                this.currentLocation = Location.getLocation(locationString);
                if (peerLocationsString != null) {
                    double[] peerLocations = new double[peerLocationsString.length];
                    for (int i2 = 0; i2 < peerLocationsString.length; ++i2) {
                        peerLocations[i2] = Location.getLocation(peerLocationsString[i2]);
                    }
                    this.currentPeersLocation = peerLocations;
                }
                this.locSetTime = System.currentTimeMillis();
                this.disableRoutingHasBeenSetLocally = false;
                this.disableRouting = false;
                this.disableRoutingHasBeenSetRemotely = false;
                this.lastGoodVersion = fs.get("lastGoodVersion");
                this.updateVersionRoutablity();
                this.testnetEnabled = fs.getBoolean("testnet", false);
                if (this.node.testnetEnabled != this.testnetEnabled) {
                    String err = "Ignoring incompatible node " + this.detectedPeer + " - peer.testnet=" + this.testnetEnabled + '(' + fs.get("testnet") + ") but node.testnet=" + this.node.testnetEnabled;
                    Logger.error(this, err);
                    throw new PeerParseException(err);
                }
                this.negTypes = fs.getIntArray("auth.negTypes");
                if (this.negTypes == null || this.negTypes.length == 0) {
                    if (fromAnonymousInitiator) {
                        this.negTypes = mangler.supportedNegTypes();
                    } else {
                        throw new FSParseException("No negTypes!");
                    }
                }
                if (fs.getBoolean("opennet", false) != isOpennet) {
                    throw new FSParseException("Trying to parse a darknet peer as opennet or an opennet peer as darknet");
                }
                try {
                    SimpleFieldSet sfs = fs.subset("dsaGroup");
                    if (sfs == null) {
                        throw new FSParseException("No dsaGroup - very old reference?");
                    }
                    this.peerCryptoGroup = DSAGroup.create(sfs);
                    sfs = fs.subset("dsaPubKey");
                    if (sfs == null || this.peerCryptoGroup == null) {
                        throw new FSParseException("No dsaPubKey - very old reference?");
                    }
                    this.peerPubKey = DSAPublicKey.create(sfs, this.peerCryptoGroup);
                    String signature = fs.get("sig");
                    fs.removeValue("sig");
                    if (!noSig) {
                        try {
                            boolean failed = false;
                            if (signature == null || this.peerCryptoGroup == null || this.peerPubKey == null || (failed = !DSA.verify(this.peerPubKey, new DSASignature(signature), new BigInteger(1, SHA256.digest(fs.toOrderedString().getBytes("UTF-8"))), false))) {
                                String errCause = "";
                                if (signature == null) {
                                    errCause = errCause + " (No signature)";
                                }
                                if (this.peerCryptoGroup == null) {
                                    errCause = errCause + " (No peer crypto group)";
                                }
                                if (this.peerPubKey == null) {
                                    errCause = errCause + " (No peer public key)";
                                }
                                if (failed) {
                                    errCause = errCause + " (VERIFICATION FAILED)";
                                }
                                Logger.error(this, "The integrity of the reference has been compromized!" + errCause + " fs was\n" + fs.toOrderedString());
                                this.isSignatureVerificationSuccessfull = false;
                                fs.putSingle("sig", signature);
                                throw new ReferenceSignatureVerificationException("The integrity of the reference has been compromized!" + errCause);
                            }
                            this.isSignatureVerificationSuccessfull = true;
                            break block61;
                        }
                        catch (NumberFormatException e) {
                            Logger.error(this, "Invalid reference: " + e, e);
                            throw new ReferenceSignatureVerificationException("The node reference you added is invalid: It does not have a valid signature.");
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
                        }
                    }
                    this.isSignatureVerificationSuccessfull = true;
                }
                catch (IllegalBase64Exception e) {
                    Logger.error(this, "Caught " + e, e);
                    throw new FSParseException(e);
                }
            }
            if (!this.generateIdentityFromPubkey()) {
                String identityString = fs.get("identity");
                if (identityString == null) {
                    throw new PeerParseException("No identity!");
                }
                try {
                    this.identity = Base64.decode(identityString);
                }
                catch (NumberFormatException e) {
                    throw new FSParseException(e);
                }
                catch (IllegalBase64Exception e) {
                    throw new FSParseException(e);
                }
            } else {
                this.identity = this.peerPubKey.asBytesHash();
            }
            if (this.identity == null) {
                throw new FSParseException("No identity");
            }
            this.identityAsBase64String = Base64.encode(this.identity);
            this.identityHash = SHA256.digest(this.identity);
            this.identityHashHash = SHA256.digest(this.identityHash);
            this.swapIdentifier = Fields.bytesToLong(this.identityHashHash);
            this.hashCode = Fields.hashCode(this.identityHash);
            byte[] nodeKey = crypto.identityHash;
            byte[] nodeKeyHash = crypto.identityHashHash;
            int digestLength = SHA256.getDigestLength();
            this.incomingSetupKey = new byte[digestLength];
            for (i = 0; i < this.incomingSetupKey.length; ++i) {
                this.incomingSetupKey[i] = (byte)(nodeKey[i] ^ this.identityHashHash[i]);
            }
            this.outgoingSetupKey = new byte[digestLength];
            for (i = 0; i < this.outgoingSetupKey.length; ++i) {
                this.outgoingSetupKey[i] = (byte)(nodeKeyHash[i] ^ this.identityHash[i]);
            }
            if (logMINOR) {
                Logger.minor(this, "Keys:\nIdentity:  " + HexUtil.bytesToHex(crypto.myIdentity) + "\nThisIdent: " + HexUtil.bytesToHex(this.identity) + "\nNode:      " + HexUtil.bytesToHex(nodeKey) + "\nNode hash: " + HexUtil.bytesToHex(nodeKeyHash) + "\nThis:      " + HexUtil.bytesToHex(this.identityHash) + "\nThis hash: " + HexUtil.bytesToHex(this.identityHashHash) + "\nFor:       " + this.getPeer());
            }
            try {
                this.incomingSetupCipher = new Rijndael(256, 256);
                this.incomingSetupCipher.initialize(this.incomingSetupKey);
                this.outgoingSetupCipher = new Rijndael(256, 256);
                this.outgoingSetupCipher.initialize(this.outgoingSetupKey);
                this.anonymousInitiatorSetupCipher = new Rijndael(256, 256);
                this.anonymousInitiatorSetupCipher.initialize(this.identityHash);
            }
            catch (UnsupportedCipherException e1) {
                Logger.error(this, "Caught: " + e1);
                throw new Error(e1);
            }
            this.nominalPeer = new Vector();
            try {
                String[] physical = fs.getAll("physical.udp");
                if (physical == null) break block62;
                for (int i3 = 0; i3 < physical.length; ++i3) {
                    Peer p;
                    try {
                        p = new Peer(physical[i3], true, true);
                    }
                    catch (HostnameSyntaxException e) {
                        if (fromLocal) {
                            Logger.error(this, "Invalid hostname or IP Address syntax error while parsing peer reference in local peers list: " + physical[i3]);
                        }
                        System.err.println("Invalid hostname or IP Address syntax error while parsing peer reference: " + physical[i3]);
                        continue;
                    }
                    if (this.nominalPeer.contains(p)) continue;
                    this.nominalPeer.addElement(p);
                }
            }
            catch (Exception e1) {
                throw new FSParseException(e1);
            }
        }
        if (this.nominalPeer.isEmpty()) {
            Logger.normal(this, "No IP addresses found for identity '" + this.identityAsBase64String + "', possibly at location '" + Double.toString(this.currentLocation) + ": " + this.userToString());
            this.detectedPeer = null;
        } else {
            this.detectedPeer = this.nominalPeer.firstElement();
        }
        this.updateShortToString();
        this.currentTracker = null;
        this.previousTracker = null;
        this.timeLastSentPacket = -1L;
        this.timeLastReceivedPacket = -1L;
        this.timeLastReceivedSwapRequest = -1L;
        this.timeLastConnected = -1L;
        this.timeLastRoutable = -1L;
        this.timeAddedOrRestarted = System.currentTimeMillis();
        this.swapRequestsInterval = new SimpleRunningAverage(50, 900.0);
        this.probeRequestsInterval = new SimpleRunningAverage(50, 1000.0);
        this.isConnected = false;
        this.messageQueue = new PeerMessageQueue();
        this.decrementHTLAtMaximum = (double)this.node.random.nextFloat() < 0.1;
        this.decrementHTLAtMinimum = (double)this.node.random.nextFloat() < 0.25;
        this.pingNumber = this.node.random.nextLong();
        this.pingAverage = new TimeDecayingRunningAverage(1.0, 30000L, 0.0, 3.15576E10, this.node);
        this.pRejected = new TimeDecayingRunningAverage(0.0, 240000L, 0.0, 1.0, this.node);
        this.parseARK(fs, true, false);
        long now = System.currentTimeMillis();
        if (fromLocal) {
            SimpleFieldSet metadata = fs.subset("metadata");
            if (metadata != null) {
                long tempRoutableConnectionCheckCount;
                long tempHadRoutableConnectionCount;
                String tempHadRoutableConnectionCountString;
                long tempPeerAddedTime;
                String tempPeerAddedTimeString;
                String tempTimeLastRoutableString;
                String tempTimeLastConnectedString;
                Peer p;
                try {
                    String detectedUDPString = metadata.get("detected.udp");
                    p = null;
                    if (detectedUDPString != null) {
                        p = new Peer(detectedUDPString, false);
                    }
                }
                catch (UnknownHostException e) {
                    p = null;
                    Logger.error(this, "detected.udp = " + metadata.get("detected.udp") + " - " + e, e);
                }
                catch (PeerParseException e) {
                    p = null;
                    Logger.error(this, "detected.udp = " + metadata.get("detected.udp") + " - " + e, e);
                }
                if (p != null) {
                    this.detectedPeer = p;
                }
                this.updateShortToString();
                String tempTimeLastReceivedPacketString = metadata.get("timeLastReceivedPacket");
                if (tempTimeLastReceivedPacketString != null) {
                    long tempTimeLastReceivedPacket;
                    this.timeLastReceivedPacket = tempTimeLastReceivedPacket = Fields.parseLong(tempTimeLastReceivedPacketString, -1L);
                }
                if ((tempTimeLastConnectedString = metadata.get("timeLastConnected")) != null) {
                    long tempTimeLastConnected;
                    this.timeLastConnected = tempTimeLastConnected = Fields.parseLong(tempTimeLastConnectedString, -1L);
                }
                if ((tempTimeLastRoutableString = metadata.get("timeLastRoutable")) != null) {
                    long tempTimeLastRoutable;
                    this.timeLastRoutable = tempTimeLastRoutable = Fields.parseLong(tempTimeLastRoutableString, -1L);
                }
                if (this.timeLastConnected < 1L && this.timeLastReceivedPacket > 1L) {
                    this.timeLastConnected = this.timeLastReceivedPacket;
                }
                if (this.timeLastRoutable < 1L && this.timeLastReceivedPacket > 1L) {
                    this.timeLastRoutable = this.timeLastReceivedPacket;
                }
                this.peerAddedTime = (tempPeerAddedTimeString = metadata.get("peerAddedTime")) != null ? (tempPeerAddedTime = Fields.parseLong(tempPeerAddedTimeString, 0L)) : 0L;
                this.neverConnected = Fields.stringToBool(metadata.get("neverConnected"), false);
                if (now - this.peerAddedTime > 2592000000L) {
                    this.peerAddedTime = 0L;
                }
                if (!this.neverConnected) {
                    this.peerAddedTime = 0L;
                }
                this.hadRoutableConnectionCount = (tempHadRoutableConnectionCountString = metadata.get("hadRoutableConnectionCount")) != null ? (tempHadRoutableConnectionCount = Fields.parseLong(tempHadRoutableConnectionCountString, 0L)) : 0L;
                String tempRoutableConnectionCheckCountString = metadata.get("routableConnectionCheckCount");
                this.routableConnectionCheckCount = tempRoutableConnectionCheckCountString != null ? (tempRoutableConnectionCheckCount = Fields.parseLong(tempRoutableConnectionCheckCountString, 0L)) : 0L;
            }
        } else {
            this.neverConnected = true;
            this.peerAddedTime = now;
        }
        this.lastAttemptedHandshakeIPUpdateTime = 0L;
        this.maybeUpdateHandshakeIPs(true);
        this.listeningHandshakeBurstCount = 0;
        this.listeningHandshakeBurstSize = 1 + this.node.random.nextInt(3);
        if (this.isBurstOnly()) {
            Logger.minor(this, "First BurstOnly mode handshake in " + (this.sendHandshakeTime - now) + "ms for " + this.shortToString() + " (count: " + this.listeningHandshakeBurstCount + ", size: " + this.listeningHandshakeBurstSize + ')');
        }
        if (fromLocal) {
            this.innerCalcNextHandshake(false, false, now);
        } else {
            this.sendHandshakeTime = now;
        }
        this.totalInputSinceStartup = fs.getLong("totalInput", 0L);
        this.totalOutputSinceStartup = fs.getLong("totalOutput", 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseARK(SimpleFieldSet fs, boolean onStartup, boolean forDiffNodeRef) {
        USK ark;
        block14: {
            ark = null;
            long arkNo = 0L;
            try {
                String arkPubKey = fs.get("ark.pubURI");
                if (onStartup && arkPubKey != null) {
                    while (arkPubKey.matches(".*-\\d+$")) {
                        arkPubKey = arkPubKey.replaceAll("-\\d+$", "");
                    }
                }
                arkNo = fs.getLong("ark.number", -1L);
                if (arkPubKey == null && arkNo <= -1L) {
                    return false;
                }
                if (arkPubKey != null && arkNo > -1L) {
                    if (onStartup) {
                        ++arkNo;
                    }
                    FreenetURI uri = new FreenetURI(arkPubKey);
                    ClientSSK ssk = new ClientSSK(uri);
                    ark = new USK(ssk, arkNo);
                    break block14;
                }
                if (forDiffNodeRef && arkPubKey == null && this.myARK != null && arkNo > -1L) {
                    ark = this.myARK.copy(arkNo);
                    break block14;
                }
                if (forDiffNodeRef && arkPubKey != null && this.myARK != null && arkNo <= -1L) {
                    Logger.error(this, "Got a differential node reference from " + this + " with an arkPubKey but no ARK edition");
                    return false;
                }
                return false;
            }
            catch (MalformedURLException e) {
                Logger.error(this, "Couldn't parse ARK info for " + this + ": " + e, e);
            }
            catch (NumberFormatException e) {
                Logger.error(this, "Couldn't parse ARK info for " + this + ": " + e, e);
            }
        }
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (ark != null && (this.myARK == null || this.myARK != ark && !this.myARK.equals(ark))) {
                this.myARK = ark;
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized Peer getPeer() {
        return this.detectedPeer;
    }

    protected synchronized Peer[] getHandshakeIPs() {
        return this.handshakeIPs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String handshakeIPsToString() {
        Peer[] localHandshakeIPs;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            localHandshakeIPs = this.handshakeIPs;
        }
        if (localHandshakeIPs == null) {
            return "null";
        }
        StringBuilder toOutputString = new StringBuilder(1024);
        boolean needSep = false;
        toOutputString.append("[ ");
        for (int i = 0; i < localHandshakeIPs.length; ++i) {
            if (needSep) {
                toOutputString.append(", ");
            }
            if (localHandshakeIPs[i] == null) {
                toOutputString.append("null");
                needSep = true;
                continue;
            }
            toOutputString.append('\'');
            toOutputString.append(localHandshakeIPs[i].getAddress(false));
            toOutputString.append('\'');
            needSep = true;
        }
        toOutputString.append(" ]");
        return toOutputString.toString();
    }

    private Peer[] updateHandshakeIPs(Peer[] localHandshakeIPs, boolean ignoreHostnames) {
        for (int i = 0; i < localHandshakeIPs.length; ++i) {
            if (ignoreHostnames) {
                if (logMINOR) {
                    Logger.debug(this, "updateHandshakeIPs: calling getAddress(false) on Peer '" + localHandshakeIPs[i] + "' for " + this.shortToString() + " (" + ignoreHostnames + ')');
                }
                localHandshakeIPs[i].getAddress(false);
                continue;
            }
            if (logMINOR) {
                Logger.debug(this, "updateHandshakeIPs: calling getHandshakeAddress() on Peer '" + localHandshakeIPs[i] + "' for " + this.shortToString() + " (" + ignoreHostnames + ')');
            }
            localHandshakeIPs[i].getHandshakeAddress();
        }
        HashSet<Peer> ret = new HashSet<Peer>();
        for (int i = 0; i < localHandshakeIPs.length; ++i) {
            ret.add(localHandshakeIPs[i]);
        }
        return ret.toArray(new Peer[ret.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeUpdateHandshakeIPs(boolean ignoreHostnames) {
        Peer[] localHandshakeIPs;
        Peer[] myNominalPeer;
        long now = System.currentTimeMillis();
        Peer localDetectedPeer = null;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            localDetectedPeer = this.detectedPeer;
            if (now - this.lastAttemptedHandshakeIPUpdateTime < 300000L) {
                return;
            }
            if (!ignoreHostnames) {
                this.lastAttemptedHandshakeIPUpdateTime = now;
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Updating handshake IPs for peer '" + this.shortToString() + "' (" + ignoreHostnames + ')');
        }
        PeerNode peerNode2 = this;
        synchronized (peerNode2) {
            myNominalPeer = this.nominalPeer.toArray(new Peer[this.nominalPeer.size()]);
        }
        if (myNominalPeer.length == 0) {
            if (localDetectedPeer == null) {
                PeerNode peerNode3 = this;
                synchronized (peerNode3) {
                    this.handshakeIPs = null;
                }
                if (logMINOR) {
                    Logger.minor(this, "1: maybeUpdateHandshakeIPs got a result of: " + this.handshakeIPsToString());
                }
                return;
            }
            localHandshakeIPs = new Peer[]{localDetectedPeer};
            localHandshakeIPs = this.updateHandshakeIPs(localHandshakeIPs, ignoreHostnames);
            PeerNode peerNode4 = this;
            synchronized (peerNode4) {
                this.handshakeIPs = localHandshakeIPs;
            }
            if (logMINOR) {
                Logger.minor(this, "2: maybeUpdateHandshakeIPs got a result of: " + this.handshakeIPsToString());
            }
            return;
        }
        FreenetInetAddress localhost = this.node.fLocalhostAddress;
        Peer[] nodePeers = this.outgoingMangler.getPrimaryIPAddress();
        Vector<Peer> localPeers = null;
        PeerNode peerNode5 = this;
        synchronized (peerNode5) {
            localPeers = new Vector<Peer>(this.nominalPeer);
        }
        boolean addedLocalhost = false;
        Peer detectedDuplicate = null;
        for (int i = 0; i < myNominalPeer.length; ++i) {
            FreenetInetAddress addr;
            Peer p = myNominalPeer[i];
            if (p == null) continue;
            if (localDetectedPeer != null && p != localDetectedPeer && p.equals(localDetectedPeer)) {
                detectedDuplicate = p;
            }
            if ((addr = p.getFreenetAddress()).equals(localhost)) {
                if (addedLocalhost) continue;
                addedLocalhost = true;
            }
            for (int j = 0; j < nodePeers.length; ++j) {
                FreenetInetAddress myAddr = nodePeers[j].getFreenetAddress();
                if (!myAddr.equals(addr)) continue;
                if (!addedLocalhost) {
                    localPeers.add(new Peer(localhost, p.getPort()));
                }
                addedLocalhost = true;
            }
            if (localPeers.contains(p)) continue;
            localPeers.add(p);
        }
        localHandshakeIPs = localPeers.toArray(new Peer[localPeers.size()]);
        localHandshakeIPs = this.updateHandshakeIPs(localHandshakeIPs, ignoreHostnames);
        PeerNode peerNode6 = this;
        synchronized (peerNode6) {
            this.handshakeIPs = localHandshakeIPs;
            if (detectedDuplicate != null && detectedDuplicate.equals(localDetectedPeer)) {
                localDetectedPeer = this.detectedPeer = detectedDuplicate;
            }
            this.updateShortToString();
        }
        if (logMINOR) {
            if (localDetectedPeer != null) {
                Logger.minor(this, "3: detectedPeer = " + localDetectedPeer + " (" + localDetectedPeer.getAddress(false) + ')');
            }
            Logger.minor(this, "3: maybeUpdateHandshakeIPs got a result of: " + this.handshakeIPsToString());
        }
    }

    public synchronized double getLocation() {
        return this.currentLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldBeExcludedFromPeerList() {
        long now = System.currentTimeMillis();
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (0.9 < this.backedOffPercent.currentValue()) {
                return true;
            }
            return 300000L + now < this.getRoutingBackedOffUntil();
            {
            }
        }
    }

    public synchronized double[] getPeersLocation() {
        return this.currentPeersLocation;
    }

    public synchronized long getLocSetTime() {
        return this.locSetTime;
    }

    public int getIdentityHash() {
        return this.hashCode;
    }

    public synchronized boolean isUnroutableOlderVersion() {
        return this.unroutableOlderVersion;
    }

    public synchronized boolean isUnroutableNewerVersion() {
        return this.unroutableNewerVersion;
    }

    @Override
    public boolean isRoutable() {
        return this.isConnected() && this.isRoutingCompatible() && !(this.currentLocation < 0.0) && !(this.currentLocation > 1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRoutingCompatible() {
        long now = System.currentTimeMillis();
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (this.isRoutable && !this.disableRouting) {
                this.timeLastRoutable = now;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        long now = System.currentTimeMillis();
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (this.isConnected && this.currentTracker != null && !this.currentTracker.packets.isDeprecated()) {
                this.timeLastConnected = now;
                return true;
            }
            return false;
        }
    }

    @Override
    public void sendAsync(Message msg, AsyncMessageCallback cb, ByteCounter ctr) throws NotConnectedException {
        AsyncMessageCallback[] asyncMessageCallbackArray;
        if (ctr == null) {
            Logger.error(this, "Bytes not logged", new Exception("debug"));
        }
        if (logMINOR) {
            Logger.minor(this, "Sending async: " + msg + " : " + cb + " on " + this + " for " + this.node.getDarknetPortNumber());
        }
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        this.addToLocalNodeSentMessagesToStatistic(msg);
        if (cb == null) {
            asyncMessageCallbackArray = null;
        } else {
            AsyncMessageCallback[] asyncMessageCallbackArray2 = new AsyncMessageCallback[1];
            asyncMessageCallbackArray = asyncMessageCallbackArray2;
            asyncMessageCallbackArray2[0] = cb;
        }
        MessageItem item = new MessageItem(msg, asyncMessageCallbackArray, ctr, this);
        long now = System.currentTimeMillis();
        this.reportBackoffStatus(now);
        int x = this.messageQueue.queueAndEstimateSize(item);
        if (x > 1024 || !this.node.enablePacketCoalescing) {
            this.node.ps.wakeUp();
        }
    }

    public long getMessageQueueLengthBytes() {
        return this.messageQueue.getMessageQueueLengthBytes();
    }

    public long getProbableSendQueueTime() {
        return (long)((double)this.getMessageQueueLengthBytes() / (this.getThrottle().getBandwidth() + 1.0));
    }

    public synchronized long lastReceivedPacketTime() {
        return this.timeLastReceivedPacket;
    }

    public synchronized long lastReceivedDataPacketTime() {
        return this.timeLastReceivedDataPacket;
    }

    public synchronized long timeLastConnected() {
        return this.timeLastConnected;
    }

    public synchronized long timeLastRoutable() {
        return this.timeLastRoutable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void maybeRekey() {
        long now = System.currentTimeMillis();
        boolean shouldDisconnect = false;
        boolean shouldReturn = false;
        boolean shouldRekey = false;
        long timeWhenRekeyingShouldOccur = 0L;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            timeWhenRekeyingShouldOccur = this.timeLastRekeyed + 3600000L;
            shouldDisconnect = timeWhenRekeyingShouldOccur + 300000L < now && this.isRekeying;
            shouldReturn = this.isRekeying || !this.isConnected;
            boolean bl = shouldRekey = timeWhenRekeyingShouldOccur < now;
            if (!shouldRekey && this.totalBytesExchangedWithCurrentTracker > 0x40000000L) {
                shouldRekey = true;
                timeWhenRekeyingShouldOccur = now;
            }
        }
        if (shouldDisconnect) {
            String time = TimeUtil.formatTime(300000L);
            System.err.println("The peer (" + this + ") has been asked to rekey " + time + " ago... force disconnect.");
            Logger.error(this, "The peer (" + this + ") has been asked to rekey " + time + " ago... force disconnect.");
            this.forceDisconnect(false);
        } else {
            if (shouldReturn || this.hasLiveHandshake(now)) {
                return;
            }
            if (shouldRekey) {
                peerNode = this;
                synchronized (peerNode) {
                    this.isRekeying = true;
                    this.sendHandshakeTime = now;
                    this.ctx = null;
                }
                Logger.normal(this, "We are asking for the key to be renewed (" + this.detectedPeer + ')');
            }
        }
    }

    public synchronized long getPeerAddedTime() {
        return this.peerAddedTime;
    }

    public synchronized long timeSinceAddedOrRestarted() {
        return System.currentTimeMillis() - this.timeAddedOrRestarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disconnected(boolean dumpMessageQueue, boolean dumpTrackers) {
        SessionKey unv;
        SessionKey prev;
        SessionKey cur;
        boolean ret;
        final long now = System.currentTimeMillis();
        Logger.normal(this, "Disconnected " + this, new Exception("debug"));
        this.node.usm.onDisconnect(this);
        this.node.failureTable.onDisconnect(this);
        this.node.peers.disconnected(this);
        MessageItem[] messagesTellDisconnected = null;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            ret = this.isConnected;
            this.isConnected = false;
            this.isRoutable = false;
            this.isRekeying = false;
            cur = this.currentTracker;
            prev = this.previousTracker;
            unv = this.unverifiedTracker;
            if (dumpTrackers) {
                this.currentTracker = null;
                this.previousTracker = null;
                this.unverifiedTracker = null;
            }
            this.sendHandshakeTime = now;
            PeerNode peerNode2 = this;
            synchronized (peerNode2) {
                this.timePrevDisconnect = this.timeLastDisconnect;
                this.timeLastDisconnect = now;
            }
            if (dumpMessageQueue) {
                messagesTellDisconnected = this.grabQueuedMessageItems();
            }
        }
        if (messagesTellDisconnected != null) {
            if (logMINOR) {
                Logger.minor(this, "Messages to dump: " + messagesTellDisconnected.length);
            }
            for (MessageItem mi : messagesTellDisconnected) {
                mi.onDisconnect();
            }
        }
        if (cur != null) {
            cur.packets.disconnected();
        }
        if (prev != null) {
            prev.packets.disconnected();
        }
        if (unv != null) {
            unv.packets.disconnected();
        }
        if (this._lastThrottle != null) {
            this._lastThrottle.maybeDisconnected();
        }
        this.node.lm.lostOrRestartedNode(this);
        this.setPeerNodeStatus(now);
        if (!dumpMessageQueue) {
            this.node.getTicker().queueTimedJob(new Runnable(){

                public void run() {
                    MessageItem[] messagesTellDisconnected;
                    if (!PeerNode.this.isConnected() && PeerNode.this.timeLastDisconnect == now && (messagesTellDisconnected = PeerNode.this.grabQueuedMessageItems()) != null) {
                        for (MessageItem mi : messagesTellDisconnected) {
                            mi.onDisconnect();
                        }
                    }
                }
            }, 3600000L);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceDisconnect(boolean purge) {
        Logger.error(this, "Forcing disconnect on " + this, new Exception("debug"));
        PeerNode peerNode = this;
        synchronized (peerNode) {
            this.forceDisconnectCalled = true;
        }
        this.disconnected(purge, true);
    }

    boolean forceDisconnectCalled() {
        return this.forceDisconnectCalled;
    }

    public MessageItem[] grabQueuedMessageItems() {
        return this.messageQueue.grabQueuedMessageItems();
    }

    public void requeueMessageItems(MessageItem[] messages, int offset, int length, boolean dontLog) {
        this.requeueMessageItems(messages, offset, length, dontLog, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requeueMessageItems(MessageItem[] messages, int offset, int length, boolean dontLog, String reason) {
        if (!dontLog) {
            long now = System.currentTimeMillis();
            String rateLimitWrapper = "";
            boolean rateLimitLogging = false;
            if (messages.length > this.messageRequeueLogRateLimitThreshold) {
                rateLimitWrapper = " (log message rate limited)";
                if (this.nextMessageRequeueLogTime <= now) {
                    this.nextMessageRequeueLogTime = now + this.messageRequeueLogRateLimitInterval;
                } else {
                    rateLimitLogging = true;
                }
            }
            if (!rateLimitLogging) {
                String reasonWrapper = "";
                if (0 <= reason.length()) {
                    reasonWrapper = " because of '" + reason + '\'';
                }
                Logger.normal(this, "Requeueing " + messages.length + " messages" + reasonWrapper + " on " + this + rateLimitWrapper);
            }
        }
        PeerMessageQueue peerMessageQueue = this.messageQueue;
        synchronized (peerMessageQueue) {
            for (int i = offset + length - 1; i >= offset; --i) {
                if (messages[i] == null) continue;
                this.messageQueue.pushfrontPrioritizedMessageItem(messages[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextUrgentTime(long now) {
        long next;
        SessionKey prev;
        SessionKey cur;
        long t = Long.MAX_VALUE;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            cur = this.currentTracker;
            prev = this.previousTracker;
        }
        SessionKey kt = cur;
        if (kt != null) {
            next = kt.packets.getNextUrgentTime();
            t = Math.min(t, next);
            if (next < now && logMINOR) {
                Logger.minor(this, "Next urgent time from curTracker less than now");
            }
            if (kt.packets.hasPacketsToResend()) {
                return now;
            }
        }
        if ((kt = prev) != null) {
            next = kt.packets.getNextUrgentTime();
            t = Math.min(t, next);
            if (next < now && logMINOR) {
                Logger.minor(this, "Next urgent time from prevTracker less than now");
            }
            if (kt.packets.hasPacketsToResend()) {
                return now;
            }
        }
        try {
            if (cur != null && !cur.packets.wouldBlock(false)) {
                t = this.messageQueue.getNextUrgentTime(t, now);
            }
        }
        catch (BlockedTooLongException e) {
            // empty catch block
        }
        return t;
    }

    private synchronized boolean mustSendNotificationsNow(long now) {
        SessionKey kt = this.currentTracker;
        if (kt != null && kt.packets.getNextUrgentTime() < now) {
            return true;
        }
        kt = this.previousTracker;
        return kt != null && kt.packets.getNextUrgentTime() < now;
    }

    public long lastSentPacketTime() {
        return this.timeLastSentPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldSendHandshake() {
        long now = System.currentTimeMillis();
        boolean tempShouldSendHandshake = false;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            tempShouldSendHandshake = now > this.sendHandshakeTime && this.handshakeIPs != null && (this.isRekeying || !this.isConnected());
        }
        if (tempShouldSendHandshake && this.hasLiveHandshake(now)) {
            tempShouldSendHandshake = false;
        }
        if (tempShouldSendHandshake) {
            if (this.isBurstOnly()) {
                peerNode = this;
                synchronized (peerNode) {
                    this.isBursting = true;
                }
                this.setPeerNodeStatus(System.currentTimeMillis());
            } else {
                return true;
            }
        }
        return tempShouldSendHandshake;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLiveHandshake(long now) {
        KeyAgreementSchemeContext c = null;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            c = this.ctx;
        }
        if (c != null && logMINOR) {
            Logger.minor(this, "Last used: " + (now - c.lastUsedTime()));
        }
        return c != null && now - c.lastUsedTime() <= 4800L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean innerCalcNextHandshake(boolean successfulHandshakeSend, boolean dontFetchARK, long now) {
        if (this.isBurstOnly()) {
            return this.calcNextHandshakeBurstOnly(now);
        }
        PeerNode peerNode = this;
        synchronized (peerNode) {
            long delay = this.unroutableOlderVersion || this.unroutableNewerVersion || this.disableRouting ? (long)(19200 + this.node.random.nextInt(9600)) : (this.invalidVersion() && !this.firstHandshake ? (long)(19200 + this.node.random.nextInt(9600)) : (long)(9600 + this.node.random.nextInt(9600)));
            if ((delay /= (long)(this.handshakeIPs == null ? 1 : this.handshakeIPs.length)) < 3000L) {
                delay = 3000L;
            }
            this.sendHandshakeTime = now + delay;
            if (successfulHandshakeSend) {
                this.firstHandshake = false;
            }
            ++this.handshakeCount;
            return this.handshakeCount == 2;
        }
    }

    private synchronized boolean calcNextHandshakeBurstOnly(long now) {
        long delay;
        boolean fetchARKFlag = false;
        ++this.listeningHandshakeBurstCount;
        if (this.isBurstOnly() && this.listeningHandshakeBurstCount >= this.listeningHandshakeBurstSize) {
            this.listeningHandshakeBurstCount = 0;
            fetchARKFlag = true;
        }
        if (this.listeningHandshakeBurstCount == 0) {
            delay = 115200 + this.node.random.nextInt(172800);
            this.listeningHandshakeBurstSize = 1 + this.node.random.nextInt(3);
            this.isBursting = false;
        } else {
            delay = 9600 + this.node.random.nextInt(9600);
        }
        if ((delay /= (long)(this.handshakeIPs == null ? 1 : this.handshakeIPs.length)) < 3000L) {
            delay = 3000L;
        }
        this.sendHandshakeTime = now + delay;
        if (logMINOR) {
            Logger.minor(this, "Next BurstOnly mode handshake in " + (this.sendHandshakeTime - now) + "ms for " + this.shortToString() + " (count: " + this.listeningHandshakeBurstCount + ", size: " + this.listeningHandshakeBurstSize + ')', (Throwable)new Exception("double-called debug"));
        }
        return fetchARKFlag;
    }

    protected void calcNextHandshake(boolean successfulHandshakeSend, boolean dontFetchARK, boolean notRegistered) {
        long now = System.currentTimeMillis();
        boolean fetchARKFlag = false;
        fetchARKFlag = this.innerCalcNextHandshake(successfulHandshakeSend, dontFetchARK, now);
        if (!notRegistered) {
            this.setPeerNodeStatus(now);
        }
        if (fetchARKFlag && !dontFetchARK) {
            long arkFetcherStartTime1 = System.currentTimeMillis();
            this.startARKFetcher();
            long arkFetcherStartTime2 = System.currentTimeMillis();
            if (arkFetcherStartTime2 - arkFetcherStartTime1 > 500L) {
                Logger.normal(this, "arkFetcherStartTime2 is more than half a second after arkFetcherStartTime1 (" + (arkFetcherStartTime2 - arkFetcherStartTime1) + ") working on " + this.shortToString());
            }
        }
    }

    public boolean isBurstOnly() {
        int status = this.outgoingMangler.getConnectivityStatus();
        if (status == 0) {
            return false;
        }
        if (status == -2 || status == -1) {
            return false;
        }
        if (status == 1) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (now - this.timeSetBurstNow > 300000L) {
            this.burstNow = this.node.random.nextInt(20) == 0;
            this.timeSetBurstNow = now;
        }
        return this.burstNow;
    }

    public void sentHandshake(boolean notRegistered) {
        if (logMINOR) {
            Logger.minor(this, "sentHandshake(): " + this);
        }
        this.calcNextHandshake(true, false, notRegistered);
    }

    public void couldNotSendHandshake(boolean notRegistered) {
        if (logMINOR) {
            Logger.minor(this, "couldNotSendHandshake(): " + this);
        }
        this.calcNextHandshake(false, false, notRegistered);
    }

    public int maxTimeBetweenReceivedPackets() {
        return 60000;
    }

    public boolean ping(int pingID) throws NotConnectedException {
        Message msg;
        Message ping = DMT.createFNPPing(pingID);
        this.node.usm.send(this, ping, this.node.dispatcher.pingCounter);
        try {
            msg = this.node.usm.waitFor(MessageFilter.create().setTimeout(2000).setType(DMT.FNPPong).setField("pingSequenceNumber", pingID), null);
        }
        catch (DisconnectedException e) {
            throw new NotConnectedException("Disconnected while waiting for pong");
        }
        return msg != null;
    }

    public short decrementHTL(short htl) {
        short max = this.node.maxHTL();
        if (htl > max) {
            htl = max;
        }
        if (htl <= 0) {
            return 0;
        }
        if (htl == max) {
            if (this.decrementHTLAtMaximum || this.node.disableProbabilisticHTLs) {
                htl = (short)(htl - 1);
            }
            return htl;
        }
        if (htl == 1) {
            if (this.decrementHTLAtMinimum || this.node.disableProbabilisticHTLs) {
                htl = (short)(htl - 1);
            }
            return htl;
        }
        htl = (short)(htl - 1);
        return htl;
    }

    public void sendSync(Message req, ByteCounter ctr) throws NotConnectedException {
        SyncMessageCallback cb = new SyncMessageCallback();
        this.sendAsync(req, cb, ctr);
        cb.waitForSend(60000L);
        if (!cb.done) {
            Logger.error(this, "Waited too long for a blocking send for " + req + " to " + this, new Exception("error"));
            this.localRejectedOverload("SendSyncTimeout");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLocation(double newLoc, double[] newLocs) {
        if (newLoc < 0.0 || newLoc > 1.0) {
            Logger.error(this, "Invalid location update for " + this + " (" + newLoc + ')', new Exception("error"));
            return;
        }
        for (double currentLoc : newLocs) {
            if (!(currentLoc < 0.0) && !(currentLoc > 1.0)) continue;
            Logger.error(this, "Invalid location update for " + this + " (" + currentLoc + ')', new Exception("error"));
            return;
        }
        Arrays.sort(newLocs);
        PeerNode peerNode = this;
        synchronized (peerNode) {
            this.currentLocation = newLoc;
            this.currentPeersLocation = newLocs;
            this.locSetTime = System.currentTimeMillis();
        }
        this.node.peers.writePeers();
        this.setPeerNodeStatus(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldRejectSwapRequest() {
        long now = System.currentTimeMillis();
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (this.timeLastReceivedSwapRequest > 0L) {
                long timeSinceLastTime = now - this.timeLastReceivedSwapRequest;
                this.swapRequestsInterval.report(timeSinceLastTime);
                double averageInterval = this.swapRequestsInterval.currentValue();
                if (averageInterval >= 900.0) {
                    this.timeLastReceivedSwapRequest = now;
                    return false;
                }
                return true;
            }
            this.timeLastReceivedSwapRequest = now;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldRejectProbeRequest() {
        long now = System.currentTimeMillis();
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (this.timeLastReceivedProbeRequest > 0L) {
                long timeSinceLastTime = now - this.timeLastReceivedProbeRequest;
                this.probeRequestsInterval.report(timeSinceLastTime);
                double averageInterval = this.probeRequestsInterval.currentValue();
                if (averageInterval >= 1000.0) {
                    this.timeLastReceivedProbeRequest = now;
                    return false;
                }
                return true;
            }
            this.timeLastReceivedProbeRequest = now;
        }
        return false;
    }

    public void changedIP(Peer newPeer) {
        this.setDetectedPeer(newPeer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDetectedPeer(Peer newPeer) {
        Peer p = newPeer;
        if ((newPeer = newPeer.dropHostName()) == null) {
            Logger.error(this, "Impossible: No address for detected peer! " + p + " on " + this);
            return;
        }
        PeerNode peerNode = this;
        synchronized (peerNode) {
            Peer oldPeer = this.detectedPeer;
            if (!(newPeer == null || oldPeer != null && oldPeer.equals(newPeer))) {
                this.detectedPeer = newPeer;
                this.updateShortToString();
                this.lastAttemptedHandshakeIPUpdateTime = 0L;
                if (!this.isConnected) {
                    return;
                }
            } else {
                return;
            }
            newPeer = newPeer.dropHostName();
            oldPeer = oldPeer.dropHostName();
            byte[] newPeerHandshake = this.jfkNoncesSent.get(newPeer);
            byte[] oldPeerHandshake = this.jfkNoncesSent.get(oldPeer);
            this.jfkNoncesSent.clear();
            this.jfkNoncesSent.put(newPeer, newPeerHandshake);
            this.jfkNoncesSent.put(newPeer, oldPeerHandshake);
        }
        this.getThrottle().maybeDisconnected();
        this.sendIPAddressMessage();
    }

    public synchronized SessionKey getCurrentKeyTracker() {
        return this.currentTracker;
    }

    public synchronized SessionKey getPreviousKeyTracker() {
        return this.previousTracker;
    }

    public synchronized SessionKey getUnverifiedKeyTracker() {
        return this.unverifiedTracker;
    }

    private void updateShortToString() {
        this.shortToString = super.toString() + '@' + this.detectedPeer + '@' + HexUtil.bytesToHex(this.identity);
    }

    @Override
    public String shortToString() {
        return this.shortToString;
    }

    public String toString() {
        return this.shortToString() + '@' + Integer.toHexString(super.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receivedPacket(boolean dontLog, boolean dataPacket) {
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (!this.isConnected && !dontLog) {
                if (this.unverifiedTracker == null && this.currentTracker == null && !this.disconnecting) {
                    Logger.error(this, "Received packet while disconnected!: " + this, new Exception("error"));
                } else if (logMINOR) {
                    Logger.minor(this, "Received packet while disconnected on " + this + " - recently disconnected() ?");
                }
            } else if (logMINOR) {
                Logger.minor(this, "Received packet on " + this);
            }
        }
        long now = System.currentTimeMillis();
        PeerNode peerNode2 = this;
        synchronized (peerNode2) {
            this.timeLastReceivedPacket = now;
            if (dataPacket) {
                this.timeLastReceivedDataPacket = now;
            }
        }
    }

    public void sentPacket() {
        this.timeLastSentPacket = System.currentTimeMillis();
    }

    public synchronized KeyAgreementSchemeContext getKeyAgreementSchemeContext() {
        return this.ctx;
    }

    public synchronized void setKeyAgreementSchemeContext(KeyAgreementSchemeContext ctx2) {
        this.ctx = ctx2;
        if (logMINOR) {
            Logger.minor(this, "setKeyAgreementSchemeContext(" + ctx2 + ") on " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long completedHandshake(long thisBootID, byte[] data, int offset, int length, BlockCipher encCipher, byte[] encKey, Peer replyTo, boolean unverified, int negType, long trackerID, boolean isJFK4, boolean jfk4SameAsOld) {
        PacketThrottle throttle;
        SessionKey newTracker;
        long now = System.currentTimeMillis();
        if (logMINOR) {
            Logger.minor(this, "Tracker ID " + trackerID + " isJFK4=" + isJFK4 + " jfk4SameAsOld=" + jfk4SameAsOld);
        }
        this.calcNextHandshake(true, true, false);
        this.stopARKFetcher();
        try {
            this.processNewNoderef(data, offset, length);
        }
        catch (FSParseException e1) {
            PeerNode peerNode = this;
            synchronized (peerNode) {
                this.bogusNoderef = true;
                this.isConnected = false;
            }
            Logger.error(this, "Failed to parse new noderef for " + this + ": " + e1, e1);
            this.node.peers.disconnected(this);
            return -1L;
        }
        boolean routable = true;
        boolean newer = false;
        boolean older = false;
        if (this.bogusNoderef) {
            Logger.normal(this, "Not routing traffic to " + this + " - bogus noderef");
            routable = false;
        } else if (this.reverseInvalidVersion()) {
            try {
                this.node.setNewestPeerLastGoodVersion(Version.getArbitraryBuildNumber(this.getLastGoodVersion(), Version.lastGoodBuild()));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            Logger.normal(this, "Not routing traffic to " + this + " - reverse invalid version " + Version.getVersionString() + " for peer's lastGoodversion: " + this.getLastGoodVersion());
            newer = true;
        } else {
            newer = false;
        }
        if (this.forwardInvalidVersion()) {
            Logger.normal(this, "Not routing traffic to " + this + " - invalid version " + this.getVersion());
            older = true;
            routable = false;
        } else if (Math.abs(this.clockDelta) > 86400000L) {
            Logger.normal(this, "Not routing traffic to " + this + " - clock problems");
            routable = false;
        } else {
            older = false;
        }
        this.changedIP(replyTo);
        boolean bootIDChanged = false;
        boolean wasARekey = false;
        SessionKey oldPrev = null;
        SessionKey oldCur = null;
        SessionKey prev = null;
        MessageItem[] messagesTellDisconnected = null;
        PacketTracker packets = null;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (this.currentTracker != null && Arrays.equals(encKey, this.currentTracker.sessionKey)) {
                Logger.error(this, "completedHandshake() with identical key to current, maybe replayed JFK(4)?");
                return -1L;
            }
            if (this.previousTracker != null && Arrays.equals(encKey, this.previousTracker.sessionKey)) {
                Logger.error(this, "completedHandshake() with identical key to previous, maybe replayed JFK(4)?");
                return -1L;
            }
            if (this.unverifiedTracker != null && Arrays.equals(encKey, this.unverifiedTracker.sessionKey)) {
                Logger.error(this, "completedHandshake() with identical key to unverified, maybe replayed JFK(4)?");
                return -1L;
            }
            this.handshakeCount = 0;
            this.bogusNoderef = false;
            if (!this.isConnected) {
                this.connectedTime = now;
                this.countSelectionsSinceConnected = 0L;
                this.sentInitialMessages = false;
            } else {
                wasARekey = true;
            }
            this.isConnected = true;
            this.disableRouting = this.disableRoutingHasBeenSetLocally || this.disableRoutingHasBeenSetRemotely;
            this.isRoutable = routable;
            this.unroutableNewerVersion = newer;
            this.unroutableOlderVersion = older;
            boolean notReusingTracker = false;
            boolean bl = bootIDChanged = thisBootID != this.bootID;
            if (bootIDChanged && wasARekey) {
                Logger.error(this, "Changed boot ID while rekeying! from " + this.bootID + " to " + thisBootID + " for " + this.getPeer());
                wasARekey = false;
                this.connectedTime = now;
                this.countSelectionsSinceConnected = 0L;
                this.sentInitialMessages = false;
            } else if (bootIDChanged && logMINOR) {
                Logger.minor(this, "Changed boot ID from " + this.bootID + " to " + thisBootID + " for " + this.getPeer());
            }
            this.bootID = thisBootID;
            if (this.currentTracker != null && this.currentTracker.packets.trackerID == trackerID && !this.currentTracker.packets.isDeprecated()) {
                if (isJFK4 && !jfk4SameAsOld) {
                    Logger.error(this, "In JFK(4), found tracker ID " + trackerID + " but other side says is new! for " + this);
                }
                packets = this.currentTracker.packets;
                if (logMINOR) {
                    Logger.minor(this, "Re-using packet tracker ID " + trackerID + " on " + this + " from current " + this.currentTracker);
                }
            } else if (this.previousTracker != null && this.previousTracker.packets.trackerID == trackerID && !this.previousTracker.packets.isDeprecated()) {
                if (isJFK4 && !jfk4SameAsOld) {
                    Logger.error(this, "In JFK(4), found tracker ID " + trackerID + " but other side says is new! for " + this);
                }
                packets = this.previousTracker.packets;
                if (logMINOR) {
                    Logger.minor(this, "Re-using packet tracker ID " + trackerID + " on " + this + " from prev " + this.previousTracker);
                }
            } else {
                if (isJFK4 && jfk4SameAsOld) {
                    this.isConnected = false;
                    Logger.error(this, "Can't reuse old tracker ID " + trackerID + " as instructed - disconnecting");
                    return -1L;
                }
                if (trackerID == -1L) {
                    packets = new PacketTracker(this);
                    notReusingTracker = true;
                    if (logMINOR) {
                        Logger.minor(this, "Creating new PacketTracker as instructed for " + this);
                    }
                } else {
                    if (isJFK4 && negType >= 4 && trackerID < 0L) {
                        Logger.error(this, "JFK(4) packet with neg type " + negType + " has negative tracker ID: " + trackerID);
                    }
                    notReusingTracker = true;
                    packets = isJFK4 && trackerID >= 0L ? new PacketTracker(this, trackerID) : new PacketTracker(this);
                    if (logMINOR) {
                        Logger.minor(this, "Creating new tracker (last resort) on " + this);
                    }
                }
            }
            if (bootIDChanged || notReusingTracker) {
                if (!bootIDChanged && notReusingTracker) {
                    Logger.error(this, "Not reusing tracker, so wiping old trackers for " + this);
                }
                oldPrev = this.previousTracker;
                oldCur = this.currentTracker;
                this.previousTracker = null;
                this.currentTracker = null;
                messagesTellDisconnected = this.grabQueuedMessageItems();
                this.offeredMainJarVersion = 0L;
            }
            newTracker = new SessionKey(this, packets, encCipher, encKey);
            if (logMINOR) {
                Logger.minor(this, "New key tracker in completedHandshake: " + newTracker + " for " + packets + " for " + this.shortToString() + " neg type " + negType);
            }
            if (unverified) {
                if (this.unverifiedTracker != null && this.previousTracker == null) {
                    this.previousTracker = this.unverifiedTracker;
                }
                this.unverifiedTracker = newTracker;
                if (this.currentTracker == null || this.currentTracker.packets.isDeprecated()) {
                    this.isConnected = false;
                }
            } else {
                this.previousTracker = prev = this.currentTracker;
                this.currentTracker = newTracker;
                this.neverConnected = false;
                this.peerAddedTime = 0L;
                this.maybeSwapTrackers();
                prev = this.previousTracker;
            }
            this.ctx = null;
            this.isRekeying = false;
            this.timeLastRekeyed = now - (long)(unverified ? 0 : 150000);
            this.totalBytesExchangedWithCurrentTracker = 0L;
            if (this.currentTracker != null && this.previousTracker != null && Arrays.equals(this.currentTracker.sessionKey, this.previousTracker.sessionKey)) {
                Logger.error(this, "currentTracker key equals previousTracker key: cur " + this.currentTracker + " prev " + this.previousTracker);
            }
            if (this.previousTracker != null && this.unverifiedTracker != null && Arrays.equals(this.previousTracker.sessionKey, this.unverifiedTracker.sessionKey)) {
                Logger.error(this, "previousTracker key equals unverifiedTracker key: prev " + this.previousTracker + " unv " + this.unverifiedTracker);
            }
            this.timeLastSentPacket = now;
        }
        if (messagesTellDisconnected != null) {
            for (int i = 0; i < messagesTellDisconnected.length; ++i) {
                messagesTellDisconnected[i].onDisconnect();
            }
        }
        if (bootIDChanged) {
            this.node.lm.lostOrRestartedNode(this);
            this.node.usm.onRestart(this);
        }
        if (oldPrev != null && oldPrev.packets != newTracker.packets) {
            oldPrev.packets.completelyDeprecated(newTracker);
        }
        if (oldCur != null && oldCur.packets != newTracker.packets) {
            oldCur.packets.completelyDeprecated(newTracker);
        }
        if (prev != null && prev.packets != newTracker.packets) {
            prev.packets.deprecated();
        }
        PeerNode peerNode2 = this;
        synchronized (peerNode2) {
            throttle = this._lastThrottle;
        }
        if (throttle != null) {
            throttle.maybeDisconnected();
        }
        Logger.normal(this, "Completed handshake with " + this + " on " + replyTo + " - current: " + this.currentTracker + " old: " + this.previousTracker + " unverified: " + this.unverifiedTracker + " bootID: " + thisBootID + " for " + this.shortToString());
        this.receivedPacket(unverified, false);
        this.setPeerNodeStatus(now);
        if (newer || older || !this.isConnected()) {
            this.node.peers.disconnected(this);
        } else if (!wasARekey) {
            this.node.peers.addConnectedPeer(this);
            this.maybeOnConnect();
        }
        return packets.trackerID;
    }

    private synchronized void maybeSwapTrackers() {
        if (this.currentTracker == null || this.previousTracker == null) {
            return;
        }
        if (this.currentTracker.packets == this.previousTracker.packets) {
            return;
        }
        long delta = Math.abs(this.currentTracker.packets.createdTime - this.previousTracker.packets.createdTime);
        if (this.previousTracker != null && !this.previousTracker.packets.isDeprecated() && delta < 120000L) {
            MessageDigest md = SHA256.getMessageDigest();
            md.update(this.currentTracker.sessionKey);
            md.update(TEST_AS_BYTES);
            md.update(Fields.longToBytes(this.bootID ^ this.node.bootID));
            int curHash = Fields.hashCode(md.digest());
            md.reset();
            md.update(this.previousTracker.sessionKey);
            md.update(TEST_AS_BYTES);
            md.update(Fields.longToBytes(this.bootID ^ this.node.bootID));
            int prevHash = Fields.hashCode(md.digest());
            SHA256.returnMessageDigest(md);
            if (prevHash < curHash) {
                SessionKey temp = this.previousTracker;
                this.previousTracker = this.currentTracker;
                this.currentTracker = temp;
                if (logMINOR) {
                    Logger.minor(this, "Swapped SessionKey's on " + this + " cur " + this.currentTracker + " prev " + this.previousTracker + " delta " + delta + " cur.deprecated=" + this.currentTracker.packets.isDeprecated() + " prev.deprecated=" + this.previousTracker.packets.isDeprecated());
                }
            } else if (logMINOR) {
                Logger.minor(this, "Not swapping SessionKey's on " + this + " cur " + this.currentTracker + " prev " + this.previousTracker + " delta " + delta + " cur.deprecated=" + this.currentTracker.packets.isDeprecated() + " prev.deprecated=" + this.previousTracker.packets.isDeprecated());
            }
        } else if (logMINOR) {
            Logger.minor(this, "Not swapping SessionKey's: previousTracker = " + this.previousTracker.toString() + (this.previousTracker.packets.isDeprecated() ? " (deprecated)" : "") + " time delta = " + delta);
        }
    }

    @Override
    public long getBootID() {
        return this.bootID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startARKFetcher() {
        if (!this.node.enableARKs) {
            return;
        }
        Object object = this.arkFetcherSync;
        synchronized (object) {
            if (this.myARK == null) {
                Logger.minor(this, "No ARK for " + this + " !!!!");
                return;
            }
            if (this.arkFetcher == null) {
                Logger.minor(this, "Starting ARK fetcher for " + this + " : " + this.myARK);
                this.arkFetcher = this.node.clientCore.uskManager.subscribeContent(this.myARK, this, true, this.node.arkFetcherContext, (short)2, this.node.nonPersistentClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopARKFetcher() {
        if (!this.node.enableARKs) {
            return;
        }
        Logger.minor(this, "Stopping ARK fetcher for " + this + " : " + this.myARK);
        Object object = this.arkFetcherSync;
        synchronized (object) {
            if (this.arkFetcher == null) {
                return;
            }
            this.node.clientCore.uskManager.unsubscribeContent(this.myARK, this.arkFetcher, true);
            this.arkFetcher = null;
        }
    }

    @Override
    public short getPollingPriorityNormal() {
        return 2;
    }

    @Override
    public short getPollingPriorityProgress() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void maybeSendInitialMessages() {
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (this.sentInitialMessages) {
                return;
            }
            if (this.currentTracker == null || this.currentTracker.packets.isDeprecated()) {
                return;
            }
            this.sentInitialMessages = true;
        }
        this.sendInitialMessages();
    }

    protected void sendInitialMessages() {
        Message locMsg = DMT.createFNPLocChangeNotificationNew(this.node.lm.getLocation(), this.node.peers.getPeerLocationDoubles(true));
        Message ipMsg = DMT.createFNPDetectedIPAddress(this.detectedPeer);
        Message timeMsg = DMT.createFNPTime(System.currentTimeMillis());
        Message packetsMsg = this.createSentPacketsMessage();
        Message dRoutingMsg = DMT.createRoutingStatus(!this.disableRoutingHasBeenSetLocally);
        Message uptimeMsg = DMT.createFNPUptime((byte)(100.0 * this.node.uptime.getUptime()));
        try {
            if (this.isRealConnection()) {
                this.sendAsync(locMsg, null, this.node.nodeStats.initialMessagesCtr);
            }
            this.sendAsync(ipMsg, null, this.node.nodeStats.initialMessagesCtr);
            this.sendAsync(timeMsg, null, this.node.nodeStats.initialMessagesCtr);
            this.sendAsync(packetsMsg, null, this.node.nodeStats.initialMessagesCtr);
            this.sendAsync(dRoutingMsg, null, this.node.nodeStats.initialMessagesCtr);
            this.sendAsync(uptimeMsg, null, this.node.nodeStats.initialMessagesCtr);
        }
        catch (NotConnectedException e) {
            Logger.error(this, "Completed handshake with " + this.getPeer() + " but disconnected (" + this.isConnected + ':' + this.currentTracker + "!!!: " + e, e);
        }
        if (this.node.nodeUpdater != null && this.isRealConnection()) {
            this.node.nodeUpdater.maybeSendUOMAnnounce(this);
        }
        this.sendConnectedDiffNoderef();
    }

    private Message createSentPacketsMessage() {
        long time;
        long[][] sent = this.getSentPacketTimesHashes();
        long[] times = sent[0];
        long[] hashes = sent[1];
        long now = System.currentTimeMillis();
        long horizon = now - Integer.MAX_VALUE;
        int skip = 0;
        for (int i = 0; i < times.length && (time = times[i]) < horizon; ++i) {
            ++skip;
        }
        int[] timeDeltas = new int[times.length - skip];
        for (int i = skip; i < times.length; ++i) {
            timeDeltas[i] = (int)(now - times[i]);
        }
        if (skip != 0) {
            long[] newHashes = new long[hashes.length - skip];
            System.arraycopy(hashes, skip, newHashes, 0, hashes.length - skip);
        }
        return DMT.createFNPSentPackets(timeDeltas, hashes, now);
    }

    private void sendIPAddressMessage() {
        Message ipMsg = DMT.createFNPDetectedIPAddress(this.detectedPeer);
        try {
            this.sendAsync(ipMsg, null, this.node.nodeStats.changedIPCtr);
        }
        catch (NotConnectedException e) {
            Logger.normal(this, "Sending IP change message to " + this + " but disconnected: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verified(SessionKey tracker) {
        SessionKey completelyDeprecatedTracker;
        long now = System.currentTimeMillis();
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (tracker == this.unverifiedTracker && !tracker.packets.isDeprecated()) {
                if (logMINOR) {
                    Logger.minor(this, "Promoting unverified tracker " + tracker + " for " + this.getPeer());
                }
                completelyDeprecatedTracker = this.previousTracker;
                this.previousTracker = this.currentTracker;
                this.currentTracker = this.unverifiedTracker;
                this.unverifiedTracker = null;
                this.isConnected = true;
                this.neverConnected = false;
                this.peerAddedTime = 0L;
                this.ctx = null;
                this.maybeSwapTrackers();
                if (this.previousTracker != null && this.previousTracker.packets != this.currentTracker.packets) {
                    this.previousTracker.packets.deprecated();
                }
            } else {
                return;
            }
        }
        this.maybeSendInitialMessages();
        this.setPeerNodeStatus(now);
        this.node.peers.addConnectedPeer(this);
        this.maybeOnConnect();
        if (completelyDeprecatedTracker != null && completelyDeprecatedTracker.packets != tracker.packets) {
            completelyDeprecatedTracker.packets.completelyDeprecated(tracker);
        }
    }

    private synchronized boolean invalidVersion() {
        return this.bogusNoderef || this.forwardInvalidVersion() || this.reverseInvalidVersion();
    }

    private synchronized boolean forwardInvalidVersion() {
        return !Version.checkGoodVersion(this.version);
    }

    private synchronized boolean reverseInvalidVersion() {
        if (this.ignoreLastGoodVersion()) {
            return false;
        }
        return !Version.checkArbitraryGoodVersion(Version.getVersionString(), this.lastGoodVersion);
    }

    public boolean publicInvalidVersion() {
        return this.unroutableOlderVersion;
    }

    public synchronized boolean publicReverseInvalidVersion() {
        return this.unroutableNewerVersion;
    }

    public synchronized boolean dontRoute() {
        return this.disableRouting;
    }

    public void processDiffNoderef(SimpleFieldSet fs) throws FSParseException {
        this.processNewNoderef(fs, false, true);
    }

    private void processNewNoderef(byte[] data, int offset, int length) throws FSParseException {
        SimpleFieldSet fs = PeerNode.compressedNoderefToFieldSet(data, offset, length);
        this.processNewNoderef(fs, false, false);
    }

    static SimpleFieldSet compressedNoderefToFieldSet(byte[] data, int offset, int length) throws FSParseException {
        InputStreamReader isr;
        if (length <= 5) {
            throw new FSParseException("Too short");
        }
        DSAGroup group = null;
        byte firstByte = data[offset];
        ++offset;
        --length;
        if ((firstByte & 2) == 2) {
            int groupIndex = data[offset] & 0xFF;
            ++offset;
            --length;
            group = Global.getGroup(groupIndex);
            if (group == null) {
                throw new FSParseException("Unknown group number " + groupIndex);
            }
            if (logMINOR) {
                Logger.minor(PeerNode.class, "DSAGroup set to " + group.fingerprintToString() + " using the group-index " + groupIndex);
            }
        }
        if ((firstByte & 1) == 1) {
            try {
                Inflater i = new Inflater();
                i.setInput(data, offset, length);
                byte[] output = new byte[4096];
                length = i.inflate(output, 0, output.length);
                data = output;
                offset = 0;
                if (logMINOR) {
                    Logger.minor(PeerNode.class, "We have decompressed a " + length + " bytes big reference.");
                }
            }
            catch (DataFormatException e) {
                throw new FSParseException("Invalid compressed data");
            }
        }
        if (logMINOR) {
            Logger.minor(PeerNode.class, "Reference: " + HexUtil.bytesToHex(data, offset, length) + '(' + length + ')');
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(data, offset, length);
        try {
            isr = new InputStreamReader((InputStream)bais, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e1, e1);
        }
        BufferedReader br = new BufferedReader(isr);
        try {
            SimpleFieldSet fs = new SimpleFieldSet(br, false, true);
            if (group != null) {
                SimpleFieldSet sfs = new SimpleFieldSet(true);
                sfs.put("dsaGroup", group.asFieldSet());
                fs.putAllOverwrite(sfs);
            }
            return fs;
        }
        catch (IOException e) {
            FSParseException ex = new FSParseException("Impossible: " + e);
            ex.initCause(e);
            throw ex;
        }
    }

    private void processNewNoderef(SimpleFieldSet fs, boolean forARK, boolean forDiffNodeRef) throws FSParseException {
        boolean changedAnything;
        if (logMINOR) {
            Logger.minor(this, "Parsing: \n" + fs);
        }
        if (changedAnything = this.innerProcessNewNoderef(fs, forARK, forDiffNodeRef)) {
            this.node.peers.writePeers();
        }
    }

    protected synchronized boolean innerProcessNewNoderef(SimpleFieldSet fs, boolean forARK, boolean forDiffNodeRef) throws FSParseException {
        boolean changedAnything;
        block30: {
            String newLastGoodVersion;
            changedAnything = false;
            if (!forDiffNodeRef && this.node.testnetEnabled != Fields.stringToBool(fs.get("testnet"), false)) {
                String err = "Preventing connection to node " + this.detectedPeer + " - peer.testnet=" + !this.node.testnetEnabled + '(' + fs.get("testnet") + ") but node.testnet=" + this.node.testnetEnabled;
                Logger.error(this, err);
                throw new FSParseException(err);
            }
            String newVersion = fs.get("version");
            if (newVersion == null) {
                if (!forARK && !forDiffNodeRef) {
                    throw new FSParseException("No version");
                }
            } else {
                if (!newVersion.equals(this.version)) {
                    changedAnything = true;
                }
                this.version = newVersion;
                if (this.version != null) {
                    try {
                        this.simpleVersion = Version.getArbitraryBuildNumber(this.version);
                    }
                    catch (VersionParseException e) {
                        Logger.error(this, "Bad version: " + this.version + " : " + e, e);
                    }
                }
                Version.seenVersion(newVersion);
            }
            if ((newLastGoodVersion = fs.get("lastGoodVersion")) != null) {
                this.lastGoodVersion = newLastGoodVersion;
            }
            this.updateVersionRoutablity();
            String locationString = fs.get("location");
            if (locationString != null) {
                double newLoc = Location.getLocation(locationString);
                if (newLoc == -1.0) {
                    if (logMINOR) {
                        Logger.minor(this, "Invalid or null location, waiting for FNPLocChangeNotification: locationString=" + locationString);
                    }
                } else if (!Location.equals(newLoc, this.currentLocation)) {
                    changedAnything = true;
                    this.currentLocation = newLoc;
                    this.locSetTime = System.currentTimeMillis();
                }
            }
            try {
                String[] physical = fs.getAll("physical.udp");
                if (physical != null) {
                    Vector<Peer> oldNominalPeer = this.nominalPeer;
                    if (this.nominalPeer == null) {
                        this.nominalPeer = new Vector();
                    }
                    this.nominalPeer.removeAllElements();
                    Object[] oldPeers = this.nominalPeer.toArray(new Peer[this.nominalPeer.size()]);
                    for (int i = 0; i < physical.length; ++i) {
                        Peer p;
                        try {
                            p = new Peer(physical[i], true, true);
                        }
                        catch (HostnameSyntaxException e) {
                            Logger.error(this, "Invalid hostname or IP Address syntax error while parsing new peer reference: " + physical[i]);
                            continue;
                        }
                        if (this.nominalPeer.contains(p)) continue;
                        if (oldNominalPeer.contains(p)) {
                            // empty if block
                        }
                        this.nominalPeer.addElement(p);
                    }
                    if (!Arrays.equals(oldPeers, this.nominalPeer.toArray(new Peer[this.nominalPeer.size()]))) {
                        changedAnything = true;
                        if (logMINOR) {
                            Logger.minor(this, "Got new physical.udp for " + this + " : " + Arrays.toString(this.nominalPeer.toArray()));
                        }
                        this.lastAttemptedHandshakeIPUpdateTime = 0L;
                        this.jfkNoncesSent.clear();
                    }
                    break block30;
                }
                if (forARK) {
                    Logger.error(this, "ARK noderef has no physical.udp for " + this + " : forDiffNodeRef=" + forDiffNodeRef + " forARK=" + forARK);
                }
            }
            catch (Exception e1) {
                Logger.error(this, "Caught " + e1, e1);
                throw new FSParseException(e1);
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Parsed successfully; changedAnything = " + changedAnything);
        }
        int[] newNegTypes = fs.getIntArray("auth.negTypes");
        boolean refHadNegTypes = false;
        if (newNegTypes == null || newNegTypes.length == 0) {
            newNegTypes = new int[]{0};
        } else {
            refHadNegTypes = true;
        }
        if (!(forDiffNodeRef && !refHadNegTypes || Arrays.equals(this.negTypes, newNegTypes))) {
            changedAnything = true;
            this.negTypes = newNegTypes;
        }
        if (this.parseARK(fs, false, forDiffNodeRef)) {
            changedAnything = true;
        }
        return changedAnything;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendAnyUrgentNotifications(boolean forceSendPrimary) {
        int size;
        long t;
        SessionKey prev;
        SessionKey cur;
        boolean sent = false;
        if (logMINOR) {
            Logger.minor(this, "sendAnyUrgentNotifications");
        }
        long now = System.currentTimeMillis();
        PeerNode peerNode = this;
        synchronized (peerNode) {
            cur = this.currentTracker;
            prev = this.previousTracker;
        }
        SessionKey tracker = cur;
        if (tracker != null && ((t = tracker.packets.getNextUrgentTime()) < now || forceSendPrimary)) {
            try {
                if (logMINOR) {
                    Logger.minor(this, "Sending urgent notifications for current tracker on " + this.shortToString());
                }
                size = this.outgoingMangler.processOutgoing(null, 0, 0, tracker, (short)0);
                this.node.nodeStats.reportNotificationOnlyPacketSent(size);
                sent = true;
            }
            catch (NotConnectedException e) {
            }
            catch (KeyChangedException e) {
            }
            catch (WouldBlockException e) {
                Logger.error(this, "Caught impossible: " + e, e);
            }
            catch (PacketSequenceException e) {
                Logger.error(this, "Caught impossible: " + e, e);
            }
        }
        if ((tracker = prev) != null && (t = tracker.packets.getNextUrgentTime()) < now) {
            try {
                if (logMINOR) {
                    Logger.minor(this, "Sending urgent notifications for previous tracker on " + this.shortToString());
                }
                size = this.outgoingMangler.processOutgoing(null, 0, 0, tracker, (short)0);
                this.node.nodeStats.reportNotificationOnlyPacketSent(size);
                sent = true;
            }
            catch (NotConnectedException e) {
            }
            catch (KeyChangedException e) {
            }
            catch (WouldBlockException e) {
                Logger.error(this, "Caught impossible: " + e, e);
            }
            catch (PacketSequenceException e) {
                Logger.error(this, "Caught impossible: " + e, e);
            }
        }
        return sent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkTrackerTimeout() {
        long now = System.currentTimeMillis();
        SessionKey prev = null;
        SessionKey cur = null;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (this.previousTracker == null) {
                return;
            }
            if (this.currentTracker == null) {
                return;
            }
            cur = this.currentTracker;
            prev = this.previousTracker;
        }
        if (prev.packets == cur.packets) {
            return;
        }
        long t = prev.packets.getNextUrgentTime();
        if (t <= -1L || prev.packets.timeLastDecodedPacket() <= 0L || now - prev.packets.timeLastDecodedPacket() <= 60000L || cur.packets.timeLastDecodedPacket() <= 0L || now - cur.packets.timeLastDecodedPacket() >= 30000L || prev.packets.countAckRequests() <= 0 && prev.packets.countResendRequests() <= 0) {
            return;
        }
        Logger.error(this, "No packets decoded on " + prev + " for 60 seconds, deprecating in favour of cur: " + cur);
        prev.packets.completelyDeprecated(cur);
    }

    public abstract PeerNodeStatus getStatus(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTMCIPeerInfo() {
        long now = System.currentTimeMillis();
        int idle = -1;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            idle = (int)((now - this.timeLastReceivedPacket) / 1000L);
        }
        if (this.getPeerNodeStatus() == 6 && this.getPeerAddedTime() > 1L) {
            idle = (int)((now - this.getPeerAddedTime()) / 1000L);
        }
        return String.valueOf(this.getPeer()) + '\t' + this.getIdentityString() + '\t' + this.getLocation() + '\t' + this.getPeerNodeStatusString() + '\t' + idle;
    }

    public String getFreevizOutput() {
        return this.getStatus(true).toString() + '|' + this.identityAsBase64String;
    }

    public synchronized String getVersion() {
        return this.version;
    }

    private synchronized String getLastGoodVersion() {
        return this.lastGoodVersion;
    }

    public int getSimpleVersion() {
        return this.simpleVersion;
    }

    public void write(Writer w) throws IOException {
        SimpleFieldSet fs = this.exportFieldSet();
        SimpleFieldSet meta = this.exportMetadataFieldSet();
        if (!meta.isEmpty()) {
            fs.put("metadata", meta);
        }
        fs.writeTo(w);
    }

    public synchronized SimpleFieldSet exportDiskFieldSet() {
        SimpleFieldSet fs = this.exportFieldSet();
        SimpleFieldSet meta = this.exportMetadataFieldSet();
        if (!meta.isEmpty()) {
            fs.put("metadata", meta);
        }
        return fs;
    }

    public synchronized SimpleFieldSet exportMetadataFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        if (this.detectedPeer != null) {
            fs.putSingle("detected.udp", this.detectedPeer.toStringPrefNumeric());
        }
        if (this.lastReceivedPacketTime() > 0L) {
            fs.putSingle("timeLastReceivedPacket", Long.toString(this.timeLastReceivedPacket));
        }
        if (this.timeLastConnected() > 0L) {
            fs.putSingle("timeLastConnected", Long.toString(this.timeLastConnected));
        }
        if (this.timeLastRoutable() > 0L) {
            fs.putSingle("timeLastRoutable", Long.toString(this.timeLastRoutable));
        }
        if (this.getPeerAddedTime() > 0L) {
            fs.putSingle("peerAddedTime", Long.toString(this.peerAddedTime));
        }
        if (this.neverConnected) {
            fs.putSingle("neverConnected", "true");
        }
        if (this.hadRoutableConnectionCount > 0L) {
            fs.putSingle("hadRoutableConnectionCount", Long.toString(this.hadRoutableConnectionCount));
        }
        if (this.routableConnectionCheckCount > 0L) {
            fs.putSingle("routableConnectionCheckCount", Long.toString(this.routableConnectionCheckCount));
        }
        if (this.currentPeersLocation != null) {
            fs.put("peersLocation", this.currentPeersLocation);
        }
        return fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleFieldSet exportVolatileFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        long now = System.currentTimeMillis();
        PeerNode peerNode = this;
        synchronized (peerNode) {
            fs.putSingle("averagePingTime", Double.toString(this.averagePingTime()));
            long idle = now - this.lastReceivedPacketTime();
            if (idle > 60000L && -1L != this.lastReceivedPacketTime()) {
                fs.putSingle("idle", Long.toString(idle));
            }
            if (this.peerAddedTime > 1L) {
                fs.putSingle("peerAddedTime", Long.toString(this.peerAddedTime));
            }
            fs.putSingle("lastRoutingBackoffReason", this.lastRoutingBackoffReason);
            fs.putSingle("routingBackoffPercent", Double.toString(this.backedOffPercent.currentValue() * 100.0));
            fs.putSingle("routingBackoff", Long.toString(Math.max(Math.max(this.routingBackedOffUntil, this.transferBackedOffUntil) - now, 0L)));
            fs.putSingle("routingBackoffLength", Integer.toString(this.routingBackoffLength));
            fs.putSingle("overloadProbability", Double.toString(this.getPRejected() * 100.0));
            fs.putSingle("percentTimeRoutableConnection", Double.toString(this.getPercentTimeRoutableConnection() * 100.0));
        }
        fs.putSingle("status", this.getPeerNodeStatusString());
        return fs;
    }

    public synchronized SimpleFieldSet exportFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        if (this.getLastGoodVersion() != null) {
            fs.putSingle("lastGoodVersion", this.lastGoodVersion);
        }
        for (int i = 0; i < this.nominalPeer.size(); ++i) {
            fs.putAppend("physical.udp", this.nominalPeer.get(i).toString());
        }
        fs.put("auth.negTypes", this.negTypes);
        fs.putSingle("identity", this.getIdentityString());
        fs.putSingle("location", Double.toString(this.currentLocation));
        fs.putSingle("testnet", Boolean.toString(this.testnetEnabled));
        fs.putSingle("version", this.version);
        if (this.peerCryptoGroup != null) {
            fs.put("dsaGroup", this.peerCryptoGroup.asFieldSet());
        }
        if (this.peerPubKey != null) {
            fs.put("dsaPubKey", this.peerPubKey.asFieldSet());
        }
        if (this.myARK != null) {
            fs.putSingle("ark.number", Long.toString(this.myARK.suggestedEdition - 1L));
            fs.putSingle("ark.pubURI", this.myARK.getBaseSSK().toString(false, false));
        }
        fs.put("opennet", this.isOpennet());
        fs.put("seed", this.isSeed());
        fs.put("totalInput", this.getTotalInputSinceStartup() + this.getTotalInputBytes());
        fs.put("totalOutput", this.getTotalOutputSinceStartup() + this.getTotalOutputBytes());
        return fs;
    }

    public abstract boolean isDarknet();

    public abstract boolean isOpennet();

    public abstract boolean isSeed();

    public synchronized long timeLastConnectionCompleted() {
        return this.connectedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requeueResendItems(Vector<ResendPacketItem> resendItems) {
        SessionKey unv;
        SessionKey prev;
        SessionKey cur;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            cur = this.currentTracker;
            prev = this.previousTracker;
            unv = this.unverifiedTracker;
        }
        for (ResendPacketItem item : resendItems) {
            if (item.pn != this) {
                throw new IllegalArgumentException("item.pn != this!");
            }
            SessionKey kt = cur;
            if (kt != null && item.kt == kt.packets) {
                kt.packets.resendPacket(item.packetNumber);
                continue;
            }
            kt = prev;
            if (kt != null && item.kt == kt.packets) {
                kt.packets.resendPacket(item.packetNumber);
                continue;
            }
            kt = unv;
            if (kt != null && item.kt == kt.packets) {
                kt.packets.resendPacket(item.packetNumber);
                continue;
            }
            SessionKey sessionKey = kt = cur == null ? unv : cur;
            if (kt == null) {
                Logger.error(this, "No tracker to resend packet " + item.packetNumber + " on");
                continue;
            }
            MessageItem mi = new MessageItem(item.buf, item.callbacks, true, this.resendByteCounter, item.priority);
            this.requeueMessageItems(new MessageItem[]{mi}, 0, 1, true);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PeerNode) {
            PeerNode pn = (PeerNode)o;
            return Arrays.equals(pn.identity, this.identity);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRoutingBackedOff() {
        long now = System.currentTimeMillis();
        PeerNode peerNode = this;
        synchronized (peerNode) {
            return now < this.routingBackedOffUntil || now < this.transferBackedOffUntil;
        }
    }

    public void localRejectedOverload() {
        this.localRejectedOverload("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportBackoffStatus(long now) {
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (now > this.lastSampleTime) {
                if (now > this.routingBackedOffUntil) {
                    if (this.lastSampleTime > this.routingBackedOffUntil) {
                        this.backedOffPercent.report(0.0);
                    } else if (this.routingBackedOffUntil > 0L) {
                        this.backedOffPercent.report((double)(this.routingBackedOffUntil - this.lastSampleTime) / (double)(now - this.lastSampleTime));
                    }
                } else {
                    this.backedOffPercent.report(1.0);
                }
            }
            this.lastSampleTime = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void localRejectedOverload(String reason) {
        assert (reason.indexOf(" ") == -1);
        this.pRejected.report(1.0);
        if (logMINOR) {
            Logger.minor(this, "Local rejected overload (" + reason + ") on " + this + " : pRejected=" + this.pRejected.currentValue());
        }
        long now = System.currentTimeMillis();
        Peer peer = this.getPeer();
        this.reportBackoffStatus(now);
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (now > this.routingBackedOffUntil) {
                this.routingBackoffLength *= 2;
                if (this.routingBackoffLength > 10800000) {
                    this.routingBackoffLength = 10800000;
                }
                int x = this.node.random.nextInt(this.routingBackoffLength);
                this.routingBackedOffUntil = now + (long)x;
                String reasonWrapper = "";
                if (0 <= reason.length()) {
                    reasonWrapper = " because of '" + reason + '\'';
                }
                if (logMINOR) {
                    Logger.minor(this, "Backing off" + reasonWrapper + ": routingBackoffLength=" + this.routingBackoffLength + ", until " + x + "ms on " + peer);
                }
            } else {
                if (logMINOR) {
                    Logger.minor(this, "Ignoring localRejectedOverload: " + (this.routingBackedOffUntil - now) + "ms remaining on routing backoff on " + peer);
                }
                return;
            }
            this.setLastBackoffReason(reason);
        }
        this.setPeerNodeStatus(now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void successNotOverload() {
        this.pRejected.report(0.0);
        if (logMINOR) {
            Logger.minor(this, "Success not overload on " + this + " : pRejected=" + this.pRejected.currentValue());
        }
        Peer peer = this.getPeer();
        long now = System.currentTimeMillis();
        this.reportBackoffStatus(now);
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (now > this.routingBackedOffUntil) {
                this.routingBackoffLength = 1000;
                if (logMINOR) {
                    Logger.minor(this, "Resetting routing backoff on " + peer);
                }
            } else {
                if (logMINOR) {
                    Logger.minor(this, "Ignoring successNotOverload: " + (this.routingBackedOffUntil - now) + "ms remaining on routing backoff on " + peer);
                }
                return;
            }
        }
        this.setPeerNodeStatus(now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferFailed(String reason) {
        assert (reason.indexOf(" ") == -1);
        this.pRejected.report(1.0);
        if (logMINOR) {
            Logger.minor(this, "Transfer failed (" + reason + ") on " + this + " : pRejected=" + this.pRejected.currentValue());
        }
        long now = System.currentTimeMillis();
        Peer peer = this.getPeer();
        this.reportBackoffStatus(now);
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (now > this.transferBackedOffUntil) {
                this.transferBackoffLength *= 2;
                if (this.transferBackoffLength > 10800000) {
                    this.transferBackoffLength = 10800000;
                }
                int x = this.node.random.nextInt(this.transferBackoffLength);
                this.transferBackedOffUntil = now + (long)x;
                String reasonWrapper = "";
                if (0 <= reason.length()) {
                    reasonWrapper = " because of '" + reason + '\'';
                }
                if (logMINOR) {
                    Logger.minor(this, "Backing off (transfer)" + reasonWrapper + ": transferBackoffLength=" + this.transferBackoffLength + ", until " + x + "ms on " + peer);
                }
            } else {
                if (logMINOR) {
                    Logger.minor(this, "Ignoring transfer failure: " + (this.transferBackedOffUntil - now) + "ms remaining on transfer backoff on " + peer);
                }
                return;
            }
            this.setLastBackoffReason(reason);
        }
        this.setPeerNodeStatus(now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferSuccess() {
        this.pRejected.report(0.0);
        if (logMINOR) {
            Logger.minor(this, "Transfer success on " + this + " : pRejected=" + this.pRejected.currentValue());
        }
        Peer peer = this.getPeer();
        long now = System.currentTimeMillis();
        this.reportBackoffStatus(now);
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (now > this.transferBackedOffUntil) {
                this.routingBackoffLength = 30000;
                if (logMINOR) {
                    Logger.minor(this, "Resetting transfer backoff on " + peer);
                }
            } else {
                if (logMINOR) {
                    Logger.minor(this, "Ignoring transfer success: " + (this.transferBackedOffUntil - now) + "ms remaining on transfer backoff on " + peer);
                }
                return;
            }
        }
        this.setPeerNodeStatus(now);
    }

    public double getPRejected() {
        return this.pRejected.currentValue();
    }

    public double averagePingTime() {
        return this.pingAverage.currentValue();
    }

    public void reportThrottledPacketSendTime(long timeDiff) {
        this.node.nodeStats.throttledPacketSendAverage.report(timeDiff);
        if (logMINOR) {
            Logger.minor(this, "Reporting throttled packet send time: " + timeDiff + " to " + this.getPeer());
        }
    }

    public void setRemoteDetectedPeer(Peer p) {
        this.remoteDetectedPeer = p;
    }

    public Peer getRemoteDetectedPeer() {
        return this.remoteDetectedPeer;
    }

    public synchronized int getRoutingBackoffLength() {
        return this.routingBackoffLength;
    }

    public synchronized long getRoutingBackedOffUntil() {
        return Math.max(this.routingBackedOffUntil, this.transferBackedOffUntil);
    }

    public synchronized String getLastBackoffReason() {
        return this.lastRoutingBackoffReason;
    }

    public synchronized String getPreviousBackoffReason() {
        return this.previousRoutingBackoffReason;
    }

    public synchronized void setLastBackoffReason(String s) {
        this.lastRoutingBackoffReason = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToLocalNodeSentMessagesToStatistic(Message m) {
        String messageSpecName = m.getSpec().getName();
        Hashtable<String, Long> hashtable = this.localNodeSentMessageTypes;
        synchronized (hashtable) {
            Long count = this.localNodeSentMessageTypes.get(messageSpecName);
            count = count == null ? Long.valueOf(1L) : Long.valueOf(count + 1L);
            this.localNodeSentMessageTypes.put(messageSpecName, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToLocalNodeReceivedMessagesFromStatistic(Message m) {
        String messageSpecName = m.getSpec().getName();
        Hashtable<String, Long> hashtable = this.localNodeReceivedMessageTypes;
        synchronized (hashtable) {
            Long count = this.localNodeReceivedMessageTypes.get(messageSpecName);
            count = count == null ? Long.valueOf(1L) : Long.valueOf(count + 1L);
            this.localNodeReceivedMessageTypes.put(messageSpecName, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, Long> getLocalNodeSentMessagesToStatistic() {
        Hashtable<String, Long> hashtable = this.localNodeSentMessageTypes;
        synchronized (hashtable) {
            return new Hashtable<String, Long>(this.localNodeSentMessageTypes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, Long> getLocalNodeReceivedMessagesFromStatistic() {
        Hashtable<String, Long> hashtable = this.localNodeReceivedMessageTypes;
        synchronized (hashtable) {
            return new Hashtable<String, Long>(this.localNodeReceivedMessageTypes);
        }
    }

    synchronized USK getARK() {
        return this.myARK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gotARK(SimpleFieldSet fs, long fetchedEdition) {
        try {
            PeerNode peerNode = this;
            synchronized (peerNode) {
                this.handshakeCount = 0;
                if (this.myARK.suggestedEdition < fetchedEdition + 1L) {
                    this.myARK = this.myARK.copy(fetchedEdition + 1L);
                }
            }
            this.processNewNoderef(fs, true, false);
        }
        catch (FSParseException e) {
            Logger.error(this, "Invalid ARK update: " + e, e);
            Logger.error(this, "Data was: \n" + fs.toString());
            PeerNode peerNode = this;
            synchronized (peerNode) {
                this.handshakeCount = 2;
            }
        }
    }

    public synchronized int getPeerNodeStatus() {
        return this.peerNodeStatus;
    }

    public String getPeerNodeStatusString() {
        int status = this.getPeerNodeStatus();
        return PeerNode.getPeerNodeStatusString(status);
    }

    public static String getPeerNodeStatusString(int status) {
        if (status == 1) {
            return "CONNECTED";
        }
        if (status == 2) {
            return "BACKED OFF";
        }
        if (status == 3) {
            return "TOO NEW";
        }
        if (status == 4) {
            return "TOO OLD";
        }
        if (status == 5) {
            return "DISCONNECTED";
        }
        if (status == 6) {
            return "NEVER CONNECTED";
        }
        if (status == 7) {
            return "DISABLED";
        }
        if (status == 11) {
            return "CLOCK PROBLEM";
        }
        if (status == 12) {
            return "CONNECTION ERROR";
        }
        if (status == 14) {
            return "ROUTING DISABLED";
        }
        if (status == 10) {
            return "LISTEN ONLY";
        }
        if (status == 9) {
            return "LISTENING";
        }
        if (status == 8) {
            return "BURSTING";
        }
        if (status == 13) {
            return "DISCONNECTING";
        }
        return "UNKNOWN STATUS";
    }

    public String getPeerNodeStatusCSSClassName() {
        int status = this.getPeerNodeStatus();
        return PeerNode.getPeerNodeStatusCSSClassName(status);
    }

    public static String getPeerNodeStatusCSSClassName(int status) {
        if (status == 1) {
            return "peer_connected";
        }
        if (status == 2) {
            return "peer_backed_off";
        }
        if (status == 3) {
            return "peer_too_new";
        }
        if (status == 4) {
            return "peer_too_old";
        }
        if (status == 5) {
            return "peer_disconnected";
        }
        if (status == 6) {
            return "peer_never_connected";
        }
        if (status == 7) {
            return "peer_disabled";
        }
        if (status == 14) {
            return "peer_routing_disabled";
        }
        if (status == 8) {
            return "peer_bursting";
        }
        if (status == 11) {
            return "peer_clock_problem";
        }
        if (status == 9) {
            return "peer_listening";
        }
        if (status == 10) {
            return "peer_listen_only";
        }
        if (status == 13) {
            return "peer_disconnecting";
        }
        return "peer_unknown_status";
    }

    protected synchronized int getPeerNodeStatus(long now, long routingBackedOffUntil) {
        this.checkConnectionsAndTrackers();
        if (this.disconnecting) {
            return 13;
        }
        if (this.isRoutable()) {
            this.peerNodeStatus = 1;
            if (now < routingBackedOffUntil) {
                this.peerNodeStatus = 2;
                if (!this.lastRoutingBackoffReason.equals(this.previousRoutingBackoffReason) || this.previousRoutingBackoffReason == null) {
                    if (this.previousRoutingBackoffReason != null) {
                        this.peers.removePeerNodeRoutingBackoffReason(this.previousRoutingBackoffReason, this);
                    }
                    this.peers.addPeerNodeRoutingBackoffReason(this.lastRoutingBackoffReason, this);
                    this.previousRoutingBackoffReason = this.lastRoutingBackoffReason;
                }
            } else if (this.previousRoutingBackoffReason != null) {
                this.peers.removePeerNodeRoutingBackoffReason(this.previousRoutingBackoffReason, this);
                this.previousRoutingBackoffReason = null;
            }
        } else if (this.isConnected() && this.bogusNoderef) {
            this.peerNodeStatus = 12;
        } else if (this.isConnected() && this.unroutableNewerVersion) {
            this.peerNodeStatus = 3;
        } else if (this.isConnected && this.unroutableOlderVersion) {
            this.peerNodeStatus = 4;
        } else if (this.isConnected && this.disableRouting) {
            this.peerNodeStatus = 14;
        } else if (this.isConnected && Math.abs(this.clockDelta) > 86400000L) {
            this.peerNodeStatus = 11;
        } else if (this.neverConnected) {
            this.peerNodeStatus = 6;
        } else {
            if (this.isBursting) {
                return 8;
            }
            this.peerNodeStatus = 5;
        }
        if (!this.isConnected && this.previousRoutingBackoffReason != null) {
            this.peers.removePeerNodeRoutingBackoffReason(this.previousRoutingBackoffReason, this);
            this.previousRoutingBackoffReason = null;
        }
        return this.peerNodeStatus;
    }

    public int setPeerNodeStatus(long now) {
        return this.setPeerNodeStatus(now, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setPeerNodeStatus(long now, boolean noLog) {
        long localRoutingBackedOffUntil = this.getRoutingBackedOffUntil();
        PeerNode peerNode = this;
        synchronized (peerNode) {
            int oldPeerNodeStatus = this.peerNodeStatus;
            this.peerNodeStatus = this.getPeerNodeStatus(now, localRoutingBackedOffUntil);
            if (this.peerNodeStatus != oldPeerNodeStatus && this.recordStatus()) {
                this.peers.removePeerNodeStatus(oldPeerNodeStatus, this, noLog);
                this.peers.addPeerNodeStatus(this.peerNodeStatus, this, noLog);
            }
        }
        return this.peerNodeStatus;
    }

    public abstract boolean recordStatus();

    private synchronized void checkConnectionsAndTrackers() {
        if (this.isConnected) {
            if (this.currentTracker == null) {
                if (this.unverifiedTracker != null) {
                    if (this.unverifiedTracker.packets.isDeprecated()) {
                        Logger.error(this, "Connected but primary tracker is null and unverified is deprecated ! " + this.unverifiedTracker + " for " + this, new Exception("debug"));
                    } else if (logMINOR) {
                        Logger.minor(this, "Connected but primary tracker is null, but unverified = " + this.unverifiedTracker + " for " + this, (Throwable)new Exception("debug"));
                    }
                } else {
                    Logger.error(this, "Connected but both primary and unverified are null on " + this, new Exception("debug"));
                }
            } else if (this.currentTracker.packets.isDeprecated()) {
                if (this.unverifiedTracker != null) {
                    if (this.unverifiedTracker.packets.isDeprecated()) {
                        Logger.error(this, "Connected but primary tracker is deprecated, unverified is deprecated: primary=" + this.currentTracker + " unverified: " + this.unverifiedTracker + " for " + this, new Exception("debug"));
                    } else if (logMINOR) {
                        Logger.minor(this, "Connected, primary tracker deprecated, unverified is valid, " + this.unverifiedTracker + " for " + this, (Throwable)new Exception("debug"));
                    }
                } else {
                    Logger.error(this, "Connected but primary tracker is deprecated and unverified tracker is null on " + this + " primary tracker = " + this.currentTracker, new Exception("debug"));
                    this.isConnected = false;
                }
            }
        }
    }

    public String getIdentityString() {
        return this.identityAsBase64String;
    }

    public boolean isFetchingARK() {
        return this.arkFetcher != null;
    }

    public synchronized int getHandshakeCount() {
        return this.handshakeCount;
    }

    synchronized void updateVersionRoutablity() {
        this.unroutableOlderVersion = this.forwardInvalidVersion();
        this.unroutableNewerVersion = this.reverseInvalidVersion();
    }

    public synchronized boolean noLongerRoutable() {
        return this.unroutableNewerVersion || this.unroutableOlderVersion || this.disableRouting;
    }

    protected synchronized void invalidate() {
        this.isRoutable = false;
        Logger.normal(this, "Invalidated " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeOnConnect() {
        if (this.wasDisconnected && this.isConnected()) {
            PeerNode peerNode = this;
            synchronized (peerNode) {
                this.wasDisconnected = false;
            }
            this.onConnect();
        } else if (!this.isConnected()) {
            PeerNode peerNode = this;
            synchronized (peerNode) {
                this.wasDisconnected = true;
            }
        }
    }

    protected void onConnect() {
        OpennetManager om = this.node.getOpennet();
        if (om != null) {
            om.dropExcessPeers();
        }
    }

    @Override
    public void onFound(USK origUSK, long edition, FetchResult result) {
        String ref;
        byte[] data;
        if (this.isConnected() || this.myARK.suggestedEdition > edition) {
            result.asBucket().free();
            return;
        }
        try {
            data = result.asByteArray();
        }
        catch (IOException e) {
            Logger.error(this, "I/O error reading fetched ARK: " + e, e);
            result.asBucket().free();
            return;
        }
        try {
            ref = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            result.asBucket().free();
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
        }
        try {
            SimpleFieldSet fs = new SimpleFieldSet(ref, false, true);
            if (logMINOR) {
                Logger.minor(this, "Got ARK for " + this);
            }
            this.gotARK(fs, edition);
        }
        catch (IOException e) {
            Logger.error(this, "Corrupt ARK reference? Fetched " + this.myARK.copy(edition) + " got while parsing: " + e + " from:\n" + ref, e);
        }
        result.asBucket().free();
    }

    public synchronized boolean noContactDetails() {
        return this.handshakeIPs == null || this.handshakeIPs.length == 0;
    }

    private synchronized void reportIncomingBytes(int length) {
        this.totalBytesIn += (long)length;
        this.totalBytesExchangedWithCurrentTracker += (long)length;
    }

    private synchronized void reportOutgoingBytes(int length) {
        this.totalBytesOut += (long)length;
        this.totalBytesExchangedWithCurrentTracker += (long)length;
    }

    public synchronized long getTotalInputBytes() {
        return this.totalBytesIn;
    }

    public synchronized long getTotalOutputBytes() {
        return this.totalBytesOut;
    }

    public synchronized long getTotalInputSinceStartup() {
        return this.totalInputSinceStartup;
    }

    public synchronized long getTotalOutputSinceStartup() {
        return this.totalOutputSinceStartup;
    }

    public boolean isSignatureVerificationSuccessfull() {
        return this.isSignatureVerificationSuccessfull;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRoutableConnectionStatus() {
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (this.isRoutable()) {
                ++this.hadRoutableConnectionCount;
            }
            ++this.routableConnectionCheckCount;
            if (this.routableConnectionCheckCount >= 200000L) {
                this.hadRoutableConnectionCount /= 2L;
                this.routableConnectionCheckCount /= 2L;
            }
        }
    }

    public synchronized double getPercentTimeRoutableConnection() {
        if (this.hadRoutableConnectionCount == 0L) {
            return 0.0;
        }
        return (double)this.hadRoutableConnectionCount / (double)this.routableConnectionCheckCount;
    }

    @Override
    public int getVersionNumber() {
        return Version.getArbitraryBuildNumber(this.getVersion(), -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PacketThrottle getThrottle() {
        PacketThrottle newThrottle = null;
        PacketThrottle prevThrottle = null;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            Peer peer = this.getPeer();
            if (peer == null) {
                return null;
            }
            if (this._lastThrottle != null && this._lastThrottle.getPeer().equals(peer)) {
                return this._lastThrottle;
            }
            newThrottle = new PacketThrottle(peer, 1024);
            prevThrottle = this._lastThrottle;
            this._lastThrottle = newThrottle;
        }
        if (prevThrottle != null) {
            prevThrottle.changedAddress(newThrottle);
        }
        return newThrottle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int selectNegType(OutgoingPacketMangler mangler) {
        int[] hisNegTypes;
        int[] myNegTypes = mangler.supportedNegTypes();
        PeerNode peerNode = this;
        synchronized (peerNode) {
            hisNegTypes = this.negTypes;
        }
        int bestNegType = -1;
        block3: for (int i = 0; i < myNegTypes.length; ++i) {
            int negType = myNegTypes[i];
            for (int j = 0; j < hisNegTypes.length; ++j) {
                if (hisNegTypes[j] != negType) continue;
                bestNegType = negType;
                continue block3;
            }
        }
        return bestNegType;
    }

    public boolean verify(byte[] hash, DSASignature sig) {
        return DSA.verify(this.peerPubKey, sig, new NativeBigInteger(1, hash), false);
    }

    public String userToString() {
        return "" + this.getPeer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeDelta(long delta) {
        PeerNode peerNode = this;
        synchronized (peerNode) {
            this.clockDelta = delta;
            if (Math.abs(this.clockDelta) > 86400000L) {
                this.isRoutable = false;
            }
        }
        this.setPeerNodeStatus(System.currentTimeMillis());
    }

    public long getClockDelta() {
        return this.clockDelta;
    }

    public void offer(Key key) {
        byte[] keyBytes = key.getFullKey();
        byte[] authenticator = HMAC.macWithSHA256(this.node.failureTable.offerAuthenticatorKey, keyBytes, 32);
        Message msg = DMT.createFNPOfferKey(key, authenticator);
        try {
            this.sendAsync(msg, null, this.node.nodeStats.sendOffersCtr);
        }
        catch (NotConnectedException e) {
            // empty catch block
        }
    }

    @Override
    public OutgoingPacketMangler getOutgoingMangler() {
        return this.outgoingMangler;
    }

    @Override
    public SocketHandler getSocketHandler() {
        return this.outgoingMangler.getSocketHandler();
    }

    public boolean isDisabled() {
        return false;
    }

    public boolean allowLocalAddresses() {
        return this.outgoingMangler.alwaysAllowLocalAddresses();
    }

    public boolean isIgnoreSource() {
        return false;
    }

    public static PeerNode create(SimpleFieldSet fs, Node node2, NodeCrypto crypto, OpennetManager opennet, PeerManager manager, boolean b, OutgoingPacketMangler mangler) throws FSParseException, PeerParseException, ReferenceSignatureVerificationException {
        if (crypto.isOpennet) {
            return new OpennetPeerNode(fs, node2, crypto, opennet, manager, b, mangler);
        }
        return new DarknetPeerNode(fs, node2, crypto, manager, b, mangler);
    }

    public byte[] getIdentity() {
        return this.identity;
    }

    public boolean neverConnected() {
        return this.neverConnected;
    }

    public abstract void onSuccess(boolean var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDisconnecting() {
        PeerNode peerNode = this;
        synchronized (peerNode) {
            this.disconnecting = true;
            this.jfkNoncesSent.clear();
        }
        this.setPeerNodeStatus(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceCancelDisconnecting() {
        PeerNode peerNode = this;
        synchronized (peerNode) {
            if (!this.disconnecting) {
                return;
            }
            this.disconnecting = false;
        }
        this.setPeerNodeStatus(System.currentTimeMillis(), true);
    }

    public void onRemove() {
        this.disconnected(true, true);
        this.stopARKFetcher();
    }

    public synchronized boolean isDisconnecting() {
        return this.disconnecting;
    }

    protected byte[] getJFKBuffer() {
        return this.jfkBuffer;
    }

    protected void setJFKBuffer(byte[] bufferJFK) {
        this.jfkBuffer = bufferJFK;
    }

    public int getSigParamsByteLength() {
        int bitLen = this.peerCryptoGroup.getQ().bitLength();
        int byteLen = bitLen / 8 + (bitLen % 8 != 0 ? 1 : 0);
        return byteLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportIncomingPacket(byte[] buf, int offset, int length, long now) {
        this.reportIncomingBytes(length);
        long hash = Fields.longHashCode(buf, offset, length);
        PeerNode peerNode = this;
        synchronized (peerNode) {
            this.packetsRecvTimes[this.recvPtr] = now;
            this.packetsRecvHashes[this.recvPtr] = hash;
            this.recvPtr = (short)(this.recvPtr + 1);
            if (this.recvPtr == 64) {
                this.recvPtr = 0;
                this.recvTrackPackets = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportOutgoingPacket(byte[] buf, int offset, int length, long now) {
        this.reportOutgoingBytes(length);
        long hash = Fields.longHashCode(buf, offset, length);
        PeerNode peerNode = this;
        synchronized (peerNode) {
            this.packetsSentTimes[this.sentPtr] = now;
            this.packetsSentHashes[this.sentPtr] = hash;
            this.sentPtr = (short)(this.sentPtr + 1);
            if (this.sentPtr == 64) {
                this.sentPtr = 0;
                this.sentTrackPackets = true;
            }
        }
    }

    public synchronized long[][] getSentPacketTimesHashes() {
        int count = this.sentTrackPackets ? 64 : (int)this.sentPtr;
        long[] times = new long[count];
        long[] hashes = new long[count];
        if (!this.sentTrackPackets) {
            System.arraycopy(this.packetsSentTimes, 0, times, 0, this.sentPtr);
            System.arraycopy(this.packetsSentHashes, 0, hashes, 0, this.sentPtr);
        } else {
            System.arraycopy(this.packetsSentTimes, this.sentPtr, times, 0, 64 - this.sentPtr);
            System.arraycopy(this.packetsSentTimes, 0, times, 64 - this.sentPtr, this.sentPtr);
            System.arraycopy(this.packetsSentHashes, this.sentPtr, hashes, 0, 64 - this.sentPtr);
            System.arraycopy(this.packetsSentHashes, 0, hashes, 64 - this.sentPtr, this.sentPtr);
        }
        return new long[][]{times, hashes};
    }

    public synchronized long[][] getRecvPacketTimesHashes() {
        int count = this.recvTrackPackets ? 64 : (int)this.recvPtr;
        long[] times = new long[count];
        long[] hashes = new long[count];
        if (!this.recvTrackPackets) {
            System.arraycopy(this.packetsRecvTimes, 0, times, 0, this.recvPtr);
            System.arraycopy(this.packetsRecvHashes, 0, hashes, 0, this.recvPtr);
        } else {
            System.arraycopy(this.packetsRecvTimes, this.recvPtr, times, 0, 64 - this.recvPtr);
            System.arraycopy(this.packetsRecvTimes, 0, times, 64 - this.recvPtr, this.recvPtr);
            System.arraycopy(this.packetsRecvHashes, this.recvPtr, hashes, 0, 64 - this.recvPtr);
            System.arraycopy(this.packetsRecvHashes, 0, hashes, 64 - this.recvPtr, this.recvPtr);
        }
        return new long[][]{times, hashes};
    }

    public void handleSentPackets(Message m) {
    }

    synchronized boolean manyPacketsClaimedSentNotReceived() {
        return this.manyPacketsClaimedSentNotReceived;
    }

    public synchronized boolean shouldAcceptAnnounce(long uid) {
        long now = System.currentTimeMillis();
        if (this.runningAnnounceUIDs.length < 1 && now - this.timeLastAcceptedAnnouncement > 1000L) {
            long[] newList = new long[this.runningAnnounceUIDs.length + 1];
            if (this.runningAnnounceUIDs.length > 0) {
                System.arraycopy(this.runningAnnounceUIDs, 0, newList, 0, this.runningAnnounceUIDs.length);
            }
            newList[this.runningAnnounceUIDs.length] = uid;
            this.timeLastAcceptedAnnouncement = now;
            return true;
        }
        return false;
    }

    public synchronized boolean completedAnnounce(long uid) {
        int runningAnnounceUIDsLength = this.runningAnnounceUIDs.length;
        if (runningAnnounceUIDsLength < 1) {
            return false;
        }
        long[] newList = new long[runningAnnounceUIDsLength - 1];
        int x = 0;
        for (int i = 0; i < this.runningAnnounceUIDs.length; ++i) {
            if (i == this.runningAnnounceUIDs.length) {
                return false;
            }
            long l = this.runningAnnounceUIDs[i];
            if (l == uid) continue;
            newList[x++] = l;
        }
        this.runningAnnounceUIDs = newList;
        if (x < this.runningAnnounceUIDs.length) {
            newList = new long[x];
            System.arraycopy(this.runningAnnounceUIDs, 0, newList, 0, x);
            this.runningAnnounceUIDs = newList;
        }
        return true;
    }

    public synchronized long timeLastDisconnect() {
        return this.timeLastDisconnect;
    }

    public abstract boolean isRealConnection();

    public boolean canAcceptAnnouncements() {
        return this.isOpennet() || this.node.passOpennetRefsThroughDarknet();
    }

    public boolean handshakeUnknownInitiator() {
        return false;
    }

    public int handshakeSetupType() {
        return -1;
    }

    public WeakReference<PeerNode> getWeakRef() {
        return this.myRef;
    }

    public Peer getHandshakeIP() {
        Peer ret;
        if (!this.shouldSendHandshake()) {
            if (logMINOR) {
                Logger.minor(this, "Not sending handshake to " + this.getPeer() + " because pn.shouldSendHandshake() returned false");
            }
            return null;
        }
        long firstTime = System.currentTimeMillis();
        Peer[] localHandshakeIPs = this.getHandshakeIPs();
        long secondTime = System.currentTimeMillis();
        if (secondTime - firstTime > 1000L) {
            Logger.error(this, "getHandshakeIPs() took more than a second to execute (" + (secondTime - firstTime) + ") working on " + this.userToString());
        }
        if (localHandshakeIPs.length == 0) {
            long thirdTime = System.currentTimeMillis();
            if (thirdTime - secondTime > 1000L) {
                Logger.error(this, "couldNotSendHandshake() (after getHandshakeIPs()) took more than a second to execute (" + (thirdTime - secondTime) + ") working on " + this.userToString());
            }
            return null;
        }
        long loopTime1 = System.currentTimeMillis();
        Vector<Peer> validIPs = new Vector<Peer>();
        for (int i = 0; i < localHandshakeIPs.length; ++i) {
            Peer peer = localHandshakeIPs[i];
            FreenetInetAddress addr = peer.getFreenetAddress();
            if (!this.outgoingMangler.allowConnection(this, addr) && logMINOR) {
                Logger.minor(this, "Not sending handshake packet to " + peer + " for " + this);
            }
            if (peer.getAddress(false) == null) {
                if (!logMINOR) continue;
                Logger.minor(this, "Not sending handshake to " + localHandshakeIPs[i] + " for " + this.getPeer() + " because the DNS lookup failed or it's a currently unsupported IPv6 address");
                continue;
            }
            if (!peer.isRealInternetAddress(false, false, this.allowLocalAddresses())) {
                if (!logMINOR) continue;
                Logger.minor(this, "Not sending handshake to " + localHandshakeIPs[i] + " for " + this.getPeer() + " because it's not a real Internet address and metadata.allowLocalAddresses is not true");
                continue;
            }
            validIPs.add(peer);
        }
        if (validIPs.isEmpty()) {
            ret = null;
        } else if (validIPs.size() == 1) {
            ret = (Peer)validIPs.get(0);
        } else {
            this.handshakeIPAlternator %= validIPs.size();
            ret = (Peer)validIPs.get(this.handshakeIPAlternator);
            ++this.handshakeIPAlternator;
        }
        long loopTime2 = System.currentTimeMillis();
        if (loopTime2 - loopTime1 > 1000L) {
            Logger.normal(this, "loopTime2 is more than a second after loopTime1 (" + (loopTime2 - loopTime1) + ") working on " + this.userToString());
        }
        return ret;
    }

    public void sendNodeToNodeMessage(SimpleFieldSet fs, int n2nType, boolean includeSentTime, long now, boolean queueOnNotConnected) {
        fs.putOverwrite("n2nType", Integer.toString(n2nType));
        if (includeSentTime) {
            fs.put("sentTime", now);
        }
        try {
            Message n2nm = DMT.createNodeToNodeMessage(n2nType, fs.toString().getBytes("UTF-8"));
            try {
                this.sendAsync(n2nm, null, this.node.nodeStats.nodeToNodeCounter);
            }
            catch (NotConnectedException e) {
                if (includeSentTime) {
                    fs.removeValue("sentTime");
                }
                if (this.isDarknet() && queueOnNotConnected) {
                    this.queueN2NM(fs);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
        }
    }

    public void queueN2NM(SimpleFieldSet fs) {
    }

    protected SimpleFieldSet getLocalNoderef() {
        return this.crypto.exportPublicFieldSet();
    }

    protected void sendConnectedDiffNoderef() {
        String[] physicalUDPEntries;
        SimpleFieldSet fs = new SimpleFieldSet(true);
        SimpleFieldSet nfs = this.getLocalNoderef();
        if (null == nfs) {
            return;
        }
        if (null != nfs.get("ark.pubURI")) {
            fs.putOverwrite("ark.pubURI", nfs.get("ark.pubURI"));
        }
        if (null != nfs.get("ark.number")) {
            fs.putOverwrite("ark.number", nfs.get("ark.number"));
        }
        if (this.isDarknet() && null != nfs.get("myName")) {
            fs.putOverwrite("myName", nfs.get("myName"));
        }
        if ((physicalUDPEntries = nfs.getAll("physical.udp")) != null) {
            fs.putOverwrite("physical.udp", physicalUDPEntries);
        }
        if (!fs.isEmpty()) {
            if (logMINOR) {
                Logger.minor(this, "fs is '" + fs.toString() + "'");
            }
            this.sendNodeToNodeMessage(fs, 2, false, 0L, false);
        } else if (logMINOR) {
            Logger.minor(this, "fs is empty");
        }
    }

    void handleFNPNetworkID(Message m) {
        int got = m.getInt("uid");
        if (logMINOR) {
            Logger.minor(this, "now peer thinks he is in network " + got);
        }
        if (this.providedNetworkID != got && this.assignedNetworkID != got) {
            this.providedNetworkID = got;
            this.node.netid.onPeerNodeChangedNetworkID(this);
        } else {
            this.providedNetworkID = got;
        }
    }

    void sendFNPNetworkID(ByteCounter ctr) throws NotConnectedException {
        if (this.assignedNetworkID != 0) {
            this.sendAsync(DMT.createFNPNetworkID(this.assignedNetworkID), null, ctr);
        }
    }

    public boolean shouldThrottle() {
        return PeerNode.shouldThrottle(this.getPeer(), this.node);
    }

    public static boolean shouldThrottle(Peer peer, Node node) {
        if (node.throttleLocalData) {
            return true;
        }
        if (peer == null) {
            return true;
        }
        InetAddress addr = peer.getAddress(false);
        if (addr == null) {
            return true;
        }
        return IPUtil.isValidAddress(addr, false);
    }

    public void reportPing(long t) {
        this.pingAverage.report(t);
    }

    public long getResendBytesSent() {
        return this.resendBytesSent;
    }

    @Override
    public void sendThrottledMessage(Message msg, int packetSize, ByteCounter ctr, int timeout, boolean blockForSend, AsyncMessageCallback callback) throws NotConnectedException, WaitedTooLongException, SyncSendWaitedTooLongException {
        long deadline = System.currentTimeMillis() + (long)timeout;
        if (logMINOR) {
            Logger.minor(this, "Sending throttled message with timeout " + timeout + " packet size " + packetSize + " to " + this.shortToString());
        }
        for (int i = 0; i < 100; ++i) {
            try {
                this.getThrottle().sendThrottledMessage(msg, this, packetSize, ctr, deadline, blockForSend, callback);
                return;
            }
            catch (ThrottleDeprecatedException e) {
                continue;
            }
        }
        Logger.error(this, "Peer constantly changes its IP address!!: " + this.shortToString());
        this.forceDisconnect(true);
        throw new NotConnectedException();
    }

    public boolean shouldDisconnectAndRemoveNow() {
        return false;
    }

    public void setUptime(byte uptime2) {
        this.uptime = uptime2;
    }

    public short getUptime() {
        return (short)(this.uptime & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementNumberOfSelections(long time) {
        PeerNode peerNode = this;
        synchronized (peerNode) {
            ++this.countSelectionsSinceConnected;
        }
    }

    public synchronized double selectionRate() {
        long timeSinceConnected = System.currentTimeMillis() - this.connectedTime;
        if (timeSinceConnected < 10000L) {
            return 0.0;
        }
        return (double)this.countSelectionsSinceConnected / (double)timeSinceConnected;
    }

    public void setMainJarOfferedVersion(long mainJarVersion) {
        this.offeredMainJarVersion = mainJarVersion;
    }

    public long getMainJarOfferedVersion() {
        return this.offeredMainJarVersion;
    }

    public void setExtJarOfferedVersion(long extJarVersion) {
        this.offeredExtJarVersion = extJarVersion;
    }

    public long getExtJarOfferedVersion() {
        return this.offeredExtJarVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean maybeSendPacket(long now, Vector<ResendPacketItem> rpiTemp, int[] rpiIntTemp) throws BlockedTooLongException {
        if (logMINOR) {
            Logger.minor(this, "maybeSendPacket: " + this);
        }
        boolean mustSend = false;
        boolean mustSendPacket = false;
        if (this.mustSendNotificationsNow(now)) {
            if (logMINOR) {
                Logger.minor(this, "Sending notification");
            }
            mustSend = true;
            mustSendPacket = true;
        }
        for (int j = 0; j < 2; ++j) {
            int[] tmp;
            SessionKey kt = j == 0 ? this.getCurrentKeyTracker() : this.getPreviousKeyTracker();
            if (kt == null || (tmp = kt.packets.grabResendPackets(rpiTemp, rpiIntTemp)) == null) continue;
            rpiIntTemp = tmp;
            for (ResendPacketItem item : rpiTemp) {
                if (item == null) continue;
                try {
                    if (logMINOR) {
                        Logger.minor(this, "Resending " + item.packetNumber + " to " + item.kt);
                    }
                    this.getOutgoingMangler().resend(item, kt);
                    return true;
                }
                catch (KeyChangedException e) {
                    Logger.error(this, "Caught " + e + " resending packets to " + kt);
                    this.requeueResendItems(rpiTemp);
                    return false;
                }
                catch (NotConnectedException e) {
                    Logger.normal(this, "Caught " + e + " resending packets to " + kt);
                    this.requeueResendItems(rpiTemp);
                    return false;
                }
                catch (PacketSequenceException e) {
                    Logger.error(this, "Caught " + e + " - disconnecting", e);
                    this.forceDisconnect(false);
                    return false;
                }
                catch (WouldBlockException e) {
                    Logger.error(this, "Impossible: " + e, e);
                    return false;
                }
            }
        }
        int minSize = this.getOutgoingMangler().fullHeadersLengthOneMessage();
        int maxSize = ((PacketSocketHandler)this.getSocketHandler()).getPacketSendThreshold();
        boolean keepalive = false;
        long lastSent = this.lastSentPacketTime();
        if (now - lastSent > 14000L) {
            if (logMINOR) {
                Logger.minor(this, "Sending keepalive");
            }
            if (now - lastSent > 140000L && lastSent > -1L) {
                Logger.error(this, "Long gap between sending packets: " + (now - lastSent) + " for " + this);
            }
            keepalive = true;
            mustSend = true;
            mustSendPacket = true;
        }
        ArrayList<MessageItem> messages = new ArrayList<MessageItem>(10);
        PeerMessageQueue peerMessageQueue = this.messageQueue;
        synchronized (peerMessageQueue) {
            if (!mustSend && this.messageQueue.mustSendNow(now)) {
                mustSend = true;
            }
            if (!mustSend && this.messageQueue.mustSendSize(minSize, maxSize)) {
                mustSend = true;
            }
            if (mustSend) {
                int size = minSize;
                boolean gotEnough = false;
                if ((size = this.messageQueue.addUrgentMessages(size, now, minSize, maxSize, messages)) < 0) {
                    gotEnough = true;
                    size = -size;
                }
                if (!gotEnough && (size = this.messageQueue.addNonUrgentMessages(size, now, minSize, maxSize, messages)) < 0) {
                    size = -size;
                }
            }
        }
        if (messages.isEmpty() && keepalive) {
            Message m = DMT.createFNPVoid();
            this.addToLocalNodeSentMessagesToStatistic(m);
            messages.add(new MessageItem(m, null, null, this));
        }
        if (!messages.isEmpty()) {
            if (!this.getOutgoingMangler().processOutgoingOrRequeue(messages.toArray(new MessageItem[messages.size()]), this, false, true) && mustSendPacket && !this.sendAnyUrgentNotifications(false)) {
                this.sendAnyUrgentNotifications(true);
            }
            return true;
        }
        if (mustSend) {
            if (this.sendAnyUrgentNotifications(false)) {
                return true;
            }
            Logger.normal(this, "No notifications sent despite no messages and mustSend=true for " + this);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getReusableTrackerID() {
        SessionKey cur;
        PeerNode peerNode = this;
        synchronized (peerNode) {
            cur = this.currentTracker;
        }
        if (cur == null) {
            if (logMINOR) {
                Logger.minor(this, "getReusableTrackerID(): cur = null on " + this);
            }
            return -1L;
        }
        if (cur.packets.isDeprecated()) {
            if (logMINOR) {
                Logger.minor(this, "getReusableTrackerID(): cur.packets.isDeprecated on " + this);
            }
            return -1L;
        }
        if (logMINOR) {
            Logger.minor(this, "getReusableTrackerID(): " + cur.packets.trackerID + " on " + this);
        }
        return cur.packets.trackerID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerTurtleTransfer(RequestSender sender) {
        Key key = sender.key;
        HashMap<Key, RequestSender> hashMap = this.turtlingTransfers;
        synchronized (hashMap) {
            if (this.turtlingTransfers.size() >= 3) {
                Logger.error(this, "Too many turtles for peer");
                return false;
            }
            if (this.turtlingTransfers.containsKey(key)) {
                Logger.error(this, "Already fetching key from peer");
                return false;
            }
            this.turtlingTransfers.put(key, sender);
            Logger.normal(this, "Turtles for " + this.getPeer() + " : " + this.turtlingTransfers.size());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterTurtleTransfer(RequestSender sender) {
        Key key = sender.key;
        HashMap<Key, RequestSender> hashMap = this.turtlingTransfers;
        synchronized (hashMap) {
            if (!this.turtlingTransfers.containsKey(key)) {
                Logger.error(this, "Removing turtle transfer " + sender + " for " + key + " from " + this + " : DOES NOT EXIST");
                return;
            }
            RequestSender oldSender = this.turtlingTransfers.remove(key);
            if (oldSender != sender) {
                Logger.error(this, "Removing turtle transfer " + sender + " for " + key + " from " + this + " : WRONG SENDER: " + oldSender);
                this.turtlingTransfers.put(key, oldSender);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTurtling(Key key) {
        HashMap<Key, RequestSender> hashMap = this.turtlingTransfers;
        synchronized (hashMap) {
            return this.turtlingTransfers.containsKey(key);
        }
    }

    static {
        try {
            TEST_AS_BYTES = "test".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
        }
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }

    private class SyncMessageCallback
    implements AsyncMessageCallback {
        private boolean done = false;
        private boolean disconnected = false;

        private SyncMessageCallback() {
        }

        public synchronized void waitForSend(long maxWaitInterval) throws NotConnectedException {
            long now = System.currentTimeMillis();
            long end = now + maxWaitInterval;
            while ((now = System.currentTimeMillis()) < end) {
                if (this.done) {
                    if (this.disconnected) {
                        throw new NotConnectedException();
                    }
                    return;
                }
                int waitTime = (int)Math.min(end - now, Integer.MAX_VALUE);
                try {
                    this.wait(waitTime);
                }
                catch (InterruptedException e) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acknowledged() {
            SyncMessageCallback syncMessageCallback = this;
            synchronized (syncMessageCallback) {
                if (this.done) {
                    return;
                }
                Logger.normal(this, "Acknowledged but not sent?! on " + this + " for " + PeerNode.this + " - lag ???");
                this.done = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnected() {
            SyncMessageCallback syncMessageCallback = this;
            synchronized (syncMessageCallback) {
                this.done = true;
                this.disconnected = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fatalError() {
            SyncMessageCallback syncMessageCallback = this;
            synchronized (syncMessageCallback) {
                this.done = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sent() {
            SyncMessageCallback syncMessageCallback = this;
            synchronized (syncMessageCallback) {
                this.done = true;
                this.notifyAll();
            }
        }
    }
}

