/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.node.MessageItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeerMessageQueue {
    private final PrioQueue[] queuesByPriority = new PrioQueue[5];

    PeerMessageQueue() {
        for (int i = 0; i < this.queuesByPriority.length; ++i) {
            this.queuesByPriority[i] = new PrioQueue();
        }
    }

    public synchronized int queueAndEstimateSize(MessageItem item) {
        this.enqueuePrioritizedMessageItem(item);
        int x = 0;
        for (PrioQueue pq : this.queuesByPriority) {
            if (pq.itemsNoID != null) {
                MessageItem messageItem;
                Iterator<Object> i$ = pq.itemsNoID.iterator();
                while (i$.hasNext() && (x += (messageItem = (MessageItem)i$.next()).getLength() + 2) <= 1024) {
                }
            }
            if (pq.itemsWithID == null) continue;
            for (LinkedList linkedList : pq.itemsWithID) {
                MessageItem it;
                Iterator i$ = linkedList.iterator();
                while (i$.hasNext() && (x += (it = (MessageItem)i$.next()).getLength() + 2) <= 1024) {
                }
            }
        }
        return x;
    }

    public synchronized long getMessageQueueLengthBytes() {
        long x = 0L;
        for (PrioQueue pq : this.queuesByPriority) {
            if (pq.itemsNoID != null) {
                for (MessageItem messageItem : pq.itemsNoID) {
                    x += (long)(messageItem.getLength() + 2);
                }
            }
            if (pq.itemsWithID == null) continue;
            for (LinkedList linkedList : pq.itemsWithID) {
                for (MessageItem it : linkedList) {
                    x += (long)(it.getLength() + 2);
                }
            }
        }
        return x;
    }

    private synchronized void enqueuePrioritizedMessageItem(MessageItem addMe) {
        short prio = addMe.getPriority();
        this.queuesByPriority[prio].addLast(addMe);
    }

    synchronized void pushfrontPrioritizedMessageItem(MessageItem addMe) {
        short prio = addMe.getPriority();
        this.queuesByPriority[prio].addFirst(addMe);
    }

    public synchronized MessageItem[] grabQueuedMessageItems() {
        int size = 0;
        for (int i = 0; i < this.queuesByPriority.length; ++i) {
            size += this.queuesByPriority[i].size();
        }
        MessageItem[] output = new MessageItem[size];
        int ptr = 0;
        for (PrioQueue queue : this.queuesByPriority) {
            ptr = queue.addTo(output, ptr);
            queue.clear();
        }
        return output;
    }

    public synchronized long getNextUrgentTime(long t, long now) {
        for (PrioQueue queue : this.queuesByPriority) {
            if ((t = Math.min(t, queue.getNextUrgentTime(t, now))) > now) continue;
            return t;
        }
        return t;
    }

    public boolean mustSendNow(long now) {
        return this.getNextUrgentTime(Long.MAX_VALUE, now) <= now;
    }

    public synchronized boolean mustSendSize(int minSize, int maxSize) {
        int length = minSize;
        for (PrioQueue items : this.queuesByPriority) {
            if ((length = items.addSize(length, maxSize)) <= maxSize) continue;
            return true;
        }
        return false;
    }

    public synchronized int addUrgentMessages(int size, long now, int minSize, int maxSize, ArrayList<MessageItem> messages) {
        boolean gotEnough = false;
        for (PrioQueue queue : this.queuesByPriority) {
            if ((size = queue.addUrgentMessages(size, minSize, maxSize, now, messages)) >= 0) continue;
            size = -size;
            gotEnough = true;
        }
        if (gotEnough) {
            return -size;
        }
        return size;
    }

    public synchronized int addNonUrgentMessages(int size, long now, int minSize, int maxSize, ArrayList<MessageItem> messages) {
        boolean gotEnough = false;
        for (PrioQueue queue : this.queuesByPriority) {
            if ((size = queue.addMessages(size, minSize, maxSize, now, messages)) >= 0) continue;
            size = -size;
            gotEnough = true;
        }
        if (gotEnough) {
            return -size;
        }
        return size;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrioQueue {
        LinkedList<MessageItem> itemsNoID;
        ArrayList<LinkedList<MessageItem>> itemsWithID;
        ArrayList<Long> itemsIDs;
        Map<Long, LinkedList<MessageItem>> itemsByID;
        private int roundRobinCounter;

        private PrioQueue() {
        }

        public void addLast(MessageItem item) {
            LinkedList<MessageItem> list;
            if (item.msg == null) {
                if (this.itemsNoID == null) {
                    this.itemsNoID = new LinkedList();
                }
                this.itemsNoID.addLast(item);
                return;
            }
            Object o = item.msg.getObject("uid");
            if (o == null || !(o instanceof Long)) {
                if (this.itemsNoID == null) {
                    this.itemsNoID = new LinkedList();
                }
                this.itemsNoID.addLast(item);
                return;
            }
            Long id = (Long)o;
            if (this.itemsByID == null) {
                this.itemsByID = new HashMap<Long, LinkedList<MessageItem>>();
                this.itemsWithID = new ArrayList();
                this.itemsIDs = new ArrayList();
                list = new LinkedList();
                this.itemsWithID.add(list);
                this.itemsIDs.add(id);
                this.itemsByID.put(id, list);
            } else {
                list = this.itemsByID.get(id);
                if (list == null) {
                    list = new LinkedList();
                    this.itemsWithID.add(list);
                    this.itemsByID.put(id, list);
                    this.itemsIDs.add(id);
                }
            }
            list.addLast(item);
        }

        public void addFirst(MessageItem item) {
            LinkedList<MessageItem> list;
            if (item.msg == null) {
                if (this.itemsNoID == null) {
                    this.itemsNoID = new LinkedList();
                }
                this.itemsNoID.addFirst(item);
                return;
            }
            Object o = item.msg.getObject("uid");
            if (o == null || !(o instanceof Long)) {
                if (this.itemsNoID == null) {
                    this.itemsNoID = new LinkedList();
                }
                this.itemsNoID.addFirst(item);
                return;
            }
            Long id = (Long)o;
            if (this.itemsByID == null) {
                this.itemsByID = new HashMap<Long, LinkedList<MessageItem>>();
                this.itemsWithID = new ArrayList();
                this.itemsIDs = new ArrayList();
                list = new LinkedList();
                this.itemsWithID.add(list);
                this.itemsIDs.add(id);
                this.itemsByID.put(id, list);
            } else {
                list = this.itemsByID.get(id);
                if (list == null) {
                    list = new LinkedList();
                    this.itemsWithID.add(list);
                    this.itemsIDs.add(id);
                    this.itemsByID.put(id, list);
                }
            }
            list.addFirst(item);
        }

        public int size() {
            int size = 0;
            if (this.itemsNoID != null) {
                size += this.itemsNoID.size();
            }
            if (this.itemsWithID != null) {
                for (LinkedList<MessageItem> list : this.itemsWithID) {
                    size += list.size();
                }
            }
            return size;
        }

        public int addTo(MessageItem[] output, int ptr) {
            if (this.itemsNoID != null) {
                for (MessageItem messageItem : this.itemsNoID) {
                    output[ptr++] = messageItem;
                }
            }
            if (this.itemsWithID != null) {
                for (LinkedList linkedList : this.itemsWithID) {
                    for (MessageItem item : linkedList) {
                        output[ptr++] = item;
                    }
                }
            }
            return ptr;
        }

        public long getNextUrgentTime(long t, long now) {
            if (this.itemsNoID != null && (t = Math.min(t, this.itemsNoID.getFirst().submitted + 100L)) <= now) {
                return t;
            }
            if (this.itemsWithID != null) {
                for (LinkedList<MessageItem> items : this.itemsWithID) {
                    if ((t = Math.min(t, items.getFirst().submitted + 100L)) > now) continue;
                    return t;
                }
            }
            return t;
        }

        public int addSize(int length, int maxSize) {
            if (this.itemsNoID != null) {
                for (MessageItem messageItem : this.itemsNoID) {
                    int thisLen = messageItem.getLength();
                    if ((length += thisLen) <= maxSize) continue;
                    return length;
                }
            }
            if (this.itemsWithID != null) {
                for (LinkedList linkedList : this.itemsWithID) {
                    for (MessageItem item : linkedList) {
                        int thisLen = item.getLength();
                        if ((length += thisLen) <= maxSize) continue;
                        return length;
                    }
                }
            }
            return length;
        }

        private int addMessages(int size, int minSize, int maxSize, long now, ArrayList<MessageItem> messages, boolean isUrgent) {
            int lists = 0;
            if (this.itemsNoID != null) {
                ++lists;
            }
            if (this.itemsWithID != null) {
                lists += this.itemsWithID.size();
            }
            block0: for (int i = 0; i < lists; ++i) {
                LinkedList<MessageItem> list;
                int l = (i + this.roundRobinCounter + 1) % lists;
                int listNum = -1;
                if (this.itemsNoID != null) {
                    if (l == 0) {
                        list = this.itemsNoID;
                    } else {
                        listNum = l - 1;
                        list = this.itemsWithID.get(listNum);
                    }
                } else {
                    listNum = l;
                    list = this.itemsWithID.get(l);
                }
                while (!list.isEmpty()) {
                    Long id;
                    MessageItem item = list.getFirst();
                    if (isUrgent && item.submitted + 100L > now) continue block0;
                    int thisSize = item.getLength();
                    if (size + 2 + thisSize > maxSize) {
                        if (size == minSize) {
                            size += 2 + thisSize;
                            list.removeFirst();
                            if (list.isEmpty()) {
                                if (list == this.itemsNoID) {
                                    this.itemsNoID = null;
                                    --lists;
                                } else {
                                    id = this.itemsIDs.get(listNum);
                                    this.itemsWithID.remove(listNum);
                                    this.itemsIDs.remove(listNum);
                                    this.itemsByID.remove(id);
                                    --lists;
                                }
                            }
                            messages.add(item);
                            this.roundRobinCounter = i;
                            return size;
                        }
                        return -size;
                    }
                    size += 2 + thisSize;
                    list.removeFirst();
                    if (list.isEmpty()) {
                        if (list == this.itemsNoID) {
                            this.itemsNoID = null;
                            --lists;
                        } else {
                            id = this.itemsIDs.get(listNum);
                            this.itemsWithID.remove(listNum);
                            this.itemsIDs.remove(listNum);
                            this.itemsByID.remove(id);
                            --lists;
                        }
                    }
                    messages.add(item);
                    this.roundRobinCounter = i;
                }
            }
            return size;
        }

        public int addUrgentMessages(int size, int minSize, int maxSize, long now, ArrayList<MessageItem> messages) {
            return this.addMessages(size, minSize, maxSize, now, messages, true);
        }

        public int addMessages(int size, int minSize, int maxSize, long now, ArrayList<MessageItem> messages) {
            return this.addMessages(size, minSize, maxSize, now, messages, false);
        }

        public void clear() {
            this.itemsNoID = null;
            this.itemsWithID = null;
            this.itemsIDs = null;
            this.itemsByID = null;
        }
    }
}

