/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.AsyncMessageCallback;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.FreenetInetAddress;
import freenet.io.comm.Message;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.Peer;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.keys.Key;
import freenet.node.DarknetPeerNode;
import freenet.node.DarknetPeerNodeStatus;
import freenet.node.FNPPacketMangler;
import freenet.node.FSParseException;
import freenet.node.Location;
import freenet.node.Node;
import freenet.node.NodeCrypto;
import freenet.node.OpennetManager;
import freenet.node.OpennetPeerNode;
import freenet.node.OpennetPeerNodeStatus;
import freenet.node.OutgoingPacketMangler;
import freenet.node.PeerNode;
import freenet.node.PeerNodeStatus;
import freenet.node.SeedClientPeerNode;
import freenet.node.SeedServerPeerNode;
import freenet.node.TimedOutNodesList;
import freenet.node.Version;
import freenet.node.useralerts.PeerManagerUserAlert;
import freenet.support.ByteArrayWrapper;
import freenet.support.Logger;
import freenet.support.ShortBuffer;
import freenet.support.SimpleFieldSet;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeerManager {
    private static boolean logMINOR;
    final Node node;
    PeerNode[] myPeers;
    PeerNode[] connectedPeers;
    private String darkFilename;
    private String openFilename;
    private PeerManagerUserAlert ua;
    private long oldestNeverConnectedPeerAge;
    private long nextOldestNeverConnectedPeerAgeUpdateTime = -1L;
    private static final long oldestNeverConnectedPeerAgeUpdateInterval = 5000L;
    private long nextPeerNodeStatusLogTime = -1L;
    private static final long peerNodeStatusLogInterval = 5000L;
    private final HashMap<Integer, HashSet<PeerNode>> peerNodeStatuses;
    private final HashMap<Integer, HashSet<PeerNode>> peerNodeStatusesDarknet;
    private final HashMap<String, HashSet<PeerNode>> peerNodeRoutingBackoffReasons;
    private long nextRoutableConnectionStatsUpdateTime = -1L;
    private static final long routableConnectionStatsUpdateInterval = 7000L;
    private volatile boolean shouldWritePeers = false;
    private static final int MIN_WRITEPEERS_DELAY = 5000;
    private final Runnable writePeersRunnable = new Runnable(){

        public void run() {
            if (PeerManager.this.shouldWritePeers) {
                PeerManager.this.shouldWritePeers = false;
                PeerManager.this.writePeersInner();
            }
            PeerManager.this.node.ps.queueTimedJob(PeerManager.this.writePeersRunnable, 5000L);
        }
    };
    public static final int PEER_NODE_STATUS_CONNECTED = 1;
    public static final int PEER_NODE_STATUS_ROUTING_BACKED_OFF = 2;
    public static final int PEER_NODE_STATUS_TOO_NEW = 3;
    public static final int PEER_NODE_STATUS_TOO_OLD = 4;
    public static final int PEER_NODE_STATUS_DISCONNECTED = 5;
    public static final int PEER_NODE_STATUS_NEVER_CONNECTED = 6;
    public static final int PEER_NODE_STATUS_DISABLED = 7;
    public static final int PEER_NODE_STATUS_BURSTING = 8;
    public static final int PEER_NODE_STATUS_LISTENING = 9;
    public static final int PEER_NODE_STATUS_LISTEN_ONLY = 10;
    public static final int PEER_NODE_STATUS_CLOCK_PROBLEM = 11;
    public static final int PEER_NODE_STATUS_CONN_ERROR = 12;
    public static final int PEER_NODE_STATUS_DISCONNECTING = 13;
    public static final int PEER_NODE_STATUS_ROUTING_DISABLED = 14;
    long timeFirstAnyConnections = 0L;
    final ByteCounter ctrDisconn = new ByteCounter(){

        public void receivedBytes(int x) {
            PeerManager.this.node.nodeStats.disconnBytesReceived(x);
        }

        public void sentBytes(int x) {
            PeerManager.this.node.nodeStats.disconnBytesSent(x);
        }

        public void sentPayload(int x) {
        }
    };
    private final Object writePeersSync = new Object();
    private final Object writePeerFileSync = new Object();

    public PeerManager(Node node) {
        Logger.normal(this, "Creating PeerManager");
        logMINOR = Logger.shouldLog(4, this);
        this.peerNodeStatuses = new HashMap();
        this.peerNodeStatusesDarknet = new HashMap();
        this.peerNodeRoutingBackoffReasons = new HashMap();
        System.out.println("Creating PeerManager");
        this.myPeers = new PeerNode[0];
        this.connectedPeers = new PeerNode[0];
        this.node = node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryReadPeers(String filename, NodeCrypto crypto, OpennetManager opennet, boolean isOpennet, boolean oldOpennetPeers) {
        Object object = this.writePeersSync;
        synchronized (object) {
            if (!oldOpennetPeers) {
                if (isOpennet) {
                    this.openFilename = filename;
                } else {
                    this.darkFilename = filename;
                }
            }
        }
        FNPPacketMangler mangler = crypto.packetMangler;
        File peersFile = new File(filename);
        File backupFile = new File(filename + ".bak");
        if (peersFile.exists() && this.readPeers(peersFile, mangler, crypto, opennet, oldOpennetPeers)) {
            String msg = oldOpennetPeers ? "Read " + opennet.countOldOpennetPeers() + " old-opennet-peers from " + peersFile : (isOpennet ? "Read " + this.getOpennetPeers().length + " opennet peers from " + peersFile : "Read " + this.getDarknetPeers().length + " darknet peers from " + peersFile);
            Logger.normal(this, msg);
            System.out.println(msg);
            return;
        }
        if (backupFile.exists()) {
            if (this.readPeers(backupFile, mangler, crypto, opennet, oldOpennetPeers)) {
                String msg = oldOpennetPeers ? "Read " + opennet.countOldOpennetPeers() + " old-opennet-peers from " + peersFile : (isOpennet ? "Read " + this.getOpennetPeers().length + " opennet peers from " + peersFile : "Read " + this.getDarknetPeers().length + " darknet peers from " + peersFile);
                Logger.normal(this, msg);
                System.out.println(msg);
            } else {
                Logger.error(this, "No (readable) peers file with peers in it found");
                System.err.println("No (readable) peers file with peers in it found");
            }
        }
    }

    private boolean readPeers(File peersFile, OutgoingPacketMangler mangler, NodeCrypto crypto, OpennetManager opennet, boolean oldOpennetPeers) {
        InputStreamReader ris;
        FileInputStream fis;
        boolean gotSome = false;
        try {
            fis = new FileInputStream(peersFile);
        }
        catch (FileNotFoundException e4) {
            Logger.normal(this, "Peers file not found: " + peersFile);
            return false;
        }
        try {
            ris = new InputStreamReader((InputStream)fis, "UTF-8");
        }
        catch (UnsupportedEncodingException e4) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e4, e4);
        }
        BufferedReader br = new BufferedReader(ris);
        try {
            while (true) {
                PeerNode pn;
                SimpleFieldSet fs = new SimpleFieldSet(br, false, true);
                try {
                    pn = PeerNode.create(fs, this.node, crypto, opennet, this, true, mangler);
                }
                catch (FSParseException e2) {
                    Logger.error(this, "Could not parse peer: " + e2 + '\n' + fs.toString(), e2);
                    continue;
                }
                catch (PeerParseException e2) {
                    Logger.error(this, "Could not parse peer: " + e2 + '\n' + fs.toString(), e2);
                    continue;
                }
                catch (ReferenceSignatureVerificationException e2) {
                    Logger.error(this, "Could not parse peer: " + e2 + '\n' + fs.toString(), e2);
                    continue;
                }
                if (oldOpennetPeers) {
                    opennet.addOldOpennetNode(pn);
                } else {
                    this.addPeer(pn, true, false);
                }
                gotSome = true;
            }
        }
        catch (EOFException e) {
        }
        catch (IOException e1) {
            Logger.error(this, "Could not read peers file: " + e1, e1);
        }
        try {
            br.close();
        }
        catch (IOException e3) {
            Logger.error(this, "Ignoring " + e3 + " caught reading " + peersFile, e3);
        }
        return gotSome;
    }

    public boolean addPeer(PeerNode pn) {
        return this.addPeer(pn, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addPeer(PeerNode pn, boolean ignoreOpennet, boolean reactivate) {
        assert (pn != null);
        if (reactivate) {
            pn.forceCancelDisconnecting();
        }
        PeerManager peerManager = this;
        synchronized (peerManager) {
            for (int i = 0; i < this.myPeers.length; ++i) {
                if (!this.myPeers[i].equals(pn)) continue;
                if (logMINOR) {
                    Logger.minor(this, "Can't add peer " + pn + " because already have " + this.myPeers[i], (Throwable)new Exception("debug"));
                }
                return false;
            }
            PeerNode[] newMyPeers = new PeerNode[this.myPeers.length + 1];
            System.arraycopy(this.myPeers, 0, newMyPeers, 0, this.myPeers.length);
            newMyPeers[this.myPeers.length] = pn;
            this.myPeers = newMyPeers;
            Logger.normal(this, "Added " + pn);
        }
        if (pn.recordStatus()) {
            this.addPeerNodeStatus(pn.getPeerNodeStatus(), pn, false);
        }
        pn.setPeerNodeStatus(System.currentTimeMillis());
        this.updatePMUserAlert();
        if (!ignoreOpennet && pn instanceof OpennetPeerNode) {
            OpennetManager opennet = this.node.getOpennet();
            if (opennet != null) {
                opennet.forceAddPeer(pn, true);
            } else {
                Logger.error(this, "Adding opennet peer when no opennet enabled!!!: " + pn + " - removing...");
                this.removePeer(pn);
                return false;
            }
        }
        return true;
    }

    synchronized boolean havePeer(PeerNode pn) {
        for (int i = 0; i < this.myPeers.length; ++i) {
            if (this.myPeers[i] != pn) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removePeer(PeerNode pn) {
        if (logMINOR) {
            Logger.minor(this, "Removing " + pn);
        }
        boolean isInPeers = false;
        PeerManager peerManager = this;
        synchronized (peerManager) {
            for (int i = 0; i < this.myPeers.length; ++i) {
                if (this.myPeers[i] != pn) continue;
                isInPeers = true;
            }
            if (pn instanceof DarknetPeerNode) {
                ((DarknetPeerNode)pn).removeExtraPeerDataDir();
            }
            if (isInPeers) {
                String peerNodePreviousRoutingBackoffReason;
                int peerNodeStatus = pn.getPeerNodeStatus();
                if (pn.recordStatus()) {
                    this.removePeerNodeStatus(peerNodeStatus, pn, !isInPeers);
                }
                if ((peerNodePreviousRoutingBackoffReason = pn.getPreviousBackoffReason()) != null) {
                    this.removePeerNodeRoutingBackoffReason(peerNodePreviousRoutingBackoffReason, pn);
                }
                ArrayList<PeerNode> a = new ArrayList<PeerNode>();
                for (PeerNode mp : this.myPeers) {
                    if (mp == pn || !mp.isConnected() || !mp.isRealConnection()) continue;
                    a.add(mp);
                }
                PeerNode[] newConnectedPeers = new PeerNode[a.size()];
                newConnectedPeers = a.toArray(newConnectedPeers);
                this.connectedPeers = newConnectedPeers;
                PeerNode[] newMyPeers = new PeerNode[this.myPeers.length - 1];
                int positionInNewArray = 0;
                for (PeerNode mp : this.myPeers) {
                    if (mp == pn) continue;
                    newMyPeers[positionInNewArray] = mp;
                    ++positionInNewArray;
                }
                this.myPeers = newMyPeers;
                Logger.normal(this, "Removed " + pn);
            }
        }
        pn.onRemove();
        if (isInPeers) {
            this.updatePMUserAlert();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAllPeers() {
        PeerNode[] oldPeers;
        Logger.normal(this, "removeAllPeers!");
        PeerManager peerManager = this;
        synchronized (peerManager) {
            oldPeers = this.myPeers;
            this.myPeers = new PeerNode[0];
            this.connectedPeers = new PeerNode[0];
        }
        for (int i = 0; i < oldPeers.length; ++i) {
            oldPeers[i].onRemove();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disconnected(PeerNode pn) {
        PeerManager peerManager = this;
        synchronized (peerManager) {
            boolean isInPeers = false;
            for (int i = 0; i < this.connectedPeers.length; ++i) {
                if (this.connectedPeers[i] != pn) continue;
                isInPeers = true;
            }
            if (!isInPeers) {
                return false;
            }
            ArrayList<PeerNode> a = new ArrayList<PeerNode>();
            for (PeerNode mp : this.myPeers) {
                if (mp == pn || !mp.isRoutable()) continue;
                a.add(mp);
            }
            PeerNode[] newConnectedPeers = new PeerNode[a.size()];
            newConnectedPeers = a.toArray(newConnectedPeers);
            this.connectedPeers = newConnectedPeers;
        }
        this.updatePMUserAlert();
        this.node.lm.announceLocChange();
        return true;
    }

    public long getTimeFirstAnyConnections() {
        return this.timeFirstAnyConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectedPeer(PeerNode pn) {
        logMINOR = Logger.shouldLog(4, this);
        if (!pn.isRealConnection()) {
            if (logMINOR) {
                Logger.minor(this, "Not a real connection: " + pn);
            }
            return;
        }
        if (!pn.isConnected()) {
            if (logMINOR) {
                Logger.minor(this, "Not connected: " + pn);
            }
            return;
        }
        long now = System.currentTimeMillis();
        PeerManager peerManager = this;
        synchronized (peerManager) {
            if (this.timeFirstAnyConnections == 0L) {
                this.timeFirstAnyConnections = now;
            }
            for (int i = 0; i < this.connectedPeers.length; ++i) {
                if (this.connectedPeers[i] != pn) continue;
                if (logMINOR) {
                    Logger.minor(this, "Already connected: " + pn);
                }
                return;
            }
            boolean inMyPeers = false;
            for (int i = 0; i < this.myPeers.length; ++i) {
                if (this.myPeers[i] != pn) continue;
                inMyPeers = true;
                break;
            }
            if (!inMyPeers) {
                Logger.error(this, "Connecting to " + pn + " but not in peers!");
                this.addPeer(pn);
            }
            if (logMINOR) {
                Logger.minor(this, "Connecting: " + pn);
            }
            PeerNode[] newConnectedPeers = new PeerNode[this.connectedPeers.length + 1];
            System.arraycopy(this.connectedPeers, 0, newConnectedPeers, 0, this.connectedPeers.length);
            newConnectedPeers[this.connectedPeers.length] = pn;
            this.connectedPeers = newConnectedPeers;
            if (logMINOR) {
                Logger.minor(this, "Connected peers: " + this.connectedPeers.length);
            }
        }
        this.updatePMUserAlert();
        this.node.lm.announceLocChange();
    }

    public PeerNode getByPeer(Peer peer) {
        for (int i = 0; i < this.myPeers.length; ++i) {
            if (!this.myPeers[i].isRealConnection() || !peer.equals(this.myPeers[i].getPeer())) continue;
            return this.myPeers[i];
        }
        return null;
    }

    public void connect(SimpleFieldSet noderef, OutgoingPacketMangler mangler) throws FSParseException, PeerParseException, ReferenceSignatureVerificationException {
        DarknetPeerNode pn = this.node.createNewDarknetNode(noderef);
        for (int i = 0; i < this.myPeers.length; ++i) {
            if (!Arrays.equals(this.myPeers[i].identity, pn.identity)) continue;
            return;
        }
        this.addPeer(pn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(final PeerNode pn, boolean sendDisconnectMessage, final boolean waitForAck, boolean purge) {
        if (logMINOR) {
            Logger.minor(this, "Disconnecting " + pn.shortToString());
        }
        PeerManager peerManager = this;
        synchronized (peerManager) {
            if (!this.havePeer(pn)) {
                return;
            }
        }
        pn.notifyDisconnecting();
        if (sendDisconnectMessage) {
            Message msg = DMT.createFNPDisconnect(true, purge, -1, new ShortBuffer(new byte[0]));
            try {
                pn.sendAsync(msg, new AsyncMessageCallback(){
                    boolean done = false;

                    public void acknowledged() {
                        this.done();
                    }

                    public void disconnected() {
                        this.done();
                    }

                    public void fatalError() {
                        this.done();
                    }

                    public void sent() {
                        if (!waitForAck) {
                            this.done();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    void done() {
                        2 var1_1 = this;
                        synchronized (var1_1) {
                            if (this.done) {
                                return;
                            }
                            this.done = true;
                        }
                        if (PeerManager.this.removePeer(pn)) {
                            PeerManager.this.writePeers();
                        }
                    }
                }, this.ctrDisconn);
            }
            catch (NotConnectedException e) {
                if (pn.isDisconnecting() && this.removePeer(pn)) {
                    this.writePeers();
                }
                return;
            }
            this.node.getTicker().queueTimedJob(new Runnable(){

                public void run() {
                    if (pn.isDisconnecting() && PeerManager.this.removePeer(pn)) {
                        PeerManager.this.writePeers();
                    }
                }
            }, 60000L);
        } else if (this.removePeer(pn)) {
            this.writePeers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getPeerLocationDoubles(boolean pruneBackedOffPeers) {
        PeerNode[] conns;
        if (!this.node.shallWePublishOurPeersLocation()) {
            return new double[0];
        }
        PeerManager peerManager = this;
        synchronized (peerManager) {
            conns = this.connectedPeers;
        }
        double[] locs = new double[conns.length];
        int x = 0;
        for (int i = 0; i < conns.length; ++i) {
            if (!conns[i].isRoutable() || pruneBackedOffPeers && conns[i].shouldBeExcludedFromPeerList()) continue;
            locs[x++] = conns[i].getLocation();
        }
        Arrays.sort(locs, 0, x);
        if (x != locs.length) {
            double[] newLocs = new double[x];
            System.arraycopy(locs, 0, newLocs, 0, x);
            return newLocs;
        }
        return locs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocationUIDPair[] getPeerLocationsAndUIDs() {
        PeerNode[] conns;
        PeerManager peerManager = this;
        synchronized (peerManager) {
            conns = this.myPeers;
        }
        Object[] locPairs = new LocationUIDPair[conns.length];
        int x = 0;
        for (int i = 0; i < conns.length; ++i) {
            if (!conns[i].isRoutable()) continue;
            locPairs[x++] = new LocationUIDPair(conns[i]);
        }
        Arrays.sort(locPairs, 0, x);
        if (x != locPairs.length) {
            LocationUIDPair[] newLocs = new LocationUIDPair[x];
            System.arraycopy(locPairs, 0, newLocs, 0, x);
            return newLocs;
        }
        return locPairs;
    }

    public synchronized PeerNode getRandomPeer(PeerNode exclude) {
        if (this.connectedPeers.length == 0) {
            return null;
        }
        for (int i = 0; i < 5; ++i) {
            PeerNode pn = this.connectedPeers[this.node.random.nextInt(this.connectedPeers.length)];
            if (pn == exclude || !pn.isRoutable()) continue;
            return pn;
        }
        ArrayList<PeerNode> v = new ArrayList<PeerNode>(this.connectedPeers.length);
        logMINOR = Logger.shouldLog(4, this);
        for (PeerNode pn : this.myPeers) {
            if (pn == exclude) continue;
            if (pn.isRoutable()) {
                v.add(pn);
                continue;
            }
            if (!logMINOR) continue;
            Logger.minor(this, "Excluding " + pn + " because is disconnected");
        }
        int lengthWithoutExcluded = v.size();
        if (exclude != null && exclude.isRoutable()) {
            v.add(exclude);
        }
        PeerNode[] newConnectedPeers = new PeerNode[v.size()];
        newConnectedPeers = v.toArray(newConnectedPeers);
        if (logMINOR) {
            Logger.minor(this, "Connected peers (in getRandomPeer): " + newConnectedPeers.length + " was " + this.connectedPeers.length);
        }
        this.connectedPeers = newConnectedPeers;
        if (lengthWithoutExcluded == 0) {
            return null;
        }
        return this.connectedPeers[this.node.random.nextInt(lengthWithoutExcluded)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void localBroadcast(Message msg, boolean ignoreRoutability, boolean onlyRealConnections, ByteCounter ctr) {
        PeerNode[] peers;
        PeerManager peerManager = this;
        synchronized (peerManager) {
            peers = this.myPeers;
        }
        for (int i = 0; i < peers.length; ++i) {
            if (!ignoreRoutability ? !peers[i].isRoutable() : !peers[i].isConnected()) continue;
            if (onlyRealConnections && !peers[i].isRealConnection()) continue;
            try {
                peers[i].sendAsync(msg, null, ctr);
                continue;
            }
            catch (NotConnectedException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void locallyBroadcastDiffNodeRef(SimpleFieldSet fs, boolean toDarknetOnly, boolean toOpennetOnly) {
        PeerNode[] peers;
        PeerManager peerManager = this;
        synchronized (peerManager) {
            peers = this.myPeers;
        }
        for (int i = 0; i < peers.length; ++i) {
            if (!peers[i].isConnected() || toDarknetOnly && !peers[i].isDarknet() || toOpennetOnly && !peers[i].isOpennet()) continue;
            peers[i].sendNodeToNodeMessage(fs, 2, false, 0L, false);
        }
    }

    public PeerNode getRandomPeer() {
        return this.getRandomPeer(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double closestPeerLocation(double loc, double ignoreLoc, int minUptimePercent) {
        double diff;
        double peerloc;
        PeerNode p;
        int i;
        PeerNode[] peers;
        PeerManager peerManager = this;
        synchronized (peerManager) {
            peers = this.connectedPeers;
        }
        double bestDiff = 1.0;
        double bestLoc = Double.MAX_VALUE;
        boolean foundOne = false;
        for (i = 0; i < peers.length; ++i) {
            p = peers[i];
            if (!p.isRoutable() || p.isRoutingBackedOff() || p.getUptime() < minUptimePercent || Math.abs((peerloc = p.getLocation()) - ignoreLoc) < 9.9E-324 || !((diff = Location.distance(peerloc, loc)) < bestDiff)) continue;
            foundOne = true;
            bestDiff = diff;
            bestLoc = peerloc;
        }
        if (!foundOne) {
            for (i = 0; i < peers.length; ++i) {
                p = peers[i];
                if (!p.isRoutable() || p.getUptime() < minUptimePercent || Math.abs((peerloc = p.getLocation()) - ignoreLoc) < 9.9E-324 || !((diff = Location.distance(peerloc, loc)) < bestDiff)) continue;
                foundOne = true;
                bestDiff = diff;
                bestLoc = peerloc;
            }
        }
        return bestLoc;
    }

    public boolean isCloserLocation(double loc, int minUptimePercent) {
        double nodeLoc = this.node.lm.getLocation();
        double nodeDist = Location.distance(nodeLoc, loc);
        double closest = this.closestPeerLocation(loc, nodeLoc, minUptimePercent);
        if (closest > 1.0) {
            return false;
        }
        double closestDist = Location.distance(closest, loc);
        return closestDist < nodeDist;
    }

    public PeerNode closerPeer(PeerNode pn, Set<PeerNode> routedTo, double loc, boolean ignoreSelf, boolean calculateMisrouting, int minVersion, List<Double> addUnpickedLocsTo, Key key) {
        return this.closerPeer(pn, routedTo, loc, ignoreSelf, calculateMisrouting, minVersion, addUnpickedLocsTo, 2.0, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerNode closerPeer(PeerNode pn, Set<PeerNode> routedTo, double target, boolean ignoreSelf, boolean calculateMisrouting, int minVersion, List<Double> addUnpickedLocsTo, double maxDistance, Key key) {
        PeerNode[] peers;
        PeerManager peerManager = this;
        synchronized (peerManager) {
            peers = this.connectedPeers;
        }
        if (!this.node.enablePerNodeFailureTables) {
            key = null;
        }
        if (logMINOR) {
            Logger.minor(this, "Choosing closest peer: connectedPeers=" + peers.length);
        }
        double maxDiff = Double.MAX_VALUE;
        if (!ignoreSelf) {
            maxDiff = Location.distance(this.node.lm.getLocation(), target);
        }
        PeerNode closest = null;
        double closestDistance = Double.MAX_VALUE;
        PeerNode closestBackedOff = null;
        double closestBackedOffDistance = Double.MAX_VALUE;
        PeerNode closestNotBackedOff = null;
        double closestNotBackedOffDistance = Double.MAX_VALUE;
        PeerNode leastRecentlyTimedOut = null;
        long timeLeastRecentlyTimedOut = Long.MAX_VALUE;
        PeerNode leastRecentlyTimedOutBackedOff = null;
        long timeLeastRecentlyTimedOutBackedOff = Long.MAX_VALUE;
        TimedOutNodesList entry = null;
        if (key != null) {
            entry = this.node.failureTable.getTimedOutNodesList(key);
        }
        long now = System.currentTimeMillis();
        int count = 0;
        double[] selectionRates = new double[peers.length];
        double totalSelectionRate = 0.0;
        for (int i = 0; i < peers.length; ++i) {
            selectionRates[i] = peers[i].selectionRate();
            totalSelectionRate += selectionRates[i];
        }
        boolean enableFOAFMitigationHack = peers.length >= 5 && totalSelectionRate > 0.0;
        for (int i = 0; i < peers.length; ++i) {
            Double d;
            boolean backedOff;
            double selectionRate;
            double selectionSamplesPercentage;
            PeerNode p = peers[i];
            if (routedTo.contains(p)) {
                if (!logMINOR) continue;
                Logger.minor(this, "Skipping (already routed to): " + p.getPeer());
                continue;
            }
            if (p == pn) {
                if (!logMINOR) continue;
                Logger.minor(this, "Skipping (req came from): " + p.getPeer());
                continue;
            }
            if (!p.isRoutable()) {
                if (!logMINOR) continue;
                Logger.minor(this, "Skipping (not connected): " + p.getPeer());
                continue;
            }
            if (key != null && p.isTurtling(key) && logMINOR) {
                Logger.minor(this, "Skipping (already turtling key): " + p.getPeer());
            }
            if (minVersion > 0 && Version.getArbitraryBuildNumber(p.getVersion(), -1) < minVersion) {
                if (!logMINOR) continue;
                Logger.minor(this, "Skipping old version: " + p.getPeer());
                continue;
            }
            if (enableFOAFMitigationHack && 30.0 < (selectionSamplesPercentage = (selectionRate = selectionRates[i]) / totalSelectionRate)) {
                if (!logMINOR) continue;
                Logger.minor(this, "Skipping over-selectionned peer(" + selectionSamplesPercentage + "%): " + p.getPeer());
                continue;
            }
            long timeout = -1L;
            if (entry != null) {
                timeout = entry.getTimeoutTime(p);
            }
            boolean timedOut = timeout > now;
            double loc = p.getLocation();
            double diff = Location.distance(loc, target);
            double[] peersLocation = p.getPeersLocation();
            if (peersLocation != null && this.node.shallWeRouteAccordingToOurPeersLocation()) {
                for (double l : peersLocation) {
                    double newDiff = Location.distance(l, target);
                    if (!(newDiff < diff)) continue;
                    loc = l;
                    diff = newDiff;
                }
                if (logMINOR) {
                    Logger.minor(this, "The peer " + p + " has published his peer's locations and the closest we have found to the target is " + diff + " away.");
                }
            }
            if (diff > maxDistance) continue;
            if (!ignoreSelf && diff > maxDiff) {
                if (!logMINOR) continue;
                Logger.minor(this, "Ignoring, further than self >maxDiff=" + maxDiff);
                continue;
            }
            ++count;
            if (logMINOR) {
                Logger.minor(this, "p.loc=" + loc + ", target=" + target + ", d=" + Location.distance(loc, target) + " usedD=" + diff + " timedOut=" + timedOut + " for " + p.getPeer());
            }
            boolean chosen = false;
            if (diff < closestDistance) {
                closestDistance = diff;
                closest = p;
                chosen = true;
                if (logMINOR) {
                    Logger.minor(this, "New best: " + diff + " (" + loc + " for " + p.getPeer());
                }
            }
            if ((backedOff = p.isRoutingBackedOff()) && diff < closestBackedOffDistance && !timedOut) {
                closestBackedOffDistance = diff;
                closestBackedOff = p;
                chosen = true;
                if (logMINOR) {
                    Logger.minor(this, "New best-backed-off: " + diff + " (" + loc + " for " + p.getPeer());
                }
            }
            if (!backedOff && diff < closestNotBackedOffDistance && !timedOut) {
                closestNotBackedOffDistance = diff;
                closestNotBackedOff = p;
                chosen = true;
                if (logMINOR) {
                    Logger.minor(this, "New best-not-backed-off: " + diff + " (" + loc + " for " + p.getPeer());
                }
            }
            if (timedOut) {
                if (!backedOff) {
                    if (timeout < timeLeastRecentlyTimedOut) {
                        timeLeastRecentlyTimedOut = timeout;
                        leastRecentlyTimedOut = p;
                    }
                } else if (timeout < timeLeastRecentlyTimedOutBackedOff) {
                    timeLeastRecentlyTimedOutBackedOff = timeout;
                    leastRecentlyTimedOutBackedOff = p;
                }
            }
            if (addUnpickedLocsTo == null || chosen || addUnpickedLocsTo.contains(d = new Double(loc))) continue;
            addUnpickedLocsTo.add(d);
        }
        PeerNode best = closestNotBackedOff;
        if (best == null) {
            if (leastRecentlyTimedOut != null) {
                best = leastRecentlyTimedOut;
                if (logMINOR) {
                    Logger.minor(this, "Using least recently failed in-timeout-period peer for key: " + best.shortToString() + " for " + key);
                }
            } else if (closestBackedOff != null) {
                best = closestBackedOff;
                if (logMINOR) {
                    Logger.minor(this, "Using best backed-off peer for key: " + best.shortToString());
                }
            } else if (leastRecentlyTimedOutBackedOff != null) {
                best = leastRecentlyTimedOutBackedOff;
                if (logMINOR) {
                    Logger.minor(this, "Using least recently failed in-timeout-period backed-off peer for key: " + best.shortToString() + " for " + key);
                }
            }
        }
        if (best != null) {
            if (calculateMisrouting) {
                this.node.nodeStats.routingMissDistance.report(Location.distance(best, closest.getLocation()));
                int numberOfConnected = this.getPeerNodeStatusSize(1, false);
                int numberOfRoutingBackedOff = this.getPeerNodeStatusSize(2, false);
                if (numberOfRoutingBackedOff + numberOfConnected > 0) {
                    this.node.nodeStats.backedOffPercent.report((double)numberOfRoutingBackedOff / (double)(numberOfRoutingBackedOff + numberOfConnected));
                }
            }
            if (addUnpickedLocsTo != null && closestNotBackedOff != null && closestBackedOff != null) {
                addUnpickedLocsTo.add(new Double(closestBackedOff.getLocation()));
            }
            this.incrementSelectionSamples(now, best);
        }
        return best;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStatus() {
        int i;
        PeerNode[] peers;
        StringBuilder sb = new StringBuilder();
        PeerManager peerManager = this;
        synchronized (peerManager) {
            peers = this.myPeers;
        }
        Object[] status = new String[peers.length];
        for (i = 0; i < peers.length; ++i) {
            PeerNode pn = peers[i];
            status[i] = pn.getStatus(true).toString();
        }
        Arrays.sort(status);
        for (i = 0; i < status.length; ++i) {
            sb.append((String)status[i]);
            sb.append('\n');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTMCIPeerList() {
        int i;
        PeerNode[] peers;
        StringBuilder sb = new StringBuilder();
        PeerManager peerManager = this;
        synchronized (peerManager) {
            peers = this.myPeers;
        }
        Object[] peerList = new String[peers.length];
        for (i = 0; i < peers.length; ++i) {
            PeerNode pn = peers[i];
            peerList[i] = pn.getTMCIPeerInfo();
        }
        Arrays.sort(peerList);
        for (i = 0; i < peerList.length; ++i) {
            sb.append((String)peerList[i]);
            sb.append('\n');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFreevizOutput() {
        int i;
        PeerNode[] peers;
        StringBuilder sb = new StringBuilder();
        PeerManager peerManager = this;
        synchronized (peerManager) {
            peers = this.myPeers;
        }
        Object[] identity = new String[peers.length];
        for (i = 0; i < peers.length; ++i) {
            PeerNode pn = peers[i];
            identity[i] = pn.getFreevizOutput();
        }
        Arrays.sort(identity);
        for (i = 0; i < identity.length; ++i) {
            sb.append((String)identity[i]);
            sb.append('\n');
        }
        return sb.toString();
    }

    void writePeers() {
        this.shouldWritePeers = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDarknetPeersString() {
        PeerNode[] peers;
        StringBuilder sb = new StringBuilder();
        PeerManager peerManager = this;
        synchronized (peerManager) {
            peers = this.myPeers;
        }
        for (PeerNode pn : peers) {
            if (!(pn instanceof DarknetPeerNode)) continue;
            sb.append(pn.exportDiskFieldSet());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getOpennetPeersString() {
        PeerNode[] peers;
        StringBuilder sb = new StringBuilder();
        PeerManager peerManager = this;
        synchronized (peerManager) {
            peers = this.myPeers;
        }
        for (PeerNode pn : peers) {
            if (!(pn instanceof OpennetPeerNode)) continue;
            sb.append(pn.exportDiskFieldSet());
        }
        return sb.toString();
    }

    protected String getOldOpennetPeersString(OpennetManager om) {
        StringBuilder sb = new StringBuilder();
        for (PeerNode pn : om.getOldPeers()) {
            if (!(pn instanceof OpennetPeerNode)) continue;
            sb.append(pn.exportDiskFieldSet());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePeersInner() {
        String darknet = null;
        String opennet = null;
        String oldOpennetPeers = null;
        String oldOpennetPeersFilename = null;
        Object object = this.writePeersSync;
        synchronized (object) {
            OpennetManager om;
            if (this.darkFilename != null) {
                darknet = this.getDarknetPeersString();
            }
            if ((om = this.node.getOpennet()) != null) {
                if (this.openFilename != null) {
                    opennet = this.getOpennetPeersString();
                }
                oldOpennetPeersFilename = om.getOldPeersFilename();
                oldOpennetPeers = this.getOldOpennetPeersString(om);
            }
        }
        object = this.writePeerFileSync;
        synchronized (object) {
            if (darknet != null) {
                this.writePeersInner(this.darkFilename, darknet);
            }
            if (oldOpennetPeers != null) {
                if (opennet != null) {
                    this.writePeersInner(this.openFilename, opennet);
                }
                this.writePeersInner(oldOpennetPeersFilename, oldOpennetPeers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePeersInner(String filename, String sb) {
        Object object = this.writePeerFileSync;
        synchronized (object) {
            FileOutputStream fos = null;
            String f = filename + ".bak";
            try {
                fos = new FileOutputStream(f);
            }
            catch (FileNotFoundException e2) {
                Logger.error(this, "Cannot write peers to disk: Cannot create " + f + " - " + e2, e2);
                Closer.close(fos);
                return;
            }
            OutputStreamWriter w = null;
            try {
                w = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            }
            catch (UnsupportedEncodingException e2) {
                Closer.close(w);
                throw new Error("Impossible: JVM doesn't support UTF-8: " + e2, e2);
            }
            try {
                try {
                    w.write(sb);
                    w.flush();
                    w.close();
                    w = null;
                    File fnam = new File(filename);
                    FileUtil.renameTo(new File(f), fnam);
                }
                catch (IOException e) {
                    try {
                        fos.close();
                    }
                    catch (IOException e1) {
                        Logger.error(this, "Cannot close peers file: " + e, e);
                    }
                    Logger.error(this, "Cannot write file: " + e, e);
                    Object var10_12 = null;
                    Closer.close(w);
                    Closer.close(fos);
                    return;
                }
                Object var10_11 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                Closer.close(w);
                Closer.close(fos);
                throw throwable;
            }
            Closer.close(w);
            Closer.close(fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePMUserAlert() {
        boolean opennetAssumeNAT;
        boolean opennetDefinitelyPortForwarded;
        boolean opennetEnabled;
        int peers;
        int darknetPeers;
        if (this.ua == null) {
            return;
        }
        PeerManager peerManager = this;
        synchronized (peerManager) {
            darknetPeers = this.getDarknetPeers().length;
            int opennetPeers = this.getOpennetPeers().length;
            peers = darknetPeers + opennetPeers;
        }
        OpennetManager om = this.node.getOpennet();
        if (om != null) {
            opennetEnabled = true;
            opennetDefinitelyPortForwarded = om.crypto.definitelyPortForwarded();
            opennetAssumeNAT = om.crypto.config.alwaysHandshakeAggressively();
        } else {
            opennetEnabled = false;
            opennetDefinitelyPortForwarded = false;
            opennetAssumeNAT = false;
        }
        boolean darknetDefinitelyPortForwarded = this.node.darknetDefinitelyPortForwarded();
        boolean darknetAssumeNAT = this.node.darknetCrypto.config.alwaysHandshakeAggressively();
        PeerManagerUserAlert peerManagerUserAlert = this.ua;
        synchronized (peerManagerUserAlert) {
            this.ua.opennetDefinitelyPortForwarded = opennetDefinitelyPortForwarded;
            this.ua.darknetDefinitelyPortForwarded = darknetDefinitelyPortForwarded;
            this.ua.opennetAssumeNAT = opennetAssumeNAT;
            this.ua.darknetAssumeNAT = darknetAssumeNAT;
            this.ua.darknetConns = this.getPeerNodeStatusSize(1, true) + this.getPeerNodeStatusSize(2, true);
            this.ua.conns = this.getPeerNodeStatusSize(1, false) + this.getPeerNodeStatusSize(2, false);
            this.ua.darknetPeers = darknetPeers;
            this.ua.disconnDarknetPeers = darknetPeers - this.ua.darknetConns;
            this.ua.peers = peers;
            this.ua.neverConn = this.getPeerNodeStatusSize(6, true);
            this.ua.clockProblem = this.getPeerNodeStatusSize(11, false);
            this.ua.connError = this.getPeerNodeStatusSize(12, true);
            this.ua.isOpennetEnabled = opennetEnabled;
        }
        if (this.anyConnectedPeers()) {
            this.node.onConnectedPeer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean anyConnectedPeers() {
        PeerNode[] conns;
        PeerManager peerManager = this;
        synchronized (peerManager) {
            conns = this.connectedPeers;
        }
        for (int i = 0; i < conns.length; ++i) {
            if (!conns[i].isRoutable()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean anyDarknetPeers() {
        PeerNode[] conns;
        PeerManager peerManager = this;
        synchronized (peerManager) {
            conns = this.connectedPeers;
        }
        for (PeerNode p : conns) {
            if (!p.isDarknet()) continue;
            return true;
        }
        return false;
    }

    public void readExtraPeerData() {
        DarknetPeerNode[] peers = this.getDarknetPeers();
        for (int i = 0; i < peers.length; ++i) {
            try {
                peers[i].readExtraPeerData();
                continue;
            }
            catch (Exception e) {
                Logger.error(this, "Got exception while reading extra peer data", e);
            }
        }
        String msg = "Extra peer data reading and processing completed";
        Logger.normal(this, msg);
        System.out.println(msg);
    }

    public void start() {
        this.ua = new PeerManagerUserAlert(this.node.nodeStats);
        this.updatePMUserAlert();
        this.node.clientCore.alerts.register(this.ua);
        this.node.ps.queueTimedJob(this.writePeersRunnable, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countNonBackedOffPeers() {
        PeerNode[] peers;
        PeerManager peerManager = this;
        synchronized (peerManager) {
            peers = this.connectedPeers;
        }
        int countNoBackoff = 0;
        for (int i = 0; i < peers.length; ++i) {
            if (!peers[i].isRoutable() || peers[i].isRoutingBackedOff()) continue;
            ++countNoBackoff;
        }
        return countNoBackoff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeUpdateOldestNeverConnectedPeerAge(long now) {
        PeerManager peerManager = this;
        synchronized (peerManager) {
            if (now <= this.nextOldestNeverConnectedPeerAgeUpdateTime) {
                return;
            }
            this.nextOldestNeverConnectedPeerAgeUpdateTime = now + 5000L;
        }
        this.oldestNeverConnectedPeerAge = 0L;
        PeerNode[] peerList = this.myPeers;
        for (int i = 0; i < peerList.length; ++i) {
            PeerNode pn = peerList[i];
            if (pn.getPeerNodeStatus() != 6 || now - pn.getPeerAddedTime() <= this.oldestNeverConnectedPeerAge) continue;
            this.oldestNeverConnectedPeerAge = now - pn.getPeerAddedTime();
        }
        if (this.oldestNeverConnectedPeerAge > 0L && logMINOR) {
            Logger.minor(this, "Oldest never connected peer is " + this.oldestNeverConnectedPeerAge + "ms old");
        }
        this.nextOldestNeverConnectedPeerAgeUpdateTime = now + 5000L;
    }

    public long getOldestNeverConnectedPeerAge() {
        return this.oldestNeverConnectedPeerAge;
    }

    public void maybeLogPeerNodeStatusSummary(long now) {
        if (now > this.nextPeerNodeStatusLogTime) {
            if (now - this.nextPeerNodeStatusLogTime > 10000L && this.nextPeerNodeStatusLogTime > 0L) {
                Logger.error(this, "maybeLogPeerNodeStatusSummary() not called for more than 10 seconds (" + (now - this.nextPeerNodeStatusLogTime) + ").  PacketSender getting bogged down or something?");
            }
            int numberOfConnected = 0;
            int numberOfRoutingBackedOff = 0;
            int numberOfTooNew = 0;
            int numberOfTooOld = 0;
            int numberOfDisconnected = 0;
            int numberOfNeverConnected = 0;
            int numberOfDisabled = 0;
            int numberOfListenOnly = 0;
            int numberOfListening = 0;
            int numberOfBursting = 0;
            int numberOfClockProblem = 0;
            int numberOfConnError = 0;
            int numberOfDisconnecting = 0;
            int numberOfRoutingDisabled = 0;
            PeerNodeStatus[] pns = this.getPeerNodeStatuses(true);
            block16: for (int i = 0; i < pns.length; ++i) {
                if (pns[i] == null) {
                    Logger.error(this, "getPeerNodeStatuses(true)[" + i + "] == null!");
                    continue;
                }
                switch (pns[i].getStatusValue()) {
                    case 1: {
                        ++numberOfConnected;
                        continue block16;
                    }
                    case 2: {
                        ++numberOfRoutingBackedOff;
                        continue block16;
                    }
                    case 3: {
                        ++numberOfTooNew;
                        continue block16;
                    }
                    case 4: {
                        ++numberOfTooOld;
                        continue block16;
                    }
                    case 5: {
                        ++numberOfDisconnected;
                        continue block16;
                    }
                    case 6: {
                        ++numberOfNeverConnected;
                        continue block16;
                    }
                    case 7: {
                        ++numberOfDisabled;
                        continue block16;
                    }
                    case 10: {
                        ++numberOfListenOnly;
                        continue block16;
                    }
                    case 9: {
                        ++numberOfListening;
                        continue block16;
                    }
                    case 8: {
                        ++numberOfBursting;
                        continue block16;
                    }
                    case 11: {
                        ++numberOfClockProblem;
                        continue block16;
                    }
                    case 12: {
                        ++numberOfConnError;
                        continue block16;
                    }
                    case 13: {
                        ++numberOfDisconnecting;
                        continue block16;
                    }
                    case 14: {
                        ++numberOfRoutingDisabled;
                        continue block16;
                    }
                    default: {
                        Logger.error(this, "Unknown peer status value : " + pns[i].getStatusValue());
                    }
                }
            }
            Logger.normal(this, "Connected: " + numberOfConnected + "  Routing Backed Off: " + numberOfRoutingBackedOff + "  Too New: " + numberOfTooNew + "  Too Old: " + numberOfTooOld + "  Disconnected: " + numberOfDisconnected + "  Never Connected: " + numberOfNeverConnected + "  Disabled: " + numberOfDisabled + "  Bursting: " + numberOfBursting + "  Listening: " + numberOfListening + "  Listen Only: " + numberOfListenOnly + "  Clock Problem: " + numberOfClockProblem + "  Connection Problem: " + numberOfConnError + "  Disconnecting: " + numberOfDisconnecting);
            this.nextPeerNodeStatusLogTime = now + 5000L;
            this.node.displayClockProblemUserAlert(numberOfClockProblem > 2);
        }
    }

    public void addPeerNodeStatus(int pnStatus, PeerNode peerNode, boolean noLog) {
        Integer peerNodeStatus = pnStatus;
        this.addPeerNodeStatuses(pnStatus, peerNode, peerNodeStatus, this.peerNodeStatuses, noLog);
        if (!peerNode.isOpennet()) {
            this.addPeerNodeStatuses(pnStatus, peerNode, peerNodeStatus, this.peerNodeStatusesDarknet, noLog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPeerNodeStatuses(int pnStatus, PeerNode peerNode, Integer peerNodeStatus, HashMap<Integer, HashSet<PeerNode>> statuses, boolean noLog) {
        HashSet<Object> statusSet = null;
        HashMap<Integer, HashSet<PeerNode>> hashMap = statuses;
        synchronized (hashMap) {
            if (statuses.containsKey(peerNodeStatus)) {
                statusSet = statuses.get(peerNodeStatus);
                if (statusSet.contains(peerNode)) {
                    if (!noLog) {
                        Logger.error(this, "addPeerNodeStatus(): node already in peerNodeStatuses: " + peerNode + " status " + PeerNode.getPeerNodeStatusString(peerNodeStatus), new Exception("debug"));
                    }
                    return;
                }
                statuses.remove(peerNodeStatus);
            } else {
                statusSet = new HashSet();
            }
            if (logMINOR) {
                Logger.minor(this, "addPeerNodeStatus(): adding PeerNode for '" + peerNode.getIdentityString() + "' with status '" + PeerNode.getPeerNodeStatusString(peerNodeStatus) + "'");
            }
            statusSet.add(peerNode);
            statuses.put(peerNodeStatus, statusSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPeerNodeStatusSize(int pnStatus, boolean darknet) {
        HashMap<Integer, HashSet<PeerNode>> statuses;
        Integer peerNodeStatus = pnStatus;
        HashSet<Object> statusSet = null;
        HashMap<Integer, HashSet<PeerNode>> hashMap = statuses = darknet ? this.peerNodeStatusesDarknet : this.peerNodeStatuses;
        synchronized (hashMap) {
            statusSet = statuses.containsKey(peerNodeStatus) ? statuses.get(peerNodeStatus) : new HashSet();
            return statusSet.size();
        }
    }

    public void removePeerNodeStatus(int pnStatus, PeerNode peerNode, boolean noLog) {
        Integer peerNodeStatus = pnStatus;
        this.removePeerNodeStatus(pnStatus, peerNodeStatus, peerNode, this.peerNodeStatuses, noLog);
        if (!peerNode.isOpennet()) {
            this.removePeerNodeStatus(pnStatus, peerNodeStatus, peerNode, this.peerNodeStatusesDarknet, noLog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePeerNodeStatus(int pnStatus, Integer peerNodeStatus, PeerNode peerNode, HashMap<Integer, HashSet<PeerNode>> statuses, boolean noLog) {
        HashSet<Object> statusSet = null;
        HashMap<Integer, HashSet<PeerNode>> hashMap = statuses;
        synchronized (hashMap) {
            if (statuses.containsKey(peerNodeStatus)) {
                statusSet = statuses.get(peerNodeStatus);
                if (!statusSet.contains(peerNode)) {
                    if (!noLog) {
                        Logger.error(this, "removePeerNodeStatus(): identity '" + peerNode.getIdentityString() + " for " + peerNode.shortToString() + "' not in peerNodeStatuses with status '" + PeerNode.getPeerNodeStatusString(peerNodeStatus) + "'", new Exception("debug"));
                    }
                    return;
                }
                if (statuses.isEmpty()) {
                    statuses.remove(peerNodeStatus);
                }
            } else {
                statusSet = new HashSet();
            }
            if (logMINOR) {
                Logger.minor(this, "removePeerNodeStatus(): removing PeerNode for '" + peerNode.getIdentityString() + "' with status '" + PeerNode.getPeerNodeStatusString(peerNodeStatus) + "'");
            }
            if (statusSet.contains(peerNode)) {
                statusSet.remove(peerNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPeerNodeRoutingBackoffReason(String peerNodeRoutingBackoffReason, PeerNode peerNode) {
        HashMap<String, HashSet<PeerNode>> hashMap = this.peerNodeRoutingBackoffReasons;
        synchronized (hashMap) {
            HashSet<Object> reasonSet = null;
            if (this.peerNodeRoutingBackoffReasons.containsKey(peerNodeRoutingBackoffReason)) {
                reasonSet = this.peerNodeRoutingBackoffReasons.get(peerNodeRoutingBackoffReason);
                if (reasonSet.contains(peerNode)) {
                    Logger.error(this, "addPeerNodeRoutingBackoffReason(): identity '" + peerNode.getIdentityString() + "' already in peerNodeRoutingBackoffReasons as " + peerNode.getPeer() + " with status code " + peerNodeRoutingBackoffReason);
                    return;
                }
                this.peerNodeRoutingBackoffReasons.remove(peerNodeRoutingBackoffReason);
            } else {
                reasonSet = new HashSet();
            }
            if (logMINOR) {
                Logger.minor(this, "addPeerNodeRoutingBackoffReason(): adding PeerNode for '" + peerNode.getIdentityString() + "' with status code " + peerNodeRoutingBackoffReason);
            }
            reasonSet.add(peerNode);
            this.peerNodeRoutingBackoffReasons.put(peerNodeRoutingBackoffReason, reasonSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPeerNodeRoutingBackoffReasons() {
        Object[] reasonStrings;
        HashMap<String, HashSet<PeerNode>> hashMap = this.peerNodeRoutingBackoffReasons;
        synchronized (hashMap) {
            reasonStrings = this.peerNodeRoutingBackoffReasons.keySet().toArray(new String[this.peerNodeRoutingBackoffReasons.size()]);
        }
        Arrays.sort(reasonStrings);
        return reasonStrings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPeerNodeRoutingBackoffReasonSize(String peerNodeRoutingBackoffReason) {
        HashSet<PeerNode> reasonSet = null;
        HashMap<String, HashSet<PeerNode>> hashMap = this.peerNodeRoutingBackoffReasons;
        synchronized (hashMap) {
            if (this.peerNodeRoutingBackoffReasons.containsKey(peerNodeRoutingBackoffReason)) {
                reasonSet = this.peerNodeRoutingBackoffReasons.get(peerNodeRoutingBackoffReason);
                return reasonSet.size();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePeerNodeRoutingBackoffReason(String peerNodeRoutingBackoffReason, PeerNode peerNode) {
        HashSet<Object> reasonSet = null;
        HashMap<String, HashSet<PeerNode>> hashMap = this.peerNodeRoutingBackoffReasons;
        synchronized (hashMap) {
            if (this.peerNodeRoutingBackoffReasons.containsKey(peerNodeRoutingBackoffReason)) {
                reasonSet = this.peerNodeRoutingBackoffReasons.get(peerNodeRoutingBackoffReason);
                if (!reasonSet.contains(peerNode)) {
                    Logger.error(this, "removePeerNodeRoutingBackoffReason(): identity '" + peerNode.getIdentityString() + "' not in peerNodeRoutingBackoffReasons with status code " + peerNodeRoutingBackoffReason, new Exception("debug"));
                    return;
                }
                this.peerNodeRoutingBackoffReasons.remove(peerNodeRoutingBackoffReason);
            } else {
                reasonSet = new HashSet();
            }
            if (logMINOR) {
                Logger.minor(this, "removePeerNodeRoutingBackoffReason(): removing PeerNode for '" + peerNode.getIdentityString() + "' with status code " + peerNodeRoutingBackoffReason);
            }
            if (reasonSet.contains(peerNode)) {
                reasonSet.remove(peerNode);
            }
            if (reasonSet.size() > 0) {
                this.peerNodeRoutingBackoffReasons.put(peerNodeRoutingBackoffReason, reasonSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerNodeStatus[] getPeerNodeStatuses(boolean noHeavy) {
        PeerNode[] peers;
        PeerManager peerManager = this;
        synchronized (peerManager) {
            peers = this.myPeers;
        }
        PeerNodeStatus[] _peerNodeStatuses = new PeerNodeStatus[peers.length];
        int peerCount = peers.length;
        for (int peerIndex = 0; peerIndex < peerCount; ++peerIndex) {
            _peerNodeStatuses[peerIndex] = peers[peerIndex].getStatus(noHeavy);
        }
        return _peerNodeStatuses;
    }

    public DarknetPeerNodeStatus[] getDarknetPeerNodeStatuses(boolean noHeavy) {
        DarknetPeerNode[] peers = this.getDarknetPeers();
        DarknetPeerNodeStatus[] _peerNodeStatuses = new DarknetPeerNodeStatus[peers.length];
        int peerCount = peers.length;
        for (int peerIndex = 0; peerIndex < peerCount; ++peerIndex) {
            _peerNodeStatuses[peerIndex] = (DarknetPeerNodeStatus)peers[peerIndex].getStatus(noHeavy);
        }
        return _peerNodeStatuses;
    }

    public OpennetPeerNodeStatus[] getOpennetPeerNodeStatuses(boolean noHeavy) {
        OpennetPeerNode[] peers = this.getOpennetPeers();
        OpennetPeerNodeStatus[] _peerNodeStatuses = new OpennetPeerNodeStatus[peers.length];
        int peerCount = peers.length;
        for (int peerIndex = 0; peerIndex < peerCount; ++peerIndex) {
            _peerNodeStatuses[peerIndex] = (OpennetPeerNodeStatus)peers[peerIndex].getStatus(noHeavy);
        }
        return _peerNodeStatuses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeUpdatePeerNodeRoutableConnectionStats(long now) {
        PeerManager peerManager = this;
        synchronized (peerManager) {
            if (now <= this.nextRoutableConnectionStatsUpdateTime) {
                return;
            }
            this.nextRoutableConnectionStatsUpdateTime = now + 7000L;
        }
        if (-1L != this.nextRoutableConnectionStatsUpdateTime) {
            PeerNode[] peerList = this.myPeers;
            for (int i = 0; i < peerList.length; ++i) {
                PeerNode pn = peerList[i];
                pn.checkRoutableConnectionStatus();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DarknetPeerNode[] getDarknetPeers() {
        PeerNode[] peers;
        PeerManager peerManager = this;
        synchronized (peerManager) {
            peers = this.myPeers;
        }
        Vector<PeerNode> v = new Vector<PeerNode>(this.myPeers.length);
        for (int i = 0; i < peers.length; ++i) {
            if (!(peers[i] instanceof DarknetPeerNode)) continue;
            v.add(peers[i]);
        }
        return v.toArray(new DarknetPeerNode[v.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<SeedServerPeerNode> getConnectedSeedServerPeersVector(HashSet<ByteArrayWrapper> exclude) {
        PeerNode[] peers;
        PeerManager peerManager = this;
        synchronized (peerManager) {
            peers = this.myPeers;
        }
        Vector<SeedServerPeerNode> v = new Vector<SeedServerPeerNode>(this.myPeers.length);
        for (PeerNode p : peers) {
            if (!(p instanceof SeedServerPeerNode)) continue;
            SeedServerPeerNode sspn = (SeedServerPeerNode)p;
            if (exclude != null && exclude.contains(new ByteArrayWrapper(sspn.getIdentity()))) {
                if (!logMINOR) continue;
                Logger.minor(this, "Not including in getConnectedSeedServerPeersVector() as in exclude set: " + sspn.userToString());
                continue;
            }
            if (!sspn.isConnected()) {
                if (!logMINOR) continue;
                Logger.minor(this, "Not including in getConnectedSeedServerPeersVector() as disconnected: " + sspn.userToString());
                continue;
            }
            v.add(sspn);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SeedServerPeerNode> getSeedServerPeersVector() {
        PeerNode[] peers;
        PeerManager peerManager = this;
        synchronized (peerManager) {
            peers = this.myPeers;
        }
        ArrayList<SeedServerPeerNode> v = new ArrayList<SeedServerPeerNode>(this.myPeers.length);
        for (PeerNode peer : peers) {
            if (!(peer instanceof SeedServerPeerNode)) continue;
            v.add((SeedServerPeerNode)peer);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpennetPeerNode[] getOpennetPeers() {
        PeerNode[] peers;
        PeerManager peerManager = this;
        synchronized (peerManager) {
            peers = this.myPeers;
        }
        Vector<PeerNode> v = new Vector<PeerNode>(this.myPeers.length);
        for (int i = 0; i < peers.length; ++i) {
            if (!(peers[i] instanceof OpennetPeerNode)) continue;
            v.add(peers[i]);
        }
        return v.toArray(new OpennetPeerNode[v.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean anyConnectedPeerHasAddress(FreenetInetAddress addr, PeerNode pn) {
        PeerNode[] peers;
        PeerManager peerManager = this;
        synchronized (peerManager) {
            peers = this.myPeers;
        }
        for (int i = 0; i < peers.length; ++i) {
            if (peers[i] == pn || !peers[i].isConnected() || !peers[i].isRealConnection() || !peers[i].getPeer().getFreenetAddress().equals(addr)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOpennetPeers() {
        PeerManager peerManager = this;
        synchronized (peerManager) {
            ArrayList<PeerNode> keep = new ArrayList<PeerNode>();
            ArrayList<PeerNode> conn = new ArrayList<PeerNode>();
            for (PeerNode pn : this.myPeers) {
                if (pn instanceof OpennetPeerNode) continue;
                keep.add(pn);
                if (!pn.isConnected()) continue;
                conn.add(pn);
            }
            this.myPeers = keep.toArray(new PeerNode[keep.size()]);
            this.connectedPeers = keep.toArray(new PeerNode[conn.size()]);
        }
        this.updatePMUserAlert();
    }

    public PeerNode containsPeer(PeerNode pn) {
        PeerNode[] peers = pn.isOpennet() ? (PeerNode[])this.getOpennetPeers() : (PeerNode[])this.getDarknetPeers();
        for (int i = 0; i < peers.length; ++i) {
            if (!Arrays.equals(pn.getIdentity(), peers[i].getIdentity())) continue;
            return peers[i];
        }
        return null;
    }

    public int quickCountConnectedPeers() {
        PeerNode[] conns = this.connectedPeers;
        if (conns == null) {
            return 0;
        }
        return this.connectedPeers.length;
    }

    public int countConnectedDarknetPeers() {
        int count = 0;
        PeerNode[] peers = this.myPeers;
        for (int i = 0; i < peers.length; ++i) {
            if (peers[i] == null || !(peers[i] instanceof DarknetPeerNode) || peers[i].isOpennet() || !peers[i].isRoutable()) continue;
            ++count;
        }
        if (logMINOR) {
            Logger.minor(this, "countConnectedDarknetPeers() returning " + count);
        }
        return count;
    }

    public int countConnectedPeers() {
        int count = 0;
        PeerNode[] peers = this.myPeers;
        for (int i = 0; i < peers.length; ++i) {
            if (peers[i] == null || !peers[i].isRoutable()) continue;
            ++count;
        }
        return count;
    }

    public int countAlmostConnectedDarknetPeers() {
        int count = 0;
        PeerNode[] peers = this.myPeers;
        for (int i = 0; i < peers.length; ++i) {
            if (peers[i] == null || !(peers[i] instanceof DarknetPeerNode) || peers[i].isOpennet() || !peers[i].isConnected()) continue;
            ++count;
        }
        return count;
    }

    public int countCompatibleDarknetPeers() {
        int count = 0;
        PeerNode[] peers = this.myPeers;
        for (int i = 0; i < peers.length; ++i) {
            if (peers[i] == null || !(peers[i] instanceof DarknetPeerNode) || peers[i].isOpennet() || !peers[i].isConnected() || !peers[i].isRoutingCompatible()) continue;
            ++count;
        }
        return count;
    }

    public int countConnectedOpennetPeers() {
        int count = 0;
        PeerNode[] peers = this.connectedPeers;
        for (int i = 0; i < peers.length; ++i) {
            if (peers[i] == null || !(peers[i] instanceof OpennetPeerNode) || !peers[i].isRoutable()) continue;
            ++count;
        }
        return count;
    }

    public int countValidPeers() {
        PeerNode[] peers = this.myPeers;
        int count = 0;
        for (int i = 0; i < peers.length; ++i) {
            if (!peers[i].isRealConnection() || peers[i].isDisabled()) continue;
            ++count;
        }
        return count;
    }

    public int countSeednodes() {
        int count = 0;
        for (PeerNode peer : this.myPeers) {
            if (!(peer instanceof SeedServerPeerNode) && !(peer instanceof SeedClientPeerNode)) continue;
            ++count;
        }
        return count;
    }

    public int countBackedOffPeers() {
        PeerNode[] peers = this.myPeers;
        int count = 0;
        for (int i = 0; i < peers.length; ++i) {
            if (!peers[i].isRealConnection() || peers[i].isDisabled() || !peers[i].isRoutingBackedOff()) continue;
            ++count;
        }
        return count;
    }

    public PeerNode getByIdentity(byte[] identity) {
        PeerNode[] peers = this.myPeers;
        for (int i = 0; i < peers.length; ++i) {
            if (!Arrays.equals(peers[i].getIdentity(), identity)) continue;
            return peers[i];
        }
        return null;
    }

    private void incrementSelectionSamples(long now, PeerNode pn) {
        pn.incrementNumberOfSelections(now);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LocationUIDPair
    implements Comparable<LocationUIDPair> {
        double location;
        long uid;

        LocationUIDPair(PeerNode pn) {
            this.location = pn.getLocation();
            this.uid = pn.swapIdentifier;
        }

        @Override
        public int compareTo(LocationUIDPair p) {
            if (p.location > this.location) {
                return 1;
            }
            if (p.location < this.location) {
                return -1;
            }
            return 0;
        }
    }
}

