/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.AsyncMessageCallback;
import freenet.io.comm.NotConnectedException;
import freenet.io.xfer.PacketThrottle;
import freenet.node.BlockedTooLongException;
import freenet.node.KeyChangedException;
import freenet.node.MessageItem;
import freenet.node.PeerNode;
import freenet.node.ResendPacketItem;
import freenet.node.SessionKey;
import freenet.node.StillNotAckedException;
import freenet.support.DoublyLinkedList;
import freenet.support.IndexableUpdatableSortedLinkedListItem;
import freenet.support.LimitedRangeIntByteArrayMap;
import freenet.support.LimitedRangeIntByteArrayMapElement;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.ReceivedPacketNumbers;
import freenet.support.TimeUtil;
import freenet.support.UpdatableSortedLinkedListKilledException;
import freenet.support.UpdatableSortedLinkedListWithForeignIndex;
import freenet.support.WouldBlockException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PacketTracker {
    private static volatile boolean logMINOR;
    public final PeerNode pn;
    private volatile boolean isDeprecated;
    private final LimitedRangeIntByteArrayMap sentPacketsContents;
    private final List<QueuedAck> ackQueue;
    private final List<QueuedForgotten> forgottenQueue;
    private int highestSeenIncomingSerialNumber;
    private final UpdatableSortedLinkedListWithForeignIndex<QueuedResendRequest> resendRequestQueue;
    private final UpdatableSortedLinkedListWithForeignIndex<QueuedAckRequest> ackRequestQueue;
    private final HashSet<Integer> packetsToResend;
    private final ReceivedPacketNumbers packetNumbersReceived;
    private int nextPacketNumber;
    final long createdTime;
    private long timeLastDecodedPacket;
    final long trackerID;
    private long timeWouldBlock = -1L;
    static final long MAX_WOULD_BLOCK_DELTA = 600000L;

    PacketTracker(PeerNode pn) {
        this(pn, pn.node.random.nextLong() & Long.MAX_VALUE);
    }

    PacketTracker(PeerNode pn, long tid) {
        this.trackerID = tid;
        this.pn = pn;
        this.ackQueue = new LinkedList<QueuedAck>();
        this.forgottenQueue = new LinkedList<QueuedForgotten>();
        this.highestSeenIncomingSerialNumber = -1;
        this.sentPacketsContents = new LimitedRangeIntByteArrayMap(128);
        this.resendRequestQueue = new UpdatableSortedLinkedListWithForeignIndex();
        this.ackRequestQueue = new UpdatableSortedLinkedListWithForeignIndex();
        this.packetsToResend = new HashSet();
        this.packetNumbersReceived = new ReceivedPacketNumbers(512);
        this.isDeprecated = false;
        this.nextPacketNumber = pn.node.random.nextInt(100000);
        this.createdTime = System.currentTimeMillis();
    }

    public void deprecated() {
        if (logMINOR) {
            Logger.minor(this, "Deprecated: " + this);
        }
        this.isDeprecated = true;
        this.sentPacketsContents.interrupt();
    }

    public int highestReceivedIncomingSeqNumber() {
        return this.highestSeenIncomingSerialNumber;
    }

    public boolean alreadyReceived(int seqNumber) {
        return this.packetNumbersReceived.contains(seqNumber);
    }

    public String toString() {
        return super.toString() + " for " + this.pn.shortToString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueAck(int seqNumber) {
        if (logMINOR) {
            Logger.minor(this, "Queueing ack for " + seqNumber);
        }
        QueuedAck qa = new QueuedAck(seqNumber);
        List<QueuedAck> list = this.ackQueue;
        synchronized (list) {
            this.ackQueue.add(qa);
        }
    }

    public void queueForgotten(int seqNumber) {
        this.queueForgotten(seqNumber, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueForgotten(int seqNumber, boolean log) {
        if (log && (!this.isDeprecated || logMINOR)) {
            String msg = "Queueing forgotten for " + seqNumber + " for " + this;
            if (!this.isDeprecated) {
                Logger.error(this, msg);
            } else {
                Logger.minor(this, msg);
            }
        }
        QueuedForgotten qf = new QueuedForgotten(seqNumber);
        List<QueuedForgotten> list = this.forgottenQueue;
        synchronized (list) {
            this.forgottenQueue.add(qf);
        }
    }

    public synchronized void receivedPacket(int seqNumber) {
        this.timeLastDecodedPacket = System.currentTimeMillis();
        if (logMINOR) {
            Logger.minor(this, "Received packet " + seqNumber + " from " + this.pn.shortToString());
        }
        if (seqNumber == -1) {
            return;
        }
        this.receivedPacketNumber(seqNumber);
        this.queueAck(seqNumber);
    }

    public long twoRTTs() {
        return (long)Math.min(Math.max(250.0, this.pn.averagePingTime() * 2.0), 2500.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receivedPacketNumber(int seqNumber) {
        if (logMINOR) {
            Logger.minor(this, "Handling received packet number " + seqNumber);
        }
        this.queueResendRequests(seqNumber);
        this.packetNumbersReceived.got(seqNumber);
        try {
            this.removeResendRequest(seqNumber);
        }
        catch (UpdatableSortedLinkedListKilledException updatableSortedLinkedListKilledException) {
            // empty catch block
        }
        PacketTracker packetTracker = this;
        synchronized (packetTracker) {
            this.highestSeenIncomingSerialNumber = Math.max(this.highestSeenIncomingSerialNumber, seqNumber);
        }
        if (logMINOR) {
            Logger.minor(this, "Handled received packet number " + seqNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeResendRequest(int seqNumber) throws UpdatableSortedLinkedListKilledException {
        UpdatableSortedLinkedListWithForeignIndex<QueuedResendRequest> updatableSortedLinkedListWithForeignIndex = this.resendRequestQueue;
        synchronized (updatableSortedLinkedListWithForeignIndex) {
            this.resendRequestQueue.removeByKey(seqNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueResendRequests(int seqNumber) {
        int max;
        PacketTracker packetTracker = this;
        synchronized (packetTracker) {
            max = this.packetNumbersReceived.highest();
        }
        if (seqNumber > max) {
            try {
                if (max != -1 && seqNumber - max > 1) {
                    if (logMINOR) {
                        Logger.minor(this, "Queueing resends from " + max + " to " + seqNumber);
                    }
                    for (int i = max + 1; i < seqNumber; ++i) {
                        this.queueResendRequest(i);
                    }
                }
            }
            catch (UpdatableSortedLinkedListKilledException updatableSortedLinkedListKilledException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueResendRequest(int packetNumber) throws UpdatableSortedLinkedListKilledException {
        UpdatableSortedLinkedListWithForeignIndex<QueuedResendRequest> updatableSortedLinkedListWithForeignIndex = this.resendRequestQueue;
        synchronized (updatableSortedLinkedListWithForeignIndex) {
            if (this.queuedResendRequest(packetNumber)) {
                if (logMINOR) {
                    Logger.minor(this, "Not queueing resend request for " + packetNumber + " - already queued");
                }
                return;
            }
            if (logMINOR) {
                Logger.minor(this, "Queueing resend request for " + packetNumber);
            }
            QueuedResendRequest qrr = new QueuedResendRequest(packetNumber);
            this.resendRequestQueue.add(qrr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueAckRequest(int packetNumber) throws UpdatableSortedLinkedListKilledException {
        UpdatableSortedLinkedListWithForeignIndex<QueuedAckRequest> updatableSortedLinkedListWithForeignIndex = this.ackRequestQueue;
        synchronized (updatableSortedLinkedListWithForeignIndex) {
            if (this.queuedAckRequest(packetNumber)) {
                if (logMINOR) {
                    Logger.minor(this, "Not queueing ack request for " + packetNumber + " - already queued");
                }
                return;
            }
            if (logMINOR) {
                Logger.minor(this, "Queueing ack request for " + packetNumber + " on " + this);
            }
            QueuedAckRequest qrr = new QueuedAckRequest(packetNumber);
            this.ackRequestQueue.add(qrr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean queuedAckRequest(int packetNumber) {
        UpdatableSortedLinkedListWithForeignIndex<QueuedAckRequest> updatableSortedLinkedListWithForeignIndex = this.ackRequestQueue;
        synchronized (updatableSortedLinkedListWithForeignIndex) {
            return this.ackRequestQueue.containsKey(packetNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean queuedResendRequest(int packetNumber) {
        UpdatableSortedLinkedListWithForeignIndex<QueuedResendRequest> updatableSortedLinkedListWithForeignIndex = this.resendRequestQueue;
        synchronized (updatableSortedLinkedListWithForeignIndex) {
            return this.resendRequestQueue.containsKey(packetNumber);
        }
    }

    public synchronized void acknowledgedPackets(int[] seqNos) {
        AsyncMessageCallback[][] callbacks = new AsyncMessageCallback[seqNos.length][];
        for (int i = 0; i < seqNos.length; ++i) {
            int realSeqNo = seqNos[i];
            if (logMINOR) {
                Logger.minor(this, "Acknowledged packet: " + realSeqNo);
            }
            try {
                this.removeAckRequest(realSeqNo);
            }
            catch (UpdatableSortedLinkedListKilledException e) {
                // empty catch block
            }
            if (logMINOR) {
                Logger.minor(this, "Removed ack request");
            }
            callbacks[i] = this.sentPacketsContents.getCallbacks(realSeqNo);
            byte[] buf = this.sentPacketsContents.get(realSeqNo);
            long timeAdded = this.sentPacketsContents.getTime(realSeqNo);
            if (!this.sentPacketsContents.remove(realSeqNo) || buf.length <= 1024) continue;
            PacketThrottle throttle = this.pn.getThrottle();
            throttle.notifyOfPacketAcknowledged();
            throttle.setRoundTripTime(System.currentTimeMillis() - timeAdded);
        }
        int cbCount = 0;
        for (int i = 0; i < callbacks.length; ++i) {
            AsyncMessageCallback[] cbs = callbacks[i];
            if (cbs == null) continue;
            for (int j = 0; j < cbs.length; ++j) {
                cbs[j].acknowledged();
                ++cbCount;
            }
        }
        if (cbCount > 0 && logMINOR) {
            Logger.minor(this, "Executed " + cbCount + " callbacks");
        }
        try {
            this.wouldBlock(true);
        }
        catch (BlockedTooLongException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgedPacket(int realSeqNo) {
        if (logMINOR) {
            Logger.minor(this, "Acknowledged packet: " + realSeqNo);
        }
        try {
            PacketTracker packetTracker = this;
            synchronized (packetTracker) {
                this.removeAckRequest(realSeqNo);
            }
        }
        catch (UpdatableSortedLinkedListKilledException e) {
            // empty catch block
        }
        if (logMINOR) {
            Logger.minor(this, "Removed ack request");
        }
        AsyncMessageCallback[] callbacks = this.sentPacketsContents.getCallbacks(realSeqNo);
        byte[] buf = this.sentPacketsContents.get(realSeqNo);
        long timeAdded = this.sentPacketsContents.getTime(realSeqNo);
        if (this.sentPacketsContents.remove(realSeqNo) && buf.length > 1024) {
            PacketThrottle throttle = this.pn.getThrottle();
            throttle.notifyOfPacketAcknowledged();
            throttle.setRoundTripTime(System.currentTimeMillis() - timeAdded);
        }
        try {
            this.wouldBlock(true);
        }
        catch (BlockedTooLongException e) {
            // empty catch block
        }
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                callbacks[i].acknowledged();
            }
            if (logMINOR) {
                Logger.minor(this, "Executed " + callbacks.length + " callbacks");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAckRequest(int seqNo) throws UpdatableSortedLinkedListKilledException {
        QueuedAckRequest qr = null;
        UpdatableSortedLinkedListWithForeignIndex<QueuedAckRequest> updatableSortedLinkedListWithForeignIndex = this.ackRequestQueue;
        synchronized (updatableSortedLinkedListWithForeignIndex) {
            qr = this.ackRequestQueue.removeByKey(seqNo);
        }
        if (qr != null) {
            qr.onAcked();
        } else {
            Logger.normal(this, "Removing ack request twice? Null on " + seqNo + " from " + this.pn.getPeer() + " (" + TimeUtil.formatTime((int)this.pn.averagePingTime(), 2, true) + " ping avg)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resendPacket(int seqNumber) {
        byte[] resendData = this.sentPacketsContents.get(seqNumber);
        if (resendData != null) {
            if (resendData.length > 1024) {
                this.pn.getThrottle().notifyOfPacketLost();
            }
            HashSet<Integer> hashSet = this.packetsToResend;
            synchronized (hashSet) {
                this.packetsToResend.add(seqNumber);
            }
            this.pn.node.ps.wakeUp();
        } else {
            PacketTracker packetTracker = this;
            synchronized (packetTracker) {
                if (this.nextPacketNumber <= seqNumber) {
                    Logger.error(this, "Asking me to resend packet " + seqNumber + " which I haven't sent yet (next=" + this.nextPacketNumber + ") on " + this);
                    return;
                }
                Logger.error(this, "Asking me to resend packet " + seqNumber + " which has already been acked or we skipped the packet number (next=" + this.nextPacketNumber + ") on " + this + " - will tell other side we have forgotten it");
            }
            this.queueForgotten(seqNumber);
        }
    }

    public synchronized void receivedAckRequest(int packetNumber) {
        if (!this.queuedAck(packetNumber)) {
            if (this.packetNumbersReceived.contains(packetNumber)) {
                this.queueAck(packetNumber);
            } else {
                try {
                    this.queueResendRequest(packetNumber);
                }
                catch (UpdatableSortedLinkedListKilledException updatableSortedLinkedListKilledException) {
                    // empty catch block
                }
                this.highestSeenIncomingSerialNumber = Math.max(this.highestSeenIncomingSerialNumber, packetNumber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean queuedAck(int packetNumber) {
        List<QueuedAck> list = this.ackQueue;
        synchronized (list) {
            for (QueuedAck qa : this.ackQueue) {
                if (qa.packetNumber != packetNumber) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destForgotPacket(int seqNumber) {
        if (this.isDeprecated) {
            Logger.normal(this, "Destination forgot packet: " + seqNumber);
        } else {
            Logger.error(this, "Destination forgot packet: " + seqNumber);
        }
        PacketTracker packetTracker = this;
        synchronized (packetTracker) {
            try {
                this.removeResendRequest(seqNumber);
            }
            catch (UpdatableSortedLinkedListKilledException updatableSortedLinkedListKilledException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wouldBlock(boolean wakeTicker) throws BlockedTooLongException {
        long now = System.currentTimeMillis();
        PacketTracker packetTracker = this;
        synchronized (packetTracker) {
            long delta;
            if (this.sentPacketsContents.wouldBlock(this.nextPacketNumber)) {
                if (this.timeWouldBlock == -1L) {
                    this.timeWouldBlock = now;
                } else {
                    long delta2 = now - this.timeWouldBlock;
                    if (delta2 > 600000L) {
                        Logger.error(this, "Not been able to allocate a packet to tracker " + this + " for " + TimeUtil.formatTime(delta2, 3, true));
                        throw new BlockedTooLongException(this, delta2);
                    }
                }
                return true;
            }
            if (this.timeWouldBlock != -1L) {
                delta = now - this.timeWouldBlock;
                this.timeWouldBlock = -1L;
                if (delta <= 100L) {
                    return false;
                }
            } else {
                return false;
            }
            Logger.error(this, "Waking PacketSender: have been blocking for packet ack for " + TimeUtil.formatTime(delta, 3, true));
        }
        this.pn.node.ps.wakeUp();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int allocateOutgoingPacketNumberNeverBlock() throws KeyChangedException, NotConnectedException, WouldBlockException {
        if (!this.pn.isConnected()) {
            throw new NotConnectedException();
        }
        PacketTracker packetTracker = this;
        synchronized (packetTracker) {
            int packetNumber = this.nextPacketNumber;
            if (this.isDeprecated) {
                throw new KeyChangedException();
            }
            this.sentPacketsContents.lockNeverBlock(packetNumber);
            this.timeWouldBlock = -1L;
            this.nextPacketNumber = packetNumber + 1;
            if (logMINOR) {
                Logger.minor(this, "Allocated " + packetNumber + " in allocateOutgoingPacketNumberNeverBlock for " + this);
            }
            return packetNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] grabForgotten() {
        int[] acks;
        if (logMINOR) {
            Logger.minor(this, "Grabbing forgotten packet numbers");
        }
        List<QueuedForgotten> list = this.forgottenQueue;
        synchronized (list) {
            int length = this.forgottenQueue.size();
            acks = new int[length];
            int i = 0;
            Iterator<QueuedForgotten> it = this.forgottenQueue.iterator();
            while (it.hasNext()) {
                QueuedForgotten ack = it.next();
                acks[i++] = ack.packetNumber;
                if (logMINOR) {
                    Logger.minor(this, "Grabbing ack " + ack.packetNumber + " from " + this);
                }
                it.remove();
            }
        }
        return acks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requeueForgot(int[] forgotPackets, int start, int length) {
        List<QueuedForgotten> list = this.forgottenQueue;
        synchronized (list) {
            for (int i = start; i < start + length; ++i) {
                this.queueForgotten(i, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] grabAcks() {
        int[] acks;
        if (logMINOR) {
            Logger.minor(this, "Grabbing acks");
        }
        List<QueuedAck> list = this.ackQueue;
        synchronized (list) {
            int length = this.ackQueue.size();
            acks = new int[length];
            int i = 0;
            for (QueuedAck ack : this.ackQueue) {
                acks[i++] = ack.packetNumber;
                if (!logMINOR) continue;
                Logger.minor(this, "Grabbing ack " + ack.packetNumber + " from " + this);
            }
            this.ackQueue.clear();
        }
        return acks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] grabResendRequests() throws NotConnectedException {
        int realLength;
        int[] packetNumbers;
        long now = System.currentTimeMillis();
        try {
            UpdatableSortedLinkedListWithForeignIndex<QueuedResendRequest> updatableSortedLinkedListWithForeignIndex = this.resendRequestQueue;
            synchronized (updatableSortedLinkedListWithForeignIndex) {
                QueuedResendRequest[] items = this.resendRequestQueue.toArray(new QueuedResendRequest[this.resendRequestQueue.size()]);
                int length = items.length;
                packetNumbers = new int[length];
                realLength = 0;
                for (int i = 0; i < length; ++i) {
                    QueuedResendRequest qrr = items[i];
                    if (this.packetNumbersReceived.contains(qrr.packetNumber)) {
                        if (logMINOR) {
                            Logger.minor(this, "Have already seen " + qrr.packetNumber + ", removing from resend list");
                        }
                        this.resendRequestQueue.remove(qrr);
                        continue;
                    }
                    if (qrr.activeTime <= now) {
                        packetNumbers[realLength++] = qrr.packetNumber;
                        if (logMINOR) {
                            Logger.minor(this, "Grabbing resend request: " + qrr.packetNumber + " from " + this);
                        }
                        qrr.sent();
                        continue;
                    }
                    if (!logMINOR) continue;
                    Logger.minor(this, "Rejecting resend request: " + qrr.packetNumber + " - in future by " + (qrr.activeTime - now) + "ms for " + this);
                }
            }
        }
        catch (UpdatableSortedLinkedListKilledException e) {
            throw new NotConnectedException();
        }
        int[] trimmedPacketNumbers = new int[realLength];
        System.arraycopy(packetNumbers, 0, trimmedPacketNumbers, 0, realLength);
        return trimmedPacketNumbers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] grabAckRequests() throws NotConnectedException, StillNotAckedException {
        int realLength;
        int[] packetNumbers;
        if (logMINOR) {
            Logger.minor(this, "Grabbing ack requests");
        }
        try {
            UpdatableSortedLinkedListWithForeignIndex<QueuedAckRequest> updatableSortedLinkedListWithForeignIndex = this.ackRequestQueue;
            synchronized (updatableSortedLinkedListWithForeignIndex) {
                long now = System.currentTimeMillis();
                QueuedAckRequest[] items = this.ackRequestQueue.toArray(new QueuedAckRequest[this.ackRequestQueue.size()]);
                int length = items.length;
                packetNumbers = new int[length];
                realLength = 0;
                for (int i = 0; i < length; ++i) {
                    QueuedAckRequest qr = items[i];
                    int packetNumber = qr.packetNumber;
                    if (qr.activeTime <= now) {
                        if (this.sentPacketsContents.get(packetNumber) == null) {
                            if (logMINOR) {
                                Logger.minor(this, "Asking to ack packet which has already been acked: " + packetNumber + " on " + this + ".grabAckRequests");
                            }
                            this.ackRequestQueue.remove(qr);
                            continue;
                        }
                        if (now - qr.createdTime > 120000L) {
                            if (logMINOR) {
                                Logger.minor(this, "Packet " + qr.packetNumber + " sent over " + (now - qr.createdTime) + "ms ago and still not acked on " + this + " for " + this.pn);
                            }
                            if (now - qr.createdTime > 600000L) {
                                Logger.error(this, "Packet " + qr.packetNumber + " sent over " + (now - qr.createdTime) + "ms ago and still not acked on " + this + " for " + this.pn);
                                throw new StillNotAckedException(this);
                            }
                        }
                        packetNumbers[realLength++] = packetNumber;
                        if (logMINOR) {
                            Logger.minor(this, "Grabbing ack request " + packetNumber + " (" + realLength + ") from " + this);
                        }
                        qr.sent();
                        continue;
                    }
                    if (!logMINOR) continue;
                    Logger.minor(this, "Ignoring ack request " + packetNumber + " (" + realLength + ") - will become active in " + (qr.activeTime - now) + "ms on " + this + " - " + qr);
                }
            }
        }
        catch (UpdatableSortedLinkedListKilledException e) {
            throw new NotConnectedException();
        }
        if (logMINOR) {
            Logger.minor(this, "realLength now " + realLength);
        }
        int[] trimmedPacketNumbers = new int[realLength];
        System.arraycopy(packetNumbers, 0, trimmedPacketNumbers, 0, realLength);
        if (logMINOR) {
            Logger.minor(this, "Returning " + trimmedPacketNumbers.length + " ackRequests");
        }
        return trimmedPacketNumbers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextUrgentTime() {
        long earliestTime = Long.MAX_VALUE;
        List<QueuedAck> list = this.ackQueue;
        synchronized (list) {
            if (!this.ackQueue.isEmpty()) {
                QueuedAck qa = this.ackQueue.get(0);
                earliestTime = qa.urgentTime;
            }
        }
        PacketActionItem qr = null;
        UpdatableSortedLinkedListWithForeignIndex<BaseQueuedResend> updatableSortedLinkedListWithForeignIndex = this.resendRequestQueue;
        synchronized (updatableSortedLinkedListWithForeignIndex) {
            if (!this.resendRequestQueue.isEmpty()) {
                qr = (PacketActionItem)this.resendRequestQueue.getLowest();
            }
        }
        if (qr != null) {
            earliestTime = Math.min(earliestTime, qr.urgentTime);
        }
        updatableSortedLinkedListWithForeignIndex = this.ackRequestQueue;
        synchronized (updatableSortedLinkedListWithForeignIndex) {
            if (!this.ackRequestQueue.isEmpty()) {
                qr = (PacketActionItem)this.ackRequestQueue.getLowest();
            }
        }
        if (qr != null) {
            earliestTime = Math.min(earliestTime, qr.urgentTime);
        }
        return earliestTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastOutgoingSeqNumber() {
        PacketTracker packetTracker = this;
        synchronized (packetTracker) {
            return this.nextPacketNumber - 1;
        }
    }

    public void sentPacket(byte[] data, int seqNumber, AsyncMessageCallback[] callbacks, short priority) throws NotConnectedException {
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] != null) continue;
                throw new NullPointerException();
            }
        }
        if (!this.sentPacketsContents.add(seqNumber, data, callbacks, priority)) {
            throw new IllegalStateException("Cannot add data for packet " + seqNumber);
        }
        try {
            this.queueAckRequest(seqNumber);
        }
        catch (UpdatableSortedLinkedListKilledException e) {
            throw new NotConnectedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LimitedRangeIntByteArrayMapElement[] clear() {
        LimitedRangeIntByteArrayMapElement[] elements;
        if (logMINOR) {
            Logger.minor(this, "Clearing " + this);
        }
        this.isDeprecated = true;
        Iterable<Comparable<QueuedResendRequest>> iterable = this.sentPacketsContents;
        synchronized (iterable) {
            elements = this.sentPacketsContents.grabAll();
        }
        iterable = this.ackQueue;
        synchronized (iterable) {
            this.ackQueue.clear();
        }
        iterable = this.resendRequestQueue;
        synchronized (iterable) {
            this.resendRequestQueue.kill();
        }
        iterable = this.ackRequestQueue;
        synchronized (iterable) {
            this.ackRequestQueue.kill();
        }
        iterable = this.packetsToResend;
        synchronized (iterable) {
            this.packetsToResend.clear();
        }
        this.packetNumbersReceived.clear();
        return elements;
    }

    public void completelyDeprecated(SessionKey newTracker) {
        LimitedRangeIntByteArrayMapElement[] elements;
        if (newTracker.packets == this) {
            Logger.error(this, "Completely deprecated in favour of self!", new Exception("debug"));
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Completely deprecated: " + this + " in favour of " + newTracker);
        }
        if ((elements = this.clear()).length == 0) {
            return;
        }
        MessageItem[] messages = new MessageItem[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            LimitedRangeIntByteArrayMapElement element = elements[i];
            byte[] buf = element.data;
            AsyncMessageCallback[] callbacks = element.callbacks;
            if (logMINOR) {
                Logger.minor(this, "Queueing resend of what was once " + element.packetNumber);
            }
            messages[i] = new MessageItem(buf, callbacks, true, this.pn.resendByteCounter, element.priority);
        }
        this.pn.requeueMessageItems(messages, 0, messages.length, true);
        this.pn.node.ps.wakeUp();
    }

    public void disconnected() {
        LimitedRangeIntByteArrayMapElement[] elements = this.clear();
        for (int i = 0; i < elements.length; ++i) {
            LimitedRangeIntByteArrayMapElement element = elements[i];
            AsyncMessageCallback[] callbacks = element.callbacks;
            if (callbacks == null) continue;
            for (int j = 0; j < callbacks.length; ++j) {
                callbacks[j].disconnected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] grabResendPackets(Vector<ResendPacketItem> rpiTemp, int[] numbers) {
        rpiTemp.clear();
        long now = System.currentTimeMillis();
        long fourRTTs = this.twoRTTs();
        int count = 0;
        HashSet<Integer> hashSet = this.packetsToResend;
        synchronized (hashSet) {
            int len = this.packetsToResend.size();
            if (numbers.length < len) {
                numbers = new int[len * 2];
            }
            Iterator<Integer> it = this.packetsToResend.iterator();
            while (it.hasNext()) {
                int packetNo = it.next();
                long resentTime = this.sentPacketsContents.getReaddedTime(packetNo);
                if (now - resentTime <= fourRTTs) continue;
                numbers[count++] = packetNo;
                it.remove();
            }
            this.packetsToResend.clear();
        }
        for (int i = 0; i < count; ++i) {
            int packetNo = numbers[i];
            byte[] buf = this.sentPacketsContents.get(packetNo);
            if (buf == null) {
                if (!logMINOR) continue;
                Logger.minor(this, "Contents null for " + packetNo + " in grabResendPackets on " + this);
                continue;
            }
            AsyncMessageCallback[] callbacks = this.sentPacketsContents.getCallbacks(packetNo);
            short priority = this.sentPacketsContents.getPriority(packetNo, (short)4);
            rpiTemp.add(new ResendPacketItem(buf, packetNo, this, callbacks, priority));
        }
        if (rpiTemp.isEmpty()) {
            return null;
        }
        return numbers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPacketsToResend() {
        HashSet<Integer> hashSet = this.packetsToResend;
        synchronized (hashSet) {
            return !this.packetsToResend.isEmpty();
        }
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countAckRequests() {
        UpdatableSortedLinkedListWithForeignIndex<QueuedAckRequest> updatableSortedLinkedListWithForeignIndex = this.ackRequestQueue;
        synchronized (updatableSortedLinkedListWithForeignIndex) {
            return this.ackRequestQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countResendRequests() {
        UpdatableSortedLinkedListWithForeignIndex<QueuedResendRequest> updatableSortedLinkedListWithForeignIndex = this.resendRequestQueue;
        synchronized (updatableSortedLinkedListWithForeignIndex) {
            return this.resendRequestQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countAcks() {
        List<QueuedAck> list = this.ackQueue;
        synchronized (list) {
            return this.ackQueue.size();
        }
    }

    public synchronized long timeLastDecodedPacket() {
        return this.timeLastDecodedPacket;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueuedAckRequest
    extends BaseQueuedResend<QueuedAckRequest> {
        final long createdTime;
        long activeDelay;

        @Override
        long initialActiveTime(long now) {
            this.activeDelay = PacketTracker.this.twoRTTs();
            return now + this.activeDelay;
        }

        QueuedAckRequest(int packetNumber) {
            super(packetNumber);
            this.createdTime = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void sent() throws UpdatableSortedLinkedListKilledException {
            UpdatableSortedLinkedListWithForeignIndex updatableSortedLinkedListWithForeignIndex = PacketTracker.this.ackRequestQueue;
            synchronized (updatableSortedLinkedListWithForeignIndex) {
                super.sent();
                PacketTracker.this.ackRequestQueue.update(this);
            }
        }

        public void onAcked() {
            long t = Math.max(0L, System.currentTimeMillis() - this.createdTime);
            PacketTracker.this.pn.reportPing(t);
            if (logMINOR) {
                Logger.minor(this, "Reported round-trip time of " + TimeUtil.formatTime(t, 2, true) + " on " + PacketTracker.this.pn.getPeer() + " (avg " + TimeUtil.formatTime((long)PacketTracker.this.pn.averagePingTime(), 2, true) + ", #" + this.packetNumber + ')');
            }
        }

        @Override
        long urgentDelay() {
            return 100L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueuedResendRequest
    extends BaseQueuedResend<QueuedResendRequest> {
        @Override
        long initialActiveTime(long now) {
            return now;
        }

        QueuedResendRequest(int packetNumber) {
            super(packetNumber);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void sent() throws UpdatableSortedLinkedListKilledException {
            UpdatableSortedLinkedListWithForeignIndex updatableSortedLinkedListWithForeignIndex = PacketTracker.this.resendRequestQueue;
            synchronized (updatableSortedLinkedListWithForeignIndex) {
                super.sent();
                PacketTracker.this.resendRequestQueue.update(this);
            }
        }

        @Override
        long urgentDelay() {
            return 100L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BaseQueuedResend<T extends BaseQueuedResend<T>>
    extends PacketActionItem
    implements IndexableUpdatableSortedLinkedListItem<T> {
        long activeTime;
        private T next;
        private T prev;
        private DoublyLinkedList<? super T> parent;

        void sent() throws UpdatableSortedLinkedListKilledException {
            long now = System.currentTimeMillis();
            this.activeTime = now + 500L;
            this.urgentTime = this.activeTime + this.urgentDelay();
        }

        BaseQueuedResend(int packetNumber) {
            this.packetNumber = packetNumber;
            long now = System.currentTimeMillis();
            this.activeTime = this.initialActiveTime(now);
            this.urgentTime = this.activeTime + this.urgentDelay();
        }

        abstract long urgentDelay();

        abstract long initialActiveTime(long var1);

        @Override
        public final T getNext() {
            return this.next;
        }

        @Override
        public final T setNext(DoublyLinkedList.Item<?> i) {
            T old = this.next;
            this.next = (BaseQueuedResend)i;
            return old;
        }

        @Override
        public T getPrev() {
            return this.prev;
        }

        @Override
        public T setPrev(DoublyLinkedList.Item<?> i) {
            T old = this.prev;
            this.prev = (BaseQueuedResend)i;
            return old;
        }

        @Override
        public int compareTo(T r) {
            if (this.urgentTime > ((BaseQueuedResend)r).urgentTime) {
                return 1;
            }
            if (this.urgentTime < ((BaseQueuedResend)r).urgentTime) {
                return -1;
            }
            if (this.packetNumber > ((BaseQueuedResend)r).packetNumber) {
                return 1;
            }
            if (this.packetNumber < ((BaseQueuedResend)r).packetNumber) {
                return -1;
            }
            return 0;
        }

        @Override
        public Object indexValue() {
            return this.packetNumber;
        }

        @Override
        public DoublyLinkedList<? super T> getParent() {
            return this.parent;
        }

        @Override
        public DoublyLinkedList<? super T> setParent(DoublyLinkedList<? super T> l) {
            DoublyLinkedList<? super T> old = this.parent;
            this.parent = l;
            return old;
        }
    }

    private static final class QueuedForgotten
    extends PacketActionItem {
        QueuedForgotten(int packet) {
            long now = System.currentTimeMillis();
            this.packetNumber = packet;
            this.urgentTime = now + 100L;
        }
    }

    private static final class QueuedAck
    extends PacketActionItem {
        QueuedAck(int packet) {
            long now = System.currentTimeMillis();
            this.packetNumber = packet;
            this.urgentTime = now + 200L;
        }
    }

    static class PacketActionItem {
        int packetNumber;
        long urgentTime;

        PacketActionItem() {
        }

        public String toString() {
            return super.toString() + ": packet " + this.packetNumber + " urgent@" + this.urgentTime + '(' + (System.currentTimeMillis() - this.urgentTime) + ')';
        }
    }
}

