/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.Peer;
import freenet.l10n.L10n;
import freenet.node.BlockedTooLongException;
import freenet.node.FastRunnable;
import freenet.node.Node;
import freenet.node.NodeStats;
import freenet.node.OpennetManager;
import freenet.node.PeerManager;
import freenet.node.PeerNode;
import freenet.node.ResendPacketItem;
import freenet.node.Ticker;
import freenet.node.Version;
import freenet.node.useralerts.UserAlert;
import freenet.support.HTMLNode;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.OOMHandler;
import freenet.support.TimeUtil;
import freenet.support.io.NativeThread;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.Vector;

public class PacketSender
implements Runnable,
Ticker {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    static final int MAX_COALESCING_DELAY = 100;
    static final int MIN_CONNECTIONS_TRY_OLD_OPENNET_PEERS = 5;
    static final int MIN_OLD_OPENNET_CONNECT_DELAY_NO_CONNS = 10000;
    static final int MIN_OLD_OPENNET_CONNECT_DELAY = 60000;
    private final TreeMap<Long, Object> timedJobsByTime;
    final NativeThread myThread;
    final Node node;
    NodeStats stats;
    long lastClearedOldSwapChains;
    long lastReportedNoPackets;
    long lastReceivedPacketFromAnyNode;
    private Vector<ResendPacketItem> rpiTemp;
    private int[] rpiIntTemp;
    private HashSet<Peer> peersDumpedBlockedTooLong = new HashSet();
    private UserAlert peersDumpedBlockedTooLongAlert = new UserAlert(){

        public String anchor() {
            return "disconnectedStillNotAcked";
        }

        public String dismissButtonText() {
            return null;
        }

        public short getPriorityClass() {
            return 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getShortText() {
            int sz;
            HashSet hashSet = PacketSender.this.peersDumpedBlockedTooLong;
            synchronized (hashSet) {
                sz = PacketSender.this.peersDumpedBlockedTooLong.size();
            }
            return PacketSender.this.l10n("somePeersDisconnectedBlockedTooLong", "count", Integer.toString(sz));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HTMLNode getHTMLText() {
            Peer[] peers;
            HTMLNode div = new HTMLNode("div");
            HashSet hashSet = PacketSender.this.peersDumpedBlockedTooLong;
            synchronized (hashSet) {
                peers = PacketSender.this.peersDumpedBlockedTooLong.toArray(new Peer[PacketSender.this.peersDumpedBlockedTooLong.size()]);
            }
            L10n.addL10nSubstitution(div, "PacketSender.somePeersDisconnectedBlockedTooLongDetail", new String[]{"count", "link", "/link"}, new String[]{Integer.toString(peers.length), "<a href=\"/?_CHECKED_HTTP_=https://bugs.freenetproject.org/\">", "</a>"});
            HTMLNode list = div.addChild("ul");
            for (Peer peer : peers) {
                list.addChild("li", peer.toString());
            }
            return div;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getText() {
            Peer[] peers;
            StringBuffer sb = new StringBuffer();
            HashSet hashSet = PacketSender.this.peersDumpedBlockedTooLong;
            synchronized (hashSet) {
                peers = PacketSender.this.peersDumpedBlockedTooLong.toArray(new Peer[PacketSender.this.peersDumpedBlockedTooLong.size()]);
            }
            sb.append(PacketSender.this.l10n("somePeersDisconnectedStillNotAckedDetail", new String[]{"count", "link", "/link"}, new String[]{Integer.toString(peers.length), "", ""}));
            sb.append('\n');
            for (Peer peer : peers) {
                sb.append('\t');
                sb.append(peer.toString());
                sb.append('\n');
            }
            return sb.toString();
        }

        public String getTitle() {
            return this.getShortText();
        }

        public Object getUserIdentifier() {
            return PacketSender.this;
        }

        public boolean isEventNotification() {
            return false;
        }

        public boolean isValid() {
            return true;
        }

        public void isValid(boolean validity) {
        }

        public void onDismiss() {
        }

        public boolean shouldUnregisterOnDismiss() {
            return false;
        }

        public boolean userCanDismiss() {
            return false;
        }
    };

    PacketSender(Node node) {
        this.timedJobsByTime = new TreeMap();
        this.node = node;
        this.myThread = new NativeThread(this, "PacketSender thread for " + node.getDarknetPortNumber(), 10, false);
        this.myThread.setDaemon(true);
        this.rpiTemp = new Vector();
        this.rpiIntTemp = new int[64];
    }

    void start(NodeStats stats) {
        this.stats = stats;
        Logger.normal(this, "Starting PacketSender");
        System.out.println("Starting PacketSender");
        long now = System.currentTimeMillis();
        long transition = Version.transitionTime;
        if (now < transition) {
            this.queueTimedJob(new Runnable(){

                public void run() {
                    Logger.OSThread.logPID(this);
                    PeerNode[] nodes = PacketSender.this.node.peers.myPeers;
                    for (int i = 0; i < nodes.length; ++i) {
                        PeerNode pn = nodes[i];
                        pn.updateVersionRoutablity();
                    }
                }
            }, transition - now);
        }
        this.myThread.start();
    }

    public void run() {
        if (logMINOR) {
            Logger.minor(this, "In PacketSender.run()");
        }
        Logger.OSThread.logPID(this);
        int brokeAt = 0;
        while (true) {
            this.lastReceivedPacketFromAnyNode = this.lastReportedNoPackets;
            try {
                brokeAt = this.realRun(brokeAt);
                continue;
            }
            catch (OutOfMemoryError e) {
                OOMHandler.handleOOM(e);
                System.err.println("Will retry above failed operation...");
                continue;
            }
            catch (Throwable t) {
                Logger.error(this, "Caught in PacketSender: " + t, t);
                System.err.println("Caught in PacketSender: " + t);
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private int realRun(int brokeAt) {
        Long l;
        long now = System.currentTimeMillis();
        PeerManager pm = this.node.peers;
        PeerNode[] nodes = pm.myPeers;
        for (int i = 0; i < nodes.length; ++i) {
            PeerNode pn = nodes[i];
            if (pn.getPeerNodeStatus() != 2) continue;
            pn.setPeerNodeStatus(now);
        }
        pm.maybeLogPeerNodeStatusSummary(now);
        pm.maybeUpdateOldestNeverConnectedPeerAge(now);
        this.stats.maybeUpdatePeerManagerUserAlertStats(now);
        this.stats.maybeUpdateNodeIOStats(now);
        pm.maybeUpdatePeerNodeRoutableConnectionStats(now);
        long nextActionTime = Long.MAX_VALUE;
        long oldTempNow = now;
        this.node.lm.removeTooOldQueuedItems();
        boolean canSendThrottled = false;
        int MAX_PACKET_SIZE = this.node.darknetCrypto.socket.getMaxPacketSize();
        long count = this.node.outputThrottle.getCount();
        if (count > (long)MAX_PACKET_SIZE) {
            canSendThrottled = true;
        } else {
            long canSendAt = this.node.outputThrottle.getNanosPerTick() * ((long)MAX_PACKET_SIZE - count);
            canSendAt = canSendAt / 1000000L + (long)(canSendAt % 1000000L == 0L ? 0 : 1);
            if (logMINOR) {
                Logger.minor(this, "Can send throttled packets in " + canSendAt + "ms");
            }
            nextActionTime = Math.min(nextActionTime, now + canSendAt);
        }
        int newBrokeAt = brokeAt;
        for (int i = 0; i < nodes.length; ++i) {
            long tempNow;
            int idx = (i + brokeAt + 1) % nodes.length;
            PeerNode pn = nodes[idx];
            this.lastReceivedPacketFromAnyNode = Math.max(pn.lastReceivedPacketTime(), this.lastReceivedPacketFromAnyNode);
            pn.maybeOnConnect();
            if (pn.shouldDisconnectAndRemoveNow() && !pn.isDisconnecting()) {
                this.node.peers.disconnect(pn, true, true, false);
            }
            if (pn.isConnected()) {
                block48: {
                    if (pn.shouldThrottle() && !canSendThrottled) continue;
                    if (now - pn.lastReceivedPacketTime() > (long)pn.maxTimeBetweenReceivedPackets()) {
                        Logger.normal(this, "Disconnecting from " + pn + " - haven't received packets recently");
                        pn.disconnected(false, false);
                        continue;
                    }
                    if (pn.isRoutable() && pn.noLongerRoutable()) {
                        pn.invalidate();
                        pn.setPeerNodeStatus(now);
                        Logger.normal(this, "shouldDisconnectNow has returned true : marking the peer as incompatible: " + pn);
                        continue;
                    }
                    try {
                        if (!canSendThrottled && pn.shouldThrottle() || !pn.maybeSendPacket(now, this.rpiTemp, this.rpiIntTemp)) break block48;
                        canSendThrottled = false;
                        count = this.node.outputThrottle.getCount();
                        if (count > (long)MAX_PACKET_SIZE) {
                            canSendThrottled = true;
                        } else {
                            long canSendAt = this.node.outputThrottle.getNanosPerTick() * ((long)MAX_PACKET_SIZE - count);
                            canSendAt = canSendAt / 1000000L + (long)(canSendAt % 1000000L == 0L ? 0 : 1);
                            if (logMINOR) {
                                Logger.minor(this, "Can send throttled packets in " + canSendAt + "ms");
                            }
                            nextActionTime = Math.min(nextActionTime, now + canSendAt);
                            newBrokeAt = idx;
                        }
                    }
                    catch (BlockedTooLongException e) {
                        Logger.error(this, "Waited too long: " + TimeUtil.formatTime(e.delta) + " to allocate a packet number to send to " + this + " on " + e.tracker + " - DISCONNECTING!");
                        pn.forceDisconnect(true);
                        this.onForceDisconnectBlockTooLong(pn, e);
                    }
                }
                long urgentTime = pn.getNextUrgentTime(now);
                if (urgentTime < Long.MAX_VALUE && logMINOR) {
                    Logger.minor(this, "Next urgent time: " + urgentTime + "(in " + (urgentTime - now) + ") for " + pn.getPeer());
                }
                nextActionTime = Math.min(nextActionTime, urgentTime);
            } else if (pn.noContactDetails()) {
                pn.startARKFetcher();
            }
            if (pn.shouldSendHandshake()) {
                long beforeHandshakeTime = System.currentTimeMillis();
                pn.getOutgoingMangler().sendHandshake(pn, false);
                long l2 = System.currentTimeMillis();
                if (l2 - beforeHandshakeTime > 2000L) {
                    Logger.error(this, "afterHandshakeTime is more than 2 seconds past beforeHandshakeTime (" + (l2 - beforeHandshakeTime) + ") in PacketSender working with " + pn.userToString());
                }
            }
            if ((tempNow = System.currentTimeMillis()) - oldTempNow > 5000L) {
                Logger.error(this, "tempNow is more than 5 seconds past oldTempNow (" + (tempNow - oldTempNow) + ") in PacketSender working with " + pn.userToString());
            }
            oldTempNow = tempNow;
        }
        brokeAt = newBrokeAt;
        OpennetManager om = this.node.getOpennet();
        if (om != null && this.node.getUptime() > 30000L) {
            PeerNode[] peers;
            for (PeerNode peerNode : peers = om.getOldPeers()) {
                if (peerNode.timeLastConnected() <= 0L) {
                    Logger.error(this, "Last connected is zero or negative for old-opennet-peer " + peerNode);
                }
                if (now - peerNode.timeLastConnected() > -1616567296L) {
                    om.purgeOldOpennetPeer(peerNode);
                    if (!logMINOR) continue;
                    Logger.minor(this, "Removing old opennet peer (too old): " + peerNode);
                    continue;
                }
                if (peerNode.isConnected()) continue;
                if (peerNode.noContactDetails()) {
                    peerNode.startARKFetcher();
                    continue;
                }
                if (!peerNode.shouldSendHandshake()) continue;
                long beforeHandshakeTime = System.currentTimeMillis();
                peerNode.getOutgoingMangler().sendHandshake(peerNode, true);
                long afterHandshakeTime = System.currentTimeMillis();
                if (afterHandshakeTime - beforeHandshakeTime <= 2000L) continue;
                Logger.error(this, "afterHandshakeTime is more than 2 seconds past beforeHandshakeTime (" + (afterHandshakeTime - beforeHandshakeTime) + ") in PacketSender working with " + peerNode.userToString());
            }
        }
        if (now - this.lastClearedOldSwapChains > 10000L) {
            this.node.lm.clearOldSwapChains();
            this.lastClearedOldSwapChains = now;
        }
        long oldNow = now;
        now = System.currentTimeMillis();
        if (now - oldNow > 10000L) {
            Logger.error(this, "now is more than 10 seconds past oldNow (" + (now - oldNow) + ") in PacketSender");
        }
        ArrayList<Object> jobsToRun = null;
        TreeMap<Long, Object> i$ = this.timedJobsByTime;
        // MONITORENTER : i$
        while (!this.timedJobsByTime.isEmpty() && (l = this.timedJobsByTime.firstKey()) <= now) {
            Job[] r;
            Object o;
            if (jobsToRun == null) {
                jobsToRun = new ArrayList<Object>();
            }
            if ((o = this.timedJobsByTime.remove(l)) instanceof Job[]) {
                r = (Job[])o;
                for (int i = 0; i < r.length; ++i) {
                    jobsToRun.add(r[i]);
                }
                continue;
            }
            r = (Job[])o;
            jobsToRun.add(r);
        }
        // MONITOREXIT : i$
        if (jobsToRun != null) {
            for (Job job : jobsToRun) {
                if (logMINOR) {
                    Logger.minor(this, "Running " + job);
                }
                if (job.job instanceof FastRunnable) {
                    try {
                        job.job.run();
                    }
                    catch (Throwable t) {
                        Logger.error(this, "Caught " + t + " running " + job, t);
                    }
                    continue;
                }
                try {
                    this.node.executor.execute(job.job, job.name, true);
                }
                catch (OutOfMemoryError e) {
                    OOMHandler.handleOOM(e);
                    System.err.println("Will retry above failed operation...");
                    this.queueTimedJob(job.job, job.name, 200L, true, false);
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught in PacketSender: " + t, t);
                    System.err.println("Caught in PacketSender: " + t);
                    t.printStackTrace();
                }
            }
        }
        long sleepTime = nextActionTime - now;
        sleepTime = Math.min(sleepTime, 100L);
        if (now - this.node.startupTime > 300000L && now - this.lastReceivedPacketFromAnyNode > 60000L) {
            Logger.error(this, "Have not received any packets from any node in last 60 seconds");
            this.lastReportedNoPackets = now;
        }
        if (sleepTime <= 0L) return brokeAt;
        try {
            if (logMINOR) {
                Logger.minor(this, "Sleeping for " + sleepTime);
            }
            PacketSender t = this;
            // MONITORENTER : t
            this.wait(sleepTime);
            // MONITOREXIT : t
            return brokeAt;
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return brokeAt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onForceDisconnectBlockTooLong(PeerNode pn, BlockedTooLongException e) {
        Peer p = pn.getPeer();
        HashSet<Peer> hashSet = this.peersDumpedBlockedTooLong;
        synchronized (hashSet) {
            this.peersDumpedBlockedTooLong.add(p);
            if (this.peersDumpedBlockedTooLong.size() > 1) {
                return;
            }
        }
        if (this.node.clientCore == null || this.node.clientCore.alerts == null) {
            return;
        }
        this.node.clientCore.alerts.register(this.peersDumpedBlockedTooLongAlert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeUp() {
        PacketSender packetSender = this;
        synchronized (packetSender) {
            this.notifyAll();
        }
    }

    protected String l10n(String key, String[] patterns, String[] values) {
        return L10n.getString("PacketSender." + key, patterns, values);
    }

    protected String l10n(String key, String pattern, String value) {
        return L10n.getString("PacketSender." + key, pattern, value);
    }

    public void queueTimedJob(Runnable job, long offset) {
        this.queueTimedJob(job, "Scheduled job: " + job, offset, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueTimedJob(Runnable runner, String name, long offset, boolean runOnTickerAnyway, boolean noDupes) {
        if (offset <= 0L && !runOnTickerAnyway) {
            if (logMINOR) {
                Logger.minor(this, "Running directly: " + runner);
            }
            this.node.executor.execute(runner, name);
            return;
        }
        Job job = new Job(name, runner);
        if (offset < 0L) {
            offset = 0L;
        }
        long now = System.currentTimeMillis();
        Long l = offset + now;
        TreeMap<Long, Object> treeMap = this.timedJobsByTime;
        synchronized (treeMap) {
            if (noDupes && this.timedJobsByTime.containsValue(runner)) {
                Logger.normal(this, "Not re-running as already queued: " + runner + " for " + name);
                return;
            }
            Object o = this.timedJobsByTime.get(l);
            if (o == null) {
                this.timedJobsByTime.put(l, job);
            } else if (o instanceof Job) {
                this.timedJobsByTime.put(l, new Job[]{(Job)o, job});
            } else if (o instanceof Job[]) {
                Job[] r = (Job[])o;
                Job[] jobs = new Job[r.length + 1];
                System.arraycopy(r, 0, jobs, 0, r.length);
                jobs[jobs.length - 1] = job;
                this.timedJobsByTime.put(l, jobs);
            }
        }
        if (offset < 100L) {
            this.wakeUp();
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
                logDEBUG = Logger.shouldLog(2, this);
            }
        });
    }

    private static final class Job {
        final String name;
        final Runnable job;

        Job(String name, Runnable job) {
            this.name = name;
            this.job = job;
        }
    }
}

