/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.node.NodeCrypto;
import freenet.node.OpennetManager;
import freenet.node.OpennetPeerNodeStatus;
import freenet.node.OutgoingPacketMangler;
import freenet.node.PeerManager;
import freenet.node.PeerNode;
import freenet.node.PeerNodeStatus;
import freenet.support.SimpleFieldSet;

public class OpennetPeerNode
extends PeerNode {
    final OpennetManager opennet;
    private long timeLastSuccess;
    private boolean wasDropped;

    public OpennetPeerNode(SimpleFieldSet fs, Node node2, NodeCrypto crypto, OpennetManager opennet, PeerManager peers, boolean fromLocal, OutgoingPacketMangler mangler) throws FSParseException, PeerParseException, ReferenceSignatureVerificationException {
        super(fs, node2, crypto, peers, fromLocal, false, mangler, true);
        if (fromLocal) {
            SimpleFieldSet metadata = fs.subset("metadata");
            this.timeLastSuccess = metadata.getLong("timeLastSuccess", 0L);
        }
        this.opennet = opennet;
    }

    public PeerNodeStatus getStatus(boolean noHeavy) {
        return new OpennetPeerNodeStatus(this, noHeavy);
    }

    public boolean isRoutingCompatible() {
        if (!this.node.isOpennetEnabled()) {
            return false;
        }
        return super.isRoutingCompatible();
    }

    public boolean isDarknet() {
        return false;
    }

    public boolean isOpennet() {
        return true;
    }

    public boolean isSeed() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDroppable(boolean ignoreDisconnect) {
        long now = System.currentTimeMillis();
        if (now - this.getPeerAddedTime() < 300000L) {
            return false;
        }
        if (now - this.node.usm.getStartedTime() < 120000L) {
            return false;
        }
        int status = this.getPeerNodeStatus();
        if (!ignoreDisconnect) {
            OpennetPeerNode opennetPeerNode = this;
            synchronized (opennetPeerNode) {
                if (status == 5 && !super.neverConnected() && now - this.timeLastDisconnect < 600000L && now - this.timePrevDisconnect > 3600000L) {
                    return false;
                }
            }
        }
        return true;
    }

    public void onSuccess(boolean insert, boolean ssk) {
        if (insert || ssk) {
            return;
        }
        this.timeLastSuccess = System.currentTimeMillis();
        this.opennet.onSuccess(this);
    }

    public void onRemove() {
        this.opennet.onRemove(this);
        super.onRemove();
    }

    public synchronized SimpleFieldSet exportMetadataFieldSet() {
        SimpleFieldSet fs = super.exportMetadataFieldSet();
        fs.put("timeLastSuccess", this.timeLastSuccess);
        return fs;
    }

    public final long timeLastSuccess() {
        return this.timeLastSuccess;
    }

    public static boolean validateRef(SimpleFieldSet ref) {
        return ref.getBoolean("opennet", false);
    }

    public boolean isRealConnection() {
        return true;
    }

    public boolean recordStatus() {
        return true;
    }

    protected boolean generateIdentityFromPubkey() {
        return false;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof OpennetPeerNode) {
            return super.equals(o);
        }
        return false;
    }

    public final boolean shouldDisconnectAndRemoveNow() {
        return this.isConnected() && this.isUnroutableOlderVersion() && System.currentTimeMillis() - this.timeLastConnectionCompleted() > 3600000L;
    }

    protected void onConnect() {
        super.onConnect();
        this.opennet.crypto.socket.getAddressTracker().setPresumedGuiltyAt(System.currentTimeMillis() + 3600000L);
    }

    synchronized void setWasDropped() {
        this.wasDropped = true;
    }

    synchronized boolean wasDropped() {
        return this.wasDropped;
    }

    synchronized boolean grabWasDropped() {
        boolean ret = this.wasDropped;
        this.wasDropped = false;
        return ret;
    }
}

