/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.Peer;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.io.comm.RetrievalException;
import freenet.io.xfer.BulkReceiver;
import freenet.io.xfer.BulkTransmitter;
import freenet.io.xfer.PartiallyReceivedBulk;
import freenet.node.AnnounceSender;
import freenet.node.AnnouncementCallback;
import freenet.node.Announcer;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.node.NodeCrypto;
import freenet.node.NodeCryptoConfig;
import freenet.node.NodeInitException;
import freenet.node.OpennetPeerNode;
import freenet.node.PeerNode;
import freenet.support.LRUQueue;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.SizeUtil;
import freenet.support.TimeSortedHashtable;
import freenet.support.io.ByteArrayRandomAccessThing;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import freenet.support.transport.ip.HostnameSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;

public class OpennetManager {
    final Node node;
    final NodeCrypto crypto;
    final Announcer announcer;
    private final LRUQueue<PeerNode> peersLRU;
    private final LRUQueue<PeerNode> oldPeers;
    static final int MAX_OLD_PEERS = 25;
    private long timeLastDropped;
    private long successCount;
    public static final int MIN_SUCCESS_BETWEEN_DROP_CONNS = 10;
    public static final int RESET_PATH_FOLDING_PROB = 20;
    public static final int DONT_READD_TIME = 60000;
    public static final int DROP_MIN_AGE = 300000;
    public static final int DROP_STARTUP_DELAY = 120000;
    public static final int DROP_DISCONNECT_DELAY = 600000;
    public static final int DROP_DISCONNECT_DELAY_COOLDOWN = 3600000;
    public static final int DROP_CONNECTED_TIME = 600000;
    public static final int MIN_TIME_BETWEEN_OFFERS = 30000;
    private static boolean logMINOR;
    public static final int PADDED_NODEREF_SIZE = 3072;
    public static final int MAX_OPENNET_NODEREF_LENGTH = 32768;
    public static final boolean ENABLE_PEERS_PER_KB_OUTPUT = false;
    public static final int TARGET_BANDWIDTH_USAGE = 20480;
    public static final int MIN_PEERS_FOR_SCALING = 10;
    public static final int MAX_PEERS_FOR_SCALING = 20;
    public static final long MAX_TIME_ON_OLD_OPENNET_PEERS = -1616567296L;
    private final long creationTime;
    private long timeLastOffered;
    private long timeLastAddedOldOpennetPeer = -1L;
    private static final int OLD_OPENNET_PEER_INTERVAL = 30000;
    private static final long MAX_AGE = 604800000L;
    private final TimeSortedHashtable<String> knownIds = new TimeSortedHashtable();

    public OpennetManager(Node node, NodeCryptoConfig opennetConfig, long startupTime, boolean enableAnnouncement) throws NodeInitException {
        logMINOR = Logger.shouldLog(4, this);
        this.creationTime = System.currentTimeMillis();
        this.node = node;
        this.crypto = new NodeCrypto(node, true, opennetConfig, startupTime, node.enableARKs);
        File nodeFile = new File(node.nodeDir, "opennet-" + this.crypto.portNumber);
        File backupNodeFile = new File("opennet-" + this.crypto.portNumber + ".bak");
        try {
            this.readFile(nodeFile);
        }
        catch (IOException e) {
            try {
                this.readFile(backupNodeFile);
            }
            catch (IOException e1) {
                this.crypto.initCrypto();
            }
        }
        this.peersLRU = new LRUQueue();
        this.oldPeers = new LRUQueue();
        node.peers.tryReadPeers(new File(node.nodeDir, "openpeers-" + this.crypto.portNumber).toString(), this.crypto, this, true, false);
        OpennetPeerNode[] nodes = node.peers.getOpennetPeers();
        Arrays.sort(nodes, new Comparator<OpennetPeerNode>(){

            @Override
            public int compare(OpennetPeerNode pn1, OpennetPeerNode pn2) {
                long lastSuccess2;
                long lastSuccess1 = pn1.timeLastSuccess();
                if (lastSuccess1 > (lastSuccess2 = pn2.timeLastSuccess())) {
                    return 1;
                }
                if (lastSuccess2 > lastSuccess1) {
                    return -1;
                }
                boolean neverConnected1 = pn1.neverConnected();
                boolean neverConnected2 = pn2.neverConnected();
                if (neverConnected1 && !neverConnected2) {
                    return -1;
                }
                if (!neverConnected1 && neverConnected2) {
                    return 1;
                }
                return pn1.hashCode - pn2.hashCode;
            }
        });
        for (int i = 0; i < nodes.length; ++i) {
            this.peersLRU.push(nodes[i]);
        }
        this.dropExcessPeers();
        this.writeFile(nodeFile, backupNodeFile);
        node.peers.tryReadPeers(new File(node.nodeDir, "openpeers-old-" + this.crypto.portNumber).toString(), this.crypto, this, true, true);
        Announcer announcer = this.announcer = enableAnnouncement ? new Announcer(this) : null;
        if (logMINOR) {
            Logger.minor(this, "My full compressed ref: " + this.crypto.myCompressedFullRef().length);
            Logger.minor(this, "My full setup ref: " + this.crypto.myCompressedSetupRef().length);
            Logger.minor(this, "My heavy setup ref: " + this.crypto.myCompressedHeavySetupRef().length);
        }
    }

    public void writeFile() {
        File nodeFile = new File(this.node.nodeDir, "opennet-" + this.crypto.portNumber);
        File backupNodeFile = new File("opennet-" + this.crypto.portNumber + ".bak");
        this.writeFile(nodeFile, backupNodeFile);
    }

    private void writeFile(File orig, File backup) {
        logMINOR = Logger.shouldLog(4, this);
        SimpleFieldSet fs = this.crypto.exportPrivateFieldSet();
        if (orig.exists()) {
            backup.delete();
        }
        FileOutputStream fos = null;
        OutputStreamWriter osr = null;
        BufferedWriter bw = null;
        try {
            fos = new FileOutputStream(backup);
            osr = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            bw = new BufferedWriter(osr);
            fs.writeTo(bw);
            bw.close();
            FileUtil.renameTo(backup, orig);
        }
        catch (IOException e) {
            Closer.close(bw);
            Closer.close(osr);
            Closer.close(fos);
        }
    }

    private void readFile(File filename) throws IOException {
        FileInputStream fis = new FileInputStream(filename);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
        BufferedReader br = new BufferedReader(isr);
        SimpleFieldSet fs = new SimpleFieldSet(br, false, true);
        br.close();
        String[] udp = fs.getAll("physical.udp");
        if (udp != null && udp.length > 0) {
            for (int i = 0; i < udp.length; ++i) {
                Peer p;
                try {
                    p = new Peer(udp[i], false, true);
                }
                catch (HostnameSyntaxException e) {
                    Logger.error(this, "Invalid hostname or IP Address syntax error while loading opennet peer node reference: " + udp[i]);
                    System.err.println("Invalid hostname or IP Address syntax error while loading opennet peer node reference: " + udp[i]);
                    continue;
                }
                catch (PeerParseException e) {
                    IOException e1 = new IOException();
                    e1.initCause(e);
                    throw e1;
                }
                if (p.getPort() != this.crypto.portNumber) continue;
                this.node.ipDetector.setOldIPAddress(p.getFreenetAddress());
                break;
            }
        }
        this.crypto.readCrypto(fs);
    }

    public void start() {
        this.crypto.start();
        if (this.announcer != null) {
            this.announcer.start();
        }
    }

    public void stop(boolean purge) {
        if (this.announcer != null) {
            this.announcer.stop();
        }
        this.crypto.stop();
        if (purge) {
            this.node.peers.removeOpennetPeers();
        }
        this.crypto.socket.getAddressTracker().setPresumedInnocent();
    }

    public OpennetPeerNode addNewOpennetNode(SimpleFieldSet fs) throws FSParseException, PeerParseException, ReferenceSignatureVerificationException {
        try {
            OpennetPeerNode pn = new OpennetPeerNode(fs, this.node, this.crypto, this, this.node.peers, false, this.crypto.packetMangler);
            if (Arrays.equals(pn.getIdentity(), this.crypto.myIdentity)) {
                if (logMINOR) {
                    Logger.minor(this, "Not adding self as opennet peer");
                }
                return null;
            }
            if (this.peersLRU.contains(pn)) {
                if (logMINOR) {
                    Logger.minor(this, "Not adding " + pn.userToString() + " to opennet list as already there");
                }
                return null;
            }
            if (this.wantPeer(pn, true, false, false)) {
                return pn;
            }
            return null;
        }
        catch (Throwable t) {
            Logger.error(this, "Caught " + t + " adding opennet node from fieldset", t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceAddPeer(PeerNode nodeToAddNow, boolean addAtLRU) {
        OpennetManager opennetManager = this;
        synchronized (opennetManager) {
            if (addAtLRU) {
                this.peersLRU.pushLeast(nodeToAddNow);
            } else {
                this.peersLRU.push(nodeToAddNow);
            }
            this.oldPeers.remove(nodeToAddNow);
        }
        this.dropExcessPeers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wantPeer(PeerNode nodeToAddNow, boolean addAtLRU, boolean justChecking, boolean oldOpennetPeer) {
        boolean noDisconnect;
        boolean notMany = false;
        OpennetManager opennetManager = this;
        synchronized (opennetManager) {
            if (nodeToAddNow != null && this.peersLRU.contains(nodeToAddNow)) {
                if (logMINOR) {
                    Logger.minor(this, "Opennet peer already present in LRU: " + nodeToAddNow);
                }
                return true;
            }
            if (this.getSize() < this.getNumberOfConnectedPeersToAim()) {
                if (nodeToAddNow != null) {
                    if (logMINOR) {
                        Logger.minor(this, "Added opennet peer " + nodeToAddNow + " as opennet peers list not full");
                    }
                    if (addAtLRU) {
                        this.peersLRU.pushLeast(nodeToAddNow);
                    } else {
                        this.peersLRU.push(nodeToAddNow);
                    }
                    this.oldPeers.remove(nodeToAddNow);
                } else if (logMINOR) {
                    Logger.minor(this, "Want peer because not enough opennet nodes");
                }
                if (nodeToAddNow != null || !justChecking) {
                    this.timeLastOffered = System.currentTimeMillis();
                }
                notMany = true;
                if (oldOpennetPeer) {
                    this.timeLastAddedOldOpennetPeer = System.currentTimeMillis();
                }
            }
            noDisconnect = this.successCount < 10L;
        }
        if (notMany) {
            if (nodeToAddNow != null) {
                this.node.peers.addPeer(nodeToAddNow, true, true);
            }
            return true;
        }
        boolean canAdd = true;
        ArrayList<OpennetPeerNode> dropList = new ArrayList<OpennetPeerNode>();
        OpennetManager opennetManager2 = this;
        synchronized (opennetManager2) {
            OpennetPeerNode toDrop;
            int maxPeers = this.getNumberOfConnectedPeersToAim();
            boolean hasDisconnected = false;
            if (this.getSize() == maxPeers && nodeToAddNow == null) {
                toDrop = this.peerToDrop(true, false);
                if (toDrop != null) {
                    hasDisconnected = !toDrop.isConnected();
                }
            } else {
                while (this.getSize() > maxPeers - (nodeToAddNow == null ? 0 : 1)) {
                    toDrop = this.peerToDrop(noDisconnect || nodeToAddNow == null, false);
                    if (toDrop == null) {
                        if (logMINOR) {
                            Logger.minor(this, "No more peers to drop, still " + this.peersLRU.size() + " peers, cannot accept peer" + (nodeToAddNow == null ? "" : nodeToAddNow.toString()));
                        }
                        canAdd = false;
                        break;
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Drop opennet peer: " + toDrop + " (connected=" + toDrop.isConnected() + ") of " + this.peersLRU.size() + ":" + this.getSize());
                    }
                    if (!toDrop.isConnected()) {
                        hasDisconnected = true;
                    }
                    this.peersLRU.remove(toDrop);
                    dropList.add(toDrop);
                }
            }
            long now = System.currentTimeMillis();
            if (canAdd && oldOpennetPeer && this.timeLastAddedOldOpennetPeer > 0L && now - this.timeLastAddedOldOpennetPeer > 30000L) {
                canAdd = false;
            }
            if (canAdd && !justChecking) {
                if (nodeToAddNow != null) {
                    this.successCount = 0L;
                    if (addAtLRU) {
                        this.peersLRU.pushLeast(nodeToAddNow);
                    } else {
                        this.peersLRU.push(nodeToAddNow);
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Added opennet peer " + nodeToAddNow + " after clearing " + dropList.size() + " items - now have " + this.peersLRU.size() + " opennet peers");
                    }
                    this.oldPeers.remove(nodeToAddNow);
                    if (!dropList.isEmpty()) {
                        this.timeLastDropped = now;
                    }
                    if (oldOpennetPeer) {
                        this.timeLastAddedOldOpennetPeer = now;
                    }
                } else if (now - this.timeLastOffered <= 30000L && !hasDisconnected) {
                    if (logMINOR) {
                        Logger.minor(this, "Cannot make offer because of minimum time between offers (last offered " + (now - this.timeLastOffered) + " ms ago)");
                    }
                    canAdd = false;
                } else {
                    if (!dropList.isEmpty()) {
                        this.timeLastDropped = now;
                    }
                    if (!justChecking) {
                        this.timeLastOffered = now;
                        if (logMINOR) {
                            Logger.minor(this, "Sending offer");
                        }
                    }
                }
            }
        }
        if (nodeToAddNow != null && canAdd && !this.node.peers.addPeer(nodeToAddNow, true, true) && logMINOR) {
            Logger.minor(this, "Already in global peers list: " + nodeToAddNow + " when adding opennet node");
        }
        for (OpennetPeerNode pn : dropList) {
            if (logMINOR) {
                Logger.minor(this, "Dropping LRU opennet peer: " + pn);
            }
            this.node.peers.disconnect(pn, true, true, true);
        }
        return canAdd;
    }

    void dropExcessPeers() {
        while (this.getSize() > this.getNumberOfConnectedPeersToAim()) {
            OpennetPeerNode toDrop;
            if (logMINOR) {
                Logger.minor(this, "Dropping opennet peers: currently " + this.peersLRU.size());
            }
            if ((toDrop = this.peerToDrop(false, false)) == null) {
                toDrop = this.peerToDrop(false, true);
            }
            if (toDrop == null) {
                return;
            }
            this.peersLRU.remove(toDrop);
            if (logMINOR) {
                Logger.minor(this, "Dropping " + toDrop);
            }
            this.node.peers.disconnect(toDrop, true, true, true);
        }
    }

    public synchronized int getSize() {
        int x = 0;
        Enumeration<PeerNode> e = this.peersLRU.elements();
        while (e.hasMoreElements()) {
            PeerNode pn = e.nextElement();
            if (pn.isConnected() && pn.isUnroutableOlderVersion()) continue;
            ++x;
        }
        return x;
    }

    synchronized OpennetPeerNode peerToDrop(boolean noDisconnect, boolean force) {
        OpennetPeerNode pn;
        int i;
        if (this.getSize() < this.getNumberOfConnectedPeersToAim()) {
            return null;
        }
        OpennetPeerNode[] peers = this.peersLRU.toArrayOrdered(new OpennetPeerNode[this.peersLRU.size()]);
        for (i = 0; i < peers.length; ++i) {
            pn = peers[i];
            if (pn.isConnected() && pn.isUnroutableOlderVersion() || pn == null || !pn.isDroppable(false) && !force || pn.isConnected()) continue;
            if (Logger.shouldLog(4, this)) {
                Logger.minor(this, "Possibly dropping opennet peer " + pn + " as is disconnected");
            }
            pn.setWasDropped();
            return pn;
        }
        if (System.currentTimeMillis() - this.timeLastDropped < 600000L) {
            return null;
        }
        if (noDisconnect) {
            return null;
        }
        for (i = 0; i < peers.length; ++i) {
            pn = peers[i];
            if (pn == null || pn.isConnected() && pn.isUnroutableOlderVersion() || !pn.isDroppable(false) && !force) continue;
            if (Logger.shouldLog(4, this)) {
                Logger.minor(this, "Possibly dropping opennet peer " + pn + " " + (System.currentTimeMillis() - this.timeLastDropped) + " ms since last dropped peer");
            }
            pn.setWasDropped();
            return pn;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSuccess(OpennetPeerNode pn) {
        OpennetManager opennetManager = this;
        synchronized (opennetManager) {
            ++this.successCount;
            if (this.peersLRU.contains(pn)) {
                this.peersLRU.push(pn);
                if (logMINOR) {
                    Logger.minor(this, "Opennet peer " + pn + " promoted to top of LRU because of successful request");
                }
                return;
            }
            if (logMINOR) {
                Logger.minor(this, "Success on opennet peer which isn't in the LRU!: " + pn, (Throwable)new Exception("debug"));
            }
        }
        if (!this.wantPeer(pn, false, false, false)) {
            this.node.peers.disconnect(pn, true, false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemove(OpennetPeerNode pn) {
        OpennetManager opennetManager = this;
        synchronized (opennetManager) {
            this.peersLRU.remove(pn);
            if (pn.isDroppable(true) && !pn.grabWasDropped()) {
                if (logMINOR) {
                    Logger.minor(this, "onRemove() for " + pn);
                }
                this.oldPeers.push(pn);
                while (this.oldPeers.size() > 25) {
                    this.oldPeers.pop();
                }
            }
        }
    }

    synchronized PeerNode[] getOldPeers() {
        return this.oldPeers.toArrayOrdered(new PeerNode[this.oldPeers.size()]);
    }

    synchronized PeerNode[] getUnsortedOldPeers() {
        return this.oldPeers.toArray(new PeerNode[this.oldPeers.size()]);
    }

    synchronized void addOldOpennetNode(PeerNode pn) {
        this.oldPeers.push(pn);
    }

    String getOldPeersFilename() {
        return new File(this.node.nodeDir, "openpeers-old-" + this.crypto.portNumber).toString();
    }

    synchronized int countOldOpennetPeers() {
        return this.oldPeers.size();
    }

    PeerNode randomOldOpennetNode() {
        PeerNode[] nodes = this.getUnsortedOldPeers();
        if (nodes.length == 0) {
            return null;
        }
        return nodes[this.node.random.nextInt(nodes.length)];
    }

    public void purgeOldOpennetPeer(PeerNode source) {
        this.oldPeers.remove(source);
    }

    protected int getNumberOfConnectedPeersToAim() {
        int max = this.node.getMaxOpennetPeers();
        return max - this.node.peers.countConnectedDarknetPeers();
    }

    public void sendOpennetRef(boolean isReply, long uid, PeerNode peer, byte[] noderef, ByteCounter ctr) throws NotConnectedException {
        byte[] padded = new byte[this.paddedSize(noderef.length)];
        if (noderef.length > padded.length) {
            Logger.error(this, "Noderef too big: " + noderef.length + " bytes");
            return;
        }
        this.node.fastWeakRandom.nextBytes(padded);
        System.arraycopy(noderef, 0, padded, 0, noderef.length);
        long xferUID = this.node.random.nextLong();
        Message msg2 = isReply ? DMT.createFNPOpennetConnectReplyNew(uid, xferUID, noderef.length, padded.length) : DMT.createFNPOpennetConnectDestinationNew(uid, xferUID, noderef.length, padded.length);
        peer.sendAsync(msg2, null, ctr);
        this.innerSendOpennetRef(xferUID, padded, peer, ctr);
    }

    private void innerSendOpennetRef(long xferUID, byte[] padded, PeerNode peer, ByteCounter ctr) throws NotConnectedException {
        ByteArrayRandomAccessThing raf = new ByteArrayRandomAccessThing(padded);
        raf.setReadOnly();
        PartiallyReceivedBulk prb = new PartiallyReceivedBulk(this.node.usm, padded.length, 1024, raf, true);
        try {
            BulkTransmitter bt = new BulkTransmitter(prb, peer, xferUID, true, ctr);
            bt.send();
        }
        catch (DisconnectedException e) {
            throw new NotConnectedException(e);
        }
    }

    public long startSendAnnouncementRequest(long uid, PeerNode peer, byte[] noderef, ByteCounter ctr, double target, short htl) throws NotConnectedException {
        long xferUID = this.node.random.nextLong();
        Message msg = DMT.createFNPOpennetAnnounceRequest(uid, xferUID, noderef.length, this.paddedSize(noderef.length), target, htl);
        peer.sendAsync(msg, null, ctr);
        return xferUID;
    }

    public void finishSentAnnouncementRequest(PeerNode peer, byte[] noderef, ByteCounter ctr, long xferUID) throws NotConnectedException {
        byte[] padded = new byte[this.paddedSize(noderef.length)];
        this.node.fastWeakRandom.nextBytes(padded);
        System.arraycopy(noderef, 0, padded, 0, noderef.length);
        this.innerSendOpennetRef(xferUID, padded, peer, ctr);
    }

    private int paddedSize(int length) {
        if (length < 3072) {
            return 3072;
        }
        Logger.normal(this, "Large noderef: " + length);
        if (length > 32768) {
            throw new IllegalArgumentException("Too big noderef: " + length + " limit is " + 32768);
        }
        return (length >>> 10) + ((length & 0x3FF) == 0 ? 0 : 1) << 10;
    }

    public void sendAnnouncementReply(long uid, PeerNode peer, byte[] noderef, ByteCounter ctr) throws NotConnectedException {
        byte[] padded = new byte[3072];
        if (noderef.length > padded.length) {
            Logger.error(this, "Noderef too big: " + noderef.length + " bytes");
            return;
        }
        System.arraycopy(noderef, 0, padded, 0, noderef.length);
        long xferUID = this.node.random.nextLong();
        Message msg = DMT.createFNPOpennetAnnounceReply(uid, xferUID, noderef.length, padded.length);
        peer.sendAsync(msg, null, ctr);
        this.innerSendOpennetRef(xferUID, padded, peer, ctr);
    }

    public byte[] waitForOpennetNoderef(boolean isReply, PeerNode source, long uid, ByteCounter ctr) {
        Message msg;
        MessageFilter mf = MessageFilter.create().setSource(source).setField("uid", uid).setTimeout(120000).setType(isReply ? DMT.FNPOpennetConnectReplyNew : DMT.FNPOpennetConnectDestinationNew);
        if (!isReply) {
            MessageFilter mfAck = MessageFilter.create().setSource(source).setField("uid", uid).setTimeout(120000).setType(DMT.FNPOpennetCompletedAck);
            mf = mfAck.or(mf);
        }
        try {
            msg = this.node.usm.waitFor(mf, ctr);
        }
        catch (DisconnectedException e) {
            Logger.normal(this, "No opennet response because node disconnected on " + this);
            return null;
        }
        if (msg == null) {
            Logger.normal(this, "Timeout waiting for opennet peer on " + this);
            return null;
        }
        if (msg.getSpec() == DMT.FNPOpennetCompletedAck) {
            return null;
        }
        long xferUID = msg.getLong("transferUID");
        int paddedLength = msg.getInt("paddedLength");
        int realLength = msg.getInt("noderefLength");
        return this.innerWaitForOpennetNoderef(xferUID, paddedLength, realLength, source, isReply, uid, false, ctr);
    }

    byte[] innerWaitForOpennetNoderef(long xferUID, int paddedLength, int realLength, PeerNode source, boolean isReply, long uid, boolean sendReject, ByteCounter ctr) {
        if (paddedLength > 32768) {
            Logger.error(this, "Noderef too big: " + SizeUtil.formatSize(paddedLength) + " real length " + SizeUtil.formatSize(realLength));
            if (sendReject) {
                this.rejectRef(uid, source, 1, ctr);
            }
            return null;
        }
        if (realLength > paddedLength) {
            Logger.error(this, "Real length larger than padded length: " + SizeUtil.formatSize(paddedLength) + " real length " + SizeUtil.formatSize(realLength));
            if (sendReject) {
                this.rejectRef(uid, source, 2, ctr);
            }
            return null;
        }
        byte[] buf = new byte[paddedLength];
        ByteArrayRandomAccessThing raf = new ByteArrayRandomAccessThing(buf);
        PartiallyReceivedBulk prb = new PartiallyReceivedBulk(this.node.usm, buf.length, 1024, raf, false);
        BulkReceiver br = new BulkReceiver(prb, source, xferUID, ctr);
        if (logMINOR) {
            Logger.minor(this, "Receiving noderef (reply=" + isReply + ") as bulk transfer for request uid " + uid + " with transfer " + xferUID + " from " + source);
        }
        if (!br.receive()) {
            if (source.isConnected()) {
                String msg = "Failed to receive noderef bulk transfer for " + this + " : " + RetrievalException.getErrString(prb.getAbortReason()) + " : " + prb.getAbortDescription() + " from " + source;
                if (prb.getAbortReason() != 7) {
                    Logger.error(this, msg);
                } else {
                    Logger.normal(this, msg);
                }
                if (sendReject) {
                    this.rejectRef(uid, source, 3, ctr);
                }
            }
            return null;
        }
        byte[] noderef = new byte[realLength];
        System.arraycopy(buf, 0, noderef, 0, realLength);
        return noderef;
    }

    public void rejectRef(long uid, PeerNode source, int reason, ByteCounter ctr) {
        Message msg = DMT.createFNPOpennetNoderefRejected(uid, reason);
        try {
            source.sendAsync(msg, null, ctr);
        }
        catch (NotConnectedException e) {
            // empty catch block
        }
    }

    public SimpleFieldSet validateNoderef(byte[] noderef, int offset, int length, PeerNode from, boolean forceOpennetEnabled) {
        String identity;
        SimpleFieldSet ref;
        try {
            ref = PeerNode.compressedNoderefToFieldSet(noderef, 0, noderef.length);
        }
        catch (FSParseException e) {
            Logger.error(this, "Invalid noderef: " + e, e);
            return null;
        }
        if (forceOpennetEnabled) {
            ref.put("opennet", true);
        }
        if (!OpennetPeerNode.validateRef(ref)) {
            Logger.error(this, "Could not parse opennet noderef for " + this + " from " + from);
            return null;
        }
        if (ref != null && (identity = ref.get("identity")) != null) {
            this.registerKnownIdentity(identity);
        }
        return ref;
    }

    public void announce(double target, AnnouncementCallback cb) {
        AnnounceSender sender = new AnnounceSender(target, this, this.node, cb, null);
        this.node.executor.execute(sender, "Announcement to " + target);
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerKnownIdentity(String d) {
        if (logMINOR) {
            Logger.minor(this, "Known Id: " + d);
        }
        long now = System.currentTimeMillis();
        TimeSortedHashtable<String> timeSortedHashtable = this.knownIds;
        synchronized (timeSortedHashtable) {
            Logger.minor(this, "Adding Id " + d + " knownIds size " + this.knownIds.size());
            this.knownIds.push(d, now);
            Logger.minor(this, "Added Id " + d + " knownIds size " + this.knownIds.size());
            this.knownIds.removeBefore(now - 604800000L);
            Logger.minor(this, "Added and pruned location " + d + " knownIds size " + this.knownIds.size());
        }
        if (logMINOR) {
            Logger.minor(this, "Estimated opennet size(session): " + this.knownIds.size());
        }
    }

    public int getNetworkSizeEstimate(long timestamp) {
        return this.knownIds.countValuesAfter(timestamp);
    }
}

