/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.config.InvalidConfigValueException;
import freenet.config.SubConfig;
import freenet.crypt.RandomSource;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.l10n.L10n;
import freenet.node.ConfigurablePersister;
import freenet.node.MemoryChecker;
import freenet.node.Node;
import freenet.node.NodeInitException;
import freenet.node.NodePinger;
import freenet.node.PeerManager;
import freenet.node.PeerNode;
import freenet.node.PeerNodeStatus;
import freenet.node.Persistable;
import freenet.node.Persister;
import freenet.node.SecurityLevelListener;
import freenet.node.SecurityLevels;
import freenet.node.TimeSkewDetectorCallback;
import freenet.support.HTMLNode;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.StringCounter;
import freenet.support.TimeUtil;
import freenet.support.TokenBucket;
import freenet.support.api.BooleanCallback;
import freenet.support.api.IntCallback;
import freenet.support.math.BootstrappingDecayingRunningAverage;
import freenet.support.math.DecayingKeyspaceAverage;
import freenet.support.math.RunningAverage;
import freenet.support.math.TimeDecayingRunningAverage;
import freenet.support.math.TrivialRunningAverage;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class NodeStats
implements Persistable {
    public static final long SUB_MAX_PING_TIME = 700L;
    public static final long MAX_PING_TIME = 1500L;
    public static final long MAX_THROTTLE_DELAY = 3000L;
    public static final long SUB_MAX_THROTTLE_DELAY = 2000L;
    public static final long MAX_BWLIMIT_DELAY_TIME_ALERT_THRESHOLD = 6000L;
    public static final long MAX_NODE_AVERAGE_PING_TIME_ALERT_THRESHOLD = 3000L;
    public static final long MAX_BWLIMIT_DELAY_TIME_ALERT_DELAY = 600000L;
    public static final long MAX_NODE_AVERAGE_PING_TIME_ALERT_DELAY = 600000L;
    public static final int MAX_INTERREQUEST_TIME = 10000;
    private final int[] incomingRequestsByLoc = new int[10];
    private int incomingRequestsAccounted = 0;
    private final int[] outgoingLocalRequestByLoc = new int[10];
    private int outgoingLocalRequestsAccounted = 0;
    private final int[] outgoingRequestByLoc = new int[10];
    private int outgoingRequestsAccounted = 0;
    private final Node node;
    private MemoryChecker myMemoryChecker;
    public final PeerManager peers;
    final RandomSource hardRandom;
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private long firstBwlimitDelayTimeThresholdBreak;
    private long firstNodeAveragePingTimeThresholdBreak;
    public boolean bwlimitDelayAlertRelevant;
    public boolean nodeAveragePingAlertRelevant;
    public final TimeDecayingRunningAverage pInstantRejectIncoming;
    private boolean ignoreLocalVsRemoteBandwidthLiability;
    final TimeDecayingRunningAverage throttledPacketSendAverage;
    final TimeDecayingRunningAverage remoteChkFetchBytesSentAverage;
    final TimeDecayingRunningAverage remoteSskFetchBytesSentAverage;
    final TimeDecayingRunningAverage remoteChkInsertBytesSentAverage;
    final TimeDecayingRunningAverage remoteSskInsertBytesSentAverage;
    final TimeDecayingRunningAverage remoteChkFetchBytesReceivedAverage;
    final TimeDecayingRunningAverage remoteSskFetchBytesReceivedAverage;
    final TimeDecayingRunningAverage remoteChkInsertBytesReceivedAverage;
    final TimeDecayingRunningAverage remoteSskInsertBytesReceivedAverage;
    final TimeDecayingRunningAverage localChkFetchBytesSentAverage;
    final TimeDecayingRunningAverage localSskFetchBytesSentAverage;
    final TimeDecayingRunningAverage localChkInsertBytesSentAverage;
    final TimeDecayingRunningAverage localSskInsertBytesSentAverage;
    final TimeDecayingRunningAverage localChkFetchBytesReceivedAverage;
    final TimeDecayingRunningAverage localSskFetchBytesReceivedAverage;
    final TimeDecayingRunningAverage localChkInsertBytesReceivedAverage;
    final TimeDecayingRunningAverage localSskInsertBytesReceivedAverage;
    final TimeDecayingRunningAverage successfulChkFetchBytesSentAverage;
    final TimeDecayingRunningAverage successfulSskFetchBytesSentAverage;
    final TimeDecayingRunningAverage successfulChkInsertBytesSentAverage;
    final TimeDecayingRunningAverage successfulSskInsertBytesSentAverage;
    final TimeDecayingRunningAverage successfulChkOfferReplyBytesSentAverage;
    final TimeDecayingRunningAverage successfulSskOfferReplyBytesSentAverage;
    final TimeDecayingRunningAverage successfulChkFetchBytesReceivedAverage;
    final TimeDecayingRunningAverage successfulSskFetchBytesReceivedAverage;
    final TimeDecayingRunningAverage successfulChkInsertBytesReceivedAverage;
    final TimeDecayingRunningAverage successfulSskInsertBytesReceivedAverage;
    final TimeDecayingRunningAverage successfulChkOfferReplyBytesReceivedAverage;
    final TimeDecayingRunningAverage successfulSskOfferReplyBytesReceivedAverage;
    final BootstrappingDecayingRunningAverage globalFetchPSuccess;
    final BootstrappingDecayingRunningAverage chkFetchPSuccess;
    final BootstrappingDecayingRunningAverage sskFetchPSuccess;
    final BootstrappingDecayingRunningAverage localFetchPSuccess;
    final BootstrappingDecayingRunningAverage remoteFetchPSuccess;
    final BootstrappingDecayingRunningAverage blockTransferPSuccess;
    final BootstrappingDecayingRunningAverage blockTransferFailTurtled;
    final BootstrappingDecayingRunningAverage blockTransferFailTimeout;
    final TrivialRunningAverage successfulLocalCHKFetchTimeAverage;
    final TrivialRunningAverage unsuccessfulLocalCHKFetchTimeAverage;
    final TrivialRunningAverage localCHKFetchTimeAverage;
    private long previous_input_stat;
    private long previous_output_stat;
    private long previous_io_stat_time;
    private long last_input_stat;
    private long last_output_stat;
    private long last_io_stat_time;
    private final Object ioStatSync = new Object();
    private long nextNodeIOStatsUpdateTime = -1L;
    private static final long nodeIOStatsUpdateInterval = 2000L;
    final TokenBucket requestOutputThrottle;
    final TokenBucket requestInputThrottle;
    public final RunningAverage routingMissDistance;
    public final RunningAverage backedOffPercent;
    public final DecayingKeyspaceAverage avgCacheLocation;
    public final DecayingKeyspaceAverage avgStoreLocation;
    public final DecayingKeyspaceAverage avgCacheSuccess;
    public final DecayingKeyspaceAverage avgStoreSuccess;
    public double furthestCacheSuccess = 0.0;
    public double furthestStoreSuccess = 0.0;
    protected final Persister persister;
    protected final DecayingKeyspaceAverage avgRequestLocation;
    public final ThreadGroup rootThreadGroup;
    private int[] activeThreadsByPriorities = new int[9];
    private int[] waitingThreadsByPriorities = new int[9];
    private int threadLimit;
    final NodePinger nodePinger;
    final StringCounter preemptiveRejectReasons;
    final StringCounter localPreemptiveRejectReasons;
    private int aggressiveGCModificator = -1;
    private long nextPeerManagerUserAlertStatsUpdateTime = -1L;
    private static final long peerManagerUserAlertStatsUpdateInterval = 1000L;
    static final int CHECK_THROTTLE_TIME = 60000;
    private static final long MAX_PEER_QUEUE_BYTES = 0x400000L;
    private static final double MAX_PEER_QUEUE_TIME = 60000.0;
    private long lastAcceptedRequest = -1L;
    final int estimatedSizeOfOneThrottledPacket;
    final Runnable throttledPacketSendAverageIdleUpdater = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            long now = System.currentTimeMillis();
            try {
                block7: {
                    try {
                        if (NodeStats.this.throttledPacketSendAverage.lastReportTime() >= now - 5000L) break block7;
                        ((NodeStats)NodeStats.this).node.outputThrottle.blockingGrab(NodeStats.this.estimatedSizeOfOneThrottledPacket);
                        ((NodeStats)NodeStats.this).node.outputThrottle.recycle(NodeStats.this.estimatedSizeOfOneThrottledPacket);
                        long after = System.currentTimeMillis();
                        NodeStats.this.throttledPacketSendAverage.report(after - now);
                    }
                    catch (Throwable t) {
                        Logger.error(this, "Caught " + t, t);
                        Object var6_5 = null;
                        NodeStats.this.node.getTicker().queueTimedJob(this, 60000L);
                        long end = System.currentTimeMillis();
                        if (logMINOR) {
                            Logger.minor(this, "Throttle check took " + TimeUtil.formatTime(end - now, 2, true));
                        }
                        NodeStats.access$702(NodeStats.this, ((NodeStats)NodeStats.this).node.executor.runningThreads());
                        NodeStats.access$802(NodeStats.this, ((NodeStats)NodeStats.this).node.executor.waitingThreads());
                        return;
                    }
                }
                Object var6_4 = null;
                NodeStats.this.node.getTicker().queueTimedJob(this, 60000L);
                long end = System.currentTimeMillis();
                if (logMINOR) {
                    Logger.minor(this, "Throttle check took " + TimeUtil.formatTime(end - now, 2, true));
                }
                NodeStats.access$702(NodeStats.this, ((NodeStats)NodeStats.this).node.executor.runningThreads());
                NodeStats.access$802(NodeStats.this, ((NodeStats)NodeStats.this).node.executor.waitingThreads());
                return;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                NodeStats.this.node.getTicker().queueTimedJob(this, 60000L);
                long end = System.currentTimeMillis();
                if (logMINOR) {
                    Logger.minor(this, "Throttle check took " + TimeUtil.formatTime(end - now, 2, true));
                }
                NodeStats.access$702(NodeStats.this, ((NodeStats)NodeStats.this).node.executor.runningThreads());
                NodeStats.access$802(NodeStats.this, ((NodeStats)NodeStats.this).node.executor.waitingThreads());
                throw throwable;
            }
        }
    };
    static final double DEFAULT_OVERHEAD = 0.7;
    static final long DEFAULT_ONLY_PERIOD = 60000L;
    static final long DEFAULT_TRANSITION_PERIOD = 240000L;
    static final double MIN_OVERHEAD = 0.01;
    private final DecimalFormat fix3p3pct = new DecimalFormat("##0.000%");
    private final NumberFormat thousendPoint = NumberFormat.getInstance();
    private long chkRequestSentBytes;
    private long chkRequestRcvdBytes;
    private long sskRequestSentBytes;
    private long sskRequestRcvdBytes;
    private long chkInsertSentBytes;
    private long chkInsertRcvdBytes;
    private long sskInsertSentBytes;
    private long sskInsertRcvdBytes;
    private long offeredKeysSenderRcvdBytes;
    private long offeredKeysSenderSentBytes;
    private long offerKeysRcvdBytes;
    private long offerKeysSentBytes;
    ByteCounter sendOffersCtr = new ByteCounter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receivedBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.offerKeysRcvdBytes += x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sentBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.offerKeysSentBytes += x;
            }
        }

        public void sentPayload(int x) {
        }
    };
    private long swappingRcvdBytes;
    private long swappingSentBytes;
    private long totalAuthBytesSent;
    private long resendBytesSent;
    public final ByteCounter resendByteCounter = new ByteCounter(){

        public void receivedBytes(int x) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sentBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.resendBytesSent += x;
            }
        }

        public void sentPayload(int x) {
            Logger.error(this, "Payload sent in resendByteCounter????", new Exception("error"));
        }
    };
    private long uomBytesSent;
    private long announceBytesSent;
    public final ByteCounter announceByteCounter = new ByteCounter(){

        public void receivedBytes(int x) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sentBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.announceBytesSent += x;
            }
        }

        public void sentPayload(int x) {
        }
    };
    private long routingStatusBytesSent;
    ByteCounter setRoutingStatusCtr = new ByteCounter(){

        public void receivedBytes(int x) {
            Logger.error(this, "Routing status sender received bytes: " + x + " - isn't that impossible?");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sentBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.routingStatusBytesSent += x;
            }
        }

        public void sentPayload(int x) {
        }
    };
    private long networkColoringReceivedBytesCounter;
    private long networkColoringSentBytesCounter;
    private long pingBytesReceived;
    private long pingBytesSent;
    public ByteCounter sskRequestCtr = new ByteCounter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receivedBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.sskRequestRcvdBytes += x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sentBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.sskRequestSentBytes += x;
            }
        }

        public void sentPayload(int x) {
        }
    };
    public ByteCounter chkRequestCtr = new ByteCounter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receivedBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.chkRequestRcvdBytes += x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sentBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.chkRequestSentBytes += x;
            }
        }

        public void sentPayload(int x) {
        }
    };
    public ByteCounter sskInsertCtr = new ByteCounter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receivedBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.sskInsertRcvdBytes += x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sentBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.sskInsertSentBytes += x;
            }
        }

        public void sentPayload(int x) {
        }
    };
    public ByteCounter chkInsertCtr = new ByteCounter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receivedBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.chkInsertRcvdBytes += x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sentBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.chkInsertSentBytes += x;
            }
        }

        public void sentPayload(int x) {
        }
    };
    private long probeRequestSentBytes;
    private long probeRequestRcvdBytes;
    public ByteCounter probeRequestCtr = new ByteCounter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receivedBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.probeRequestRcvdBytes += x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sentBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.probeRequestSentBytes += x;
            }
        }

        public void sentPayload(int x) {
        }
    };
    private long routedMessageBytesRcvd;
    private long routedMessageBytesSent;
    public ByteCounter routedMessageCtr = new ByteCounter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receivedBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.routedMessageBytesRcvd += x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sentBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.routedMessageBytesSent += x;
            }
        }

        public void sentPayload(int x) {
        }
    };
    private long disconnBytesReceived;
    private long disconnBytesSent;
    private long initialMessagesBytesReceived;
    private long initialMessagesBytesSent;
    ByteCounter initialMessagesCtr = new ByteCounter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receivedBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.initialMessagesBytesReceived += x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sentBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.initialMessagesBytesSent += x;
            }
        }

        public void sentPayload(int x) {
        }
    };
    private long changedIPBytesReceived;
    private long changedIPBytesSent;
    ByteCounter changedIPCtr = new ByteCounter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receivedBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.changedIPBytesReceived += x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sentBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.changedIPBytesSent += x;
            }
        }

        public void sentPayload(int x) {
        }
    };
    private long nodeToNodeRcvdBytes;
    private long nodeToNodeSentBytes;
    final ByteCounter nodeToNodeCounter = new ByteCounter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receivedBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.nodeToNodeRcvdBytes += x;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sentBytes(int x) {
            NodeStats nodeStats = NodeStats.this;
            synchronized (nodeStats) {
                NodeStats.this.nodeToNodeSentBytes += x;
            }
        }

        public void sentPayload(int x) {
        }
    };
    private long notificationOnlySentBytes;
    private long turtleTransfersCompleted;
    private long turtleSuccesses;

    NodeStats(Node node, int sortOrder, SubConfig statsConfig, int obwLimit, int ibwLimit, File nodeDir) throws NodeInitException {
        this.node = node;
        this.peers = node.peers;
        this.hardRandom = node.random;
        this.routingMissDistance = new TimeDecayingRunningAverage(0.0, 180000L, 0.0, 1.0, node);
        this.backedOffPercent = new TimeDecayingRunningAverage(0.0, 180000L, 0.0, 1.0, node);
        this.preemptiveRejectReasons = new StringCounter();
        this.localPreemptiveRejectReasons = new StringCounter();
        this.pInstantRejectIncoming = new TimeDecayingRunningAverage(0.0, 60000L, 0.0, 1.0, node);
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while (tg.getParent() != null) {
            tg = tg.getParent();
        }
        this.rootThreadGroup = tg;
        this.activeThreadsByPriorities = new int[9];
        this.waitingThreadsByPriorities = new int[9];
        this.throttledPacketSendAverage = new TimeDecayingRunningAverage(1.0, 600000L, 0.0, 9.223372036854776E18, node);
        this.nodePinger = new NodePinger(node);
        this.previous_input_stat = 0L;
        this.previous_output_stat = 0L;
        this.previous_io_stat_time = 1L;
        this.last_input_stat = 0L;
        this.last_output_stat = 0L;
        this.last_io_stat_time = 3L;
        statsConfig.register("threadLimit", 500, sortOrder++, true, true, "NodeStat.threadLimit", "NodeStat.threadLimitLong", new IntCallback(){

            public Integer get() {
                return NodeStats.this.threadLimit;
            }

            public void set(Integer val) throws InvalidConfigValueException {
                if (this.get().equals(val)) {
                    return;
                }
                if (val < 100) {
                    throw new InvalidConfigValueException(NodeStats.this.l10n("valueTooLow"));
                }
                NodeStats.this.threadLimit = val;
            }
        }, false);
        this.threadLimit = statsConfig.getInt("threadLimit");
        statsConfig.register("aggressiveGC", this.aggressiveGCModificator, sortOrder++, true, false, "NodeStat.aggressiveGC", "NodeStat.aggressiveGCLong", new IntCallback(){

            public Integer get() {
                return NodeStats.this.aggressiveGCModificator;
            }

            public void set(Integer val) throws InvalidConfigValueException {
                if (this.get().equals(val)) {
                    return;
                }
                Logger.normal(this, "Changing aggressiveGCModificator to " + val);
                NodeStats.this.aggressiveGCModificator = val;
            }
        }, false);
        this.aggressiveGCModificator = statsConfig.getInt("aggressiveGC");
        this.myMemoryChecker = new MemoryChecker(node.ps, this.aggressiveGCModificator);
        statsConfig.register("memoryChecker", true, sortOrder++, true, false, "NodeStat.memCheck", "NodeStat.memCheckLong", new BooleanCallback(){

            public Boolean get() {
                return NodeStats.this.myMemoryChecker.isRunning();
            }

            public void set(Boolean val) throws InvalidConfigValueException {
                if (this.get().equals(val)) {
                    return;
                }
                if (val.booleanValue()) {
                    NodeStats.this.myMemoryChecker.start();
                } else {
                    NodeStats.this.myMemoryChecker.terminate();
                }
            }
        });
        if (statsConfig.getBoolean("memoryChecker")) {
            this.myMemoryChecker.start();
        }
        statsConfig.register("ignoreLocalVsRemoteBandwidthLiability", false, sortOrder++, true, false, "NodeStat.ignoreLocalVsRemoteBandwidthLiability", "NodeStat.ignoreLocalVsRemoteBandwidthLiabilityLong", new BooleanCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean get() {
                NodeStats nodeStats = NodeStats.this;
                synchronized (nodeStats) {
                    return NodeStats.this.ignoreLocalVsRemoteBandwidthLiability;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void set(Boolean val) throws InvalidConfigValueException {
                NodeStats nodeStats = NodeStats.this;
                synchronized (nodeStats) {
                    NodeStats.this.ignoreLocalVsRemoteBandwidthLiability = val;
                }
            }
        });
        node.securityLevels.addNetworkThreatLevelListener(new SecurityLevelListener<SecurityLevels.NETWORK_THREAT_LEVEL>(){

            @Override
            public void onChange(SecurityLevels.NETWORK_THREAT_LEVEL oldLevel, SecurityLevels.NETWORK_THREAT_LEVEL newLevel) {
                if (newLevel == SecurityLevels.NETWORK_THREAT_LEVEL.MAXIMUM) {
                    NodeStats.this.ignoreLocalVsRemoteBandwidthLiability = true;
                }
                if (oldLevel == SecurityLevels.NETWORK_THREAT_LEVEL.MAXIMUM) {
                    NodeStats.this.ignoreLocalVsRemoteBandwidthLiability = false;
                }
            }
        });
        this.persister = new ConfigurablePersister(this, statsConfig, "nodeThrottleFile", "node-throttle.dat", sortOrder++, true, false, "NodeStat.statsPersister", "NodeStat.statsPersisterLong", node.ps, nodeDir);
        SimpleFieldSet throttleFS = this.persister.read();
        if (logMINOR) {
            Logger.minor(this, "Read throttleFS:\n" + throttleFS);
        }
        this.localChkFetchBytesSentAverage = new TimeDecayingRunningAverage(500.0, 180000L, 0.0, 1.073741824E9, throttleFS == null ? null : throttleFS.subset("LocalChkFetchBytesSentAverage"), (TimeSkewDetectorCallback)node);
        this.localSskFetchBytesSentAverage = new TimeDecayingRunningAverage(500.0, 180000L, 0.0, 1.073741824E9, throttleFS == null ? null : throttleFS.subset("LocalSskFetchBytesSentAverage"), (TimeSkewDetectorCallback)node);
        this.localChkInsertBytesSentAverage = new TimeDecayingRunningAverage(32768.0, 180000L, 0.0, 1.073741824E9, throttleFS == null ? null : throttleFS.subset("LocalChkInsertBytesSentAverage"), (TimeSkewDetectorCallback)node);
        this.localSskInsertBytesSentAverage = new TimeDecayingRunningAverage(2048.0, 180000L, 0.0, 1.073741824E9, throttleFS == null ? null : throttleFS.subset("LocalSskInsertBytesSentAverage"), (TimeSkewDetectorCallback)node);
        this.localChkFetchBytesReceivedAverage = new TimeDecayingRunningAverage(34816.0, 180000L, 0.0, 1.073741824E9, throttleFS == null ? null : throttleFS.subset("LocalChkFetchBytesReceivedAverage"), (TimeSkewDetectorCallback)node);
        this.localSskFetchBytesReceivedAverage = new TimeDecayingRunningAverage(2048.0, 180000L, 0.0, 1.073741824E9, throttleFS == null ? null : throttleFS.subset("LocalSskFetchBytesReceivedAverage"), (TimeSkewDetectorCallback)node);
        this.localChkInsertBytesReceivedAverage = new TimeDecayingRunningAverage(1024.0, 180000L, 0.0, 1.073741824E9, throttleFS == null ? null : throttleFS.subset("LocalChkInsertBytesReceivedAverage"), (TimeSkewDetectorCallback)node);
        this.localSskInsertBytesReceivedAverage = new TimeDecayingRunningAverage(500.0, 180000L, 0.0, 1.073741824E9, throttleFS == null ? null : throttleFS.subset("LocalChkInsertBytesReceivedAverage"), (TimeSkewDetectorCallback)node);
        this.remoteChkFetchBytesSentAverage = new TimeDecayingRunningAverage(36340.0, 180000L, 0.0, 1.073741824E9, throttleFS == null ? null : throttleFS.subset("RemoteChkFetchBytesSentAverage"), (TimeSkewDetectorCallback)node);
        this.remoteSskFetchBytesSentAverage = new TimeDecayingRunningAverage(2548.0, 180000L, 0.0, 1.073741824E9, throttleFS == null ? null : throttleFS.subset("RemoteSskFetchBytesSentAverage"), (TimeSkewDetectorCallback)node);
        this.remoteChkInsertBytesSentAverage = new TimeDecayingRunningAverage(66560.0, 180000L, 0.0, 1.073741824E9, throttleFS == null ? null : throttleFS.subset("RemoteChkInsertBytesSentAverage"), (TimeSkewDetectorCallback)node);
        this.remoteSskInsertBytesSentAverage = new TimeDecayingRunningAverage(2548.0, 180000L, 0.0, 1.073741824E9, throttleFS == null ? null : throttleFS.subset("RemoteSskInsertBytesSentAverage"), (TimeSkewDetectorCallback)node);
        this.remoteChkFetchBytesReceivedAverage = new TimeDecayingRunningAverage(36340.0, 180000L, 0.0, 1.073741824E9, throttleFS == null ? null : throttleFS.subset("RemoteChkFetchBytesReceivedAverage"), (TimeSkewDetectorCallback)node);
        this.remoteSskFetchBytesReceivedAverage = new TimeDecayingRunningAverage(2548.0, 180000L, 0.0, 1.073741824E9, throttleFS == null ? null : throttleFS.subset("RemoteSskFetchBytesReceivedAverage"), (TimeSkewDetectorCallback)node);
        this.remoteChkInsertBytesReceivedAverage = new TimeDecayingRunningAverage(34292.0, 180000L, 0.0, 1.073741824E9, throttleFS == null ? null : throttleFS.subset("RemoteChkInsertBytesReceivedAverage"), (TimeSkewDetectorCallback)node);
        this.remoteSskInsertBytesReceivedAverage = new TimeDecayingRunningAverage(2548.0, 180000L, 0.0, 1.073741824E9, throttleFS == null ? null : throttleFS.subset("RemoteSskInsertBytesReceivedAverage"), (TimeSkewDetectorCallback)node);
        this.successfulChkFetchBytesSentAverage = new TimeDecayingRunningAverage(36340.0, 180000L, 0.0, 1.073741824E9, throttleFS == null ? null : throttleFS.subset("SuccessfulChkFetchBytesSentAverage"), (TimeSkewDetectorCallback)node);
        this.successfulSskFetchBytesSentAverage = new TimeDecayingRunningAverage(2548.0, 180000L, 0.0, 1.073741824E9, throttleFS == null ? null : throttleFS.subset("SuccessfulSskFetchBytesSentAverage"), (TimeSkewDetectorCallback)node);
        this.successfulChkInsertBytesSentAverage = new TimeDecayingRunningAverage(66560.0, 180000L, 0.0, 1.073741824E9, throttleFS == null ? null : throttleFS.subset("SuccessfulChkInsertBytesSentAverage"), (TimeSkewDetectorCallback)node);
        this.successfulSskInsertBytesSentAverage = new TimeDecayingRunningAverage(2548.0, 180000L, 0.0, 1.073741824E9, throttleFS == null ? null : throttleFS.subset("SuccessfulSskInsertBytesSentAverage"), (TimeSkewDetectorCallback)node);
        this.successfulChkOfferReplyBytesSentAverage = new TimeDecayingRunningAverage(33268.0, 180000L, 0.0, 1.073741824E9, throttleFS == null ? null : throttleFS.subset("successfulChkOfferReplyBytesSentAverage"), (TimeSkewDetectorCallback)node);
        this.successfulSskOfferReplyBytesSentAverage = new TimeDecayingRunningAverage(3072.0, 180000L, 0.0, 1.073741824E9, throttleFS == null ? null : throttleFS.subset("successfulSskOfferReplyBytesSentAverage"), (TimeSkewDetectorCallback)node);
        this.successfulChkFetchBytesReceivedAverage = new TimeDecayingRunningAverage(36340.0, 180000L, 0.0, 1.073741824E9, throttleFS == null ? null : throttleFS.subset("SuccessfulChkFetchBytesReceivedAverage"), (TimeSkewDetectorCallback)node);
        this.successfulSskFetchBytesReceivedAverage = new TimeDecayingRunningAverage(2548.0, 180000L, 0.0, 1.073741824E9, throttleFS == null ? null : throttleFS.subset("SuccessfulSskFetchBytesReceivedAverage"), (TimeSkewDetectorCallback)node);
        this.successfulChkInsertBytesReceivedAverage = new TimeDecayingRunningAverage(34292.0, 180000L, 0.0, 1.073741824E9, throttleFS == null ? null : throttleFS.subset("SuccessfulChkInsertBytesReceivedAverage"), (TimeSkewDetectorCallback)node);
        this.successfulSskInsertBytesReceivedAverage = new TimeDecayingRunningAverage(2548.0, 180000L, 0.0, 1.073741824E9, throttleFS == null ? null : throttleFS.subset("SuccessfulSskInsertBytesReceivedAverage"), (TimeSkewDetectorCallback)node);
        this.successfulChkOfferReplyBytesReceivedAverage = new TimeDecayingRunningAverage(33268.0, 180000L, 0.0, 1.073741824E9, throttleFS == null ? null : throttleFS.subset("successfulChkOfferReplyBytesReceivedAverage"), (TimeSkewDetectorCallback)node);
        this.successfulSskOfferReplyBytesReceivedAverage = new TimeDecayingRunningAverage(3072.0, 180000L, 0.0, 1.073741824E9, throttleFS == null ? null : throttleFS.subset("successfulSskOfferReplyBytesReceivedAverage"), (TimeSkewDetectorCallback)node);
        this.globalFetchPSuccess = new BootstrappingDecayingRunningAverage(0.0, 0.0, 1.0, 262144, null);
        this.chkFetchPSuccess = new BootstrappingDecayingRunningAverage(0.0, 0.0, 1.0, 262144, null);
        this.sskFetchPSuccess = new BootstrappingDecayingRunningAverage(0.0, 0.0, 1.0, 262144, null);
        this.localFetchPSuccess = new BootstrappingDecayingRunningAverage(0.0, 0.0, 1.0, 262144, null);
        this.remoteFetchPSuccess = new BootstrappingDecayingRunningAverage(0.0, 0.0, 1.0, 262144, null);
        this.blockTransferPSuccess = new BootstrappingDecayingRunningAverage(0.0, 0.0, 1.0, 262144, null);
        this.blockTransferFailTurtled = new BootstrappingDecayingRunningAverage(0.0, 0.0, 1.0, 262144, null);
        this.blockTransferFailTimeout = new BootstrappingDecayingRunningAverage(0.0, 0.0, 1.0, 262144, null);
        this.successfulLocalCHKFetchTimeAverage = new TrivialRunningAverage();
        this.unsuccessfulLocalCHKFetchTimeAverage = new TrivialRunningAverage();
        this.localCHKFetchTimeAverage = new TrivialRunningAverage();
        this.requestOutputThrottle = new TokenBucket(Math.max(obwLimit * 60, 655360), (int)(1000000000L / (long)obwLimit), 0L);
        this.requestInputThrottle = new TokenBucket(Math.max(ibwLimit * 60, 655360), (int)(1000000000L / (long)ibwLimit), 0L);
        this.estimatedSizeOfOneThrottledPacket = 1024 + DMT.packetTransmitSize(1024, 32) + node.estimateFullHeadersLengthOneMessage();
        double nodeLoc = node.lm.getLocation();
        this.avgCacheLocation = new DecayingKeyspaceAverage(nodeLoc, (int)node.maxCacheKeys, throttleFS == null ? null : throttleFS.subset("AverageCacheLocation"));
        this.avgStoreLocation = new DecayingKeyspaceAverage(nodeLoc, (int)node.maxStoreKeys, throttleFS == null ? null : throttleFS.subset("AverageStoreLocation"));
        this.avgCacheSuccess = new DecayingKeyspaceAverage(nodeLoc, 10000, throttleFS == null ? null : throttleFS.subset("AverageCacheSuccessLocation"));
        this.avgStoreSuccess = new DecayingKeyspaceAverage(nodeLoc, 10000, throttleFS == null ? null : throttleFS.subset("AverageStoreSuccessLocation"));
        this.avgRequestLocation = new DecayingKeyspaceAverage(nodeLoc, 10000, throttleFS == null ? null : throttleFS.subset("AverageRequestLocation"));
    }

    protected String l10n(String key) {
        return L10n.getString("NodeStats." + key);
    }

    public void start() throws NodeInitException {
        this.node.executor.execute(new Runnable(){

            public void run() {
                NodeStats.this.nodePinger.start();
            }
        }, "Starting NodePinger");
        this.persister.start();
        this.node.getTicker().queueTimedJob(this.throttledPacketSendAverageIdleUpdater, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String shouldRejectRequest(boolean canAcceptAnyway, boolean isInsert, boolean isSSK, boolean isLocal, boolean isOfferReply, PeerNode source) {
        long now;
        double overheadFraction;
        double sentOverheadPerSecond;
        block53: {
            double bwlimitDelayTime;
            block49: {
                block47: {
                    long time;
                    block48: {
                        int threadCount;
                        if (logMINOR) {
                            this.dumpByteCostAverages();
                        }
                        if (this.threadLimit < (threadCount = this.getActiveThreadCount())) {
                            this.pInstantRejectIncoming.report(1.0);
                            this.rejected(">threadLimit", isLocal);
                            return ">threadLimit (" + threadCount + '/' + this.threadLimit + ')';
                        }
                        bwlimitDelayTime = this.throttledPacketSendAverage.currentValue();
                        long[] total = this.node.collector.getTotalIO();
                        long totalSent = total[0];
                        long totalOverhead = this.getSentOverhead();
                        long uptime = this.node.getUptime();
                        sentOverheadPerSecond = (double)totalOverhead * 1000.0 / (double)uptime;
                        overheadFraction = (double)(totalSent - totalOverhead) / (double)totalSent;
                        long timeFirstAnyConnections = this.peers.timeFirstAnyConnections;
                        now = System.currentTimeMillis();
                        if (logMINOR) {
                            Logger.minor(this, "Output rate: " + (double)totalSent * 1000.0 / (double)uptime + " overhead rate " + sentOverheadPerSecond + " non-overhead fraction " + overheadFraction);
                        }
                        if (timeFirstAnyConnections <= 0L) break block47;
                        time = now - timeFirstAnyConnections;
                        if (time >= 60000L) break block48;
                        overheadFraction = 0.7;
                        if (logMINOR) {
                            Logger.minor(this, "Adjusted overhead fraction: " + overheadFraction);
                        }
                        break block49;
                    }
                    if (time < 300000L) {
                        overheadFraction = ((double)(time -= 60000L) * overheadFraction + (double)(240000L - time) * 0.7) / 240000.0;
                        if (logMINOR) {
                            Logger.minor(this, "Adjusted overhead fraction: " + overheadFraction);
                        }
                    }
                    break block49;
                }
                if (overheadFraction < 0.01) {
                    Logger.error(this, "Overhead fraction is " + overheadFraction + " - assuming this is self-inflicted and using default");
                    overheadFraction = 0.7;
                }
            }
            double pingTime = this.nodePinger.averagePingTime();
            NodeStats nodeStats = this;
            synchronized (nodeStats) {
                double x;
                block52: {
                    block51: {
                        block50: {
                            if (!(pingTime > 1500.0)) break block50;
                            if (now - this.lastAcceptedRequest > 10000L && canAcceptAnyway) {
                                if (logMINOR) {
                                    Logger.minor(this, "Accepting request anyway (take one every 10 secs to keep bwlimitDelayTime updated)");
                                }
                                break block51;
                            } else {
                                this.pInstantRejectIncoming.report(1.0);
                                this.rejected(">MAX_PING_TIME", isLocal);
                                return ">MAX_PING_TIME (" + TimeUtil.formatTime((long)pingTime, 2, true) + ')';
                            }
                        }
                        if (pingTime > 700.0) {
                            x = (pingTime - 700.0) / 800.0;
                            if (this.hardRandom.nextDouble() < x) {
                                this.pInstantRejectIncoming.report(1.0);
                                this.rejected(">SUB_MAX_PING_TIME", isLocal);
                                return ">SUB_MAX_PING_TIME (" + TimeUtil.formatTime((long)pingTime, 2, true) + ')';
                            }
                        }
                    }
                    if (!(bwlimitDelayTime > 3000.0)) break block52;
                    if (now - this.lastAcceptedRequest > 10000L && canAcceptAnyway) {
                        if (logMINOR) {
                            Logger.minor(this, "Accepting request anyway (take one every 10 secs to keep bwlimitDelayTime updated)");
                        }
                        break block53;
                    } else {
                        this.pInstantRejectIncoming.report(1.0);
                        this.rejected(">MAX_THROTTLE_DELAY", isLocal);
                        return ">MAX_THROTTLE_DELAY (" + TimeUtil.formatTime((long)bwlimitDelayTime, 2, true) + ')';
                    }
                }
                if (bwlimitDelayTime > 2000.0) {
                    x = (bwlimitDelayTime - 2000.0) / 1000.0;
                    if (this.hardRandom.nextDouble() < x) {
                        this.pInstantRejectIncoming.report(1.0);
                        this.rejected(">SUB_MAX_THROTTLE_DELAY", isLocal);
                        return ">SUB_MAX_THROTTLE_DELAY (" + TimeUtil.formatTime((long)bwlimitDelayTime, 2, true) + ')';
                    }
                }
            }
        }
        int numLocalCHKRequests = this.node.getNumLocalCHKRequests() + 1;
        int numLocalSSKRequests = this.node.getNumLocalSSKRequests() + 1;
        int numLocalCHKInserts = this.node.getNumLocalCHKInserts() + 1;
        int numLocalSSKInserts = this.node.getNumLocalSSKInserts() + 1;
        int numRemoteCHKRequests = this.node.getNumRemoteCHKRequests() + 1;
        int numRemoteSSKRequests = this.node.getNumRemoteSSKRequests() + 1;
        int numRemoteCHKInserts = this.node.getNumRemoteCHKInserts() + 1;
        int numRemoteSSKInserts = this.node.getNumRemoteSSKInserts() + 1;
        int numCHKOfferReplies = this.node.getNumCHKOfferReplies() + 1;
        int numSSKOfferReplies = this.node.getNumSSKOfferReplies() + 1;
        if (!isLocal) {
            if (isOfferReply) {
                if (isSSK) {
                    --numSSKOfferReplies;
                } else {
                    --numCHKOfferReplies;
                }
            } else if (isInsert) {
                if (isSSK) {
                    --numRemoteSSKInserts;
                } else {
                    --numRemoteCHKInserts;
                }
            } else if (isSSK) {
                --numRemoteSSKRequests;
            } else {
                --numRemoteCHKRequests;
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Running (adjusted): CHK fetch local " + numLocalCHKRequests + " remote " + numRemoteCHKRequests + " SSK fetch local " + numLocalSSKRequests + " remote " + numRemoteSSKRequests + " CHK insert local " + numLocalCHKInserts + " remote " + numRemoteCHKInserts + " SSK insert local " + numLocalSSKInserts + " remote " + numRemoteSSKInserts + " CHK offer replies local " + numCHKOfferReplies + " SSK offer replies " + numSSKOfferReplies);
        }
        double bandwidthLiabilityOutput = this.ignoreLocalVsRemoteBandwidthLiability ? this.successfulChkFetchBytesSentAverage.currentValue() * (double)(numRemoteCHKRequests + numLocalCHKRequests - 1) + this.successfulSskFetchBytesSentAverage.currentValue() * (double)(numRemoteSSKRequests + numLocalSSKRequests - 1) + this.successfulChkInsertBytesSentAverage.currentValue() * (double)(numRemoteCHKInserts + numLocalCHKInserts - 1) + this.successfulSskInsertBytesSentAverage.currentValue() * (double)(numRemoteSSKInserts + numLocalSSKInserts - 1) : this.successfulChkFetchBytesSentAverage.currentValue() * (double)numRemoteCHKRequests + this.localChkFetchBytesSentAverage.currentValue() * (double)numLocalCHKRequests + this.successfulSskFetchBytesSentAverage.currentValue() * (double)numRemoteSSKRequests + this.localSskFetchBytesSentAverage.currentValue() * (double)numLocalSSKRequests + this.successfulChkInsertBytesSentAverage.currentValue() * (double)numRemoteCHKInserts + this.successfulChkInsertBytesSentAverage.currentValue() * (double)numLocalCHKInserts + this.successfulSskInsertBytesSentAverage.currentValue() * (double)numRemoteSSKInserts + this.successfulSskInsertBytesSentAverage.currentValue() * (double)numLocalSSKInserts + this.successfulChkOfferReplyBytesSentAverage.currentValue() * (double)numCHKOfferReplies + this.successfulSskOfferReplyBytesSentAverage.currentValue() * (double)numSSKOfferReplies;
        double outputAvailablePerSecond = (double)this.node.getOutputBandwidthLimit() - sentOverheadPerSecond;
        if (logMINOR) {
            Logger.minor(this, "Overhead per second: " + sentOverheadPerSecond + " bwlimit: " + this.node.getOutputBandwidthLimit() + " => output available per second: " + outputAvailablePerSecond + " but minimum of " + (double)this.node.getOutputBandwidthLimit() / 5.0);
        }
        outputAvailablePerSecond = Math.max(outputAvailablePerSecond, (double)this.node.getOutputBandwidthLimit() / 5.0);
        double bandwidthAvailableOutput = outputAvailablePerSecond * 90.0;
        if (logMINOR) {
            Logger.minor(this, "90 second limit: " + bandwidthAvailableOutput + " expected output liability: " + bandwidthLiabilityOutput);
        }
        if (bandwidthLiabilityOutput > bandwidthAvailableOutput) {
            this.pInstantRejectIncoming.report(1.0);
            this.rejected("Output bandwidth liability", isLocal);
            return "Output bandwidth liability (" + bandwidthLiabilityOutput + " > " + bandwidthAvailableOutput + ")";
        }
        double bandwidthLiabilityInput = this.ignoreLocalVsRemoteBandwidthLiability ? this.successfulChkFetchBytesReceivedAverage.currentValue() * (double)(numRemoteCHKRequests + numLocalCHKRequests - 1) + this.successfulSskFetchBytesReceivedAverage.currentValue() * (double)(numRemoteSSKRequests + numLocalSSKRequests - 1) + this.successfulChkInsertBytesReceivedAverage.currentValue() * (double)(numRemoteCHKInserts + numLocalCHKInserts - 1) + this.successfulSskInsertBytesReceivedAverage.currentValue() * (double)(numRemoteSSKInserts + numLocalSSKInserts - 1) : this.successfulChkFetchBytesReceivedAverage.currentValue() * (double)numRemoteCHKRequests + this.successfulChkFetchBytesReceivedAverage.currentValue() * (double)numLocalCHKRequests + this.successfulSskFetchBytesReceivedAverage.currentValue() * (double)numRemoteSSKRequests + this.successfulSskFetchBytesReceivedAverage.currentValue() * (double)numLocalSSKRequests + this.successfulChkInsertBytesReceivedAverage.currentValue() * (double)numRemoteCHKInserts + this.localChkInsertBytesReceivedAverage.currentValue() * (double)numLocalCHKInserts + this.successfulSskInsertBytesReceivedAverage.currentValue() * (double)numRemoteSSKInserts + this.localSskInsertBytesReceivedAverage.currentValue() * (double)numLocalSSKInserts + this.successfulChkOfferReplyBytesReceivedAverage.currentValue() * (double)numCHKOfferReplies + this.successfulSskOfferReplyBytesReceivedAverage.currentValue() * (double)numSSKOfferReplies;
        double bandwidthAvailableInput = (long)this.node.getInputBandwidthLimit() * 90L;
        if (bandwidthAvailableInput < 0.0) {
            Logger.error(this, "Negative available bandwidth: " + bandwidthAvailableInput + " node.ibwlimit=" + this.node.getInputBandwidthLimit() + " node.obwlimit=" + this.node.getOutputBandwidthLimit() + " node.inputLimitDefault=" + this.node.inputLimitDefault);
        }
        if (bandwidthLiabilityInput > bandwidthAvailableInput) {
            this.pInstantRejectIncoming.report(1.0);
            this.rejected("Input bandwidth liability", isLocal);
            return "Input bandwidth liability (" + bandwidthLiabilityInput + " > " + bandwidthAvailableInput + ")";
        }
        double expected = this.getThrottle(isLocal, isInsert, isSSK, true).currentValue();
        int expectedSent = (int)Math.max(expected / overheadFraction, 0.0);
        if (logMINOR) {
            Logger.minor(this, "Expected sent bytes: " + expected + " -> " + expectedSent);
        }
        if (!this.requestOutputThrottle.instantGrab(expectedSent)) {
            this.pInstantRejectIncoming.report(1.0);
            this.rejected("Insufficient output bandwidth", isLocal);
            return "Insufficient output bandwidth";
        }
        expected = this.getThrottle(isLocal, isInsert, isSSK, false).currentValue();
        int expectedReceived = (int)Math.max(expected, 0.0);
        if (logMINOR) {
            Logger.minor(this, "Expected received bytes: " + expectedReceived);
        }
        if (!this.requestInputThrottle.instantGrab(expectedReceived)) {
            this.requestOutputThrottle.recycle(expectedSent);
            this.pInstantRejectIncoming.report(1.0);
            this.rejected("Insufficient input bandwidth", isLocal);
            return "Insufficient input bandwidth";
        }
        if (source != null) {
            if (source.getMessageQueueLengthBytes() > 0x400000L) {
                this.rejected(">MAX_PEER_QUEUE_BYTES", isLocal);
                return "Too many message bytes queued for peer";
            }
            if ((double)source.getProbableSendQueueTime() > 60000.0) {
                this.rejected(">MAX_PEER_QUEUE_TIME", isLocal);
                return "Peer's queue will take too long to transfer";
            }
        }
        NodeStats nodeStats = this;
        synchronized (nodeStats) {
            if (logMINOR) {
                Logger.minor(this, "Accepting request? (isSSK=" + isSSK + ")");
            }
            this.lastAcceptedRequest = now;
        }
        this.pInstantRejectIncoming.report(0.0);
        return null;
    }

    private void rejected(String reason, boolean isLocal) {
        if (!isLocal) {
            this.preemptiveRejectReasons.inc(reason);
        } else {
            this.localPreemptiveRejectReasons.inc(reason);
        }
    }

    private RunningAverage getThrottle(boolean isLocal, boolean isInsert, boolean isSSK, boolean isSent) {
        if (isLocal) {
            if (isInsert) {
                if (isSSK) {
                    return isSent ? this.localSskInsertBytesSentAverage : this.localSskInsertBytesReceivedAverage;
                }
                return isSent ? this.localChkInsertBytesSentAverage : this.localChkInsertBytesReceivedAverage;
            }
            if (isSSK) {
                return isSent ? this.localSskFetchBytesSentAverage : this.localSskFetchBytesReceivedAverage;
            }
            return isSent ? this.localChkFetchBytesSentAverage : this.localChkFetchBytesReceivedAverage;
        }
        if (isInsert) {
            if (isSSK) {
                return isSent ? this.remoteSskInsertBytesSentAverage : this.remoteSskInsertBytesReceivedAverage;
            }
            return isSent ? this.remoteChkInsertBytesSentAverage : this.remoteChkInsertBytesReceivedAverage;
        }
        if (isSSK) {
            return isSent ? this.remoteSskFetchBytesSentAverage : this.remoteSskFetchBytesReceivedAverage;
        }
        return isSent ? this.remoteChkFetchBytesSentAverage : this.remoteChkFetchBytesReceivedAverage;
    }

    private void dumpByteCostAverages() {
        Logger.minor(this, "Byte cost averages: REMOTE: CHK insert " + this.remoteChkInsertBytesSentAverage.currentValue() + '/' + this.remoteChkInsertBytesReceivedAverage.currentValue() + " SSK insert " + this.remoteSskInsertBytesSentAverage.currentValue() + '/' + this.remoteSskInsertBytesReceivedAverage.currentValue() + " CHK fetch " + this.remoteChkFetchBytesSentAverage.currentValue() + '/' + this.remoteChkFetchBytesReceivedAverage.currentValue() + " SSK fetch " + this.remoteSskFetchBytesSentAverage.currentValue() + '/' + this.remoteSskFetchBytesReceivedAverage.currentValue());
        Logger.minor(this, "Byte cost averages: LOCAL: CHK insert " + this.localChkInsertBytesSentAverage.currentValue() + '/' + this.localChkInsertBytesReceivedAverage.currentValue() + " SSK insert " + this.localSskInsertBytesSentAverage.currentValue() + '/' + this.localSskInsertBytesReceivedAverage.currentValue() + " CHK fetch " + this.localChkFetchBytesSentAverage.currentValue() + '/' + this.localChkFetchBytesReceivedAverage.currentValue() + " SSK fetch " + this.localSskFetchBytesSentAverage.currentValue() + '/' + this.localSskFetchBytesReceivedAverage.currentValue());
        Logger.minor(this, "Byte cost averages: SUCCESSFUL: CHK insert " + this.successfulChkInsertBytesSentAverage.currentValue() + '/' + this.successfulChkInsertBytesReceivedAverage.currentValue() + " SSK insert " + this.successfulSskInsertBytesSentAverage.currentValue() + '/' + this.successfulSskInsertBytesReceivedAverage.currentValue() + " CHK fetch " + this.successfulChkFetchBytesSentAverage.currentValue() + '/' + this.successfulChkFetchBytesReceivedAverage.currentValue() + " SSK fetch " + this.successfulSskFetchBytesSentAverage.currentValue() + '/' + this.successfulSskFetchBytesReceivedAverage.currentValue() + " CHK offer reply " + this.successfulChkOfferReplyBytesSentAverage.currentValue() + '/' + this.successfulChkOfferReplyBytesReceivedAverage.currentValue() + " SSK offer reply " + this.successfulSskOfferReplyBytesSentAverage.currentValue() + '/' + this.successfulSskOfferReplyBytesReceivedAverage.currentValue());
    }

    public double getBwlimitDelayTime() {
        return this.throttledPacketSendAverage.currentValue();
    }

    public double getNodeAveragePingTime() {
        return this.nodePinger.averagePingTime();
    }

    public int getOpennetSizeEstimate(long timestamp) {
        if (this.node.opennet == null) {
            return 0;
        }
        return this.node.opennet.getNetworkSizeEstimate(timestamp);
    }

    public int getDarknetSizeEstimate(long timestamp) {
        return this.node.lm.getNetworkSizeEstimate(timestamp);
    }

    public Object[] getKnownLocations(long timestamp) {
        return this.node.lm.getKnownLocations(timestamp);
    }

    public double pRejectIncomingInstantly() {
        return this.pInstantRejectIncoming.currentValue();
    }

    public void maybeUpdatePeerManagerUserAlertStats(long now) {
        if (now > this.nextPeerManagerUserAlertStatsUpdateTime) {
            if (this.getBwlimitDelayTime() > 6000.0) {
                if (this.firstBwlimitDelayTimeThresholdBreak == 0L) {
                    this.firstBwlimitDelayTimeThresholdBreak = now;
                }
            } else {
                this.firstBwlimitDelayTimeThresholdBreak = 0L;
            }
            this.bwlimitDelayAlertRelevant = this.firstBwlimitDelayTimeThresholdBreak != 0L && now - this.firstBwlimitDelayTimeThresholdBreak >= 600000L;
            if (this.getNodeAveragePingTime() > 3000.0) {
                if (this.firstNodeAveragePingTimeThresholdBreak == 0L) {
                    this.firstNodeAveragePingTimeThresholdBreak = now;
                }
            } else {
                this.firstNodeAveragePingTimeThresholdBreak = 0L;
            }
            this.nodeAveragePingAlertRelevant = this.firstNodeAveragePingTimeThresholdBreak != 0L && now - this.firstNodeAveragePingTimeThresholdBreak >= 600000L;
            if (logDEBUG) {
                Logger.debug(this, "mUPMUAS: " + now + ": " + this.getBwlimitDelayTime() + " >? " + 6000L + " since " + this.firstBwlimitDelayTimeThresholdBreak + " (" + this.bwlimitDelayAlertRelevant + ") " + this.getNodeAveragePingTime() + " >? " + 3000L + " since " + this.firstNodeAveragePingTimeThresholdBreak + " (" + this.nodeAveragePingAlertRelevant + ')');
            }
            this.nextPeerManagerUserAlertStatsUpdateTime = now + 1000L;
        }
    }

    public SimpleFieldSet persistThrottlesToFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.put("RemoteChkFetchBytesSentAverage", this.remoteChkFetchBytesSentAverage.exportFieldSet(true));
        fs.put("RemoteSskFetchBytesSentAverage", this.remoteSskFetchBytesSentAverage.exportFieldSet(true));
        fs.put("RemoteChkInsertBytesSentAverage", this.remoteChkInsertBytesSentAverage.exportFieldSet(true));
        fs.put("RemoteSskInsertBytesSentAverage", this.remoteSskInsertBytesSentAverage.exportFieldSet(true));
        fs.put("RemoteChkFetchBytesReceivedAverage", this.remoteChkFetchBytesReceivedAverage.exportFieldSet(true));
        fs.put("RemoteSskFetchBytesReceivedAverage", this.remoteSskFetchBytesReceivedAverage.exportFieldSet(true));
        fs.put("RemoteChkInsertBytesReceivedAverage", this.remoteChkInsertBytesReceivedAverage.exportFieldSet(true));
        fs.put("RemoteSskInsertBytesReceivedAverage", this.remoteSskInsertBytesReceivedAverage.exportFieldSet(true));
        fs.put("LocalChkFetchBytesSentAverage", this.localChkFetchBytesSentAverage.exportFieldSet(true));
        fs.put("LocalSskFetchBytesSentAverage", this.localSskFetchBytesSentAverage.exportFieldSet(true));
        fs.put("LocalChkInsertBytesSentAverage", this.localChkInsertBytesSentAverage.exportFieldSet(true));
        fs.put("LocalSskInsertBytesSentAverage", this.localSskInsertBytesSentAverage.exportFieldSet(true));
        fs.put("LocalChkFetchBytesReceivedAverage", this.localChkFetchBytesReceivedAverage.exportFieldSet(true));
        fs.put("LocalSskFetchBytesReceivedAverage", this.localSskFetchBytesReceivedAverage.exportFieldSet(true));
        fs.put("LocalChkInsertBytesReceivedAverage", this.localChkInsertBytesReceivedAverage.exportFieldSet(true));
        fs.put("LocalSskInsertBytesReceivedAverage", this.localSskInsertBytesReceivedAverage.exportFieldSet(true));
        fs.put("SuccessfulChkFetchBytesSentAverage", this.successfulChkFetchBytesSentAverage.exportFieldSet(true));
        fs.put("SuccessfulSskFetchBytesSentAverage", this.successfulSskFetchBytesSentAverage.exportFieldSet(true));
        fs.put("SuccessfulChkInsertBytesSentAverage", this.successfulChkInsertBytesSentAverage.exportFieldSet(true));
        fs.put("SuccessfulSskInsertBytesSentAverage", this.successfulSskInsertBytesSentAverage.exportFieldSet(true));
        fs.put("SuccessfulChkOfferReplyBytesSentAverage", this.successfulChkOfferReplyBytesSentAverage.exportFieldSet(true));
        fs.put("SuccessfulSskOfferReplyBytesSentAverage", this.successfulSskOfferReplyBytesSentAverage.exportFieldSet(true));
        fs.put("SuccessfulChkFetchBytesReceivedAverage", this.successfulChkFetchBytesReceivedAverage.exportFieldSet(true));
        fs.put("SuccessfulSskFetchBytesReceivedAverage", this.successfulSskFetchBytesReceivedAverage.exportFieldSet(true));
        fs.put("SuccessfulChkInsertBytesReceivedAverage", this.successfulChkInsertBytesReceivedAverage.exportFieldSet(true));
        fs.put("SuccessfulSskInsertBytesReceivedAverage", this.successfulSskInsertBytesReceivedAverage.exportFieldSet(true));
        fs.put("SuccessfulChkOfferReplyBytesReceivedAverage", this.successfulChkOfferReplyBytesReceivedAverage.exportFieldSet(true));
        fs.put("SuccessfulSskOfferReplyBytesReceivedAverage", this.successfulSskOfferReplyBytesReceivedAverage.exportFieldSet(true));
        fs.put("AverageCacheLocation", this.avgCacheLocation.exportFieldSet(true));
        fs.put("AverageStoreLocation", this.avgStoreLocation.exportFieldSet(true));
        fs.put("AverageCacheSuccessLocation", this.avgCacheSuccess.exportFieldSet(true));
        fs.put("AverageStoreSuccessLocation", this.avgStoreSuccess.exportFieldSet(true));
        fs.put("AverageRequestLocation", this.avgRequestLocation.exportFieldSet(true));
        return fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeUpdateNodeIOStats(long now) {
        if (now > this.nextNodeIOStatsUpdateTime) {
            long indiff;
            long outdiff;
            long[] io_stats = this.node.collector.getTotalIO();
            Object object = this.ioStatSync;
            synchronized (object) {
                this.previous_output_stat = this.last_output_stat;
                this.previous_input_stat = this.last_input_stat;
                this.previous_io_stat_time = this.last_io_stat_time;
                this.last_output_stat = io_stats[0];
                this.last_input_stat = io_stats[1];
                this.last_io_stat_time = now;
                outdiff = this.last_output_stat - this.previous_output_stat;
                indiff = this.last_input_stat - this.previous_input_stat;
            }
            if (logMINOR) {
                Logger.minor(this, "Last 2 seconds: input: " + indiff + " output: " + outdiff);
            }
            this.nextNodeIOStatsUpdateTime = now + 2000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getNodeIOStats() {
        long[] result = new long[6];
        Object object = this.ioStatSync;
        synchronized (object) {
            result[0] = this.previous_output_stat;
            result[1] = this.previous_input_stat;
            result[2] = this.previous_io_stat_time;
            result[3] = this.last_output_stat;
            result[4] = this.last_input_stat;
            result[5] = this.last_io_stat_time;
        }
        return result;
    }

    public void waitUntilNotOverloaded(boolean isInsert) {
        while (this.threadLimit < this.getActiveThreadCount()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public int getActiveThreadCount() {
        return this.rootThreadGroup.activeCount() - this.node.executor.getWaitingThreadsCount();
    }

    public int[] getActiveThreadsByPriority() {
        return this.activeThreadsByPriorities;
    }

    public int[] getWaitingThreadsByPriority() {
        return this.waitingThreadsByPriorities;
    }

    public int getThreadLimit() {
        return this.threadLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleFieldSet exportVolatileFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        long now = System.currentTimeMillis();
        fs.put("isUsingWrapper", this.node.isUsingWrapper());
        long nodeUptimeSeconds = 0L;
        NodeStats nodeStats = this;
        synchronized (nodeStats) {
            fs.put("startupTime", this.node.startupTime);
            nodeUptimeSeconds = (now - this.node.startupTime) / 1000L;
            if (nodeUptimeSeconds == 0L) {
                nodeUptimeSeconds = 1L;
            }
            fs.put("uptimeSeconds", nodeUptimeSeconds);
        }
        fs.put("averagePingTime", this.getNodeAveragePingTime());
        fs.put("bwlimitDelayTime", this.getBwlimitDelayTime());
        fs.put("opennetSizeEstimateSession", this.getOpennetSizeEstimate(-1L));
        int opennetSizeEstimate24hourRecent = this.getOpennetSizeEstimate(now - 86400000L);
        fs.put("opennetSizeEstimate24hourRecent", opennetSizeEstimate24hourRecent);
        int opennetSizeEstimate48hourRecent = this.getOpennetSizeEstimate(now - 172800000L);
        fs.put("opennetSizeEstimate48hourRecent", opennetSizeEstimate48hourRecent);
        fs.put("networkSizeEstimateSession", this.getDarknetSizeEstimate(-1L));
        int networkSizeEstimate24hourRecent = this.getDarknetSizeEstimate(now - 86400000L);
        fs.put("networkSizeEstimate24hourRecent", networkSizeEstimate24hourRecent);
        int networkSizeEstimate48hourRecent = this.getDarknetSizeEstimate(now - 172800000L);
        fs.put("networkSizeEstimate48hourRecent", networkSizeEstimate48hourRecent);
        fs.put("routingMissDistance", this.routingMissDistance.currentValue());
        fs.put("backedOffPercent", this.backedOffPercent.currentValue());
        fs.put("pInstantReject", this.pRejectIncomingInstantly());
        fs.put("unclaimedFIFOSize", this.node.usm.getUnclaimedFIFOSize());
        PeerNodeStatus[] peerNodeStatuses = this.peers.getPeerNodeStatuses(true);
        int numberOfSeedServers = this.getCountSeedServers(peerNodeStatuses);
        int numberOfSeedClients = this.getCountSeedClients(peerNodeStatuses);
        int numberOfConnected = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 1);
        int numberOfRoutingBackedOff = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 2);
        int numberOfTooNew = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 3);
        int numberOfTooOld = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 4);
        int numberOfDisconnected = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 5);
        int numberOfNeverConnected = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 6);
        int numberOfDisabled = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 7);
        int numberOfBursting = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 8);
        int numberOfListening = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 9);
        int numberOfListenOnly = PeerNodeStatus.getPeerStatusCount(peerNodeStatuses, 10);
        int numberOfSimpleConnected = numberOfConnected + numberOfRoutingBackedOff;
        int numberOfNotConnected = numberOfTooNew + numberOfTooOld + numberOfDisconnected + numberOfNeverConnected + numberOfDisabled + numberOfBursting + numberOfListening + numberOfListenOnly;
        fs.put("numberOfSeedServers", numberOfSeedServers);
        fs.put("numberOfSeedClients", numberOfSeedClients);
        fs.put("numberOfConnected", numberOfConnected);
        fs.put("numberOfRoutingBackedOff", numberOfRoutingBackedOff);
        fs.put("numberOfTooNew", numberOfTooNew);
        fs.put("numberOfTooOld", numberOfTooOld);
        fs.put("numberOfDisconnected", numberOfDisconnected);
        fs.put("numberOfNeverConnected", numberOfNeverConnected);
        fs.put("numberOfDisabled", numberOfDisabled);
        fs.put("numberOfBursting", numberOfBursting);
        fs.put("numberOfListening", numberOfListening);
        fs.put("numberOfListenOnly", numberOfListenOnly);
        fs.put("numberOfSimpleConnected", numberOfSimpleConnected);
        fs.put("numberOfNotConnected", numberOfNotConnected);
        fs.put("numberOfInsertSenders", this.node.getNumInsertSenders());
        fs.put("numberOfRequestSenders", this.node.getNumRequestSenders());
        fs.put("numberOfTransferringRequestSenders", this.node.getNumTransferringRequestSenders());
        fs.put("numberOfARKFetchers", this.node.getNumARKFetchers());
        long[] total = this.node.collector.getTotalIO();
        long total_output_rate = total[0] / nodeUptimeSeconds;
        long total_input_rate = total[1] / nodeUptimeSeconds;
        long totalPayloadOutput = this.node.getTotalPayloadSent();
        long total_payload_output_rate = totalPayloadOutput / nodeUptimeSeconds;
        int total_payload_output_percent = total[0] == 0L ? -1 : (int)(100L * totalPayloadOutput / total[0]);
        fs.put("totalOutputBytes", total[0]);
        fs.put("totalOutputRate", total_output_rate);
        fs.put("totalPayloadOutputBytes", totalPayloadOutput);
        fs.put("totalPayloadOutputRate", total_payload_output_rate);
        fs.put("totalPayloadOutputPercent", total_payload_output_percent);
        fs.put("totalInputBytes", total[1]);
        fs.put("totalInputRate", total_input_rate);
        long[] rate = this.getNodeIOStats();
        long deltaMS = rate[5] - rate[2];
        double recent_output_rate = deltaMS == 0L ? 0.0 : 1000.0 * (double)(rate[3] - rate[0]) / (double)deltaMS;
        double recent_input_rate = deltaMS == 0L ? 0.0 : 1000.0 * (double)(rate[4] - rate[1]) / (double)deltaMS;
        fs.put("recentOutputRate", recent_output_rate);
        fs.put("recentInputRate", recent_input_rate);
        String[] routingBackoffReasons = this.peers.getPeerNodeRoutingBackoffReasons();
        if (routingBackoffReasons.length != 0) {
            for (int i = 0; i < routingBackoffReasons.length; ++i) {
                fs.put("numberWithRoutingBackoffReasons." + routingBackoffReasons[i], this.peers.getPeerNodeRoutingBackoffReasonSize(routingBackoffReasons[i]));
            }
        }
        double swaps = this.node.getSwaps();
        double noSwaps = this.node.getNoSwaps();
        double numberOfRemotePeerLocationsSeenInSwaps = this.node.getNumberOfRemotePeerLocationsSeenInSwaps();
        fs.putSingle("numberOfRemotePeerLocationsSeenInSwaps", Double.toString(numberOfRemotePeerLocationsSeenInSwaps));
        double avgConnectedPeersPerNode = 0.0;
        if (numberOfRemotePeerLocationsSeenInSwaps > 0.0 && (swaps > 0.0 || noSwaps > 0.0)) {
            avgConnectedPeersPerNode = numberOfRemotePeerLocationsSeenInSwaps / (swaps + noSwaps);
        }
        fs.putSingle("avgConnectedPeersPerNode", Double.toString(avgConnectedPeersPerNode));
        int startedSwaps = this.node.getStartedSwaps();
        int swapsRejectedAlreadyLocked = this.node.getSwapsRejectedAlreadyLocked();
        int swapsRejectedNowhereToGo = this.node.getSwapsRejectedNowhereToGo();
        int swapsRejectedRateLimit = this.node.getSwapsRejectedRateLimit();
        int swapsRejectedRecognizedID = this.node.getSwapsRejectedRecognizedID();
        double locationChangePerSession = this.node.getLocationChangeSession();
        double locationChangePerSwap = 0.0;
        double locationChangePerMinute = 0.0;
        double swapsPerMinute = 0.0;
        double noSwapsPerMinute = 0.0;
        double swapsPerNoSwaps = 0.0;
        if (swaps > 0.0) {
            locationChangePerSwap = locationChangePerSession / swaps;
        }
        if (swaps > 0.0 && nodeUptimeSeconds >= 60L) {
            locationChangePerMinute = locationChangePerSession / ((double)nodeUptimeSeconds / 60.0);
        }
        if (swaps > 0.0 && nodeUptimeSeconds >= 60L) {
            swapsPerMinute = swaps / ((double)nodeUptimeSeconds / 60.0);
        }
        if (noSwaps > 0.0 && nodeUptimeSeconds >= 60L) {
            noSwapsPerMinute = noSwaps / ((double)nodeUptimeSeconds / 60.0);
        }
        if (swaps > 0.0 && noSwaps > 0.0) {
            swapsPerNoSwaps = swaps / noSwaps;
        }
        fs.put("locationChangePerSession", locationChangePerSession);
        fs.put("locationChangePerSwap", locationChangePerSwap);
        fs.put("locationChangePerMinute", locationChangePerMinute);
        fs.put("swapsPerMinute", swapsPerMinute);
        fs.put("noSwapsPerMinute", noSwapsPerMinute);
        fs.put("swapsPerNoSwaps", swapsPerNoSwaps);
        fs.put("swaps", swaps);
        fs.put("noSwaps", noSwaps);
        fs.put("startedSwaps", startedSwaps);
        fs.put("swapsRejectedAlreadyLocked", swapsRejectedAlreadyLocked);
        fs.put("swapsRejectedNowhereToGo", swapsRejectedNowhereToGo);
        fs.put("swapsRejectedRateLimit", swapsRejectedRateLimit);
        fs.put("swapsRejectedRecognizedID", swapsRejectedRecognizedID);
        long fix32kb = 32768L;
        long cachedKeys = this.node.getChkDatacache().keyCount();
        long cachedSize = cachedKeys * fix32kb;
        long storeKeys = this.node.getChkDatastore().keyCount();
        long storeSize = storeKeys * fix32kb;
        long overallKeys = cachedKeys + storeKeys;
        long overallSize = cachedSize + storeSize;
        long maxOverallKeys = this.node.getMaxTotalKeys();
        long maxOverallSize = maxOverallKeys * fix32kb;
        double percentOverallKeysOfMax = (double)(overallKeys * 100L) / (double)maxOverallKeys;
        long cachedStoreHits = this.node.getChkDatacache().hits();
        long cachedStoreMisses = this.node.getChkDatacache().misses();
        long cacheAccesses = cachedStoreHits + cachedStoreMisses;
        double percentCachedStoreHitsOfAccesses = (double)(cachedStoreHits * 100L) / (double)cacheAccesses;
        long storeHits = this.node.getChkDatastore().hits();
        long storeMisses = this.node.getChkDatastore().misses();
        long storeAccesses = storeHits + storeMisses;
        double percentStoreHitsOfAccesses = (double)(storeHits * 100L) / (double)storeAccesses;
        long overallAccesses = storeAccesses + cacheAccesses;
        double avgStoreAccessRate = (double)overallAccesses / (double)nodeUptimeSeconds;
        fs.put("cachedKeys", cachedKeys);
        fs.put("cachedSize", cachedSize);
        fs.put("storeKeys", storeKeys);
        fs.put("storeSize", storeSize);
        fs.put("overallKeys", overallKeys);
        fs.put("overallSize", overallSize);
        fs.put("maxOverallKeys", maxOverallKeys);
        fs.put("maxOverallSize", maxOverallSize);
        fs.put("percentOverallKeysOfMax", percentOverallKeysOfMax);
        fs.put("cachedStoreHits", cachedStoreHits);
        fs.put("cachedStoreMisses", cachedStoreMisses);
        fs.put("cacheAccesses", cacheAccesses);
        fs.put("percentCachedStoreHitsOfAccesses", percentCachedStoreHitsOfAccesses);
        fs.put("storeHits", storeHits);
        fs.put("storeMisses", storeMisses);
        fs.put("storeAccesses", storeAccesses);
        fs.put("percentStoreHitsOfAccesses", percentStoreHitsOfAccesses);
        fs.put("overallAccesses", overallAccesses);
        fs.put("avgStoreAccessRate", avgStoreAccessRate);
        Runtime rt = Runtime.getRuntime();
        float freeMemory = rt.freeMemory();
        float totalMemory = rt.totalMemory();
        float maxMemory = rt.maxMemory();
        long usedJavaMem = (long)(totalMemory - freeMemory);
        long allocatedJavaMem = (long)totalMemory;
        long maxJavaMem = (long)maxMemory;
        int availableCpus = rt.availableProcessors();
        fs.put("freeJavaMemory", (long)freeMemory);
        fs.put("usedJavaMemory", usedJavaMem);
        fs.put("allocatedJavaMemory", allocatedJavaMem);
        fs.put("maximumJavaMemory", maxJavaMem);
        fs.put("availableCPUs", availableCpus);
        fs.put("runningThreadCount", this.getActiveThreadCount());
        fs.put("globalFetchPSuccess", this.globalFetchPSuccess.currentValue());
        fs.put("chkFetchPSuccess", this.chkFetchPSuccess.currentValue());
        fs.put("sskFetchPSuccess", this.sskFetchPSuccess.currentValue());
        fs.put("localFetchPSuccess", this.localFetchPSuccess.currentValue());
        fs.put("remoteFetchPSuccess", this.remoteFetchPSuccess.currentValue());
        fs.put("blockTransferPSuccess", this.blockTransferPSuccess.currentValue());
        fs.put("blockTransferFailTurtled", this.blockTransferFailTurtled.currentValue());
        fs.put("blockTransferFailTimeout", this.blockTransferFailTimeout.currentValue());
        return fs;
    }

    public void setOutputLimit(int obwLimit) {
        this.requestOutputThrottle.changeNanosAndBucketSize((int)(1000000000L / (long)obwLimit), Math.max(obwLimit * 60, 655360));
        if (this.node.inputLimitDefault) {
            this.setInputLimit(obwLimit * 4);
        }
    }

    public void setInputLimit(int ibwLimit) {
        this.requestInputThrottle.changeNanosAndBucketSize((int)(1000000000L / (long)ibwLimit), Math.max(ibwLimit * 60, 655360));
    }

    public boolean isTestnetEnabled() {
        return this.node.isTestnetEnabled();
    }

    public boolean getRejectReasonsTable(HTMLNode table) {
        return this.preemptiveRejectReasons.toTableRows(table) > 0;
    }

    public boolean getLocalRejectReasonsTable(HTMLNode table) {
        return this.localPreemptiveRejectReasons.toTableRows(table) > 0;
    }

    public void requestCompleted(boolean succeeded, boolean isRemote, boolean isSSK) {
        this.globalFetchPSuccess.report(succeeded ? 1.0 : 0.0);
        if (isSSK) {
            this.sskFetchPSuccess.report(succeeded ? 1.0 : 0.0);
        } else {
            this.chkFetchPSuccess.report(succeeded ? 1.0 : 0.0);
        }
        if (isRemote) {
            this.remoteFetchPSuccess.report(succeeded ? 1.0 : 0.0);
        } else {
            this.localFetchPSuccess.report(succeeded ? 1.0 : 0.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillSuccessRateBox(HTMLNode parent) {
        long succeeded;
        long total;
        HTMLNode list = parent.addChild("table", "border", "0");
        BootstrappingDecayingRunningAverage[] averages = new BootstrappingDecayingRunningAverage[]{this.globalFetchPSuccess, this.chkFetchPSuccess, this.sskFetchPSuccess, this.localFetchPSuccess, this.remoteFetchPSuccess, this.blockTransferPSuccess, this.blockTransferFailTurtled, this.blockTransferFailTimeout};
        String[] names = new String[]{"All requests", "CHKs", "SSKs", "Local requests", "Remote requests", "Block transfers", "Turtled downstream", "Transfers timed out"};
        HTMLNode row = list.addChild("tr");
        row.addChild("th", "Group");
        row.addChild("th", "P(success)");
        row.addChild("th", "Count");
        for (int i = 0; i < averages.length; ++i) {
            row = list.addChild("tr");
            row.addChild("td", names[i]);
            if (averages[i].countReports() == 0L) {
                row.addChild("td", "-");
                row.addChild("td", "0");
                continue;
            }
            row.addChild("td", this.fix3p3pct.format(averages[i].currentValue()));
            row.addChild("td", this.thousendPoint.format(averages[i].countReports()));
        }
        row = list.addChild("tr");
        row.addChild("td", "Turtle requests");
        NodeStats nodeStats = this;
        synchronized (nodeStats) {
            total = this.turtleTransfersCompleted;
            succeeded = this.turtleSuccesses;
        }
        if (total == 0L) {
            row.addChild("td", "-");
            row.addChild("td", "0");
        } else {
            row.addChild("td", this.fix3p3pct.format((double)succeeded / (double)total));
            row.addChild("td", this.thousendPoint.format(total));
        }
    }

    public synchronized void requestSentBytes(boolean ssk, int x) {
        if (ssk) {
            this.sskRequestSentBytes += (long)x;
        } else {
            this.chkRequestSentBytes += (long)x;
        }
    }

    public synchronized void requestReceivedBytes(boolean ssk, int x) {
        if (ssk) {
            this.sskRequestRcvdBytes += (long)x;
        } else {
            this.chkRequestRcvdBytes += (long)x;
        }
    }

    public synchronized void insertSentBytes(boolean ssk, int x) {
        if (logDEBUG) {
            Logger.debug(this, "insertSentBytes(" + ssk + ", " + x + ")");
        }
        if (ssk) {
            this.sskInsertSentBytes += (long)x;
        } else {
            this.chkInsertSentBytes += (long)x;
        }
    }

    public synchronized void insertReceivedBytes(boolean ssk, int x) {
        if (ssk) {
            this.sskInsertRcvdBytes += (long)x;
        } else {
            this.chkInsertRcvdBytes += (long)x;
        }
    }

    public synchronized long getCHKRequestTotalBytesSent() {
        return this.chkRequestSentBytes;
    }

    public synchronized long getSSKRequestTotalBytesSent() {
        return this.sskRequestSentBytes;
    }

    public synchronized long getCHKInsertTotalBytesSent() {
        return this.chkInsertSentBytes;
    }

    public synchronized long getSSKInsertTotalBytesSent() {
        return this.sskInsertSentBytes;
    }

    public synchronized void offeredKeysSenderReceivedBytes(int x) {
        this.offeredKeysSenderRcvdBytes += (long)x;
    }

    public synchronized void offeredKeysSenderSentBytes(int x) {
        this.offeredKeysSenderSentBytes += (long)x;
    }

    public long getOfferedKeysTotalBytesReceived() {
        return this.offeredKeysSenderRcvdBytes;
    }

    public long getOfferedKeysTotalBytesSent() {
        return this.offeredKeysSenderSentBytes;
    }

    public synchronized long getOffersSentBytesSent() {
        return this.offerKeysSentBytes;
    }

    public synchronized void swappingReceivedBytes(int x) {
        this.swappingRcvdBytes += (long)x;
    }

    public synchronized void swappingSentBytes(int x) {
        this.swappingSentBytes += (long)x;
    }

    public synchronized long getSwappingTotalBytesReceived() {
        return this.swappingRcvdBytes;
    }

    public synchronized long getSwappingTotalBytesSent() {
        return this.swappingSentBytes;
    }

    public synchronized void reportAuthBytes(int x) {
        this.totalAuthBytesSent += (long)x;
    }

    public synchronized long getTotalAuthBytesSent() {
        return this.totalAuthBytesSent;
    }

    public synchronized long getResendBytesSent() {
        return this.resendBytesSent;
    }

    public synchronized void reportUOMBytesSent(int x) {
        this.uomBytesSent += (long)x;
    }

    public synchronized long getUOMBytesSent() {
        return this.uomBytesSent;
    }

    public synchronized long getAnnounceBytesSent() {
        return this.announceBytesSent;
    }

    public synchronized long getRoutingStatusBytes() {
        return this.routingStatusBytesSent;
    }

    public synchronized void networkColoringReceivedBytes(int x) {
        this.networkColoringReceivedBytesCounter += (long)x;
    }

    public synchronized void networkColoringSentBytes(int x) {
        this.networkColoringSentBytesCounter += (long)x;
    }

    public synchronized long getNetworkColoringSentBytes() {
        return this.networkColoringSentBytesCounter;
    }

    public synchronized void pingCounterReceived(int x) {
        this.pingBytesReceived += (long)x;
    }

    public synchronized void pingCounterSent(int x) {
        this.pingBytesSent += (long)x;
    }

    public synchronized long getPingSentBytes() {
        return this.pingBytesSent;
    }

    public synchronized long getProbeRequestSentBytes() {
        return this.probeRequestSentBytes;
    }

    public synchronized long getRoutedMessageSentBytes() {
        return this.routedMessageBytesSent;
    }

    void disconnBytesReceived(int x) {
        this.disconnBytesReceived += (long)x;
    }

    void disconnBytesSent(int x) {
        this.disconnBytesSent += (long)x;
    }

    public long getDisconnBytesSent() {
        return this.disconnBytesSent;
    }

    public synchronized long getInitialMessagesBytesSent() {
        return this.initialMessagesBytesSent;
    }

    public long getChangedIPBytesSent() {
        return this.changedIPBytesSent;
    }

    public long getNodeToNodeBytesSent() {
        return this.nodeToNodeSentBytes;
    }

    synchronized void reportNotificationOnlyPacketSent(int packetSize) {
        this.notificationOnlySentBytes += (long)packetSize;
    }

    public long getNotificationOnlyPacketsSentBytes() {
        return this.notificationOnlySentBytes;
    }

    public synchronized long getSentOverhead() {
        return this.offerKeysSentBytes + this.swappingSentBytes + this.totalAuthBytesSent + this.resendBytesSent + this.uomBytesSent + this.announceBytesSent + this.routingStatusBytesSent + this.networkColoringSentBytesCounter + this.pingBytesSent + this.probeRequestSentBytes + this.routedMessageBytesSent + this.disconnBytesSent + this.initialMessagesBytesSent + this.changedIPBytesSent + this.nodeToNodeSentBytes + this.notificationOnlySentBytes;
    }

    public double getSentOverheadPerSecond() {
        long uptime = this.node.getUptime();
        return (double)this.getSentOverhead() * 1000.0 / (double)uptime;
    }

    public synchronized void successfulBlockReceive() {
        this.blockTransferPSuccess.report(1.0);
        if (logMINOR) {
            Logger.minor(this, "Successful receives: " + this.blockTransferPSuccess.currentValue() + " count=" + this.blockTransferPSuccess.countReports());
        }
    }

    public synchronized void failedBlockReceive(boolean normalFetch, boolean timeout, boolean turtle) {
        if (normalFetch) {
            this.blockTransferFailTurtled.report(turtle ? 1.0 : 0.0);
            this.blockTransferFailTimeout.report(timeout ? 1.0 : 0.0);
        }
        this.blockTransferPSuccess.report(0.0);
        if (logMINOR) {
            Logger.minor(this, "Successful receives: " + this.blockTransferPSuccess.currentValue() + " count=" + this.blockTransferPSuccess.countReports());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportIncomingRequestLocation(double loc) {
        assert (loc > 0.0 && loc < 1.0);
        int[] nArray = this.incomingRequestsByLoc;
        synchronized (this.incomingRequestsByLoc) {
            int n = (int)Math.floor(loc * (double)this.incomingRequestsByLoc.length);
            this.incomingRequestsByLoc[n] = this.incomingRequestsByLoc[n] + 1;
            ++this.incomingRequestsAccounted;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getIncomingRequestLocation(int[] retval) {
        int[] result = new int[this.incomingRequestsByLoc.length];
        int[] nArray = this.incomingRequestsByLoc;
        synchronized (this.incomingRequestsByLoc) {
            System.arraycopy(this.incomingRequestsByLoc, 0, result, 0, this.incomingRequestsByLoc.length);
            retval[0] = this.incomingRequestsAccounted;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportOutgoingLocalRequestLocation(double loc) {
        assert (loc > 0.0 && loc < 1.0);
        int[] nArray = this.outgoingLocalRequestByLoc;
        synchronized (this.outgoingLocalRequestByLoc) {
            int n = (int)Math.floor(loc * (double)this.outgoingLocalRequestByLoc.length);
            this.outgoingLocalRequestByLoc[n] = this.outgoingLocalRequestByLoc[n] + 1;
            ++this.outgoingLocalRequestsAccounted;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getOutgoingLocalRequestLocation(int[] retval) {
        int[] result = new int[this.outgoingLocalRequestByLoc.length];
        int[] nArray = this.outgoingLocalRequestByLoc;
        synchronized (this.outgoingLocalRequestByLoc) {
            System.arraycopy(this.outgoingLocalRequestByLoc, 0, result, 0, this.outgoingLocalRequestByLoc.length);
            retval[0] = this.outgoingLocalRequestsAccounted;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportOutgoingRequestLocation(double loc) {
        assert (loc > 0.0 && loc < 1.0);
        int[] nArray = this.outgoingRequestByLoc;
        synchronized (this.outgoingRequestByLoc) {
            int n = (int)Math.floor(loc * (double)this.outgoingRequestByLoc.length);
            this.outgoingRequestByLoc[n] = this.outgoingRequestByLoc[n] + 1;
            ++this.outgoingRequestsAccounted;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getOutgoingRequestLocation(int[] retval) {
        int[] result = new int[this.outgoingRequestByLoc.length];
        int[] nArray = this.outgoingRequestByLoc;
        synchronized (this.outgoingRequestByLoc) {
            System.arraycopy(this.outgoingRequestByLoc, 0, result, 0, this.outgoingRequestByLoc.length);
            retval[0] = this.outgoingRequestsAccounted;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }

    private int getCountSeedServers(PeerNodeStatus[] peerNodeStatuses) {
        int count = 0;
        for (int peerIndex = 0; peerIndex < peerNodeStatuses.length; ++peerIndex) {
            if (!peerNodeStatuses[peerIndex].isSeedServer()) continue;
            ++count;
        }
        return count;
    }

    private int getCountSeedClients(PeerNodeStatus[] peerNodeStatuses) {
        int count = 0;
        for (int peerIndex = 0; peerIndex < peerNodeStatuses.length; ++peerIndex) {
            if (!peerNodeStatuses[peerIndex].isSeedClient()) continue;
            ++count;
        }
        return count;
    }

    public void reportCHKTime(long rtt, boolean successful) {
        if (successful) {
            this.successfulLocalCHKFetchTimeAverage.report(rtt);
        } else {
            this.unsuccessfulLocalCHKFetchTimeAverage.report(rtt);
        }
        this.localCHKFetchTimeAverage.report(rtt);
    }

    public void fillDetailedTimingsBox(HTMLNode html) {
        HTMLNode table = html.addChild("table");
        HTMLNode row = table.addChild("tr");
        row.addChild("td", "Successful");
        row.addChild("td", TimeUtil.formatTime((long)this.successfulLocalCHKFetchTimeAverage.currentValue(), 2, true));
        row = table.addChild("tr");
        row.addChild("td", "Unsuccessful");
        row.addChild("td", TimeUtil.formatTime((long)this.unsuccessfulLocalCHKFetchTimeAverage.currentValue(), 2, true));
        row = table.addChild("tr");
        row.addChild("td", "Average");
        row.addChild("td", TimeUtil.formatTime((long)this.localCHKFetchTimeAverage.currentValue(), 2, true));
    }

    synchronized void turtleSucceeded() {
        ++this.turtleSuccesses;
        ++this.turtleTransfersCompleted;
    }

    synchronized void turtleFailed() {
        ++this.turtleTransfersCompleted;
    }

    static /* synthetic */ int[] access$702(NodeStats x0, int[] x1) {
        x0.activeThreadsByPriorities = x1;
        return x1;
    }

    static /* synthetic */ int[] access$802(NodeStats x0, int[] x1) {
        x0.waitingThreadsByPriorities = x1;
        return x1;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
                logDEBUG = Logger.shouldLog(2, this);
            }
        });
    }
}

