/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.config.FreenetFilePersistentConfig;
import freenet.config.InvalidConfigValueException;
import freenet.config.PersistentConfig;
import freenet.config.SubConfig;
import freenet.crypt.DiffieHellman;
import freenet.crypt.RandomSource;
import freenet.crypt.SSL;
import freenet.crypt.Yarrow;
import freenet.node.DNSRequester;
import freenet.node.ExtVersion;
import freenet.node.FNPPacketMangler;
import freenet.node.LoggingConfigHandler;
import freenet.node.Node;
import freenet.node.NodeInitException;
import freenet.support.Executor;
import freenet.support.Logger;
import freenet.support.LoggerHook;
import freenet.support.PooledExecutor;
import freenet.support.SimpleFieldSet;
import freenet.support.io.NativeThread;
import java.io.File;
import java.io.IOException;
import java.security.Security;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;

public class NodeStarter
implements WrapperListener {
    private Node node;
    private static LoggingConfigHandler logConfigHandler;
    public static final int REQUIRED_EXT_BUILD_NUMBER = 24;
    public static final int RECOMMENDED_EXT_BUILD_NUMBER = 26;
    public static int extBuildNumber;
    public static String extRevisionNumber;
    private FreenetFilePersistentConfig cfg;

    private NodeStarter() {
    }

    public NodeStarter get() {
        return this;
    }

    public Integer start(String[] args) {
        File configFilename;
        if (args.length > 1) {
            System.out.println("Usage: $ java freenet.node.Node <configFile>");
            return -1;
        }
        this.getExtBuild();
        if (args.length == 0) {
            System.out.println("Using default config filename freenet.ini");
            configFilename = new File("freenet.ini");
        } else {
            configFilename = new File(args[0]);
        }
        Security.setProperty("networkaddress.cache.ttl", "0");
        Security.setProperty("networkaddress.cache.negative.ttl", "0");
        try {
            this.cfg = FreenetFilePersistentConfig.constructFreenetFilePersistentConfig(configFilename);
        }
        catch (IOException e) {
            System.out.println("Error : " + e);
            e.printStackTrace();
            return -1;
        }
        SubConfig loggingConfig = new SubConfig("logger", this.cfg);
        PooledExecutor executor = new PooledExecutor();
        try {
            logConfigHandler = new LoggingConfigHandler(loggingConfig, executor);
        }
        catch (InvalidConfigValueException e) {
            System.err.println("Error: could not set up logging: " + e.getMessage());
            e.printStackTrace();
            return -2;
        }
        executor.start();
        WrapperManager.signalStarting((int)500000);
        Runnable useless = new Runnable(){

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(3600000L);
                        }
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    catch (Throwable t) {
                        try {
                            Logger.error(this, "Caught " + t, t);
                        }
                        catch (Throwable throwable) {
                        }
                        continue;
                    }
                    break;
                }
            }
        };
        NativeThread plug = new NativeThread(useless, "Plug", 10, false);
        plug.setDaemon(false);
        plug.start();
        SubConfig sslConfig = new SubConfig("ssl", this.cfg);
        SSL.init(sslConfig);
        try {
            this.node = new Node(this.cfg, null, null, logConfigHandler, this, executor);
            this.node.start(false);
            System.out.println("Node initialization completed.");
        }
        catch (NodeInitException e) {
            System.err.println("Failed to load node: " + e.getMessage());
            e.printStackTrace();
            System.exit(e.exitCode);
        }
        return null;
    }

    private void getExtBuild() {
        try {
            extBuildNumber = 26;
            extRevisionNumber = "23771";
            String builtWithMessage = "freenet.jar built with freenet-ext.jar Build #" + extBuildNumber + " r" + extRevisionNumber;
            Logger.normal(this, builtWithMessage);
            System.out.println(builtWithMessage);
            extBuildNumber = ExtVersion.buildNumber();
            if (extBuildNumber == -42) {
                extBuildNumber = ExtVersion.extBuildNumber();
                extRevisionNumber = ExtVersion.extRevisionNumber();
            }
            if (extBuildNumber == 0) {
                String buildMessage = "extBuildNumber is 0; perhaps your freenet-ext.jar file is corrupted?";
                Logger.error(this, buildMessage);
                System.err.println(buildMessage);
                extBuildNumber = -1;
            }
            if (extRevisionNumber == null) {
                String revisionMessage = "extRevisionNumber is null; perhaps your freenet-ext.jar file is corrupted?";
                Logger.error(this, revisionMessage);
                System.err.println(revisionMessage);
                extRevisionNumber = "INVALID";
            }
        }
        catch (Throwable t) {
            Logger.error(this, "Unable to get the version of your freenet-ext file : it's probably corrupted!");
            System.err.println("Unable to get the version of your freenet-ext file : it's probably corrupted!");
            System.err.println(t.getMessage());
            extRevisionNumber = "INVALID";
            extBuildNumber = -1;
        }
    }

    public int stop(int exitCode) {
        System.err.println("Shutting down with exit code " + exitCode);
        this.node.park();
        WrapperManager.signalStopping((int)120000);
        return exitCode;
    }

    public void restart() {
        WrapperManager.restart();
    }

    public void controlEvent(int event) {
        if (!(WrapperManager.isControlledByNativeWrapper() || event != 200 && event != 201 && event != 203)) {
            WrapperManager.stop((int)0);
        }
    }

    public static void main(String[] args) {
        WrapperManager.start((WrapperListener)new NodeStarter(), (String[])args);
    }

    public static RandomSource globalTestInit(String testName, boolean enablePlug, int logThreshold, String details, boolean noDNS) throws LoggerHook.InvalidThresholdException {
        File dir = new File(testName);
        if (!(dir.mkdir() || dir.exists() && dir.isDirectory())) {
            System.err.println("Cannot create directory for test");
            System.exit(25);
        }
        Logger.setupStdoutLogging(logThreshold, details);
        Security.setProperty("networkaddress.cache.ttl", "0");
        Security.setProperty("networkaddress.cache.negative.ttl", "0");
        Yarrow random = new Yarrow();
        DiffieHellman.init(random);
        if (enablePlug) {
            Runnable useless = new Runnable(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Thread.sleep(3600000L);
                            }
                        }
                        catch (InterruptedException e) {
                            continue;
                        }
                        catch (Throwable t) {
                            try {
                                Logger.error(this, "Caught " + t, t);
                            }
                            catch (Throwable throwable) {
                            }
                            continue;
                        }
                        break;
                    }
                }
            };
            Thread plug = new Thread(useless, "Plug");
            plug.setDaemon(false);
            plug.start();
        }
        FNPPacketMangler.LOG_UNMATCHABLE_ERROR = true;
        DNSRequester.DISABLE = noDNS;
        return random;
    }

    public static Node createTestNode(int port, int opennetPort, String testName, boolean disableProbabilisticHTLs, short maxHTL, int dropProb, RandomSource random, Executor executor, int threadLimit, long storeSize, boolean ramStore, boolean enableSwapping, boolean enableARKs, boolean enableULPRs, boolean enablePerNodeFailureTables, boolean enableSwapQueueing, boolean enablePacketCoalescing, int outputBandwidthLimit, boolean enableFOAF, boolean connectToSeednodes, String ipAddressOverride) throws NodeInitException {
        File baseDir = new File(testName);
        File portDir = new File(baseDir, Integer.toString(port));
        if (!(portDir.mkdir() || portDir.exists() && portDir.isDirectory())) {
            System.err.println("Cannot create directory for test");
            System.exit(25);
        }
        SimpleFieldSet configFS = new SimpleFieldSet(false);
        if (outputBandwidthLimit > 0) {
            configFS.put("node.outputBandwidthLimit", outputBandwidthLimit);
            configFS.put("node.throttleLocalTraffic", true);
        } else {
            configFS.put("node.outputBandwidthLimit", 0x1000000);
            configFS.put("node.throttleLocalTraffic", false);
        }
        configFS.put("node.listenPort", port);
        configFS.put("node.disableProbabilisticHTLs", disableProbabilisticHTLs);
        configFS.put("fproxy.enabled", false);
        configFS.put("fcp.enabled", false);
        configFS.put("console.enabled", false);
        configFS.putSingle("pluginmanager.loadplugin", "");
        configFS.put("node.updater.enabled", false);
        configFS.putSingle("node.tempDir", new File(portDir, "temp").toString());
        configFS.putSingle("node.storeDir", new File(portDir, "store").toString());
        configFS.put("fcp.persistentDownloadsEnabled", false);
        configFS.putSingle("node.throttleFile", new File(portDir, "throttle.dat").toString());
        configFS.putSingle("node.nodeDir", portDir.toString());
        configFS.put("node.maxHTL", maxHTL);
        configFS.put("node.testingDropPacketsEvery", dropProb);
        configFS.put("node.alwaysAllowLocalAddresses", true);
        configFS.put("node.includeLocalAddressesInNoderefs", true);
        configFS.put("node.enableARKs", false);
        configFS.put("node.load.threadLimit", threadLimit);
        if (ramStore) {
            configFS.putSingle("node.storeType", "ram");
        }
        configFS.put("node.storeSize", storeSize);
        configFS.put("node.disableHangCheckers", true);
        configFS.put("node.enableSwapping", enableSwapping);
        configFS.put("node.enableSwapQueueing", enableSwapQueueing);
        configFS.put("node.enableARKs", enableARKs);
        configFS.put("node.enableULPRDataPropagation", enableULPRs);
        configFS.put("node.enablePerNodeFailureTables", enablePerNodeFailureTables);
        configFS.put("node.enablePacketCoalescing", enablePacketCoalescing);
        configFS.put("node.publishOurPeersLocation", enableFOAF);
        configFS.put("node.routeAccordingToOurPeersLocation", enableFOAF);
        configFS.put("node.opennet.enabled", opennetPort > 0);
        configFS.put("node.opennet.listenPort", opennetPort);
        configFS.put("node.opennet.alwaysAllowLocalAddresses", true);
        configFS.put("node.opennet.oneConnectionPerIP", false);
        configFS.put("node.opennet.assumeNATed", true);
        configFS.put("node.opennet.connectToSeednodes", connectToSeednodes);
        configFS.put("node.encryptTempBuckets", false);
        configFS.put("node.encryptPersistentTempBuckets", false);
        if (ipAddressOverride != null) {
            configFS.putSingle("node.ipAddressOverride", ipAddressOverride);
        }
        PersistentConfig config = new PersistentConfig(configFS);
        Node node = new Node(config, random, random, null, null, executor);
        node.peers.removeAllPeers();
        return node;
    }
}

