/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.node.Node;
import freenet.node.PeerManager;
import freenet.node.PeerNode;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.Arrays;

public class NodePinger
implements Runnable {
    private static volatile boolean logMINOR;
    private final Node node;
    private volatile double meanPing = 0.0;
    public static final double CRAZY_MAX_PING_TIME = 3.15576E10;

    NodePinger(Node n) {
        this.node = n;
    }

    void start() {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            PeerNode[] peers = null;
            PeerManager peerManager = this.node.peers;
            synchronized (peerManager) {
                if (this.node.peers.connectedPeers == null || this.node.peers.connectedPeers.length == 0) {
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 5] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
                    Object var5_3 = null;
                    this.node.ps.queueTimedJob(this, 200L);
                    return;
                }
                peers = new PeerNode[this.node.peers.connectedPeers.length];
                System.arraycopy(this.node.peers.connectedPeers, 0, peers, 0, this.node.peers.connectedPeers.length);
            }
            this.recalculateMean(peers);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.node.ps.queueTimedJob(this, 200L);
            throw throwable;
        }
        Object var5_4 = null;
        this.node.ps.queueTimedJob(this, 200L);
    }

    private void recalculateMean(PeerNode[] peers) {
        if (peers.length == 0) {
            return;
        }
        this.meanPing = this.calculateMedianPing(peers);
        if (logMINOR) {
            Logger.minor(this, "Median ping: " + this.meanPing);
        }
    }

    private double calculateMedianPing(PeerNode[] peers) {
        double[] allPeers = new double[peers.length];
        for (int i = 0; i < peers.length; ++i) {
            PeerNode peer = peers[i];
            allPeers[i] = peer.averagePingTime();
        }
        Arrays.sort(allPeers);
        return allPeers[peers.length / 2];
    }

    public double averagePingTime() {
        return this.meanPing;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }
}

