/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.FreenetInetAddress;
import freenet.io.comm.Peer;
import freenet.node.Node;
import freenet.node.NodeARKInserter;
import freenet.node.NodeCrypto;
import freenet.node.NodeIPDetector;
import freenet.node.PeerNode;
import freenet.support.Logger;
import freenet.support.transport.ip.IPUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NodeIPPortDetector {
    final Node node;
    final NodeIPDetector ipDetector;
    final NodeCrypto crypto;
    private final NodeARKInserter arkPutter;
    Peer[] lastPeers;

    NodeIPPortDetector(Node node, NodeIPDetector ipDetector, NodeCrypto crypto, boolean enableARKs) {
        this.node = node;
        this.ipDetector = ipDetector;
        this.crypto = crypto;
        this.arkPutter = new NodeARKInserter(node, crypto, this, enableARKs);
        ipDetector.addPortDetector(this);
    }

    FreenetInetAddress[] detectPrimaryIPAddress() {
        FreenetInetAddress addr = this.crypto.getBindTo();
        if (addr.isRealInternetAddress(false, true, false)) {
            return new FreenetInetAddress[]{addr};
        }
        return this.ipDetector.detectPrimaryIPAddress(!this.crypto.config.includeLocalAddressesInNoderefs);
    }

    Peer[] detectPrimaryPeers() {
        boolean logMINOR = Logger.shouldLog(4, this);
        ArrayList<Peer> addresses = new ArrayList<Peer>();
        FreenetInetAddress[] addrs = this.detectPrimaryIPAddress();
        for (int i = 0; i < addrs.length; ++i) {
            addresses.add(new Peer(addrs[i], this.crypto.portNumber));
            if (!logMINOR) continue;
            Logger.minor(this, "Adding " + addrs[i]);
        }
        PeerNode[] peerList = this.crypto.getPeerNodes();
        if (peerList != null) {
            Peer p;
            HashMap<Peer, Integer> countsByPeer = new HashMap<Peer, Integer>();
            for (int i = 0; i < peerList.length; ++i) {
                p = peerList[i].getRemoteDetectedPeer();
                if (p == null || p.isNull() || !IPUtil.isValidAddress(p.getAddress(true), false)) continue;
                if (Logger.shouldLog(4, this)) {
                    Logger.minor(this, "Peer " + peerList[i].getPeer() + " thinks we are " + p);
                }
                if (countsByPeer.containsKey(p)) {
                    countsByPeer.put(p, (Integer)countsByPeer.get(p) + 1);
                    continue;
                }
                countsByPeer.put(p, 1);
            }
            if (countsByPeer.size() == 1) {
                Iterator it = countsByPeer.keySet().iterator();
                p = (Peer)it.next();
                Logger.minor(this, "Everyone agrees we are " + p);
                if (!addresses.contains(p)) {
                    addresses.add(p);
                }
            } else if (countsByPeer.size() > 1) {
                Peer best = null;
                Peer secondBest = null;
                int bestPopularity = 0;
                int secondBestPopularity = 0;
                for (Map.Entry entry : countsByPeer.entrySet()) {
                    Peer cur = (Peer)entry.getKey();
                    int curPop = (Integer)entry.getValue();
                    Logger.normal(this, "Detected peer: " + cur + " popularity " + curPop);
                    if (curPop < bestPopularity) continue;
                    secondBestPopularity = bestPopularity;
                    bestPopularity = curPop;
                    secondBest = best;
                    best = cur;
                }
                if (best != null && (bestPopularity > 1 || addrs.length == 0)) {
                    if (!addresses.contains(best)) {
                        Logger.normal(this, "Adding best peer " + best + " (" + bestPopularity + ')');
                        addresses.add(best);
                    }
                    if (secondBest != null && secondBestPopularity > 1) {
                        if (!addresses.contains(secondBest)) {
                            Logger.normal(this, "Adding second best peer " + secondBest + " (" + secondBest + ')');
                            addresses.add(secondBest);
                        }
                        if (best.getAddress().equals(secondBest.getAddress()) && bestPopularity == 1) {
                            Logger.error(this, "Hrrrm, maybe this is a symmetric NAT? Expect trouble connecting!");
                            System.err.println("Hrrrm, maybe this is a symmetric NAT? Expect trouble connecting!");
                            this.ipDetector.setMaybeSymmetric();
                            Peer p2 = new Peer(best.getFreenetAddress(), this.crypto.portNumber);
                            if (!addresses.contains(p2)) {
                                addresses.add(p2);
                            }
                        }
                    }
                }
            }
        }
        this.lastPeers = addresses.toArray(new Peer[addresses.size()]);
        if (logMINOR) {
            Logger.minor(this, "Returning for port " + this.crypto.portNumber + " : " + Arrays.toString(this.lastPeers));
        }
        return this.lastPeers;
    }

    void update() {
        this.arkPutter.update();
    }

    void startARK() {
        this.arkPutter.start();
    }

    public Peer[] getPrimaryPeers() {
        if (this.lastPeers == null) {
            return this.detectPrimaryPeers();
        }
        return this.lastPeers;
    }

    public boolean includes(FreenetInetAddress addr) {
        FreenetInetAddress[] a = this.detectPrimaryIPAddress();
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].equals(addr)) continue;
            return true;
        }
        return false;
    }
}

