/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.config.InvalidConfigValueException;
import freenet.config.SubConfig;
import freenet.io.comm.FreenetInetAddress;
import freenet.io.comm.Peer;
import freenet.l10n.L10n;
import freenet.node.IPDetectorPluginManager;
import freenet.node.Node;
import freenet.node.NodeIPPortDetector;
import freenet.node.PeerNode;
import freenet.node.SeedServerPeerNode;
import freenet.node.useralerts.IPUndetectedUserAlert;
import freenet.node.useralerts.InvalidAddressOverrideUserAlert;
import freenet.node.useralerts.SimpleUserAlert;
import freenet.pluginmanager.DetectedIP;
import freenet.pluginmanager.FredPluginBandwidthIndicator;
import freenet.pluginmanager.FredPluginIPDetector;
import freenet.pluginmanager.FredPluginPortForward;
import freenet.support.HTMLNode;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.StringCallback;
import freenet.support.transport.ip.HostnameSyntaxException;
import freenet.support.transport.ip.IPAddressDetector;
import freenet.support.transport.ip.IPUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeIPDetector {
    private static volatile boolean logMINOR;
    final Node node;
    FreenetInetAddress overrideIPAddress;
    String overrideIPAddressString;
    FreenetInetAddress oldIPAddress;
    DetectedIP[] pluginDetectedIPs;
    FreenetInetAddress[] lastIPAddress;
    private int minimumMTU = Integer.MAX_VALUE;
    private final IPAddressDetector ipDetector;
    final IPDetectorPluginManager ipDetectorManager;
    private static InvalidAddressOverrideUserAlert invalidAddressOverrideAlert;
    private boolean hasValidAddressOverride;
    private static IPUndetectedUserAlert primaryIPUndetectedAlert;
    FreenetInetAddress[] lastIP;
    boolean maybeSymmetric;
    private boolean hasDetectedPM;
    private boolean hasDetectedIAD;
    private NodeIPPortDetector[] portDetectors;
    private boolean hasValidIP;
    private boolean firstDetection = true;
    SimpleUserAlert maybeSymmetricAlert;
    private FredPluginBandwidthIndicator bandwidthIndicator;

    public NodeIPDetector(Node node) {
        this.node = node;
        this.ipDetectorManager = new IPDetectorPluginManager(node, this);
        this.ipDetector = new IPAddressDetector(10000, this);
        invalidAddressOverrideAlert = new InvalidAddressOverrideUserAlert(node);
        primaryIPUndetectedAlert = new IPUndetectedUserAlert(node);
        this.portDetectors = new NodeIPPortDetector[0];
    }

    public synchronized void addPortDetector(NodeIPPortDetector detector) {
        NodeIPPortDetector[] newDetectors = new NodeIPPortDetector[this.portDetectors.length + 1];
        System.arraycopy(this.portDetectors, 0, newDetectors, 0, this.portDetectors.length);
        newDetectors[this.portDetectors.length] = detector;
        this.portDetectors = newDetectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FreenetInetAddress[] detectPrimaryIPAddress(boolean dumpLocalAddresses) {
        boolean addedValidIP = false;
        Logger.minor(this, "Redetecting IPs...");
        ArrayList<FreenetInetAddress> addresses = new ArrayList<FreenetInetAddress>();
        if (this.overrideIPAddress != null) {
            addresses.add(this.overrideIPAddress);
            if (this.overrideIPAddress.isRealInternetAddress(false, true, false)) {
                addedValidIP = true;
            }
        }
        if (!this.node.dontDetect()) {
            addedValidIP |= this.innerDetect(addresses);
        }
        if (this.node.clientCore != null) {
            boolean hadValidIP;
            NodeIPDetector nodeIPDetector = this;
            synchronized (nodeIPDetector) {
                hadValidIP = this.hasValidIP;
                this.hasValidIP = addedValidIP;
                if (this.firstDetection) {
                    hadValidIP = !addedValidIP;
                    this.firstDetection = false;
                }
            }
            if (hadValidIP != addedValidIP) {
                if (addedValidIP) {
                    if (logMINOR) {
                        Logger.minor(this, "Got valid IP");
                    }
                    this.onAddedValidIP();
                } else {
                    if (logMINOR) {
                        Logger.minor(this, "No valid IP");
                    }
                    this.onNotAddedValidIP();
                }
            }
        } else if (logMINOR) {
            Logger.minor(this, "Client core not loaded");
        }
        NodeIPDetector hadValidIP = this;
        synchronized (hadValidIP) {
            this.hasValidIP = addedValidIP;
        }
        this.lastIPAddress = addresses.toArray(new FreenetInetAddress[addresses.size()]);
        if (dumpLocalAddresses) {
            ArrayList<FreenetInetAddress> filtered = new ArrayList<FreenetInetAddress>(this.lastIPAddress.length);
            for (int i = 0; i < this.lastIPAddress.length; ++i) {
                if (this.lastIPAddress[i] == null) continue;
                if (this.lastIPAddress[i] == this.overrideIPAddress && this.lastIPAddress[i].hasHostnameNoIP()) {
                    filtered.add(this.lastIPAddress[i]);
                    continue;
                }
                if (this.lastIPAddress[i].hasHostnameNoIP() || !IPUtil.isValidAddress(this.lastIPAddress[i].getAddress(), false)) continue;
                filtered.add(this.lastIPAddress[i]);
            }
            return filtered.toArray(new FreenetInetAddress[filtered.size()]);
        }
        return this.lastIPAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasValidIP() {
        NodeIPDetector nodeIPDetector = this;
        synchronized (nodeIPDetector) {
            return this.hasValidIP;
        }
    }

    private void onAddedValidIP() {
        this.node.clientCore.alerts.unregister(primaryIPUndetectedAlert);
        this.node.onAddedValidIP();
    }

    private void onNotAddedValidIP() {
        this.node.clientCore.alerts.register(primaryIPUndetectedAlert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean innerDetect(List<FreenetInetAddress> addresses) {
        Object addr;
        int i;
        boolean addedValidIP = false;
        InetAddress[] detectedAddrs = this.ipDetector.getAddress();
        assert (detectedAddrs != null);
        NodeIPDetector nodeIPDetector = this;
        synchronized (nodeIPDetector) {
            this.hasDetectedIAD = true;
        }
        for (i = 0; i < detectedAddrs.length; ++i) {
            addr = new FreenetInetAddress(detectedAddrs[i]);
            if (addresses.contains(addr)) continue;
            Logger.normal(this, "Detected IP address: " + addr);
            addresses.add((FreenetInetAddress)addr);
            if (!((FreenetInetAddress)addr).isRealInternetAddress(false, false, false)) continue;
            addedValidIP = true;
        }
        if (this.pluginDetectedIPs != null && this.pluginDetectedIPs.length > 0) {
            for (i = 0; i < this.pluginDetectedIPs.length; ++i) {
                FreenetInetAddress a;
                addr = this.pluginDetectedIPs[i].publicAddress;
                if (addr == null || addresses.contains(a = new FreenetInetAddress((InetAddress)addr))) continue;
                Logger.normal(this, "Plugin detected IP address: " + a);
                addresses.add(a);
                if (!a.isRealInternetAddress(false, false, false)) continue;
                addedValidIP = true;
            }
        }
        if (!addedValidIP && this.oldIPAddress != null && !this.oldIPAddress.equals(this.overrideIPAddress)) {
            addresses.add(this.oldIPAddress);
        }
        if (this.node.peers != null) {
            PeerNode[] peerList = this.node.peers.myPeers;
            HashMap<FreenetInetAddress, Integer> countsByPeer = new HashMap<FreenetInetAddress, Integer>();
            for (int i2 = 0; i2 < peerList.length; ++i2) {
                if (!peerList[i2].isConnected()) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "Not connected");
                    continue;
                }
                if (!peerList[i2].isRealConnection()) {
                    if (!(peerList[i2] instanceof SeedServerPeerNode)) continue;
                    if (logMINOR) {
                        Logger.minor(this, "Not a real connection and not a seed node: " + peerList[i2]);
                    }
                }
                if (logMINOR) {
                    Logger.minor(this, "Maybe a usable connection for IP: " + peerList[i2]);
                }
                Peer p = peerList[i2].getRemoteDetectedPeer();
                if (logMINOR) {
                    Logger.minor(this, "Remote detected peer: " + p);
                }
                if (p == null || p.isNull()) continue;
                FreenetInetAddress addr2 = p.getFreenetAddress();
                if (logMINOR) {
                    Logger.minor(this, "Address: " + addr2);
                }
                if (addr2 == null) continue;
                if (!IPUtil.isValidAddress(addr2.getAddress(false), false)) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "Address not valid");
                    continue;
                }
                if (logMINOR) {
                    Logger.minor(this, "Peer " + peerList[i2].getPeer() + " thinks we are " + addr2);
                }
                if (countsByPeer.containsKey(addr2)) {
                    countsByPeer.put(addr2, (Integer)countsByPeer.get(addr2) + 1);
                    continue;
                }
                countsByPeer.put(addr2, 1);
            }
            if (countsByPeer.size() == 1) {
                Iterator it = countsByPeer.keySet().iterator();
                FreenetInetAddress addr3 = (FreenetInetAddress)it.next();
                Logger.minor(this, "Everyone agrees we are " + addr3);
                if (!addresses.contains(addr3)) {
                    if (addr3.isRealInternetAddress(false, false, false)) {
                        addedValidIP = true;
                    }
                    addresses.add(addr3);
                }
            } else if (countsByPeer.size() > 1) {
                FreenetInetAddress best = null;
                FreenetInetAddress secondBest = null;
                int bestPopularity = 0;
                int secondBestPopularity = 0;
                for (Map.Entry entry : countsByPeer.entrySet()) {
                    FreenetInetAddress cur = (FreenetInetAddress)entry.getKey();
                    int curPop = (Integer)entry.getValue();
                    Logger.minor(this, "Detected peer: " + cur + " popularity " + curPop);
                    if (curPop < bestPopularity) continue;
                    secondBestPopularity = bestPopularity;
                    bestPopularity = curPop;
                    secondBest = best;
                    best = cur;
                }
                if (best != null) {
                    boolean hasRealDetectedAddress = false;
                    for (int i3 = 0; i3 < detectedAddrs.length; ++i3) {
                        if (!IPUtil.isValidAddress(detectedAddrs[i3], false)) continue;
                        hasRealDetectedAddress = true;
                    }
                    if (bestPopularity > 1 || !hasRealDetectedAddress) {
                        if (!addresses.contains(best)) {
                            Logger.minor(this, "Adding best peer " + best + " (" + bestPopularity + ')');
                            addresses.add(best);
                            if (best.isRealInternetAddress(false, false, false)) {
                                addedValidIP = true;
                            }
                        }
                        if (secondBest != null && secondBestPopularity > 1 && !addresses.contains(secondBest)) {
                            Logger.minor(this, "Adding second best peer " + secondBest + " (" + secondBest + ')');
                            addresses.add(secondBest);
                            if (secondBest.isRealInternetAddress(false, false, false)) {
                                addedValidIP = true;
                            }
                        }
                    }
                }
            }
        }
        return addedValidIP;
    }

    private String l10n(String key) {
        return L10n.getString("NodeIPDetector." + key);
    }

    private String l10n(String key, String pattern, String value) {
        return L10n.getString("NodeIPDetector." + key, pattern, value);
    }

    FreenetInetAddress[] getPrimaryIPAddress(boolean dumpLocal) {
        if (this.lastIPAddress == null) {
            return this.detectPrimaryIPAddress(dumpLocal);
        }
        return this.lastIPAddress;
    }

    public boolean hasDirectlyDetectedIP() {
        InetAddress[] addrs = this.ipDetector.getAddress();
        if (addrs == null || addrs.length == 0) {
            return false;
        }
        for (int i = 0; i < addrs.length; ++i) {
            if (!IPUtil.isValidAddress(addrs[i], false)) continue;
            if (logMINOR) {
                Logger.minor(this, "Has a directly detected IP: " + addrs[i]);
            }
            return true;
        }
        return false;
    }

    public void processDetectedIPs(DetectedIP[] list) {
        this.pluginDetectedIPs = list;
        for (int i = 0; i < this.pluginDetectedIPs.length; ++i) {
            int mtu = this.pluginDetectedIPs[i].mtu;
            if (this.minimumMTU <= mtu || mtu <= 0) continue;
            this.minimumMTU = mtu;
            Logger.normal(this, "Reducing the MTU to " + this.minimumMTU);
            if (mtu >= 1100) continue;
            this.node.onTooLowMTU(this.minimumMTU, 1100);
        }
        this.redetectAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redetectAddress() {
        NodeIPPortDetector[] detectors;
        Object[] newIP = this.detectPrimaryIPAddress(false);
        NodeIPDetector nodeIPDetector = this;
        synchronized (nodeIPDetector) {
            if (Arrays.equals(newIP, this.lastIP)) {
                return;
            }
            this.lastIP = newIP;
            detectors = this.portDetectors;
        }
        for (int i = 0; i < detectors.length; ++i) {
            detectors[i].update();
        }
        this.node.writeNodeFile();
    }

    public void setOldIPAddress(FreenetInetAddress freenetAddress) {
        this.oldIPAddress = freenetAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerConfigs(SubConfig nodeConfig, int sortOrder) {
        nodeConfig.register("ipAddressOverride", "", sortOrder++, true, false, "NodeIPDectector.ipOverride", "NodeIPDectector.ipOverrideLong", new StringCallback(){

            public String get() {
                if (NodeIPDetector.this.overrideIPAddressString == null) {
                    return "";
                }
                return NodeIPDetector.this.overrideIPAddressString;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void set(String val) throws InvalidConfigValueException {
                FreenetInetAddress addr;
                boolean hadValidAddressOverride = NodeIPDetector.this.hasValidAddressOverride();
                if (val.length() == 0) {
                    NodeIPDetector.this.overrideIPAddressString = val;
                    NodeIPDetector.this.overrideIPAddress = null;
                    NodeIPDetector.this.lastIPAddress = null;
                    NodeIPDetector.this.redetectAddress();
                    return;
                }
                try {
                    addr = new FreenetInetAddress(val, false, true);
                }
                catch (HostnameSyntaxException e) {
                    throw new InvalidConfigValueException(NodeIPDetector.this.l10n("unknownHostErrorInIPOverride", "error", "hostname or IP address syntax error"));
                }
                catch (UnknownHostException e) {
                    throw new InvalidConfigValueException(NodeIPDetector.this.l10n("unknownHostErrorInIPOverride", "error", e.getMessage()));
                }
                if (addr.equals(NodeIPDetector.this.overrideIPAddress)) {
                    return;
                }
                NodeIPDetector.this.overrideIPAddressString = val;
                NodeIPDetector.this.overrideIPAddress = addr;
                NodeIPDetector.this.lastIPAddress = null;
                2 var4_6 = this;
                synchronized (var4_6) {
                    NodeIPDetector.this.hasValidAddressOverride = true;
                }
                if (!hadValidAddressOverride) {
                    NodeIPDetector.this.onGetValidAddressOverride();
                }
                NodeIPDetector.this.redetectAddress();
            }
        });
        this.hasValidAddressOverride = true;
        this.overrideIPAddressString = nodeConfig.getString("ipAddressOverride");
        if (this.overrideIPAddressString.length() == 0) {
            this.overrideIPAddress = null;
        } else {
            String msg;
            try {
                this.overrideIPAddress = new FreenetInetAddress(this.overrideIPAddressString, false, true);
            }
            catch (HostnameSyntaxException e) {
                NodeIPDetector nodeIPDetector = this;
                synchronized (nodeIPDetector) {
                    this.hasValidAddressOverride = false;
                }
                msg = "Invalid IP override syntax: " + this.overrideIPAddressString + " in config: " + e.getMessage();
                Logger.error(this, msg);
                System.err.println(msg + " but starting up anyway, ignoring the configured IP override");
                this.overrideIPAddress = null;
            }
            catch (UnknownHostException e) {
                msg = "Unknown host: " + this.overrideIPAddressString + " in config: " + e.getMessage();
                Logger.error(this, msg);
                System.err.println(msg + " but starting up anyway with no IP override");
                this.overrideIPAddress = null;
            }
        }
        nodeConfig.register("tempIPAddressHint", "", sortOrder++, true, false, "NodeIPDectector.tempAddressHint", "NodeIPDectector.tempAddressHintLong", new StringCallback(){

            public String get() {
                return "";
            }

            public void set(String val) throws InvalidConfigValueException {
                if (val.length() == 0) {
                    return;
                }
                if (NodeIPDetector.this.overrideIPAddress != null) {
                    return;
                }
                try {
                    NodeIPDetector.this.oldIPAddress = new FreenetInetAddress(val, false);
                }
                catch (UnknownHostException e) {
                    throw new InvalidConfigValueException("Unknown host: " + e.getMessage());
                }
                NodeIPDetector.this.redetectAddress();
            }
        });
        String ipHintString = nodeConfig.getString("tempIPAddressHint");
        if (ipHintString.length() > 0) {
            try {
                this.oldIPAddress = new FreenetInetAddress(ipHintString, false);
            }
            catch (UnknownHostException e) {
                String msg = "Unknown host: " + ipHintString + " in config: " + e.getMessage();
                Logger.error(this, msg);
                System.err.println(msg + "");
                this.oldIPAddress = null;
            }
        }
        return sortOrder;
    }

    public void start() {
        boolean haveValidAddressOverride = this.hasValidAddressOverride();
        if (!haveValidAddressOverride) {
            this.onNotGetValidAddressOverride();
        }
        this.node.executor.execute(this.ipDetector, "IP address re-detector");
        this.redetectAddress();
        this.node.getTicker().queueTimedJob(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                NodeIPPortDetector[] detectors;
                4 var2_1 = this;
                synchronized (var2_1) {
                    detectors = NodeIPDetector.this.portDetectors;
                }
                for (int i = 0; i < detectors.length; ++i) {
                    detectors[i].startARK();
                }
            }
        }, 60000L);
    }

    public void onConnectedPeer() {
        this.ipDetectorManager.maybeRun();
    }

    public void registerIPDetectorPlugin(FredPluginIPDetector detector) {
        this.ipDetectorManager.registerDetectorPlugin(detector);
    }

    public void unregisterIPDetectorPlugin(FredPluginIPDetector detector) {
        this.ipDetectorManager.unregisterDetectorPlugin(detector);
    }

    public synchronized boolean isDetecting() {
        return !this.hasDetectedPM || !this.hasDetectedIAD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void hasDetectedPM() {
        if (logMINOR) {
            Logger.minor(this, "hasDetectedPM() called", (Throwable)new Exception("debug"));
        }
        NodeIPDetector nodeIPDetector = this;
        synchronized (nodeIPDetector) {
            this.hasDetectedPM = true;
        }
    }

    public int getMinimumDetectedMTU() {
        return this.minimumMTU > 0 ? this.minimumMTU : 1500;
    }

    public void setMaybeSymmetric() {
        if (this.ipDetectorManager != null && this.ipDetectorManager.isEmpty()) {
            if (this.maybeSymmetricAlert == null) {
                this.maybeSymmetricAlert = new SimpleUserAlert(true, this.l10n("maybeSymmetricTitle"), this.l10n("maybeSymmetric"), this.l10n("maybeSymmetricShort"), 1);
            }
            if (this.node.clientCore != null && this.node.clientCore.alerts != null) {
                this.node.clientCore.alerts.register(this.maybeSymmetricAlert);
            }
        } else if (this.maybeSymmetricAlert != null) {
            this.node.clientCore.alerts.unregister(this.maybeSymmetricAlert);
        }
    }

    public void registerPortForwardPlugin(FredPluginPortForward forward) {
        this.ipDetectorManager.registerPortForwardPlugin(forward);
    }

    public void unregisterPortForwardPlugin(FredPluginPortForward forward) {
        this.ipDetectorManager.unregisterPortForwardPlugin(forward);
    }

    public synchronized void registerBandwidthIndicatorPlugin(FredPluginBandwidthIndicator indicator) {
        this.bandwidthIndicator = indicator;
    }

    public synchronized void unregisterBandwidthIndicatorPlugin(FredPluginBandwidthIndicator indicator) {
        this.bandwidthIndicator = null;
    }

    public synchronized FredPluginBandwidthIndicator getBandwidthIndicator() {
        return this.bandwidthIndicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasValidAddressOverride() {
        NodeIPDetector nodeIPDetector = this;
        synchronized (nodeIPDetector) {
            return this.hasValidAddressOverride;
        }
    }

    private void onGetValidAddressOverride() {
        this.node.clientCore.alerts.unregister(invalidAddressOverrideAlert);
    }

    private void onNotGetValidAddressOverride() {
        this.node.clientCore.alerts.register(invalidAddressOverrideAlert);
    }

    public void addConnectionTypeBox(HTMLNode contentNode) {
        this.ipDetectorManager.addConnectionTypeBox(contentNode);
    }

    public boolean noDetectPlugins() {
        return !this.ipDetectorManager.hasDetectors();
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }
}

