/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.crypt.HMAC;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.Dispatcher;
import freenet.io.comm.Message;
import freenet.io.comm.MessageType;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.Peer;
import freenet.keys.Key;
import freenet.keys.NodeSSK;
import freenet.node.AnnounceSender;
import freenet.node.CHKInsertHandler;
import freenet.node.DarknetPeerNode;
import freenet.node.FastRunnable;
import freenet.node.InsertTag;
import freenet.node.Node;
import freenet.node.NodeStats;
import freenet.node.OfferReplyTag;
import freenet.node.OpennetManager;
import freenet.node.PeerNode;
import freenet.node.ProbeCallback;
import freenet.node.ProbeRequestHandler;
import freenet.node.ProbeRequestSender;
import freenet.node.RequestHandler;
import freenet.node.RequestTag;
import freenet.node.SSKInsertHandler;
import freenet.support.Fields;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.ShortBuffer;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class NodeDispatcher
implements Dispatcher,
Runnable {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    final Node node;
    private NodeStats nodeStats;
    private NodeDispatcherCallback callback;
    private static final long STALE_CONTEXT = 20000L;
    private static final long STALE_CONTEXT_CHECK = 20000L;
    ByteCounter pingCounter = new ByteCounter(){

        public void receivedBytes(int x) {
            NodeDispatcher.this.node.nodeStats.pingCounterReceived(x);
        }

        public void sentBytes(int x) {
            NodeDispatcher.this.node.nodeStats.pingCounterSent(x);
        }

        public void sentPayload(int x) {
        }
    };
    final Hashtable<Long, RoutedContext> routedContexts = new Hashtable();
    public static final int PROBE_TYPE_RESETTING_HTL = 0;

    NodeDispatcher(Node node) {
        this.node = node;
        this.nodeStats = node.nodeStats;
        node.getTicker().queueTimedJob(this, 20000L);
    }

    public boolean handleMessage(Message m) {
        MessageType spec;
        PeerNode source = (PeerNode)m.getSource();
        if (source == null) {
            return true;
        }
        if (logMINOR) {
            Logger.minor(this, "Dispatching " + m + " from " + source);
        }
        if (this.callback != null) {
            try {
                this.callback.snoop(m, this.node);
            }
            catch (Throwable t) {
                Logger.error(this, "Callback threw " + t, t);
            }
        }
        if ((spec = m.getSpec()) == DMT.FNPPing) {
            block50: {
                Message reply = DMT.createFNPPong(m.getInt("pingSequenceNumber"));
                try {
                    source.sendAsync(reply, null, this.pingCounter);
                }
                catch (NotConnectedException e) {
                    if (!logMINOR) break block50;
                    Logger.minor(this, "Lost connection replying to " + m);
                }
            }
            return true;
        }
        if (spec == DMT.FNPStoreSecret) {
            return this.node.netid.handleStoreSecret(m);
        }
        if (spec == DMT.FNPSecretPing) {
            return this.node.netid.handleSecretPing(m);
        }
        if (spec == DMT.FNPDetectedIPAddress) {
            Peer p = (Peer)m.getObject("externalAddress");
            source.setRemoteDetectedPeer(p);
            this.node.ipDetector.redetectAddress();
            return true;
        }
        if (spec == DMT.FNPTime) {
            return this.handleTime(m, source);
        }
        if (spec == DMT.FNPUptime) {
            return this.handleUptime(m, source);
        }
        if (spec == DMT.FNPSentPackets) {
            source.handleSentPackets(m);
            return true;
        }
        if (spec == DMT.FNPVoid) {
            return true;
        }
        if (spec == DMT.FNPDisconnect) {
            this.handleDisconnect(m, source);
            return true;
        }
        if (spec == DMT.nodeToNodeMessage) {
            this.node.receivedNodeToNodeMessage(m, source);
            return true;
        }
        if (spec == DMT.UOMAnnounce && source.isRealConnection()) {
            return this.node.nodeUpdater.uom.handleAnnounce(m, source);
        }
        if (spec == DMT.UOMRequestRevocation && source.isRealConnection()) {
            return this.node.nodeUpdater.uom.handleRequestRevocation(m, source);
        }
        if (spec == DMT.UOMSendingRevocation && source.isRealConnection()) {
            return this.node.nodeUpdater.uom.handleSendingRevocation(m, source);
        }
        if (spec == DMT.UOMRequestMain && source.isRealConnection()) {
            return this.node.nodeUpdater.uom.handleRequestJar(m, source, false);
        }
        if (spec == DMT.UOMRequestExtra && source.isRealConnection()) {
            return this.node.nodeUpdater.uom.handleRequestJar(m, source, true);
        }
        if (spec == DMT.UOMSendingMain && source.isRealConnection()) {
            return this.node.nodeUpdater.uom.handleSendingMain(m, source);
        }
        if (spec == DMT.UOMSendingExtra && source.isRealConnection()) {
            return this.node.nodeUpdater.uom.handleSendingExt(m, source);
        }
        if (spec == DMT.FNPOpennetAnnounceRequest) {
            return this.handleAnnounceRequest(m, source);
        }
        if (spec == DMT.FNPRoutingStatus) {
            if (source instanceof DarknetPeerNode) {
                boolean value = m.getBoolean("routingEnabled");
                if (logMINOR) {
                    Logger.minor(this, "The peer (" + source + ") asked us to set routing=" + value);
                }
                ((DarknetPeerNode)source).setRoutingStatus(value, false);
            }
            return true;
        }
        if (source.isRealConnection() && spec == DMT.FNPLocChangeNotificationNew) {
            double newLoc = m.getDouble("location");
            ShortBuffer buffer = (ShortBuffer)m.getObject("peerLocations");
            double[] locs = Fields.bytesToDoubles(buffer.getData());
            if (20 < locs.length && source.isOpennet()) {
                if (locs.length > 40) {
                    Logger.error(this, "We received " + locs.length + " locations from " + source.toString() + "! That should *NOT* happen! Possible attack!");
                    source.forceDisconnect(true);
                    return true;
                }
                Logger.normal(this, "Too many locations from " + source.toString() + " : " + locs.length + " could be an accident, using the first " + 20);
                double[] firstLocs = new double[20];
                System.arraycopy(locs, 0, firstLocs, 0, 20);
                locs = firstLocs;
            }
            source.updateLocation(newLoc, locs);
            return true;
        }
        if (!source.isRoutable()) {
            return false;
        }
        if (logDEBUG) {
            Logger.debug(this, "Not routable");
        }
        if (spec == DMT.FNPNetworkID) {
            source.handleFNPNetworkID(m);
            return true;
        }
        if (spec == DMT.FNPSwapRequest) {
            return this.node.lm.handleSwapRequest(m, source);
        }
        if (spec == DMT.FNPSwapReply) {
            return this.node.lm.handleSwapReply(m, source);
        }
        if (spec == DMT.FNPSwapRejected) {
            return this.node.lm.handleSwapRejected(m, source);
        }
        if (spec == DMT.FNPSwapCommit) {
            return this.node.lm.handleSwapCommit(m, source);
        }
        if (spec == DMT.FNPSwapComplete) {
            return this.node.lm.handleSwapComplete(m, source);
        }
        if (spec == DMT.FNPCHKDataRequest) {
            return this.handleDataRequest(m, source, false);
        }
        if (spec == DMT.FNPSSKDataRequest) {
            return this.handleDataRequest(m, source, true);
        }
        if (spec == DMT.FNPInsertRequest) {
            return this.handleInsertRequest(m, source, false);
        }
        if (spec == DMT.FNPSSKInsertRequest) {
            return this.handleInsertRequest(m, source, true);
        }
        if (spec == DMT.FNPSSKInsertRequestNew) {
            return this.handleInsertRequest(m, source, true);
        }
        if (spec == DMT.FNPRHProbeRequest) {
            return this.handleProbeRequest(m, source);
        }
        if (spec == DMT.FNPRoutedPing) {
            return this.handleRouted(m, source);
        }
        if (spec == DMT.FNPRoutedPong) {
            return this.handleRoutedReply(m);
        }
        if (spec == DMT.FNPRoutedRejected) {
            return this.handleRoutedRejected(m);
        }
        if (spec == DMT.FNPOfferKey) {
            return this.handleOfferKey(m, source);
        }
        if (spec == DMT.FNPGetOfferedKey) {
            return this.handleGetOfferedKey(m, source);
        }
        return false;
    }

    private boolean handleUptime(Message m, PeerNode source) {
        byte uptime = m.getByte("uptimePercent48H");
        source.setUptime(uptime);
        return true;
    }

    private boolean handleOfferKey(Message m, PeerNode source) {
        Key key = (Key)m.getObject("key");
        byte[] authenticator = ((ShortBuffer)m.getObject("offerAuthenticator")).getData();
        this.node.failureTable.onOffer(key, source, authenticator);
        return true;
    }

    private boolean handleGetOfferedKey(Message m, PeerNode source) {
        boolean needPubKey;
        OfferReplyTag tag;
        boolean isSSK;
        long uid;
        Key key;
        block11: {
            key = (Key)m.getObject("key");
            byte[] authenticator = ((ShortBuffer)m.getObject("offerAuthenticator")).getData();
            uid = m.getLong("uid");
            if (!HMAC.verifyWithSHA256(this.node.failureTable.offerAuthenticatorKey, key.getFullKey(), authenticator)) {
                Logger.error(this, "Invalid offer request from " + source + " : authenticator did not verify");
                try {
                    source.sendAsync(DMT.createFNPGetOfferedKeyInvalid(uid, (short)1), null, this.node.failureTable.senderCounter);
                }
                catch (NotConnectedException e) {
                    // empty catch block
                }
                return true;
            }
            if (logMINOR) {
                Logger.minor(this, "Valid GetOfferedKey for " + key + " from " + source);
            }
            isSSK = key instanceof NodeSSK;
            tag = new OfferReplyTag(isSSK);
            this.node.lockUID(uid, isSSK, false, true, false, tag);
            try {
                needPubKey = m.getBoolean("needPubKey");
                String reject = this.nodeStats.shouldRejectRequest(true, false, isSSK, false, true, source);
                if (reject == null) break block11;
                Logger.normal(this, "Rejecting FNPGetOfferedKey from " + source + " for " + key + " : " + reject);
                Message rejected = DMT.createFNPRejectedOverload(uid, true);
                try {
                    source.sendAsync(rejected, null, this.node.failureTable.senderCounter);
                }
                catch (NotConnectedException e) {
                    Logger.normal(this, "Rejecting (overload) data request from " + source.getPeer() + ": " + e);
                }
                this.node.unlockUID(uid, isSSK, false, false, true, false, tag);
                return true;
            }
            catch (Error e) {
                this.node.unlockUID(uid, isSSK, false, false, true, false, tag);
                throw e;
            }
            catch (RuntimeException e) {
                this.node.unlockUID(uid, isSSK, false, false, true, false, tag);
                throw e;
            }
        }
        try {
            this.node.failureTable.sendOfferedKey(key, isSSK, needPubKey, uid, source, tag);
        }
        catch (NotConnectedException e) {
            // empty catch block
        }
        return true;
    }

    private void handleDisconnect(final Message m, final PeerNode source) {
        this.node.getTicker().queueTimedJob(new FastRunnable(){

            public void run() {
                source.sendAnyUrgentNotifications(true);
                NodeDispatcher.this.finishDisconnect(m, source);
            }
        }, 0L);
    }

    private void finishDisconnect(Message m, PeerNode source) {
        OpennetManager om;
        boolean purge;
        source.disconnected(true, true);
        boolean remove = m.getBoolean("remove");
        if (remove) {
            this.node.peers.disconnect(source, false, false, false);
        }
        if ((purge = m.getBoolean("purge")) && (om = this.node.getOpennet()) != null) {
            om.purgeOldOpennetPeer(source);
        }
        int type = m.getInt("nodeToNodeMessageType");
        ShortBuffer messageData = (ShortBuffer)m.getObject("nodeToNodeMessageData");
        if (messageData.getLength() == 0) {
            return;
        }
        this.node.receivedNodeToNodeMessage(source, type, messageData, true);
    }

    private boolean handleTime(Message m, PeerNode source) {
        long delta = m.getLong("time") - System.currentTimeMillis();
        source.setTimeDelta(delta);
        return true;
    }

    private boolean handleDataRequest(Message m, PeerNode source, boolean isSSK) {
        String rejectReason;
        ByteCounter ctr;
        long id = m.getLong("uid");
        ByteCounter byteCounter = ctr = isSSK ? this.node.nodeStats.sskRequestCtr : this.node.nodeStats.chkRequestCtr;
        if (this.node.recentlyCompleted(id)) {
            Message rejected = DMT.createFNPRejectedLoop(id);
            try {
                source.sendAsync(rejected, null, ctr);
            }
            catch (NotConnectedException e) {
                Logger.normal(this, "Rejecting data request (loop, finished): " + e);
            }
            return true;
        }
        short htl = m.getShort("hopsToLive");
        Key key = (Key)m.getObject("freenetRoutingKey");
        RequestTag tag = new RequestTag(isSSK, RequestTag.START.REMOTE);
        if (!this.node.lockUID(id, isSSK, false, false, false, tag)) {
            if (logMINOR) {
                Logger.minor(this, "Could not lock ID " + id + " -> rejecting (already running)");
            }
            Message rejected = DMT.createFNPRejectedLoop(id);
            try {
                source.sendAsync(rejected, null, ctr);
            }
            catch (NotConnectedException e) {
                Logger.normal(this, "Rejecting request from " + source.getPeer() + ": " + e);
            }
            this.node.failureTable.onFinalFailure(key, null, htl, -1, source);
            return true;
        }
        if (logMINOR) {
            Logger.minor(this, "Locked " + id);
        }
        if ((rejectReason = this.nodeStats.shouldRejectRequest(!isSSK, false, isSSK, false, false, source)) != null) {
            Logger.normal(this, "Rejecting " + (isSSK ? "SSK" : "CHK") + " request from " + source.getPeer() + " preemptively because " + rejectReason);
            Message rejected = DMT.createFNPRejectedOverload(id, true);
            try {
                source.sendAsync(rejected, null, ctr);
            }
            catch (NotConnectedException e) {
                Logger.normal(this, "Rejecting (overload) data request from " + source.getPeer() + ": " + e);
            }
            tag.setRejected();
            this.node.unlockUID(id, isSSK, false, false, false, false, tag);
            return true;
        }
        this.nodeStats.reportIncomingRequestLocation(key.toNormalizedDouble());
        RequestHandler rh = new RequestHandler(m, source, id, this.node, htl, key, tag);
        this.node.executor.execute(rh, "RequestHandler for UID " + id + " on " + this.node.getDarknetPortNumber());
        return true;
    }

    private boolean handleInsertRequest(Message m, PeerNode source, boolean isSSK) {
        ByteCounter ctr = isSSK ? this.node.nodeStats.sskInsertCtr : this.node.nodeStats.chkInsertCtr;
        long id = m.getLong("uid");
        if (this.node.recentlyCompleted(id)) {
            Message rejected = DMT.createFNPRejectedLoop(id);
            try {
                source.sendAsync(rejected, null, ctr);
            }
            catch (NotConnectedException e) {
                Logger.normal(this, "Rejecting insert request from " + source.getPeer() + ": " + e);
            }
            return true;
        }
        InsertTag tag = new InsertTag(isSSK, InsertTag.START.REMOTE);
        if (!this.node.lockUID(id, isSSK, true, false, false, tag)) {
            if (logMINOR) {
                Logger.minor(this, "Could not lock ID " + id + " -> rejecting (already running)");
            }
            Message rejected = DMT.createFNPRejectedLoop(id);
            try {
                source.sendAsync(rejected, null, ctr);
            }
            catch (NotConnectedException e) {
                Logger.normal(this, "Rejecting insert request from " + source.getPeer() + ": " + e);
            }
            return true;
        }
        String rejectReason = this.nodeStats.shouldRejectRequest(!isSSK, true, isSSK, false, false, source);
        if (rejectReason != null) {
            Logger.normal(this, "Rejecting insert from " + source.getPeer() + " preemptively because " + rejectReason);
            Message rejected = DMT.createFNPRejectedOverload(id, true);
            try {
                source.sendAsync(rejected, null, ctr);
            }
            catch (NotConnectedException e) {
                Logger.normal(this, "Rejecting (overload) insert request from " + source.getPeer() + ": " + e);
            }
            this.node.unlockUID(id, isSSK, true, false, false, false, tag);
            return true;
        }
        long now = System.currentTimeMillis();
        if (m.getSpec().equals(DMT.FNPSSKInsertRequest)) {
            NodeSSK key = (NodeSSK)m.getObject("freenetRoutingKey");
            byte[] data = ((ShortBuffer)m.getObject("data")).getData();
            byte[] headers = ((ShortBuffer)m.getObject("blockHeaders")).getData();
            short htl = m.getShort("hopsToLive");
            SSKInsertHandler rh = new SSKInsertHandler(key, data, headers, htl, source, id, this.node, now, tag);
            rh.receivedBytes(m.receivedByteCount());
            this.node.executor.execute(rh, "SSKInsertHandler for " + id + " on " + this.node.getDarknetPortNumber());
        } else if (m.getSpec().equals(DMT.FNPSSKInsertRequestNew)) {
            NodeSSK key = (NodeSSK)m.getObject("freenetRoutingKey");
            short htl = m.getShort("hopsToLive");
            SSKInsertHandler rh = new SSKInsertHandler(key, null, null, htl, source, id, this.node, now, tag);
            rh.receivedBytes(m.receivedByteCount());
            this.node.executor.execute(rh, "SSKInsertHandler for " + id + " on " + this.node.getDarknetPortNumber());
        } else {
            CHKInsertHandler rh = new CHKInsertHandler(m, source, id, this.node, now, tag);
            this.node.executor.execute(rh, "CHKInsertHandler for " + id + " on " + this.node.getDarknetPortNumber());
        }
        if (logMINOR) {
            Logger.minor(this, "Started InsertHandler for " + id);
        }
        return true;
    }

    private boolean handleProbeRequest(Message m, PeerNode source) {
        long id = m.getLong("uid");
        if (this.node.recentlyCompleted(id)) {
            Message rejected = DMT.createFNPRejectedLoop(id);
            try {
                source.sendAsync(rejected, null, this.node.nodeStats.probeRequestCtr);
            }
            catch (NotConnectedException e) {
                Logger.normal(this, "Rejecting probe request from " + source.getPeer() + ": " + e);
            }
            return true;
        }
        this.node.completed(id);
        if (source.shouldRejectProbeRequest()) {
            Logger.normal(this, "Rejecting probe request from " + source.getPeer());
            Message rejected = DMT.createFNPRejectedOverload(id, true);
            try {
                source.sendAsync(rejected, null, this.node.nodeStats.probeRequestCtr);
            }
            catch (NotConnectedException e) {
                Logger.normal(this, "Rejecting (overload) insert request from " + source.getPeer() + ": " + e);
            }
            return true;
        }
        double target = m.getDouble("targetLocation");
        if (target > 1.0 || target < 0.0) {
            Logger.normal(this, "Rejecting invalid (target=" + target + ") probe request from " + source.getPeer());
            Message rejected = DMT.createFNPRejectedOverload(id, true);
            try {
                source.sendAsync(rejected, null, this.node.nodeStats.probeRequestCtr);
            }
            catch (NotConnectedException e) {
                Logger.normal(this, "Rejecting (invalid) insert request from " + source.getPeer() + ": " + e);
            }
            return true;
        }
        ProbeRequestHandler.start(m, source, this.node, target);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleAnnounceRequest(Message m, PeerNode source) {
        boolean bl;
        block13: {
            boolean success;
            OpennetManager om;
            long uid;
            block11: {
                boolean bl2;
                block12: {
                    uid = m.getLong("uid");
                    om = this.node.getOpennet();
                    if (om == null || !source.canAcceptAnnouncements()) {
                        Message msg = DMT.createFNPOpennetDisabled(uid);
                        try {
                            source.sendAsync(msg, null, this.node.nodeStats.announceByteCounter);
                        }
                        catch (NotConnectedException e) {
                            // empty catch block
                        }
                        return true;
                    }
                    if (this.node.recentlyCompleted(uid)) {
                        Message msg = DMT.createFNPRejectedLoop(uid);
                        try {
                            source.sendAsync(msg, null, this.node.nodeStats.announceByteCounter);
                        }
                        catch (NotConnectedException e) {
                            // empty catch block
                        }
                        return true;
                    }
                    success = false;
                    this.node.completed(uid);
                    try {
                        if (source.shouldAcceptAnnounce(uid)) break block11;
                        Message msg = DMT.createFNPRejectedOverload(uid, true);
                        try {
                            source.sendAsync(msg, null, this.node.nodeStats.announceByteCounter);
                        }
                        catch (NotConnectedException e) {
                            // empty catch block
                        }
                        bl2 = true;
                        Object var10_15 = null;
                        if (success) break block12;
                        source.completedAnnounce(uid);
                    }
                    catch (Throwable throwable) {
                        block14: {
                            Object var10_17 = null;
                            if (success) break block14;
                            source.completedAnnounce(uid);
                        }
                        throw throwable;
                    }
                }
                return bl2;
            }
            AnnounceSender sender = new AnnounceSender(m, uid, source, om, this.node);
            this.node.executor.execute(sender, "Announcement sender for " + uid);
            success = true;
            bl = true;
            Object var10_16 = null;
            if (success) break block13;
            source.completedAnnounce(uid);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long now = System.currentTimeMillis();
        Hashtable<Long, RoutedContext> hashtable = this.routedContexts;
        synchronized (hashtable) {
            Iterator<RoutedContext> i = this.routedContexts.values().iterator();
            while (i.hasNext()) {
                RoutedContext rc = i.next();
                if (now - rc.createdTime <= 20000L) continue;
                i.remove();
            }
        }
        this.node.getTicker().queueTimedJob(this, 20000L);
    }

    private boolean handleRoutedRejected(Message m) {
        short ohtl;
        long id = m.getLong("uid");
        Long lid = id;
        RoutedContext rc = this.routedContexts.get(lid);
        if (rc == null) {
            Logger.error(this, "Unrecognized FNPRoutedRejected");
            return false;
        }
        short htl = rc.lastHtl;
        if (rc.source != null) {
            htl = rc.source.decrementHTL(htl);
        }
        if ((ohtl = m.getShort("hopsToLive")) < htl) {
            htl = ohtl;
        }
        if (htl == 0) {
            if (rc.source != null) {
                try {
                    rc.source.sendAsync(DMT.createFNPRoutedRejected(id, (short)0), null, this.nodeStats.routedMessageCtr);
                }
                catch (NotConnectedException e) {
                    Logger.error(this, "Unable to relay probe DNF: peer disconnected: " + rc.source);
                }
            }
        } else {
            this.forward(rc.msg, id, rc.source, htl, rc.msg.getDouble("targetLocation"), rc, rc.identity);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean handleRouted(Message m, PeerNode source) {
        RoutedContext ctx;
        if (logMINOR) {
            Logger.minor(this, "handleRouted(" + m + ')');
        }
        long id = m.getLong("uid");
        Long lid = id;
        short htl = m.getShort("hopsToLive");
        byte[] identity = ((ShortBuffer)m.getObject("nodeIdentity")).getData();
        if (source != null) {
            htl = source.decrementHTL(htl);
        }
        if ((ctx = this.routedContexts.get(lid)) != null) {
            block15: {
                try {
                    source.sendAsync(DMT.createFNPRoutedRejected(id, htl), null, this.nodeStats.routedMessageCtr);
                }
                catch (NotConnectedException e) {
                    if (!logMINOR) break block15;
                    Logger.minor(this, "Lost connection rejecting " + m);
                }
            }
            return true;
        }
        ctx = new RoutedContext(m, source, identity);
        Hashtable<Long, RoutedContext> e = this.routedContexts;
        synchronized (e) {
            this.routedContexts.put(lid, ctx);
        }
        double target = m.getDouble("targetLocation");
        if (logMINOR) {
            Logger.minor(this, "id " + id + " from " + source + " htl " + htl + " target " + target);
        }
        if (Math.abs(this.node.lm.getLocation() - target) <= Double.MIN_VALUE) {
            if (logMINOR) {
                Logger.minor(this, "Dispatching " + m.getSpec() + " on " + this.node.getDarknetPortNumber());
            }
            this.dispatchRoutedMessage(m, source, id);
            return true;
        }
        if (htl == 0) {
            block16: {
                Message reject = DMT.createFNPRoutedRejected(id, (short)0);
                if (source != null) {
                    try {
                        source.sendAsync(reject, null, this.nodeStats.routedMessageCtr);
                    }
                    catch (NotConnectedException e2) {
                        if (!logMINOR) break block16;
                        Logger.minor(this, "Lost connection rejecting " + m);
                    }
                }
            }
            return true;
        }
        return this.forward(m, id, source, htl, target, ctx, identity);
    }

    boolean handleRoutedReply(Message m) {
        block5: {
            Long lid;
            RoutedContext ctx;
            long id = m.getLong("uid");
            if (logMINOR) {
                Logger.minor(this, "Got reply: " + m);
            }
            if ((ctx = this.routedContexts.get(lid = Long.valueOf(id))) == null) {
                Logger.error(this, "Unrecognized routed reply: " + m);
                return false;
            }
            PeerNode pn = ctx.source;
            if (pn == null) {
                return false;
            }
            try {
                pn.sendAsync(m, null, this.nodeStats.routedMessageCtr);
            }
            catch (NotConnectedException e) {
                if (!logMINOR) break block5;
                Logger.minor(this, "Lost connection forwarding " + m + " to " + pn);
            }
        }
        return true;
    }

    private boolean forward(Message m, long id, PeerNode pn, short htl, double target, RoutedContext ctx, byte[] targetIdentity) {
        block12: {
            if (logMINOR) {
                Logger.minor(this, "Should forward");
            }
            m = this.preForward(m, htl);
            while (true) {
                PeerNode next;
                if ((next = this.node.peers.getByIdentity(targetIdentity)) != null && !next.isConnected()) {
                    Logger.error(this, "Found target but disconnected!: " + next);
                    next = null;
                }
                if (next == null) {
                    next = this.node.peers.closerPeer(pn, ctx.routedTo, target, true, this.node.isAdvancedModeEnabled(), -1, null, null);
                }
                if (logMINOR) {
                    Logger.minor(this, "Next: " + next + " message: " + m);
                }
                if (next == null) break;
                if (logMINOR) {
                    Logger.minor(this, "Forwarding " + m.getSpec() + " to " + next.getPeer().getPort());
                }
                ctx.addSent(next);
                try {
                    next.sendAsync(m, null, this.nodeStats.routedMessageCtr);
                    break block12;
                }
                catch (NotConnectedException e) {
                    continue;
                }
                break;
            }
            if (logMINOR) {
                Logger.minor(this, "Reached dead end for " + m.getSpec() + " on " + this.node.getDarknetPortNumber());
            }
            Message reject = DMT.createFNPRoutedRejected(id, htl);
            if (pn != null) {
                try {
                    pn.sendAsync(reject, null, this.nodeStats.routedMessageCtr);
                }
                catch (NotConnectedException e) {
                    Logger.error(this, "Cannot send reject message back to source " + pn);
                    return true;
                }
            }
        }
        return true;
    }

    private Message preForward(Message m, short newHTL) {
        m.set("hopsToLive", newHTL);
        if (m.getSpec() == DMT.FNPRoutedPing) {
            int x = m.getInt("counter");
            m.set("counter", ++x);
        }
        return m;
    }

    private boolean dispatchRoutedMessage(Message m, PeerNode src, long id) {
        if (m.getSpec() == DMT.FNPRoutedPing) {
            block5: {
                if (logMINOR) {
                    Logger.minor(this, "RoutedPing reached other side! (" + id + ")");
                }
                int x = m.getInt("counter");
                Message reply = DMT.createFNPRoutedPong(id, x);
                if (logMINOR) {
                    Logger.minor(this, "Replying - counter = " + x + " for " + id);
                }
                try {
                    src.sendAsync(reply, null, this.nodeStats.routedMessageCtr);
                }
                catch (NotConnectedException e) {
                    if (!logMINOR) break block5;
                    Logger.minor(this, "Lost connection replying to " + m + " in dispatchRoutedMessage");
                }
            }
            return true;
        }
        return false;
    }

    void start(NodeStats stats) {
        this.nodeStats = stats;
    }

    public static String peersUIDsToString(long[] peerUIDs, double[] peerLocs) {
        StringBuilder sb;
        block4: {
            int i;
            int min;
            block3: {
                sb = new StringBuilder(peerUIDs.length * 23 + peerLocs.length * 26);
                min = Math.min(peerUIDs.length, peerLocs.length);
                for (i = 0; i < min; ++i) {
                    double loc = peerLocs[i];
                    long uid = peerUIDs[i];
                    sb.append(loc);
                    sb.append('=');
                    sb.append(uid);
                    if (i == min - 1) continue;
                    sb.append('|');
                }
                if (peerUIDs.length <= min) break block3;
                for (i = min; i < peerUIDs.length; ++i) {
                    sb.append("|U:");
                    sb.append(peerUIDs[i]);
                }
                break block4;
            }
            if (peerLocs.length <= min) break block4;
            for (i = min; i < peerLocs.length; ++i) {
                sb.append("|L:");
                sb.append(peerLocs[i]);
            }
        }
        return sb.toString();
    }

    public void startProbe(final double target, final ProbeCallback cb) {
        final long uid = this.node.random.nextLong();
        ProbeRequestSender rs = new ProbeRequestSender(target, this.node.maxHTL(), uid, this.node, this.node.getLocation(), null, 2.0);
        rs.addListener(new ProbeRequestSender.Listener(){

            public void onCompletion(double nearest, double best, short counter, short uniqueCounter, short linearCounter) throws NotConnectedException {
                cb.onCompleted("completed", target, best, nearest, uid, counter, uniqueCounter, linearCounter);
            }

            public void onRNF(short htl, double nearest, double best, short counter, short uniqueCounter, short linearCounter) throws NotConnectedException {
                cb.onCompleted("rnf", target, best, nearest, uid, counter, uniqueCounter, linearCounter);
            }

            public void onReceivedRejectOverload(double nearest, double best, short counter, short uniqueCounter, short linearCounter, String reason) throws NotConnectedException {
                cb.onRejectOverload();
            }

            public void onTimeout(double nearest, double best, short counter, short uniqueCounter, short linearCounter, String reason) throws NotConnectedException {
                cb.onCompleted("timeout", target, best, nearest, uid, counter, uniqueCounter, linearCounter);
            }

            public void onTrace(long uid2, double nearest, double best, short htl, short counter, short uniqueCounter, double location, long myUID, ShortBuffer peerLocs, ShortBuffer peerUIDs, short forkCount, short linearCounter, String reason, long prevUID) throws NotConnectedException {
                cb.onTrace(uid2, target, nearest, best, htl, counter, location, myUID, Fields.bytesToDoubles(peerLocs.getData()), Fields.bytesToLongs(peerUIDs.getData()), new double[0], forkCount, linearCounter, reason, prevUID);
            }
        });
        rs.start();
    }

    public void setHook(NodeDispatcherCallback cb) {
        this.callback = cb;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
                logDEBUG = Logger.shouldLog(2, this);
            }
        });
    }

    static class RoutedContext {
        long createdTime;
        long accessTime;
        PeerNode source;
        final HashSet<PeerNode> routedTo;
        Message msg;
        short lastHtl;
        final byte[] identity;

        RoutedContext(Message msg, PeerNode source, byte[] identity) {
            this.createdTime = this.accessTime = System.currentTimeMillis();
            this.source = source;
            this.routedTo = new HashSet();
            this.msg = msg;
            this.lastHtl = msg.getShort("hopsToLive");
            this.identity = identity;
        }

        void addSent(PeerNode n) {
            this.routedTo.add(n);
        }
    }

    public static interface NodeDispatcherCallback {
        public void snoop(Message var1, Node var2);
    }
}

