/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.config.InvalidConfigValueException;
import freenet.config.NodeNeedRestartException;
import freenet.config.SubConfig;
import freenet.io.comm.FreenetInetAddress;
import freenet.node.NodeCrypto;
import freenet.node.NodeInitException;
import freenet.node.SecurityLevelListener;
import freenet.node.SecurityLevels;
import freenet.support.Logger;
import freenet.support.api.BooleanCallback;
import freenet.support.api.IntCallback;
import freenet.support.api.StringCallback;
import java.net.UnknownHostException;

public class NodeCryptoConfig {
    private int portNumber;
    private FreenetInetAddress bindTo;
    private int dropProbability;
    private NodeCrypto crypto;
    private boolean oneConnectionPerAddress;
    private boolean alwaysAllowLocalAddresses;
    private boolean assumeNATed;
    public boolean includeLocalAddressesInNoderefs;
    private boolean paddDataPackets;
    public static final int OPTION_COUNT = 3;

    NodeCryptoConfig(SubConfig config, int sortOrder, boolean isOpennet, SecurityLevels securityLevels) throws NodeInitException {
        config.register("listenPort", -1, sortOrder++, true, true, "Node.port", "Node.portLong", new IntCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Integer get() {
                Class<NodeCryptoConfig> clazz = NodeCryptoConfig.class;
                synchronized (NodeCryptoConfig.class) {
                    if (NodeCryptoConfig.this.crypto != null) {
                        NodeCryptoConfig.this.portNumber = ((NodeCryptoConfig)NodeCryptoConfig.this).crypto.portNumber;
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return NodeCryptoConfig.this.portNumber;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void set(Integer val) throws InvalidConfigValueException {
                if (NodeCryptoConfig.this.portNumber < -1 || NodeCryptoConfig.this.portNumber == 0 || NodeCryptoConfig.this.portNumber > 65535) {
                    throw new InvalidConfigValueException("Invalid port number");
                }
                Class<NodeCryptoConfig> clazz = NodeCryptoConfig.class;
                synchronized (NodeCryptoConfig.class) {
                    if (NodeCryptoConfig.this.portNumber == val) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                    if (NodeCryptoConfig.this.crypto != null) {
                        throw new InvalidConfigValueException("Switching listenPort on the fly not yet supported");
                    }
                    NodeCryptoConfig.this.portNumber = val;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            public boolean isReadOnly() {
                return true;
            }
        }, false);
        try {
            this.portNumber = config.getInt("listenPort");
        }
        catch (Exception e) {
            Logger.error(this, "Caught " + e, e);
            System.err.println(e);
            e.printStackTrace();
            this.portNumber = -1;
        }
        config.register("bindTo", "0.0.0.0", sortOrder++, true, true, "Node.bindTo", "Node.bindToLong", new NodeBindtoCallback());
        try {
            this.bindTo = new FreenetInetAddress(config.getString("bindTo"), false);
        }
        catch (UnknownHostException e) {
            throw new NodeInitException(9, "Invalid bindTo: " + config.getString("bindTo"));
        }
        config.register("testingDropPacketsEvery", 0, sortOrder++, true, false, "Node.dropPacketEvery", "Node.dropPacketEveryLong", new IntCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Integer get() {
                NodeCryptoConfig nodeCryptoConfig = NodeCryptoConfig.this;
                synchronized (nodeCryptoConfig) {
                    return NodeCryptoConfig.this.dropProbability;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void set(Integer val) throws InvalidConfigValueException {
                if (val < 0) {
                    throw new InvalidConfigValueException("testingDropPacketsEvery must not be negative");
                }
                NodeCryptoConfig nodeCryptoConfig = NodeCryptoConfig.this;
                synchronized (nodeCryptoConfig) {
                    if (val == NodeCryptoConfig.this.dropProbability) {
                        return;
                    }
                    NodeCryptoConfig.this.dropProbability = val;
                    if (NodeCryptoConfig.this.crypto == null) {
                        return;
                    }
                }
                NodeCryptoConfig.this.crypto.onSetDropProbability(val);
            }
        }, false);
        this.dropProbability = config.getInt("testingDropPacketsEvery");
        config.register("oneConnectionPerIP", isOpennet, sortOrder++, true, false, "Node.oneConnectionPerIP", "Node.oneConnectionPerIPLong", new BooleanCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean get() {
                NodeCryptoConfig nodeCryptoConfig = NodeCryptoConfig.this;
                synchronized (nodeCryptoConfig) {
                    return NodeCryptoConfig.this.oneConnectionPerAddress;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void set(Boolean val) throws InvalidConfigValueException {
                NodeCryptoConfig nodeCryptoConfig = NodeCryptoConfig.this;
                synchronized (nodeCryptoConfig) {
                    NodeCryptoConfig.this.oneConnectionPerAddress = val;
                }
            }
        });
        this.oneConnectionPerAddress = config.getBoolean("oneConnectionPerIP");
        if (isOpennet) {
            securityLevels.addNetworkThreatLevelListener(new SecurityLevelListener<SecurityLevels.NETWORK_THREAT_LEVEL>(){

                @Override
                public void onChange(SecurityLevels.NETWORK_THREAT_LEVEL oldLevel, SecurityLevels.NETWORK_THREAT_LEVEL newLevel) {
                    if (newLevel == SecurityLevels.NETWORK_THREAT_LEVEL.LOW) {
                        NodeCryptoConfig.this.oneConnectionPerAddress = false;
                    }
                    if (oldLevel == SecurityLevels.NETWORK_THREAT_LEVEL.LOW) {
                        NodeCryptoConfig.this.oneConnectionPerAddress = true;
                    }
                }
            });
        }
        config.register("alwaysAllowLocalAddresses", !isOpennet, sortOrder++, true, false, "Node.alwaysAllowLocalAddresses", "Node.alwaysAllowLocalAddressesLong", new BooleanCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean get() {
                NodeCryptoConfig nodeCryptoConfig = NodeCryptoConfig.this;
                synchronized (nodeCryptoConfig) {
                    return NodeCryptoConfig.this.alwaysAllowLocalAddresses;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void set(Boolean val) throws InvalidConfigValueException {
                NodeCryptoConfig nodeCryptoConfig = NodeCryptoConfig.this;
                synchronized (nodeCryptoConfig) {
                    NodeCryptoConfig.this.alwaysAllowLocalAddresses = val;
                }
            }
        });
        this.alwaysAllowLocalAddresses = config.getBoolean("alwaysAllowLocalAddresses");
        if (!isOpennet) {
            securityLevels.addFriendsThreatLevelListener(new SecurityLevelListener<SecurityLevels.FRIENDS_THREAT_LEVEL>(){

                @Override
                public void onChange(SecurityLevels.FRIENDS_THREAT_LEVEL oldLevel, SecurityLevels.FRIENDS_THREAT_LEVEL newLevel) {
                    if (newLevel == SecurityLevels.FRIENDS_THREAT_LEVEL.HIGH) {
                        NodeCryptoConfig.this.alwaysAllowLocalAddresses = false;
                    }
                    if (oldLevel == SecurityLevels.FRIENDS_THREAT_LEVEL.HIGH) {
                        NodeCryptoConfig.this.alwaysAllowLocalAddresses = false;
                    }
                }
            });
        }
        config.register("assumeNATed", true, sortOrder++, true, true, "Node.assumeNATed", "Node.assumeNATedLong", new BooleanCallback(){

            public Boolean get() {
                return NodeCryptoConfig.this.assumeNATed;
            }

            public void set(Boolean val) throws InvalidConfigValueException {
                NodeCryptoConfig.this.assumeNATed = val;
            }
        });
        this.assumeNATed = config.getBoolean("assumeNATed");
        config.register("includeLocalAddressesInNoderefs", !isOpennet, sortOrder++, true, false, "NodeIPDectector.inclLocalAddress", "NodeIPDectector.inclLocalAddressLong", new BooleanCallback(){

            public Boolean get() {
                return NodeCryptoConfig.this.includeLocalAddressesInNoderefs;
            }

            public void set(Boolean val) throws InvalidConfigValueException {
                NodeCryptoConfig.this.includeLocalAddressesInNoderefs = val;
            }
        });
        this.includeLocalAddressesInNoderefs = config.getBoolean("includeLocalAddressesInNoderefs");
        config.register("paddDataPackets", true, sortOrder++, true, false, "Node.paddDataPackets", "Node.paddDataPacketsLong", new BooleanCallback(){

            public Boolean get() {
                return NodeCryptoConfig.this.paddDataPackets;
            }

            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                if (val.equals(this.get())) {
                    return;
                }
                NodeCryptoConfig.this.paddDataPackets = val;
            }
        });
        this.paddDataPackets = config.getBoolean("paddDataPackets");
        securityLevels.addNetworkThreatLevelListener(new SecurityLevelListener<SecurityLevels.NETWORK_THREAT_LEVEL>(){

            @Override
            public void onChange(SecurityLevels.NETWORK_THREAT_LEVEL oldLevel, SecurityLevels.NETWORK_THREAT_LEVEL newLevel) {
                if (newLevel == SecurityLevels.NETWORK_THREAT_LEVEL.LOW) {
                    NodeCryptoConfig.this.paddDataPackets = false;
                }
                if (oldLevel == SecurityLevels.NETWORK_THREAT_LEVEL.LOW) {
                    NodeCryptoConfig.this.paddDataPackets = true;
                }
            }
        });
    }

    synchronized void starting(NodeCrypto crypto2) {
        if (this.crypto != null) {
            throw new IllegalStateException("Replacing existing NodeCrypto " + this.crypto + " with " + crypto2);
        }
        this.crypto = crypto2;
    }

    synchronized void started(NodeCrypto crypto2) {
        if (this.crypto != null) {
            throw new IllegalStateException("Replacing existing NodeCrypto " + this.crypto + " with " + crypto2);
        }
    }

    synchronized void maybeStarted(NodeCrypto crypto2) {
    }

    synchronized void stopping(NodeCrypto crypto2) {
        this.crypto = null;
    }

    public synchronized int getPort() {
        return this.portNumber;
    }

    public synchronized FreenetInetAddress getBindTo() {
        return this.bindTo;
    }

    public synchronized void setPort(int port) {
        this.portNumber = port;
    }

    public synchronized int getDropProbability() {
        return this.dropProbability;
    }

    public synchronized boolean oneConnectionPerAddress() {
        return this.oneConnectionPerAddress;
    }

    public synchronized boolean alwaysAllowLocalAddresses() {
        return this.alwaysAllowLocalAddresses;
    }

    public boolean alwaysHandshakeAggressively() {
        return this.assumeNATed;
    }

    public boolean includeLocalAddressesInNoderefs() {
        return this.includeLocalAddressesInNoderefs;
    }

    public boolean paddDataPackets() {
        return this.paddDataPackets;
    }

    class NodeBindtoCallback
    extends StringCallback {
        NodeBindtoCallback() {
        }

        public String get() {
            return NodeCryptoConfig.this.bindTo.toString();
        }

        public void set(String val) throws InvalidConfigValueException {
            if (val.equals(this.get())) {
                return;
            }
            throw new InvalidConfigValueException("Cannot be updated on the fly");
        }

        public boolean isReadOnly() {
            return true;
        }
    }
}

