/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Predicate;
import freenet.crypt.BlockCipher;
import freenet.crypt.DSA;
import freenet.crypt.DSAGroup;
import freenet.crypt.DSAPrivateKey;
import freenet.crypt.DSAPublicKey;
import freenet.crypt.DSASignature;
import freenet.crypt.Global;
import freenet.crypt.RandomSource;
import freenet.crypt.SHA256;
import freenet.crypt.UnsupportedCipherException;
import freenet.crypt.ciphers.Rijndael;
import freenet.io.comm.FreenetInetAddress;
import freenet.io.comm.Peer;
import freenet.io.comm.UdpSocketHandler;
import freenet.keys.FreenetURI;
import freenet.keys.InsertableClientSSK;
import freenet.node.FNPPacketMangler;
import freenet.node.FSParseException;
import freenet.node.HandlePortTuple;
import freenet.node.Node;
import freenet.node.NodeCryptoConfig;
import freenet.node.NodeIPPortDetector;
import freenet.node.NodeInitException;
import freenet.node.PeerNode;
import freenet.node.Version;
import freenet.support.Base64;
import freenet.support.Fields;
import freenet.support.IllegalBase64Exception;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.io.Closer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.zip.DeflaterOutputStream;
import net.i2p.util.NativeBigInteger;

public class NodeCrypto {
    public static final int IDENTITY_LENGTH = 32;
    final Node node;
    final boolean isOpennet;
    final RandomSource random;
    UdpSocketHandler socket;
    public FNPPacketMangler packetMangler;
    final int portNumber;
    byte[] myIdentity;
    byte[] identityHash;
    byte[] identityHashHash;
    byte[] clientNonce;
    private DSAGroup cryptoGroup;
    private DSAPrivateKey privKey;
    private DSAPublicKey pubKey;
    InsertableClientSSK myARK;
    long myARKNumber;
    static boolean logMINOR;
    final NodeCryptoConfig config;
    final NodeIPPortDetector detector;
    final BlockCipher anonSetupCipher;
    private String mySignedReference = null;
    private DSASignature myReferenceSignature = null;
    private volatile Object referenceSync = new Object();

    public NodeCrypto(Node node, boolean isOpennet, NodeCryptoConfig config, long startupTime, boolean enableARKs) throws NodeInitException {
        this.node = node;
        this.config = config;
        this.random = node.random;
        this.isOpennet = isOpennet;
        logMINOR = Logger.shouldLog(4, this);
        config.starting(this);
        try {
            try {
                int port = config.getPort();
                FreenetInetAddress bindto = config.getBindTo();
                UdpSocketHandler u = null;
                if (port > 65535) {
                    throw new NodeInitException(10, "Impossible port number: " + port);
                }
                if (port == -1) {
                    for (int i = 0; i < 200000; ++i) {
                        int portNo = 1024 + this.random.nextInt(64511);
                        try {
                            u = new UdpSocketHandler(portNo, bindto.getAddress(), node, startupTime, this.getTitle(portNo), node.collector);
                            port = u.getPortNumber();
                            break;
                        }
                        catch (Exception e) {
                            Logger.normal(this, "Could not use port: " + bindto + ':' + portNo + ": " + e, e);
                            System.err.println("Could not use port: " + bindto + ':' + portNo + ": " + e);
                            e.printStackTrace();
                            continue;
                        }
                    }
                    if (u == null) {
                        throw new NodeInitException(11, "Could not find an available UDP port number for FNP (none specified)");
                    }
                } else {
                    try {
                        u = new UdpSocketHandler(port, bindto.getAddress(), node, startupTime, this.getTitle(port), node.collector);
                    }
                    catch (Exception e) {
                        Logger.error(this, "Caught " + e, e);
                        System.err.println(e);
                        e.printStackTrace();
                        throw new NodeInitException(10, "Could not bind to port: " + port + " (node already running?)");
                    }
                }
                this.socket = u;
                Logger.normal(this, "FNP port created on " + bindto + ':' + port);
                System.out.println("FNP port created on " + bindto + ':' + port);
                this.portNumber = port;
                config.setPort(port);
                this.socket.setDropProbability(config.getDropProbability());
                this.packetMangler = new FNPPacketMangler(node, this, this.socket);
                this.socket.setLowLevelFilter(this.packetMangler);
                this.detector = new NodeIPPortDetector(node, node.ipDetector, this, enableARKs);
                this.anonSetupCipher = new Rijndael(256, 256);
            }
            catch (NodeInitException e) {
                config.stopping(this);
                throw e;
            }
            catch (RuntimeException e) {
                config.stopping(this);
                throw e;
            }
            catch (Error e) {
                config.stopping(this);
                throw e;
            }
            catch (UnsupportedCipherException e) {
                config.stopping(this);
                throw new Error(e);
            }
            Object var14_17 = null;
            config.maybeStarted(this);
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            config.maybeStarted(this);
            throw throwable;
        }
    }

    private String getTitle(int port) {
        return "UDP " + (this.isOpennet ? "Opennet " : "Darknet ") + "port " + port;
    }

    public void readCrypto(SimpleFieldSet fs) throws IOException {
        String identity = fs.get("identity");
        if (identity == null) {
            throw new IOException();
        }
        try {
            this.myIdentity = Base64.decode(identity);
        }
        catch (IllegalBase64Exception e2) {
            throw new IOException();
        }
        this.identityHash = SHA256.digest(this.myIdentity);
        this.anonSetupCipher.initialize(this.identityHash);
        this.identityHashHash = SHA256.digest(this.identityHash);
        try {
            this.cryptoGroup = DSAGroup.create(fs.subset("dsaGroup"));
            this.privKey = DSAPrivateKey.create(fs.subset("dsaPrivKey"), this.cryptoGroup);
            this.pubKey = DSAPublicKey.create(fs.subset("dsaPubKey"), this.cryptoGroup);
        }
        catch (IllegalBase64Exception e) {
            Logger.error(this, "Caught " + e, e);
            throw new IOException(e.toString());
        }
        catch (FSParseException e) {
            Logger.error(this, "Caught " + e, e);
            throw new IOException(e.toString());
        }
        InsertableClientSSK ark = null;
        String s = fs.get("ark.number");
        String privARK = fs.get("ark.privURI");
        try {
            if (privARK != null) {
                FreenetURI uri = new FreenetURI(privARK);
                ark = InsertableClientSSK.create(uri);
                if (s == null) {
                    ark = null;
                    this.myARKNumber = 0L;
                } else {
                    try {
                        this.myARKNumber = Long.parseLong(s);
                    }
                    catch (NumberFormatException e) {
                        this.myARKNumber = 0L;
                        ark = null;
                    }
                }
            }
        }
        catch (MalformedURLException e) {
            Logger.minor(this, "Caught " + e, (Throwable)e);
            ark = null;
        }
        if (ark == null) {
            ark = InsertableClientSSK.createRandom(this.random, "ark");
            this.myARKNumber = 0L;
        }
        this.myARK = ark;
        String cn = fs.get("clientNonce");
        if (cn != null) {
            try {
                this.clientNonce = Base64.decode(cn);
            }
            catch (IllegalBase64Exception e) {
                throw new IOException("Invalid clientNonce field: " + e);
            }
        } else {
            this.clientNonce = new byte[32];
            this.node.random.nextBytes(this.clientNonce);
        }
    }

    public void initCrypto() {
        this.myIdentity = new byte[32];
        this.random.nextBytes(this.myIdentity);
        MessageDigest md = SHA256.getMessageDigest();
        this.identityHash = md.digest(this.myIdentity);
        this.identityHashHash = md.digest(this.identityHash);
        this.cryptoGroup = Global.DSAgroupBigA;
        this.privKey = new DSAPrivateKey(this.cryptoGroup, this.random);
        this.pubKey = new DSAPublicKey(this.cryptoGroup, this.privKey);
        this.myARK = InsertableClientSSK.createRandom(this.random, "ark");
        this.myARKNumber = 0L;
        SHA256.returnMessageDigest(md);
        this.anonSetupCipher.initialize(this.identityHash);
        this.clientNonce = new byte[32];
        this.node.random.nextBytes(this.clientNonce);
    }

    public void start() {
        this.packetMangler.start();
        this.socket.start();
    }

    public SimpleFieldSet exportPrivateFieldSet() {
        SimpleFieldSet fs = this.exportPublicFieldSet(false, false, false);
        this.addPrivateFields(fs);
        return fs;
    }

    public SimpleFieldSet exportPublicFieldSet() {
        return this.exportPublicFieldSet(false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SimpleFieldSet exportPublicFieldSet(boolean forSetup, boolean forAnonInitiator, boolean forARK) {
        Peer[] ips;
        SimpleFieldSet fs = this.exportPublicCryptoFieldSet(forSetup || forARK, forAnonInitiator);
        if (!forAnonInitiator && !forSetup && (ips = this.detector.detectPrimaryPeers()) != null) {
            for (int i = 0; i < ips.length; ++i) {
                fs.putAppend("physical.udp", ips[i].toString());
            }
        }
        fs.putSingle("version", Version.getVersionString());
        if (!forAnonInitiator) {
            fs.putSingle("lastGoodVersion", Version.getLastGoodVersionString());
        }
        if (this.node.testnetEnabled) {
            fs.put("testnet", true);
            fs.put("testnetPort", this.node.testnetHandler.getPort());
        }
        if (!(this.isOpennet || forSetup || forARK)) {
            fs.putSingle("myName", this.node.getMyName());
        }
        if (!forAnonInitiator) {
            fs.put("opennet", this.isOpennet);
            Object object = this.referenceSync;
            synchronized (object) {
                if (this.myReferenceSignature == null || this.mySignedReference == null || !this.mySignedReference.equals(fs.toOrderedString())) {
                    this.mySignedReference = fs.toOrderedString();
                    try {
                        this.myReferenceSignature = this.signRef(this.mySignedReference);
                    }
                    catch (NodeInitException e) {
                        this.node.exit(e.exitCode);
                    }
                }
                fs.putSingle("sig", this.myReferenceSignature.toLongString());
            }
        }
        if (logMINOR) {
            Logger.minor(this, "My reference: " + fs.toOrderedString());
        }
        return fs;
    }

    SimpleFieldSet exportPublicCryptoFieldSet(boolean forSetup, boolean forAnonInitiator) {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        int[] negTypes = this.packetMangler.supportedNegTypes();
        if (!forSetup && !forAnonInitiator) {
            fs.putSingle("identity", Base64.encode(this.myIdentity));
        }
        if (!forSetup) {
            fs.put("dsaGroup", this.cryptoGroup.asFieldSet());
            fs.put("dsaPubKey", this.pubKey.asFieldSet());
        }
        if (!forAnonInitiator) {
            fs.put("auth.negTypes", negTypes);
            if (!forSetup) {
                fs.put("ark.number", this.myARKNumber);
                fs.putSingle("ark.pubURI", this.myARK.getURI().toString(false, false));
            }
        }
        return fs;
    }

    DSASignature signRef(String mySignedReference) throws NodeInitException {
        if (logMINOR) {
            Logger.minor(this, "Signing reference:\n" + mySignedReference);
        }
        try {
            byte[] ref = mySignedReference.getBytes("UTF-8");
            BigInteger m = new BigInteger(1, SHA256.digest(ref));
            if (logMINOR) {
                Logger.minor(this, "m = " + m.toString(16));
            }
            DSASignature _signature = DSA.sign(this.cryptoGroup, this.privKey, m, this.random);
            if (logMINOR && !DSA.verify(this.pubKey, _signature, m, false)) {
                throw new NodeInitException(1023, mySignedReference);
            }
            return _signature;
        }
        catch (UnsupportedEncodingException e) {
            Logger.error(this, "Error while signing the node identity!" + e, e);
            System.err.println("Error while signing the node identity!" + e);
            e.printStackTrace();
            throw new NodeInitException(255, "Impossible: JVM doesn't support UTF-8");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] myCompressedRef(boolean setup, boolean heavySetup, boolean forARK) {
        ByteArrayOutputStream baos;
        boolean shouldStripGroup;
        block10: {
            SimpleFieldSet fs = this.exportPublicFieldSet(setup, heavySetup, forARK);
            boolean bl = shouldStripGroup = heavySetup && Global.DSAgroupBigA.equals(this.cryptoGroup);
            if (shouldStripGroup) {
                fs.removeSubset("dsaGroup");
            }
            baos = new ByteArrayOutputStream();
            DeflaterOutputStream gis = new DeflaterOutputStream(baos);
            try {
                Object var10_8;
                try {
                    fs.writeTo(gis);
                }
                catch (IOException e) {
                    Logger.error(this, "IOE :" + e.getMessage(), e);
                    var10_8 = null;
                    Closer.close(gis);
                    Closer.close(baos);
                    break block10;
                }
                var10_8 = null;
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                Closer.close(gis);
                Closer.close(baos);
                throw throwable;
            }
            Closer.close(gis);
            Closer.close(baos);
        }
        byte[] buf = baos.toByteArray();
        if (buf.length >= 4096) {
            throw new IllegalStateException("We are attempting to send a " + buf.length + " bytes big reference!");
        }
        byte[] obuf = new byte[buf.length + 1 + (shouldStripGroup ? 1 : 0)];
        int offset = 0;
        if (shouldStripGroup) {
            obuf[offset++] = 3;
            int dsaGroupIndex = 1;
            if (logMINOR) {
                Logger.minor(this, "We are stripping the group from the reference as it's a known group (groupIndex=" + dsaGroupIndex + ')');
            }
            obuf[offset++] = (byte)(dsaGroupIndex & 0xFF);
        } else {
            obuf[offset++] = 1;
        }
        System.arraycopy(buf, 0, obuf, offset, buf.length);
        if (logMINOR) {
            Logger.minor(this, "myCompressedRef(" + setup + "," + heavySetup + ") returning " + obuf.length + " bytes");
        }
        return obuf;
    }

    public byte[] myCompressedSetupRef() {
        return this.myCompressedRef(true, false, false);
    }

    public byte[] myCompressedHeavySetupRef() {
        return this.myCompressedRef(false, true, false);
    }

    public byte[] myCompressedFullRef() {
        return this.myCompressedRef(false, false, false);
    }

    void addPrivateFields(SimpleFieldSet fs) {
        fs.put("dsaPrivKey", this.privKey.asFieldSet());
        fs.putSingle("ark.privURI", this.myARK.getInsertURI().toString(false, false));
        if (fs.get("location") == null) {
            fs.put("location", this.node.lm.getLocation());
        }
        fs.putSingle("clientNonce", Base64.encode(this.clientNonce));
    }

    public int getIdentityHash() {
        return Fields.hashCode(this.identityHash);
    }

    DSASignature sign(byte[] hash) {
        return DSA.sign(this.cryptoGroup, this.privKey, new NativeBigInteger(1, hash), this.random);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSetDropProbability(int val) {
        NodeCrypto nodeCrypto = this;
        synchronized (nodeCrypto) {
            if (this.socket == null) {
                return;
            }
        }
        this.socket.setDropProbability(val);
    }

    public void stop() {
        this.config.stopping(this);
        this.socket.close();
    }

    public PeerNode[] getPeerNodes() {
        if (this.node.peers == null) {
            return null;
        }
        if (this.isOpennet) {
            return this.node.peers.getOpennetPeers();
        }
        return this.node.peers.getDarknetPeers();
    }

    public boolean allowConnection(PeerNode pn, FreenetInetAddress addr) {
        if (this.config.oneConnectionPerAddress() && this.node.peers.anyConnectedPeerHasAddress(addr, pn) && !this.detector.includes(addr)) {
            Logger.normal(this, "Not sending handshake packets to " + addr + " for " + pn + " : Same IP address as another node");
            return false;
        }
        return true;
    }

    DSAGroup getCryptoGroup() {
        return this.cryptoGroup;
    }

    public BlockCipher getAnonSetupCipher() {
        return this.anonSetupCipher;
    }

    public PeerNode[] getAnonSetupPeerNodes() {
        ArrayList<PeerNode> v = new ArrayList<PeerNode>();
        PeerNode[] peers = this.node.peers.myPeers;
        for (int i = 0; i < peers.length; ++i) {
            PeerNode pn = peers[i];
            if (!pn.handshakeUnknownInitiator() || pn.getOutgoingMangler() != this.packetMangler) continue;
            v.add(pn);
        }
        return v.toArray(new PeerNode[v.size()]);
    }

    void setPortForwardingBroken() {
        this.socket.getAddressTracker().setBroken();
    }

    public byte[] getIdentity(boolean unknownInitiator) {
        if (unknownInitiator) {
            return this.pubKey.asBytesHash();
        }
        return this.myIdentity;
    }

    public boolean definitelyPortForwarded() {
        return this.socket.getDetectedConnectivityStatus() == 2;
    }

    public int getDetectedConnectivityStatus() {
        return this.socket.getDetectedConnectivityStatus();
    }

    public FreenetInetAddress getBindTo() {
        return this.config.getBindTo();
    }

    public long getNodeHandle(ObjectContainer setupContainer) {
        HandlePortTuple tuple;
        long handle;
        if (setupContainer == null) {
            return this.random.nextLong();
        }
        ObjectSet result = setupContainer.query((Predicate)new Predicate<HandlePortTuple>(){

            public boolean match(HandlePortTuple tuple) {
                return tuple.portNumber == NodeCrypto.this.portNumber;
            }
        });
        if (result.hasNext()) {
            long handle2 = ((HandlePortTuple)result.next()).handle;
            System.err.println("Retrieved database handle for node on port " + this.portNumber + ": " + handle2);
            return handle2;
        }
        while (true) {
            handle = this.random.nextLong();
            tuple = new HandlePortTuple();
            tuple.handle = handle;
            ObjectSet os = setupContainer.get((Object)tuple);
            if (!os.hasNext()) break;
            System.err.println("Generating database handle for node: already taken: " + handle);
        }
        tuple.portNumber = this.portNumber;
        setupContainer.store((Object)tuple);
        setupContainer.commit();
        if (Logger.shouldLog(4, this)) {
            Logger.minor(this, "COMMITTED");
        }
        System.err.println("Generated and stored database handle for node on port " + this.portNumber + ": " + handle);
        return handle;
    }
}

