/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import com.db4o.ObjectContainer;
import com.db4o.ext.Db4oException;
import freenet.client.ArchiveManager;
import freenet.client.FECQueue;
import freenet.client.HighLevelSimpleClient;
import freenet.client.HighLevelSimpleClientImpl;
import freenet.client.InsertContext;
import freenet.client.async.BackgroundBlockEncoder;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.DBJob;
import freenet.client.async.DBJobRunner;
import freenet.client.async.DatabaseDisabledException;
import freenet.client.async.DatastoreChecker;
import freenet.client.async.HealingQueue;
import freenet.client.async.InsertCompressor;
import freenet.client.async.SimpleHealingQueue;
import freenet.client.async.USKManager;
import freenet.client.events.SimpleEventProducer;
import freenet.clients.http.FProxyToadlet;
import freenet.clients.http.SimpleToadletServer;
import freenet.clients.http.filter.FilterCallback;
import freenet.clients.http.filter.FoundURICallback;
import freenet.clients.http.filter.GenericReadFilterCallback;
import freenet.config.Config;
import freenet.config.InvalidConfigValueException;
import freenet.config.NodeNeedRestartException;
import freenet.config.SubConfig;
import freenet.crypt.RandomSource;
import freenet.io.xfer.AbortedException;
import freenet.io.xfer.PartiallyReceivedBlock;
import freenet.keys.CHKBlock;
import freenet.keys.CHKVerifyException;
import freenet.keys.ClientCHK;
import freenet.keys.ClientCHKBlock;
import freenet.keys.ClientKey;
import freenet.keys.ClientKeyBlock;
import freenet.keys.ClientSSK;
import freenet.keys.ClientSSKBlock;
import freenet.keys.FreenetURI;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.NodeSSK;
import freenet.keys.SSKBlock;
import freenet.keys.SSKVerifyException;
import freenet.l10n.L10n;
import freenet.node.CHKInsertSender;
import freenet.node.ConfigurablePersister;
import freenet.node.InsertTag;
import freenet.node.LowLevelGetException;
import freenet.node.LowLevelPutException;
import freenet.node.Node;
import freenet.node.NodeInitException;
import freenet.node.NodeRestartJobsQueue;
import freenet.node.NodeStats;
import freenet.node.Persistable;
import freenet.node.Persister;
import freenet.node.PrioRunnable;
import freenet.node.RequestSender;
import freenet.node.RequestStarterGroup;
import freenet.node.RequestTag;
import freenet.node.SSKInsertSender;
import freenet.node.SecurityLevelListener;
import freenet.node.SecurityLevels;
import freenet.node.SimpleSendableInsert;
import freenet.node.TextModeClientInterface;
import freenet.node.TextModeClientInterfaceServer;
import freenet.node.Ticker;
import freenet.node.fcp.FCPServer;
import freenet.node.useralerts.SimpleUserAlert;
import freenet.node.useralerts.UserAlert;
import freenet.node.useralerts.UserAlertManager;
import freenet.store.KeyCollisionException;
import freenet.support.Base64;
import freenet.support.Executor;
import freenet.support.ExecutorIdleCallback;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.MutableBoolean;
import freenet.support.OOMHandler;
import freenet.support.OOMHook;
import freenet.support.PrioritizedSerialExecutor;
import freenet.support.SimpleFieldSet;
import freenet.support.api.BooleanCallback;
import freenet.support.api.IntCallback;
import freenet.support.api.LongCallback;
import freenet.support.api.StringArrCallback;
import freenet.support.api.StringCallback;
import freenet.support.compress.RealCompressor;
import freenet.support.io.FileUtil;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.PersistentTempBucketFactory;
import freenet.support.io.TempBucketFactory;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.tanukisoftware.wrapper.WrapperManager;

public class NodeClientCore
implements Persistable,
DBJobRunner,
OOMHook,
ExecutorIdleCallback {
    private static volatile boolean logMINOR;
    public final USKManager uskManager;
    public final ArchiveManager archiveManager;
    public final RequestStarterGroup requestStarters;
    private final HealingQueue healingQueue;
    public final NodeRestartJobsQueue restartJobsQueue;
    public final String formPassword;
    File downloadDir;
    private File[] downloadAllowedDirs;
    private boolean includeDownloadDir;
    private boolean downloadAllowedEverywhere;
    private File[] uploadAllowedDirs;
    private boolean uploadAllowedEverywhere;
    public final FilenameGenerator tempFilenameGenerator;
    public final FilenameGenerator persistentFilenameGenerator;
    public final TempBucketFactory tempBucketFactory;
    public final PersistentTempBucketFactory persistentTempBucketFactory;
    public final Node node;
    final NodeStats nodeStats;
    public final RandomSource random;
    final File tempDir;
    public final FECQueue fecQueue;
    public final UserAlertManager alerts;
    final TextModeClientInterfaceServer tmci;
    TextModeClientInterface directTMCI;
    final FCPServer fcpServer;
    FProxyToadlet fproxyServlet;
    final SimpleToadletServer toadletContainer;
    public final BackgroundBlockEncoder backgroundBlockEncoder;
    public final RealCompressor compressor;
    protected final Persister persister;
    public final transient PrioritizedSerialExecutor clientDatabaseExecutor;
    public final DatastoreChecker storeChecker;
    public final transient ClientContext clientContext;
    public static int maxBackgroundUSKFetchers;
    static final int MAX_ARCHIVE_HANDLERS = 200;
    static final long MAX_CACHED_ARCHIVE_DATA = 0x2000000L;
    static final long MAX_ARCHIVED_FILE_SIZE = 0x100000L;
    static final int MAX_CACHED_ELEMENTS = 262144;
    private static final int FEC_QUEUE_CACHE_SIZE = 20;
    private UserAlert startingUpAlert;
    private NodeRestartJobsQueue.RestartDBJob[] startupDatabaseJobs;
    private File persistentTempDir;
    private boolean alwaysCommit;
    private int startupDatabaseJobsDone = 0;
    private DBJob startupJobRunner = new DBJob(){

        public boolean run(ObjectContainer container, ClientContext context) {
            NodeRestartJobsQueue.RestartDBJob job = NodeClientCore.this.startupDatabaseJobs[NodeClientCore.this.startupDatabaseJobsDone];
            try {
                container.activate((Object)job.job, 1);
                System.err.println("Cleaning up after restart: " + job.job);
                NodeClientCore.this.restartJobsQueue.removeRestartJob(job.job, job.prio, container);
                job.job.run(container, context);
                container.commit();
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t + " in startup job " + job, t);
                NodeClientCore.this.restartJobsQueue.queueRestartJob(job.job, job.prio, container, true);
            }
            NodeClientCore.this.startupDatabaseJobsDone++;
            if (NodeClientCore.this.startupDatabaseJobsDone == NodeClientCore.this.startupDatabaseJobs.length) {
                NodeClientCore.access$1102(NodeClientCore.this, null);
            } else {
                try {
                    context.jobRunner.queue(NodeClientCore.this.startupJobRunner, 7, false);
                }
                catch (DatabaseDisabledException e) {
                    // empty catch block
                }
            }
            return true;
        }
    };
    private boolean killedDatabase = false;
    private long lastCommitted = System.currentTimeMillis();
    static final int MAX_COMMIT_INTERVAL = 30000;
    private boolean commitThisTransaction;

    NodeClientCore(Node node, Config config, SubConfig nodeConfig, File nodeDir, int portNumber, int sortOrder, SimpleFieldSet oldConfig, SubConfig fproxyConfig, SimpleToadletServer toadlets, ObjectContainer container) throws NodeInitException {
        this.node = node;
        this.nodeStats = node.nodeStats;
        this.random = node.random;
        boolean bl = this.killedDatabase = container == null;
        if (this.killedDatabase) {
            System.err.println("Database corrupted (before entering NodeClientCore)!");
        }
        FECQueue q = null;
        try {
            q = !this.killedDatabase ? FECQueue.create(node.nodeDBHandle, container) : new FECQueue(node.nodeDBHandle);
        }
        catch (Db4oException e) {
            this.killedDatabase = true;
            q = new FECQueue(node.nodeDBHandle);
        }
        this.fecQueue = q;
        this.backgroundBlockEncoder = new BackgroundBlockEncoder();
        this.clientDatabaseExecutor = new PrioritizedSerialExecutor(5, 11, 5, true, 30000, this);
        this.storeChecker = new DatastoreChecker(node);
        byte[] pwdBuf = new byte[16];
        this.random.nextBytes(pwdBuf);
        this.compressor = new RealCompressor(node.executor);
        this.formPassword = Base64.encode(pwdBuf);
        this.alerts = new UserAlertManager(this);
        NodeRestartJobsQueue rq = null;
        try {
            if (!this.killedDatabase) {
                rq = container == null ? null : NodeRestartJobsQueue.init(node.nodeDBHandle, container);
            }
        }
        catch (Db4oException e) {
            this.killedDatabase = true;
        }
        this.restartJobsQueue = rq;
        NodeRestartJobsQueue.RestartDBJob[] startupJobs = null;
        try {
            if (!this.killedDatabase) {
                startupJobs = this.restartJobsQueue.getEarlyRestartDatabaseJobs(container);
            }
        }
        catch (Db4oException e) {
            this.killedDatabase = true;
        }
        this.startupDatabaseJobs = startupJobs;
        if (this.startupDatabaseJobs != null && this.startupDatabaseJobs.length > 0) {
            try {
                this.queue(this.startupJobRunner, 7, false);
            }
            catch (DatabaseDisabledException e1) {
                // empty catch block
            }
        }
        if (!this.killedDatabase) {
            try {
                this.restartJobsQueue.addLateRestartDatabaseJobs(this, container);
            }
            catch (Db4oException e) {
                this.killedDatabase = true;
            }
            catch (DatabaseDisabledException e) {
                // empty catch block
            }
        }
        this.persister = new ConfigurablePersister(this, nodeConfig, "clientThrottleFile", "client-throttle.dat", sortOrder++, true, false, "NodeClientCore.fileForClientStats", "NodeClientCore.fileForClientStatsLong", node.ps, nodeDir);
        SimpleFieldSet throttleFS = this.persister.read();
        if (logMINOR) {
            Logger.minor(this, "Read throttleFS:\n" + throttleFS);
        }
        if (logMINOR) {
            Logger.minor(this, "Serializing RequestStarterGroup from:\n" + throttleFS);
        }
        nodeConfig.register("tempDir", new File(nodeDir, "temp-" + portNumber).toString(), sortOrder++, true, true, "NodeClientCore.tempDir", "NodeClientCore.tempDirLong", new StringCallback(){

            public String get() {
                return NodeClientCore.this.tempDir.getPath();
            }

            public void set(String val) throws InvalidConfigValueException {
                if (NodeClientCore.this.tempDir.equals(new File(val))) {
                    return;
                }
                throw new InvalidConfigValueException(NodeClientCore.l10n("movingTempDirOnTheFlyNotSupported"));
            }

            public boolean isReadOnly() {
                return true;
            }
        });
        this.tempDir = new File(nodeConfig.getString("tempDir"));
        if (!(this.tempDir.exists() && this.tempDir.isDirectory() || this.tempDir.mkdir())) {
            String msg = "Could not find or create temporary directory";
            throw new NodeInitException(16, msg);
        }
        try {
            this.tempFilenameGenerator = new FilenameGenerator(this.random, true, this.tempDir, "temp-");
        }
        catch (IOException e) {
            String msg = "Could not find or create temporary directory (filename generator)";
            throw new NodeInitException(16, msg);
        }
        this.uskManager = new USKManager(this);
        nodeConfig.register("encryptPersistentTempBuckets", true, sortOrder++, true, false, "NodeClientCore.encryptPersistentTempBuckets", "NodeClientCore.encryptPersistentTempBucketsLong", new BooleanCallback(){

            public Boolean get() {
                return NodeClientCore.this.persistentTempBucketFactory == null ? true : NodeClientCore.this.persistentTempBucketFactory.isEncrypting();
            }

            public void set(Boolean val) throws InvalidConfigValueException {
                if (this.get().equals(val) || NodeClientCore.this.persistentTempBucketFactory == null) {
                    return;
                }
                NodeClientCore.this.persistentTempBucketFactory.setEncryption(val);
            }
        });
        nodeConfig.register("persistentTempDir", new File(nodeDir, "persistent-temp-" + portNumber).toString(), sortOrder++, true, false, "NodeClientCore.persistentTempDir", "NodeClientCore.persistentTempDirLong", new StringCallback(){

            public String get() {
                return NodeClientCore.this.persistentTempDir.toString();
            }

            public void set(String val) throws InvalidConfigValueException {
                if (this.get().equals(val)) {
                    return;
                }
                throw new InvalidConfigValueException("Moving persistent temp directory on the fly not supported at present");
            }

            public boolean isReadOnly() {
                return true;
            }
        });
        PersistentTempBucketFactory ptbf = null;
        FilenameGenerator pfg = null;
        this.persistentTempDir = new File(nodeConfig.getString("persistentTempDir"));
        try {
            String prefix = "freenet-temp-";
            if (!this.killedDatabase) {
                ptbf = PersistentTempBucketFactory.load(this.persistentTempDir, prefix, this.random, node.fastWeakRandom, container, node.nodeDBHandle, nodeConfig.getBoolean("encryptPersistentTempBuckets"), this, node.getTicker());
                ptbf.init(this.persistentTempDir, prefix, this.random, node.fastWeakRandom);
                pfg = ptbf.fg;
            }
        }
        catch (IOException e2) {
            String msg = "Could not find or create persistent temporary directory: " + e2;
            e2.printStackTrace();
            throw new NodeInitException(16, msg);
        }
        catch (Db4oException e) {
            this.killedDatabase = true;
        }
        if (this.killedDatabase) {
            this.persistentTempBucketFactory = null;
            this.persistentFilenameGenerator = null;
        } else {
            this.persistentTempBucketFactory = ptbf;
            this.persistentFilenameGenerator = pfg;
        }
        nodeConfig.register("maxRAMBucketSize", "128KiB", sortOrder++, true, false, "NodeClientCore.maxRAMBucketSize", "NodeClientCore.maxRAMBucketSizeLong", new LongCallback(){

            public Long get() {
                return NodeClientCore.this.tempBucketFactory == null ? 0L : NodeClientCore.this.tempBucketFactory.getMaxRAMBucketSize();
            }

            public void set(Long val) throws InvalidConfigValueException {
                if (this.get().equals(val) || NodeClientCore.this.tempBucketFactory == null) {
                    return;
                }
                NodeClientCore.this.tempBucketFactory.setMaxRAMBucketSize(val);
            }
        }, true);
        nodeConfig.register("RAMBucketPoolSize", "10MiB", sortOrder++, true, false, "NodeClientCore.ramBucketPoolSize", "NodeClientCore.ramBucketPoolSizeLong", new LongCallback(){

            public Long get() {
                return NodeClientCore.this.tempBucketFactory == null ? 0L : NodeClientCore.this.tempBucketFactory.getMaxRamUsed();
            }

            public void set(Long val) throws InvalidConfigValueException {
                if (this.get().equals(val) || NodeClientCore.this.tempBucketFactory == null) {
                    return;
                }
                NodeClientCore.this.tempBucketFactory.setMaxRamUsed(val);
            }
        }, true);
        nodeConfig.register("encryptTempBuckets", true, sortOrder++, true, false, "NodeClientCore.encryptTempBuckets", "NodeClientCore.encryptTempBucketsLong", new BooleanCallback(){

            public Boolean get() {
                return NodeClientCore.this.tempBucketFactory == null ? true : NodeClientCore.this.tempBucketFactory.isEncrypting();
            }

            public void set(Boolean val) throws InvalidConfigValueException {
                if (this.get().equals(val) || NodeClientCore.this.tempBucketFactory == null) {
                    return;
                }
                NodeClientCore.this.tempBucketFactory.setEncryption(val);
            }
        });
        this.tempBucketFactory = new TempBucketFactory(node.executor, this.tempFilenameGenerator, nodeConfig.getLong("maxRAMBucketSize"), nodeConfig.getLong("RAMBucketPoolSize"), this.random, node.fastWeakRandom, nodeConfig.getBoolean("encryptTempBuckets"));
        this.archiveManager = new ArchiveManager(200, 0x2000000L, 0x100000L, 262144, this.tempBucketFactory);
        this.healingQueue = new SimpleHealingQueue(new InsertContext(this.tempBucketFactory, this.tempBucketFactory, this.persistentTempBucketFactory, 0, 2, 1, 0, 0, new SimpleEventProducer(), true), 5, 512);
        this.clientContext = new ClientContext(this, this.fecQueue, node.executor, this.backgroundBlockEncoder, this.archiveManager, this.persistentTempBucketFactory, this.tempBucketFactory, this.healingQueue, this.uskManager, this.random, node.fastWeakRandom, node.getTicker(), this.tempFilenameGenerator, this.persistentFilenameGenerator, this.compressor);
        this.compressor.setClientContext(this.clientContext);
        this.storeChecker.setContext(this.clientContext);
        this.requestStarters = new RequestStarterGroup(node, this, portNumber, this.random, config, throttleFS, this.clientContext);
        this.clientContext.init(this.requestStarters);
        if (!this.killedDatabase) {
            try {
                ClientRequestScheduler.loadKeyListeners(container, this.clientContext);
            }
            catch (Db4oException e) {
                this.killedDatabase = true;
            }
        }
        if (!this.killedDatabase) {
            try {
                InsertCompressor.load(container, this.clientContext);
            }
            catch (Db4oException e) {
                this.killedDatabase = true;
            }
        }
        node.securityLevels.addPhysicalThreatLevelListener(new SecurityLevelListener<SecurityLevels.PHYSICAL_THREAT_LEVEL>(){

            @Override
            public void onChange(SecurityLevels.PHYSICAL_THREAT_LEVEL oldLevel, SecurityLevels.PHYSICAL_THREAT_LEVEL newLevel) {
                if (newLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.LOW) {
                    if (NodeClientCore.this.tempBucketFactory.isEncrypting()) {
                        NodeClientCore.this.tempBucketFactory.setEncryption(false);
                    }
                    if (NodeClientCore.this.persistentTempBucketFactory.isEncrypting()) {
                        NodeClientCore.this.persistentTempBucketFactory.setEncryption(false);
                    }
                } else {
                    if (!NodeClientCore.this.tempBucketFactory.isEncrypting()) {
                        NodeClientCore.this.tempBucketFactory.setEncryption(true);
                    }
                    if (!NodeClientCore.this.persistentTempBucketFactory.isEncrypting()) {
                        NodeClientCore.this.persistentTempBucketFactory.setEncryption(true);
                    }
                }
            }
        });
        nodeConfig.register("downloadsDir", "downloads", sortOrder++, true, true, "NodeClientCore.downloadDir", "NodeClientCore.downloadDirLong", new StringCallback(){

            public String get() {
                return NodeClientCore.this.downloadDir.getPath();
            }

            public void set(String val) throws InvalidConfigValueException {
                if (NodeClientCore.this.downloadDir.equals(new File(val))) {
                    return;
                }
                File f = new File(val);
                if (!(f.exists() && f.isDirectory() || f.mkdir())) {
                    throw new InvalidConfigValueException(NodeClientCore.l10n("couldNotFindOrCreateDir"));
                }
                NodeClientCore.this.downloadDir = new File(val);
            }
        });
        String val = nodeConfig.getString("downloadsDir");
        this.downloadDir = new File(val);
        if (!(this.downloadDir.exists() && this.downloadDir.isDirectory() || this.downloadDir.mkdir())) {
            throw new NodeInitException(14, "Could not find or create default downloads directory");
        }
        nodeConfig.register("downloadAllowedDirs", new String[]{"all"}, sortOrder++, true, true, "NodeClientCore.downloadAllowedDirs", "NodeClientCore.downloadAllowedDirsLong", new StringArrCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String[] get() {
                NodeClientCore nodeClientCore = NodeClientCore.this;
                synchronized (nodeClientCore) {
                    if (NodeClientCore.this.downloadAllowedEverywhere) {
                        return new String[]{"all"};
                    }
                    String[] dirs = new String[NodeClientCore.this.downloadAllowedDirs.length + (NodeClientCore.this.includeDownloadDir ? 1 : 0)];
                    for (int i = 0; i < NodeClientCore.this.downloadAllowedDirs.length; ++i) {
                        dirs[i] = NodeClientCore.this.downloadAllowedDirs[i].getPath();
                    }
                    if (NodeClientCore.this.includeDownloadDir) {
                        dirs[((NodeClientCore)NodeClientCore.this).downloadAllowedDirs.length] = "downloads";
                    }
                    return dirs;
                }
            }

            public void set(String[] val) throws InvalidConfigValueException {
                NodeClientCore.this.setDownloadAllowedDirs(val);
            }
        });
        this.setDownloadAllowedDirs(nodeConfig.getStringArr("downloadAllowedDirs"));
        nodeConfig.register("uploadAllowedDirs", new String[]{"all"}, sortOrder++, true, true, "NodeClientCore.uploadAllowedDirs", "NodeClientCore.uploadAllowedDirsLong", new StringArrCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String[] get() {
                NodeClientCore nodeClientCore = NodeClientCore.this;
                synchronized (nodeClientCore) {
                    if (NodeClientCore.this.uploadAllowedEverywhere) {
                        return new String[]{"all"};
                    }
                    String[] dirs = new String[NodeClientCore.this.uploadAllowedDirs.length];
                    for (int i = 0; i < NodeClientCore.this.uploadAllowedDirs.length; ++i) {
                        dirs[i] = NodeClientCore.this.uploadAllowedDirs[i].getPath();
                    }
                    return dirs;
                }
            }

            public void set(String[] val) throws InvalidConfigValueException {
                NodeClientCore.this.setUploadAllowedDirs(val);
            }
        });
        this.setUploadAllowedDirs(nodeConfig.getStringArr("uploadAllowedDirs"));
        Logger.normal(this, "Initializing USK Manager");
        System.out.println("Initializing USK Manager");
        try {
            this.uskManager.init(this.killedDatabase ? null : container, this.clientContext);
        }
        catch (Db4oException e) {
            this.killedDatabase = true;
        }
        nodeConfig.register("maxBackgroundUSKFetchers", "64", sortOrder++, true, false, "NodeClientCore.maxUSKFetchers", "NodeClientCore.maxUSKFetchersLong", new IntCallback(){

            public Integer get() {
                return maxBackgroundUSKFetchers;
            }

            public void set(Integer uskFetch) throws InvalidConfigValueException {
                if (uskFetch <= 0) {
                    throw new InvalidConfigValueException(NodeClientCore.l10n("maxUSKFetchersMustBeGreaterThanZero"));
                }
                maxBackgroundUSKFetchers = uskFetch;
            }
        }, false);
        maxBackgroundUSKFetchers = nodeConfig.getInt("maxBackgroundUSKFetchers");
        try {
            this.tmci = TextModeClientInterfaceServer.maybeCreate(node, this, config);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new NodeInitException(19, "Could not start TMCI: " + e);
        }
        try {
            this.fcpServer = FCPServer.maybeCreate(node, this, node.config, container);
            if (!this.killedDatabase) {
                this.fcpServer.load(container);
            }
        }
        catch (IOException e) {
            throw new NodeInitException(17, "Could not start FCP: " + e);
        }
        catch (InvalidConfigValueException e) {
            throw new NodeInitException(17, "Could not start FCP: " + e);
        }
        this.startingUpAlert = new SimpleUserAlert(true, NodeClientCore.l10n("startingUpTitle"), NodeClientCore.l10n("startingUp"), NodeClientCore.l10n("startingUpShort"), 3);
        this.alerts.register(this.startingUpAlert);
        this.alerts.register(new SimpleUserAlert(true, L10n.getString("QueueToadlet.persistenceBrokenTitle"), L10n.getString("QueueToadlet.persistenceBroken", new String[]{"TEMPDIR", "DBFILE"}, new String[]{FileUtil.getCanonicalFile(this.getPersistentTempDir()).toString() + File.separator, FileUtil.getCanonicalFile(node.getNodeDir()) + File.separator + "node.db4o"}), L10n.getString("QueueToadlet.persistenceBrokenShortAlert"), 0){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean isValid() {
                NodeClientCore nodeClientCore = NodeClientCore.this;
                synchronized (nodeClientCore) {
                    if (!NodeClientCore.this.killedDatabase) {
                        return false;
                    }
                }
                return !NodeClientCore.this.node.isStopping();
            }

            public boolean userCanDismiss() {
                return false;
            }
        });
        this.toadletContainer = toadlets;
        this.toadletContainer.setCore(this);
        this.toadletContainer.setBucketFactory(this.tempBucketFactory);
        if (this.fecQueue == null) {
            throw new NullPointerException();
        }
        this.fecQueue.init(7, 20, this.clientContext.jobRunner, node.executor, this.clientContext);
        OOMHandler.addOOMHook(this);
        if (this.killedDatabase) {
            System.err.println("Database corrupted (leaving NodeClientCore)!");
        }
        nodeConfig.register("alwaysCommit", false, sortOrder++, true, false, "NodeClientCore.alwaysCommit", "NodeClientCore.alwaysCommitLong", new BooleanCallback(){

            public Boolean get() {
                return NodeClientCore.this.alwaysCommit;
            }

            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                NodeClientCore.this.alwaysCommit = val;
            }
        });
        this.alwaysCommit = nodeConfig.getBoolean("alwaysCommit");
    }

    private static String l10n(String key) {
        return L10n.getString("NodeClientCore." + key);
    }

    protected synchronized void setDownloadAllowedDirs(String[] val) {
        int x = 0;
        this.downloadAllowedEverywhere = false;
        this.includeDownloadDir = false;
        int i = 0;
        this.downloadAllowedDirs = new File[val.length];
        for (i = 0; i < this.downloadAllowedDirs.length; ++i) {
            String s = val[i];
            if (s.equals("downloads")) {
                this.includeDownloadDir = true;
                continue;
            }
            if (s.equals("all")) {
                this.downloadAllowedEverywhere = true;
                continue;
            }
            this.downloadAllowedDirs[x++] = new File(val[i]);
        }
        if (x != i) {
            File[] newDirs = new File[x];
            System.arraycopy(this.downloadAllowedDirs, 0, newDirs, 0, x);
            this.downloadAllowedDirs = newDirs;
        }
    }

    protected synchronized void setUploadAllowedDirs(String[] val) {
        int x = 0;
        int i = 0;
        this.uploadAllowedEverywhere = false;
        this.uploadAllowedDirs = new File[val.length];
        for (i = 0; i < this.uploadAllowedDirs.length; ++i) {
            String s = val[i];
            if (s.equals("all")) {
                this.uploadAllowedEverywhere = true;
                continue;
            }
            this.uploadAllowedDirs[x++] = new File(val[i]);
        }
        if (x != i) {
            File[] newDirs = new File[x];
            System.arraycopy(this.uploadAllowedDirs, 0, newDirs, 0, x);
            this.uploadAllowedDirs = newDirs;
        }
    }

    public void start(Config config) throws NodeInitException {
        this.backgroundBlockEncoder.setContext(this.clientContext);
        this.node.executor.execute(this.backgroundBlockEncoder, "Background block encoder");
        try {
            this.clientContext.jobRunner.queue(new DBJob(){

                public boolean run(ObjectContainer container, ClientContext context) {
                    ArchiveManager.init(container, context, context.nodeDBHandle);
                    return false;
                }
            }, 10, false);
        }
        catch (DatabaseDisabledException databaseDisabledException) {
            // empty catch block
        }
        this.persister.start();
        this.storeChecker.start(this.node.executor, "Datastore checker");
        if (this.fcpServer != null) {
            this.fcpServer.maybeStart();
        }
        if (this.tmci != null) {
            this.tmci.start();
        }
        this.backgroundBlockEncoder.runPersistentQueue(this.clientContext);
        this.node.executor.execute(this.compressor, "Compression scheduler");
        this.node.executor.execute(new PrioRunnable(){

            public void run() {
                Logger.normal(this, "Resuming persistent requests");
                NodeClientCore.this.fcpServer.finishStart();
                if (NodeClientCore.this.persistentTempBucketFactory != null) {
                    NodeClientCore.this.persistentTempBucketFactory.completedInit();
                }
                NodeClientCore.this.node.pluginManager.start(NodeClientCore.this.node.config);
                NodeClientCore.this.node.ipDetector.ipDetectorManager.start();
                Logger.normal(this, "Completed startup: All persistent requests resumed or restarted");
                NodeClientCore.this.alerts.unregister(NodeClientCore.this.startingUpAlert);
            }

            public int getPriority() {
                return 3;
            }
        }, "Startup completion thread");
        this.clientDatabaseExecutor.start(this.node.executor, "Client database access thread");
    }

    public void asyncGet(Key key, boolean cache, boolean offersOnly, final SimpleRequestSenderCompletionListener listener) {
        RequestTag tag;
        boolean isSSK;
        final long uid = this.random.nextLong();
        if (!this.node.lockUID(uid, isSSK = key instanceof NodeSSK, false, false, true, tag = new RequestTag(isSSK, RequestTag.START.ASYNC_GET))) {
            Logger.error(this, "Could not lock UID just randomly generated: " + uid + " - probably indicates broken PRNG");
            return;
        }
        this.asyncGet(key, isSSK, cache, offersOnly, uid, new RequestSender.Listener(){

            public void onCHKTransferBegins() {
            }

            public void onReceivedRejectOverload() {
            }

            public void onRequestSenderFinished(int status) {
                NodeClientCore.this.node.unlockUID(uid, isSSK, false, true, false, true, tag);
                tag.setRequestSenderFinished(status);
                if (listener != null) {
                    listener.completed(status == 0);
                }
            }

            public void onAbortDownstreamTransfers(int reason, String desc) {
            }
        }, tag);
    }

    void asyncGet(Key key, boolean isSSK, boolean cache, boolean offersOnly, long uid, RequestSender.Listener listener, RequestTag tag) {
        try {
            Object o = this.node.makeRequestSender(key, this.node.maxHTL(), uid, null, false, cache, false, offersOnly);
            if (o instanceof KeyBlock) {
                tag.servedFromDatastore = true;
                this.node.unlockUID(uid, isSSK, false, true, false, true, tag);
                return;
            }
            RequestSender rs = (RequestSender)o;
            tag.setSender(rs);
            rs.addListener(listener);
            if (rs.uid != uid) {
                this.node.unlockUID(uid, isSSK, false, false, false, true, tag);
            }
            if (logMINOR) {
                Logger.minor(this, "Started " + o + " for " + uid + " for " + key);
            }
        }
        catch (RuntimeException e) {
            Logger.error(this, "Caught error trying to start request: " + e, e);
            this.node.unlockUID(uid, isSSK, false, true, false, true, tag);
        }
        catch (Error e) {
            Logger.error(this, "Caught error trying to start request: " + e, e);
            this.node.unlockUID(uid, isSSK, false, true, false, true, tag);
        }
    }

    public ClientKeyBlock realGetKey(ClientKey key, boolean localOnly, boolean cache, boolean ignoreStore) throws LowLevelGetException {
        if (key instanceof ClientCHK) {
            return this.realGetCHK((ClientCHK)key, localOnly, cache, ignoreStore);
        }
        if (key instanceof ClientSSK) {
            return this.realGetSSK((ClientSSK)key, localOnly, cache, ignoreStore);
        }
        throw new IllegalArgumentException("Not a CHK or SSK: " + key);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ClientCHKBlock realGetCHK(ClientCHK key, boolean localOnly, boolean cache, boolean ignoreStore) throws LowLevelGetException {
        ClientCHKBlock rtt2;
        RequestTag tag;
        long uid;
        block33: {
            long startTime = System.currentTimeMillis();
            uid = this.random.nextLong();
            if (!this.node.lockUID(uid, false, false, false, true, tag = new RequestTag(false, RequestTag.START.LOCAL))) {
                Logger.error(this, "Could not lock UID just randomly generated: " + uid + " - probably indicates broken PRNG");
                throw new LowLevelGetException(3);
            }
            try {
                long rtt2;
                int status;
                Object o = this.node.makeRequestSender(key.getNodeCHK(), this.node.maxHTL(), uid, null, localOnly, cache, ignoreStore, false);
                if (o instanceof CHKBlock) {
                    ClientCHKBlock clientCHKBlock;
                    try {
                        tag.setServedFromDatastore();
                        clientCHKBlock = new ClientCHKBlock((CHKBlock)o, key);
                    }
                    catch (CHKVerifyException e) {
                        Logger.error(this, "Does not verify: " + e, e);
                        throw new LowLevelGetException(1);
                    }
                    Object var18_12 = null;
                    this.node.unlockUID(uid, false, false, true, false, true, tag);
                    return clientCHKBlock;
                }
                if (o == null) {
                    throw new LowLevelGetException(2);
                }
                RequestSender rs = (RequestSender)o;
                boolean rejectedOverload = false;
                short waitStatus = 0;
                do {
                    waitStatus = rs.waitUntilStatusChange(waitStatus);
                    if (!rejectedOverload && (waitStatus & 1) != 0) {
                        this.requestStarters.rejectedOverload(false, false);
                        rejectedOverload = true;
                    }
                    status = rs.getStatus();
                    if (!rs.abortedDownstreamTransfers()) continue;
                    status = 4;
                } while (status == -1);
                if (status != 6 && status != 7 && status != 8) {
                    if (logMINOR) {
                        Logger.minor(this, "CHK fetch cost " + rs.getTotalSentBytes() + '/' + rs.getTotalReceivedBytes() + " bytes (" + status + ')');
                    }
                    this.nodeStats.localChkFetchBytesSentAverage.report(rs.getTotalSentBytes());
                    this.nodeStats.localChkFetchBytesReceivedAverage.report(rs.getTotalReceivedBytes());
                    if (status == 0) {
                        this.nodeStats.successfulChkFetchBytesReceivedAverage.report(rs.getTotalReceivedBytes());
                    }
                }
                if (status == 6 || status == 7) {
                    if (!rejectedOverload) {
                        this.requestStarters.rejectedOverload(false, false);
                        rejectedOverload = true;
                        rtt2 = System.currentTimeMillis() - startTime;
                        this.node.nodeStats.reportCHKTime(rtt2, false);
                    }
                } else if (rs.hasForwarded() && (status == 3 || status == 9 || status == 0 || status == 1 || status == 5 || status == 10)) {
                    rtt2 = System.currentTimeMillis() - startTime;
                    if (!rejectedOverload) {
                        this.requestStarters.requestCompleted(false, false, key.getNodeKey());
                    }
                    this.requestStarters.chkRequestThrottle.successfulCompletion(rtt2);
                    this.node.nodeStats.reportCHKTime(rtt2, status == 0);
                    if (status == 0) {
                        Logger.minor(this, "Successful CHK fetch took " + rtt2);
                    }
                }
                if (status == 0) {
                    try {
                        rtt2 = new ClientCHKBlock(rs.getPRB().getBlock(), rs.getHeaders(), key, true);
                        break block33;
                    }
                    catch (CHKVerifyException e) {
                        Logger.error(this, "Does not verify: " + e, e);
                        throw new LowLevelGetException(1);
                    }
                    catch (AbortedException e) {
                        Logger.error(this, "Impossible: " + e, e);
                        throw new LowLevelGetException(3);
                    }
                }
                switch (status) {
                    case -1: {
                        Logger.error(this, "RS still running in getCHK!: " + rs);
                        throw new LowLevelGetException(3);
                    }
                    case 3: {
                        throw new LowLevelGetException(4);
                    }
                    case 9: {
                        throw new LowLevelGetException(10);
                    }
                    case 1: {
                        throw new LowLevelGetException(5);
                    }
                    case 4: 
                    case 11: {
                        throw new LowLevelGetException(7);
                    }
                    case 5: 
                    case 10: {
                        throw new LowLevelGetException(8);
                    }
                    case 6: 
                    case 7: {
                        throw new LowLevelGetException(6);
                    }
                    case 8: {
                        throw new LowLevelGetException(3);
                    }
                }
                Logger.error(this, "Unknown RequestSender code in getCHK: " + status + " on " + rs);
                throw new LowLevelGetException(3);
            }
            catch (Throwable throwable) {
                Object var18_14 = null;
                this.node.unlockUID(uid, false, false, true, false, true, tag);
                throw throwable;
            }
        }
        Object var18_13 = null;
        this.node.unlockUID(uid, false, false, true, false, true, tag);
        return rtt2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ClientSSKBlock realGetSSK(ClientSSK key, boolean localOnly, boolean cache, boolean ignoreStore) throws LowLevelGetException {
        ClientSSKBlock clientSSKBlock;
        RequestTag tag;
        long uid;
        block29: {
            long startTime = System.currentTimeMillis();
            uid = this.random.nextLong();
            if (!this.node.lockUID(uid, true, false, false, true, tag = new RequestTag(true, RequestTag.START.LOCAL))) {
                Logger.error(this, "Could not lock UID just randomly generated: " + uid + " - probably indicates broken PRNG");
                throw new LowLevelGetException(3);
            }
            try {
                int status;
                Object o = this.node.makeRequestSender(key.getNodeKey(), this.node.maxHTL(), uid, null, localOnly, cache, ignoreStore, false);
                if (o instanceof SSKBlock) {
                    ClientSSKBlock clientSSKBlock2;
                    try {
                        tag.setServedFromDatastore();
                        SSKBlock block = (SSKBlock)o;
                        key.setPublicKey(block.getPubKey());
                        clientSSKBlock2 = ClientSSKBlock.construct(block, key);
                    }
                    catch (SSKVerifyException e) {
                        Logger.error(this, "Does not verify: " + e, e);
                        throw new LowLevelGetException(1);
                    }
                    Object var18_14 = null;
                    this.node.unlockUID(uid, true, false, true, false, true, tag);
                    return clientSSKBlock2;
                }
                if (o == null) {
                    throw new LowLevelGetException(2);
                }
                RequestSender rs = (RequestSender)o;
                boolean rejectedOverload = false;
                short waitStatus = 0;
                do {
                    waitStatus = rs.waitUntilStatusChange(waitStatus);
                    if (rejectedOverload || (waitStatus & 1) == 0) continue;
                    this.requestStarters.rejectedOverload(true, false);
                    rejectedOverload = true;
                } while ((status = rs.getStatus()) == -1);
                if (status != 6 && status != 7 && status != 8) {
                    if (logMINOR) {
                        Logger.minor(this, "SSK fetch cost " + rs.getTotalSentBytes() + '/' + rs.getTotalReceivedBytes() + " bytes (" + status + ')');
                    }
                    this.nodeStats.localSskFetchBytesSentAverage.report(rs.getTotalSentBytes());
                    this.nodeStats.localSskFetchBytesReceivedAverage.report(rs.getTotalReceivedBytes());
                    if (status == 0) {
                        this.nodeStats.successfulSskFetchBytesReceivedAverage.report(rs.getTotalReceivedBytes());
                    }
                }
                if (status == 6 || status == 7) {
                    if (!rejectedOverload) {
                        this.requestStarters.rejectedOverload(true, false);
                        rejectedOverload = true;
                    }
                } else if (rs.hasForwarded() && (status == 3 || status == 9 || status == 0 || status == 1 || status == 5 || status == 10)) {
                    long rtt = System.currentTimeMillis() - startTime;
                    if (!rejectedOverload) {
                        this.requestStarters.requestCompleted(true, false, key.getNodeKey());
                    }
                    this.requestStarters.sskRequestThrottle.successfulCompletion(rtt);
                }
                if (rs.getStatus() == 0) {
                    try {
                        SSKBlock block = rs.getSSKBlock();
                        key.setPublicKey(block.getPubKey());
                        clientSSKBlock = ClientSSKBlock.construct(block, key);
                        break block29;
                    }
                    catch (SSKVerifyException e) {
                        Logger.error(this, "Does not verify: " + e, e);
                        throw new LowLevelGetException(1);
                    }
                }
                switch (rs.getStatus()) {
                    case -1: {
                        Logger.error(this, "RS still running in getCHK!: " + rs);
                        throw new LowLevelGetException(3);
                    }
                    case 3: {
                        throw new LowLevelGetException(4);
                    }
                    case 9: {
                        throw new LowLevelGetException(10);
                    }
                    case 1: {
                        throw new LowLevelGetException(5);
                    }
                    case 4: 
                    case 11: {
                        Logger.error(this, "WTF? Transfer failed on an SSK? on " + uid);
                        throw new LowLevelGetException(7);
                    }
                    case 5: 
                    case 10: {
                        throw new LowLevelGetException(8);
                    }
                    case 6: 
                    case 7: {
                        throw new LowLevelGetException(6);
                    }
                }
                Logger.error(this, "Unknown RequestSender code in getCHK: " + rs.getStatus() + " on " + rs);
                throw new LowLevelGetException(3);
            }
            catch (Throwable throwable) {
                Object var18_16 = null;
                this.node.unlockUID(uid, true, false, true, false, true, tag);
                throw throwable;
            }
        }
        Object var18_15 = null;
        this.node.unlockUID(uid, true, false, true, false, true, tag);
        return clientSSKBlock;
    }

    public void realPut(KeyBlock block, boolean cache) throws LowLevelPutException {
        if (block instanceof CHKBlock) {
            this.realPutCHK((CHKBlock)block, cache);
        } else if (block instanceof SSKBlock) {
            this.realPutSSK((SSKBlock)block, cache);
        } else {
            throw new IllegalArgumentException("Unknown put type " + block.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void realPutCHK(CHKBlock block, boolean cache) throws LowLevelPutException {
        InsertTag tag;
        byte[] data = block.getData();
        byte[] headers = block.getHeaders();
        PartiallyReceivedBlock prb = new PartiallyReceivedBlock(32, 1024, data);
        long uid = this.random.nextLong();
        if (!this.node.lockUID(uid, false, true, false, true, tag = new InsertTag(false, InsertTag.START.LOCAL))) {
            Logger.error(this, "Could not lock UID just randomly generated: " + uid + " - probably indicates broken PRNG");
            throw new LowLevelPutException(1);
        }
        try {
            int status;
            CHKInsertSender cHKInsertSender;
            long startTime = System.currentTimeMillis();
            if (cache) {
                this.node.store(block);
            }
            CHKInsertSender is = this.node.makeInsertSender(block.getKey(), this.node.maxHTL(), uid, null, headers, prb, false, cache);
            boolean hasReceivedRejectedOverload = false;
            while (true) {
                cHKInsertSender = is;
                synchronized (cHKInsertSender) {
                    if (is.getStatus() == -1) {
                        try {
                            is.wait(5000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    if (is.getStatus() != -1) {
                        break;
                    }
                }
                if (hasReceivedRejectedOverload || !is.receivedRejectedOverload()) continue;
                hasReceivedRejectedOverload = true;
                this.requestStarters.rejectedOverload(false, true);
            }
            while (true) {
                cHKInsertSender = is;
                synchronized (cHKInsertSender) {
                    if (is.completed()) {
                        break;
                    }
                    try {
                        is.wait(10000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (!is.anyTransfersFailed() || hasReceivedRejectedOverload) continue;
                hasReceivedRejectedOverload = true;
                this.requestStarters.rejectedOverload(false, true);
            }
            if (logMINOR) {
                Logger.minor(this, "Completed " + uid + " overload=" + hasReceivedRejectedOverload + ' ' + is.getStatusString());
            }
            if (!hasReceivedRejectedOverload && is.sentRequest() && is.uid == uid && (is.getStatus() == 1 || is.getStatus() == 0)) {
                long endTime = System.currentTimeMillis();
                long len = endTime - startTime;
                this.requestStarters.chkInsertThrottle.successfulCompletion(len);
                this.requestStarters.requestCompleted(false, true, block.getKey());
            }
            if ((status = is.getStatus()) != 4 && status != 5 && status != 3 && status != 6) {
                int sent = is.getTotalSentBytes();
                int received = is.getTotalReceivedBytes();
                if (logMINOR) {
                    Logger.minor(this, "Local CHK insert cost " + sent + '/' + received + " bytes (" + status + ')');
                }
                this.nodeStats.localChkInsertBytesSentAverage.report(sent);
                this.nodeStats.localChkInsertBytesReceivedAverage.report(received);
                if (status == 0) {
                    this.nodeStats.successfulChkInsertBytesSentAverage.report(sent);
                }
            }
            if (status == 0) {
                Logger.normal(this, "Succeeded inserting " + block);
                Object var18_23 = null;
                this.node.unlockUID(uid, false, true, true, false, true, tag);
                return;
            }
            String msg = "Failed inserting " + block + " : " + is.getStatusString();
            if (status == 1) {
                msg = msg + " - this is normal on small networks; the data will still be propagated, but it can't find the 20+ nodes needed for full success";
            }
            if (is.getStatus() != 1) {
                Logger.error(this, msg);
            } else {
                Logger.normal(this, msg);
            }
            switch (is.getStatus()) {
                case -1: {
                    Logger.error(this, "IS still running in putCHK!: " + is);
                    throw new LowLevelPutException(1);
                }
                case 4: 
                case 5: {
                    throw new LowLevelPutException(3);
                }
                case 1: {
                    throw new LowLevelPutException(2);
                }
                case 6: {
                    throw new LowLevelPutException(4);
                }
                case 3: {
                    throw new LowLevelPutException(1);
                }
            }
            Logger.error(this, "Unknown CHKInsertSender code in putCHK: " + is.getStatus() + " on " + is);
            throw new LowLevelPutException(1);
        }
        catch (Throwable throwable) {
            Object var18_24 = null;
            this.node.unlockUID(uid, false, true, true, false, true, tag);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void realPutSSK(SSKBlock block, boolean cache) throws LowLevelPutException {
        InsertTag tag;
        long uid = this.random.nextLong();
        if (!this.node.lockUID(uid, true, true, false, true, tag = new InsertTag(true, InsertTag.START.LOCAL))) {
            Logger.error(this, "Could not lock UID just randomly generated: " + uid + " - probably indicates broken PRNG");
            throw new LowLevelPutException(1);
        }
        try {
            int status;
            SSKInsertSender sSKInsertSender;
            long startTime = System.currentTimeMillis();
            SSKBlock altBlock = this.node.fetch(block.getKey(), false);
            if (altBlock != null && !altBlock.equals(block)) {
                throw new LowLevelPutException(5);
            }
            SSKInsertSender is = this.node.makeInsertSender(block, this.node.maxHTL(), uid, null, false, cache);
            boolean hasReceivedRejectedOverload = false;
            while (true) {
                sSKInsertSender = is;
                synchronized (sSKInsertSender) {
                    if (is.getStatus() == -1) {
                        try {
                            is.wait(5000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    if (is.getStatus() != -1) {
                        break;
                    }
                }
                if (hasReceivedRejectedOverload || !is.receivedRejectedOverload()) continue;
                hasReceivedRejectedOverload = true;
                this.requestStarters.rejectedOverload(true, true);
            }
            while (true) {
                sSKInsertSender = is;
                synchronized (sSKInsertSender) {
                    if (is.getStatus() != -1) {
                        break;
                    }
                    try {
                        is.wait(10000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            if (logMINOR) {
                Logger.minor(this, "Completed " + uid + " overload=" + hasReceivedRejectedOverload + ' ' + is.getStatusString());
            }
            if (!hasReceivedRejectedOverload && is.sentRequest() && is.uid == uid && (is.getStatus() == 1 || is.getStatus() == 0)) {
                long endTime = System.currentTimeMillis();
                long rtt = endTime - startTime;
                this.requestStarters.requestCompleted(true, true, block.getKey());
                this.requestStarters.sskInsertThrottle.successfulCompletion(rtt);
            }
            if ((status = is.getStatus()) != 4 && status != 5 && status != 3 && status != 6) {
                int sent = is.getTotalSentBytes();
                int received = is.getTotalReceivedBytes();
                if (logMINOR) {
                    Logger.minor(this, "Local SSK insert cost " + sent + '/' + received + " bytes (" + status + ')');
                }
                this.nodeStats.localSskInsertBytesSentAverage.report(sent);
                this.nodeStats.localSskInsertBytesReceivedAverage.report(received);
                if (status == 0) {
                    this.nodeStats.successfulSskInsertBytesSentAverage.report(sent);
                }
            }
            if (is.hasCollided()) {
                try {
                    this.node.storeInsert(is.getBlock(), true);
                }
                catch (KeyCollisionException e) {
                    Logger.normal(this, "collision race? is=" + is, e);
                }
                throw new LowLevelPutException(5);
            }
            if (cache) {
                try {
                    this.node.storeInsert(block, false);
                }
                catch (KeyCollisionException e) {
                    throw new LowLevelPutException(5);
                }
            }
            if (status == 0) {
                Logger.normal(this, "Succeeded inserting " + block);
                Object var16_23 = null;
                this.node.unlockUID(uid, true, true, true, false, true, tag);
                return;
            }
            String msg = "Failed inserting " + block + " : " + is.getStatusString();
            if (status == 1) {
                msg = msg + " - this is normal on small networks; the data will still be propagated, but it can't find the 20+ nodes needed for full success";
            }
            if (is.getStatus() != 1) {
                Logger.error(this, msg);
            } else {
                Logger.normal(this, msg);
            }
            switch (is.getStatus()) {
                case -1: {
                    Logger.error(this, "IS still running in putCHK!: " + is);
                    throw new LowLevelPutException(1);
                }
                case 4: 
                case 5: {
                    throw new LowLevelPutException(3);
                }
                case 1: {
                    throw new LowLevelPutException(2);
                }
                case 6: {
                    throw new LowLevelPutException(4);
                }
                case 3: {
                    throw new LowLevelPutException(1);
                }
            }
            Logger.error(this, "Unknown CHKInsertSender code in putSSK: " + is.getStatus() + " on " + is);
            throw new LowLevelPutException(1);
        }
        catch (Throwable throwable) {
            Object var16_24 = null;
            this.node.unlockUID(uid, true, true, true, false, true, tag);
            throw throwable;
        }
    }

    public HighLevelSimpleClient makeClient(short prioClass) {
        return this.makeClient(prioClass, false);
    }

    public HighLevelSimpleClient makeClient(short prioClass, boolean forceDontIgnoreTooManyPathComponents) {
        return new HighLevelSimpleClientImpl(this, this.tempBucketFactory, this.random, true, prioClass, forceDontIgnoreTooManyPathComponents);
    }

    public boolean cacheInserts() {
        return true;
    }

    public FCPServer getFCPServer() {
        return this.fcpServer;
    }

    public FProxyToadlet getFProxy() {
        return this.fproxyServlet;
    }

    public SimpleToadletServer getToadletContainer() {
        return this.toadletContainer;
    }

    public TextModeClientInterfaceServer getTextModeClientInterface() {
        return this.tmci;
    }

    public void setFProxy(FProxyToadlet fproxy) {
        this.fproxyServlet = fproxy;
    }

    public TextModeClientInterface getDirectTMCI() {
        return this.directTMCI;
    }

    public void setDirectTMCI(TextModeClientInterface i) {
        this.directTMCI = i;
    }

    public File getDownloadDir() {
        return this.downloadDir;
    }

    public HealingQueue getHealingQueue() {
        return this.healingQueue;
    }

    public void queueRandomReinsert(KeyBlock block) {
        SimpleSendableInsert ssi = new SimpleSendableInsert(this, block, 0);
        if (logMINOR) {
            Logger.minor(this, "Queueing random reinsert for " + block + " : " + ssi);
        }
        ssi.schedule();
    }

    public void storeConfig() {
        Logger.normal(this, "Trying to write config to disk", new Exception("debug"));
        this.node.config.store();
    }

    public boolean isTestnetEnabled() {
        return this.node.isTestnetEnabled();
    }

    public boolean isAdvancedModeEnabled() {
        return this.getToadletContainer() != null && this.getToadletContainer().isAdvancedModeEnabled();
    }

    public boolean isFProxyJavascriptEnabled() {
        return this.getToadletContainer() != null && this.getToadletContainer().isFProxyJavascriptEnabled();
    }

    public String getMyName() {
        return this.node.getMyName();
    }

    public FilterCallback createFilterCallback(URI uri, FoundURICallback cb) {
        if (logMINOR) {
            Logger.minor(this, "Creating filter callback: " + uri + ", " + cb);
        }
        return new GenericReadFilterCallback(uri, cb);
    }

    public int maxBackgroundUSKFetchers() {
        return maxBackgroundUSKFetchers;
    }

    public boolean allowDownloadTo(File filename) {
        if (this.downloadAllowedEverywhere) {
            return true;
        }
        if (this.includeDownloadDir && FileUtil.isParent(this.downloadDir, filename)) {
            return true;
        }
        for (int i = 0; i < this.downloadAllowedDirs.length; ++i) {
            if (!FileUtil.isParent(this.downloadAllowedDirs[i], filename)) continue;
            return true;
        }
        return false;
    }

    public boolean allowUploadFrom(File filename) {
        if (this.uploadAllowedEverywhere) {
            return true;
        }
        for (int i = 0; i < this.uploadAllowedDirs.length; ++i) {
            if (!FileUtil.isParent(this.uploadAllowedDirs[i], filename)) continue;
            return true;
        }
        return false;
    }

    public File[] getAllowedUploadDirs() {
        return this.uploadAllowedDirs;
    }

    public SimpleFieldSet persistThrottlesToFieldSet() {
        return this.requestStarters.persistToFieldSet();
    }

    public Ticker getTicker() {
        return this.node.ps;
    }

    public Executor getExecutor() {
        return this.node.executor;
    }

    public File getPersistentTempDir() {
        return this.persistentTempDir;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public boolean hasLoadedQueue() {
        return this.fcpServer.hasFinishedStart();
    }

    public void maybeQueueOfferedKey(Key key, boolean force) {
        ClientRequestScheduler sched = key instanceof NodeSSK ? this.requestStarters.sskFetchScheduler : this.requestStarters.chkFetchScheduler;
        sched.maybeQueueOfferedKey(key, force);
    }

    public void dequeueOfferedKey(Key key) {
        ClientRequestScheduler sched = key instanceof NodeSSK ? this.requestStarters.sskFetchScheduler : this.requestStarters.chkFetchScheduler;
        sched.dequeueOfferedKey(key);
    }

    public FreenetURI[] getBookmarkURIs() {
        return this.toadletContainer.getBookmarkURIs();
    }

    public long countTransientQueuedRequests() {
        return this.requestStarters.countTransientQueuedRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(DBJob job, int priority, boolean checkDupes) throws DatabaseDisabledException {
        NodeClientCore nodeClientCore = this;
        synchronized (nodeClientCore) {
            if (this.killedDatabase) {
                throw new DatabaseDisabledException();
            }
        }
        if (checkDupes) {
            this.clientDatabaseExecutor.executeNoDupes(new DBJobWrapper(job), priority, "" + job);
        } else {
            this.clientDatabaseExecutor.execute((Runnable)new DBJobWrapper(job), priority, "" + job);
        }
    }

    public boolean onDatabaseThread() {
        return this.clientDatabaseExecutor.onThread();
    }

    public int getQueueSize(int priority) {
        return this.clientDatabaseExecutor.getQueueSize(priority);
    }

    public void handleLowMemory() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleOutOfMemory() throws Exception {
        NodeClientCore nodeClientCore = this;
        synchronized (nodeClientCore) {
            this.killedDatabase = true;
        }
        WrapperManager.requestThreadDump();
        System.err.println("Out of memory: Emergency shutdown to protect database integrity in progress...");
        System.exit(29);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueRestartJob(DBJob job, int priority, ObjectContainer container, boolean early) throws DatabaseDisabledException {
        NodeClientCore nodeClientCore = this;
        synchronized (nodeClientCore) {
            if (this.killedDatabase) {
                throw new DatabaseDisabledException();
            }
        }
        this.restartJobsQueue.queueRestartJob(job, priority, container, early);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRestartJob(DBJob job, int priority, ObjectContainer container) throws DatabaseDisabledException {
        NodeClientCore nodeClientCore = this;
        synchronized (nodeClientCore) {
            if (this.killedDatabase) {
                throw new DatabaseDisabledException();
            }
        }
        this.restartJobsQueue.removeRestartJob(job, priority, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBlocking(final DBJob job, int priority) throws DatabaseDisabledException {
        if (this.clientDatabaseExecutor.onThread()) {
            job.run(this.node.db, this.clientContext);
        } else {
            final MutableBoolean finished = new MutableBoolean();
            this.queue(new DBJob(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean run(ObjectContainer container, ClientContext context) {
                    MutableBoolean mutableBoolean;
                    boolean bl;
                    try {
                        bl = job.run(container, context);
                        Object var5_4 = null;
                        mutableBoolean = finished;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        MutableBoolean mutableBoolean2 = finished;
                        synchronized (mutableBoolean2) {
                            finished.value = true;
                            finished.notifyAll();
                        }
                        throw throwable;
                    }
                    synchronized (mutableBoolean) {
                        finished.value = true;
                        finished.notifyAll();
                    }
                    return bl;
                }
            }, priority, false);
            MutableBoolean mutableBoolean = finished;
            synchronized (mutableBoolean) {
                while (!finished.value) {
                    try {
                        finished.wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
    }

    public boolean objectCanNew(ObjectContainer container) {
        Logger.error(this, "Not storing NodeClientCore in database", new Exception("error"));
        return false;
    }

    public synchronized void killDatabase() {
        this.killedDatabase = true;
    }

    public synchronized boolean killedDatabase() {
        return this.killedDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onIdle() {
        NodeClientCore nodeClientCore = this;
        synchronized (nodeClientCore) {
            if (this.killedDatabase) {
                return;
            }
        }
        this.persistentTempBucketFactory.preCommit(this.node.db);
        this.node.db.commit();
        nodeClientCore = this;
        synchronized (nodeClientCore) {
            this.lastCommitted = System.currentTimeMillis();
        }
        if (logMINOR) {
            Logger.minor(this, "COMMITTED");
        }
        this.persistentTempBucketFactory.postCommit(this.node.db);
    }

    public synchronized void setCommitThisTransaction() {
        this.commitThisTransaction = true;
    }

    static /* synthetic */ NodeRestartJobsQueue.RestartDBJob[] access$1102(NodeClientCore x0, NodeRestartJobsQueue.RestartDBJob[] x1) {
        x0.startupDatabaseJobs = x1;
        return x1;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }

    class DBJobWrapper
    implements Runnable {
        final DBJob job;

        DBJobWrapper(DBJob job) {
            this.job = job;
            if (job == null) {
                throw new NullPointerException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block28: {
                try {
                    boolean killed2;
                    NodeClientCore nodeClientCore = NodeClientCore.this;
                    synchronized (nodeClientCore) {
                        if (NodeClientCore.this.killedDatabase) {
                            Logger.error(this, "Database killed already, not running job");
                            return;
                        }
                    }
                    if (this.job == null) {
                        throw new NullPointerException();
                    }
                    if (NodeClientCore.this.node == null) {
                        throw new NullPointerException();
                    }
                    boolean commit = this.job.run(NodeClientCore.this.node.db, NodeClientCore.this.clientContext);
                    NodeClientCore nodeClientCore2 = NodeClientCore.this;
                    synchronized (nodeClientCore2) {
                        killed2 = NodeClientCore.this.killedDatabase;
                        if (!killed2) {
                            long now = System.currentTimeMillis();
                            if (now - NodeClientCore.this.lastCommitted > 30000L) {
                                NodeClientCore.this.lastCommitted = now;
                                commit = true;
                            }
                            if (NodeClientCore.this.alwaysCommit) {
                                commit = true;
                            }
                            if (NodeClientCore.this.commitThisTransaction) {
                                commit = true;
                                NodeClientCore.this.commitThisTransaction = false;
                            }
                        }
                    }
                    if (killed2) {
                        NodeClientCore.this.node.db.rollback();
                        return;
                    }
                    if (!commit) break block28;
                    NodeClientCore.this.persistentTempBucketFactory.preCommit(NodeClientCore.this.node.db);
                    NodeClientCore.this.node.db.commit();
                    nodeClientCore2 = NodeClientCore.this;
                    synchronized (nodeClientCore2) {
                        NodeClientCore.this.lastCommitted = System.currentTimeMillis();
                    }
                    if (logMINOR) {
                        Logger.minor(this, "COMMITTED");
                    }
                    NodeClientCore.this.persistentTempBucketFactory.postCommit(NodeClientCore.this.node.db);
                }
                catch (Throwable t) {
                    boolean killed;
                    if (t instanceof OutOfMemoryError) {
                        NodeClientCore killed2 = NodeClientCore.this;
                        synchronized (killed2) {
                            NodeClientCore.this.killedDatabase = true;
                        }
                        OOMHandler.handleOOM((OutOfMemoryError)t);
                    } else {
                        Logger.error(this, "Failed to run database job " + this.job + " : caught " + t, t);
                    }
                    NodeClientCore nodeClientCore = NodeClientCore.this;
                    synchronized (nodeClientCore) {
                        killed = NodeClientCore.this.killedDatabase;
                    }
                    if (!killed) break block28;
                    NodeClientCore.this.node.db.rollback();
                }
            }
        }

        public int hashCode() {
            return this.job == null ? 0 : this.job.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof DBJobWrapper)) {
                return false;
            }
            DBJobWrapper cmp = (DBJobWrapper)o;
            return cmp.job == this.job;
        }

        public String toString() {
            return "DBJobWrapper:" + this.job;
        }
    }

    public static interface SimpleRequestSenderCompletionListener {
        public void completed(boolean var1);
    }
}

