/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.config.Configuration;
import com.db4o.diagnostic.ClassHasNoFields;
import com.db4o.diagnostic.Diagnostic;
import com.db4o.diagnostic.DiagnosticBase;
import com.db4o.diagnostic.DiagnosticListener;
import com.db4o.ext.Db4oException;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.StatsConfig;
import freenet.client.FECJob;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.DatastoreCheckerItem;
import freenet.client.async.InsertCompressor;
import freenet.client.async.PersistentCooldownQueueItem;
import freenet.client.async.RegisterMe;
import freenet.clients.http.SimpleToadletServer;
import freenet.config.EnumerableOptionCallback;
import freenet.config.FreenetFilePersistentConfig;
import freenet.config.InvalidConfigValueException;
import freenet.config.NodeNeedRestartException;
import freenet.config.PersistentConfig;
import freenet.config.SubConfig;
import freenet.crypt.DSAPublicKey;
import freenet.crypt.DiffieHellman;
import freenet.crypt.RandomSource;
import freenet.crypt.Yarrow;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.FreenetInetAddress;
import freenet.io.comm.IOStatisticCollector;
import freenet.io.comm.Message;
import freenet.io.comm.MessageCore;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.Peer;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.io.comm.UdpSocketHandler;
import freenet.io.xfer.PartiallyReceivedBlock;
import freenet.keys.CHKBlock;
import freenet.keys.CHKVerifyException;
import freenet.keys.ClientCHK;
import freenet.keys.ClientCHKBlock;
import freenet.keys.ClientKey;
import freenet.keys.ClientKeyBlock;
import freenet.keys.ClientSSK;
import freenet.keys.ClientSSKBlock;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.KeyVerifyException;
import freenet.keys.NodeCHK;
import freenet.keys.NodeSSK;
import freenet.keys.SSKBlock;
import freenet.keys.SSKVerifyException;
import freenet.l10n.L10n;
import freenet.node.Announcer;
import freenet.node.AnyInsertSender;
import freenet.node.CHKInsertSender;
import freenet.node.DNSRequester;
import freenet.node.DarknetPeerNode;
import freenet.node.FSParseException;
import freenet.node.FailureTable;
import freenet.node.GetPubkey;
import freenet.node.InsertTag;
import freenet.node.Location;
import freenet.node.LocationManager;
import freenet.node.LoggingConfigHandler;
import freenet.node.NetworkIDManager;
import freenet.node.NodeClientCore;
import freenet.node.NodeCrypto;
import freenet.node.NodeCryptoConfig;
import freenet.node.NodeDispatcher;
import freenet.node.NodeIPDetector;
import freenet.node.NodeInitException;
import freenet.node.NodeStarter;
import freenet.node.NodeStats;
import freenet.node.NodeToNodeMessageListener;
import freenet.node.OfferReplyTag;
import freenet.node.OpennetDisabledException;
import freenet.node.OpennetManager;
import freenet.node.OpennetPeerNode;
import freenet.node.PacketSender;
import freenet.node.PeerManager;
import freenet.node.PeerNode;
import freenet.node.RequestClient;
import freenet.node.RequestSender;
import freenet.node.RequestTag;
import freenet.node.SSKInsertSender;
import freenet.node.SecurityLevelListener;
import freenet.node.SecurityLevels;
import freenet.node.SeedServerTestPeerNode;
import freenet.node.SemiOrderedShutdownHook;
import freenet.node.TestnetHandler;
import freenet.node.Ticker;
import freenet.node.TimeSkewDetectorCallback;
import freenet.node.UIDTag;
import freenet.node.UptimeEstimator;
import freenet.node.Version;
import freenet.node.fcp.FCPClient;
import freenet.node.updater.NodeUpdateManager;
import freenet.node.useralerts.AbstractUserAlert;
import freenet.node.useralerts.BuildOldAgeUserAlert;
import freenet.node.useralerts.ClockProblemDetectedUserAlert;
import freenet.node.useralerts.ExtOldAgeUserAlert;
import freenet.node.useralerts.MeaningfulNodeNameUserAlert;
import freenet.node.useralerts.NotEnoughNiceLevelsUserAlert;
import freenet.node.useralerts.SimpleUserAlert;
import freenet.node.useralerts.TimeSkewDetectedUserAlert;
import freenet.pluginmanager.ForwardPort;
import freenet.pluginmanager.PluginManager;
import freenet.store.BerkeleyDBFreenetStore;
import freenet.store.CHKStore;
import freenet.store.FreenetStore;
import freenet.store.KeyCollisionException;
import freenet.store.PubkeyStore;
import freenet.store.RAMFreenetStore;
import freenet.store.SSKStore;
import freenet.store.saltedhash.SaltedHashFreenetStore;
import freenet.support.Executor;
import freenet.support.Fields;
import freenet.support.FileLoggerHook;
import freenet.support.HTMLEncoder;
import freenet.support.HTMLNode;
import freenet.support.HexUtil;
import freenet.support.LRUQueue;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.OOMHandler;
import freenet.support.PooledExecutor;
import freenet.support.ShortBuffer;
import freenet.support.SimpleFieldSet;
import freenet.support.TokenBucket;
import freenet.support.api.BooleanCallback;
import freenet.support.api.IntCallback;
import freenet.support.api.LongCallback;
import freenet.support.api.ShortCallback;
import freenet.support.api.StringCallback;
import freenet.support.io.ArrayBucketFactory;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import freenet.support.io.NativeThread;
import freenet.support.io.PersistentBlobTempBucketTag;
import freenet.support.transport.ip.HostnameSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import org.spaceroots.mantissa.random.MersenneTwister;
import org.tanukisoftware.wrapper.WrapperManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node
implements TimeSkewDetectorCallback {
    private static volatile boolean logMINOR;
    private static MeaningfulNodeNameUserAlert nodeNameUserAlert;
    private static BuildOldAgeUserAlert buildOldAgeUserAlert;
    private static TimeSkewDetectedUserAlert timeSkewDetectedUserAlert;
    private static final ClockProblemDetectedUserAlert clockProblemDetectedUserAlert;
    public final ObjectContainer db;
    public final long nodeDBHandle;
    public final NodeStats nodeStats;
    public final NetworkIDManager netid;
    public final PersistentConfig config;
    static File logDir;
    static long maxLogSize;
    public static LoggingConfigHandler logConfigHandler;
    public static final boolean DONT_CACHE_LOCAL_REQUESTS = false;
    public static final int PACKETS_IN_BLOCK = 32;
    public static final int PACKET_SIZE = 1024;
    public static final double DECREMENT_AT_MIN_PROB = 0.25;
    public static final double DECREMENT_AT_MAX_PROB = 0.1;
    public static final int KEEPALIVE_INTERVAL = 14000;
    public static final int MAX_PEER_INACTIVITY = 60000;
    public static final int HANDSHAKE_TIMEOUT = 4800;
    public static final int MIN_TIME_BETWEEN_HANDSHAKE_SENDS = 9600;
    public static final int RANDOMIZED_TIME_BETWEEN_HANDSHAKE_SENDS = 9600;
    public static final int MIN_TIME_BETWEEN_VERSION_PROBES = 19200;
    public static final int RANDOMIZED_TIME_BETWEEN_VERSION_PROBES = 9600;
    public static final int MIN_TIME_BETWEEN_VERSION_SENDS = 19200;
    public static final int RANDOMIZED_TIME_BETWEEN_VERSION_SENDS = 9600;
    public static final int MIN_TIME_BETWEEN_BURSTING_HANDSHAKE_BURSTS = 115200;
    public static final int RANDOMIZED_TIME_BETWEEN_BURSTING_HANDSHAKE_BURSTS = 172800;
    public static final int MIN_BURSTING_HANDSHAKE_BURST_SIZE = 1;
    public static final int RANDOMIZED_BURSTING_HANDSHAKE_BURST_SIZE = 3;
    public static final long ALARM_TIME = 60000L;
    static final int MIN_INTERVAL_BETWEEN_INCOMING_SWAP_REQUESTS = 900;
    static final int MIN_INTERVAL_BETWEEN_INCOMING_PROBE_REQUESTS = 1000;
    public static final int SYMMETRIC_KEY_LENGTH = 32;
    static final long TESTNET_MIN_MAX_ZIPPED_LOGFILES = 0x20000000L;
    static final String TESTNET_MIN_MAX_ZIPPED_LOGFILES_STRING = "512M";
    private final File storeDir;
    private final String storeType;
    private int storeBloomFilterSize;
    private final boolean storeBloomFilterCounting;
    private boolean storeSaltHashResizeOnStart;
    static final int sizePerKey = 34988;
    private long maxTotalKeys;
    long maxCacheKeys;
    long maxStoreKeys;
    private long maxTotalDatastoreSize;
    private boolean storeForceBigShrinks;
    private Environment storeEnvironment;
    private EnvironmentMutableConfig envMutableConfig;
    private final SemiOrderedShutdownHook shutdownHook;
    private long databaseMaxMemory;
    private CHKStore chkDatastore;
    private SSKStore sskDatastore;
    private PubkeyStore pubKeyDatastore;
    private CHKStore chkDatacache;
    private SSKStore sskDatacache;
    private PubkeyStore pubKeyDatacache;
    GetPubkey getPubKey;
    private final HashMap<KeyHTLPair, RequestSender> requestSenders;
    private final HashMap<NodeCHK, RequestSender> transferringRequestSenders;
    private final HashSet<Long> transferringRequestHandlers;
    private final HashMap<KeyHTLPair, AnyInsertSender> insertSenders;
    public final FetchContext arkFetcherContext;
    public final NodeIPDetector ipDetector;
    boolean disableProbabilisticHTLs;
    private final HashMap<Long, UIDTag> runningUIDs;
    private final HashMap<Long, RequestTag> runningCHKGetUIDs;
    private final HashMap<Long, RequestTag> runningLocalCHKGetUIDs;
    private final HashMap<Long, RequestTag> runningSSKGetUIDs;
    private final HashMap<Long, RequestTag> runningLocalSSKGetUIDs;
    private final HashMap<Long, InsertTag> runningCHKPutUIDs;
    private final HashMap<Long, InsertTag> runningLocalCHKPutUIDs;
    private final HashMap<Long, InsertTag> runningSSKPutUIDs;
    private final HashMap<Long, InsertTag> runningLocalSSKPutUIDs;
    private final HashMap<Long, OfferReplyTag> runningCHKOfferReplyUIDs;
    private final HashMap<Long, OfferReplyTag> runningSSKOfferReplyUIDs;
    public long swapIdentifier;
    private String myName;
    public final LocationManager lm;
    public final PeerManager peers;
    final File nodeDir;
    final File extraPeerDataDir;
    public final RandomSource random;
    public final Random fastWeakRandom;
    final MessageCore usm;
    NodeCrypto darknetCrypto;
    private final NodeCryptoConfig opennetCryptoConfig;
    OpennetManager opennet;
    private volatile boolean isAllowedToConnectToSeednodes;
    private int maxOpennetPeers;
    private boolean acceptSeedConnections;
    private boolean passOpennetRefsThroughDarknet;
    public final Executor executor;
    public final PacketSender ps;
    final DNSRequester dnsr;
    final NodeDispatcher dispatcher;
    public final UptimeEstimator uptime;
    final boolean testnetEnabled;
    final TestnetHandler testnetHandler;
    public final TokenBucket outputThrottle;
    public boolean throttleLocalData;
    private int outputBandwidthLimit;
    private int inputBandwidthLimit;
    boolean inputLimitDefault;
    final boolean enableARKs;
    final boolean enablePerNodeFailureTables;
    final boolean enableULPRDataPropagation;
    final boolean enableSwapping;
    private volatile boolean publishOurPeersLocation;
    private volatile boolean routeAccordingToOurPeersLocation;
    boolean enableSwapQueueing;
    boolean enablePacketCoalescing;
    public static final short DEFAULT_MAX_HTL = 10;
    private short maxHTL;
    public final IOStatisticCollector collector;
    public static final int N2N_MESSAGE_TYPE_FPROXY = 1;
    public static final int N2N_MESSAGE_TYPE_DIFFNODEREF = 2;
    public static final int N2N_TEXT_MESSAGE_TYPE_USERALERT = 1;
    public static final int N2N_TEXT_MESSAGE_TYPE_FILE_OFFER = 2;
    public static final int N2N_TEXT_MESSAGE_TYPE_FILE_OFFER_ACCEPTED = 3;
    public static final int N2N_TEXT_MESSAGE_TYPE_FILE_OFFER_REJECTED = 4;
    public static final int EXTRA_PEER_DATA_TYPE_N2NTM = 1;
    public static final int EXTRA_PEER_DATA_TYPE_PEER_NOTE = 2;
    public static final int EXTRA_PEER_DATA_TYPE_QUEUED_TO_SEND_N2NM = 3;
    public static final int PEER_NOTE_TYPE_PRIVATE_DARKNET_COMMENT = 1;
    public final long lastBootID;
    public final long bootID;
    public final long startupTime;
    private SimpleToadletServer toadlets;
    public final NodeClientCore clientCore;
    final FailureTable failureTable;
    public int lastVersion;
    public final NodeUpdateManager nodeUpdater;
    public final SecurityLevels securityLevels;
    public final PluginManager pluginManager;
    public final InetAddress localhostAddress;
    public final FreenetInetAddress fLocalhostAddress;
    private boolean wasTestnet;
    private static NodeStarter nodeStarter;
    private boolean hasStarted;
    private boolean isStopping;
    private static final int MIN_UPTIME_STORE_KEY = 40;
    private volatile boolean isPRNGReady;
    private boolean storePreallocate;
    private final Object writeNodeFileSync;
    private static boolean jvmHasGCJCharConversionBug;
    long timeLastDumpedHits;
    final boolean decrementAtMax;
    final boolean decrementAtMin;
    static final int TIMEOUT = 600000;
    private Runnable deadUIDChecker;
    final LRUQueue<Long> recentlyCompletedIDs;
    static final int MAX_RECENTLY_COMPLETED_IDS = 10000;
    static final int SIGNATURE_PARAMETER_LENGTH = 32;
    private Map<Integer, NodeToNodeMessageListener> n2nmListeners;
    private NodeToNodeMessageListener diffNoderefListener;
    private NodeToNodeMessageListener fproxyN2NMListener;
    private volatile Object statsSync;
    private long totalPayloadSent;
    private SimpleUserAlert alertMTUTooSmall;
    public final RequestClient nonPersistentClient;
    private volatile long turtleCount;
    private static int MAX_TURTLES;
    private static int MAX_TURTLES_PER_KEY;
    private HashMap<Key, RequestSender[]> turtlingTransfers;

    private void readNodeFile(String filename) throws IOException {
        String verString;
        FileInputStream fis = new FileInputStream(filename);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
        BufferedReader br = new BufferedReader(isr);
        SimpleFieldSet fs = new SimpleFieldSet(br, false, true);
        br.close();
        String[] udp = fs.getAll("physical.udp");
        if (udp != null && udp.length > 0) {
            for (String udpAddr : udp) {
                Peer p;
                try {
                    p = new Peer(udpAddr, false, true);
                }
                catch (HostnameSyntaxException e) {
                    Logger.error(this, "Invalid hostname or IP Address syntax error while parsing our darknet node reference: " + udpAddr);
                    System.err.println("Invalid hostname or IP Address syntax error while parsing our darknet node reference: " + udpAddr);
                    continue;
                }
                catch (PeerParseException e) {
                    IOException e1 = new IOException();
                    e1.initCause(e);
                    throw e1;
                }
                if (p.getPort() != this.getDarknetPortNumber()) continue;
                this.ipDetector.setOldIPAddress(p.getFreenetAddress());
                break;
            }
        }
        this.darknetCrypto.readCrypto(fs);
        this.swapIdentifier = Fields.bytesToLong(this.darknetCrypto.identityHashHash);
        String loc = fs.get("location");
        double locD = Location.getLocation(loc);
        if (locD == -1.0) {
            throw new IOException("Invalid location: " + loc);
        }
        this.lm.setLocation(locD);
        this.myName = fs.get("myName");
        if (this.myName == null) {
            this.myName = this.newName();
        }
        if ((verString = fs.get("version")) == null) {
            Logger.error(this, "No version!");
            System.err.println("No version!");
        } else {
            this.lastVersion = Version.getArbitraryBuildNumber(verString, -1);
        }
        this.wasTestnet = Fields.stringToBool(fs.get("testnet"), false);
    }

    private String newName() {
        return "Node id|" + this.random.nextLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeNodeFile() {
        Object object = this.writeNodeFileSync;
        synchronized (object) {
            this.writeNodeFile(new File(this.nodeDir, "node-" + this.getDarknetPortNumber()), new File(this.nodeDir, "node-" + this.getDarknetPortNumber() + ".bak"));
        }
    }

    public void writeOpennetFile() {
        OpennetManager om = this.opennet;
        if (om != null) {
            om.writeFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNodeFile(File orig, File backup) {
        SimpleFieldSet fs = this.darknetCrypto.exportPrivateFieldSet();
        if (orig.exists()) {
            backup.delete();
        }
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(backup);
                fs.writeTo(fos);
                FileUtil.renameTo(backup, orig);
            }
            catch (IOException ioe) {
                Logger.error(this, "IOE :" + ioe.getMessage(), ioe);
                Object var7_6 = null;
                Closer.close(fos);
                return;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Closer.close(fos);
            throw throwable;
        }
        Closer.close(fos);
    }

    private void initNodeFileSettings() {
        Logger.normal(this, "Creating new node file from scratch");
        this.darknetCrypto.initCrypto();
        this.swapIdentifier = Fields.bytesToLong(this.darknetCrypto.identityHashHash);
        this.myName = this.newName();
    }

    public static void main(String[] args) throws IOException {
        NodeStarter.main(args);
    }

    public boolean isUsingWrapper() {
        return nodeStarter != null && WrapperManager.isControlledByNativeWrapper();
    }

    public NodeStarter getNodeStarter() {
        return nodeStarter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Node(PersistentConfig config, RandomSource r, RandomSource weakRandom, LoggingConfigHandler lc, NodeStarter ns, Executor executor) throws NodeInitException {
        long oldBootID;
        SubConfig fproxyConfig;
        int sortOrder;
        SubConfig nodeConfig;
        SimpleFieldSet oldConfig;
        block83: {
            ObjectContainer database;
            this.getPubKey = new GetPubkey();
            this.isStopping = false;
            this.isPRNGReady = false;
            this.writeNodeFileSync = new Object();
            this.deadUIDChecker = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        this.checkUIDs(Node.this.runningLocalSSKGetUIDs);
                        this.checkUIDs(Node.this.runningLocalCHKGetUIDs);
                        this.checkUIDs(Node.this.runningLocalSSKPutUIDs);
                        this.checkUIDs(Node.this.runningLocalCHKPutUIDs);
                        this.checkUIDs(Node.this.runningSSKGetUIDs);
                        this.checkUIDs(Node.this.runningCHKGetUIDs);
                        this.checkUIDs(Node.this.runningSSKPutUIDs);
                        this.checkUIDs(Node.this.runningCHKPutUIDs);
                        this.checkUIDs(Node.this.runningSSKOfferReplyUIDs);
                        this.checkUIDs(Node.this.runningCHKOfferReplyUIDs);
                        Object var2_1 = null;
                        Node.this.getTicker().queueTimedJob(this, 60000L);
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        Node.this.getTicker().queueTimedJob(this, 60000L);
                        throw throwable;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void checkUIDs(HashMap<Long, ? extends UIDTag> map) {
                    UIDTag[] tags;
                    Long[] uids;
                    HashMap<Long, ? extends UIDTag> hashMap = map;
                    synchronized (hashMap) {
                        uids = map.keySet().toArray(new Long[map.size()]);
                        tags = map.values().toArray(new UIDTag[map.size()]);
                    }
                    long now = System.currentTimeMillis();
                    for (int i = 0; i < uids.length; ++i) {
                        if (now - tags[i].createdTime <= 600000L) continue;
                        tags[i].logStillPresent(uids[i]);
                        HashMap<Long, ? extends UIDTag> hashMap2 = map;
                        synchronized (hashMap2) {
                            map.remove(uids[i]);
                            continue;
                        }
                    }
                }
            };
            this.n2nmListeners = new HashMap<Integer, NodeToNodeMessageListener>();
            this.diffNoderefListener = new NodeToNodeMessageListener(){

                public void handleMessage(byte[] data, boolean fromDarknet, PeerNode src, int type) {
                    Logger.normal(this, "Received differential node reference node to node message from " + src.getPeer());
                    SimpleFieldSet fs = null;
                    try {
                        fs = new SimpleFieldSet(new String(data, "UTF-8"), false, true);
                    }
                    catch (IOException e) {
                        Logger.error(this, "IOException while parsing node to node message data", e);
                        return;
                    }
                    if (fs.get("n2nType") != null) {
                        fs.removeValue("n2nType");
                    }
                    try {
                        src.processDiffNoderef(fs);
                    }
                    catch (FSParseException e) {
                        Logger.error(this, "FSParseException while parsing node to node message data", e);
                        return;
                    }
                }
            };
            this.fproxyN2NMListener = new NodeToNodeMessageListener(){

                public void handleMessage(byte[] data, boolean fromDarknet, PeerNode src, int type) {
                    if (!fromDarknet) {
                        Logger.error(this, "Got N2NTM from non-darknet node ?!?!?!: from " + src);
                        return;
                    }
                    DarknetPeerNode darkSource = (DarknetPeerNode)src;
                    Logger.normal(this, "Received N2NTM from '" + darkSource.getPeer() + "'");
                    SimpleFieldSet fs = null;
                    try {
                        fs = new SimpleFieldSet(new String(data, "UTF-8"), false, true);
                    }
                    catch (IOException e) {
                        Logger.error(this, "IOException while parsing node to node message data", e);
                        return;
                    }
                    if (fs.get("n2nType") != null) {
                        fs.removeValue("n2nType");
                    }
                    fs.putOverwrite("n2nType", Integer.toString(type));
                    if (fs.get("receivedTime") != null) {
                        fs.removeValue("receivedTime");
                    }
                    fs.putOverwrite("receivedTime", Long.toString(System.currentTimeMillis()));
                    if (fs.get("receivedAs") != null) {
                        fs.removeValue("receivedAs");
                    }
                    fs.putOverwrite("receivedAs", "nodeToNodeMessage");
                    int fileNumber = darkSource.writeNewExtraPeerDataFile(fs, 1);
                    if (fileNumber == -1) {
                        Logger.error(this, "Failed to write N2NTM to extra peer data file for peer " + darkSource.getPeer());
                    }
                    try {
                        Node.this.handleNodeToNodeTextMessageSimpleFieldSet(fs, darkSource, fileNumber);
                    }
                    catch (FSParseException e) {
                        throw new Error(e);
                    }
                }
            };
            this.statsSync = new Object();
            this.nonPersistentClient = new RequestClient(){

                public boolean persistent() {
                    return false;
                }

                public void removeFrom(ObjectContainer container) {
                    throw new UnsupportedOperationException();
                }
            };
            this.turtlingTransfers = new HashMap();
            String tmp = "Initializing Node using Freenet Build #" + Version.buildNumber() + " r" + "build01217" + " and freenet-ext Build #" + NodeStarter.extBuildNumber + " r" + NodeStarter.extRevisionNumber + " with " + System.getProperty("java.vendor") + " JVM version " + System.getProperty("java.version") + " running on " + System.getProperty("os.arch") + ' ' + System.getProperty("os.name") + ' ' + System.getProperty("os.version");
            Logger.normal(this, tmp);
            System.out.println(tmp);
            this.collector = new IOStatisticCollector();
            this.executor = executor;
            nodeStarter = ns;
            if (logConfigHandler != lc) {
                logConfigHandler = lc;
            }
            this.startupTime = System.currentTimeMillis();
            oldConfig = config.getSimpleFieldSet();
            nodeConfig = new SubConfig("node", config);
            sortOrder = 0;
            nodeConfig.register("l10n", Locale.getDefault().getLanguage().toLowerCase(), sortOrder++, false, true, "Node.l10nLanguage", "Node.l10nLanguageLong", new L10nCallback());
            try {
                L10n.setLanguage(nodeConfig.getString("l10n"));
            }
            catch (MissingResourceException e) {
                try {
                    L10n.setLanguage(nodeConfig.getOption("l10n").getDefault());
                }
                catch (MissingResourceException e1) {
                    L10n.setLanguage(L10n.LANGUAGE.getDefault().shortCode);
                }
            }
            fproxyConfig = new SubConfig("fproxy", config);
            try {
                this.toadlets = new SimpleToadletServer(fproxyConfig, new ArrayBucketFactory(), executor);
                fproxyConfig.finishedInitialization();
                this.toadlets.start();
            }
            catch (IOException e4) {
                Logger.error(this, "Could not start web interface: " + e4, e4);
                System.err.println("Could not start web interface: " + e4);
                e4.printStackTrace();
                throw new NodeInitException(18, "Could not start FProxy: " + e4);
            }
            catch (InvalidConfigValueException e4) {
                System.err.println("Invalid config value, cannot start web interface: " + e4);
                e4.printStackTrace();
                throw new NodeInitException(18, "Could not start FProxy: " + e4);
            }
            if (r == null) {
                NativeThread entropyGatheringThread = new NativeThread(new Runnable(){

                    private void recurse(File f) {
                        if (Node.this.isPRNGReady) {
                            return;
                        }
                        File[] subDirs = f.listFiles(new FileFilter(){

                            public boolean accept(File pathname) {
                                return pathname.exists() && pathname.canRead() && pathname.isDirectory();
                            }
                        });
                        if (subDirs != null) {
                            for (File currentDir : subDirs) {
                                this.recurse(currentDir);
                            }
                        }
                    }

                    public void run() {
                        for (File root : File.listRoots()) {
                            if (Node.this.isPRNGReady) {
                                return;
                            }
                            this.recurse(root);
                        }
                    }
                }, "Entropy Gathering Thread", 1, true);
                entropyGatheringThread.start();
                this.random = new Yarrow();
                DiffieHellman.init(this.random);
            } else {
                this.random = r;
            }
            this.isPRNGReady = true;
            this.toadlets.getStartupToadlet().setIsPRNGReady();
            if (weakRandom == null) {
                byte[] buffer = new byte[16];
                this.random.nextBytes(buffer);
                this.fastWeakRandom = new MersenneTwister(buffer);
            } else {
                this.fastWeakRandom = weakRandom;
            }
            nodeNameUserAlert = new MeaningfulNodeNameUserAlert(this);
            this.recentlyCompletedIDs = new LRUQueue();
            this.config = config;
            this.lm = new LocationManager(this.random, this);
            try {
                this.localhostAddress = InetAddress.getByName("127.0.0.1");
            }
            catch (UnknownHostException e3) {
                throw new Error(e3);
            }
            this.fLocalhostAddress = new FreenetInetAddress(this.localhostAddress);
            this.requestSenders = new HashMap();
            this.transferringRequestSenders = new HashMap();
            this.transferringRequestHandlers = new HashSet();
            this.insertSenders = new HashMap();
            this.runningUIDs = new HashMap();
            this.runningCHKGetUIDs = new HashMap();
            this.runningLocalCHKGetUIDs = new HashMap();
            this.runningSSKGetUIDs = new HashMap();
            this.runningLocalSSKGetUIDs = new HashMap();
            this.runningCHKPutUIDs = new HashMap();
            this.runningLocalCHKPutUIDs = new HashMap();
            this.runningSSKPutUIDs = new HashMap();
            this.runningLocalSSKPutUIDs = new HashMap();
            this.runningCHKOfferReplyUIDs = new HashMap();
            this.runningSSKOfferReplyUIDs = new HashMap();
            this.securityLevels = new SecurityLevels(this, config);
            nodeConfig.register("nodeDir", ".", sortOrder++, true, true, "Node.nodeDir", "Node.nodeDirLong", new StringCallback(){

                public String get() {
                    return Node.this.nodeDir.getPath();
                }

                public void set(String val) throws InvalidConfigValueException {
                    if (Node.this.nodeDir.equals(new File(val))) {
                        return;
                    }
                    throw new InvalidConfigValueException("Moving node directory on the fly not supported at present");
                }

                public boolean isReadOnly() {
                    return true;
                }
            });
            this.nodeDir = new File(nodeConfig.getString("nodeDir"));
            if (!(this.nodeDir.exists() && this.nodeDir.isDirectory() || this.nodeDir.mkdir())) {
                String msg = "Could not find or create datastore directory";
                throw new NodeInitException(15, msg);
            }
            this.shutdownHook = new SemiOrderedShutdownHook();
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            Configuration dbConfig = Db4o.newConfiguration();
            dbConfig.freespace().useBTreeSystem();
            dbConfig.objectClass(PersistentCooldownQueueItem.class).objectField("key").indexed(true);
            dbConfig.objectClass(PersistentCooldownQueueItem.class).objectField("keyAsBytes").indexed(true);
            dbConfig.objectClass(PersistentCooldownQueueItem.class).objectField("time").indexed(true);
            dbConfig.objectClass(RegisterMe.class).objectField("core").indexed(true);
            dbConfig.objectClass(RegisterMe.class).objectField("priority").indexed(true);
            dbConfig.objectClass(PersistentCooldownQueueItem.class).objectField("time").indexed(true);
            dbConfig.objectClass(FECJob.class).objectField("priority").indexed(true);
            dbConfig.objectClass(FECJob.class).objectField("addedTime").indexed(true);
            dbConfig.objectClass(FECJob.class).objectField("queue").indexed(true);
            dbConfig.objectClass(InsertCompressor.class).objectField("nodeDBHandle").indexed(true);
            dbConfig.objectClass(FCPClient.class).objectField("name").indexed(true);
            dbConfig.objectClass(DatastoreCheckerItem.class).objectField("prio").indexed(true);
            dbConfig.objectClass(PersistentBlobTempBucketTag.class).objectField("index").indexed(true);
            dbConfig.objectClass(PersistentBlobTempBucketTag.class).objectField("bucket").indexed(true);
            dbConfig.objectClass(PersistentBlobTempBucketTag.class).objectField("factory").indexed(true);
            dbConfig.objectClass(PersistentBlobTempBucketTag.class).objectField("isFree").indexed(true);
            dbConfig.objectClass(FetchException.class).cascadeOnDelete(true);
            dbConfig.messageLevel(1);
            dbConfig.activationDepth(1);
            dbConfig.automaticShutDown(false);
            dbConfig.blockSize(8);
            dbConfig.diagnostic().addListener(new DiagnosticListener(){

                public void onDiagnostic(Diagnostic arg0) {
                    if (arg0 instanceof ClassHasNoFields) {
                        return;
                    }
                    if (arg0 instanceof DiagnosticBase) {
                        DiagnosticBase d = (DiagnosticBase)arg0;
                        Logger.debug(this, "Diagnostic: " + d.getClass() + " : " + d.problem() + " : " + d.solution() + " : " + d.reason(), new Exception("debug"));
                    } else {
                        Logger.debug(this, "Diagnostic: " + arg0 + " : " + arg0.getClass(), new Exception("debug"));
                    }
                }
            });
            this.shutdownHook.addEarlyJob(new Thread(){

                public void run() {
                    System.err.println("Stopping database jobs...");
                    if (Node.this.clientCore == null) {
                        return;
                    }
                    Node.this.clientCore.killDatabase();
                }
            });
            this.shutdownHook.addLateJob(new Thread(){

                public void run() {
                    if (Node.this.db == null) {
                        return;
                    }
                    System.err.println("Rolling back unfinished transactions...");
                    Node.this.db.rollback();
                    System.err.println("Closing database...");
                    Node.this.db.close();
                }
            });
            System.err.println("Optimise native queries: " + dbConfig.optimizeNativeQueries());
            System.err.println("Query activation depth: " + dbConfig.activationDepth());
            try {
                database = Db4o.openFile((Configuration)dbConfig, (String)new File(this.nodeDir, "node.db4o").toString());
                System.err.println("Opened database");
            }
            catch (Db4oException e) {
                database = null;
                System.err.println("Failed to open database: " + (Object)((Object)e));
                e.printStackTrace();
            }
            if (Logger.shouldLog(2, ClientRequestScheduler.class) && database != null) {
                try {
                    System.err.println("DUMPING DATABASE CONTENTS:");
                    ObjectSet contents = database.queryByExample(new Object());
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    for (Object o : contents) {
                        String name = o.getClass().getName();
                        if (map.get(name) != null) {
                            map.put(name, (Integer)map.get(name) + 1);
                        } else {
                            map.put(name, 1);
                        }
                        try {
                            Logger.minor(this, "DATABASE: " + o.getClass() + ":" + o + ":" + database.ext().getID(o));
                        }
                        catch (Throwable t) {
                            Logger.minor(this, "CAUGHT " + t + " FOR CLASS " + o.getClass());
                        }
                        database.deactivate(o, 1);
                    }
                    int total = 0;
                    for (Map.Entry entry : map.entrySet()) {
                        System.err.println((String)entry.getKey() + " : " + entry.getValue());
                        total += ((Integer)entry.getValue()).intValue();
                    }
                    System.gc();
                    System.runFinalization();
                    System.gc();
                    System.runFinalization();
                    System.err.println("END DATABASE DUMP: " + total + " objects");
                }
                catch (Db4oException e) {
                    System.err.println("Unable to dump database contents. Treating as corrupt database.");
                    e.printStackTrace();
                    try {
                        database.rollback();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    try {
                        database.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    database = null;
                }
                catch (IllegalArgumentException e) {
                    System.err.println("Unable to dump database contents. Treating as corrupt database.");
                    e.printStackTrace();
                    try {
                        database.rollback();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    try {
                        database.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    database = null;
                }
            }
            this.db = database;
            this.bootID = this.random.nextLong();
            File bootIDFile = new File(this.nodeDir, "bootID");
            int BOOT_FILE_LENGTH = 16;
            oldBootID = -1L;
            RandomAccessFile raf = null;
            try {
                Object var23_41;
                try {
                    raf = new RandomAccessFile(bootIDFile, "rw");
                    if (raf.length() < (long)BOOT_FILE_LENGTH) {
                        oldBootID = -1L;
                    } else {
                        byte[] buf = new byte[BOOT_FILE_LENGTH];
                        raf.readFully(buf);
                        String s = new String(buf, "ISO-8859-1");
                        try {
                            oldBootID = Fields.bytesToLong(HexUtil.hexToBytes(s));
                        }
                        catch (NumberFormatException e) {
                            oldBootID = -1L;
                        }
                        raf.seek(0L);
                    }
                    String s = HexUtil.bytesToHex(Fields.longToBytes(this.bootID));
                    byte[] buf = s.getBytes("ISO-8859-1");
                    if (buf.length != BOOT_FILE_LENGTH) {
                        System.err.println("Not 16 bytes for boot ID " + this.bootID + " - WTF??");
                    }
                    raf.write(buf);
                }
                catch (IOException e) {
                    oldBootID = -1L;
                    var23_41 = null;
                    Closer.close(raf);
                    break block83;
                }
                var23_41 = null;
            }
            catch (Throwable throwable) {
                Object var23_42 = null;
                Closer.close(raf);
                throw throwable;
            }
            Closer.close(raf);
        }
        this.lastBootID = oldBootID;
        buildOldAgeUserAlert = new BuildOldAgeUserAlert();
        nodeConfig.register("disableProbabilisticHTLs", false, sortOrder++, true, false, "Node.disablePHTLS", "Node.disablePHTLSLong", new BooleanCallback(){

            public Boolean get() {
                return Node.this.disableProbabilisticHTLs;
            }

            public void set(Boolean val) throws InvalidConfigValueException {
                Node.this.disableProbabilisticHTLs = val;
            }
        });
        this.disableProbabilisticHTLs = nodeConfig.getBoolean("disableProbabilisticHTLs");
        nodeConfig.register("maxHTL", (short)10, sortOrder++, true, false, "Node.maxHTL", "Node.maxHTLLong", new ShortCallback(){

            public Short get() {
                return Node.this.maxHTL;
            }

            public void set(Short val) throws InvalidConfigValueException {
                if (Node.this.maxHTL < 0) {
                    throw new InvalidConfigValueException("Impossible max HTL");
                }
                Node.this.maxHTL = val;
            }
        }, false);
        this.maxHTL = nodeConfig.getShort("maxHTL");
        this.decrementAtMax = this.random.nextDouble() <= 0.1;
        this.decrementAtMin = this.random.nextDouble() <= 0.25;
        this.usm = new MessageCore();
        this.ipDetector = new NodeIPDetector(this);
        sortOrder = this.ipDetector.registerConfigs(nodeConfig, sortOrder);
        nodeConfig.register("enableARKs", true, sortOrder++, true, false, "Node.enableARKs", "Node.enableARKsLong", new BooleanCallback(){

            public Boolean get() {
                return Node.this.enableARKs;
            }

            public void set(Boolean val) throws InvalidConfigValueException {
                throw new InvalidConfigValueException("Cannot change on the fly");
            }

            public boolean isReadOnly() {
                return true;
            }
        });
        this.enableARKs = nodeConfig.getBoolean("enableARKs");
        nodeConfig.register("enablePerNodeFailureTables", true, sortOrder++, true, false, "Node.enablePerNodeFailureTables", "Node.enablePerNodeFailureTablesLong", new BooleanCallback(){

            public Boolean get() {
                return Node.this.enablePerNodeFailureTables;
            }

            public void set(Boolean val) throws InvalidConfigValueException {
                throw new InvalidConfigValueException("Cannot change on the fly");
            }

            public boolean isReadOnly() {
                return true;
            }
        });
        this.enablePerNodeFailureTables = nodeConfig.getBoolean("enablePerNodeFailureTables");
        nodeConfig.register("enableULPRDataPropagation", true, sortOrder++, true, false, "Node.enableULPRDataPropagation", "Node.enableULPRDataPropagationLong", new BooleanCallback(){

            public Boolean get() {
                return Node.this.enableULPRDataPropagation;
            }

            public void set(Boolean val) throws InvalidConfigValueException {
                throw new InvalidConfigValueException("Cannot change on the fly");
            }

            public boolean isReadOnly() {
                return true;
            }
        });
        this.enableULPRDataPropagation = nodeConfig.getBoolean("enableULPRDataPropagation");
        nodeConfig.register("enableSwapping", true, sortOrder++, true, false, "Node.enableSwapping", "Node.enableSwappingLong", new BooleanCallback(){

            public Boolean get() {
                return Node.this.enableSwapping;
            }

            public void set(Boolean val) throws InvalidConfigValueException {
                throw new InvalidConfigValueException("Cannot change on the fly");
            }

            public boolean isReadOnly() {
                return true;
            }
        });
        this.enableSwapping = nodeConfig.getBoolean("enableSwapping");
        nodeConfig.register("publishOurPeersLocation", true, sortOrder++, true, false, "Node.publishOurPeersLocation", "Node.publishOurPeersLocationLong", new BooleanCallback(){

            public Boolean get() {
                return Node.this.publishOurPeersLocation;
            }

            public void set(Boolean val) throws InvalidConfigValueException {
                Node.this.publishOurPeersLocation = val;
            }
        });
        this.publishOurPeersLocation = nodeConfig.getBoolean("publishOurPeersLocation");
        nodeConfig.register("routeAccordingToOurPeersLocation", true, sortOrder++, true, false, "Node.routeAccordingToOurPeersLocation", "Node.routeAccordingToOurPeersLocationLong", new BooleanCallback(){

            public Boolean get() {
                return Node.this.routeAccordingToOurPeersLocation;
            }

            public void set(Boolean val) throws InvalidConfigValueException {
                Node.this.routeAccordingToOurPeersLocation = val;
            }
        });
        this.routeAccordingToOurPeersLocation = nodeConfig.getBoolean("routeAccordingToOurPeersLocation");
        this.securityLevels.addNetworkThreatLevelListener(new SecurityLevelListener<SecurityLevels.NETWORK_THREAT_LEVEL>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onChange(SecurityLevels.NETWORK_THREAT_LEVEL oldLevel, SecurityLevels.NETWORK_THREAT_LEVEL newLevel) {
                Node node = Node.this;
                synchronized (node) {
                    boolean wantFOAF = true;
                    if ((newLevel == SecurityLevels.NETWORK_THREAT_LEVEL.MAXIMUM || newLevel == SecurityLevels.NETWORK_THREAT_LEVEL.HIGH) && Node.this.securityLevels.friendsThreatLevel == SecurityLevels.FRIENDS_THREAT_LEVEL.HIGH) {
                        wantFOAF = false;
                    }
                    Node.this.routeAccordingToOurPeersLocation = wantFOAF;
                }
            }
        });
        this.securityLevels.addFriendsThreatLevelListener(new SecurityLevelListener<SecurityLevels.FRIENDS_THREAT_LEVEL>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onChange(SecurityLevels.FRIENDS_THREAT_LEVEL oldLevel, SecurityLevels.FRIENDS_THREAT_LEVEL newLevel) {
                Node node = Node.this;
                synchronized (node) {
                    boolean wantFOAF = true;
                    SecurityLevels.NETWORK_THREAT_LEVEL networkLevel = Node.this.securityLevels.networkThreatLevel;
                    if ((networkLevel == SecurityLevels.NETWORK_THREAT_LEVEL.MAXIMUM || networkLevel == SecurityLevels.NETWORK_THREAT_LEVEL.HIGH) && newLevel == SecurityLevels.FRIENDS_THREAT_LEVEL.HIGH) {
                        wantFOAF = false;
                    }
                    Node.this.routeAccordingToOurPeersLocation = wantFOAF;
                }
            }
        });
        nodeConfig.register("enableSwapQueueing", true, sortOrder++, true, false, "Node.enableSwapQueueing", "Node.enableSwapQueueingLong", new BooleanCallback(){

            public Boolean get() {
                return Node.this.enableSwapQueueing;
            }

            public void set(Boolean val) throws InvalidConfigValueException {
                Node.this.enableSwapQueueing = val;
            }
        });
        this.enableSwapQueueing = nodeConfig.getBoolean("enableSwapQueueing");
        nodeConfig.register("enablePacketCoalescing", true, sortOrder++, true, false, "Node.enablePacketCoalescing", "Node.enablePacketCoalescingLong", new BooleanCallback(){

            public Boolean get() {
                return Node.this.enablePacketCoalescing;
            }

            public void set(Boolean val) throws InvalidConfigValueException {
                Node.this.enablePacketCoalescing = val;
            }
        });
        this.enablePacketCoalescing = nodeConfig.getBoolean("enablePacketCoalescing");
        if (oldConfig != null && "-1".equals(oldConfig.get("node.listenPort"))) {
            throw new NodeInitException(9, "Your freenet.ini file is corrupted! 'listenPort=-1'");
        }
        NodeCryptoConfig darknetConfig = new NodeCryptoConfig(nodeConfig, sortOrder++, false, this.securityLevels);
        sortOrder += 3;
        this.darknetCrypto = new NodeCrypto(this, false, darknetConfig, this.startupTime, this.enableARKs);
        this.nodeDBHandle = this.darknetCrypto.getNodeHandle(this.db);
        if (this.db != null) {
            this.db.commit();
            if (Logger.shouldLog(4, this)) {
                Logger.minor(this, "COMMITTED");
            }
        }
        this.dnsr = new DNSRequester(this);
        this.ps = new PacketSender(this);
        if (executor instanceof PooledExecutor) {
            ((PooledExecutor)executor).setTicker(this.ps);
        }
        Logger.normal(Node.class, "Creating node...");
        this.shutdownHook.addEarlyJob(new Thread(){

            public void run() {
                if (Node.this.opennet != null) {
                    Node.this.opennet.stop(false);
                }
            }
        });
        this.shutdownHook.addEarlyJob(new Thread(){

            public void run() {
                Node.this.darknetCrypto.stop();
            }
        });
        nodeConfig.register("outputBandwidthLimit", "15K", sortOrder++, false, true, "Node.outBWLimit", "Node.outBWLimitLong", new IntCallback(){

            public Integer get() {
                return Node.this.outputBandwidthLimit;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void set(Integer obwLimit) throws InvalidConfigValueException {
                if (obwLimit <= 0) {
                    throw new InvalidConfigValueException(Node.this.l10n("bwlimitMustBePositive"));
                }
                Node node = Node.this;
                synchronized (node) {
                    Node.this.outputBandwidthLimit = obwLimit;
                }
                Node.this.outputThrottle.changeNanosAndBucketSize(1000000000L / (long)obwLimit.intValue(), obwLimit / 2);
                Node.this.nodeStats.setOutputLimit(obwLimit);
            }
        }, true);
        int obwLimit = nodeConfig.getInt("outputBandwidthLimit");
        if (obwLimit <= 0) {
            throw new NodeInitException(26, "Invalid outputBandwidthLimit");
        }
        this.outputBandwidthLimit = obwLimit;
        int bucketSize = obwLimit / 2;
        bucketSize = Math.max(bucketSize, 2048);
        this.outputThrottle = new TokenBucket(bucketSize, 1000000000L / (long)obwLimit, obwLimit / 2);
        nodeConfig.register("inputBandwidthLimit", "-1", sortOrder++, false, true, "Node.inBWLimit", "Node.inBWLimitLong", new IntCallback(){

            public Integer get() {
                if (Node.this.inputLimitDefault) {
                    return -1;
                }
                return Node.this.inputBandwidthLimit;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void set(Integer ibwLimit) throws InvalidConfigValueException {
                Node node = Node.this;
                synchronized (node) {
                    if (ibwLimit == -1) {
                        Node.this.inputLimitDefault = true;
                        ibwLimit = Node.this.outputBandwidthLimit * 4;
                    } else {
                        if (ibwLimit <= 1) {
                            throw new InvalidConfigValueException(Node.this.l10n("bandwidthLimitMustBePositiveOrMinusOne"));
                        }
                        Node.this.inputLimitDefault = false;
                    }
                    Node.this.inputBandwidthLimit = ibwLimit;
                }
                Node.this.nodeStats.setInputLimit(ibwLimit);
            }
        }, true);
        int ibwLimit = nodeConfig.getInt("inputBandwidthLimit");
        if (ibwLimit == -1) {
            this.inputLimitDefault = true;
            ibwLimit = obwLimit * 4;
        } else if (ibwLimit <= 0) {
            throw new NodeInitException(26, "Invalid inputBandwidthLimit");
        }
        this.inputBandwidthLimit = ibwLimit;
        nodeConfig.register("throttleLocalTraffic", false, sortOrder++, true, false, "Node.throttleLocalTraffic", "Node.throttleLocalTrafficLong", new BooleanCallback(){

            public Boolean get() {
                return Node.this.throttleLocalData;
            }

            public void set(Boolean val) throws InvalidConfigValueException {
                Node.this.throttleLocalData = val;
            }
        });
        this.throttleLocalData = nodeConfig.getBoolean("throttleLocalTraffic");
        this.testnetHandler = TestnetHandler.maybeCreate(this, config);
        if (this.testnetHandler != null) {
            int x;
            String msg = "WARNING: ENABLING TESTNET CODE! This WILL seriously jeopardize your anonymity!";
            Logger.error(this, msg);
            System.err.println(msg);
            this.testnetEnabled = true;
            if (logConfigHandler.getFileLoggerHook() == null) {
                System.err.println("Forcing logging enabled (essential for testnet)");
                logConfigHandler.forceEnableLogging();
            }
            if ((x = Logger.globalGetThreshold()) != 4 && x != 2) {
                System.err.println("Forcing log threshold to MINOR for testnet, was " + x);
                Logger.globalSetThreshold(4);
            }
            if (logConfigHandler.getMaxZippedLogFiles() < 0x20000000L) {
                System.err.println("Forcing max zipped logfiles space to 256MB for testnet");
                try {
                    logConfigHandler.setMaxZippedLogFiles(TESTNET_MIN_MAX_ZIPPED_LOGFILES_STRING);
                }
                catch (InvalidConfigValueException e) {
                    throw new Error("Impossible: " + e, e);
                }
                catch (NodeNeedRestartException e) {
                    throw new Error("Impossible: " + e, e);
                }
            }
        } else {
            FileLoggerHook flh;
            String s = "Testnet mode DISABLED. You may have some level of anonymity. :)\nNote that this version of Freenet is still a very early alpha, and may well have numerous bugs and design flaws.\nIn particular: YOU ARE WIDE OPEN TO YOUR IMMEDIATE PEERS! They can eavesdrop on your requests with relatively little difficulty at present (correlation attacks etc).";
            Logger.normal(this, s);
            System.err.println(s);
            this.testnetEnabled = false;
            if (this.wasTestnet && (flh = logConfigHandler.getFileLoggerHook()) != null) {
                flh.deleteAllOldLogFiles();
            }
        }
        File nodeFile = new File(this.nodeDir, "node-" + this.getDarknetPortNumber());
        File nodeFileBackup = new File(this.nodeDir, "node-" + this.getDarknetPortNumber() + ".bak");
        try {
            this.readNodeFile(nodeFile.getPath());
        }
        catch (IOException e) {
            try {
                System.err.println("Trying to read node file backup ...");
                this.readNodeFile(nodeFileBackup.getPath());
            }
            catch (IOException e1) {
                if (nodeFile.exists() || nodeFileBackup.exists()) {
                    System.err.println("No node file or cannot read, (re)initialising crypto etc");
                    System.err.println(e1.toString());
                    e1.printStackTrace();
                    System.err.println("After:");
                    System.err.println(e.toString());
                    e.printStackTrace();
                } else {
                    System.err.println("Creating new cryptographic keys...");
                }
                this.initNodeFileSettings();
            }
        }
        if (this.wasTestnet != this.testnetEnabled) {
            Logger.error(this, "Switched from testnet mode to non-testnet mode or vice versa! Regenerating pubkey, privkey, and deleting logs.");
            this.darknetCrypto.initCrypto();
        }
        this.dispatcher = new NodeDispatcher(this);
        this.usm.setDispatcher(this.dispatcher);
        this.peers = new PeerManager(this);
        this.peers.tryReadPeers(new File(this.nodeDir, "peers-" + this.getDarknetPortNumber()).getPath(), this.darknetCrypto, null, false, false);
        this.peers.writePeers();
        this.peers.updatePMUserAlert();
        this.uptime = new UptimeEstimator(this.nodeDir, this.ps, this.darknetCrypto.identityHash);
        this.failureTable = new FailureTable(this);
        SubConfig opennetConfig = new SubConfig("node.opennet", config);
        opennetConfig.register("connectToSeednodes", true, 0, true, false, "Node.withAnnouncement", "Node.withAnnouncementLong", new BooleanCallback(){

            public Boolean get() {
                return Node.this.isAllowedToConnectToSeednodes;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                if (this.get().equals(val)) {
                    return;
                }
                Node node = Node.this;
                synchronized (node) {
                    Node.this.isAllowedToConnectToSeednodes = val;
                    if (Node.this.opennet != null) {
                        throw new NodeNeedRestartException(Node.this.l10n("connectToSeednodesCannotBeChangedMustDisableOpennetOrReboot"));
                    }
                }
            }
        });
        this.isAllowedToConnectToSeednodes = opennetConfig.getBoolean("connectToSeednodes");
        opennetConfig.register("enabled", false, 0, true, true, "Node.opennetEnabled", "Node.opennetEnabledLong", new BooleanCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean get() {
                Node node = Node.this;
                synchronized (node) {
                    return Node.this.opennet != null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void set(Boolean val) throws InvalidConfigValueException {
                OpennetManager o;
                Node node = Node.this;
                synchronized (node) {
                    if (val == (Node.this.opennet != null)) {
                        return;
                    }
                    if (val.booleanValue()) {
                        try {
                            o = Node.this.opennet = new OpennetManager(Node.this, Node.this.opennetCryptoConfig, System.currentTimeMillis(), Node.this.isAllowedToConnectToSeednodes);
                        }
                        catch (NodeInitException e) {
                            Node.this.opennet = null;
                            throw new InvalidConfigValueException(e.getMessage());
                        }
                    } else {
                        o = Node.this.opennet;
                        Node.this.opennet = null;
                    }
                }
                if (val.booleanValue()) {
                    o.start();
                } else {
                    o.stop(true);
                }
                Node.this.ipDetector.ipDetectorManager.notifyPortChange(Node.this.getPublicInterfacePorts());
            }
        });
        boolean opennetEnabled = opennetConfig.getBoolean("enabled");
        opennetConfig.register("maxOpennetPeers", "20", 1, true, false, "Node.maxOpennetPeers", "Node.maxOpennetPeersLong", new IntCallback(){

            public Integer get() {
                return Node.this.maxOpennetPeers;
            }

            public void set(Integer inputMaxOpennetPeers) throws InvalidConfigValueException {
                if (inputMaxOpennetPeers < 0) {
                    throw new InvalidConfigValueException(Node.this.l10n("mustBePositive"));
                }
                if (inputMaxOpennetPeers > 20) {
                    throw new InvalidConfigValueException(Node.this.l10n("maxOpennetPeersMustBeTwentyOrLess"));
                }
                Node.this.maxOpennetPeers = inputMaxOpennetPeers;
            }
        }, false);
        this.maxOpennetPeers = opennetConfig.getInt("maxOpennetPeers");
        if (this.maxOpennetPeers > 20) {
            Logger.error(this, "maxOpennetPeers may not be over 20");
            this.maxOpennetPeers = 20;
        }
        this.opennetCryptoConfig = new NodeCryptoConfig(opennetConfig, 2, true, this.securityLevels);
        this.opennet = opennetEnabled ? new OpennetManager(this, this.opennetCryptoConfig, System.currentTimeMillis(), this.isAllowedToConnectToSeednodes) : null;
        this.securityLevels.addNetworkThreatLevelListener(new SecurityLevelListener<SecurityLevels.NETWORK_THREAT_LEVEL>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onChange(SecurityLevels.NETWORK_THREAT_LEVEL oldLevel, SecurityLevels.NETWORK_THREAT_LEVEL newLevel) {
                if (newLevel == SecurityLevels.NETWORK_THREAT_LEVEL.HIGH || newLevel == SecurityLevels.NETWORK_THREAT_LEVEL.MAXIMUM) {
                    OpennetManager om;
                    Node node = Node.this;
                    synchronized (node) {
                        om = Node.this.opennet;
                        if (om != null) {
                            Node.this.opennet = null;
                        }
                    }
                    if (om != null) {
                        om.stop(true);
                        Node.this.ipDetector.ipDetectorManager.notifyPortChange(Node.this.getPublicInterfacePorts());
                    }
                } else if (newLevel == SecurityLevels.NETWORK_THREAT_LEVEL.NORMAL || newLevel == SecurityLevels.NETWORK_THREAT_LEVEL.LOW) {
                    OpennetManager o = null;
                    Node node = Node.this;
                    synchronized (node) {
                        if (Node.this.opennet == null) {
                            try {
                                o = Node.this.opennet = new OpennetManager(Node.this, Node.this.opennetCryptoConfig, System.currentTimeMillis(), Node.this.isAllowedToConnectToSeednodes);
                            }
                            catch (NodeInitException e) {
                                Node.this.opennet = null;
                                Logger.error(this, "UNABLE TO ENABLE OPENNET: " + e, e);
                                Node.this.clientCore.alerts.register(new SimpleUserAlert(false, Node.this.l10n("enableOpennetFailedTitle"), Node.this.l10n("enableOpennetFailed", "message", e.getLocalizedMessage()), Node.this.l10n("enableOpennetFailed", "message", e.getLocalizedMessage()), 1));
                            }
                        }
                    }
                    if (o != null) {
                        o.start();
                        Node.this.ipDetector.ipDetectorManager.notifyPortChange(Node.this.getPublicInterfacePorts());
                    }
                }
                Node.this.config.store();
            }
        });
        opennetConfig.register("acceptSeedConnections", false, 2, true, true, "Node.acceptSeedConnectionsShort", "Node.acceptSeedConnections", new BooleanCallback(){

            public Boolean get() {
                return Node.this.acceptSeedConnections;
            }

            public void set(Boolean val) throws InvalidConfigValueException {
                Node.this.acceptSeedConnections = val;
            }
        });
        this.acceptSeedConnections = opennetConfig.getBoolean("acceptSeedConnections");
        opennetConfig.finishedInitialization();
        nodeConfig.register("passOpennetPeersThroughDarknet", true, sortOrder++, true, false, "Node.passOpennetPeersThroughDarknet", "Node.passOpennetPeersThroughDarknetLong", new BooleanCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean get() {
                Node node = Node.this;
                synchronized (node) {
                    return Node.this.passOpennetRefsThroughDarknet;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void set(Boolean val) throws InvalidConfigValueException {
                Node node = Node.this;
                synchronized (node) {
                    Node.this.passOpennetRefsThroughDarknet = val;
                }
            }
        });
        this.passOpennetRefsThroughDarknet = nodeConfig.getBoolean("passOpennetPeersThroughDarknet");
        nodeConfig.register("extraPeerDataDir", new File(this.nodeDir, "extra-peer-data-" + this.getDarknetPortNumber()).toString(), sortOrder++, true, true, "Node.extraPeerDir", "Node.extraPeerDirLong", new StringCallback(){

            public String get() {
                return Node.this.extraPeerDataDir.getPath();
            }

            public void set(String val) throws InvalidConfigValueException {
                if (Node.this.extraPeerDataDir.equals(new File(val))) {
                    return;
                }
                throw new InvalidConfigValueException("Moving extra peer data directory on the fly not supported at present");
            }

            public boolean isReadOnly() {
                return true;
            }
        });
        this.extraPeerDataDir = new File(nodeConfig.getString("extraPeerDataDir"));
        if (!(this.extraPeerDataDir.exists() && this.extraPeerDataDir.isDirectory() || this.extraPeerDataDir.mkdir())) {
            String msg = "Could not find or create extra peer data directory";
            throw new NodeInitException(22, msg);
        }
        nodeConfig.register("name", this.myName, sortOrder++, false, true, "Node.nodeName", "Node.nodeNameLong", new NodeNameCallback());
        this.myName = nodeConfig.getString("name");
        nodeConfig.register("storeForceBigShrinks", false, sortOrder++, true, false, "Node.forceBigShrink", "Node.forceBigShrinkLong", new BooleanCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean get() {
                Node node = Node.this;
                synchronized (node) {
                    return Node.this.storeForceBigShrinks;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void set(Boolean val) throws InvalidConfigValueException {
                Node node = Node.this;
                synchronized (node) {
                    Node.this.storeForceBigShrinks = val;
                }
            }
        });
        nodeConfig.register("storeType", "salt-hash", sortOrder++, true, true, "Node.storeType", "Node.storeTypeLong", new StoreTypeCallback());
        this.storeType = nodeConfig.getString("storeType");
        nodeConfig.register("storeSize", "100M", sortOrder++, false, true, "Node.storeSize", "Node.storeSizeLong", new LongCallback(){

            public Long get() {
                return Node.this.maxTotalDatastoreSize;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void set(Long storeSize) throws InvalidConfigValueException {
                if (storeSize < 0L || storeSize < 0x2000000L) {
                    throw new InvalidConfigValueException(Node.this.l10n("invalidStoreSize"));
                }
                long newMaxStoreKeys = storeSize / 34988L;
                if (newMaxStoreKeys == Node.this.maxTotalKeys) {
                    return;
                }
                Node node = Node.this;
                synchronized (node) {
                    Node.this.maxTotalDatastoreSize = storeSize;
                    Node.this.maxTotalKeys = newMaxStoreKeys;
                    Node.this.maxStoreKeys = Node.this.maxTotalKeys / 2L;
                    Node.this.maxCacheKeys = Node.this.maxTotalKeys - Node.this.maxStoreKeys;
                }
                try {
                    Node.this.chkDatastore.setMaxKeys(Node.this.maxStoreKeys, Node.this.storeForceBigShrinks);
                    Node.this.chkDatacache.setMaxKeys(Node.this.maxCacheKeys, Node.this.storeForceBigShrinks);
                    Node.this.pubKeyDatastore.setMaxKeys(Node.this.maxStoreKeys, Node.this.storeForceBigShrinks);
                    Node.this.pubKeyDatacache.setMaxKeys(Node.this.maxCacheKeys, Node.this.storeForceBigShrinks);
                    Node.this.sskDatastore.setMaxKeys(Node.this.maxStoreKeys, Node.this.storeForceBigShrinks);
                    Node.this.sskDatacache.setMaxKeys(Node.this.maxCacheKeys, Node.this.storeForceBigShrinks);
                }
                catch (IOException e) {
                    Logger.error(this, "Caught " + e + " resizing the datastore", e);
                    System.err.println("Caught " + e + " resizing the datastore");
                    e.printStackTrace();
                }
                catch (DatabaseException e) {
                    Logger.error(this, "Caught " + (Object)((Object)e) + " resizing the datastore", e);
                    System.err.println("Caught " + (Object)((Object)e) + " resizing the datastore");
                    e.printStackTrace();
                }
                Node.this.nodeStats.avgStoreLocation.changeMaxReports((int)Node.this.maxStoreKeys);
                Node.this.nodeStats.avgCacheLocation.changeMaxReports((int)Node.this.maxCacheKeys);
            }
        }, true);
        this.maxTotalDatastoreSize = nodeConfig.getLong("storeSize");
        if (this.maxTotalDatastoreSize < 0L || this.maxTotalDatastoreSize < 0x2000000L && !this.storeType.equals("ram")) {
            throw new NodeInitException(13, "Invalid store size");
        }
        this.maxTotalKeys = this.maxTotalDatastoreSize / 34988L;
        nodeConfig.register("storeBloomFilterSize", -1, sortOrder++, true, false, "Node.storeBloomFilterSize", "Node.storeBloomFilterSizeLong", new IntCallback(){
            private Integer cachedBloomFilterSize;

            public Integer get() {
                if (this.cachedBloomFilterSize == null) {
                    this.cachedBloomFilterSize = Node.this.storeBloomFilterSize;
                }
                return this.cachedBloomFilterSize;
            }

            public void set(Integer val) throws InvalidConfigValueException, NodeNeedRestartException {
                this.cachedBloomFilterSize = val;
                throw new NodeNeedRestartException("Store bloom filter size cannot be changed on the fly");
            }

            public boolean isReadOnly() {
                return !"salt-hash".equals(Node.this.storeType);
            }
        }, true);
        this.storeBloomFilterSize = nodeConfig.getInt("storeBloomFilterSize");
        nodeConfig.register("storeBloomFilterCounting", true, sortOrder++, true, false, "Node.storeBloomFilterCounting", "Node.storeBloomFilterCountingLong", new BooleanCallback(){
            private Boolean cachedBloomFilterCounting;

            public Boolean get() {
                if (this.cachedBloomFilterCounting == null) {
                    this.cachedBloomFilterCounting = Node.this.storeBloomFilterCounting;
                }
                return this.cachedBloomFilterCounting;
            }

            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                this.cachedBloomFilterCounting = val;
                throw new NodeNeedRestartException("Store bloom filter type cannot be changed on the fly");
            }

            public boolean isReadOnly() {
                return !"salt-hash".equals(Node.this.storeType);
            }
        });
        this.storeBloomFilterCounting = nodeConfig.getBoolean("storeBloomFilterCounting");
        nodeConfig.register("storeSaltHashResizeOnStart", false, sortOrder++, true, false, "Node.storeSaltHashResizeOnStart", "Node.storeSaltHashResizeOnStartLong", new BooleanCallback(){

            public Boolean get() {
                return Node.this.storeSaltHashResizeOnStart;
            }

            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                Node.this.storeSaltHashResizeOnStart = val;
            }
        });
        this.storeSaltHashResizeOnStart = nodeConfig.getBoolean("storeSaltHashResizeOnStart");
        nodeConfig.register("storeDir", "datastore", sortOrder++, true, true, "Node.storeDirectory", "Node.storeDirectoryLong", new StringCallback(){

            public String get() {
                return Node.this.storeDir.getPath();
            }

            public void set(String val) throws InvalidConfigValueException {
                if (Node.this.storeDir.equals(new File(val))) {
                    return;
                }
                throw new InvalidConfigValueException("Moving datastore on the fly not supported at present");
            }

            public boolean isReadOnly() {
                return true;
            }
        });
        final String suffix = "-" + this.getDarknetPortNumber();
        String datastoreDir = nodeConfig.getString("storeDir");
        this.storeDir = new File(datastoreDir);
        if (!(this.storeDir.exists() && this.storeDir.isDirectory() || this.storeDir.mkdir())) {
            String msg = "Could not find or create datastore directory";
            throw new NodeInitException(3, msg);
        }
        this.maxStoreKeys = this.maxTotalKeys / 2L;
        this.maxCacheKeys = this.maxTotalKeys - this.maxStoreKeys;
        nodeConfig.register("storePreallocate", true, sortOrder++, true, true, "Node.storePreallocate", "Node.storePreallocateLong", new BooleanCallback(){

            public Boolean get() {
                return Node.this.storePreallocate;
            }

            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                Node.this.storePreallocate = val;
                if (Node.this.storeType.equals("salt-hash")) {
                    ((SaltedHashFreenetStore)Node.this.chkDatastore.getStore()).setPreallocate(val);
                    ((SaltedHashFreenetStore)Node.this.chkDatacache.getStore()).setPreallocate(val);
                    ((SaltedHashFreenetStore)Node.this.pubKeyDatastore.getStore()).setPreallocate(val);
                    ((SaltedHashFreenetStore)Node.this.pubKeyDatacache.getStore()).setPreallocate(val);
                    ((SaltedHashFreenetStore)Node.this.sskDatastore.getStore()).setPreallocate(val);
                    ((SaltedHashFreenetStore)Node.this.sskDatacache.getStore()).setPreallocate(val);
                }
            }
        });
        this.storePreallocate = nodeConfig.getBoolean("storePreallocate");
        if (File.separatorChar == '/' && System.getProperty("os.name").toLowerCase().indexOf("mac os") < 0) {
            this.securityLevels.addPhysicalThreatLevelListener(new SecurityLevelListener<SecurityLevels.PHYSICAL_THREAT_LEVEL>(){

                @Override
                public void onChange(SecurityLevels.PHYSICAL_THREAT_LEVEL oldLevel, SecurityLevels.PHYSICAL_THREAT_LEVEL newLevel) {
                    try {
                        if (newLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.LOW) {
                            nodeConfig.set("storePreallocate", false);
                        } else {
                            nodeConfig.set("storePreallocate", true);
                        }
                    }
                    catch (NodeNeedRestartException e) {
                    }
                    catch (InvalidConfigValueException invalidConfigValueException) {
                        // empty catch block
                    }
                }
            });
        }
        if (this.storeType.equals("salt-hash")) {
            this.initSaltHashFS(suffix);
        } else if (this.storeType.equals("bdb-index")) {
            nodeConfig.register("databaseMaxMemory", "20M", sortOrder++, true, false, "Node.databaseMemory", "Node.databaseMemoryLong", new LongCallback(){

                public Long get() {
                    return Node.this.databaseMaxMemory;
                }

                public void set(Long val) throws InvalidConfigValueException {
                    if (val < 0L) {
                        throw new InvalidConfigValueException(Node.this.l10n("mustBePositive"));
                    }
                    long maxHeapMemory = Runtime.getRuntime().maxMemory();
                    if (maxHeapMemory < Long.MAX_VALUE && val > 80L * maxHeapMemory / 100L) {
                        throw new InvalidConfigValueException(Node.this.l10n("storeMaxMemTooHigh"));
                    }
                    Node.this.envMutableConfig.setCacheSize(val.longValue());
                    try {
                        Node.this.storeEnvironment.setMutableConfig(Node.this.envMutableConfig);
                    }
                    catch (DatabaseException e) {
                        throw new InvalidConfigValueException(Node.this.l10n("errorApplyingConfig", "error", e.getLocalizedMessage()));
                    }
                    Node.this.databaseMaxMemory = val;
                }
            }, true);
            long maxHeapMemory = Runtime.getRuntime().maxMemory();
            this.databaseMaxMemory = nodeConfig.getLong("databaseMaxMemory");
            if (maxHeapMemory < Long.MAX_VALUE && this.databaseMaxMemory > 80L * maxHeapMemory / 100L) {
                Logger.error(this, "The databaseMemory setting is set too high " + this.databaseMaxMemory + " ... let's assume it's not what the user wants to do and restore the default.");
                this.databaseMaxMemory = Fields.parseLong(nodeConfig.getOption("databaseMaxMemory").getDefault());
            }
            this.initBDBFS(suffix);
        } else {
            this.chkDatastore = new CHKStore();
            new RAMFreenetStore<CHKBlock>(this.chkDatastore, (int)Math.min(Integer.MAX_VALUE, this.maxStoreKeys));
            this.chkDatacache = new CHKStore();
            new RAMFreenetStore<CHKBlock>(this.chkDatacache, (int)Math.min(Integer.MAX_VALUE, this.maxCacheKeys));
            this.pubKeyDatastore = new PubkeyStore();
            new RAMFreenetStore<DSAPublicKey>(this.pubKeyDatastore, (int)Math.min(Integer.MAX_VALUE, this.maxStoreKeys));
            this.pubKeyDatacache = new PubkeyStore();
            this.getPubKey.setDataStore(this.pubKeyDatastore, this.pubKeyDatacache);
            new RAMFreenetStore<DSAPublicKey>(this.pubKeyDatacache, (int)Math.min(Integer.MAX_VALUE, this.maxCacheKeys));
            this.sskDatastore = new SSKStore(this.getPubKey);
            new RAMFreenetStore<SSKBlock>(this.sskDatastore, (int)Math.min(Integer.MAX_VALUE, this.maxStoreKeys));
            this.sskDatacache = new SSKStore(this.getPubKey);
            new RAMFreenetStore<SSKBlock>(this.sskDatacache, (int)Math.min(Integer.MAX_VALUE, this.maxCacheKeys));
            this.envMutableConfig = null;
            this.storeEnvironment = null;
        }
        this.nodeStats = new NodeStats(this, sortOrder, new SubConfig("node.load", config), obwLimit, ibwLimit, this.nodeDir);
        this.clientCore = new NodeClientCore(this, config, nodeConfig, this.nodeDir, this.getDarknetPortNumber(), sortOrder, oldConfig, fproxyConfig, this.toadlets, this.db);
        this.netid = new NetworkIDManager(this);
        if (this.storeType.equals("salt-hash")) {
            ((SaltedHashFreenetStore)this.chkDatastore.getStore()).setUserAlertManager(this.clientCore.alerts);
            ((SaltedHashFreenetStore)this.chkDatacache.getStore()).setUserAlertManager(this.clientCore.alerts);
            ((SaltedHashFreenetStore)this.pubKeyDatastore.getStore()).setUserAlertManager(this.clientCore.alerts);
            ((SaltedHashFreenetStore)this.pubKeyDatacache.getStore()).setUserAlertManager(this.clientCore.alerts);
            ((SaltedHashFreenetStore)this.sskDatastore.getStore()).setUserAlertManager(this.clientCore.alerts);
            ((SaltedHashFreenetStore)this.sskDatacache.getStore()).setUserAlertManager(this.clientCore.alerts);
            if (this.isBDBStoreExist(suffix)) {
                this.clientCore.alerts.register(new SimpleUserAlert(true, L10n.getString("Node.storeSaltHashMigratedShort"), L10n.getString("Node.storeSaltHashMigratedShort"), L10n.getString("Node.storeSaltHashMigratedShort"), 3){

                    public HTMLNode getHTMLText() {
                        HTMLNode div = new HTMLNode("div");
                        div.addChild("#", L10n.getString("Node.storeSaltHashMigrated"));
                        HTMLNode ul = div.addChild("ul");
                        for (String type : new String[]{"chk", "pubkey", "ssk"}) {
                            for (String storecache : new String[]{"store", "store.keys", "store.lru", "cache", "cache.keys", "cache.lru"}) {
                                File f = new File(Node.this.storeDir, type + suffix + "." + storecache);
                                if (!f.exists()) continue;
                                ul.addChild("li", f.getAbsolutePath());
                            }
                        }
                        File dbDir = new File(Node.this.storeDir, "database" + suffix);
                        if (dbDir.exists()) {
                            ul.addChild("li", dbDir.getAbsolutePath());
                        }
                        return div;
                    }

                    public String getText() {
                        StringBuilder sb = new StringBuilder();
                        sb.append(L10n.getString("Node.storeSaltHashMigrated") + " \n");
                        for (String type : new String[]{"chk", "pubkey", "ssk"}) {
                            for (String storecache : new String[]{"store", "store.keys", "store.lru", "cache", "cache.keys", "cache.lru"}) {
                                File f = new File(Node.this.storeDir, type + suffix + "." + storecache);
                                if (f.exists()) {
                                    sb.append(" - ");
                                }
                                sb.append(f.getAbsolutePath());
                                sb.append("\n");
                            }
                        }
                        File dbDir = new File(Node.this.storeDir, "database" + suffix);
                        if (dbDir.exists()) {
                            sb.append(" - ");
                            sb.append(dbDir.getAbsolutePath());
                            sb.append("\n");
                        }
                        return sb.toString();
                    }

                    public boolean isValid() {
                        return Node.this.isBDBStoreExist(suffix);
                    }

                    public void onDismiss() {
                    }

                    public boolean userCanDismiss() {
                        return true;
                    }
                });
            }
        }
        this.securityLevels.registerUserAlert(this.clientCore.alerts);
        nodeConfig.finishedInitialization();
        this.writeNodeFile();
        Logger.normal(this, "Initializing Plugin Manager");
        System.out.println("Initializing Plugin Manager");
        this.pluginManager = new PluginManager(this);
        WrapperManager.signalStarting((int)120000);
        FetchContext ctx = this.clientCore.makeClient((short)0, true).getFetchContext();
        ctx.allowSplitfiles = false;
        ctx.dontEnterImplicitArchives = true;
        ctx.maxArchiveRestarts = 0;
        ctx.maxMetadataSize = 256;
        ctx.maxNonSplitfileRetries = 10;
        ctx.maxOutputLength = 4096L;
        ctx.maxRecursionLevel = 2;
        ctx.maxTempLength = 4096L;
        this.arkFetcherContext = ctx;
        System.out.println("Initializing Node Updater");
        try {
            this.nodeUpdater = NodeUpdateManager.maybeCreate(this, config);
        }
        catch (InvalidConfigValueException e) {
            e.printStackTrace();
            throw new NodeInitException(21, "Could not create Updater: " + e);
        }
        this.registerNodeToNodeMessageListener(1, this.fproxyN2NMListener);
        this.registerNodeToNodeMessageListener(2, this.diffNoderefListener);
        if (this.toadlets.isEnabled()) {
            this.toadlets.createFproxy();
            this.toadlets.removeStartupToadlet();
        }
        Logger.normal(this, "Node constructor completed");
        System.out.println("Node constructor completed");
    }

    private boolean isBDBStoreExist(String suffix) {
        return new File(this.storeDir, "chk" + suffix + ".store").exists() || new File(this.storeDir, "chk" + suffix + ".store.keys").exists() || new File(this.storeDir, "chk" + suffix + ".store.lru").exists() || new File(this.storeDir, "chk" + suffix + ".cache").exists() || new File(this.storeDir, "chk" + suffix + ".cache.keys").exists() || new File(this.storeDir, "chk" + suffix + ".cache.lru").exists() || new File(this.storeDir, "pubkey" + suffix + ".store").exists() || new File(this.storeDir, "pubkey" + suffix + ".store.keys").exists() || new File(this.storeDir, "pubkey" + suffix + ".store.lru").exists() || new File(this.storeDir, "pubkey" + suffix + ".cache").exists() || new File(this.storeDir, "pubkey" + suffix + ".cache.keys").exists() || new File(this.storeDir, "pubkey" + suffix + ".cache.lru").exists() || new File(this.storeDir, "ssk" + suffix + ".store").exists() || new File(this.storeDir, "ssk" + suffix + ".store.keys").exists() || new File(this.storeDir, "ssk" + suffix + ".store.lru").exists() || new File(this.storeDir, "ssk" + suffix + ".cache").exists() || new File(this.storeDir, "ssk" + suffix + ".cache.keys").exists() || new File(this.storeDir, "ssk" + suffix + ".cache.lru").exists() || new File(this.storeDir, "database" + suffix).exists();
    }

    private void initSaltHashFS(String suffix) throws NodeInitException {
        this.storeEnvironment = null;
        this.envMutableConfig = null;
        try {
            int bloomSize = this.storeBloomFilterSize;
            if (bloomSize == -1) {
                bloomSize = (int)Math.min(this.maxTotalDatastoreSize / 2048L, Integer.MAX_VALUE);
            }
            int bloomFilterSizeInM = this.storeBloomFilterCounting ? bloomSize / 6 * 4 : (bloomSize + 6) / 6 * 8;
            Logger.normal(this, "Initializing CHK Datastore");
            System.out.println("Initializing CHK Datastore (" + this.maxStoreKeys + " keys)");
            this.chkDatastore = new CHKStore();
            SaltedHashFreenetStore chkDataFS = SaltedHashFreenetStore.construct(this.storeDir, "CHK-store", this.chkDatastore, this.random, this.maxStoreKeys, bloomFilterSizeInM, this.storeBloomFilterCounting, this.shutdownHook, this.storePreallocate, this.storeSaltHashResizeOnStart);
            Logger.normal(this, "Initializing CHK Datacache");
            System.out.println("Initializing CHK Datacache (" + this.maxCacheKeys + ':' + this.maxCacheKeys + " keys)");
            this.chkDatacache = new CHKStore();
            SaltedHashFreenetStore chkCacheFS = SaltedHashFreenetStore.construct(this.storeDir, "CHK-cache", this.chkDatacache, this.random, this.maxCacheKeys, bloomFilterSizeInM, this.storeBloomFilterCounting, this.shutdownHook, this.storePreallocate, this.storeSaltHashResizeOnStart);
            Logger.normal(this, "Initializing pubKey Datastore");
            System.out.println("Initializing pubKey Datastore");
            this.pubKeyDatastore = new PubkeyStore();
            SaltedHashFreenetStore pubkeyDataFS = SaltedHashFreenetStore.construct(this.storeDir, "PUBKEY-store", this.pubKeyDatastore, this.random, this.maxStoreKeys, bloomFilterSizeInM, this.storeBloomFilterCounting, this.shutdownHook, this.storePreallocate, this.storeSaltHashResizeOnStart);
            Logger.normal(this, "Initializing pubKey Datacache");
            System.out.println("Initializing pubKey Datacache (" + this.maxCacheKeys + " keys)");
            this.pubKeyDatacache = new PubkeyStore();
            SaltedHashFreenetStore pubkeyCacheFS = SaltedHashFreenetStore.construct(this.storeDir, "PUBKEY-cache", this.pubKeyDatacache, this.random, this.maxCacheKeys, bloomFilterSizeInM, this.storeBloomFilterCounting, this.shutdownHook, this.storePreallocate, this.storeSaltHashResizeOnStart);
            this.getPubKey.setDataStore(this.pubKeyDatastore, this.pubKeyDatacache);
            Logger.normal(this, "Initializing SSK Datastore");
            System.out.println("Initializing SSK Datastore");
            this.sskDatastore = new SSKStore(this.getPubKey);
            SaltedHashFreenetStore sskDataFS = SaltedHashFreenetStore.construct(this.storeDir, "SSK-store", this.sskDatastore, this.random, this.maxStoreKeys, bloomFilterSizeInM, this.storeBloomFilterCounting, this.shutdownHook, this.storePreallocate, this.storeSaltHashResizeOnStart);
            Logger.normal(this, "Initializing SSK Datacache");
            System.out.println("Initializing SSK Datacache (" + this.maxCacheKeys + " keys)");
            this.sskDatacache = new SSKStore(this.getPubKey);
            SaltedHashFreenetStore sskCacheFS = SaltedHashFreenetStore.construct(this.storeDir, "SSK-cache", this.sskDatacache, this.random, this.maxCacheKeys, bloomFilterSizeInM, this.storeBloomFilterCounting, this.shutdownHook, this.storePreallocate, this.storeSaltHashResizeOnStart);
            File migrationFile = new File(this.storeDir, "migrated");
            if (!migrationFile.exists()) {
                chkDataFS.migrationFrom(new File(this.storeDir, "chk" + suffix + ".store"), new File(this.storeDir, "chk" + suffix + ".store.keys"));
                chkCacheFS.migrationFrom(new File(this.storeDir, "chk" + suffix + ".cache"), new File(this.storeDir, "chk" + suffix + ".cache.keys"));
                pubkeyDataFS.migrationFrom(new File(this.storeDir, "pubkey" + suffix + ".store"), new File(this.storeDir, "pubkey" + suffix + ".store.keys"));
                pubkeyCacheFS.migrationFrom(new File(this.storeDir, "pubkey" + suffix + ".cache"), new File(this.storeDir, "pubkey" + suffix + ".cache.keys"));
                sskDataFS.migrationFrom(new File(this.storeDir, "ssk" + suffix + ".store"), new File(this.storeDir, "ssk" + suffix + ".store.keys"));
                sskCacheFS.migrationFrom(new File(this.storeDir, "ssk" + suffix + ".cache"), new File(this.storeDir, "ssk" + suffix + ".cache.keys"));
                migrationFile.createNewFile();
            }
        }
        catch (IOException e) {
            System.err.println("Could not open store: " + e);
            e.printStackTrace();
            throw new NodeInitException(3, e.getMessage());
        }
    }

    private void initBDBFS(String suffix) throws NodeInitException {
        String msg;
        EnvironmentConfig mutableConfig;
        EnvironmentConfig envConfig = BerkeleyDBFreenetStore.getBDBConfig();
        File dbDir = new File(this.storeDir, "database-" + this.getDarknetPortNumber());
        dbDir.mkdirs();
        File reconstructFile = new File(dbDir, "reconstruct");
        Environment env = null;
        System.out.println("Starting database...");
        try {
            if (reconstructFile.exists()) {
                reconstructFile.delete();
                throw new DatabaseException();
            }
            WrapperManager.signalStarting((int)3600000);
            env = new Environment(dbDir, envConfig);
            mutableConfig = env.getConfig();
        }
        catch (DatabaseException e) {
            if (env != null) {
                try {
                    env.close();
                }
                catch (Throwable t) {
                    System.err.println("Error closing database: " + t + " after " + (Object)((Object)e));
                    t.printStackTrace();
                }
            }
            System.err.println("Deleting old database log files...");
            File[] files = dbDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                String name = files[i].getName().toLowerCase();
                if (!name.endsWith(".jdb") && !name.equals("je.lck") || files[i].delete()) continue;
                System.err.println("Failed to delete old database log file " + files[i]);
            }
            System.err.println("Recovering...");
            try {
                env = new Environment(dbDir, envConfig);
                mutableConfig = env.getConfig();
            }
            catch (DatabaseException e1) {
                System.err.println("Could not open store: " + (Object)((Object)e1));
                e1.printStackTrace();
                System.err.println("Previous error was (tried deleting database and retrying): " + (Object)((Object)e));
                e.printStackTrace();
                throw new NodeInitException(3, e1.getMessage());
            }
        }
        this.storeEnvironment = env;
        this.envMutableConfig = mutableConfig;
        this.shutdownHook.addLateJob(new Thread(){

            public void run() {
                try {
                    Node.this.storeEnvironment.close();
                    System.err.println("Successfully closed all datastores.");
                }
                catch (Throwable t) {
                    System.err.println("Caught " + t + " closing environment");
                    t.printStackTrace();
                }
            }
        });
        this.envMutableConfig.setCacheSize(this.databaseMaxMemory);
        try {
            this.storeEnvironment.setMutableConfig(this.envMutableConfig);
        }
        catch (DatabaseException e) {
            System.err.println("Could not set the database configuration: " + (Object)((Object)e));
            e.printStackTrace();
            throw new NodeInitException(3, e.getMessage());
        }
        try {
            Logger.normal(this, "Initializing CHK Datastore");
            System.out.println("Initializing CHK Datastore (" + this.maxStoreKeys + " keys)");
            this.chkDatastore = new CHKStore();
            BerkeleyDBFreenetStore.construct(this.storeDir, true, suffix, this.maxStoreKeys, FreenetStore.StoreType.CHK, this.storeEnvironment, this.shutdownHook, reconstructFile, this.chkDatastore, this.random);
            Logger.normal(this, "Initializing CHK Datacache");
            System.out.println("Initializing CHK Datacache (" + this.maxCacheKeys + ':' + this.maxCacheKeys + " keys)");
            this.chkDatacache = new CHKStore();
            BerkeleyDBFreenetStore.construct(this.storeDir, false, suffix, this.maxCacheKeys, FreenetStore.StoreType.CHK, this.storeEnvironment, this.shutdownHook, reconstructFile, this.chkDatacache, this.random);
            Logger.normal(this, "Initializing pubKey Datastore");
            System.out.println("Initializing pubKey Datastore");
            this.pubKeyDatastore = new PubkeyStore();
            BerkeleyDBFreenetStore.construct(this.storeDir, true, suffix, this.maxStoreKeys, FreenetStore.StoreType.PUBKEY, this.storeEnvironment, this.shutdownHook, reconstructFile, this.pubKeyDatastore, this.random);
            Logger.normal(this, "Initializing pubKey Datacache");
            System.out.println("Initializing pubKey Datacache (" + this.maxCacheKeys + " keys)");
            this.pubKeyDatacache = new PubkeyStore();
            BerkeleyDBFreenetStore.construct(this.storeDir, false, suffix, this.maxCacheKeys, FreenetStore.StoreType.PUBKEY, this.storeEnvironment, this.shutdownHook, reconstructFile, this.pubKeyDatacache, this.random);
            this.getPubKey.setDataStore(this.pubKeyDatastore, this.pubKeyDatacache);
            Logger.normal(this, "Initializing SSK Datastore");
            System.out.println("Initializing SSK Datastore");
            this.sskDatastore = new SSKStore(this.getPubKey);
            BerkeleyDBFreenetStore.construct(this.storeDir, true, suffix, this.maxStoreKeys, FreenetStore.StoreType.SSK, this.storeEnvironment, this.shutdownHook, reconstructFile, this.sskDatastore, this.random);
            Logger.normal(this, "Initializing SSK Datacache");
            System.out.println("Initializing SSK Datacache (" + this.maxCacheKeys + " keys)");
            this.sskDatacache = new SSKStore(this.getPubKey);
            BerkeleyDBFreenetStore.construct(this.storeDir, false, suffix, this.maxStoreKeys, FreenetStore.StoreType.SSK, this.storeEnvironment, this.shutdownHook, reconstructFile, this.sskDatacache, this.random);
        }
        catch (FileNotFoundException e1) {
            msg = "Could not open datastore: " + e1;
            Logger.error(this, msg, e1);
            System.err.println(msg);
            throw new NodeInitException(1, msg);
        }
        catch (IOException e1) {
            msg = "Could not open datastore: " + e1;
            Logger.error(this, msg, e1);
            System.err.println(msg);
            e1.printStackTrace();
            throw new NodeInitException(2, msg);
        }
        catch (DatabaseException e1) {
            try {
                reconstructFile.createNewFile();
            }
            catch (IOException e) {
                System.err.println("Cannot create reconstruct file " + reconstructFile + " : " + e + " - store will not be reconstructed !!!!");
                e.printStackTrace();
            }
            msg = "Could not open datastore due to corruption, will attempt to reconstruct on next startup: " + (Object)((Object)e1);
            Logger.error(this, msg, e1);
            System.err.println(msg);
            e1.printStackTrace();
            throw new NodeInitException(27, msg);
        }
    }

    public void start(boolean noSwaps) throws NodeInitException {
        this.dispatcher.start(this.nodeStats);
        this.dnsr.start();
        this.peers.start();
        this.nodeStats.start();
        this.uptime.start();
        this.failureTable.start();
        this.darknetCrypto.start();
        if (this.opennet != null) {
            this.opennet.start();
        }
        this.ps.start(this.nodeStats);
        this.usm.start(this.ps);
        if (this.isUsingWrapper()) {
            Logger.normal(this, "Using wrapper correctly: " + nodeStarter);
            System.out.println("Using wrapper correctly: " + nodeStarter);
        } else {
            Logger.error(this, "NOT using wrapper (at least not correctly).  Your freenet-ext.jar <http://downloads.freenetproject.org/alpha/freenet-ext.jar> and/or wrapper.conf <https://emu.freenetproject.org/svn/trunk/apps/installer/installclasspath/config/wrapper.conf> need to be updated.");
            System.out.println("NOT using wrapper (at least not correctly).  Your freenet-ext.jar <http://downloads.freenetproject.org/alpha/freenet-ext.jar> and/or wrapper.conf <https://emu.freenetproject.org/svn/trunk/apps/installer/installclasspath/config/wrapper.conf> need to be updated.");
        }
        Logger.normal(this, "Freenet 0.7 Build #" + Version.buildNumber() + " r" + "build01217");
        System.out.println("Freenet 0.7 Build #" + Version.buildNumber() + " r" + "build01217");
        Logger.normal(this, "FNP port is on " + this.darknetCrypto.getBindTo() + ':' + this.getDarknetPortNumber());
        System.out.println("FNP port is on " + this.darknetCrypto.getBindTo() + ':' + this.getDarknetPortNumber());
        this.ipDetector.start();
        this.lm.startSender();
        try {
            Logger.normal(this, "Starting the node updater");
            this.nodeUpdater.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NodeInitException(21, "Could not start Updater: " + e);
        }
        if (this.testnetHandler != null) {
            this.testnetHandler.start();
        }
        this.checkForEvilJVMBugs();
        if (!this.nodeUpdater.isEnabled() && 26 > NodeStarter.extBuildNumber) {
            this.clientCore.alerts.register(new ExtOldAgeUserAlert());
        } else if (NodeStarter.extBuildNumber == -1) {
            this.clientCore.alerts.register(new ExtOldAgeUserAlert());
        }
        if (!NativeThread.HAS_ENOUGH_NICE_LEVELS) {
            this.clientCore.alerts.register(new NotEnoughNiceLevelsUserAlert());
        }
        this.clientCore.start(this.config);
        this.startDeadUIDChecker();
        if (this.config instanceof FreenetFilePersistentConfig) {
            FreenetFilePersistentConfig cfg = (FreenetFilePersistentConfig)this.config;
            cfg.finishedInit(this.ps);
            cfg.setHasNodeStarted();
        }
        this.config.store();
        this.peers.readExtraPeerData();
        Logger.normal(this, "Started node");
        this.hasStarted = true;
    }

    private void checkForEvilJVMBugs() {
        String jvmVendor = System.getProperty("java.vm.vendor");
        String jvmSpecVendor = System.getProperty("java.specification.vendor", "");
        String jvmVersion = System.getProperty("java.version");
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        if (logMINOR) {
            Logger.minor(this, "JVM vendor: " + jvmVendor + ", JVM version: " + jvmVersion + ", OS name: " + osName + ", OS version: " + osVersion);
        }
        if (jvmVendor.startsWith("Sun ") || jvmVendor.startsWith("The FreeBSD Foundation") && jvmSpecVendor.startsWith("Sun ")) {
            boolean is142 = jvmVersion.startsWith("1.4.2_");
            boolean is150 = jvmVersion.startsWith("1.5.0_");
            boolean spuriousOOMs = false;
            if (is142 || is150) {
                String[] split = jvmVersion.split("_");
                String secondPart = split[1];
                if (secondPart.indexOf("-") != -1) {
                    split = secondPart.split("-");
                    secondPart = split[0];
                }
                int subver = Integer.parseInt(secondPart);
                Logger.minor(this, "JVM version: " + jvmVersion + " subver: " + subver + " from " + secondPart + " is142=" + is142 + " is150=" + is150);
                if (is142) {
                    if (subver < 13) {
                        spuriousOOMs = true;
                    }
                } else if (subver < 10) {
                    spuriousOOMs = true;
                }
            }
            if (spuriousOOMs) {
                System.err.println("Please upgrade to at least sun jvm 1.4.2_13, 1.5.0_10 or 1.6 (recommended). This version is buggy and may cause spurious OutOfMemoryErrors.");
                this.clientCore.alerts.register(new AbstractUserAlert(false, null, null, null, null, 1, true, null, false, null){

                    public HTMLNode getHTMLText() {
                        HTMLNode n = new HTMLNode("div");
                        L10n.addL10nSubstitution(n, "Node.buggyJVMWithLink", new String[]{"link", "/link", "version"}, new String[]{"<a href=\"/?_CHECKED_HTTP_=http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=4855795\">", "</a>", HTMLEncoder.encode(System.getProperty("java.version"))});
                        return n;
                    }

                    public String getText() {
                        return Node.this.l10n("buggyJVM", "version", System.getProperty("java.version"));
                    }

                    public String getTitle() {
                        return Node.this.l10n("buggyJVMTitle");
                    }

                    public void isValid(boolean validity) {
                    }

                    public String getShortText() {
                        return Node.this.l10n("buggyJVMShort", "version", System.getProperty("java.version"));
                    }
                });
            }
        } else if (!jvmVendor.startsWith("Apple ") && !jvmVendor.startsWith("\"Apple ")) {
            if (jvmVendor.startsWith("Free Software Foundation")) {
                try {
                    jvmVersion = System.getProperty("java.version").split(" ")[0].replaceAll("[.]", "");
                    int jvmVersionInt = Integer.parseInt(jvmVersion);
                    if (jvmVersionInt <= 422 && jvmVersionInt >= 100) {
                        jvmHasGCJCharConversionBug = true;
                    }
                }
                catch (Throwable t) {
                    Logger.error(this, "GCJ version check is broken!", t);
                }
            }
            this.clientCore.alerts.register(new SimpleUserAlert(true, this.l10n("notUsingSunVMTitle"), this.l10n("notUsingSunVM", new String[]{"vendor", "version"}, new String[]{jvmVendor, jvmVersion}), this.l10n("notUsingSunVMShort"), 2));
        }
        if (!this.isUsingWrapper()) {
            this.clientCore.alerts.register(new SimpleUserAlert(true, this.l10n("notUsingWrapperTitle"), this.l10n("notUsingWrapper"), this.l10n("notUsingWrapperShort"), 2));
        }
    }

    public static boolean checkForGCJCharConversionBug() {
        return jvmHasGCJCharConversionBug;
    }

    private String l10n(String key) {
        return L10n.getString("Node." + key);
    }

    private String l10n(String key, String pattern, String value) {
        return L10n.getString("Node." + key, pattern, value);
    }

    private String l10n(String key, String[] pattern, String[] value) {
        return L10n.getString("Node." + key, pattern, value);
    }

    public SimpleFieldSet exportVolatileFieldSet() {
        return this.nodeStats.exportVolatileFieldSet();
    }

    public int routedPing(double loc2, byte[] nodeIdentity) {
        long uid = this.random.nextLong();
        int initialX = this.random.nextInt();
        Message m = DMT.createFNPRoutedPing(uid, loc2, this.maxHTL, initialX, nodeIdentity);
        Logger.normal(this, "Message: " + m);
        this.dispatcher.handleRouted(m, null);
        MessageFilter mf1 = MessageFilter.create().setField("uid", uid).setType(DMT.FNPRoutedPong).setTimeout(5000);
        try {
            m = this.usm.waitFor(mf1, null);
        }
        catch (DisconnectedException e) {
            Logger.normal(this, "Disconnected in waiting for pong");
            return -1;
        }
        if (m == null) {
            return -1;
        }
        if (m.getSpec() == DMT.FNPRoutedRejected) {
            return -1;
        }
        return m.getInt("counter") - initialX;
    }

    private KeyBlock makeRequestLocal(Key key, long uid, boolean promoteCache) {
        KeyBlock kb = null;
        if (key instanceof NodeCHK) {
            kb = this.fetch((NodeCHK)key, !promoteCache);
        } else if (key instanceof NodeSSK) {
            NodeSSK sskKey = (NodeSSK)key;
            DSAPublicKey pubKey = sskKey.getPubKey();
            if (pubKey == null) {
                pubKey = this.getPubKey.getKey(sskKey.getPubKeyHash());
                if (logMINOR) {
                    Logger.minor(this, "Fetched pubkey: " + pubKey);
                }
                try {
                    sskKey.setPubKey(pubKey);
                }
                catch (SSKVerifyException e) {
                    Logger.error(this, "Error setting pubkey: " + e, e);
                }
            }
            if (pubKey != null) {
                if (logMINOR) {
                    Logger.minor(this, "Got pubkey: " + pubKey);
                }
                kb = this.fetch(sskKey, !promoteCache);
            } else if (logMINOR) {
                Logger.minor(this, "Not found because no pubkey: " + uid);
            }
        } else {
            throw new IllegalStateException("Unknown key type: " + key.getClass());
        }
        if (kb != null) {
            if (this.clientCore != null && this.clientCore.requestStarters != null) {
                if (kb instanceof CHKBlock) {
                    this.clientCore.requestStarters.chkFetchScheduler.tripPendingKey(kb);
                } else {
                    this.clientCore.requestStarters.sskFetchScheduler.tripPendingKey(kb);
                }
            }
            this.failureTable.onFound(kb);
            return kb;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object makeRequestSender(Key key, short htl, long uid, PeerNode source, boolean localOnly, boolean cache, boolean ignoreStore, boolean offersOnly) {
        KeyBlock kb;
        if (logMINOR) {
            Logger.minor(this, "makeRequestSender(" + key + ',' + htl + ',' + uid + ',' + source + ") on " + this.getDarknetPortNumber());
        }
        if (!ignoreStore && (kb = this.makeRequestLocal(key, uid, cache)) != null) {
            return kb;
        }
        if (localOnly) {
            return null;
        }
        if (logMINOR) {
            Logger.minor(this, "Not in store locally");
        }
        RequestSender sender = null;
        HashMap<Object, RequestSender> hashMap = this.transferringRequestSenders;
        synchronized (hashMap) {
            sender = this.transferringRequestSenders.get(key);
        }
        if (sender != null) {
            if (logMINOR) {
                Logger.minor(this, "Data already being transferred: " + sender);
            }
            return sender;
        }
        if (htl == 0) {
            if (logMINOR) {
                Logger.minor(this, "No HTL");
            }
            return null;
        }
        hashMap = this.requestSenders;
        synchronized (hashMap) {
            sender = new RequestSender(key, null, htl, uid, this, source, offersOnly);
        }
        sender.start();
        if (logMINOR) {
            Logger.minor(this, "Created new sender: " + sender);
        }
        return sender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequestSender(Key key, short htl, RequestSender sender) {
        HashMap<KeyHTLPair, RequestSender> hashMap = this.requestSenders;
        synchronized (hashMap) {
            KeyHTLPair kh = new KeyHTLPair(key, htl, sender.uid);
            if (this.requestSenders.containsKey(kh)) {
                RequestSender rs = this.requestSenders.get(kh);
                Logger.error(this, "addRequestSender(): KeyHTLPair '" + kh + "' already in requestSenders as " + rs + " and you want to add " + sender);
                return;
            }
            this.requestSenders.put(kh, sender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInsertSender(Key key, short htl, AnyInsertSender sender) {
        HashMap<KeyHTLPair, AnyInsertSender> hashMap = this.insertSenders;
        synchronized (hashMap) {
            KeyHTLPair kh = new KeyHTLPair(key, htl, sender.getUID());
            if (this.insertSenders.containsKey(kh)) {
                AnyInsertSender is = this.insertSenders.get(kh);
                Logger.error(this, "addInsertSender(): KeyHTLPair '" + kh + "' already in insertSenders as " + is + " and you want to add " + sender);
                return;
            }
            this.insertSenders.put(kh, sender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransferringSender(NodeCHK key, RequestSender sender) {
        HashMap<NodeCHK, RequestSender> hashMap = this.transferringRequestSenders;
        synchronized (hashMap) {
            this.transferringRequestSenders.put(key, sender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTransferringRequestHandler(long id) {
        HashSet<Long> hashSet = this.transferringRequestHandlers;
        synchronized (hashSet) {
            this.transferringRequestHandlers.add(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTransferringRequestHandler(long id) {
        HashSet<Long> hashSet = this.transferringRequestHandlers;
        synchronized (hashSet) {
            this.transferringRequestHandlers.remove(id);
        }
    }

    public KeyBlock fetch(Key key, boolean dontPromote) {
        if (key instanceof NodeSSK) {
            return this.fetch((NodeSSK)key, dontPromote);
        }
        if (key instanceof NodeCHK) {
            return this.fetch((NodeCHK)key, dontPromote);
        }
        throw new IllegalArgumentException();
    }

    public SSKBlock fetch(NodeSSK key, boolean dontPromote) {
        if (logMINOR) {
            this.dumpStoreHits();
        }
        try {
            double loc = key.toNormalizedDouble();
            double dist = Location.distance(this.lm.getLocation(), loc);
            this.nodeStats.avgRequestLocation.report(loc);
            SSKBlock block = this.sskDatastore.fetch(key, dontPromote);
            if (block != null) {
                this.nodeStats.avgStoreSuccess.report(loc);
                if (dist > this.nodeStats.furthestStoreSuccess) {
                    this.nodeStats.furthestStoreSuccess = dist;
                }
                return block;
            }
            block = this.sskDatacache.fetch(key, dontPromote);
            if (block != null) {
                this.nodeStats.avgCacheSuccess.report(loc);
                if (dist > this.nodeStats.furthestCacheSuccess) {
                    this.nodeStats.furthestCacheSuccess = dist;
                }
            }
            return block;
        }
        catch (IOException e) {
            Logger.error(this, "Cannot fetch data: " + e, e);
            return null;
        }
    }

    public CHKBlock fetch(NodeCHK key, boolean dontPromote) {
        if (logMINOR) {
            this.dumpStoreHits();
        }
        try {
            double loc = key.toNormalizedDouble();
            double dist = Location.distance(this.lm.getLocation(), loc);
            this.nodeStats.avgRequestLocation.report(loc);
            CHKBlock block = this.chkDatastore.fetch(key, dontPromote);
            if (block != null) {
                this.nodeStats.avgStoreSuccess.report(loc);
                if (dist > this.nodeStats.furthestStoreSuccess) {
                    this.nodeStats.furthestStoreSuccess = dist;
                }
                return block;
            }
            block = this.chkDatacache.fetch(key, dontPromote);
            if (block != null) {
                this.nodeStats.avgCacheSuccess.report(loc);
                if (dist > this.nodeStats.furthestCacheSuccess) {
                    this.nodeStats.furthestCacheSuccess = dist;
                }
            }
            return block;
        }
        catch (IOException e) {
            Logger.error(this, "Cannot fetch data: " + e, e);
            return null;
        }
    }

    public CHKStore getChkDatacache() {
        return this.chkDatacache;
    }

    public CHKStore getChkDatastore() {
        return this.chkDatastore;
    }

    public long getMaxTotalKeys() {
        return this.maxTotalKeys;
    }

    public void dumpStoreHits() {
        long now = System.currentTimeMillis();
        if (now - this.timeLastDumpedHits <= 5000L) {
            return;
        }
        this.timeLastDumpedHits = now;
        Logger.minor(this, "Distribution of hits and misses over stores:\nCHK Datastore: " + this.chkDatastore.hits() + '/' + (this.chkDatastore.hits() + this.chkDatastore.misses()) + '/' + this.chkDatastore.keyCount() + "\nCHK Datacache: " + this.chkDatacache.hits() + '/' + (this.chkDatacache.hits() + this.chkDatacache.misses()) + '/' + this.chkDatacache.keyCount() + "\nSSK Datastore: " + this.sskDatastore.hits() + '/' + (this.sskDatastore.hits() + this.sskDatastore.misses()) + '/' + this.sskDatastore.keyCount() + "\nSSK Datacache: " + this.sskDatacache.hits() + '/' + (this.sskDatacache.hits() + this.sskDatacache.misses()) + '/' + this.sskDatacache.keyCount());
    }

    public void store(CHKBlock block) {
        boolean deep = !this.peers.isCloserLocation(block.getKey().toNormalizedDouble(), 40);
        this.store(block, deep);
    }

    public void storeShallow(CHKBlock block) {
        this.store(block, false);
    }

    public void store(KeyBlock block, boolean deep) throws KeyCollisionException {
        if (block instanceof CHKBlock) {
            this.store((CHKBlock)block, deep);
        } else if (block instanceof SSKBlock) {
            this.store((SSKBlock)block, deep, false);
        } else {
            throw new IllegalArgumentException("Unknown keytype ");
        }
    }

    private void store(CHKBlock block, boolean deep) {
        try {
            double loc = block.getKey().toNormalizedDouble();
            if (deep) {
                this.chkDatastore.put(block);
                this.nodeStats.avgStoreLocation.report(loc);
            }
            this.chkDatacache.put(block);
            this.nodeStats.avgCacheLocation.report(loc);
            this.failureTable.onFound(block);
        }
        catch (IOException e) {
            Logger.error(this, "Cannot store data: " + e, e);
        }
        catch (OutOfMemoryError e) {
            OOMHandler.handleOOM(e);
        }
        catch (Throwable t) {
            System.err.println(t);
            t.printStackTrace();
            Logger.error(this, "Caught " + t + " storing data", t);
        }
        if (this.clientCore != null && this.clientCore.requestStarters != null) {
            this.clientCore.requestStarters.chkFetchScheduler.tripPendingKey(block);
        }
    }

    public void storeInsert(SSKBlock block, boolean overwrite) throws KeyCollisionException {
        this.store(block, block.getKey().toNormalizedDouble(), true);
    }

    public void storeShallow(SSKBlock block) throws KeyCollisionException {
        this.store(block, false);
    }

    public void store(SSKBlock block, boolean deep, boolean overwrite) throws KeyCollisionException {
        try {
            this.getPubKey.cacheKey(block.getKey().getPubKeyHash(), block.getKey().getPubKey(), deep);
            if (deep) {
                this.sskDatastore.put(block, overwrite);
            }
            this.sskDatacache.put(block, overwrite);
            this.failureTable.onFound(block);
        }
        catch (IOException e) {
            Logger.error(this, "Cannot store data: " + e, e);
        }
        catch (OutOfMemoryError e) {
            OOMHandler.handleOOM(e);
        }
        catch (KeyCollisionException e) {
            throw e;
        }
        catch (Throwable t) {
            System.err.println(t);
            t.printStackTrace();
            Logger.error(this, "Caught " + t + " storing data", t);
        }
        if (this.clientCore != null && this.clientCore.requestStarters != null) {
            this.clientCore.requestStarters.sskFetchScheduler.tripPendingKey(block);
        }
    }

    public void store(SSKBlock block, double loc, boolean overwrite) throws KeyCollisionException {
        boolean deep = !this.peers.isCloserLocation(loc, 40);
        this.store(block, deep, overwrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransferringSender(NodeCHK key, RequestSender sender) {
        HashMap<NodeCHK, RequestSender> hashMap = this.transferringRequestSenders;
        synchronized (hashMap) {
            if (this.transferringRequestSenders.get(key) == sender) {
                this.transferringRequestSenders.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequestSender(Key key, short htl, RequestSender sender) {
        HashMap<KeyHTLPair, RequestSender> hashMap = this.requestSenders;
        synchronized (hashMap) {
            KeyHTLPair kh = new KeyHTLPair(key, htl, sender.uid);
            if (this.requestSenders.get(kh) == sender) {
                this.requestSenders.remove(kh);
                this.requestSenders.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInsertSender(Key key, short htl, AnyInsertSender sender) {
        HashMap<KeyHTLPair, AnyInsertSender> hashMap = this.insertSenders;
        synchronized (hashMap) {
            KeyHTLPair kh = new KeyHTLPair(key, htl, sender.getUID());
            AnyInsertSender is = this.insertSenders.remove(kh);
            if (is != sender) {
                Logger.error(this, "Removed " + is + " should be " + sender + " for " + key + ',' + htl + " in removeInsertSender");
            }
            this.insertSenders.notifyAll();
        }
    }

    public short decrementHTL(PeerNode source, short htl) {
        if (source != null) {
            return source.decrementHTL(htl);
        }
        if (htl >= this.maxHTL) {
            htl = this.maxHTL;
        }
        if (htl <= 0) {
            return 0;
        }
        if (htl == this.maxHTL) {
            if (this.decrementAtMax || this.disableProbabilisticHTLs) {
                htl = (short)(htl - 1);
            }
            return htl;
        }
        if (htl == 1) {
            if (this.decrementAtMin || this.disableProbabilisticHTLs) {
                htl = (short)(htl - 1);
            }
            return htl;
        }
        htl = (short)(htl - 1);
        return htl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CHKInsertSender makeInsertSender(NodeCHK key, short htl, long uid, PeerNode source, byte[] headers, PartiallyReceivedBlock prb, boolean fromStore, boolean cache) {
        if (logMINOR) {
            Logger.minor(this, "makeInsertSender(" + key + ',' + htl + ',' + uid + ',' + source + ",...," + fromStore);
        }
        KeyHTLPair kh = new KeyHTLPair(key, htl, uid);
        CHKInsertSender is = null;
        HashMap<KeyHTLPair, AnyInsertSender> hashMap = this.insertSenders;
        synchronized (hashMap) {
            is = (CHKInsertSender)this.insertSenders.get(kh);
        }
        if (is != null) {
            if (logMINOR) {
                Logger.minor(this, "Found " + is + " for " + kh);
            }
            return is;
        }
        if (fromStore && !cache) {
            throw new IllegalArgumentException("From store = true but cache = false !!!");
        }
        is = new CHKInsertSender(key, uid, headers, htl, source, this, prb, fromStore);
        is.start();
        if (logMINOR) {
            Logger.minor(this, is.toString() + " for " + kh.toString());
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSKInsertSender makeInsertSender(SSKBlock block, short htl, long uid, PeerNode source, boolean fromStore, boolean cache) {
        NodeSSK key = block.getKey();
        if (key.getPubKey() == null) {
            throw new IllegalArgumentException("No pub key when inserting");
        }
        if (cache) {
            this.getPubKey.cacheKey(key.getPubKeyHash(), key.getPubKey(), !this.peers.isCloserLocation(block.getKey().toNormalizedDouble(), 40));
        }
        Logger.minor(this, "makeInsertSender(" + key + ',' + htl + ',' + uid + ',' + source + ",...," + fromStore);
        KeyHTLPair kh = new KeyHTLPair(key, htl, uid);
        SSKInsertSender is = null;
        HashMap<KeyHTLPair, AnyInsertSender> hashMap = this.insertSenders;
        synchronized (hashMap) {
            is = (SSKInsertSender)this.insertSenders.get(kh);
        }
        if (is != null) {
            Logger.minor(this, "Found " + is + " for " + kh);
            return is;
        }
        if (fromStore && !cache) {
            throw new IllegalArgumentException("From store = true but cache = false !!!");
        }
        is = new SSKInsertSender(block, uid, htl, source, this, fromStore);
        is.start();
        Logger.minor(this, is.toString() + " for " + kh.toString());
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lockUID(long uid, boolean ssk, boolean insert, boolean offerReply, boolean local, UIDTag tag) {
        HashMap<Long, UIDTag> map;
        HashMap<Long, UIDTag> hashMap = this.runningUIDs;
        synchronized (hashMap) {
            if (this.runningUIDs.containsKey(uid)) {
                return false;
            }
            this.runningUIDs.put(uid, tag);
        }
        if (offerReply) {
            map = this.getOfferTracker(ssk);
            this.innerLock(map, (OfferReplyTag)tag, uid, ssk, insert, offerReply, local);
        } else if (insert) {
            map = this.getInsertTracker(ssk, local);
            this.innerLock(map, (InsertTag)tag, uid, ssk, insert, offerReply, local);
        } else {
            map = this.getRequestTracker(ssk, local);
            this.innerLock(map, (RequestTag)tag, uid, ssk, insert, offerReply, local);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends UIDTag> void innerLock(HashMap<Long, T> map, T tag, Long uid, boolean ssk, boolean insert, boolean offerReply, boolean local) {
        HashMap<Long, T> hashMap = map;
        synchronized (hashMap) {
            if (logMINOR) {
                Logger.minor(this, "Locking " + uid + " ssk=" + ssk + " insert=" + insert + " offerReply=" + offerReply + " local=" + local + " size=" + map.size(), (Throwable)new Exception("debug"));
            }
            if (map.containsKey(uid)) {
                Logger.error(this, "Already have UID in specific map (" + ssk + "," + insert + "," + offerReply + "," + local + ") but not in general map: trying to register " + tag + " but already have " + map.get(uid));
            }
            map.put(uid, tag);
            if (logMINOR) {
                Logger.minor(this, "Locked " + uid + " ssk=" + ssk + " insert=" + insert + " offerReply=" + offerReply + " local=" + local + " size=" + map.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockUID(long uid, boolean ssk, boolean insert, boolean canFail, boolean offerReply, boolean local, UIDTag tag) {
        HashMap<Long, UIDTag> map;
        this.completed(uid);
        if (offerReply) {
            map = this.getOfferTracker(ssk);
            this.innerUnlock(map, (OfferReplyTag)tag, uid, ssk, insert, offerReply, local, canFail);
        } else if (insert) {
            map = this.getInsertTracker(ssk, local);
            this.innerUnlock(map, (InsertTag)tag, uid, ssk, insert, offerReply, local, canFail);
        } else {
            map = this.getRequestTracker(ssk, local);
            this.innerUnlock(map, (RequestTag)tag, uid, ssk, insert, offerReply, local, canFail);
        }
        HashMap<Long, UIDTag> hashMap = this.runningUIDs;
        synchronized (hashMap) {
            UIDTag oldTag = this.runningUIDs.get(uid);
            if (oldTag == null) {
                if (canFail) {
                    return;
                }
                throw new IllegalStateException("Could not unlock " + uid + "! : ssk=" + ssk + " insert=" + insert + " canFail=" + canFail + " offerReply=" + offerReply + " local=" + local);
            }
            if (tag != oldTag) {
                if (canFail) {
                    return;
                }
                Logger.error(this, "Removing " + tag + " for " + uid + " but " + tag + " is registered!");
                return;
            }
            this.runningUIDs.remove(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends UIDTag> void innerUnlock(HashMap<Long, T> map, T tag, Long uid, boolean ssk, boolean insert, boolean offerReply, boolean local, boolean canFail) {
        HashMap<Long, T> hashMap = map;
        synchronized (hashMap) {
            if (logMINOR) {
                Logger.minor(this, "Unlocking " + uid + " ssk=" + ssk + " insert=" + insert + " offerReply=" + offerReply + " local=" + local + " size=" + map.size(), (Throwable)new Exception("debug"));
            }
            if (map.get(uid) != tag) {
                if (canFail) {
                    if (logMINOR) {
                        Logger.minor(this, "Can fail and did fail: removing " + tag + " got " + map.get(uid) + " for " + uid);
                    }
                } else {
                    Logger.error(this, "Removing " + tag + " for " + uid + " returned " + map.get(uid));
                }
            } else {
                map.remove(uid);
            }
            if (logMINOR) {
                Logger.minor(this, "Unlocked " + uid + " ssk=" + ssk + " insert=" + insert + " offerReply=" + offerReply + " local=" + local + " size=" + map.size());
            }
        }
    }

    private HashMap<Long, RequestTag> getRequestTracker(boolean ssk, boolean local) {
        if (ssk) {
            return local ? this.runningLocalSSKGetUIDs : this.runningSSKGetUIDs;
        }
        return local ? this.runningLocalCHKGetUIDs : this.runningCHKGetUIDs;
    }

    private HashMap<Long, InsertTag> getInsertTracker(boolean ssk, boolean local) {
        if (ssk) {
            return local ? this.runningLocalSSKPutUIDs : this.runningSSKPutUIDs;
        }
        return local ? this.runningLocalCHKPutUIDs : this.runningCHKPutUIDs;
    }

    private HashMap<Long, OfferReplyTag> getOfferTracker(boolean ssk) {
        return ssk ? this.runningSSKOfferReplyUIDs : this.runningCHKOfferReplyUIDs;
    }

    private void startDeadUIDChecker() {
        this.getTicker().queueTimedJob(this.deadUIDChecker, 600000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStatus() {
        AnyInsertSender[] senders;
        StringBuilder sb = new StringBuilder();
        if (this.peers != null) {
            sb.append(this.peers.getStatus());
        } else {
            sb.append("No peers yet");
        }
        sb.append("\nInserts: ");
        HashMap<KeyHTLPair, AnyInsertSender> hashMap = this.insertSenders;
        synchronized (hashMap) {
            senders = this.insertSenders.values().toArray(new AnyInsertSender[this.insertSenders.size()]);
        }
        int x = senders.length;
        sb.append(x);
        if (x < 5 && x > 0) {
            sb.append('\n');
            for (AnyInsertSender s : this.insertSenders.values()) {
                sb.append(s.getUID());
                sb.append(": ");
                sb.append(s.getStatusString());
                sb.append('\n');
            }
        }
        sb.append("\nRequests: ");
        sb.append(this.getNumRequestSenders());
        sb.append("\nTransferring requests: ");
        sb.append(this.getNumTransferringRequestSenders());
        sb.append('\n');
        return sb.toString();
    }

    public String getTMCIPeerList() {
        StringBuilder sb = new StringBuilder();
        if (this.peers != null) {
            sb.append(this.peers.getTMCIPeerList());
        } else {
            sb.append("No peers yet");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumInsertSenders() {
        HashMap<KeyHTLPair, AnyInsertSender> hashMap = this.insertSenders;
        synchronized (hashMap) {
            return this.insertSenders.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumRequestSenders() {
        HashMap<KeyHTLPair, RequestSender> hashMap = this.requestSenders;
        synchronized (hashMap) {
            return this.requestSenders.size();
        }
    }

    public int getNumSSKRequests() {
        return this.runningSSKGetUIDs.size() + this.runningLocalSSKGetUIDs.size();
    }

    public int getNumCHKRequests() {
        return this.runningCHKGetUIDs.size() + this.runningLocalCHKGetUIDs.size();
    }

    public int getNumSSKInserts() {
        return this.runningSSKPutUIDs.size() + this.runningLocalSSKPutUIDs.size();
    }

    public int getNumCHKInserts() {
        return this.runningCHKPutUIDs.size() + this.runningLocalCHKPutUIDs.size();
    }

    public int getNumLocalSSKRequests() {
        return this.runningLocalSSKGetUIDs.size();
    }

    public int getNumLocalCHKRequests() {
        return this.runningLocalCHKGetUIDs.size();
    }

    public int getNumRemoteSSKRequests() {
        return this.runningSSKGetUIDs.size();
    }

    public int getNumRemoteCHKRequests() {
        return this.runningCHKGetUIDs.size();
    }

    public int getNumLocalSSKInserts() {
        return this.runningLocalSSKPutUIDs.size();
    }

    public int getNumLocalCHKInserts() {
        return this.runningLocalCHKPutUIDs.size();
    }

    public int getNumRemoteSSKInserts() {
        return this.runningSSKPutUIDs.size();
    }

    public int getNumRemoteCHKInserts() {
        return this.runningCHKPutUIDs.size();
    }

    public int getNumSSKOfferReplies() {
        return this.runningSSKOfferReplyUIDs.size();
    }

    public int getNumCHKOfferReplies() {
        return this.runningCHKOfferReplyUIDs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumTransferringRequestSenders() {
        HashMap<NodeCHK, RequestSender> hashMap = this.transferringRequestSenders;
        synchronized (hashMap) {
            return this.transferringRequestSenders.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumTransferringRequestHandlers() {
        HashSet<Long> hashSet = this.transferringRequestHandlers;
        synchronized (hashSet) {
            return this.transferringRequestHandlers.size();
        }
    }

    public String getFreevizOutput() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nrequests=");
        sb.append(this.getNumRequestSenders());
        sb.append("\ntransferring_requests=");
        sb.append(this.getNumTransferringRequestSenders());
        sb.append("\ninserts=");
        sb.append(this.getNumInsertSenders());
        sb.append('\n');
        if (this.peers != null) {
            sb.append(this.peers.getFreevizOutput());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recentlyCompleted(long id) {
        LRUQueue<Long> lRUQueue = this.recentlyCompletedIDs;
        synchronized (lRUQueue) {
            return this.recentlyCompletedIDs.contains(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completed(long id) {
        LRUQueue<Long> lRUQueue = this.recentlyCompletedIDs;
        synchronized (lRUQueue) {
            this.recentlyCompletedIDs.push(id);
            while (this.recentlyCompletedIDs.size() > 10000) {
                this.recentlyCompletedIDs.pop();
            }
        }
    }

    public boolean isTestnetEnabled() {
        return this.testnetEnabled;
    }

    public ClientKeyBlock fetchKey(ClientKey key, boolean dontPromote) throws KeyVerifyException {
        if (key instanceof ClientCHK) {
            return this.fetch((ClientCHK)key, dontPromote);
        }
        if (key instanceof ClientSSK) {
            return this.fetch((ClientSSK)key, dontPromote);
        }
        throw new IllegalStateException("Don't know what to do with " + key);
    }

    public ClientKeyBlock fetch(ClientSSK clientSSK, boolean dontPromote) throws SSKVerifyException {
        DSAPublicKey key = clientSSK.getPubKey();
        if (key == null) {
            key = this.getPubKey.getKey(clientSSK.pubKeyHash);
        }
        if (key == null) {
            return null;
        }
        clientSSK.setPublicKey(key);
        SSKBlock block = this.fetch((NodeSSK)clientSSK.getNodeKey(), dontPromote);
        if (block == null) {
            if (logMINOR) {
                Logger.minor(this, "Could not find key for " + clientSSK + " (dontPromote=" + dontPromote + ")");
            }
            return null;
        }
        this.getPubKey.cacheKey(clientSSK.pubKeyHash, key, false);
        return ClientSSKBlock.construct(block, clientSSK);
    }

    private ClientKeyBlock fetch(ClientCHK clientCHK, boolean dontPromote) throws CHKVerifyException {
        CHKBlock block = this.fetch(clientCHK.getNodeCHK(), dontPromote);
        if (block == null) {
            return null;
        }
        return new ClientCHKBlock(block, clientCHK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(int reason) {
        try {
            this.park();
            System.out.println("Goodbye.");
            System.out.println(reason);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            System.exit(reason);
            throw throwable;
        }
        System.exit(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(String reason) {
        try {
            this.park();
            System.out.println("Goodbye. from " + this + " (" + reason + ')');
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            System.exit(0);
            throw throwable;
        }
        System.exit(0);
    }

    public boolean isStopping() {
        return this.isStopping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void park() {
        Node node = this;
        synchronized (node) {
            if (this.isStopping) {
                return;
            }
            this.isStopping = true;
        }
        try {
            Message msg = DMT.createFNPDisconnect(false, false, -1, new ShortBuffer(new byte[0]));
            this.peers.localBroadcast(msg, true, false, this.peers.ctrDisconn);
        }
        catch (Throwable t) {
            try {
                Logger.error(this, "Failed to tell peers we are going down: " + t, t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.config.store();
        Yarrow myRandom = (Yarrow)this.random;
        myRandom.write_seed(myRandom.seedfile, true);
    }

    public NodeUpdateManager getNodeUpdater() {
        return this.nodeUpdater;
    }

    public DarknetPeerNode[] getDarknetConnections() {
        return this.peers.getDarknetPeers();
    }

    public boolean addPeerConnection(PeerNode pn) {
        boolean retval = this.peers.addPeer(pn);
        this.peers.writePeers();
        return retval;
    }

    public void removePeerConnection(PeerNode pn) {
        this.peers.disconnect(pn, true, false, false);
    }

    public void onConnectedPeer() {
        if (logMINOR) {
            Logger.minor(this, "onConnectedPeer()");
        }
        this.ipDetector.onConnectedPeer();
    }

    public int getFNPPort() {
        return this.getDarknetPortNumber();
    }

    public synchronized boolean setNewestPeerLastGoodVersion(int version) {
        if (version > Node.buildOldAgeUserAlert.lastGoodVersion) {
            if (Node.buildOldAgeUserAlert.lastGoodVersion == 0) {
                this.clientCore.alerts.register(buildOldAgeUserAlert);
            }
            Node.buildOldAgeUserAlert.lastGoodVersion = version;
            return true;
        }
        return false;
    }

    public synchronized boolean isOudated() {
        return Node.buildOldAgeUserAlert.lastGoodVersion > 0;
    }

    public synchronized void registerNodeToNodeMessageListener(int type, NodeToNodeMessageListener listener) {
        this.n2nmListeners.put(type, listener);
    }

    public void receivedNodeToNodeMessage(Message m, PeerNode src) {
        int type = (Integer)m.getObject("nodeToNodeMessageType");
        ShortBuffer messageData = (ShortBuffer)m.getObject("nodeToNodeMessageData");
        this.receivedNodeToNodeMessage(src, type, messageData, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedNodeToNodeMessage(PeerNode src, int type, ShortBuffer messageData, boolean partingMessage) {
        boolean fromDarknet = false;
        if (src instanceof DarknetPeerNode) {
            fromDarknet = true;
        }
        NodeToNodeMessageListener listener = null;
        Node node = this;
        synchronized (node) {
            listener = this.n2nmListeners.get(type);
        }
        if (listener == null) {
            Logger.error(this, "Unknown n2nm ID: " + type + " - discarding packet length " + messageData.getLength());
            return;
        }
        listener.handleMessage(messageData.getData(), fromDarknet, src, type);
    }

    public void handleNodeToNodeTextMessageSimpleFieldSet(SimpleFieldSet fs, DarknetPeerNode source, int fileNumber) throws FSParseException {
        if (logMINOR) {
            Logger.minor(this, "Got node to node message: \n" + fs);
        }
        int overallType = fs.getInt("n2nType");
        fs.removeValue("n2nType");
        if (overallType == 1) {
            this.handleFproxyNodeToNodeTextMessageSimpleFieldSet(fs, source, fileNumber);
        } else {
            Logger.error(this, "Received unknown node to node message type '" + overallType + "' from " + source.getPeer());
        }
    }

    private void handleFproxyNodeToNodeTextMessageSimpleFieldSet(SimpleFieldSet fs, DarknetPeerNode source, int fileNumber) throws FSParseException {
        int type = fs.getInt("type");
        if (type == 1) {
            source.handleFproxyN2NTM(fs, fileNumber);
        } else if (type == 2) {
            source.handleFproxyFileOffer(fs, fileNumber);
        } else if (type == 3) {
            source.handleFproxyFileOfferAccepted(fs, fileNumber);
        } else if (type == 4) {
            source.handleFproxyFileOfferRejected(fs, fileNumber);
        } else {
            Logger.error(this, "Received unknown fproxy node to node message sub-type '" + type + "' from " + source.getPeer());
        }
    }

    public String getMyName() {
        return this.myName;
    }

    public MessageCore getUSM() {
        return this.usm;
    }

    public LocationManager getLocationManager() {
        return this.lm;
    }

    public int getSwaps() {
        return LocationManager.swaps;
    }

    public int getNoSwaps() {
        return LocationManager.noSwaps;
    }

    public int getStartedSwaps() {
        return LocationManager.startedSwaps;
    }

    public int getSwapsRejectedAlreadyLocked() {
        return LocationManager.swapsRejectedAlreadyLocked;
    }

    public int getSwapsRejectedNowhereToGo() {
        return LocationManager.swapsRejectedNowhereToGo;
    }

    public int getSwapsRejectedRateLimit() {
        return LocationManager.swapsRejectedRateLimit;
    }

    public int getSwapsRejectedRecognizedID() {
        return LocationManager.swapsRejectedRecognizedID;
    }

    public PeerNode[] getPeerNodes() {
        return this.peers.myPeers;
    }

    public PeerNode[] getConnectedPeers() {
        return this.peers.connectedPeers;
    }

    public PeerNode getPeerNode(String nodeIdentifier) {
        PeerNode[] pn = this.peers.myPeers;
        for (int i = 0; i < pn.length; ++i) {
            Peer peer = pn[i].getPeer();
            String nodeIpAndPort = "";
            if (peer != null) {
                nodeIpAndPort = peer.toString();
            }
            String identity = pn[i].getIdentityString();
            if (pn[i] instanceof DarknetPeerNode) {
                DarknetPeerNode dpn = (DarknetPeerNode)pn[i];
                String name = dpn.myName;
                if (!identity.equals(nodeIdentifier) && !nodeIpAndPort.equals(nodeIdentifier) && !name.equals(nodeIdentifier)) continue;
                return pn[i];
            }
            if (!identity.equals(nodeIdentifier) && !nodeIpAndPort.equals(nodeIdentifier)) continue;
            return pn[i];
        }
        return null;
    }

    public boolean isHasStarted() {
        return this.hasStarted;
    }

    public void queueRandomReinsert(KeyBlock block) {
        this.clientCore.queueRandomReinsert(block);
    }

    public String getExtraPeerDataDir() {
        return this.extraPeerDataDir.getPath();
    }

    public boolean noConnectedPeers() {
        return !this.peers.anyConnectedPeers();
    }

    public double getLocation() {
        return this.lm.getLocation();
    }

    public double getLocationChangeSession() {
        return this.lm.getLocChangeSession();
    }

    public int getAverageOutgoingSwapTime() {
        return this.lm.getAverageSwapTime();
    }

    public int getSendSwapInterval() {
        return this.lm.getSendSwapInterval();
    }

    public int getNumberOfRemotePeerLocationsSeenInSwaps() {
        return this.lm.numberOfRemotePeerLocationsSeenInSwaps;
    }

    public boolean isAdvancedModeEnabled() {
        if (this.clientCore == null) {
            return false;
        }
        return this.clientCore.isAdvancedModeEnabled();
    }

    public boolean isFProxyJavascriptEnabled() {
        return this.clientCore.isFProxyJavascriptEnabled();
    }

    public int getNumARKFetchers() {
        PeerNode[] p = this.peers.myPeers;
        int x = 0;
        for (int i = 0; i < p.length; ++i) {
            if (!p[i].isFetchingARK()) continue;
            ++x;
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sentPayload(int len) {
        Object object = this.statsSync;
        synchronized (object) {
            this.totalPayloadSent += (long)len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalPayloadSent() {
        Object object = this.statsSync;
        synchronized (object) {
            return this.totalPayloadSent;
        }
    }

    public void setName(String key) throws InvalidConfigValueException, NodeNeedRestartException {
        this.config.get("node").getOption("name").setValue(key);
    }

    public Ticker getTicker() {
        return this.ps;
    }

    public int getUnclaimedFIFOSize() {
        return this.usm.getUnclaimedFIFOSize();
    }

    public void connectToSeednode(SeedServerTestPeerNode node) throws OpennetDisabledException, FSParseException, PeerParseException, ReferenceSignatureVerificationException {
        this.peers.addPeer(node, false, false);
    }

    public void connect(Node node) throws FSParseException, PeerParseException, ReferenceSignatureVerificationException {
        this.peers.connect(node.darknetCrypto.exportPublicFieldSet(), this.darknetCrypto.packetMangler);
    }

    public short maxHTL() {
        return this.maxHTL;
    }

    public int getDarknetPortNumber() {
        return this.darknetCrypto.portNumber;
    }

    public void JEStatsDump() {
        if (this.storeEnvironment == null) {
            System.out.println("database stat not availiable");
            return;
        }
        try {
            StatsConfig statsConf = new StatsConfig();
            statsConf.setClear(true);
            System.out.println(this.storeEnvironment.getStats(statsConf));
        }
        catch (DatabaseException e) {
            System.out.println("Failed to get stats from JE environment: " + (Object)((Object)e));
        }
    }

    public int getOutputBandwidthLimit() {
        return this.outputBandwidthLimit;
    }

    public synchronized int getInputBandwidthLimit() {
        if (this.inputLimitDefault) {
            return this.outputBandwidthLimit * 4;
        }
        return this.inputBandwidthLimit;
    }

    @Override
    public synchronized void setTimeSkewDetectedUserAlert() {
        if (timeSkewDetectedUserAlert == null) {
            timeSkewDetectedUserAlert = new TimeSkewDetectedUserAlert();
            this.clientCore.alerts.register(timeSkewDetectedUserAlert);
        }
    }

    public File getNodeDir() {
        return this.nodeDir;
    }

    public DarknetPeerNode createNewDarknetNode(SimpleFieldSet fs) throws FSParseException, PeerParseException, ReferenceSignatureVerificationException {
        return new DarknetPeerNode(fs, this, this.darknetCrypto, this.peers, false, this.darknetCrypto.packetMangler);
    }

    public OpennetPeerNode createNewOpennetNode(SimpleFieldSet fs) throws FSParseException, OpennetDisabledException, PeerParseException, ReferenceSignatureVerificationException {
        if (this.opennet == null) {
            throw new OpennetDisabledException("Opennet is not currently enabled");
        }
        return new OpennetPeerNode(fs, this, this.opennet.crypto, this.opennet, this.peers, false, this.opennet.crypto.packetMangler);
    }

    public SeedServerTestPeerNode createNewSeedServerTestPeerNode(SimpleFieldSet fs) throws FSParseException, OpennetDisabledException, PeerParseException, ReferenceSignatureVerificationException {
        if (this.opennet == null) {
            throw new OpennetDisabledException("Opennet is not currently enabled");
        }
        return new SeedServerTestPeerNode(fs, this, this.opennet.crypto, this.peers, true, this.opennet.crypto.packetMangler);
    }

    public OpennetPeerNode addNewOpennetNode(SimpleFieldSet fs) throws FSParseException, PeerParseException, ReferenceSignatureVerificationException {
        if (this.opennet == null) {
            return null;
        }
        return this.opennet.addNewOpennetNode(fs);
    }

    public byte[] getOpennetIdentity() {
        return this.opennet.crypto.myIdentity;
    }

    public byte[] getDarknetIdentity() {
        return this.darknetCrypto.myIdentity;
    }

    public int estimateFullHeadersLengthOneMessage() {
        return this.darknetCrypto.packetMangler.fullHeadersLengthOneMessage();
    }

    public synchronized boolean isOpennetEnabled() {
        return this.opennet != null;
    }

    public SimpleFieldSet exportDarknetPublicFieldSet() {
        return this.darknetCrypto.exportPublicFieldSet();
    }

    public SimpleFieldSet exportOpennetPublicFieldSet() {
        return this.opennet.crypto.exportPublicFieldSet();
    }

    public SimpleFieldSet exportDarknetPrivateFieldSet() {
        return this.darknetCrypto.exportPrivateFieldSet();
    }

    public SimpleFieldSet exportOpennetPrivateFieldSet() {
        return this.opennet.crypto.exportPrivateFieldSet();
    }

    public synchronized boolean dontDetect() {
        if (!this.darknetCrypto.getBindTo().isRealInternetAddress(false, true, false)) {
            return false;
        }
        return this.opennet == null || !this.opennet.crypto.getBindTo().isRealInternetAddress(false, true, false);
    }

    public int getOpennetFNPPort() {
        if (this.opennet == null) {
            return -1;
        }
        return this.opennet.crypto.portNumber;
    }

    OpennetManager getOpennet() {
        return this.opennet;
    }

    public synchronized boolean passOpennetRefsThroughDarknet() {
        return this.passOpennetRefsThroughDarknet;
    }

    public Set<ForwardPort> getPublicInterfacePorts() {
        NodeCrypto crypto;
        HashSet<ForwardPort> set = new HashSet<ForwardPort>();
        set.add(new ForwardPort("darknet", false, 17, this.darknetCrypto.portNumber));
        if (this.opennet != null && (crypto = this.opennet.crypto) != null) {
            set.add(new ForwardPort("opennet", false, 17, crypto.portNumber));
        }
        return set;
    }

    public long getUptime() {
        return System.currentTimeMillis() - this.usm.getStartedTime();
    }

    public synchronized UdpSocketHandler[] getPacketSocketHandlers() {
        if (this.opennet != null) {
            return new UdpSocketHandler[]{this.darknetCrypto.socket, this.opennet.crypto.socket};
        }
        return new UdpSocketHandler[]{this.darknetCrypto.socket};
    }

    public int getMaxOpennetPeers() {
        return this.maxOpennetPeers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAddedValidIP() {
        Announcer announcer;
        OpennetManager om;
        Node node = this;
        synchronized (node) {
            om = this.opennet;
        }
        if (om != null && (announcer = om.announcer) != null) {
            announcer.maybeSendAnnouncement();
        }
    }

    public boolean wantAnonAuth() {
        return this.opennet != null && this.acceptSeedConnections;
    }

    public void displayClockProblemUserAlert(boolean value) {
        if (value) {
            this.clientCore.alerts.register(clockProblemDetectedUserAlert);
        } else {
            this.clientCore.alerts.unregister(clockProblemDetectedUserAlert);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean opennetDefinitelyPortForwarded() {
        OpennetManager om;
        Node node = this;
        synchronized (node) {
            om = this.opennet;
        }
        if (om == null) {
            return false;
        }
        NodeCrypto crypto = om.crypto;
        if (crypto == null) {
            return false;
        }
        return crypto.definitelyPortForwarded();
    }

    public boolean darknetDefinitelyPortForwarded() {
        if (this.darknetCrypto == null) {
            return false;
        }
        return this.darknetCrypto.definitelyPortForwarded();
    }

    public boolean hasKey(Key key) {
        if (key instanceof NodeCHK) {
            return this.fetch((NodeCHK)key, true) != null;
        }
        return this.fetch((NodeSSK)key, true) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalRunningUIDs() {
        HashMap<Long, UIDTag> hashMap = this.runningUIDs;
        synchronized (hashMap) {
            return this.runningUIDs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRunningUIDs(Vector<Long> list) {
        HashMap<Long, UIDTag> hashMap = this.runningUIDs;
        synchronized (hashMap) {
            list.addAll(this.runningUIDs.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalRunningUIDsAlt() {
        HashMap<Long, UIDTag> hashMap = this.runningUIDs;
        synchronized (hashMap) {
            return this.runningCHKGetUIDs.size() + this.runningCHKPutUIDs.size() + this.runningSSKGetUIDs.size() + this.runningSSKGetUIDs.size() + this.runningSSKOfferReplyUIDs.size() + this.runningCHKOfferReplyUIDs.size();
        }
    }

    public void setLocation(double loc) {
        this.lm.setLocation(loc);
    }

    public boolean peersWantKey(Key key) {
        return this.failureTable.peersWantKey(key);
    }

    public void onTooLowMTU(int minAdvertisedMTU, int minAcceptableMTU) {
        if (this.alertMTUTooSmall != null) {
            return;
        }
        this.alertMTUTooSmall = new SimpleUserAlert(false, this.l10n("tooSmallMTU"), this.l10n("tooSmallMTULong", new String[]{"mtu", "minMTU"}, new String[]{Integer.toString(minAdvertisedMTU), Integer.toString(minAcceptableMTU)}), this.l10n("tooSmallMTUShort"), 1);
        this.clientCore.alerts.register(this.alertMTUTooSmall);
    }

    public void setDispatcherHook(NodeDispatcher.NodeDispatcherCallback cb) {
        this.dispatcher.setHook(cb);
    }

    public boolean shallWePublishOurPeersLocation() {
        return this.publishOurPeersLocation;
    }

    public boolean shallWeRouteAccordingToOurPeersLocation() {
        return this.routeAccordingToOurPeersLocation && Version.lastGoodBuild() >= 1160;
    }

    public boolean objectCanNew(ObjectContainer container) {
        Logger.error(this, "Not storing Node in database", new Exception("error"));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeTurtle(RequestSender sender) {
        if (!this.registerTurtleTransfer(sender)) {
            sender.killTurtle();
            Logger.error(this, "Didn't make turtle (global) for key " + sender.key + " for " + sender);
            return;
        }
        PeerNode from = sender.transferringFrom();
        if (from == null) {
            return;
        }
        if (!from.registerTurtleTransfer(sender)) {
            this.unregisterTurtleTransfer(sender);
            sender.killTurtle();
            Logger.error(this, "Didn't make turtle (peer) for key " + sender.key + " for " + sender);
            return;
        }
        Logger.normal(this, "TURTLING: " + sender.key + " for " + sender);
        HashMap<NodeCHK, RequestSender> hashMap = this.transferringRequestSenders;
        synchronized (hashMap) {
            this.transferringRequestSenders.remove(sender.key);
        }
        ++this.turtleCount;
        sender.setTurtle();
    }

    public long getTurtleCount() {
        return this.turtleCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerTurtleTransfer(RequestSender sender) {
        Key key = sender.key;
        HashMap<Key, RequestSender[]> hashMap = this.turtlingTransfers;
        synchronized (hashMap) {
            if (this.getNumIncomingTurtles() >= MAX_TURTLES) {
                Logger.error(this, "Too many turtles running globally");
                return false;
            }
            if (!this.turtlingTransfers.containsKey(key)) {
                this.turtlingTransfers.put(key, new RequestSender[]{sender});
                Logger.normal(this, "Running turtles (a): " + this.getNumIncomingTurtles() + " : " + this.turtlingTransfers.size());
                return true;
            }
            RequestSender[] senders = this.turtlingTransfers.get(key);
            if (senders.length >= MAX_TURTLES_PER_KEY) {
                Logger.error(this, "Too many turtles for key globally");
                return false;
            }
            for (int i = 0; i < senders.length; ++i) {
                if (senders[i] != sender) continue;
                Logger.error(this, "Registering turtle for " + sender + " : " + key + " twice! (globally)");
                return false;
            }
            RequestSender[] newSenders = new RequestSender[senders.length + 1];
            System.arraycopy(senders, 0, newSenders, 0, senders.length);
            newSenders[senders.length] = sender;
            this.turtlingTransfers.put(key, newSenders);
            Logger.normal(this, "Running turtles (b): " + this.getNumIncomingTurtles() + " : " + this.turtlingTransfers.size());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterTurtleTransfer(RequestSender sender) {
        Key key = sender.key;
        HashMap<Key, RequestSender[]> hashMap = this.turtlingTransfers;
        synchronized (hashMap) {
            if (!this.turtlingTransfers.containsKey(key)) {
                Logger.error(this, "Removing turtle " + sender + " for " + key + " : DOES NOT EXIST IN GLOBAL TURTLES LIST");
                return;
            }
            RequestSender[] senders = this.turtlingTransfers.get(key);
            if (senders.length == 1 && senders[0] == sender) {
                this.turtlingTransfers.remove(key);
                return;
            }
            if (senders.length == 2) {
                if (senders[0] == sender) {
                    this.turtlingTransfers.put(key, new RequestSender[]{senders[1]});
                } else if (senders[1] == sender) {
                    this.turtlingTransfers.put(key, new RequestSender[]{senders[0]});
                }
                return;
            }
            int x = 0;
            for (int i = 0; i < senders.length; ++i) {
                if (senders[i] != sender) continue;
                ++x;
            }
            if (x == 0) {
                Logger.error(this, "Turtle not in global register: " + sender + " for " + key);
                return;
            }
            if (senders.length == x) {
                Logger.error(this, "Lots of copies of turtle: " + x);
                this.turtlingTransfers.remove(key);
                return;
            }
            RequestSender[] newSenders = new RequestSender[senders.length - x];
            int idx = 0;
            for (RequestSender s : senders) {
                if (s == sender) continue;
                newSenders[idx++] = s;
            }
            this.turtlingTransfers.put(key, newSenders);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumIncomingTurtles() {
        HashMap<Key, RequestSender[]> hashMap = this.turtlingTransfers;
        synchronized (hashMap) {
            int turtles = 0;
            for (RequestSender[] senders : this.turtlingTransfers.values()) {
                turtles += senders.length;
            }
            return turtles;
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
        clockProblemDetectedUserAlert = new ClockProblemDetectedUserAlert();
        jvmHasGCJCharConversionBug = false;
        MAX_TURTLES = 10;
        MAX_TURTLES_PER_KEY = 2;
    }

    static class KeyHTLPair {
        final Key key;
        final short htl;
        final long uid;

        KeyHTLPair(Key key, short htl, long uid) {
            this.key = key;
            this.htl = htl;
            this.uid = uid;
        }

        public boolean equals(Object o) {
            if (o instanceof KeyHTLPair) {
                KeyHTLPair p = (KeyHTLPair)o;
                return p.key.equals(this.key) && p.htl == this.htl && p.uid == this.uid;
            }
            return false;
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.htl ^ (int)this.uid;
        }

        public String toString() {
            return this.key.toString() + ':' + this.htl + ':' + this.uid;
        }
    }

    private static class L10nCallback
    extends StringCallback
    implements EnumerableOptionCallback {
        private L10nCallback() {
        }

        public String get() {
            return L10n.getSelectedLanguage().fullName;
        }

        public void set(String val) throws InvalidConfigValueException {
            if (val == null || this.get().equalsIgnoreCase(val)) {
                return;
            }
            try {
                L10n.setLanguage(val);
            }
            catch (MissingResourceException e) {
                throw new InvalidConfigValueException(e.getLocalizedMessage());
            }
            PluginManager.setLanguage(L10n.getSelectedLanguage());
        }

        public String[] getPossibleValues() {
            return L10n.LANGUAGE.valuesWithFullNames();
        }
    }

    private class StoreTypeCallback
    extends StringCallback
    implements EnumerableOptionCallback {
        private String cachedStoreType;

        private StoreTypeCallback() {
        }

        public String get() {
            if (this.cachedStoreType == null) {
                this.cachedStoreType = Node.this.storeType;
            }
            return this.cachedStoreType;
        }

        public void set(String val) throws InvalidConfigValueException, NodeNeedRestartException {
            boolean found = false;
            for (String p : this.getPossibleValues()) {
                if (!p.equals(val)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new InvalidConfigValueException("Invalid store type");
            }
            this.cachedStoreType = val;
            throw new NodeNeedRestartException("Store type cannot be changed on the fly");
        }

        public String[] getPossibleValues() {
            return new String[]{"bdb-index", "salt-hash", "ram"};
        }
    }

    public class NodeNameCallback
    extends StringCallback {
        NodeNameCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String get() {
            String name;
            NodeNameCallback nodeNameCallback = this;
            synchronized (nodeNameCallback) {
                name = Node.this.myName;
            }
            if (name.startsWith("Node id|") || name.equals("MyFirstFreenetNode")) {
                Node.this.clientCore.alerts.register(nodeNameUserAlert);
            } else {
                Node.this.clientCore.alerts.unregister(nodeNameUserAlert);
            }
            return name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(String val) throws InvalidConfigValueException {
            if (this.get().equals(val)) {
                return;
            }
            if (val.length() > 128) {
                throw new InvalidConfigValueException("The given node name is too long (" + val + ')');
            }
            if ("".equals(val)) {
                val = "~none~";
            }
            NodeNameCallback nodeNameCallback = this;
            synchronized (nodeNameCallback) {
                Node.this.myName = val;
            }
            SimpleFieldSet fs = new SimpleFieldSet(true);
            fs.putSingle("myName", Node.this.myName);
            Node.this.peers.locallyBroadcastDiffNodeRef(fs, true, false);
            this.get();
        }
    }
}

