/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.support.Logger;
import freenet.support.ShortBuffer;
import freenet.support.math.BootstrappingDecayingRunningAverage;
import freenet.support.math.RunningAverage;
import freenet.support.math.TrivialRunningAverage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkIDManager
implements Runnable,
Comparator<PeerNetworkGroup> {
    public static boolean disableSecretPings = true;
    public static boolean disableSecretPinger = true;
    private static final int ACCEPTED_TIMEOUT = 5000;
    private static final int SECRETPONG_TIMEOUT = 20000;
    private static final long BETWEEN_PEERS = 2000L;
    private static final long STARTUP_DELAY = 20000L;
    private static final long LONG_PERIOD = 120000L;
    private final short MAX_HTL;
    private static final short MIN_HTL = 3;
    private final boolean logMINOR;
    private static final int NO_NETWORKID = 0;
    private static final int MIN_PINGS_FOR_STARTUP = 3;
    private static final int COMFORT_LEVEL = 20;
    private static final int PING_VOLLEYS_PER_NETWORK_RECOMPUTE = 5;
    private final HashMap<PeerNode, StoredSecret> secretsByPeer = new HashMap();
    private final HashMap<Long, StoredSecret> secretsByUID = new HashMap();
    private static final double MAGIC_LINEAR_GRACE = 0.8;
    private static final double FALL_OPEN_MARK = 0.2;
    private final Node node;
    private int startupChecks;
    private HashMap<PeerNode, HashMap<PeerNode, PingRecord>> recordMapsByPeer = new HashMap();
    private List<PeerNode> workQueue = new ArrayList<PeerNode>();
    private PeerNode processing;
    private boolean processingRace;
    private int pingVolleysToGo = 5;
    public long secretPingSuccesses;
    public long totalSecretPingAttempts;
    private double cheat_findBestSetwisePingAverage_best;
    private RunningAverage cheat_stats_general_bestOther = new TrivialRunningAverage();
    private RunningAverage cheat_stats_findBestSetwisePingAverage_best_general = new TrivialRunningAverage();
    boolean inTransition = false;
    Object transitionLock = new Object();
    List<PeerNetworkGroup> networkGroups = new ArrayList<PeerNetworkGroup>();
    public int ourNetworkId = 0;
    private final ByteCounter ctr = new ByteCounter(){

        public void receivedBytes(int x) {
            ((NetworkIDManager)NetworkIDManager.this).node.nodeStats.networkColoringReceivedBytes(x);
        }

        public void sentBytes(int x) {
            ((NetworkIDManager)NetworkIDManager.this).node.nodeStats.networkColoringSentBytes(x);
        }

        public void sentPayload(int x) {
        }
    };

    NetworkIDManager(final Node node) {
        this.node = node;
        this.MAX_HTL = node.maxHTL();
        this.logMINOR = Logger.shouldLog(4, this);
        if (!disableSecretPinger) {
            node.getTicker().queueTimedJob(new Runnable(){

                public void run() {
                    NetworkIDManager.this.checkAllPeers();
                    NetworkIDManager.this.startupChecks = node.peers.quickCountConnectedPeers() * 3;
                    Logger.normal(NetworkIDManager.this, "Past startup delay, " + NetworkIDManager.this.startupChecks + " connected peers");
                    NetworkIDManager.this.reschedule(0L);
                }
            }, 20000L);
        }
    }

    public boolean handleStoreSecret(Message m) {
        if (disableSecretPings) {
            return true;
        }
        PeerNode pn = (PeerNode)m.getSource();
        long uid = m.getLong("uid");
        long secret = m.getLong("secret");
        StoredSecret s = new StoredSecret(pn, uid, secret);
        if (this.logMINOR) {
            Logger.minor(this, "Storing secret: " + s);
        }
        this.addOrReplaceSecret(s);
        try {
            pn.sendAsync(DMT.createFNPAccepted(uid), null, this.ctr);
        }
        catch (NotConnectedException e) {
            Logger.error(this, "peer disconnected before storeSecret ack?", e);
        }
        return true;
    }

    public boolean handleSecretPing(final Message m) {
        if (disableSecretPings) {
            return true;
        }
        final PeerNode source = (PeerNode)m.getSource();
        final long uid = m.getLong("uid");
        final short htl = m.getShort("hopsToLive");
        final short dawnHtl = m.getShort("dawnHtl");
        final int counter = m.getInt("counter");
        this.node.executor.execute(new Runnable(){

            public void run() {
                try {
                    NetworkIDManager.this._handleSecretPing(m, source, uid, htl, dawnHtl, counter);
                }
                catch (NotConnectedException e) {
                    Logger.normal(this, "secretPing/not connected: " + e);
                }
            }
        }, "SecretPingHandler for UID " + uid + " on " + this.node.getDarknetPortNumber());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _handleSecretPing(Message m, PeerNode source, long uid, short htl, short dawnHtl, int counter) throws NotConnectedException {
        block23: {
            if (disableSecretPings || this.node.recentlyCompleted(uid)) {
                if (this.logMINOR) {
                    Logger.minor(this, "recently complete/loop: " + uid);
                }
                source.sendAsync(DMT.createFNPRejectedLoop(uid), null, this.ctr);
            } else {
                StoredSecret match;
                byte[] nodeIdentity = ((ShortBuffer)m.getObject("nodeIdentity")).getData();
                HashMap<PeerNode, StoredSecret> hashMap = this.secretsByPeer;
                synchronized (hashMap) {
                    match = this.secretsByUID.get(uid);
                }
                if (match != null) {
                    if (htl > dawnHtl) {
                        source.sendAsync(DMT.createFNPRejectedLoop(uid), null, this.ctr);
                    } else {
                        if (this.logMINOR) {
                            Logger.minor(this, "Responding to " + source + " with " + match + " from " + match.peer);
                        }
                        source.sendAsync(match.getSecretPong(counter + 1), null, this.ctr);
                    }
                } else {
                    Message msg;
                    this.node.completed(uid);
                    double target = m.getDouble("targetLocation");
                    HashSet<PeerNode> routedTo = new HashSet<PeerNode>();
                    while (true) {
                        PeerNode next;
                        if ((next = htl > dawnHtl && routedTo.isEmpty() ? this.node.peers.getRandomPeer(source) : this.node.peers.closerPeer(source, routedTo, target, true, this.node.isAdvancedModeEnabled(), -1, null, null)) == null) {
                            source.sendAsync(DMT.createFNPRejectedLoop(uid), null, this.ctr);
                            break block23;
                        }
                        if ((htl = next.decrementHTL(htl)) <= 0) {
                            source.sendAsync(DMT.createFNPRejectedLoop(uid), null, this.ctr);
                            break block23;
                        }
                        if (!source.isConnected()) {
                            throw new NotConnectedException("source gone away while forwarding");
                        }
                        ++counter;
                        routedTo.add(next);
                        try {
                            next.sendAsync(DMT.createFNPSecretPing(uid, target, htl, dawnHtl, counter, nodeIdentity), null, this.ctr);
                        }
                        catch (NotConnectedException e) {
                            Logger.normal(this, next + " disconnected before secret-ping-forward");
                            continue;
                        }
                        MessageFilter mfPong = MessageFilter.create().setSource(next).setField("uid", uid).setTimeout(20000).setType(DMT.FNPSecretPong);
                        MessageFilter mfRejectLoop = MessageFilter.create().setSource(next).setField("uid", uid).setTimeout(20000).setType(DMT.FNPRejectedLoop);
                        try {
                            msg = this.node.usm.waitFor(mfPong.or(mfRejectLoop), null);
                        }
                        catch (DisconnectedException e) {
                            Logger.normal(this, next + " disconnected while waiting for a secret-pong");
                            continue;
                        }
                        if (msg == null) {
                            Logger.error(this, "fatal timeout in waiting for secretpong from " + next);
                            break block23;
                        }
                        if (msg.getSpec() == DMT.FNPSecretPong) {
                            int suppliedCounter = msg.getInt("counter");
                            if (suppliedCounter > counter) {
                                counter = suppliedCounter;
                            }
                            long secret = msg.getLong("secret");
                            if (this.logMINOR) {
                                Logger.minor(this, this.node + " forwarding apparently-successful secretpong response: " + counter + "/" + secret + " from " + next + " to " + source);
                            }
                            source.sendAsync(DMT.createFNPSecretPong(uid, counter, secret), null, this.ctr);
                            break block23;
                        }
                        if (msg.getSpec() != DMT.FNPRejectedLoop) break;
                        if (!this.logMINOR) continue;
                        Logger.minor(this, "secret ping (reject/loop): " + source + " -> " + next);
                    }
                    Logger.error(this, "unexpected message type: " + msg);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDisconnect(PeerNode pn) {
        HashMap<PeerNode, StoredSecret> hashMap = this.secretsByPeer;
        synchronized (hashMap) {
            StoredSecret s = this.secretsByPeer.get(pn);
            if (s != null) {
                Logger.normal(this, "Removing on disconnect: " + s);
                this.removeSecret(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrReplaceSecret(StoredSecret s) {
        HashMap<PeerNode, StoredSecret> hashMap = this.secretsByPeer;
        synchronized (hashMap) {
            StoredSecret prev = this.secretsByPeer.get(s.peer);
            if (prev != null) {
                if (this.logMINOR) {
                    Logger.minor(this, "Removing on replacement: " + s);
                }
                this.removeSecret(prev);
            }
            this.secretsByPeer.put(s.peer, s);
            this.secretsByUID.put(s.uid, s);
        }
    }

    private void removeSecret(StoredSecret s) {
        this.secretsByPeer.remove(s.peer);
        this.secretsByUID.remove(s.uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PingRecord getPingRecord(PeerNode target, PeerNode via) {
        PingRecord retval;
        HashMap<PeerNode, HashMap<PeerNode, PingRecord>> hashMap = this.recordMapsByPeer;
        synchronized (hashMap) {
            HashMap<PeerNode, PingRecord> peerRecords = this.recordMapsByPeer.get(target);
            if (peerRecords == null) {
                peerRecords = new HashMap();
                this.recordMapsByPeer.put(target, peerRecords);
            }
            if ((retval = peerRecords.get(via)) == null) {
                retval = new PingRecord();
                retval.target = target;
                retval.via = via;
                peerRecords.put(via, retval);
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forgetPingRecords(PeerNode p) {
        Object object = this.workQueue;
        synchronized (object) {
            this.workQueue.remove(p);
            if (p.equals(this.processing)) {
                this.processingRace = true;
                return;
            }
        }
        object = this.recordMapsByPeer;
        synchronized (object) {
            this.recordMapsByPeer.remove(p);
            for (HashMap<PeerNode, PingRecord> complement : this.recordMapsByPeer.values()) {
                complement.values().remove(p);
            }
        }
    }

    private void reschedule(long period) {
        this.node.getTicker().queueTimedJob(this, period);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean didAnything;
        List<PeerNode> list = this.workQueue;
        synchronized (list) {
            if (this.processing != null) {
                Logger.error(this, "possibly *bad* programming error, only one thread should use secretpings");
                return;
            }
            if (!this.workQueue.isEmpty()) {
                this.processing = this.workQueue.remove(0);
            }
        }
        if (this.processing != null) {
            PeerNode target = this.processing;
            double randomTarget = this.node.random.nextDouble();
            HashSet<PeerNode> nodesRoutedTo = new HashSet<PeerNode>();
            PeerNode next = this.node.peers.closerPeer(target, nodesRoutedTo, randomTarget, true, false, -1, null, null);
            while (next != null && target.isRoutable() && !this.processingRace) {
                nodesRoutedTo.add(next);
                this.blockingUpdatePingRecord(target, next);
                this.betweenPingSleep(target);
                next = this.node.peers.closerPeer(target, nodesRoutedTo, randomTarget, true, false, -1, null, null);
            }
        }
        List<PeerNode> list2 = this.workQueue;
        synchronized (list2) {
            boolean bl = didAnything = this.processing != null;
            if (this.processingRace) {
                this.processingRace = false;
                PeerNode target = this.processing;
                this.processing = null;
                this.forgetPingRecords(target);
            }
            this.processing = null;
        }
        --this.pingVolleysToGo;
        if (this.startupChecks > 0) {
            --this.startupChecks;
        } else if (this.pingVolleysToGo <= 0) {
            this.doNetworkIDReckoning(didAnything);
            this.pingVolleysToGo = 5;
        }
        list2 = this.workQueue;
        synchronized (list2) {
            if (this.workQueue.isEmpty()) {
                this.checkAllPeers();
                if (this.startupChecks > 0) {
                    this.reschedule(2000L);
                } else {
                    this.reschedule(120000L);
                }
            } else {
                this.reschedule(2000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void blockingUpdatePingRecord(PeerNode target, PeerNode next) {
        int suppliedCounter;
        boolean success;
        short dawn;
        short htl;
        PingRecord record;
        block16: {
            long uid = this.node.random.nextLong();
            long secret = this.node.random.nextLong();
            record = this.getPingRecord(target, next);
            htl = record.getNextHtl();
            dawn = record.getNextDawnHtl(htl);
            success = false;
            suppliedCounter = 1;
            ++this.totalSecretPingAttempts;
            try {
                try {
                    target.sendSync(DMT.createFNPStoreSecret(uid, secret), null);
                    MessageFilter mfAccepted = MessageFilter.create().setSource(target).setField("uid", uid).setTimeout(5000).setType(DMT.FNPAccepted);
                    Message msg = this.node.usm.waitFor(mfAccepted, null);
                    if (msg == null || msg.getSpec() != DMT.FNPAccepted) {
                        Logger.error(this, "peer is unresponsive to StoreSecret " + target);
                        Object var19_14 = null;
                        if (success) {
                            ++this.secretPingSuccesses;
                            record.success(suppliedCounter, htl, dawn);
                            return;
                        }
                        record.failure(suppliedCounter, htl, dawn);
                        return;
                    }
                    next.sendSync(DMT.createFNPSecretPing(uid, target.getLocation(), htl, dawn, 0, target.identity), null);
                    MessageFilter mfPong = MessageFilter.create().setSource(next).setField("uid", uid).setTimeout(20000).setType(DMT.FNPSecretPong);
                    MessageFilter mfRejectLoop = MessageFilter.create().setSource(next).setField("uid", uid).setTimeout(20000).setType(DMT.FNPRejectedLoop);
                    msg = this.node.usm.waitFor(mfPong.or(mfRejectLoop), null);
                    if (msg == null) {
                        Logger.error(this, "fatal timeout in waiting for secretpong from " + next);
                        break block16;
                    }
                    if (msg.getSpec() == DMT.FNPSecretPong) {
                        suppliedCounter = msg.getInt("counter");
                        long suppliedSecret = msg.getLong("secret");
                        if (this.logMINOR) {
                            Logger.minor(this, "got secret, counter=" + suppliedCounter);
                        }
                        success = secret == suppliedSecret;
                        break block16;
                    }
                    if (msg.getSpec() == DMT.FNPRejectedLoop) {
                        Logger.normal(this, "top level rejectLoop (no route found): " + next + " -> " + target);
                    }
                }
                catch (NotConnectedException e) {
                    Logger.normal(this, "one party left during connectivity test: " + e);
                    Object var19_16 = null;
                    if (success) {
                        ++this.secretPingSuccesses;
                        record.success(suppliedCounter, htl, dawn);
                        return;
                    }
                    record.failure(suppliedCounter, htl, dawn);
                    return;
                }
                catch (DisconnectedException e) {
                    Logger.normal(this, "one party left during connectivity test: " + e);
                    Object var19_17 = null;
                    if (success) {
                        ++this.secretPingSuccesses;
                        record.success(suppliedCounter, htl, dawn);
                        return;
                    }
                    record.failure(suppliedCounter, htl, dawn);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var19_18 = null;
                if (success) {
                    ++this.secretPingSuccesses;
                    record.success(suppliedCounter, htl, dawn);
                    throw throwable;
                }
                record.failure(suppliedCounter, htl, dawn);
                throw throwable;
            }
        }
        Object var19_15 = null;
        if (success) {
            ++this.secretPingSuccesses;
            record.success(suppliedCounter, htl, dawn);
            return;
        }
        record.failure(suppliedCounter, htl, dawn);
    }

    private void betweenPingSleep(PeerNode target) {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void addWorkToLockedQueue(PeerNode p) {
        if (p != null && !this.workQueue.contains(p)) {
            this.workQueue.add(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAllPeers() {
        HashSet<PeerNode> set = this.getAllConnectedPeers();
        List<PeerNode> list = this.workQueue;
        synchronized (list) {
            for (PeerNode p : set) {
                this.addWorkToLockedQueue(p);
            }
        }
    }

    private HashSet<PeerNode> getAllConnectedPeers() {
        double randomTarget = this.node.random.nextDouble();
        HashSet<PeerNode> connectedPeers = new HashSet<PeerNode>();
        PeerNode next = this.node.peers.closerPeer(null, connectedPeers, randomTarget, true, false, -1, null, null);
        while (next != null) {
            connectedPeers.add(next);
            next = this.node.peers.closerPeer(null, connectedPeers, randomTarget, true, false, -1, null, null);
        }
        return connectedPeers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNetworkIDReckoning(boolean anyPingChanges) {
        ArrayList<PeerNetworkGroup> newNetworkGroups = new ArrayList<PeerNetworkGroup>();
        HashSet<PeerNode> all = this.getAllConnectedPeers();
        HashSet todo = (HashSet)all.clone();
        Object object = this.transitionLock;
        synchronized (object) {
            this.inTransition = true;
        }
        if (this.logMINOR) {
            Logger.minor(this, "doNetworkIDReckoning for " + all.size() + " peers");
        }
        if (todo.isEmpty()) {
            return;
        }
        while (!todo.isEmpty()) {
            ArrayList<PeerNode> members;
            PeerNode mostConnected = this.findMostConnectedPeerInSet(todo, all);
            PeerNetworkGroup newGroup = new PeerNetworkGroup();
            newNetworkGroups.add(newGroup);
            todo.remove(mostConnected);
            if (todo.isEmpty()) {
                members = new ArrayList<PeerNode>();
                members.add(mostConnected);
            } else {
                members = this.xferConnectedPeerSetFor(mostConnected, todo);
            }
            newGroup.setMembers(members);
        }
        Collections.sort(newNetworkGroups, this);
        HashSet<Integer> takenNetworkIds = new HashSet<Integer>();
        for (PeerNetworkGroup newGroup : newNetworkGroups) {
            newGroup.setForbiddenIds(takenNetworkIds);
            int id = newGroup.getConsensus(true);
            if (id == 0) {
                id = this.node.random.nextInt();
            }
            newGroup.assignNetworkId(id);
            takenNetworkIds.add(id);
            if (!this.logMINOR) continue;
            Logger.minor(this, "net " + id + " has " + newGroup.members.size() + " peers");
        }
        Object object2 = this.transitionLock;
        synchronized (object2) {
            PeerNetworkGroup ourgroup = (PeerNetworkGroup)newNetworkGroups.get(0);
            this.ourNetworkId = ourgroup.networkid;
            Logger.error(this, "I am in network: " + this.ourNetworkId + ", and have divided my " + all.size() + " peers into " + newNetworkGroups.size() + " network groups");
            Logger.error(this, "largestGroup=" + ourgroup.members.size());
            Logger.error(this, "bestFirst=" + this.cheat_stats_general_bestOther.currentValue());
            Logger.error(this, "bestGeneralFactor=" + this.cheat_stats_findBestSetwisePingAverage_best_general.currentValue());
            this.networkGroups = newNetworkGroups;
            this.inTransition = false;
        }
    }

    private PeerNode findMostConnectedPeerInSet(HashSet<PeerNode> set, HashSet<PeerNode> possibleTargets) {
        double max = -1.0;
        PeerNode theMan = null;
        for (PeerNode p : set) {
            double value = this.getPeerNodeConnectedness(p, possibleTargets);
            if (!(value > max)) continue;
            max = value;
            theMan = p;
        }
        return theMan;
    }

    private double getPeerNodeConnectedness(PeerNode p, HashSet<PeerNode> possibleTargets) {
        double retval = 1.0;
        double totalLossFactor = 1.0 / (double)possibleTargets.size();
        for (PeerNode target : possibleTargets) {
            PingRecord record = this.getPingRecord(p, target);
            double pingAverage = record.average.currentValue();
            if (pingAverage < totalLossFactor) {
                retval *= totalLossFactor;
                continue;
            }
            retval *= pingAverage;
        }
        return retval;
    }

    private List<PeerNode> xferConnectedPeerSetFor(PeerNode thisPeer, HashSet<PeerNode> fromOthers) {
        ArrayList<PeerNode> currentGroup = new ArrayList<PeerNode>();
        currentGroup.add(thisPeer);
        HashSet<PeerNode> remainder = fromOthers;
        double goodConnectivity = this.getSetwisePingAverage(thisPeer, fromOthers);
        if (goodConnectivity < 0.2) {
            Logger.normal(this, "falling open with " + fromOthers.size() + " peers left");
            currentGroup.addAll(fromOthers);
            fromOthers.clear();
            this.cheat_stats_general_bestOther.report(0.0);
            return currentGroup;
        }
        this.cheat_stats_general_bestOther.report(goodConnectivity);
        goodConnectivity *= 0.8;
        while (!remainder.isEmpty()) {
            PeerNode bestOther = this.findBestSetwisePingAverage(remainder, currentGroup);
            if (!(this.cheat_findBestSetwisePingAverage_best >= goodConnectivity)) break;
            remainder.remove(bestOther);
            currentGroup.add(bestOther);
        }
        if (currentGroup.size() == 1 && fromOthers.size() == 1) {
            double average2;
            PeerNode onlyLeft = fromOthers.iterator().next();
            double average1 = this.getPingRecord((PeerNode)onlyLeft, (PeerNode)thisPeer).average.currentValue();
            if (0.5 * average1 + 0.5 * (average2 = this.getPingRecord((PeerNode)thisPeer, (PeerNode)onlyLeft).average.currentValue()) > 0.25) {
                Logger.normal(this, "combine the dregs: " + thisPeer + "/" + fromOthers);
                fromOthers.remove(onlyLeft);
                currentGroup.add(onlyLeft);
            }
        }
        return currentGroup;
    }

    private double getSetwisePingAverage(PeerNode thisPeer, Collection<PeerNode> toThesePeers) {
        Iterator<PeerNode> i = toThesePeers.iterator();
        double accum = 0.0;
        if (!i.hasNext()) {
            Logger.error(this, "getSetwisePingAverage to nobody?");
            return 1.0;
        }
        while (i.hasNext()) {
            PeerNode other = i.next();
            accum += this.getPingRecord((PeerNode)thisPeer, (PeerNode)other).average.currentValue();
        }
        return accum / (double)toThesePeers.size();
    }

    private PeerNode findBestSetwisePingAverage(HashSet<PeerNode> ofThese, Collection<PeerNode> towardsThese) {
        PeerNode retval = null;
        double best = -1.0;
        Iterator<PeerNode> i = ofThese.iterator();
        if (!i.hasNext()) {
            Logger.error(this, "findBestSetwisePingAverage to nobody?");
            return null;
        }
        while (i.hasNext()) {
            PeerNode thisOne = i.next();
            double average = this.getSetwisePingAverage(thisOne, towardsThese);
            if (!(average > best)) continue;
            retval = thisOne;
            best = average;
        }
        this.cheat_findBestSetwisePingAverage_best = best;
        this.cheat_stats_findBestSetwisePingAverage_best_general.report(best);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPeerNodeChangedNetworkID(PeerNode p) {
        Object object = this.transitionLock;
        synchronized (object) {
            if (this.inTransition) {
                return;
            }
            boolean haveFoundIt = false;
            PeerNetworkGroup mine = p.networkGroup;
            HashSet<Integer> nowTakenIds = new HashSet<Integer>();
            for (PeerNetworkGroup png : this.networkGroups) {
                int newId;
                int oldId;
                if (png.equals(mine)) {
                    haveFoundIt = true;
                    oldId = png.networkid;
                    newId = png.getConsensus(true);
                    if (oldId == newId) {
                        return;
                    }
                    if (png.recentlyAssigned()) {
                        return;
                    }
                    png.assignNetworkId(newId);
                    nowTakenIds.add(newId);
                    continue;
                }
                if (haveFoundIt) {
                    png.setForbiddenIds(nowTakenIds);
                    newId = oldId = png.networkid;
                    if (nowTakenIds.contains(oldId)) {
                        newId = png.getConsensus(true);
                        png.assignNetworkId(newId);
                    }
                    nowTakenIds.add(newId);
                    continue;
                }
                nowTakenIds.add(png.networkid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inSeparateNetworks(PeerNode a, PeerNode b) {
        if (a == null || b == null || a.assignedNetworkID == 0 || b.assignedNetworkID == 0) {
            return false;
        }
        Object object = this.transitionLock;
        synchronized (object) {
            if (this.inTransition) {
                return false;
            }
            return !a.networkGroup.equals(b.networkGroup);
        }
    }

    @Override
    public int compare(PeerNetworkGroup a, PeerNetworkGroup b) {
        return b.members.size() - a.members.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PeerNetworkGroup {
        List<PeerNode> members;
        int networkid = 0;
        HashSet<Integer> forbiddenIds;
        long lastAssign;
        boolean unanimous;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getConsensus(boolean probabilistic) {
            HashMap<Integer, Integer> h = new HashMap<Integer, Integer>();
            Integer lastId = this.networkid;
            PeerNetworkGroup peerNetworkGroup = this;
            synchronized (peerNetworkGroup) {
                int totalWitnesses = 0;
                int maxId = this.networkid;
                int maxCount = 0;
                for (PeerNode p : this.members) {
                    Integer id = p.providedNetworkID;
                    if (this.forbiddenIds.contains(id) || id == 0) continue;
                    ++totalWitnesses;
                    int count = 1;
                    Integer prev = (Integer)h.get(id);
                    if (prev != null) {
                        count = prev + 1;
                    }
                    h.put(id, count);
                    if (count > maxCount) {
                        maxCount = count;
                        maxId = id;
                    }
                    lastId = id;
                }
                boolean bl = this.unanimous = h.size() == 1;
                if (h.size() <= 1) {
                    return lastId;
                }
                if (!probabilistic) {
                    return maxId;
                }
                double incrementPerWitness = 1.0 / (double)totalWitnesses;
                double winningTarget = ((NetworkIDManager)NetworkIDManager.this).node.random.nextDouble();
                if (NetworkIDManager.this.logMINOR) {
                    Logger.minor(this, "winningTarget=" + winningTarget + ", totalWitnesses=" + totalWitnesses + ", inc=" + incrementPerWitness);
                }
                double sum = 0.0;
                for (Map.Entry e : h.entrySet()) {
                    int id = (Integer)e.getKey();
                    int count = (Integer)e.getValue();
                    sum += (double)count * incrementPerWitness;
                    if (NetworkIDManager.this.logMINOR) {
                        Logger.minor(this, "network " + id + " " + count + " peers, " + sum);
                    }
                    if (!(sum >= winningTarget)) continue;
                    return id;
                }
                Logger.error(this, "logic error; winningTarget=" + winningTarget + ", sum@end=" + sum + ", count=" + h.size());
                return maxId;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void assignNetworkId(int id) {
            PeerNetworkGroup peerNetworkGroup = this;
            synchronized (peerNetworkGroup) {
                this.lastAssign = System.currentTimeMillis();
                this.networkid = id;
                for (PeerNode p : this.members) {
                    p.assignedNetworkID = id;
                    p.networkGroup = this;
                    try {
                        p.sendFNPNetworkID(NetworkIDManager.this.ctr);
                    }
                    catch (NotConnectedException e) {
                        Logger.normal(this, "disconnected on network reassignment");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setForbiddenIds(HashSet<Integer> a) {
            PeerNetworkGroup peerNetworkGroup = this;
            synchronized (peerNetworkGroup) {
                this.forbiddenIds = new HashSet<Integer>(a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setMembers(List<PeerNode> a) {
            PeerNetworkGroup peerNetworkGroup = this;
            synchronized (peerNetworkGroup) {
                this.members = a;
            }
        }

        boolean recentlyAssigned() {
            return System.currentTimeMillis() - this.lastAssign < 2000L;
        }
    }

    private final class PingRecord {
        PeerNode target;
        PeerNode via;
        long lastSuccess = -1L;
        long lastTry = -1L;
        int shortestSuccess = Integer.MAX_VALUE;
        RunningAverage average = new BootstrappingDecayingRunningAverage(0.0, 0.0, 1.0, 200, null);
        RunningAverage sHtl = new BootstrappingDecayingRunningAverage(NetworkIDManager.access$300(NetworkIDManager.this), 0.0, NetworkIDManager.access$300(NetworkIDManager.this), 200, null);
        RunningAverage fHtl = new BootstrappingDecayingRunningAverage(NetworkIDManager.access$300(NetworkIDManager.this), 0.0, NetworkIDManager.access$300(NetworkIDManager.this), 200, null);
        RunningAverage sDawn = new BootstrappingDecayingRunningAverage(0.0, 0.0, NetworkIDManager.access$300(NetworkIDManager.this), 200, null);
        RunningAverage fDawn = new BootstrappingDecayingRunningAverage(0.0, 0.0, NetworkIDManager.access$300(NetworkIDManager.this), 200, null);

        private PingRecord() {
        }

        public String toString() {
            return "percent=" + this.average.currentValue();
        }

        public void success(int counter, short htl, short dawn) {
            long now;
            this.lastTry = now = System.currentTimeMillis();
            this.lastSuccess = now;
            this.average.report(1.0);
            if (counter < this.shortestSuccess) {
                this.shortestSuccess = counter;
            }
            dawn = (short)(htl - dawn);
            this.sHtl.report(htl);
            this.sDawn.report(dawn);
        }

        public void failure(int counter, short htl, short dawn) {
            long now;
            this.lastTry = now = System.currentTimeMillis();
            this.average.report(0.0);
            dawn = (short)(htl - dawn);
            this.fHtl.report(htl);
            this.fDawn.report(dawn);
        }

        public short getNextHtl() {
            if (this.sHtl.countReports() < 20L) {
                return NetworkIDManager.this.MAX_HTL;
            }
            if (this.average.currentValue() > 0.8) {
                short htl = (short)(this.sHtl.currentValue() - 0.5);
                if (htl < 3) {
                    htl = 3;
                }
                return (short)htl;
            }
            short htl = (short)(this.sHtl.currentValue() + 0.5);
            if (htl > NetworkIDManager.this.MAX_HTL) {
                htl = NetworkIDManager.this.MAX_HTL;
            }
            return htl;
        }

        public short getNextDawnHtl(short htl) {
            short max = (short)(htl / 2 - 1);
            short diff = this.fDawn.countReports() < 20L ? (short)2 : (this.sDawn.countReports() < 20L ? (short)(this.fDawn.currentValue() + 0.5) : (short)(0.25 * this.fDawn.currentValue() + 0.75 * this.sDawn.currentValue()));
            if (diff > max) {
                diff = max;
            }
            return (short)(htl - diff);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.via.equals(((PingRecord)obj).via);
        }

        public int hashCode() {
            return this.via.hashCode();
        }
    }

    private static final class StoredSecret {
        PeerNode peer;
        long uid;
        long secret;

        StoredSecret(PeerNode peer, long uid, long secret) {
            this.peer = peer;
            this.uid = uid;
            this.secret = secret;
        }

        public String toString() {
            return "Secret(" + this.uid + "/" + this.secret + ")";
        }

        Message getSecretPong(int counter) {
            return DMT.createFNPSecretPong(this.uid, counter, this.secret);
        }
    }
}

