/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.AsyncMessageCallback;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.Message;
import freenet.node.PeerNode;
import freenet.support.Logger;

public class MessageItem {
    final Message msg;
    final byte[] buf;
    final AsyncMessageCallback[] cb;
    final long submitted;
    final boolean formatted;
    final ByteCounter ctrCallback;
    private final short priority;

    public MessageItem(Message msg2, AsyncMessageCallback[] cb2, ByteCounter ctr, PeerNode pn) {
        this.msg = msg2;
        this.cb = cb2;
        this.formatted = false;
        this.ctrCallback = ctr;
        this.submitted = System.currentTimeMillis();
        this.priority = msg2.getSpec().getPriority();
        this.buf = this.msg.encodeToPacket(pn);
    }

    public MessageItem(byte[] data, AsyncMessageCallback[] cb2, boolean formatted, ByteCounter ctr, short priority) {
        this.cb = cb2;
        this.msg = null;
        this.buf = data;
        this.formatted = formatted;
        if (formatted && this.buf == null) {
            throw new NullPointerException();
        }
        this.ctrCallback = ctr;
        this.submitted = System.currentTimeMillis();
        this.priority = priority;
    }

    public byte[] getData() {
        return this.buf;
    }

    public int getLength() {
        return this.buf.length;
    }

    public void onSent(int length) {
        if (this.ctrCallback != null) {
            try {
                this.ctrCallback.sentBytes(length);
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t + " reporting " + length + " sent bytes on " + this, t);
            }
        }
        if (this.cb != null) {
            for (int i = 0; i < this.cb.length; ++i) {
                try {
                    this.cb[i].sent();
                    continue;
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught " + t + " calling sent() on " + this.cb[i] + " for " + this, t);
                }
            }
        }
    }

    public short getPriority() {
        return this.priority;
    }

    public String toString() {
        return super.toString() + ":formatted=" + this.formatted + ",msg=" + this.msg;
    }

    public void onDisconnect() {
        if (this.cb != null) {
            for (int i = 0; i < this.cb.length; ++i) {
                try {
                    this.cb[i].disconnected();
                    continue;
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught " + t + " calling sent() on " + this.cb[i] + " for " + this, t);
                }
            }
        }
    }
}

