/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.config.EnumerableOptionCallback;
import freenet.config.InvalidConfigValueException;
import freenet.config.NodeNeedRestartException;
import freenet.config.OptionFormatException;
import freenet.config.SubConfig;
import freenet.support.Executor;
import freenet.support.FileLoggerHook;
import freenet.support.Logger;
import freenet.support.LoggerHook;
import freenet.support.LoggerHookChain;
import freenet.support.api.BooleanCallback;
import freenet.support.api.IntCallback;
import freenet.support.api.LongCallback;
import freenet.support.api.StringCallback;
import java.io.File;
import java.io.IOException;

public class LoggingConfigHandler {
    protected static final String LOG_PREFIX = "freenet";
    private final SubConfig config;
    private FileLoggerHook fileLoggerHook;
    private File logDir;
    private long maxZippedLogsSize;
    private String logRotateInterval;
    private long maxCachedLogBytes;
    private int maxCachedLogLines;
    private final Executor executor;
    private final Object enableLoggerLock = new Object();

    public LoggingConfigHandler(SubConfig loggingConfig, Executor executor) throws InvalidConfigValueException {
        this.config = loggingConfig;
        this.executor = executor;
        loggingConfig.register("enabled", true, 1, true, false, "LogConfigHandler.enabled", "LogConfigHandler.enabledLong", new BooleanCallback(){

            public Boolean get() {
                return LoggingConfigHandler.this.fileLoggerHook != null;
            }

            public void set(Boolean val) throws InvalidConfigValueException {
                if (val == (LoggingConfigHandler.this.fileLoggerHook != null)) {
                    return;
                }
                if (!val.booleanValue()) {
                    LoggingConfigHandler.this.disableLogger();
                } else {
                    LoggingConfigHandler.this.enableLogger();
                }
            }
        });
        boolean loggingEnabled = loggingConfig.getBoolean("enabled");
        loggingConfig.register("dirname", "logs", 2, true, false, "LogConfigHandler.dirName", "LogConfigHandler.dirNameLong", new StringCallback(){

            public String get() {
                return LoggingConfigHandler.this.logDir.getPath();
            }

            public void set(String val) throws InvalidConfigValueException {
                File f = new File(val);
                if (f.equals(LoggingConfigHandler.this.logDir)) {
                    return;
                }
                LoggingConfigHandler.this.preSetLogDir(f);
                if (LoggingConfigHandler.this.fileLoggerHook == null) {
                    LoggingConfigHandler.this.logDir = f;
                } else {
                    LoggingConfigHandler.this.fileLoggerHook.switchBaseFilename(f.getPath() + File.separator + LoggingConfigHandler.LOG_PREFIX);
                    LoggingConfigHandler.this.logDir = f;
                    new Deleter(LoggingConfigHandler.this.logDir).start();
                }
            }
        });
        this.logDir = new File(this.config.getString("dirname"));
        if (loggingEnabled) {
            this.preSetLogDir(this.logDir);
        }
        this.config.register("maxZippedLogsSize", "128M", 3, true, true, "LogConfigHandler.maxZippedLogsSize", "LogConfigHandler.maxZippedLogsSizeLong", new LongCallback(){

            public Long get() {
                return LoggingConfigHandler.this.maxZippedLogsSize;
            }

            public void set(Long val) throws InvalidConfigValueException {
                if (val < 0L) {
                    val = 0L;
                }
                LoggingConfigHandler.this.maxZippedLogsSize = val;
                if (LoggingConfigHandler.this.fileLoggerHook != null) {
                    LoggingConfigHandler.this.fileLoggerHook.setMaxOldLogsSize(val);
                }
            }
        }, true);
        this.maxZippedLogsSize = this.config.getLong("maxZippedLogsSize");
        this.config.register("priority", "normal", 4, false, false, "LogConfigHandler.minLoggingPriority", "LogConfigHandler.minLoggingPriorityLong", new PriorityCallback());
        this.config.register("priorityDetail", "", 5, true, false, "LogConfigHandler.detaildPriorityThreshold", "LogConfigHandler.detaildPriorityThresholdLong", new StringCallback(){

            public String get() {
                LoggerHookChain chain = Logger.getChain();
                return chain.getDetailedThresholds();
            }

            public void set(String val) throws InvalidConfigValueException {
                LoggerHookChain chain = Logger.getChain();
                try {
                    chain.setDetailedThresholds(val);
                }
                catch (LoggerHook.InvalidThresholdException e) {
                    throw new InvalidConfigValueException(e.getMessage());
                }
            }
        });
        this.config.register("interval", "10MINUTE", 5, true, false, "LogConfigHandler.rotationInterval", "LogConfigHandler.rotationIntervalLong", new StringCallback(){

            public String get() {
                return LoggingConfigHandler.this.logRotateInterval;
            }

            public void set(String val) throws InvalidConfigValueException {
                if (val.equals(LoggingConfigHandler.this.logRotateInterval)) {
                    return;
                }
                if (LoggingConfigHandler.this.fileLoggerHook != null) {
                    try {
                        LoggingConfigHandler.this.fileLoggerHook.setInterval(val);
                    }
                    catch (FileLoggerHook.IntervalParseException e) {
                        throw new OptionFormatException(e.getMessage());
                    }
                }
                LoggingConfigHandler.this.logRotateInterval = val;
            }
        });
        this.logRotateInterval = this.config.getString("interval");
        this.config.register("maxCachedBytes", "10M", 6, true, false, "LogConfigHandler.maxCachedBytes", "LogConfigHandler.maxCachedBytesLong", new LongCallback(){

            public Long get() {
                return LoggingConfigHandler.this.maxCachedLogBytes;
            }

            public void set(Long val) throws InvalidConfigValueException {
                if (val < 0L) {
                    val = 0L;
                }
                if (val == LoggingConfigHandler.this.maxCachedLogBytes) {
                    return;
                }
                LoggingConfigHandler.this.maxCachedLogBytes = val;
                if (LoggingConfigHandler.this.fileLoggerHook != null) {
                    LoggingConfigHandler.this.fileLoggerHook.setMaxListBytes(val);
                }
            }
        }, true);
        this.maxCachedLogBytes = this.config.getLong("maxCachedBytes");
        this.config.register("maxCachedLines", "100k", 7, true, false, "LogConfigHandler.maxCachedLines", "LogConfigHandler.maxCachedLinesLong", new IntCallback(){

            public Integer get() {
                return LoggingConfigHandler.this.maxCachedLogLines;
            }

            public void set(Integer val) throws InvalidConfigValueException {
                if (val < 0) {
                    val = 0;
                }
                if (val == LoggingConfigHandler.this.maxCachedLogLines) {
                    return;
                }
                LoggingConfigHandler.this.maxCachedLogLines = val;
                if (LoggingConfigHandler.this.fileLoggerHook != null) {
                    LoggingConfigHandler.this.fileLoggerHook.setMaxListLength(val);
                }
            }
        }, false);
        this.maxCachedLogLines = this.config.getInt("maxCachedLines");
        if (loggingEnabled) {
            this.enableLogger();
        }
        this.config.finishedInitialization();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableLogger() {
        try {
            this.preSetLogDir(this.logDir);
        }
        catch (InvalidConfigValueException e3) {
            System.err.println("Cannot set log dir: " + this.logDir + ": " + e3);
            e3.printStackTrace();
        }
        Object object = this.enableLoggerLock;
        synchronized (object) {
            FileLoggerHook hook;
            if (this.fileLoggerHook != null) {
                return;
            }
            Logger.setupChain();
            try {
                this.config.forceUpdate("priority");
                this.config.forceUpdate("priorityDetail");
            }
            catch (InvalidConfigValueException e2) {
                System.err.println("Invalid config value for logger.priority in config file: " + this.config.getString("priority"));
            }
            catch (NodeNeedRestartException e) {
                System.err.println("impossible NodeNeedRestartException for logger.priority in config file: " + this.config.getString("priority"));
            }
            try {
                hook = new FileLoggerHook(true, new File(this.logDir, LOG_PREFIX).getAbsolutePath(), "d (c, t, p): m", "MMM dd, yyyy HH:mm:ss:SSS", 2, false, true, this.maxZippedLogsSize);
            }
            catch (IOException e) {
                System.err.println("CANNOT START LOGGER: " + e.getMessage());
                return;
            }
            try {
                hook.setInterval(this.logRotateInterval);
            }
            catch (FileLoggerHook.IntervalParseException e) {
                System.err.println("INVALID LOGGING INTERVAL: " + e.getMessage());
                try {
                    hook.setInterval("5MINUTE");
                }
                catch (FileLoggerHook.IntervalParseException e1) {
                    System.err.println("Impossible: " + e1.getMessage());
                }
            }
            hook.setMaxListBytes(this.maxCachedLogBytes);
            hook.setMaxListLength(this.maxCachedLogLines);
            this.fileLoggerHook = hook;
            Logger.globalAddHook(hook);
            hook.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disableLogger() {
        Object object = this.enableLoggerLock;
        synchronized (object) {
            if (this.fileLoggerHook == null) {
                return;
            }
            FileLoggerHook hook = this.fileLoggerHook;
            Logger.globalRemoveHook(hook);
            hook.close();
            this.fileLoggerHook = null;
            Logger.destroyChainIfEmpty();
        }
    }

    protected void preSetLogDir(File f) throws InvalidConfigValueException {
        boolean exists = f.exists();
        if (exists && !f.isDirectory()) {
            throw new InvalidConfigValueException("Cannot overwrite a file with a log directory");
        }
        if (!exists) {
            f.mkdir();
            exists = f.exists();
            if (!exists || !f.isDirectory()) {
                throw new InvalidConfigValueException("Cannot create log directory");
            }
        }
    }

    public FileLoggerHook getFileLoggerHook() {
        return this.fileLoggerHook;
    }

    public void forceEnableLogging() {
        this.enableLogger();
    }

    public long getMaxZippedLogFiles() {
        return this.maxZippedLogsSize;
    }

    public void setMaxZippedLogFiles(String maxSizeAsString) throws InvalidConfigValueException, NodeNeedRestartException {
        this.config.set("maxZippedLogsSize", maxSizeAsString);
    }

    class Deleter
    implements Runnable {
        File logDir;

        public Deleter(File logDir) {
            this.logDir = logDir;
        }

        void start() {
            LoggingConfigHandler.this.executor.execute(this, "Old log directory " + this.logDir + " deleter");
        }

        public void run() {
            Logger.OSThread.logPID(this);
            LoggingConfigHandler.this.fileLoggerHook.waitForSwitch();
            this.delete(this.logDir);
        }

        private boolean delete(File dir) {
            boolean failed = false;
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                String s = f.getName();
                if (s.startsWith("freenet-") && s.indexOf(".log") != -1) {
                    if (f.isFile()) {
                        if (f.delete()) continue;
                        failed = true;
                        continue;
                    }
                    if (!f.isDirectory() || !this.delete(f)) continue;
                    failed = true;
                    continue;
                }
                failed = true;
            }
            if (!failed) {
                failed = !dir.delete();
            }
            return failed;
        }
    }

    private static class PriorityCallback
    extends StringCallback
    implements EnumerableOptionCallback {
        private final String[] possibleValues = new String[]{"ERROR", "NORMAL", "MINOR", "DEBUG"};

        private PriorityCallback() {
        }

        public String get() {
            LoggerHookChain chain = Logger.getChain();
            return LoggerHook.priorityOf(chain.getThreshold());
        }

        public void set(String val) throws InvalidConfigValueException {
            LoggerHookChain chain = Logger.getChain();
            try {
                chain.setThreshold(val);
            }
            catch (LoggerHook.InvalidThresholdException e) {
                throw new OptionFormatException(e.getMessage());
            }
        }

        public String[] getPossibleValues() {
            return this.possibleValues;
        }
    }
}

