/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.crypt.RandomSource;
import freenet.crypt.SHA256;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.node.Location;
import freenet.node.Node;
import freenet.node.PeerManager;
import freenet.node.PeerNode;
import freenet.node.SendMessageOnErrorCallback;
import freenet.support.Fields;
import freenet.support.Logger;
import freenet.support.ShortBuffer;
import freenet.support.TimeSortedHashtable;
import freenet.support.io.Closer;
import freenet.support.math.BootstrappingDecayingRunningAverage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.MessageDigest;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class LocationManager
implements ByteCounter {
    static final int TIMEOUT = 60000;
    static final int SWAP_MAX_HTL = 10;
    static final int SWAP_RESET = 16000;
    static final int SEND_SWAP_INTERVAL = 8000;
    final BootstrappingDecayingRunningAverage averageSwapTime;
    static final int MIN_SWAP_TIME = 900;
    static final int MAX_SWAP_TIME = 60000;
    private static final long STARTUP_DELAY = 60000L;
    private static boolean logMINOR;
    final RandomSource r;
    final SwapRequestSender sender;
    final Node node;
    long timeLastSuccessfullySwapped;
    private double loc;
    private long timeLocSet;
    private double locChangeSession = 0.0;
    int numberOfRemotePeerLocationsSeenInSwaps = 0;
    private boolean locked;
    public static int swaps;
    public static int noSwaps;
    public static int startedSwaps;
    public static int swapsRejectedAlreadyLocked;
    public static int swapsRejectedNowhereToGo;
    public static int swapsRejectedRateLimit;
    public static int swapsRejectedRecognizedID;
    long lockedTime;
    static final double SWAP_ACCEPT_PROB = 0.25;
    final Hashtable<Long, RecentlyForwardedItem> recentlyForwardedIDs;
    private final LinkedList<Message> incomingMessageQueue = new LinkedList();
    static final int MAX_INCOMING_QUEUE_LENGTH = 10;
    static final long MAX_TIME_ON_INCOMING_QUEUE = 30000L;
    private static final long MAX_AGE = 604800000L;
    private final TimeSortedHashtable<Double> knownLocs = new TimeSortedHashtable();

    public LocationManager(RandomSource r, Node node) {
        this.loc = r.nextDouble();
        this.sender = new SwapRequestSender();
        this.r = r;
        this.node = node;
        this.recentlyForwardedIDs = new Hashtable();
        this.averageSwapTime = new BootstrappingDecayingRunningAverage(8000.0, 0.0, 2.147483647E9, 20, null);
        this.timeLocSet = System.currentTimeMillis();
        logMINOR = Logger.shouldLog(4, this);
    }

    public synchronized double getLocation() {
        return this.loc;
    }

    public synchronized void setLocation(double l) {
        if (l < 0.0 || l > 1.0) {
            Logger.error(this, "Setting invalid location: " + l, new Exception("error"));
            return;
        }
        this.loc = l;
        this.timeLocSet = System.currentTimeMillis();
    }

    public synchronized void updateLocationChangeSession(double newLoc) {
        double oldLoc = this.loc;
        double diff = Location.change(oldLoc, newLoc);
        if (logMINOR) {
            Logger.minor(this, "updateLocationChangeSession: oldLoc: " + oldLoc + " -> newLoc: " + newLoc + " moved: " + diff);
        }
        this.locChangeSession += diff;
    }

    public void startSender() {
        if (this.node.enableSwapping) {
            this.node.getTicker().queueTimedJob(this.sender, 60000L);
        }
    }

    private void startSwapRequest() {
        this.node.executor.execute(new OutgoingSwapRequestHandler(), "Outgoing swap request handler for port " + this.node.getDarknetPortNumber());
    }

    public boolean swappingDisabled() {
        return this.node.isOpennetEnabled();
    }

    public int getSendSwapInterval() {
        int interval = (int)this.averageSwapTime.currentValue();
        if (interval < 900) {
            interval = 900;
        }
        if (interval > 60000) {
            interval = 60000;
        }
        return interval;
    }

    protected void announceLocChange() {
        this.announceLocChange(false, false, false);
    }

    private void announceLocChange(boolean log, boolean randomReset, boolean fromDupLocation) {
        Message msg = DMT.createFNPLocChangeNotificationNew(this.getLocation(), this.node.peers.getPeerLocationDoubles(true));
        this.node.peers.localBroadcast(msg, false, true, this);
        if (log) {
            this.recordLocChange(randomReset, fromDupLocation);
        }
    }

    private void recordLocChange(final boolean randomReset, final boolean fromDupLocation) {
        this.node.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                File locationLog = new File(LocationManager.this.node.nodeDir, "location.log.txt");
                if (locationLog.exists() && locationLog.length() > 0xA00000L) {
                    locationLog.delete();
                }
                FileWriter fw = null;
                try {
                    try {
                        fw = new FileWriter(locationLog, true);
                        fw.write("" + DateFormat.getDateTimeInstance().format(new Date()) + " : " + LocationManager.this.getLocation() + (randomReset ? " (random reset" + (fromDupLocation ? " from duplicated location" : "") + ")" : "") + '\n');
                        fw.close();
                    }
                    catch (IOException e) {
                        Logger.error(this, "Unable to write changed location to " + locationLog + " : " + e, e);
                        Object var5_4 = null;
                        if (fw == null) return;
                        Closer.close(fw);
                        return;
                    }
                    Object var5_3 = null;
                    if (fw == null) return;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (fw == null) throw throwable;
                    Closer.close(fw);
                    throw throwable;
                }
                Closer.close(fw);
            }
        }, "Record new location");
    }

    synchronized boolean lock() {
        if (this.locked) {
            if (logMINOR) {
                Logger.minor(this, "Already locked");
            }
            return false;
        }
        if (logMINOR) {
            Logger.minor(this, "Locking on port " + this.node.getDarknetPortNumber());
        }
        this.locked = true;
        this.lockedTime = System.currentTimeMillis();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlock(boolean logSwapTime) {
        Message nextMessage;
        LocationManager locationManager = this;
        synchronized (locationManager) {
            if (!this.locked) {
                throw new IllegalStateException("Unlocking when not locked!");
            }
            long lockTime = System.currentTimeMillis() - this.lockedTime;
            if (logMINOR) {
                Logger.minor(this, "Unlocking on port " + this.node.getDarknetPortNumber());
                Logger.minor(this, "lockTime: " + lockTime);
            }
            this.averageSwapTime.report(lockTime);
            if (this.incomingMessageQueue.isEmpty()) {
                this.locked = false;
                return;
            }
            nextMessage = this.incomingMessageQueue.removeFirst();
            this.lockedTime = System.currentTimeMillis();
        }
        long oldID = nextMessage.getLong("uid");
        long newID = oldID + 1L;
        PeerNode pn = (PeerNode)nextMessage.getSource();
        this.innerHandleSwapRequest(oldID, newID, pn, nextMessage);
    }

    private boolean shouldSwap(double myLoc, double[] friendLocs, double hisLoc, double[] hisFriendLocs, long rand) {
        int i;
        int i2;
        int i3;
        if (Math.abs(hisLoc - myLoc) <= 9.9E-324) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("my: ").append(myLoc).append(", his: ").append(hisLoc).append(", myFriends: ");
        sb.append(friendLocs.length).append(", hisFriends: ").append(hisFriendLocs.length).append(" mine:\n");
        for (i3 = 0; i3 < friendLocs.length; ++i3) {
            sb.append(friendLocs[i3]);
            sb.append(' ');
        }
        sb.append("\nhis:\n");
        for (i3 = 0; i3 < hisFriendLocs.length; ++i3) {
            sb.append(hisFriendLocs[i3]);
            sb.append(' ');
        }
        if (logMINOR) {
            Logger.minor(this, sb.toString());
        }
        double A = 1.0;
        for (i2 = 0; i2 < friendLocs.length; ++i2) {
            if (Math.abs(friendLocs[i2] - myLoc) <= 9.9E-324) continue;
            A *= Location.distance(friendLocs[i2], myLoc);
        }
        for (i2 = 0; i2 < hisFriendLocs.length; ++i2) {
            if (Math.abs(hisFriendLocs[i2] - hisLoc) <= 9.9E-324) continue;
            A *= Location.distance(hisFriendLocs[i2], hisLoc);
        }
        double B = 1.0;
        for (i = 0; i < friendLocs.length; ++i) {
            if (Math.abs(friendLocs[i] - hisLoc) <= 9.9E-324) continue;
            B *= Location.distance(friendLocs[i], hisLoc);
        }
        for (i = 0; i < hisFriendLocs.length; ++i) {
            if (Math.abs(hisFriendLocs[i] - myLoc) <= 9.9E-324) continue;
            B *= Location.distance(hisFriendLocs[i], myLoc);
        }
        if (A > B) {
            return true;
        }
        double randProb = (double)(rand & Long.MAX_VALUE) / 9.223372036854776E18;
        double p = A / B;
        return randProb < p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTooOldQueuedItems() {
        while (true) {
            Message first;
            LocationManager locationManager = this;
            synchronized (locationManager) {
                if (this.incomingMessageQueue.isEmpty()) {
                    return;
                }
                first = this.incomingMessageQueue.getFirst();
                if (first.age() < 30000L) {
                    return;
                }
                this.incomingMessageQueue.removeFirst();
                if (logMINOR) {
                    Logger.minor(this, "Cancelling queued item: " + first + " - too long on queue, maybe circular waiting?");
                }
                ++swapsRejectedAlreadyLocked;
            }
            long oldID = first.getLong("uid");
            PeerNode pn = (PeerNode)first.getSource();
            Message reject = DMT.createFNPSwapRejected(oldID);
            try {
                pn.sendAsync(reject, null, this);
                continue;
            }
            catch (NotConnectedException e1) {
                if (!logMINOR) continue;
                Logger.minor(this, "Lost connection rejecting SwapRequest (locked) from " + pn);
                continue;
            }
            break;
        }
    }

    public boolean handleSwapRequest(Message m, PeerNode pn) {
        int htl;
        long oldID = m.getLong("uid");
        long newID = oldID + 1L;
        RecentlyForwardedItem item = this.recentlyForwardedIDs.get(oldID);
        if (item != null) {
            block24: {
                if (logMINOR) {
                    Logger.minor(this, "Rejecting - same ID as previous request");
                }
                Message reject = DMT.createFNPSwapRejected(oldID);
                try {
                    pn.sendAsync(reject, null, this);
                }
                catch (NotConnectedException e) {
                    if (!logMINOR) break block24;
                    Logger.minor(this, "Lost connection to " + pn + " rejecting SwapRequest");
                }
            }
            ++swapsRejectedRecognizedID;
            return true;
        }
        if (pn.shouldRejectSwapRequest()) {
            block25: {
                if (logMINOR) {
                    Logger.minor(this, "Advised to reject SwapRequest by PeerNode - rate limit");
                }
                Message reject = DMT.createFNPSwapRejected(oldID);
                try {
                    pn.sendAsync(reject, null, this);
                }
                catch (NotConnectedException e) {
                    if (!logMINOR) break block25;
                    Logger.minor(this, "Lost connection rejecting SwapRequest from " + pn);
                }
            }
            ++swapsRejectedRateLimit;
            return true;
        }
        if (logMINOR) {
            Logger.minor(this, "SwapRequest from " + pn + " - uid=" + oldID);
        }
        if ((htl = m.getInt("hopsToLive")) > 10) {
            Logger.error(this, "Bogus swap HTL: " + htl + " from " + pn + " uid=" + oldID);
            htl = 10;
        }
        if (!this.node.enableSwapping || --htl <= 0 && this.swappingDisabled()) {
            block26: {
                Message reject = DMT.createFNPSwapRejected(oldID);
                try {
                    pn.sendAsync(reject, null, this);
                }
                catch (NotConnectedException e1) {
                    if (!logMINOR) break block26;
                    Logger.minor(this, "Lost connection rejecting SwapRequest (locked) from " + pn);
                }
            }
            return true;
        }
        if (htl <= 0) {
            if (logMINOR) {
                Logger.minor(this, "Accepting?... " + oldID);
            }
            this.lockOrQueue(m, oldID, newID, pn);
            return true;
        }
        m.set("hopsToLive", htl);
        m.set("uid", newID);
        if (logMINOR) {
            Logger.minor(this, "Forwarding... " + oldID);
        }
        while (true) {
            PeerNode randomPeer;
            if ((randomPeer = this.node.peers.getRandomPeer(pn)) == null) {
                if (logMINOR) {
                    Logger.minor(this, "Late reject " + oldID);
                }
                Message reject = DMT.createFNPSwapRejected(oldID);
                try {
                    pn.sendAsync(reject, null, this);
                }
                catch (NotConnectedException e1) {
                    Logger.normal(this, "Late reject but disconnected from sender: " + pn);
                }
                ++swapsRejectedNowhereToGo;
                return true;
            }
            if (logMINOR) {
                Logger.minor(this, "Forwarding " + oldID + " to " + randomPeer);
            }
            item = this.addForwardedItem(oldID, newID, pn, randomPeer);
            item.successfullyForwarded = false;
            try {
                randomPeer.sendAsync(m, new MyCallback(DMT.createFNPSwapRejected(oldID), pn, item), this);
            }
            catch (NotConnectedException e) {
                if (!logMINOR) continue;
                Logger.minor(this, "Not connected");
                continue;
            }
            break;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lockOrQueue(Message msg, long oldID, long newID, PeerNode pn) {
        block21: {
            boolean runNow = false;
            boolean reject = false;
            if (logMINOR) {
                Logger.minor(this, "Locking on port " + this.node.getDarknetPortNumber() + " for uid " + oldID + " from " + pn);
            }
            LocationManager locationManager = this;
            synchronized (locationManager) {
                if (!this.locked) {
                    this.locked = true;
                    runNow = true;
                    this.lockedTime = System.currentTimeMillis();
                } else if (!this.node.enableSwapQueueing || this.incomingMessageQueue.size() > 10) {
                    reject = true;
                    ++swapsRejectedAlreadyLocked;
                    if (logMINOR) {
                        Logger.minor(this, "Incoming queue length too large: " + this.incomingMessageQueue.size() + " rejecting " + msg);
                    }
                } else {
                    this.incomingMessageQueue.addLast(msg);
                    if (logMINOR) {
                        Logger.minor(this, "Queued " + msg + " queue length " + this.incomingMessageQueue.size());
                    }
                }
            }
            if (reject) {
                if (logMINOR) {
                    Logger.minor(this, "Rejecting " + msg);
                }
                Message rejected = DMT.createFNPSwapRejected(oldID);
                try {
                    pn.sendAsync(rejected, null, this);
                }
                catch (NotConnectedException e1) {
                    if (logMINOR) {
                        Logger.minor(this, "Lost connection rejecting SwapRequest (locked) from " + pn);
                    }
                    break block21;
                }
            }
            if (runNow) {
                if (logMINOR) {
                    Logger.minor(this, "Running " + msg);
                }
                boolean completed = false;
                try {
                    this.innerHandleSwapRequest(oldID, newID, pn, msg);
                    completed = true;
                    Object var12_11 = null;
                    if (!completed) {
                        this.unlock(false);
                    }
                }
                catch (Throwable throwable) {
                    Object var12_12 = null;
                    if (!completed) {
                        this.unlock(false);
                    }
                    throw throwable;
                }
            }
        }
    }

    private void innerHandleSwapRequest(long oldID, long newID, PeerNode pn, Message m) {
        RecentlyForwardedItem item = this.addForwardedItem(oldID, newID, pn, null);
        IncomingSwapRequestHandler isrh = new IncomingSwapRequestHandler(m, pn, item);
        if (logMINOR) {
            Logger.minor(this, "Handling... " + oldID + " from " + pn);
        }
        this.node.executor.execute(isrh, "Incoming swap request handler for port " + this.node.getDarknetPortNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecentlyForwardedItem addForwardedItem(long uid, long oid, PeerNode pn, PeerNode randomPeer) {
        RecentlyForwardedItem item = new RecentlyForwardedItem(uid, oid, pn, randomPeer);
        Hashtable<Long, RecentlyForwardedItem> hashtable = this.recentlyForwardedIDs;
        synchronized (hashtable) {
            this.recentlyForwardedIDs.put(uid, item);
            this.recentlyForwardedIDs.put(oid, item);
        }
        return item;
    }

    public boolean handleSwapReply(Message m, PeerNode source) {
        block8: {
            long uid = m.getLong("uid");
            RecentlyForwardedItem item = this.recentlyForwardedIDs.get(uid);
            if (item == null) {
                Logger.error(this, "Unrecognized SwapReply: ID " + uid);
                return false;
            }
            if (item.requestSender == null) {
                if (logMINOR) {
                    Logger.minor(this, "SwapReply from " + source + " on chain originated locally " + uid);
                }
                return false;
            }
            if (item.routedTo == null) {
                Logger.error(this, "Got SwapReply on " + uid + " but routedTo is null!");
                return false;
            }
            if (source != item.routedTo) {
                Logger.error(this, "Unmatched swapreply " + uid + " from wrong source: From " + source + " should be " + item.routedTo + " to " + item.requestSender);
                return true;
            }
            item.lastMessageTime = System.currentTimeMillis();
            m.set("uid", item.incomingID);
            if (logMINOR) {
                Logger.minor(this, "Forwarding SwapReply " + uid + " from " + source + " to " + item.requestSender);
            }
            try {
                item.requestSender.sendAsync(m, null, this);
            }
            catch (NotConnectedException e) {
                if (!logMINOR) break block8;
                Logger.minor(this, "Lost connection forwarding SwapReply " + uid + " to " + item.requestSender);
            }
        }
        return true;
    }

    public boolean handleSwapRejected(Message m, PeerNode source) {
        block8: {
            long uid = m.getLong("uid");
            RecentlyForwardedItem item = this.recentlyForwardedIDs.get(uid);
            if (item == null) {
                return false;
            }
            if (item.requestSender == null) {
                if (logMINOR) {
                    Logger.minor(this, "Got a FNPSwapRejected without any requestSender set! we can't and won't claim it! UID=" + uid);
                }
                return false;
            }
            if (item.routedTo == null) {
                Logger.error(this, "Got SwapRejected on " + uid + " but routedTo is null!");
                return false;
            }
            if (source != item.routedTo) {
                Logger.error(this, "Unmatched swapreply " + uid + " from wrong source: From " + source + " should be " + item.routedTo + " to " + item.requestSender);
                return true;
            }
            this.removeRecentlyForwardedItem(item);
            item.lastMessageTime = System.currentTimeMillis();
            if (logMINOR) {
                Logger.minor(this, "Forwarding SwapRejected " + uid + " from " + source + " to " + item.requestSender);
            }
            m.set("uid", item.incomingID);
            try {
                item.requestSender.sendAsync(m, null, this);
            }
            catch (NotConnectedException e) {
                if (!logMINOR) break block8;
                Logger.minor(this, "Lost connection forwarding SwapRejected " + uid + " to " + item.requestSender);
            }
        }
        return true;
    }

    public boolean handleSwapCommit(Message m, PeerNode source) {
        block6: {
            long uid = m.getLong("uid");
            RecentlyForwardedItem item = this.recentlyForwardedIDs.get(uid);
            if (item == null) {
                return false;
            }
            if (item.routedTo == null) {
                return false;
            }
            if (source != item.requestSender) {
                Logger.error(this, "Unmatched swapreply " + uid + " from wrong source: From " + source + " should be " + item.requestSender + " to " + item.routedTo);
                return true;
            }
            item.lastMessageTime = System.currentTimeMillis();
            if (logMINOR) {
                Logger.minor(this, "Forwarding SwapCommit " + uid + ',' + item.outgoingID + " from " + source + " to " + item.routedTo);
            }
            m.set("uid", item.outgoingID);
            try {
                item.routedTo.sendAsync(m, new SendMessageOnErrorCallback(DMT.createFNPSwapRejected(item.incomingID), item.requestSender, this), this);
            }
            catch (NotConnectedException e) {
                if (!logMINOR) break block6;
                Logger.minor(this, "Lost connection forwarding SwapCommit " + uid + " to " + item.routedTo);
            }
        }
        this.spyOnLocations(m, false);
        return true;
    }

    public boolean handleSwapComplete(Message m, PeerNode source) {
        RecentlyForwardedItem item;
        long uid = m.getLong("uid");
        if (logMINOR) {
            Logger.minor(this, "handleSwapComplete(" + uid + ')');
        }
        if ((item = this.recentlyForwardedIDs.get(uid)) == null) {
            if (logMINOR) {
                Logger.minor(this, "Item not found: " + uid + ": " + m);
            }
            return false;
        }
        if (item.requestSender == null) {
            if (logMINOR) {
                Logger.minor(this, "Not matched " + uid + ": " + m);
            }
            return false;
        }
        if (item.routedTo == null) {
            Logger.error(this, "Got SwapComplete on " + uid + " but routedTo == null! (meaning we accepted it, presumably)");
            return false;
        }
        if (source != item.routedTo) {
            Logger.error(this, "Unmatched swapreply " + uid + " from wrong source: From " + source + " should be " + item.routedTo + " to " + item.requestSender);
            return true;
        }
        if (logMINOR) {
            Logger.minor(this, "Forwarding SwapComplete " + uid + " from " + source + " to " + item.requestSender);
        }
        m.set("uid", item.incomingID);
        try {
            item.requestSender.sendAsync(m, null, this);
        }
        catch (NotConnectedException e) {
            Logger.normal(this, "Lost connection forwarding SwapComplete " + uid + " to " + item.requestSender);
        }
        item.lastMessageTime = System.currentTimeMillis();
        this.removeRecentlyForwardedItem(item);
        this.spyOnLocations(m, false);
        return true;
    }

    private void spyOnLocations(Message m, boolean ignoreIfOld) {
        this.spyOnLocations(m, ignoreIfOld, false, -1.0);
    }

    private void spyOnLocations(Message m, boolean ignoreIfOld, boolean swappingWithMe, double myLoc) {
        byte[] data;
        long[] uids = null;
        Message uidsMessage = m.getSubMessage(DMT.FNPSwapNodeUIDs);
        if (uidsMessage != null) {
            uids = Fields.bytesToLongs(((ShortBuffer)uidsMessage.getObject("nodeUIDs")).getData());
        }
        if ((data = ((ShortBuffer)m.getObject("data")).getData()).length < 16 || data.length % 8 != 0) {
            Logger.error(this, "Data invalid length in swap commit: " + data.length, new Exception("error"));
            return;
        }
        double[] locations = Fields.bytesToDoubles(data, 8, data.length - 8);
        double hisLoc = locations[0];
        if (hisLoc < 0.0 || hisLoc > 1.0) {
            Logger.error(this, "Invalid hisLoc in swap commit: " + hisLoc, new Exception("error"));
            return;
        }
        if (uids != null) {
            this.registerKnownLocation(hisLoc, uids[0]);
            if (swappingWithMe) {
                this.registerKnownLocation(myLoc, uids[0]);
            }
        } else if (!ignoreIfOld) {
            this.registerKnownLocation(hisLoc);
        }
        for (int i = 1; i < locations.length; ++i) {
            double loc = locations[i];
            if (uids != null) {
                this.registerKnownLocation(loc, uids[i - 1]);
                this.registerLink(uids[0], uids[i - 1]);
                continue;
            }
            if (ignoreIfOld) continue;
            this.registerKnownLocation(loc);
            this.registerLocationLink(hisLoc, loc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOldSwapChains() {
        long now = System.currentTimeMillis();
        Hashtable<Long, RecentlyForwardedItem> hashtable = this.recentlyForwardedIDs;
        synchronized (hashtable) {
            RecentlyForwardedItem[] items = new RecentlyForwardedItem[this.recentlyForwardedIDs.size()];
            if (items.length < 1) {
                return;
            }
            items = this.recentlyForwardedIDs.values().toArray(items);
            for (int i = 0; i < items.length; ++i) {
                if (now - items[i].lastMessageTime <= 120000L) continue;
                this.removeRecentlyForwardedItem(items[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lostOrRestartedNode(PeerNode pn) {
        ArrayList<RecentlyForwardedItem> v = new ArrayList<RecentlyForwardedItem>();
        Hashtable<Long, RecentlyForwardedItem> hashtable = this.recentlyForwardedIDs;
        synchronized (hashtable) {
            Set<Map.Entry<Long, RecentlyForwardedItem>> entrySet = this.recentlyForwardedIDs.entrySet();
            for (Map.Entry<Long, RecentlyForwardedItem> entry : entrySet) {
                Long l = entry.getKey();
                RecentlyForwardedItem item = entry.getValue();
                if (item == null) {
                    Logger.error(this, "Key is " + l + " but no value on recentlyForwardedIDs - shouldn't be possible");
                    continue;
                }
                if (item.routedTo != pn || !item.successfullyForwarded) continue;
                v.add(item);
            }
            for (RecentlyForwardedItem item : v) {
                this.removeRecentlyForwardedItem(item);
            }
        }
        int dumped = v.size();
        if (dumped != 0 && logMINOR) {
            Logger.minor(this, "lostOrRestartedNode dumping " + dumped + " swap requests for " + pn.getPeer());
        }
        for (RecentlyForwardedItem item : v) {
            Message msg = DMT.createFNPSwapRejected(item.incomingID);
            if (logMINOR) {
                Logger.minor(this, "Rejecting in lostOrRestartedNode: " + item.incomingID + " from " + item.requestSender);
            }
            try {
                item.requestSender.sendAsync(msg, null, this);
            }
            catch (NotConnectedException e1) {
                Logger.normal(this, "Both sender and receiver disconnected for " + item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRecentlyForwardedItem(RecentlyForwardedItem item) {
        if (logMINOR) {
            Logger.minor(this, "Removing: " + item);
        }
        if (item == null) {
            Logger.error(this, "removeRecentlyForwardedItem(null)", new Exception("error"));
        }
        Hashtable<Long, RecentlyForwardedItem> hashtable = this.recentlyForwardedIDs;
        synchronized (hashtable) {
            this.recentlyForwardedIDs.remove(item.incomingID);
            this.recentlyForwardedIDs.remove(item.outgoingID);
        }
    }

    void registerLocationLink(double d, double t) {
        if (logMINOR) {
            Logger.minor(this, "Known Link: " + d + ' ' + t);
        }
    }

    void registerKnownLocation(double d, long uid) {
        if (logMINOR) {
            Logger.minor(this, "LOCATION: " + d + " UID: " + uid);
        }
        this.registerKnownLocation(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerKnownLocation(double d) {
        if (logMINOR) {
            Logger.minor(this, "Known Location: " + d);
        }
        long now = System.currentTimeMillis();
        TimeSortedHashtable<Double> timeSortedHashtable = this.knownLocs;
        synchronized (timeSortedHashtable) {
            Logger.minor(this, "Adding location " + d + " knownLocs size " + this.knownLocs.size());
            this.knownLocs.push(d, now);
            Logger.minor(this, "Added location " + d + " knownLocs size " + this.knownLocs.size());
            this.knownLocs.removeBefore(now - 604800000L);
            Logger.minor(this, "Added and pruned location " + d + " knownLocs size " + this.knownLocs.size());
        }
        if (logMINOR) {
            Logger.minor(this, "Estimated net size(session): " + this.knownLocs.size());
        }
    }

    void registerLink(long uid1, long uid2) {
        if (logMINOR) {
            Logger.minor(this, "UID LINK: " + uid1 + " , " + uid2);
        }
    }

    public int getNetworkSizeEstimate(long timestamp) {
        return this.knownLocs.countValuesAfter(timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getKnownLocations(long timestamp) {
        TimeSortedHashtable<Double> timeSortedHashtable = this.knownLocs;
        synchronized (timeSortedHashtable) {
            return this.knownLocs.pairsAfter(timestamp, new Double[this.knownLocs.size()]);
        }
    }

    static double[] extractLocs(PeerManager.LocationUIDPair[] pairs) {
        double[] locs = new double[pairs.length];
        for (int i = 0; i < pairs.length; ++i) {
            locs[i] = pairs[i].location;
        }
        return locs;
    }

    static long[] extractUIDs(PeerManager.LocationUIDPair[] pairs) {
        long[] uids = new long[pairs.length];
        for (int i = 0; i < pairs.length; ++i) {
            uids[i] = pairs[i].uid;
        }
        return uids;
    }

    public static double[] extractLocs(PeerNode[] peers, boolean indicateBackoff) {
        double[] locs = new double[peers.length];
        for (int i = 0; i < peers.length; ++i) {
            locs[i] = peers[i].getLocation();
            if (!indicateBackoff) continue;
            if (peers[i].isRoutingBackedOff()) {
                int n = i;
                locs[n] = locs[n] + 1.0;
                continue;
            }
            locs[i] = -1.0 - locs[i];
        }
        return locs;
    }

    public static long[] extractUIDs(PeerNode[] peers) {
        long[] uids = new long[peers.length];
        for (int i = 0; i < peers.length; ++i) {
            uids[i] = peers[i].swapIdentifier;
        }
        return uids;
    }

    public synchronized double getLocChangeSession() {
        return this.locChangeSession;
    }

    public int getAverageSwapTime() {
        return (int)this.averageSwapTime.currentValue();
    }

    public void receivedBytes(int x) {
        this.node.nodeStats.swappingReceivedBytes(x);
    }

    public void sentBytes(int x) {
        this.node.nodeStats.swappingSentBytes(x);
    }

    public void sentPayload(int x) {
        Logger.error(this, "LocationManager sentPayload()?", new Exception("debug"));
    }

    static class RecentlyForwardedItem {
        final long incomingID;
        final long outgoingID;
        final long addedTime;
        long lastMessageTime;
        final PeerNode requestSender;
        PeerNode routedTo;
        boolean successfullyForwarded;

        RecentlyForwardedItem(long id, long outgoingID, PeerNode from, PeerNode to) {
            this.incomingID = id;
            this.outgoingID = outgoingID;
            this.requestSender = from;
            this.routedTo = to;
            this.lastMessageTime = this.addedTime = System.currentTimeMillis();
        }
    }

    public class OutgoingSwapRequestHandler
    implements Runnable {
        RecentlyForwardedItem item;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            boolean reachedEnd;
            block45: {
                block44: {
                    block43: {
                        block42: {
                            block41: {
                                block40: {
                                    block39: {
                                        block38: {
                                            block37: {
                                                block36: {
                                                    block35: {
                                                        Logger.OSThread.logPID(this);
                                                        long uid = LocationManager.this.r.nextLong();
                                                        if (!LocationManager.this.lock()) {
                                                            return;
                                                        }
                                                        reachedEnd = false;
                                                        try {
                                                            try {
                                                                Message reply;
                                                                ++startedSwaps;
                                                                long random = LocationManager.this.r.nextLong();
                                                                double myLoc = LocationManager.this.getLocation();
                                                                PeerManager.LocationUIDPair[] friendLocsAndUIDs = LocationManager.this.node.peers.getPeerLocationsAndUIDs();
                                                                double[] friendLocs = LocationManager.extractLocs(friendLocsAndUIDs);
                                                                long[] myValueLong = new long[2 + friendLocs.length];
                                                                myValueLong[0] = random;
                                                                myValueLong[1] = Double.doubleToLongBits(myLoc);
                                                                for (int i = 0; i < friendLocs.length; ++i) {
                                                                    myValueLong[i + 2] = Double.doubleToLongBits(friendLocs[i]);
                                                                }
                                                                byte[] myValue = Fields.longsToBytes(myValueLong);
                                                                byte[] myHash = SHA256.digest(myValue);
                                                                Message m = DMT.createFNPSwapRequest(uid, myHash, 10);
                                                                PeerNode pn = LocationManager.this.node.peers.getRandomPeer();
                                                                if (pn == null) {
                                                                    Object var32_14 = null;
                                                                    LocationManager.this.unlock(reachedEnd);
                                                                    if (this.item == null) return;
                                                                    break block35;
                                                                }
                                                                this.item = LocationManager.this.addForwardedItem(uid, uid, null, pn);
                                                                if (logMINOR) {
                                                                    Logger.minor(this, "Sending SwapRequest " + uid + " to " + pn);
                                                                }
                                                                MessageFilter filter1 = MessageFilter.create().setType(DMT.FNPSwapRejected).setField("uid", uid).setSource(pn).setTimeout(60000);
                                                                MessageFilter filter2 = MessageFilter.create().setType(DMT.FNPSwapReply).setField("uid", uid).setSource(pn).setTimeout(60000);
                                                                MessageFilter filter = filter1.or(filter2);
                                                                LocationManager.this.node.usm.send(pn, m, LocationManager.this);
                                                                if (logMINOR) {
                                                                    Logger.minor(this, "Waiting for SwapReply/SwapRejected on " + uid);
                                                                }
                                                                try {
                                                                    reply = LocationManager.this.node.usm.waitFor(filter, LocationManager.this);
                                                                }
                                                                catch (DisconnectedException e) {
                                                                    if (logMINOR) {
                                                                        Logger.minor(this, "Disconnected while waiting for SwapReply/SwapRejected for " + uid);
                                                                    }
                                                                    Object var32_15 = null;
                                                                    LocationManager.this.unlock(reachedEnd);
                                                                    if (this.item == null) return;
                                                                    LocationManager.this.removeRecentlyForwardedItem(this.item);
                                                                    return;
                                                                }
                                                                if (reply == null) {
                                                                    if (pn.isRoutable() && System.currentTimeMillis() - pn.timeLastConnectionCompleted() > 120000L) {
                                                                        Logger.error(this, "Timed out waiting for SwapRejected/SwapReply on " + uid);
                                                                    }
                                                                    break block36;
                                                                }
                                                                if (reply.getSpec() == DMT.FNPSwapRejected) {
                                                                    if (logMINOR) {
                                                                        Logger.minor(this, "Swap rejected on " + uid);
                                                                    }
                                                                    break block37;
                                                                }
                                                                byte[] hisHash = ((ShortBuffer)reply.getObject("hash")).getData();
                                                                Message confirm = DMT.createFNPSwapCommit(uid, myValue);
                                                                filter1.clearOr();
                                                                MessageFilter filter3 = MessageFilter.create().setField("uid", uid).setType(DMT.FNPSwapComplete).setTimeout(60000).setSource(pn);
                                                                filter = filter1.or(filter3);
                                                                LocationManager.this.node.usm.send(pn, confirm, LocationManager.this);
                                                                if (logMINOR) {
                                                                    Logger.minor(this, "Waiting for SwapComplete: uid = " + uid);
                                                                }
                                                                try {
                                                                    reply = LocationManager.this.node.usm.waitFor(filter, LocationManager.this);
                                                                }
                                                                catch (DisconnectedException e) {
                                                                    if (logMINOR) {
                                                                        Logger.minor(this, "Disconnected waiting for SwapComplete on " + uid);
                                                                    }
                                                                    Object var32_18 = null;
                                                                    LocationManager.this.unlock(reachedEnd);
                                                                    if (this.item == null) return;
                                                                    LocationManager.this.removeRecentlyForwardedItem(this.item);
                                                                    return;
                                                                }
                                                                if (reply == null) {
                                                                    if (pn.isRoutable() && System.currentTimeMillis() - pn.timeLastConnectionCompleted() > 120000L) {
                                                                        Logger.error(this, "Timed out waiting for SwapComplete - malicious node?? on " + uid);
                                                                    }
                                                                    break block38;
                                                                }
                                                                if (reply.getSpec() == DMT.FNPSwapRejected) {
                                                                    Logger.error(this, "Got SwapRejected while waiting for SwapComplete. This can happen occasionally because of badly timed disconnects, but if it happens frequently it indicates a bug or an attack");
                                                                    break block39;
                                                                }
                                                                byte[] hisBuf = ((ShortBuffer)reply.getObject("data")).getData();
                                                                if (hisBuf.length % 8 != 0 || hisBuf.length < 16) {
                                                                    Logger.error(this, "Bad content length in SwapComplete - malicious node? on " + uid);
                                                                    break block40;
                                                                }
                                                                byte[] rehash = SHA256.digest(hisBuf);
                                                                if (!Arrays.equals(rehash, hisHash)) {
                                                                    Logger.error(this, "Bad hash in SwapComplete - malicious node? on " + uid);
                                                                    break block41;
                                                                }
                                                                long[] hisBufLong = Fields.bytesToLongs(hisBuf);
                                                                if (hisBufLong.length < 2) {
                                                                    Logger.error(this, "Bad buffer length (no random, no location)- malicious node? on " + uid);
                                                                    break block42;
                                                                }
                                                                long hisRandom = hisBufLong[0];
                                                                double hisLoc = Double.longBitsToDouble(hisBufLong[1]);
                                                                if (hisLoc < 0.0 || hisLoc > 1.0) {
                                                                    Logger.error(this, "Bad loc: " + hisLoc + " on " + uid);
                                                                    break block43;
                                                                }
                                                                LocationManager.this.registerKnownLocation(hisLoc);
                                                                double[] hisFriendLocs = new double[hisBufLong.length - 2];
                                                                for (int i = 0; i < hisFriendLocs.length; ++i) {
                                                                    hisFriendLocs[i] = Double.longBitsToDouble(hisBufLong[i + 2]);
                                                                    if (hisFriendLocs[i] < 0.0 || hisFriendLocs[i] > 1.0) {
                                                                        Logger.error(this, "Bad friend loc: " + hisFriendLocs[i] + " on " + uid);
                                                                        break block44;
                                                                    }
                                                                    LocationManager.this.registerLocationLink(hisLoc, hisFriendLocs[i]);
                                                                    LocationManager.this.registerKnownLocation(hisFriendLocs[i]);
                                                                }
                                                                LocationManager.this.numberOfRemotePeerLocationsSeenInSwaps += hisFriendLocs.length;
                                                                boolean shouldSwap = LocationManager.this.shouldSwap(myLoc, friendLocs, hisLoc, hisFriendLocs, random ^ hisRandom);
                                                                LocationManager.this.spyOnLocations(reply, true, shouldSwap, myLoc);
                                                                if (shouldSwap) {
                                                                    LocationManager.this.timeLastSuccessfullySwapped = System.currentTimeMillis();
                                                                    LocationManager.this.updateLocationChangeSession(hisLoc);
                                                                    LocationManager.this.setLocation(hisLoc);
                                                                    if (logMINOR) {
                                                                        Logger.minor(this, "Swapped: " + myLoc + " <-> " + hisLoc + " - " + uid);
                                                                    }
                                                                    ++swaps;
                                                                    LocationManager.this.announceLocChange(true, false, false);
                                                                    LocationManager.this.node.writeNodeFile();
                                                                } else {
                                                                    if (logMINOR) {
                                                                        Logger.minor(this, "Didn't swap: " + myLoc + " <-> " + hisLoc + " - " + uid);
                                                                    }
                                                                    ++noSwaps;
                                                                }
                                                                reachedEnd = true;
                                                                if (LocationManager.this.node.random.nextInt(16000) == 0) {
                                                                    LocationManager.this.setLocation(LocationManager.this.node.random.nextDouble());
                                                                    LocationManager.this.announceLocChange(true, true, false);
                                                                    LocationManager.this.node.writeNodeFile();
                                                                }
                                                                break block45;
                                                            }
                                                            catch (Throwable t) {
                                                                Logger.error(this, "Caught " + t, t);
                                                                Object var32_27 = null;
                                                                LocationManager.this.unlock(reachedEnd);
                                                                if (this.item == null) return;
                                                                LocationManager.this.removeRecentlyForwardedItem(this.item);
                                                                return;
                                                            }
                                                        }
                                                        catch (Throwable throwable) {
                                                            Object var32_28 = null;
                                                            LocationManager.this.unlock(reachedEnd);
                                                            if (this.item == null) throw throwable;
                                                            LocationManager.this.removeRecentlyForwardedItem(this.item);
                                                            throw throwable;
                                                        }
                                                    }
                                                    LocationManager.this.removeRecentlyForwardedItem(this.item);
                                                    return;
                                                }
                                                Object var32_16 = null;
                                                LocationManager.this.unlock(reachedEnd);
                                                if (this.item == null) return;
                                                LocationManager.this.removeRecentlyForwardedItem(this.item);
                                                return;
                                            }
                                            Object var32_17 = null;
                                            LocationManager.this.unlock(reachedEnd);
                                            if (this.item == null) return;
                                            LocationManager.this.removeRecentlyForwardedItem(this.item);
                                            return;
                                        }
                                        Object var32_19 = null;
                                        LocationManager.this.unlock(reachedEnd);
                                        if (this.item == null) return;
                                        LocationManager.this.removeRecentlyForwardedItem(this.item);
                                        return;
                                    }
                                    Object var32_20 = null;
                                    LocationManager.this.unlock(reachedEnd);
                                    if (this.item == null) return;
                                    LocationManager.this.removeRecentlyForwardedItem(this.item);
                                    return;
                                }
                                Object var32_21 = null;
                                LocationManager.this.unlock(reachedEnd);
                                if (this.item == null) return;
                                LocationManager.this.removeRecentlyForwardedItem(this.item);
                                return;
                            }
                            Object var32_22 = null;
                            LocationManager.this.unlock(reachedEnd);
                            if (this.item == null) return;
                            LocationManager.this.removeRecentlyForwardedItem(this.item);
                            return;
                        }
                        Object var32_23 = null;
                        LocationManager.this.unlock(reachedEnd);
                        if (this.item == null) return;
                        LocationManager.this.removeRecentlyForwardedItem(this.item);
                        return;
                    }
                    Object var32_24 = null;
                    LocationManager.this.unlock(reachedEnd);
                    if (this.item == null) return;
                    LocationManager.this.removeRecentlyForwardedItem(this.item);
                    return;
                }
                Object var32_25 = null;
                LocationManager.this.unlock(reachedEnd);
                if (this.item == null) return;
                LocationManager.this.removeRecentlyForwardedItem(this.item);
                return;
            }
            Object var32_26 = null;
            LocationManager.this.unlock(reachedEnd);
            if (this.item == null) return;
            LocationManager.this.removeRecentlyForwardedItem(this.item);
        }
    }

    public class IncomingSwapRequestHandler
    implements Runnable {
        Message origMessage;
        PeerNode pn;
        long uid;
        RecentlyForwardedItem item;

        IncomingSwapRequestHandler(Message msg, PeerNode pn, RecentlyForwardedItem item) {
            this.origMessage = msg;
            this.pn = pn;
            this.item = item;
            this.uid = this.origMessage.getLong("uid");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            boolean reachedEnd;
            block29: {
                block28: {
                    block27: {
                        block26: {
                            block25: {
                                block24: {
                                    block23: {
                                        block22: {
                                            Logger.OSThread.logPID(this);
                                            MessageDigest md = SHA256.getMessageDigest();
                                            reachedEnd = false;
                                            try {
                                                try {
                                                    Message commit;
                                                    byte[] hisHash = ((ShortBuffer)this.origMessage.getObject("hash")).getData();
                                                    if (hisHash.length != md.getDigestLength()) {
                                                        Logger.error(this, "Invalid SwapRequest from peer: wrong length hash " + hisHash.length + " on " + this.uid);
                                                        Object var27_5 = null;
                                                        LocationManager.this.unlock(reachedEnd);
                                                        break block22;
                                                    }
                                                    LocationManager.this.addForwardedItem(this.uid, this.uid, this.pn, null);
                                                    long random = LocationManager.this.r.nextLong();
                                                    double myLoc = LocationManager.this.getLocation();
                                                    PeerManager.LocationUIDPair[] friendLocsAndUIDs = LocationManager.this.node.peers.getPeerLocationsAndUIDs();
                                                    double[] friendLocs = LocationManager.extractLocs(friendLocsAndUIDs);
                                                    long[] myValueLong = new long[2 + friendLocs.length];
                                                    myValueLong[0] = random;
                                                    myValueLong[1] = Double.doubleToLongBits(myLoc);
                                                    for (int i = 0; i < friendLocs.length; ++i) {
                                                        myValueLong[i + 2] = Double.doubleToLongBits(friendLocs[i]);
                                                    }
                                                    byte[] myValue = Fields.longsToBytes(myValueLong);
                                                    byte[] myHash = md.digest(myValue);
                                                    Message m = DMT.createFNPSwapReply(this.uid, myHash);
                                                    MessageFilter filter = MessageFilter.create().setType(DMT.FNPSwapCommit).setField("uid", this.uid).setTimeout(60000).setSource(this.pn);
                                                    LocationManager.this.node.usm.send(this.pn, m, LocationManager.this);
                                                    try {
                                                        commit = LocationManager.this.node.usm.waitFor(filter, LocationManager.this);
                                                    }
                                                    catch (DisconnectedException e) {
                                                        if (logMINOR) {
                                                            Logger.minor(this, "Disconnected from " + this.pn + " while waiting for SwapCommit");
                                                        }
                                                        Object var27_6 = null;
                                                        LocationManager.this.unlock(reachedEnd);
                                                        LocationManager.this.removeRecentlyForwardedItem(this.item);
                                                        return;
                                                    }
                                                    if (commit == null) {
                                                        Logger.error(this, "Timed out waiting for SwapCommit on " + this.uid + " - this can happen occasionally due to connection closes, if it happens often, there may be a serious problem");
                                                        break block23;
                                                    }
                                                    byte[] hisBuf = ((ShortBuffer)commit.getObject("data")).getData();
                                                    if (hisBuf.length % 8 != 0 || hisBuf.length < 16) {
                                                        Logger.error(this, "Bad content length in SwapComplete - malicious node? on " + this.uid);
                                                        break block24;
                                                    }
                                                    byte[] rehash = md.digest(hisBuf);
                                                    if (!Arrays.equals(rehash, hisHash)) {
                                                        Logger.error(this, "Bad hash in SwapCommit - malicious node? on " + this.uid);
                                                        break block25;
                                                    }
                                                    long[] hisBufLong = Fields.bytesToLongs(hisBuf);
                                                    if (hisBufLong.length < 2) {
                                                        Logger.error(this, "Bad buffer length (no random, no location)- malicious node? on " + this.uid);
                                                        break block26;
                                                    }
                                                    long hisRandom = hisBufLong[0];
                                                    double hisLoc = Double.longBitsToDouble(hisBufLong[1]);
                                                    if (hisLoc < 0.0 || hisLoc > 1.0) {
                                                        Logger.error(this, "Bad loc: " + hisLoc + " on " + this.uid);
                                                        break block27;
                                                    }
                                                    LocationManager.this.registerKnownLocation(hisLoc);
                                                    double[] hisFriendLocs = new double[hisBufLong.length - 2];
                                                    for (int i = 0; i < hisFriendLocs.length; ++i) {
                                                        hisFriendLocs[i] = Double.longBitsToDouble(hisBufLong[i + 2]);
                                                        if (hisFriendLocs[i] < 0.0 || hisFriendLocs[i] > 1.0) {
                                                            Logger.error(this, "Bad friend loc: " + hisFriendLocs[i] + " on " + this.uid);
                                                            break block28;
                                                        }
                                                        LocationManager.this.registerLocationLink(hisLoc, hisFriendLocs[i]);
                                                        LocationManager.this.registerKnownLocation(hisFriendLocs[i]);
                                                    }
                                                    LocationManager.this.numberOfRemotePeerLocationsSeenInSwaps += hisFriendLocs.length;
                                                    Message confirm = DMT.createFNPSwapComplete(this.uid, myValue);
                                                    LocationManager.this.node.usm.send(this.pn, confirm, LocationManager.this);
                                                    boolean shouldSwap = LocationManager.this.shouldSwap(myLoc, friendLocs, hisLoc, hisFriendLocs, random ^ hisRandom);
                                                    LocationManager.this.spyOnLocations(commit, true, shouldSwap, myLoc);
                                                    if (shouldSwap) {
                                                        LocationManager.this.timeLastSuccessfullySwapped = System.currentTimeMillis();
                                                        LocationManager.this.updateLocationChangeSession(hisLoc);
                                                        LocationManager.this.setLocation(hisLoc);
                                                        if (logMINOR) {
                                                            Logger.minor(this, "Swapped: " + myLoc + " <-> " + hisLoc + " - " + this.uid);
                                                        }
                                                        ++swaps;
                                                        LocationManager.this.announceLocChange(true, false, false);
                                                        LocationManager.this.node.writeNodeFile();
                                                    } else {
                                                        if (logMINOR) {
                                                            Logger.minor(this, "Didn't swap: " + myLoc + " <-> " + hisLoc + " - " + this.uid);
                                                        }
                                                        ++noSwaps;
                                                    }
                                                    reachedEnd = true;
                                                    if (LocationManager.this.node.random.nextInt(16000) == 0) {
                                                        LocationManager.this.setLocation(LocationManager.this.node.random.nextDouble());
                                                        LocationManager.this.announceLocChange(true, true, false);
                                                        LocationManager.this.node.writeNodeFile();
                                                    }
                                                    SHA256.returnMessageDigest(md);
                                                    break block29;
                                                }
                                                catch (Throwable t) {
                                                    Logger.error(this, "Caught " + t, t);
                                                    Object var27_14 = null;
                                                    LocationManager.this.unlock(reachedEnd);
                                                    LocationManager.this.removeRecentlyForwardedItem(this.item);
                                                    return;
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                Object var27_15 = null;
                                                LocationManager.this.unlock(reachedEnd);
                                                LocationManager.this.removeRecentlyForwardedItem(this.item);
                                                throw throwable;
                                            }
                                        }
                                        LocationManager.this.removeRecentlyForwardedItem(this.item);
                                        return;
                                    }
                                    Object var27_7 = null;
                                    LocationManager.this.unlock(reachedEnd);
                                    LocationManager.this.removeRecentlyForwardedItem(this.item);
                                    return;
                                }
                                Object var27_8 = null;
                                LocationManager.this.unlock(reachedEnd);
                                LocationManager.this.removeRecentlyForwardedItem(this.item);
                                return;
                            }
                            Object var27_9 = null;
                            LocationManager.this.unlock(reachedEnd);
                            LocationManager.this.removeRecentlyForwardedItem(this.item);
                            return;
                        }
                        Object var27_10 = null;
                        LocationManager.this.unlock(reachedEnd);
                        LocationManager.this.removeRecentlyForwardedItem(this.item);
                        return;
                    }
                    Object var27_11 = null;
                    LocationManager.this.unlock(reachedEnd);
                    LocationManager.this.removeRecentlyForwardedItem(this.item);
                    return;
                }
                Object var27_12 = null;
                LocationManager.this.unlock(reachedEnd);
                LocationManager.this.removeRecentlyForwardedItem(this.item);
                return;
            }
            Object var27_13 = null;
            LocationManager.this.unlock(reachedEnd);
            LocationManager.this.removeRecentlyForwardedItem(this.item);
        }
    }

    public class SwapRequestSender
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Logger.OSThread.logPID(this);
            Thread.currentThread().setName("SwapRequestSender");
            while (true) {
                try {
                    while (true) {
                        long endTime;
                        long startTime = System.currentTimeMillis();
                        double nextRandom = LocationManager.this.r.nextDouble();
                        do {
                            int sleepTime = LocationManager.this.getSendSwapInterval();
                            sleepTime = (int)((double)sleepTime * nextRandom);
                            sleepTime = Math.min(sleepTime, Integer.MAX_VALUE);
                            endTime = startTime + (long)sleepTime;
                            long now = System.currentTimeMillis();
                            long diff = endTime - now;
                            try {
                                if (diff <= 0L) continue;
                                Thread.sleep(Math.min((int)diff, 10000));
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        } while (System.currentTimeMillis() < endTime);
                        if (LocationManager.this.swappingDisabled() || !LocationManager.this.lock()) continue;
                        if (System.currentTimeMillis() - LocationManager.this.timeLastSuccessfullySwapped > 30000L) {
                            Object var18_3;
                            try {
                                boolean myFlag = false;
                                double myLoc = LocationManager.this.getLocation();
                                PeerNode[] peers = LocationManager.this.node.peers.connectedPeers;
                                for (int i = 0; i < peers.length; ++i) {
                                    PeerNode pn = peers[i];
                                    if (!pn.isRoutable()) continue;
                                    PeerNode peerNode = pn;
                                    synchronized (peerNode) {
                                        double ploc = pn.getLocation();
                                        if (Math.abs(ploc - myLoc) <= Double.MIN_VALUE) {
                                            long now = System.currentTimeMillis();
                                            if (now - pn.getLocSetTime() > 120000L && now - LocationManager.this.timeLocSet > 120000L) {
                                                myFlag = true;
                                                Logger.error(this, "Randomizing location: my loc=" + myLoc + " but loc=" + ploc + " for " + pn);
                                                break;
                                            }
                                            Logger.normal(this, "Node " + pn + " has identical location to us, waiting until this has persisted for 2 minutes...");
                                        }
                                        continue;
                                    }
                                }
                                if (myFlag) {
                                    LocationManager.this.setLocation(LocationManager.this.node.random.nextDouble());
                                    LocationManager.this.announceLocChange(true, true, true);
                                    LocationManager.this.node.writeNodeFile();
                                }
                                var18_3 = null;
                                LocationManager.this.unlock(false);
                            }
                            catch (Throwable throwable) {
                                var18_3 = null;
                                LocationManager.this.unlock(false);
                                throw throwable;
                            }
                        } else {
                            LocationManager.this.unlock(false);
                        }
                        LocationManager.this.startSwapRequest();
                    }
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught " + t, t);
                    continue;
                }
                break;
            }
        }
    }

    public class MyCallback
    extends SendMessageOnErrorCallback {
        RecentlyForwardedItem item;

        public MyCallback(Message message, PeerNode pn, RecentlyForwardedItem item) {
            super(message, pn, LocationManager.this);
            this.item = item;
        }

        public void disconnected() {
            super.disconnected();
            LocationManager.this.removeRecentlyForwardedItem(this.item);
        }

        public void acknowledged() {
            this.item.successfullyForwarded = true;
        }
    }
}

