/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.node.PeerManager;
import freenet.node.PeerNode;
import freenet.support.Logger;

public class Location {
    public static double getLocation(String init) {
        try {
            if (init == null) {
                return -1.0;
            }
            double d = Double.parseDouble(init);
            if (d < 0.0 || d > 1.0) {
                return -1.0;
            }
            return d;
        }
        catch (NumberFormatException e) {
            return -1.0;
        }
    }

    static double distance(PeerNode p, double loc) {
        double d = Location.distance(p.getLocation(), loc);
        return d;
    }

    public static double distance(double a, double b) {
        return Location.distance(a, b, false);
    }

    public static double distance(double a, double b, boolean allowCrazy) {
        if (!allowCrazy) {
            if (a < 0.0 || a > 1.0 || b < 0.0 || b > 1.0) {
                Logger.error(PeerManager.class, "Invalid Location ! a = " + a + " b = " + b + "Please report this bug!", new Exception("error"));
                throw new NullPointerException();
            }
            return Location.simpleDistance(a, b);
        }
        if (a < 0.0 || a > 1.0) {
            a = 2.0;
        }
        if (b < 0.0 || b > 1.0) {
            b = 2.0;
        }
        if (a > 1.0 && b > 2.0) {
            return 0.0;
        }
        if (a > 1.0) {
            return a - b;
        }
        if (b > 1.0) {
            return b - a;
        }
        return Location.simpleDistance(a, b);
    }

    private static double simpleDistance(double a, double b) {
        if (a > b) {
            return Math.min(a - b, 1.0 - a + b);
        }
        return Math.min(b - a, 1.0 - b + a);
    }

    public static double change(double from, double to) {
        if (to > from) {
            double directDifference = to - from;
            double oppositeDifference = 1.0 - to + from;
            if (directDifference <= oppositeDifference) {
                return directDifference;
            }
            return -oppositeDifference;
        }
        double directDifference = from - to;
        double oppositeDifference = 1.0 - from + to;
        if (directDifference < oppositeDifference) {
            return -directDifference;
        }
        return oppositeDifference;
    }

    public static double normalize(double rough) {
        int intPart = (int)rough;
        double maybeNegative = rough - (double)intPart;
        if (maybeNegative < 0.0) {
            return 1.0 + maybeNegative;
        }
        return maybeNegative;
    }

    public static boolean equals(double newLoc, double currentLocation) {
        return Math.abs(newLoc - currentLocation) < 9.9E-324;
    }
}

