/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.clients.http.filter.GenericReadFilterCallback;
import freenet.io.comm.FreenetInetAddress;
import freenet.io.comm.Peer;
import freenet.l10n.L10n;
import freenet.node.Node;
import freenet.node.NodeIPDetector;
import freenet.node.OpennetManager;
import freenet.node.PeerNode;
import freenet.node.useralerts.AbstractUserAlert;
import freenet.node.useralerts.ProxyUserAlert;
import freenet.node.useralerts.SimpleUserAlert;
import freenet.node.useralerts.UserAlert;
import freenet.pluginmanager.DetectedIP;
import freenet.pluginmanager.ForwardPort;
import freenet.pluginmanager.ForwardPortCallback;
import freenet.pluginmanager.ForwardPortStatus;
import freenet.pluginmanager.FredPlugin;
import freenet.pluginmanager.FredPluginIPDetector;
import freenet.pluginmanager.FredPluginPortForward;
import freenet.support.HTMLEncoder;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.OOMHandler;
import freenet.support.transport.ip.IPUtil;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPDetectorPluginManager
implements ForwardPortCallback {
    static boolean logMINOR;
    static boolean logDEBUG;
    private final NodeIPDetector detector;
    private final Node node;
    FredPluginIPDetector[] plugins;
    FredPluginPortForward[] portForwardPlugins;
    private final MyUserAlert noConnectionAlert;
    private final MyUserAlert symmetricAlert;
    private final MyUserAlert portRestrictedAlert;
    private final MyUserAlert restrictedAlert;
    private short connectionType;
    private ProxyUserAlert proxyAlert;
    private final PortForwardAlert portForwardAlert;
    private boolean started;
    private HashMap<FredPluginIPDetector, DetectorRunner> runners = new HashMap();
    private HashSet<FredPluginIPDetector> failedRunners = new HashSet();
    private long lastDetectAttemptEndedTime;
    private long firstTimeUrgent;
    private SimpleUserAlert noConnectivityAlert;

    IPDetectorPluginManager(Node node, NodeIPDetector detector) {
        logMINOR = Logger.shouldLog(4, this.getClass());
        logDEBUG = Logger.shouldLog(2, this.getClass());
        this.plugins = new FredPluginIPDetector[0];
        this.portForwardPlugins = new FredPluginPortForward[0];
        this.node = node;
        this.detector = detector;
        this.noConnectionAlert = new MyUserAlert(this.l10n("noConnectivityTitle"), this.l10n("noConnectivity"), true, 1);
        this.symmetricAlert = new MyUserAlert(this.l10n("symmetricTitle"), this.l10n("symmetric"), true, 1);
        this.portRestrictedAlert = new MyUserAlert(this.l10n("portRestrictedTitle"), this.l10n("portRestricted"), true, 2);
        this.restrictedAlert = new MyUserAlert(this.l10n("restrictedTitle"), this.l10n("restricted"), false, 3);
        this.portForwardAlert = new PortForwardAlert();
    }

    public int[] getUDPPortsNotForwarded() {
        int opennetStatus;
        OpennetManager om = this.node.getOpennet();
        int darknetStatus = this.node.peers.anyDarknetPeers() ? this.node.darknetCrypto.getDetectedConnectivityStatus() : 0;
        int n = opennetStatus = om == null ? 0 : om.crypto.getDetectedConnectivityStatus();
        if (om == null || opennetStatus >= 0) {
            if (darknetStatus >= 0) {
                return new int[0];
            }
            return new int[]{(darknetStatus < -1 ? -1 : 1) * this.node.getDarknetPortNumber()};
        }
        if (darknetStatus >= 0) {
            return new int[]{(opennetStatus < -1 ? -1 : 1) * om.crypto.portNumber};
        }
        return new int[]{(darknetStatus < -1 ? -1 : 1) * this.node.getDarknetPortNumber(), (opennetStatus < -1 ? -1 : 1) * om.crypto.portNumber};
    }

    private String l10n(String key) {
        return L10n.getString("IPDetectorPluginManager." + key);
    }

    public String l10n(String key, String pattern, String value) {
        return L10n.getString("IPDetectorPluginManager." + key, new String[]{pattern}, new String[]{value});
    }

    public String l10n(String key, String[] patterns, String[] values) {
        return L10n.getString("IPDetectorPluginManager." + key, patterns, values);
    }

    void start() {
        this.proxyAlert = new ProxyUserAlert(this.node.clientCore.alerts, false);
        this.node.clientCore.alerts.register(this.portForwardAlert);
        this.started = true;
        this.tryMaybeRun();
    }

    private void tryMaybeRun() {
        try {
            this.maybeRun();
        }
        catch (Throwable t) {
            Logger.error(this, "Caught " + t, t);
        }
        this.node.getTicker().queueTimedJob(new Runnable(){

            public void run() {
                Logger.OSThread.logPID(this);
                IPDetectorPluginManager.this.tryMaybeRun();
            }
        }, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDetectorPlugin(FredPluginIPDetector d) {
        if (d == null) {
            throw new NullPointerException();
        }
        IPDetectorPluginManager iPDetectorPluginManager = this;
        synchronized (iPDetectorPluginManager) {
            this.lastDetectAttemptEndedTime = -1L;
            FredPluginIPDetector[] newPlugins = new FredPluginIPDetector[this.plugins.length + 1];
            System.arraycopy(this.plugins, 0, newPlugins, 0, this.plugins.length);
            newPlugins[this.plugins.length] = d;
            this.plugins = newPlugins;
        }
        if (logMINOR) {
            Logger.minor(this, "Registering a new plugin : " + d);
        }
        this.maybeRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterDetectorPlugin(FredPluginIPDetector d) {
        DetectorRunner runningDetector;
        IPDetectorPluginManager iPDetectorPluginManager = this;
        synchronized (iPDetectorPluginManager) {
            int count = 0;
            for (int i = 0; i < this.plugins.length; ++i) {
                if (this.plugins[i] != d) continue;
                ++count;
            }
            if (count == 0) {
                return;
            }
            FredPluginIPDetector[] newPlugins = new FredPluginIPDetector[this.plugins.length - count];
            int x = 0;
            for (int i = 0; i < this.plugins.length; ++i) {
                if (this.plugins[i] == d) continue;
                newPlugins[x++] = this.plugins[i];
            }
            this.plugins = newPlugins;
            runningDetector = this.runners.get(d);
        }
        if (runningDetector != null) {
            runningDetector.kill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeRun() {
        if (!this.started) {
            return;
        }
        logMINOR = Logger.shouldLog(4, this.getClass());
        logDEBUG = Logger.shouldLog(2, this.getClass());
        if (logMINOR) {
            Logger.minor(this, "Maybe running IP detection plugins", (Throwable)new Exception("debug"));
        }
        PeerNode[] peers = this.node.getPeerNodes();
        PeerNode[] conns = this.node.getConnectedPeers();
        int peerCount = this.node.peers.countValidPeers();
        FreenetInetAddress[] nodeAddrs = this.detector.getPrimaryIPAddress(true);
        long now = System.currentTimeMillis();
        IPDetectorPluginManager iPDetectorPluginManager = this;
        synchronized (iPDetectorPluginManager) {
            if (this.plugins.length == 0) {
                if (logMINOR) {
                    Logger.minor(this, "No IP detection plugins");
                }
                this.detector.hasDetectedPM();
                return;
            }
            if (this.runners.size() == this.plugins.length) {
                if (logMINOR) {
                    Logger.minor(this, "Already running all IP detection plugins");
                }
                return;
            }
            if (this.failedRunners.size() == this.plugins.length) {
                if (now - this.lastDetectAttemptEndedTime < 300000L) {
                    if (logMINOR) {
                        Logger.minor(this, "Last detect failed less than 5 minutes ago");
                    }
                    return;
                }
                if (logMINOR) {
                    Logger.minor(this, "Last detect failed, redetecting");
                }
                this.startDetect();
                return;
            }
            if (this.detector.hasDirectlyDetectedIP() && !this.shouldDetectDespiteRealIP(now, conns, nodeAddrs)) {
                return;
            }
            if (peerCount == 0) {
                if (this.shouldDetectNoPeers(now)) {
                    this.startDetect();
                }
            } else if (this.shouldDetectWithPeers(now, peers, conns, nodeAddrs)) {
                this.startDetect();
            }
        }
    }

    private boolean shouldDetectNoPeers(long now) {
        if (now - this.lastDetectAttemptEndedTime < 21600000L) {
            if (logMINOR) {
                Logger.minor(this, "No peers but detected less than 6 hours ago");
            }
            return false;
        }
        return true;
    }

    private boolean shouldDetectWithPeers(long now, PeerNode[] peers, PeerNode[] conns, FreenetInetAddress[] nodeAddrs) {
        boolean detect = false;
        int realConnections = 0;
        int realDisconnected = 0;
        int recentlyConnected = 0;
        if (logMINOR) {
            Logger.minor(this, "Checking whether should detect with " + peers.length + " peers and " + conns.length + " conns, counting peers...");
        }
        for (int i = 0; i < peers.length; ++i) {
            InetAddress addr;
            FreenetInetAddress a;
            Peer peer;
            PeerNode p = peers[i];
            if (p.isDisabled() || (peer = p.getPeer()) == null || (a = peer.getFreenetAddress()) == null || (addr = a.getAddress(false)) != null && !IPUtil.isValidAddress(addr, false)) continue;
            boolean skip = false;
            for (int j = 0; j < nodeAddrs.length; ++j) {
                if (!a.equals(nodeAddrs[j])) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            if (p.isConnected()) {
                ++realConnections;
                continue;
            }
            ++realDisconnected;
            if (now - p.lastReceivedPacketTime() >= 300000L) continue;
            ++recentlyConnected;
        }
        if (logMINOR) {
            Logger.minor(this, "Real connections: " + realConnections + " disconnected " + realDisconnected);
        }
        if (realConnections == 0 && realDisconnected > 0) {
            if (this.firstTimeUrgent <= 0L) {
                this.firstTimeUrgent = now;
            }
            if (this.detector.oldIPAddress != null && this.detector.oldIPAddress.isRealInternetAddress(false, false, false)) {
                if (logDEBUG) {
                    Logger.debug(this, "Detecting in 2 minutes as have oldIPAddress");
                }
                if (now - this.firstTimeUrgent > 120000L) {
                    detect = true;
                    this.firstTimeUrgent = now;
                    if (logMINOR) {
                        Logger.minor(this, "Detecting now as 2 minutes are up (have oldIPAddress)");
                    }
                }
            } else {
                if (logMINOR) {
                    Logger.minor(this, "Detecting now (no oldIPAddress)");
                }
                detect = true;
            }
        } else {
            if (realConnections == 0 && realDisconnected == 0) {
                return this.shouldDetectNoPeers(now);
            }
            if (logDEBUG) {
                Logger.minor(this, "Not urgent; conns=" + conns.length + ", peers=" + peers.length);
            }
            this.firstTimeUrgent = 0L;
        }
        if (realConnections == 0 && realDisconnected > 0 && recentlyConnected > 2 && now - this.lastDetectAttemptEndedTime > 360000L) {
            return true;
        }
        if (this.detector.maybeSymmetric && this.lastDetectAttemptEndedTime <= 0L) {
            return true;
        }
        if (detect) {
            if (now - this.lastDetectAttemptEndedTime < 3600000L) {
                if (logMINOR) {
                    Logger.minor(this, "Only trying once per hour");
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean shouldDetectDespiteRealIP(long now, PeerNode[] peers, FreenetInetAddress[] nodeAddrs) {
        if (now - this.lastDetectAttemptEndedTime < 43200000L) {
            if (logMINOR) {
                Logger.minor(this, "Node has directly detected IP and we have checked less than 12 hours ago");
            }
            return false;
        }
        if (logMINOR) {
            Logger.minor(this, "Checking whether should detect despite real IP...");
        }
        HashSet<InetAddress> addressesConnected = null;
        boolean hasOldPeers = false;
        for (PeerNode p : peers) {
            long l;
            if (!p.isConnected() && now - p.lastReceivedPacketTime() >= 86400000L) continue;
            Peer peer = p.getPeer();
            if (peer != null) {
                InetAddress addr = peer.getAddress(false);
                if (p.isConnected() && addr != null && IPUtil.isValidAddress(peer.getAddress(), false)) {
                    boolean internal = false;
                    for (int j = 0; j < nodeAddrs.length; ++j) {
                        if (!addr.equals(nodeAddrs[j].getAddress())) continue;
                        internal = true;
                        break;
                    }
                    if (!internal) {
                        if (addressesConnected == null) {
                            addressesConnected = new HashSet<InetAddress>();
                        }
                        addressesConnected.add(addr);
                        if (addressesConnected.size() > 2) {
                            if (logMINOR) {
                                Logger.minor(this, "Node has directly detected IP and has connected to 3 real IPs");
                            }
                            return false;
                        }
                    }
                }
            }
            if ((l = p.getPeerAddedTime()) > 0L && now - l <= 1800000L) continue;
            hasOldPeers = true;
        }
        if (!hasOldPeers) {
            if (logMINOR) {
                Logger.minor(this, "Not detecting as less than 30 minutes old");
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startDetect() {
        if (logMINOR) {
            Logger.minor(this, "Detecting...");
        }
        IPDetectorPluginManager iPDetectorPluginManager = this;
        synchronized (iPDetectorPluginManager) {
            this.failedRunners.clear();
            for (int i = 0; i < this.plugins.length; ++i) {
                FredPluginIPDetector plugin = this.plugins[i];
                if (this.runners.containsKey(plugin)) continue;
                DetectorRunner d = new DetectorRunner(this.plugins[i]);
                this.runners.put(plugin, d);
                this.node.executor.execute(d, "Plugin detector runner for " + this.plugins[i].getClass());
            }
        }
    }

    public boolean isEmpty() {
        return this.plugins.length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPortForwardPlugin(FredPluginPortForward forward) {
        if (forward == null) {
            throw new NullPointerException();
        }
        IPDetectorPluginManager iPDetectorPluginManager = this;
        synchronized (iPDetectorPluginManager) {
            FredPluginPortForward[] newForwardPlugins = new FredPluginPortForward[this.portForwardPlugins.length + 1];
            System.arraycopy(this.portForwardPlugins, 0, newForwardPlugins, 0, this.portForwardPlugins.length);
            newForwardPlugins[this.portForwardPlugins.length] = forward;
            this.portForwardPlugins = newForwardPlugins;
        }
        if (logMINOR) {
            Logger.minor(this, "Registering a new port forward plugin : " + forward);
        }
        forward.onChangePublicPorts(this.node.getPublicInterfacePorts(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPortForwardPlugin(FredPluginPortForward forward) {
        IPDetectorPluginManager iPDetectorPluginManager = this;
        synchronized (iPDetectorPluginManager) {
            int count = 0;
            for (int i = 0; i < this.portForwardPlugins.length; ++i) {
                if (this.portForwardPlugins[i] != forward) continue;
                ++count;
            }
            if (count == 0) {
                return;
            }
            FredPluginPortForward[] newPlugins = new FredPluginPortForward[this.portForwardPlugins.length - count];
            int x = 0;
            for (int i = 0; i < this.portForwardPlugins.length; ++i) {
                if (this.portForwardPlugins[i] == forward) continue;
                newPlugins[x++] = this.portForwardPlugins[i];
            }
            this.portForwardPlugins = newPlugins;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyPortChange(final Set<ForwardPort> newPorts) {
        FredPluginPortForward[] plugins;
        IPDetectorPluginManager iPDetectorPluginManager = this;
        synchronized (iPDetectorPluginManager) {
            plugins = this.portForwardPlugins;
        }
        for (int i = 0; i < plugins.length; ++i) {
            final FredPluginPortForward plugin = plugins[i];
            this.node.executor.execute(new Runnable(){

                public void run() {
                    try {
                        plugin.onChangePublicPorts(newPorts, IPDetectorPluginManager.this);
                    }
                    catch (Throwable t) {
                        Logger.error(this, "Changing public ports list on " + plugin + " threw: " + t, t);
                    }
                }
            }, "Notify " + plugins[i] + " of ports list change");
        }
    }

    @Override
    public void portForwardStatus(Map<ForwardPort, ForwardPortStatus> statuses) {
        Set<ForwardPort> currentPorts = this.node.getPublicInterfacePorts();
        for (ForwardPort p : currentPorts) {
            ForwardPortStatus status = statuses.get(p);
            if (status == null) continue;
            if (status.status == 3) {
                Logger.normal(this, "Succeeded forwarding " + p.name + " port " + p.portNumber + " for " + p.protocol + " - port forward definitely succeeded " + status.reasonString);
                continue;
            }
            if (status.status == 2) {
                Logger.normal(this, "Probably succeeded forwarding " + p.name + " port " + p.portNumber + " for " + p.protocol + " - port forward probably succeeded " + status.reasonString);
                continue;
            }
            if (status.status == 1) {
                Logger.normal(this, "Maybe succeeded forwarding " + p.name + " port " + p.portNumber + " for " + p.protocol + " - port forward may have succeeded but strongly recommend out of band verification " + status.reasonString);
                continue;
            }
            if (status.status == -2) {
                Logger.error(this, "Failed forwarding " + p.name + " port " + p.portNumber + " for " + p.protocol + " - port forward definitely failed " + status.reasonString);
                continue;
            }
            if (status.status != -1) continue;
            Logger.error(this, "Probably failed forwarding " + p.name + " port " + p.portNumber + " for " + p.protocol + " - port forward probably failed " + status.reasonString);
        }
        this.node.executor.execute(new Runnable(){

            public void run() {
                IPDetectorPluginManager.this.maybeRun();
            }
        }, "Redetect IP after port forward changed");
    }

    public synchronized boolean hasDetectors() {
        return this.plugins.length > 0;
    }

    public void addConnectionTypeBox(HTMLNode contentNode) {
        if (this.node.clientCore == null) {
            return;
        }
        if (this.node.clientCore.alerts == null) {
            return;
        }
        if (this.proxyAlert == null) {
            return;
        }
        if (this.proxyAlert.isValid()) {
            contentNode.addChild(this.node.clientCore.alerts.renderAlert(this.proxyAlert));
        } else {
            Logger.error(this, "start() not called yet?", new Exception("debug"));
        }
    }

    public class DetectorRunner
    implements Runnable {
        final FredPluginIPDetector plugin;

        public DetectorRunner(FredPluginIPDetector detector) {
            this.plugin = detector;
        }

        public void kill() {
            ((IPDetectorPluginManager)IPDetectorPluginManager.this).node.pluginManager.killPlugin((FredPlugin)((Object)this.plugin), 0);
        }

        public void run() {
            Logger.OSThread.logPID(this);
            try {
                this.realRun();
            }
            catch (OutOfMemoryError e) {
                OOMHandler.handleOOM(e);
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t, t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void realRun() {
            if (logMINOR) {
                Logger.minor(this, "Running plugin detection");
            }
            try {
                Vector<DetectedIP> v = new Vector<DetectedIP>();
                DetectedIP[] detected = null;
                try {
                    detected = this.plugin.getAddress();
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught " + t, t);
                }
                if (detected != null) {
                    for (int j = 0; j < detected.length; ++j) {
                        v.add(detected[j]);
                    }
                }
                IPDetectorPluginManager j = IPDetectorPluginManager.this;
                // MONITORENTER : j
                IPDetectorPluginManager.this.lastDetectAttemptEndedTime = System.currentTimeMillis();
                boolean failed = false;
                if (v.isEmpty()) {
                    if (logMINOR) {
                        Logger.minor(this, "No IPs found");
                    }
                    failed = true;
                } else {
                    failed = true;
                    for (DetectedIP ip : v) {
                        if (logMINOR) {
                            Logger.minor(this, "Detected IP: " + ip + " for " + this.plugin);
                        }
                        if (ip.publicAddress == null || !IPUtil.isValidAddress(ip.publicAddress, false)) continue;
                        if (logMINOR) {
                            Logger.minor(this, "Address checked out");
                        }
                        failed = false;
                    }
                }
                if (failed) {
                    if (logMINOR) {
                        Logger.minor(this, "Failed");
                    }
                    IPDetectorPluginManager.this.failedRunners.add(this.plugin);
                    // MONITOREXIT : j
                    Object var15_11 = null;
                    IPDetectorPluginManager iPDetectorPluginManager = IPDetectorPluginManager.this;
                    // MONITORENTER : iPDetectorPluginManager
                    IPDetectorPluginManager.this.runners.remove(this.plugin);
                    if (!IPDetectorPluginManager.this.runners.isEmpty()) {
                        // MONITOREXIT : iPDetectorPluginManager
                        return;
                    }
                    // MONITOREXIT : iPDetectorPluginManager
                    IPDetectorPluginManager.this.detector.hasDetectedPM();
                    return;
                }
                // MONITOREXIT : j
                DetectedIP[] list = v.toArray(new DetectedIP[v.size()]);
                int countOpen = 0;
                int countFullCone = 0;
                int countRestricted = 0;
                int countPortRestricted = 0;
                int countSymmetric = 0;
                int countClosed = 0;
                block26: for (int i = 0; i < list.length; ++i) {
                    Logger.normal(this, "Detected IP: " + list[i].publicAddress + " : type " + list[i].natType);
                    System.out.println("Detected IP: " + list[i].publicAddress + " : type " + list[i].natType);
                    switch (list[i].natType) {
                        case 3: {
                            ++countFullCone;
                            continue block26;
                        }
                        case 2: {
                            ++countOpen;
                            continue block26;
                        }
                        case 8: {
                            ++countClosed;
                            continue block26;
                        }
                        case 1: {
                            continue block26;
                        }
                        case 4: {
                            ++countRestricted;
                            continue block26;
                        }
                        case 5: {
                            ++countPortRestricted;
                            continue block26;
                        }
                        case 6: 
                        case 7: {
                            ++countSymmetric;
                            continue block26;
                        }
                    }
                }
                if (countClosed > 0 && countOpen + countFullCone + countRestricted + countPortRestricted + countSymmetric == 0) {
                    IPDetectorPluginManager.this.proxyAlert.setAlert(IPDetectorPluginManager.this.noConnectionAlert);
                    IPDetectorPluginManager.this.proxyAlert.isValid(true);
                    IPDetectorPluginManager.this.connectionType = (short)8;
                } else if (countSymmetric > 0 && countOpen + countFullCone + countRestricted + countPortRestricted == 0) {
                    IPDetectorPluginManager.this.proxyAlert.setAlert(IPDetectorPluginManager.this.symmetricAlert);
                    IPDetectorPluginManager.this.proxyAlert.isValid(true);
                    IPDetectorPluginManager.this.connectionType = (short)6;
                } else if (countPortRestricted > 0 && countOpen + countFullCone + countRestricted == 0) {
                    IPDetectorPluginManager.this.proxyAlert.setAlert(IPDetectorPluginManager.this.portRestrictedAlert);
                    IPDetectorPluginManager.this.proxyAlert.isValid(true);
                    IPDetectorPluginManager.this.connectionType = (short)5;
                } else if (countRestricted > 0 && countOpen + countFullCone == 0) {
                    IPDetectorPluginManager.this.proxyAlert.setAlert(IPDetectorPluginManager.this.restrictedAlert);
                    IPDetectorPluginManager.this.proxyAlert.isValid(true);
                    IPDetectorPluginManager.this.connectionType = (short)4;
                } else if (countFullCone > 0 && countOpen == 0) {
                    IPDetectorPluginManager.this.proxyAlert.isValid(false);
                    IPDetectorPluginManager.this.connectionType = (short)3;
                } else if (countOpen > 0) {
                    IPDetectorPluginManager.this.proxyAlert.isValid(false);
                }
                IPDetectorPluginManager.this.detector.processDetectedIPs(list);
                if (IPDetectorPluginManager.this.connectionType == 8) {
                    SimpleUserAlert toRegister = null;
                    DetectorRunner detectorRunner = this;
                    // MONITORENTER : detectorRunner
                    if (IPDetectorPluginManager.this.noConnectivityAlert == null) {
                        toRegister = new SimpleUserAlert(false, IPDetectorPluginManager.this.l10n("noConnectivityTitle"), IPDetectorPluginManager.this.l10n("noConnectivity"), IPDetectorPluginManager.this.l10n("noConnectivityShort"), 1);
                        IPDetectorPluginManager.this.noConnectivityAlert = toRegister;
                    }
                    // MONITOREXIT : detectorRunner
                    if (toRegister != null) {
                        ((IPDetectorPluginManager)IPDetectorPluginManager.this).node.clientCore.alerts.register(toRegister);
                    }
                } else {
                    DetectorRunner detectorRunner = this;
                    // MONITORENTER : detectorRunner
                    SimpleUserAlert toKill = IPDetectorPluginManager.this.noConnectivityAlert;
                    IPDetectorPluginManager.this.noConnectivityAlert = null;
                    // MONITOREXIT : detectorRunner
                    if (toKill != null) {
                        ((IPDetectorPluginManager)IPDetectorPluginManager.this).node.clientCore.alerts.unregister(toKill);
                    }
                }
                Object var15_12 = null;
                IPDetectorPluginManager iPDetectorPluginManager = IPDetectorPluginManager.this;
                // MONITORENTER : iPDetectorPluginManager
                IPDetectorPluginManager.this.runners.remove(this.plugin);
                if (!IPDetectorPluginManager.this.runners.isEmpty()) {
                    // MONITOREXIT : iPDetectorPluginManager
                    return;
                }
                // MONITOREXIT : iPDetectorPluginManager
                IPDetectorPluginManager.this.detector.hasDetectedPM();
                return;
            }
            catch (Throwable throwable) {
                Object var15_13 = null;
                IPDetectorPluginManager iPDetectorPluginManager = IPDetectorPluginManager.this;
                // MONITORENTER : iPDetectorPluginManager
                IPDetectorPluginManager.this.runners.remove(this.plugin);
                if (!IPDetectorPluginManager.this.runners.isEmpty()) {
                    // MONITOREXIT : iPDetectorPluginManager
                    return;
                }
                // MONITOREXIT : iPDetectorPluginManager
                IPDetectorPluginManager.this.detector.hasDetectedPM();
                throw throwable;
            }
        }
    }

    public class MyUserAlert
    extends AbstractUserAlert {
        final boolean suggestPortForward;
        private int[] portsNotForwarded;

        public MyUserAlert(String title, String text, boolean suggestPortForward, short code) {
            super(false, title, text, title, null, code, true, L10n.getString("UserAlert.hide"), false, null);
            this.suggestPortForward = suggestPortForward;
            this.portsNotForwarded = new int[0];
        }

        public HTMLNode getHTMLText() {
            HTMLNode div = new HTMLNode("div");
            div.addChild("#", super.getText());
            if (this.suggestPortForward) {
                if (this.portsNotForwarded.length == 1) {
                    L10n.addL10nSubstitution(div, "IPDetectorPluginManager.suggestForwardPortWithLink", new String[]{"link", "/link", "port"}, new String[]{"<a href=\"/?_CHECKED_HTTP_=http://wiki.freenetproject.org/FirewallAndRouterIssues\">", "</a>", Integer.toString(this.portsNotForwarded[0])});
                } else {
                    L10n.addL10nSubstitution(div, "IPDetectorPluginManager.suggestForwardTwoPortsWithLink", new String[]{"link", "/link", "port1", "port2"}, new String[]{"<a href=\"/?_CHECKED_HTTP_=http://wiki.freenetproject.org/FirewallAndRouterIssues\">", "</a>", Integer.toString(this.portsNotForwarded[0]), Integer.toString(this.portsNotForwarded[1])});
                }
            }
            return div;
        }

        public String getText() {
            if (!this.suggestPortForward) {
                return super.getText();
            }
            StringBuilder sb = new StringBuilder();
            sb.append(super.getText());
            if (this.portsNotForwarded.length == 1) {
                sb.append(IPDetectorPluginManager.this.l10n("suggestForwardPort", "port", Integer.toString(Math.abs(this.portsNotForwarded[0]))));
            } else if (this.portsNotForwarded.length >= 2) {
                sb.append(IPDetectorPluginManager.this.l10n("suggestForwardTwoPorts", new String[]{"port1", "port2"}, new String[]{Integer.toString(Math.abs(this.portsNotForwarded[0])), Integer.toString(Math.abs(this.portsNotForwarded[1]))}));
                if (this.portsNotForwarded.length > 2) {
                    Logger.error(this, "Not able to tell user about more than 2 ports to forward! (" + this.portsNotForwarded.length + ")");
                }
            }
            return sb.toString();
        }

        public void isValid(boolean validity) {
            this.valid = validity;
        }

        public boolean isValid() {
            this.portsNotForwarded = IPDetectorPluginManager.this.getUDPPortsNotForwarded();
            return this.valid && this.portsNotForwarded.length > 0;
        }

        public void onDismiss() {
            this.valid = false;
        }

        public boolean userCanDismiss() {
            return false;
        }
    }

    public class PortForwardAlert
    implements UserAlert {
        private int[] portsNotForwarded;
        private short maxPriorityShown;
        private int maxPortsLength;
        private boolean valid;

        public String anchor() {
            return "port-forward:" + super.hashCode();
        }

        public String dismissButtonText() {
            return L10n.getString("UserAlert.hide");
        }

        public HTMLNode getHTMLText() {
            String keySuffix;
            HTMLNode div = new HTMLNode("div");
            String url = GenericReadFilterCallback.escapeURL(HTMLEncoder.encode(IPDetectorPluginManager.this.l10n("portForwardHelpURL")));
            boolean maybeForwarded = true;
            for (int i = 0; i < this.portsNotForwarded.length; ++i) {
                if (this.portsNotForwarded[i] >= 0) continue;
                maybeForwarded = false;
            }
            String string = keySuffix = maybeForwarded ? "MaybeForwarded" : "NotForwarded";
            if (this.portsNotForwarded.length == 1) {
                L10n.addL10nSubstitution(div, "IPDetectorPluginManager.forwardPort" + keySuffix, new String[]{"port", "link", "/link"}, new String[]{Integer.toString(Math.abs(this.portsNotForwarded[0])), "<a href=\"" + url + "\">", "</a>"});
            } else if (this.portsNotForwarded.length == 2) {
                L10n.addL10nSubstitution(div, "IPDetectorPluginManager.forwardTwoPorts" + keySuffix, new String[]{"port1", "port2", "link", "/link"}, new String[]{Integer.toString(Math.abs(this.portsNotForwarded[0])), Integer.toString(Math.abs(this.portsNotForwarded[1])), "<a href=\"" + url + "\">", "</a>"});
            } else {
                Logger.error(this, "Unknown number of ports to forward: " + this.portsNotForwarded.length);
            }
            if (this.innerGetPriorityClass() == 1) {
                div.addChild("#", " " + IPDetectorPluginManager.this.l10n("symmetricPS"));
            }
            return div;
        }

        public short getPriorityClass() {
            return this.innerGetPriorityClass();
        }

        public short innerGetPriorityClass() {
            if (IPDetectorPluginManager.this.connectionType == 6 || IPDetectorPluginManager.this.connectionType == 7) {
                return 1;
            }
            if (this.portsNotForwarded != null) {
                for (int i = 0; i < this.portsNotForwarded.length; ++i) {
                    if (this.portsNotForwarded[i] >= 0) continue;
                    return 1;
                }
            }
            return 3;
        }

        public String getShortText() {
            String keySuffix;
            String prefix = this.innerGetPriorityClass() == 1 ? IPDetectorPluginManager.this.l10n("seriousConnectionProblems") : IPDetectorPluginManager.this.l10n("connectionProblems");
            prefix = prefix + " ";
            boolean maybeForwarded = true;
            for (int i = 0; i < this.portsNotForwarded.length; ++i) {
                if (this.portsNotForwarded[i] >= 0) continue;
                maybeForwarded = false;
            }
            String string = keySuffix = maybeForwarded ? "MaybeForwarded" : "NotForwarded";
            if (this.portsNotForwarded.length == 1) {
                return prefix + IPDetectorPluginManager.this.l10n("forwardPortShort" + keySuffix, "port", Integer.toString(Math.abs(this.portsNotForwarded[0])));
            }
            if (this.portsNotForwarded.length == 2) {
                return prefix + IPDetectorPluginManager.this.l10n("forwardTwoPortsShort" + keySuffix, new String[]{"port1", "port2"}, new String[]{Integer.toString(Math.abs(this.portsNotForwarded[0])), Integer.toString(Math.abs(this.portsNotForwarded[1]))});
            }
            Logger.error(this, "Unknown number of ports to forward: " + this.portsNotForwarded.length);
            return "";
        }

        public String getText() {
            String keySuffix;
            String url = IPDetectorPluginManager.this.l10n("portForwardHelpURL");
            boolean maybeForwarded = true;
            for (int i = 0; i < this.portsNotForwarded.length; ++i) {
                if (this.portsNotForwarded[i] >= 0) continue;
                maybeForwarded = false;
            }
            String string = keySuffix = maybeForwarded ? "MaybeForwarded" : "NotForwarded";
            if (this.portsNotForwarded.length == 1) {
                return IPDetectorPluginManager.this.l10n("forwardPort" + keySuffix, new String[]{"port", "link", "/link"}, new String[]{Integer.toString(Math.abs(this.portsNotForwarded[0])), "", " (" + url + ")"});
            }
            if (this.portsNotForwarded.length == 2) {
                return IPDetectorPluginManager.this.l10n("forwardTwoPorts" + keySuffix, new String[]{"port1", "port2", "link", "/link"}, new String[]{Integer.toString(Math.abs(this.portsNotForwarded[0])), Integer.toString(Math.abs(this.portsNotForwarded[1])), "", " (" + url + ")"});
            }
            Logger.error(this, "Unknown number of ports to forward: " + this.portsNotForwarded.length);
            return "";
        }

        public String getTitle() {
            return this.getShortText();
        }

        public Object getUserIdentifier() {
            return IPDetectorPluginManager.this;
        }

        public boolean isValid() {
            short prio;
            this.portsNotForwarded = IPDetectorPluginManager.this.getUDPPortsNotForwarded();
            if (this.portsNotForwarded.length > this.maxPortsLength) {
                this.valid = true;
                this.maxPortsLength = this.portsNotForwarded.length;
            }
            if ((prio = this.innerGetPriorityClass()) < this.maxPriorityShown) {
                this.valid = true;
                this.maxPriorityShown = prio;
            }
            if (this.portsNotForwarded.length == 0) {
                return false;
            }
            return this.valid;
        }

        public void isValid(boolean validity) {
            this.valid = validity;
        }

        public void onDismiss() {
            this.valid = false;
        }

        public boolean shouldUnregisterOnDismiss() {
            return false;
        }

        public boolean userCanDismiss() {
            return true;
        }

        public boolean isEventNotification() {
            return false;
        }
    }
}

