/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.node.Node;
import freenet.node.NodeDispatcher;
import freenet.node.ProbeCallback;
import freenet.support.Logger;
import java.util.Arrays;

public class GlobalProbe
implements Runnable {
    double lastLocation = 0.0;
    long lastTime;
    int lastHops;
    private boolean doneSomething = false;
    final ProbeCallback cb;
    final Node node;
    int ctr;

    public GlobalProbe(Node n) {
        this.node = n;
        this.cb = new ProbeCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCompleted(String reason, double target, double best, double nearest, long id, short counter, short uniqueCount, short linearCount) {
                String msg = "Completed probe request: " + target + " -> " + best + "\r\nNearest actually hit " + nearest + ", " + counter + " nodes (" + linearCount + " hops" + uniqueCount + " unique nodes) in " + (System.currentTimeMillis() - GlobalProbe.this.lastTime) + ", id " + id + "\r\n";
                Logger.error(this, msg);
                GlobalProbe globalProbe = GlobalProbe.this;
                synchronized (globalProbe) {
                    GlobalProbe.this.doneSomething = true;
                    GlobalProbe.this.lastLocation = best;
                    GlobalProbe.this.lastHops = counter;
                    GlobalProbe.this.notifyAll();
                }
            }

            public void onTrace(long uid, double target, double nearest, double best, short htl, short counter, double location, long nodeUID, double[] peerLocs, long[] peerUIDs, double[] locsNotVisited, short forkCount, short linearCount, String reason, long prevUID) {
                String msg = "Probe trace: UID=" + uid + " target=" + target + " nearest=" + nearest + " best=" + best + " htl=" + htl + " counter=" + counter + " location=" + location + " node UID=" + nodeUID + " prev UID=" + prevUID + " peers=" + NodeDispatcher.peersUIDsToString(peerUIDs, peerLocs) + " locs not visited: " + Arrays.toString(locsNotVisited) + " fork count: " + forkCount + " linear count: " + linearCount + " from " + reason;
                Logger.normal(this, msg);
            }

            public void onRejectOverload() {
                Logger.normal(this, "Probe trace received rejected overload");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Logger.OSThread.logPID(this);
        GlobalProbe globalProbe = this;
        synchronized (globalProbe) {
            double prevLoc = this.lastLocation = 0.0;
            while (true) {
                this.doneSomething = false;
                this.lastTime = System.currentTimeMillis();
                this.node.dispatcher.startProbe(this.lastLocation, this.cb);
                for (int i = 0; i < 20 && !this.doneSomething; ++i) {
                    try {
                        this.wait(10000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (!this.doneSomething) {
                    this.error("Stalled on " + this.lastLocation + " , waiting some more.");
                    try {
                        this.wait(100000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (!this.doneSomething) {
                        this.error("Still no response to probe request, trying again.");
                        continue;
                    }
                }
                if (Math.abs(this.lastLocation - prevLoc) < 9.9E-324) {
                    this.error("Location is same as previous ! Sleeping then trying again");
                    try {
                        this.wait(100000L);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                this.output(this.lastLocation, this.lastHops);
                prevLoc = this.lastLocation;
                if (this.lastLocation > 1.0 || Math.abs(this.lastLocation - 1.0) < 9.9E-324) break;
                ++this.ctr;
                try {
                    this.wait(10000L);
                }
                catch (InterruptedException e) {}
            }
        }
    }

    private void output(double loc, int hops) {
        double estimatedNodes = ((double)this.ctr + 1.0) / loc;
        Logger.error(this, "LOCATION " + this.ctr + ": " + loc + " - estimated nodes: " + estimatedNodes + " (" + hops + " hops)");
        System.err.println("LOCATION " + this.ctr + ": " + loc + " - estimated nodes: " + estimatedNodes + " (" + hops + " hops)");
    }

    private void error(String string) {
        Logger.error(this, string);
        System.err.println("GlobalProbe error: " + string);
    }
}

