/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.crypt.DSAPublicKey;
import freenet.crypt.SHA256;
import freenet.store.PubkeyStore;
import freenet.support.ByteArrayWrapper;
import freenet.support.HexUtil;
import freenet.support.LRUHashtable;
import freenet.support.Logger;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Arrays;

public class GetPubkey {
    private static volatile boolean logMINOR;
    private static final boolean USE_RAM_PUBKEYS_CACHE = true;
    private static final int MAX_MEMORY_CACHED_PUBKEYS = 1000;
    private final LRUHashtable<ByteArrayWrapper, DSAPublicKey> cachedPubKeys = new LRUHashtable();
    private PubkeyStore pubKeyDatastore;
    private PubkeyStore pubKeyDatacache;

    GetPubkey() {
    }

    void setDataStore(PubkeyStore pubKeyDatastore, PubkeyStore pubKeyDatacache) {
        this.pubKeyDatastore = pubKeyDatastore;
        this.pubKeyDatacache = pubKeyDatacache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DSAPublicKey getKey(byte[] hash) {
        ByteArrayWrapper w = new ByteArrayWrapper(hash);
        if (logMINOR) {
            Logger.minor(this, "Getting pubkey: " + HexUtil.bytesToHex(hash));
        }
        LRUHashtable<ByteArrayWrapper, DSAPublicKey> lRUHashtable = this.cachedPubKeys;
        synchronized (lRUHashtable) {
            DSAPublicKey key = this.cachedPubKeys.get(w);
            if (key != null) {
                this.cachedPubKeys.push(w, key);
                if (logMINOR) {
                    Logger.minor(this, "Got " + HexUtil.bytesToHex(hash) + " from cache");
                }
                return key;
            }
        }
        try {
            DSAPublicKey key = this.pubKeyDatastore.fetch(hash, false);
            if (key == null) {
                key = this.pubKeyDatacache.fetch(hash, false);
            }
            if (key != null) {
                this.cacheKey(hash, key, false);
                if (logMINOR) {
                    Logger.minor(this, "Got " + HexUtil.bytesToHex(hash) + " from store");
                }
            }
            return key;
        }
        catch (IOException e) {
            Logger.error(this, "Error accessing pubkey store: " + e, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheKey(byte[] hash, DSAPublicKey key, boolean deep) {
        if (logMINOR) {
            Logger.minor(this, "Cache key: " + HexUtil.bytesToHex(hash) + " : " + key);
        }
        ByteArrayWrapper w = new ByteArrayWrapper(hash);
        LRUHashtable<ByteArrayWrapper, DSAPublicKey> lRUHashtable = this.cachedPubKeys;
        synchronized (lRUHashtable) {
            DSAPublicKey key2 = this.cachedPubKeys.get(w);
            if (key2 != null && !key2.equals(key)) {
                MessageDigest md256 = SHA256.getMessageDigest();
                try {
                    byte[] hashCheck = md256.digest(key.asBytes());
                    if (Arrays.equals(hashCheck, hash)) {
                        Logger.error(this, "Hash is correct!!!");
                        byte[] oldHash = md256.digest(key2.asBytes());
                        if (Arrays.equals(oldHash, hash)) {
                            Logger.error(this, "Old hash is correct too!! - Bug in DSAPublicKey.equals() or SHA-256 collision!");
                        } else {
                            Logger.error(this, "Old hash is wrong!");
                            this.cachedPubKeys.removeKey(w);
                            this.cacheKey(hash, key, deep);
                        }
                    } else {
                        Logger.error(this, "New hash is wrong");
                    }
                    Object var11_11 = null;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    SHA256.returnMessageDigest(md256);
                    throw throwable;
                }
                SHA256.returnMessageDigest(md256);
                throw new IllegalArgumentException("Wrong hash?? Already have different key with same hash!");
            }
            this.cachedPubKeys.push(w, key);
            while (this.cachedPubKeys.size() > 1000) {
                this.cachedPubKeys.popKey();
            }
        }
        try {
            if (deep) {
                this.pubKeyDatastore.put(hash, key);
                this.pubKeyDatastore.fetch(hash, true);
            }
            this.pubKeyDatacache.put(hash, key);
            this.pubKeyDatacache.fetch(hash, true);
        }
        catch (IOException e) {
            Logger.error(this, "Error accessing pubkey store: " + e, e);
        }
    }

    static {
        Logger.registerClass(GetPubkey.class);
    }
}

