/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.keys.Key;
import freenet.node.PeerNode;
import freenet.node.TimedOutNodesList;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashSet;

class FailureTableEntry
implements TimedOutNodesList {
    final Key key;
    long creationTime;
    long receivedTime;
    long sentTime;
    WeakReference<PeerNode>[] requestorNodes;
    long[] requestorTimes;
    long[] requestorBootIDs;
    WeakReference<PeerNode>[] requestedNodes;
    double[] requestedLocs;
    long[] requestedBootIDs;
    long[] requestedTimes;
    long[] requestedTimeouts;
    short[] requestedTimeoutHTLs;
    private static volatile boolean logMINOR;
    static final int MAX_TIME_BETWEEN_REQUEST_AND_OFFER = 3600000;
    public static final long[] EMPTY_LONG_ARRAY;
    public static final short[] EMPTY_SHORT_ARRAY;
    public static final double[] EMPTY_DOUBLE_ARRAY;
    public static final WeakReference<PeerNode>[] EMPTY_WEAK_REFERENCE;

    FailureTableEntry(Key key) {
        long now;
        this.key = key;
        if (key == null) {
            throw new NullPointerException();
        }
        this.creationTime = now = System.currentTimeMillis();
        this.receivedTime = -1L;
        this.sentTime = -1L;
        this.requestorNodes = EMPTY_WEAK_REFERENCE;
        this.requestorTimes = EMPTY_LONG_ARRAY;
        this.requestorBootIDs = EMPTY_LONG_ARRAY;
        this.requestedNodes = EMPTY_WEAK_REFERENCE;
        this.requestedLocs = EMPTY_DOUBLE_ARRAY;
        this.requestedBootIDs = EMPTY_LONG_ARRAY;
        this.requestedTimes = EMPTY_LONG_ARRAY;
        this.requestedTimeouts = EMPTY_LONG_ARRAY;
        this.requestedTimeoutHTLs = EMPTY_SHORT_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(short htl2, PeerNode[] requestors, PeerNode[] requestedFrom, int timeout, long now) {
        if (logMINOR) {
            Logger.minor(this, "onFailure(" + htl2 + ",requestors=" + Arrays.toString(requestors) + ",requestedFrom=" + Arrays.toString(requestedFrom) + ",timeout=" + timeout);
        }
        FailureTableEntry failureTableEntry = this;
        synchronized (failureTableEntry) {
            int i;
            if (requestors != null) {
                for (i = 0; i < requestors.length; ++i) {
                    this.addRequestor(requestors[i], now);
                }
            }
            if (requestedFrom != null) {
                for (i = 0; i < requestedFrom.length; ++i) {
                    this.addRequestedFrom(requestedFrom[i], now);
                }
            }
        }
    }

    public synchronized void failedTo(PeerNode routedTo, int timeout, long now, short htl) {
        int idx;
        long curTimeoutTime;
        long newTimeoutTime;
        if (logMINOR) {
            Logger.minor(this, "Failed sending request to " + routedTo.shortToString() + " : timeout " + timeout);
        }
        if ((newTimeoutTime = now + (long)timeout) > (curTimeoutTime = this.requestedTimeouts[idx = this.addRequestedFrom(routedTo, now)])) {
            this.requestedTimeouts[idx] = newTimeoutTime;
            this.requestedTimeoutHTLs[idx] = htl;
        }
    }

    synchronized int addRequestor(PeerNode requestor, long now) {
        int i;
        int notIncluded;
        if (logMINOR) {
            Logger.minor(this, "Adding requestors: " + requestor + " at " + now);
        }
        this.receivedTime = now;
        boolean includedAlready = false;
        int nulls = 0;
        int ret = -1;
        for (int i2 = 0; i2 < this.requestorNodes.length; ++i2) {
            PeerNode got;
            PeerNode peerNode = got = this.requestorNodes[i2] == null ? null : (PeerNode)this.requestorNodes[i2].get();
            if (got == requestor) {
                includedAlready = true;
                this.requestorTimes[i2] = now;
                this.requestorBootIDs[i2] = requestor.getBootID();
                ret = i2;
                break;
            }
            if (got != null && got.getBootID() != this.requestorBootIDs[i2] || now - this.requestorTimes[i2] > 3600000L) {
                this.requestorNodes[i2] = null;
                got = null;
            }
            if (got != null) continue;
            ++nulls;
        }
        if (nulls == 0 && includedAlready) {
            return ret;
        }
        int n = notIncluded = includedAlready ? 0 : 1;
        if (nulls == 1 && !includedAlready) {
            for (int i3 = 0; i3 < this.requestorNodes.length; ++i3) {
                if (this.requestorNodes[i3] != null && this.requestorNodes[i3].get() != null) continue;
                this.requestorNodes[i3] = requestor.myRef;
                this.requestorTimes[i3] = now;
                this.requestorBootIDs[i3] = requestor.getBootID();
                return i3;
            }
        }
        WeakReference[] newRequestorNodes = new WeakReference[this.requestorNodes.length + notIncluded - nulls];
        long[] newRequestorTimes = new long[this.requestorNodes.length + notIncluded - nulls];
        long[] newRequestorBootIDs = new long[this.requestorNodes.length + notIncluded - nulls];
        int toIndex = 0;
        for (i = 0; i < this.requestorNodes.length; ++i) {
            PeerNode pn;
            WeakReference<PeerNode> ref = this.requestorNodes[i];
            PeerNode peerNode = pn = ref == null ? null : (PeerNode)ref.get();
            if (pn == null) continue;
            if (pn == requestor) {
                ret = toIndex;
            }
            newRequestorNodes[toIndex] = this.requestorNodes[i];
            newRequestorTimes[toIndex] = this.requestorTimes[i];
            newRequestorBootIDs[toIndex] = this.requestorBootIDs[i];
            ++toIndex;
        }
        if (!includedAlready) {
            newRequestorNodes[toIndex] = requestor.myRef;
            newRequestorTimes[toIndex] = now;
            newRequestorBootIDs[toIndex] = requestor.getBootID();
            ret = toIndex++;
        }
        for (i = toIndex; i < newRequestorNodes.length; ++i) {
            newRequestorNodes[i] = null;
        }
        if (toIndex > newRequestorNodes.length + 2) {
            WeakReference[] newNewRequestorNodes = new WeakReference[toIndex];
            long[] newNewRequestorTimes = new long[toIndex];
            long[] newNewRequestorBootIDs = new long[toIndex];
            System.arraycopy(newRequestorNodes, 0, newNewRequestorNodes, 0, toIndex);
            System.arraycopy(newRequestorTimes, 0, newNewRequestorTimes, 0, toIndex);
            System.arraycopy(newRequestorBootIDs, 0, newNewRequestorBootIDs, 0, toIndex);
            newRequestorNodes = newNewRequestorNodes;
            newRequestorTimes = newNewRequestorTimes;
            newRequestorBootIDs = newNewRequestorBootIDs;
        }
        this.requestorNodes = newRequestorNodes;
        this.requestorTimes = newRequestorTimes;
        this.requestorBootIDs = newRequestorBootIDs;
        return ret;
    }

    private synchronized int addRequestedFrom(PeerNode requestedFrom, long now) {
        int i;
        int notIncluded;
        if (logMINOR) {
            Logger.minor(this, "Adding requested from: " + requestedFrom + " at " + now);
        }
        this.sentTime = now;
        boolean includedAlready = false;
        int nulls = 0;
        int ret = -1;
        for (int i2 = 0; i2 < this.requestedNodes.length; ++i2) {
            PeerNode got;
            PeerNode peerNode = got = this.requestedNodes[i2] == null ? null : (PeerNode)this.requestedNodes[i2].get();
            if (got == requestedFrom) {
                includedAlready = true;
                this.requestedLocs[i2] = requestedFrom.getLocation();
                this.requestedBootIDs[i2] = requestedFrom.getBootID();
                this.requestedTimes[i2] = now;
                ret = i2;
                break;
            }
            if (got != null) continue;
            ++nulls;
        }
        if (includedAlready && nulls == 0) {
            return ret;
        }
        int n = notIncluded = includedAlready ? 0 : 1;
        if (nulls == 1 && !includedAlready) {
            for (int i3 = 0; i3 < this.requestedNodes.length; ++i3) {
                if (this.requestedNodes[i3] != null && this.requestedNodes[i3].get() != null) continue;
                this.requestedNodes[i3] = requestedFrom.myRef;
                this.requestedLocs[i3] = requestedFrom.getLocation();
                this.requestedBootIDs[i3] = requestedFrom.getBootID();
                this.requestedTimes[i3] = now;
                this.requestedTimeouts[i3] = -1L;
                this.requestedTimeoutHTLs[i3] = -1;
                return i3;
            }
        }
        WeakReference[] newRequestedNodes = new WeakReference[this.requestedNodes.length + notIncluded - nulls];
        double[] newRequestedLocs = new double[this.requestedNodes.length + notIncluded - nulls];
        long[] newRequestedBootIDs = new long[this.requestedNodes.length + notIncluded - nulls];
        long[] newRequestedTimes = new long[this.requestedNodes.length + notIncluded - nulls];
        long[] newRequestedTimeouts = new long[this.requestedNodes.length + notIncluded - nulls];
        short[] newRequestedTimeoutHTLs = new short[this.requestedNodes.length + notIncluded - nulls];
        int toIndex = 0;
        for (i = 0; i < this.requestedNodes.length; ++i) {
            PeerNode pn;
            WeakReference<PeerNode> ref = this.requestedNodes[i];
            PeerNode peerNode = pn = ref == null ? null : (PeerNode)ref.get();
            if (pn == null) continue;
            if (pn == requestedFrom) {
                ret = toIndex;
            }
            newRequestedNodes[toIndex] = this.requestedNodes[i];
            newRequestedTimes[toIndex] = this.requestedTimes[i];
            newRequestedBootIDs[toIndex] = this.requestedBootIDs[i];
            newRequestedLocs[toIndex] = this.requestedLocs[i];
            newRequestedTimeouts[toIndex] = this.requestedTimeouts[i];
            newRequestedTimeoutHTLs[toIndex] = this.requestedTimeoutHTLs[i];
            ++toIndex;
        }
        if (!includedAlready) {
            ret = toIndex;
            newRequestedNodes[toIndex] = requestedFrom.myRef;
            newRequestedTimes[toIndex] = now;
            newRequestedBootIDs[toIndex] = requestedFrom.getBootID();
            newRequestedLocs[toIndex] = requestedFrom.getLocation();
            newRequestedTimeouts[toIndex] = -1L;
            newRequestedTimeoutHTLs[toIndex] = -1;
            ret = toIndex++;
        }
        for (i = toIndex; i < newRequestedNodes.length; ++i) {
            newRequestedNodes[i] = null;
        }
        if (toIndex > newRequestedNodes.length + 2) {
            WeakReference[] newNewRequestedNodes = new WeakReference[toIndex];
            double[] newNewRequestedLocs = new double[toIndex];
            long[] newNewRequestedBootIDs = new long[toIndex];
            long[] newNewRequestedTimes = new long[toIndex];
            long[] newNewRequestedTimeouts = new long[toIndex];
            short[] newNewRequestedTimeoutHTLs = new short[toIndex];
            System.arraycopy(newRequestedNodes, 0, newNewRequestedNodes, 0, toIndex);
            System.arraycopy(newRequestedLocs, 0, newNewRequestedLocs, 0, toIndex);
            System.arraycopy(newRequestedBootIDs, 0, newNewRequestedBootIDs, 0, toIndex);
            System.arraycopy(newRequestedTimes, 0, newNewRequestedTimes, 0, toIndex);
            System.arraycopy(newRequestedTimeouts, 0, newNewRequestedTimeouts, 0, toIndex);
            System.arraycopy(newRequestedTimeoutHTLs, 0, newNewRequestedTimeoutHTLs, 0, toIndex);
            newRequestedNodes = newNewRequestedNodes;
            newRequestedLocs = newNewRequestedLocs;
            newRequestedBootIDs = newNewRequestedBootIDs;
            newRequestedTimes = newNewRequestedTimes;
            newRequestedTimeouts = newNewRequestedTimeouts;
            newRequestedTimeoutHTLs = newNewRequestedTimeoutHTLs;
        }
        this.requestedNodes = newRequestedNodes;
        this.requestedLocs = newRequestedLocs;
        this.requestedBootIDs = newRequestedBootIDs;
        this.requestedTimes = newRequestedTimes;
        this.requestedTimeouts = newRequestedTimeouts;
        this.requestedTimeoutHTLs = newRequestedTimeoutHTLs;
        return ret;
    }

    public synchronized void offer() {
        PeerNode pn;
        WeakReference<PeerNode> ref;
        int i;
        HashSet<PeerNode> set = new HashSet<PeerNode>();
        if (logMINOR) {
            Logger.minor(this, "Sending offers to nodes which requested the key from us:");
        }
        for (i = 0; i < this.requestorNodes.length; ++i) {
            ref = this.requestorNodes[i];
            if (ref == null || (pn = (PeerNode)ref.get()) == null || pn.getBootID() != this.requestorBootIDs[i]) continue;
            if (!set.add(pn)) {
                Logger.error(this, "Node is in requestorNodes twice: " + pn);
            }
            pn.offer(this.key);
        }
        if (logMINOR) {
            Logger.minor(this, "Sending offers to nodes which we sent the key to:");
        }
        for (i = 0; i < this.requestedNodes.length; ++i) {
            ref = this.requestedNodes[i];
            if (ref == null || (pn = (PeerNode)ref.get()) == null || pn.getBootID() != this.requestedBootIDs[i] || set.contains(pn)) continue;
            pn.offer(this.key);
        }
    }

    public synchronized boolean othersWant(PeerNode peer) {
        boolean anyValid = false;
        for (int i = 0; i < this.requestorNodes.length; ++i) {
            WeakReference<PeerNode> ref = this.requestorNodes[i];
            if (ref == null) continue;
            PeerNode pn = (PeerNode)ref.get();
            if (pn == null) {
                this.requestorNodes[i] = null;
                continue;
            }
            long bootID = pn.getBootID();
            if (bootID != this.requestorBootIDs[i]) {
                this.requestorNodes[i] = null;
                continue;
            }
            anyValid = true;
        }
        if (!anyValid) {
            this.requestorNodes = EMPTY_WEAK_REFERENCE;
            this.requestorBootIDs = EMPTY_LONG_ARRAY;
            this.requestorTimes = EMPTY_LONG_ARRAY;
        }
        return anyValid;
    }

    public synchronized boolean askedByPeer(PeerNode peer, long now) {
        boolean anyValid = false;
        boolean ret = false;
        for (int i = 0; i < this.requestorNodes.length; ++i) {
            WeakReference<PeerNode> ref = this.requestorNodes[i];
            if (ref == null) continue;
            PeerNode pn = (PeerNode)ref.get();
            if (pn == null) {
                this.requestorNodes[i] = null;
                continue;
            }
            long bootID = pn.getBootID();
            if (bootID != this.requestorBootIDs[i]) {
                this.requestorNodes[i] = null;
                continue;
            }
            if (now - this.requestorTimes[i] >= 3600000L) continue;
            if (pn == peer) {
                ret = true;
            }
            anyValid = true;
        }
        if (!anyValid) {
            this.requestorNodes = EMPTY_WEAK_REFERENCE;
            this.requestorBootIDs = EMPTY_LONG_ARRAY;
            this.requestorTimes = EMPTY_LONG_ARRAY;
        }
        return ret;
    }

    public synchronized boolean askedFromPeer(PeerNode peer, long now) {
        boolean anyValid = false;
        boolean ret = false;
        for (int i = 0; i < this.requestedNodes.length; ++i) {
            WeakReference<PeerNode> ref = this.requestedNodes[i];
            if (ref == null) continue;
            PeerNode pn = (PeerNode)ref.get();
            if (pn == null) {
                this.requestedNodes[i] = null;
                continue;
            }
            long bootID = pn.getBootID();
            if (bootID != this.requestedBootIDs[i]) {
                this.requestedNodes[i] = null;
                continue;
            }
            anyValid = true;
            if (now - this.requestedTimes[i] >= 3600000L) continue;
            if (pn == peer) {
                ret = true;
            }
            anyValid = true;
        }
        if (!anyValid) {
            this.requestedNodes = EMPTY_WEAK_REFERENCE;
            this.requestedTimeouts = EMPTY_LONG_ARRAY;
            this.requestedBootIDs = EMPTY_LONG_ARRAY;
            this.requestedTimes = this.requestedBootIDs;
            this.requestedTimeoutHTLs = EMPTY_SHORT_ARRAY;
        }
        return ret;
    }

    public synchronized boolean isEmpty(long now) {
        if (this.requestedNodes.length > 0) {
            return false;
        }
        return this.requestorNodes.length <= 0;
    }

    public synchronized long getTimeoutTime(PeerNode peer) {
        for (int i = 0; i < this.requestedNodes.length; ++i) {
            WeakReference<PeerNode> ref = this.requestedNodes[i];
            if (ref == null || ref.get() != peer) continue;
            return this.requestedTimeouts[i];
        }
        return -1L;
    }

    public synchronized boolean cleanup() {
        long now = System.currentTimeMillis();
        boolean empty = this.cleanupRequestor(now);
        return empty &= this.cleanupRequested(now);
    }

    private boolean cleanupRequestor(long now) {
        boolean empty = true;
        int x = 0;
        for (int i = 0; i < this.requestorNodes.length; ++i) {
            long bootID;
            PeerNode pn;
            WeakReference<PeerNode> ref = this.requestorNodes[i];
            if (ref == null || (pn = (PeerNode)ref.get()) == null || (bootID = pn.getBootID()) != this.requestorBootIDs[i] || !pn.isConnected() || now - this.requestorTimes[i] > 3600000L) continue;
            empty = false;
            this.requestorNodes[x] = this.requestorNodes[i];
            this.requestorTimes[x] = this.requestorTimes[i];
            this.requestorBootIDs[x] = this.requestorBootIDs[i];
            ++x;
        }
        if (x < this.requestorNodes.length) {
            WeakReference[] newRequestorNodes = new WeakReference[x];
            long[] newRequestorTimes = new long[x];
            long[] newRequestorBootIDs = new long[x];
            System.arraycopy(this.requestorNodes, 0, newRequestorNodes, 0, x);
            System.arraycopy(this.requestorTimes, 0, newRequestorTimes, 0, x);
            System.arraycopy(this.requestorBootIDs, 0, newRequestorBootIDs, 0, x);
            this.requestorNodes = newRequestorNodes;
            this.requestorTimes = newRequestorTimes;
            this.requestorBootIDs = newRequestorBootIDs;
        }
        return empty;
    }

    private boolean cleanupRequested(long now) {
        boolean empty = true;
        int x = 0;
        for (int i = 0; i < this.requestedNodes.length; ++i) {
            long bootID;
            PeerNode pn;
            WeakReference<PeerNode> ref = this.requestedNodes[i];
            if (ref == null || (pn = (PeerNode)ref.get()) == null || (bootID = pn.getBootID()) != this.requestedBootIDs[i] || !pn.isConnected() || now - this.requestedTimes[i] > 3600000L) continue;
            empty = false;
            this.requestedNodes[x] = this.requestedNodes[i];
            this.requestedTimes[x] = this.requestedTimes[i];
            this.requestedBootIDs[x] = this.requestedBootIDs[i];
            this.requestedLocs[x] = this.requestedLocs[i];
            if (now < this.requestedTimeouts[x]) {
                this.requestedTimeouts[x] = this.requestedTimeouts[i];
                this.requestedTimeoutHTLs[x] = this.requestedTimeoutHTLs[i];
            } else {
                this.requestedTimeouts[x] = -1L;
                this.requestedTimeoutHTLs[x] = -1;
            }
            ++x;
        }
        if (x < this.requestedNodes.length) {
            WeakReference[] newRequestedNodes = new WeakReference[x];
            long[] newRequestedTimes = new long[x];
            long[] newRequestedBootIDs = new long[x];
            double[] newRequestedLocs = new double[x];
            long[] newRequestedTimeouts = new long[x];
            short[] newRequestedTimeoutHTLs = new short[x];
            System.arraycopy(this.requestedNodes, 0, newRequestedNodes, 0, x);
            System.arraycopy(this.requestedTimes, 0, newRequestedTimes, 0, x);
            System.arraycopy(this.requestedBootIDs, 0, newRequestedBootIDs, 0, x);
            System.arraycopy(this.requestedLocs, 0, newRequestedLocs, 0, x);
            System.arraycopy(this.requestedTimeouts, 0, newRequestedTimeouts, 0, x);
            System.arraycopy(this.requestedTimeoutHTLs, 0, newRequestedTimeoutHTLs, 0, x);
            this.requestedNodes = newRequestedNodes;
            this.requestedTimes = newRequestedTimes;
            this.requestedBootIDs = newRequestedBootIDs;
            this.requestedLocs = newRequestedLocs;
            this.requestedTimeouts = newRequestedTimeouts;
            this.requestedTimeoutHTLs = newRequestedTimeoutHTLs;
        }
        return empty;
    }

    public boolean isEmpty() {
        return this.isEmpty(System.currentTimeMillis());
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
        EMPTY_LONG_ARRAY = new long[0];
        EMPTY_SHORT_ARRAY = new short[0];
        EMPTY_DOUBLE_ARRAY = new double[0];
        EMPTY_WEAK_REFERENCE = new WeakReference[0];
    }
}

