/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.Message;
import freenet.io.comm.NotConnectedException;
import freenet.io.xfer.BlockTransmitter;
import freenet.io.xfer.PartiallyReceivedBlock;
import freenet.io.xfer.WaitedTooLongException;
import freenet.keys.CHKBlock;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.NodeCHK;
import freenet.keys.NodeSSK;
import freenet.keys.SSKBlock;
import freenet.node.FailureTableEntry;
import freenet.node.Node;
import freenet.node.OfferReplyTag;
import freenet.node.PeerNode;
import freenet.node.PrioRunnable;
import freenet.node.SyncSendWaitedTooLongException;
import freenet.node.TimedOutNodesList;
import freenet.support.LRUHashtable;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.OOMHandler;
import freenet.support.OOMHook;
import freenet.support.SerialExecutor;
import java.lang.ref.WeakReference;
import java.util.Vector;

public class FailureTable
implements OOMHook {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private final LRUHashtable<Key, FailureTableEntry> entriesByKey;
    private final LRUHashtable<Key, BlockOfferList> blockOfferListByKey;
    private final Node node;
    static final int MAX_ENTRIES = 20000;
    static final int MAX_OFFERS = 10000;
    static final int REJECT_TIME = 600000;
    static final int MAX_LIFETIME = 3600000;
    static final int OFFER_EXPIRY_TIME = 600000;
    final byte[] offerAuthenticatorKey;
    static final int CLEANUP_PERIOD = 1800000;
    private final SerialExecutor offerExecutor;
    public final OfferedKeysByteCounter senderCounter = new OfferedKeysByteCounter();

    FailureTable(Node node) {
        this.entriesByKey = new LRUHashtable();
        this.blockOfferListByKey = new LRUHashtable();
        this.node = node;
        this.offerAuthenticatorKey = new byte[32];
        node.random.nextBytes(this.offerAuthenticatorKey);
        this.offerExecutor = new SerialExecutor(7);
        node.ps.queueTimedJob(new FailureTableCleaner(), 1800000L);
    }

    public void start() {
        this.offerExecutor.start(this.node.executor, "FailureTable offers executor");
        OOMHandler.addOOMHook(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailed(Key key, PeerNode routedTo, short htl, int timeout) {
        FailureTableEntry entry;
        if (!this.node.enableULPRDataPropagation && !this.node.enablePerNodeFailureTables) {
            return;
        }
        long now = System.currentTimeMillis();
        FailureTable failureTable = this;
        synchronized (failureTable) {
            entry = this.entriesByKey.get(key);
            if (entry == null) {
                entry = new FailureTableEntry(key);
            }
            this.entriesByKey.push(key, entry);
            this.trimEntries(now);
        }
        entry.failedTo(routedTo, timeout, now, htl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFinalFailure(Key key, PeerNode routedTo, short htl, int timeout, PeerNode requestor) {
        FailureTableEntry entry;
        if (!this.node.enableULPRDataPropagation && !this.node.enablePerNodeFailureTables) {
            return;
        }
        long now = System.currentTimeMillis();
        FailureTable failureTable = this;
        synchronized (failureTable) {
            entry = this.entriesByKey.get(key);
            if (entry == null) {
                entry = new FailureTableEntry(key);
            }
            this.entriesByKey.push(key, entry);
            this.trimEntries(now);
        }
        if (routedTo != null) {
            entry.failedTo(routedTo, timeout, now, htl);
        }
        if (requestor != null) {
            entry.addRequestor(requestor, now);
        }
    }

    private synchronized void trimEntries(long now) {
        while (this.entriesByKey.size() > 20000) {
            this.entriesByKey.popKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFound(KeyBlock block) {
        FailureTableEntry entry;
        if (!this.node.enableULPRDataPropagation && !this.node.enablePerNodeFailureTables) {
            return;
        }
        Key key = block.getKey();
        if (key == null) {
            throw new NullPointerException();
        }
        FailureTable failureTable = this;
        synchronized (failureTable) {
            entry = this.entriesByKey.get(key);
            if (entry == null) {
                return;
            }
            this.entriesByKey.removeKey(key);
            this.blockOfferListByKey.removeKey(key);
        }
        if (!this.node.enableULPRDataPropagation) {
            return;
        }
        entry.offer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onOffer(final Key key, final PeerNode peer, final byte[] authenticator) {
        if (!this.node.enableULPRDataPropagation) {
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Offered key " + key + " by peer " + peer);
        }
        FailureTable failureTable = this;
        synchronized (failureTable) {
            FailureTableEntry entry = this.entriesByKey.get(key);
            if (entry == null) {
                if (logMINOR) {
                    Logger.minor(this, "We didn't ask for the key");
                }
                return;
            }
        }
        this.offerExecutor.execute(new Runnable(){

            public void run() {
                FailureTable.this.innerOnOffer(key, peer, authenticator);
            }
        }, "onOffer()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void innerOnOffer(Key key, PeerNode peer, byte[] authenticator) {
        FailureTableEntry entry;
        if (key.getRoutingKey() == null) {
            throw new NullPointerException();
        }
        if (this.node.hasKey(key)) {
            Logger.minor(this, "Already have key");
            return;
        }
        long now = System.currentTimeMillis();
        FailureTable failureTable = this;
        synchronized (failureTable) {
            entry = this.entriesByKey.get(key);
            if (entry == null) {
                if (logMINOR) {
                    Logger.minor(this, "We didn't ask for the key");
                }
                return;
            }
        }
        boolean weAsked = entry.askedFromPeer(peer, now);
        boolean heAsked = entry.askedByPeer(peer, now);
        if (!(weAsked || key instanceof NodeCHK && heAsked)) {
            if (logMINOR) {
                Logger.minor(this, "Not propagating key: weAsked=" + weAsked + " heAsked=" + heAsked);
            }
            if (entry.isEmpty(now)) {
                FailureTable failureTable2 = this;
                synchronized (failureTable2) {
                    this.entriesByKey.removeKey(key);
                }
            }
            return;
        }
        if (entry.isEmpty(now)) {
            this.entriesByKey.removeKey(key);
        }
        FailureTable failureTable3 = this;
        synchronized (failureTable3) {
            if (logMINOR) {
                Logger.minor(this, "Valid offer");
            }
            BlockOfferList bl = this.blockOfferListByKey.get(key);
            BlockOffer offer = new BlockOffer(peer, now, authenticator, peer.getBootID());
            if (bl == null) {
                bl = new BlockOfferList(entry, offer);
            } else {
                bl.addOffer(offer);
            }
            this.blockOfferListByKey.push(key, bl);
            this.trimOffersList(now);
        }
        this.node.clientCore.maybeQueueOfferedKey(key, entry.othersWant(peer));
    }

    private synchronized void trimOffersList(long now) {
        while (true) {
            if (this.blockOfferListByKey.isEmpty()) {
                return;
            }
            BlockOfferList bl = this.blockOfferListByKey.peekValue();
            if (!bl.isEmpty(now) && bl.expires() >= now && this.blockOfferListByKey.size() <= 10000) break;
            if (logMINOR) {
                Logger.minor(this, "Removing block offer list " + bl + " list size now " + this.blockOfferListByKey.size());
            }
            this.blockOfferListByKey.popKey();
        }
    }

    public void sendOfferedKey(final Key key, final boolean isSSK, final boolean needPubKey, final long uid, final PeerNode source, final OfferReplyTag tag) throws NotConnectedException {
        this.offerExecutor.execute(new Runnable(){

            public void run() {
                try {
                    FailureTable.this.innerSendOfferedKey(key, isSSK, needPubKey, uid, source, tag);
                }
                catch (NotConnectedException e) {
                    FailureTable.this.node.unlockUID(uid, isSSK, false, false, true, false, tag);
                }
                catch (Throwable t) {
                    FailureTable.this.node.unlockUID(uid, isSSK, false, false, true, false, tag);
                    Logger.error(this, "Caught " + t + " sending offered key", t);
                }
            }
        }, "sendOfferedKey");
    }

    protected void innerSendOfferedKey(Key key, final boolean isSSK, boolean needPubKey, final long uid, final PeerNode source, final OfferReplyTag tag) throws NotConnectedException {
        if (isSSK) {
            SSKBlock block = this.node.fetch((NodeSSK)key, false);
            if (block == null) {
                source.sendAsync(DMT.createFNPGetOfferedKeyInvalid(uid, (short)2), null, this.senderCounter);
                this.node.unlockUID(uid, isSSK, false, false, true, false, tag);
                return;
            }
            final Message data = DMT.createFNPSSKDataFoundData(uid, block.getRawData());
            Message headers = DMT.createFNPSSKDataFoundHeaders(uid, block.getRawHeaders());
            final int dataLength = block.getRawData().length;
            source.sendAsync(headers, null, this.senderCounter);
            this.node.executor.execute(new PrioRunnable(){

                public int getPriority() {
                    return 7;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block6: {
                        try {
                            try {
                                source.sendThrottledMessage(data, dataLength, FailureTable.this.senderCounter, 60000, false, null);
                            }
                            catch (NotConnectedException e) {
                                Object var3_2 = null;
                                FailureTable.this.node.unlockUID(uid, isSSK, false, false, true, false, tag);
                                break block6;
                            }
                            catch (WaitedTooLongException e) {
                                Logger.error(this, "Waited too long sending SSK data");
                                Object var3_3 = null;
                                FailureTable.this.node.unlockUID(uid, isSSK, false, false, true, false, tag);
                                break block6;
                            }
                            catch (SyncSendWaitedTooLongException syncSendWaitedTooLongException) {
                                Object var3_4 = null;
                                FailureTable.this.node.unlockUID(uid, isSSK, false, false, true, false, tag);
                            }
                            Object var3_1 = null;
                            FailureTable.this.node.unlockUID(uid, isSSK, false, false, true, false, tag);
                        }
                        catch (Throwable throwable) {
                            Object var3_5 = null;
                            FailureTable.this.node.unlockUID(uid, isSSK, false, false, true, false, tag);
                            throw throwable;
                        }
                    }
                }
            }, "Send offered SSK");
            if (needPubKey) {
                Message pk = DMT.createFNPSSKPubKey(uid, block.getPubKey());
                source.sendAsync(pk, null, this.senderCounter);
            }
        } else {
            CHKBlock block = this.node.fetch((NodeCHK)key, false);
            if (block == null) {
                source.sendAsync(DMT.createFNPGetOfferedKeyInvalid(uid, (short)2), null, this.senderCounter);
                this.node.unlockUID(uid, isSSK, false, false, true, false, tag);
                return;
            }
            Message df = DMT.createFNPCHKDataFound(uid, block.getRawHeaders());
            source.sendAsync(df, null, this.senderCounter);
            PartiallyReceivedBlock prb = new PartiallyReceivedBlock(32, 1024, block.getRawData());
            final BlockTransmitter bt = new BlockTransmitter(this.node.usm, source, uid, prb, this.senderCounter);
            this.node.executor.execute(new PrioRunnable(){

                public int getPriority() {
                    return 7;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        try {
                            bt.send(((FailureTable)FailureTable.this).node.executor);
                        }
                        catch (Throwable t) {
                            Logger.error(this, "Sending offered key failed: " + t, t);
                            Object var3_2 = null;
                            FailureTable.this.node.unlockUID(uid, isSSK, false, false, true, false, tag);
                        }
                        Object var3_1 = null;
                        FailureTable.this.node.unlockUID(uid, isSSK, false, false, true, false, tag);
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        FailureTable.this.node.unlockUID(uid, isSSK, false, false, true, false, tag);
                        throw throwable;
                    }
                }
            }, "CHK offer sender");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OfferList getOffers(Key key) {
        BlockOfferList bl;
        if (!this.node.enableULPRDataPropagation) {
            return null;
        }
        FailureTable failureTable = this;
        synchronized (failureTable) {
            bl = this.blockOfferListByKey.get(key);
            if (bl == null) {
                return null;
            }
        }
        return new OfferList(bl);
    }

    public void onDisconnect(PeerNode pn) {
        if (!this.node.enableULPRDataPropagation && !this.node.enablePerNodeFailureTables) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimedOutNodesList getTimedOutNodesList(Key key) {
        if (!this.node.enablePerNodeFailureTables) {
            return null;
        }
        FailureTable failureTable = this;
        synchronized (failureTable) {
            return this.entriesByKey.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean peersWantKey(Key key) {
        FailureTableEntry entry;
        FailureTable failureTable = this;
        synchronized (failureTable) {
            entry = this.entriesByKey.get(key);
            if (entry == null) {
                return false;
            }
        }
        return entry.othersWant(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleLowMemory() throws Exception {
        FailureTable failureTable = this;
        synchronized (failureTable) {
            int size = this.entriesByKey.size();
            do {
                this.entriesByKey.popKey();
            } while (this.entriesByKey.size() >= size / 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleOutOfMemory() throws Exception {
        FailureTable failureTable = this;
        synchronized (failureTable) {
            this.entriesByKey.clear();
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
                logDEBUG = Logger.shouldLog(2, this);
            }
        });
    }

    public class FailureTableCleaner
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    this.realRun();
                }
                catch (Throwable t) {
                    Logger.error(this, "FailureTableCleaner caught " + t, t);
                    Object var3_2 = null;
                    ((FailureTable)FailureTable.this).node.ps.queueTimedJob(this, 1800000L);
                }
                Object var3_1 = null;
                ((FailureTable)FailureTable.this).node.ps.queueTimedJob(this, 1800000L);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ((FailureTable)FailureTable.this).node.ps.queueTimedJob(this, 1800000L);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void realRun() {
            FailureTableEntry[] entries;
            if (logMINOR) {
                Logger.minor(this, "Starting FailureTable cleanup");
            }
            long startTime = System.currentTimeMillis();
            FailureTable failureTable = FailureTable.this;
            synchronized (failureTable) {
                entries = new FailureTableEntry[FailureTable.this.entriesByKey.size()];
                FailureTable.this.entriesByKey.valuesToArray(entries);
            }
            for (int i = 0; i < entries.length; ++i) {
                if (!entries[i].cleanup()) continue;
                FailureTable failureTable2 = FailureTable.this;
                synchronized (failureTable2) {
                    FailureTableEntry failureTableEntry = entries[i];
                    synchronized (failureTableEntry) {
                        if (entries[i].isEmpty()) {
                            FailureTable.this.entriesByKey.removeKey(entries[i].key);
                        }
                    }
                }
            }
            long endTime = System.currentTimeMillis();
            if (logMINOR) {
                Logger.minor(this, "Finished FailureTable cleanup took " + (endTime - startTime) + "ms");
            }
        }
    }

    class OfferList {
        private final BlockOfferList offerList;
        private final Vector<BlockOffer> recentOffers;
        private final Vector<BlockOffer> expiredOffers;
        private BlockOffer lastOffer;

        OfferList(BlockOfferList offerList) {
            this.offerList = offerList;
            this.recentOffers = new Vector();
            this.expiredOffers = new Vector();
            long now = System.currentTimeMillis();
            BlockOffer[] offers = offerList.offers;
            for (int i = 0; i < offers.length; ++i) {
                if (!offers[i].isExpired(now)) {
                    this.recentOffers.add(offers[i]);
                    continue;
                }
                this.expiredOffers.add(offers[i]);
            }
            if (logMINOR) {
                Logger.minor(this, "Offers: " + this.recentOffers.size() + " recent " + this.expiredOffers.size() + " expired");
            }
        }

        public BlockOffer getFirstOffer() {
            if (this.lastOffer != null) {
                throw new IllegalStateException("Last offer not dealt with");
            }
            if (!this.recentOffers.isEmpty()) {
                int x = ((FailureTable)FailureTable.this).node.random.nextInt(this.recentOffers.size());
                this.lastOffer = this.recentOffers.remove(x);
                return this.lastOffer;
            }
            if (!this.expiredOffers.isEmpty()) {
                int x = ((FailureTable)FailureTable.this).node.random.nextInt(this.expiredOffers.size());
                this.lastOffer = this.expiredOffers.remove(x);
                return this.lastOffer;
            }
            return null;
        }

        public void deleteLastOffer() {
            this.offerList.deleteOffer(this.lastOffer);
            this.lastOffer = null;
        }

        public void keepLastOffer() {
            this.lastOffer = null;
        }
    }

    class OfferedKeysByteCounter
    implements ByteCounter {
        OfferedKeysByteCounter() {
        }

        public void receivedBytes(int x) {
            ((FailureTable)FailureTable.this).node.nodeStats.offeredKeysSenderReceivedBytes(x);
        }

        public void sentBytes(int x) {
            ((FailureTable)FailureTable.this).node.nodeStats.offeredKeysSenderSentBytes(x);
        }

        public void sentPayload(int x) {
            FailureTable.this.node.sentPayload(x);
            ((FailureTable)FailureTable.this).node.nodeStats.offeredKeysSenderSentBytes(-x);
        }
    }

    static final class BlockOffer {
        final long offeredTime;
        final WeakReference<PeerNode> nodeRef;
        final byte[] authenticator;
        final long bootID;

        BlockOffer(PeerNode pn, long now, byte[] authenticator, long bootID) {
            this.nodeRef = pn.myRef;
            this.offeredTime = now;
            this.authenticator = authenticator;
            this.bootID = bootID;
        }

        public PeerNode getPeerNode() {
            return (PeerNode)this.nodeRef.get();
        }

        public boolean isExpired(long now) {
            return this.nodeRef.get() == null || now > this.offeredTime + 600000L;
        }

        public boolean isExpired() {
            return this.isExpired(System.currentTimeMillis());
        }
    }

    private final class BlockOfferList {
        private BlockOffer[] offers;
        final FailureTableEntry entry;

        BlockOfferList(FailureTableEntry entry, BlockOffer offer) {
            this.entry = entry;
            this.offers = new BlockOffer[]{offer};
        }

        public synchronized long expires() {
            long last = 0L;
            for (int i = 0; i < this.offers.length; ++i) {
                if (this.offers[i].offeredTime <= last) continue;
                last = this.offers[i].offeredTime;
            }
            return last + 600000L;
        }

        public synchronized boolean isEmpty(long now) {
            for (int i = 0; i < this.offers.length; ++i) {
                if (this.offers[i].isExpired(now)) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteOffer(BlockOffer offer) {
            if (logMINOR) {
                Logger.minor(this, "Deleting " + offer + " from " + this);
            }
            Object object = this;
            synchronized (object) {
                int idx = -1;
                int offerLength = this.offers.length;
                for (int i = 0; i < offerLength; ++i) {
                    if (this.offers[i] != offer) continue;
                    idx = i;
                }
                if (idx < 0) {
                    return;
                }
                BlockOffer[] newOffers = new BlockOffer[offerLength - 1];
                if (idx > 0) {
                    System.arraycopy(this.offers, 0, newOffers, 0, idx);
                }
                if (idx < newOffers.length) {
                    System.arraycopy(this.offers, idx + 1, newOffers, idx, this.offers.length - idx - 1);
                }
                this.offers = newOffers;
            }
            if (this.offers.length < 1) {
                object = FailureTable.this;
                synchronized (object) {
                    FailureTable.this.blockOfferListByKey.removeKey(this.entry.key);
                }
                ((FailureTable)FailureTable.this).node.clientCore.dequeueOfferedKey(this.entry.key);
            }
        }

        public synchronized void addOffer(BlockOffer offer) {
            BlockOffer[] newOffers = new BlockOffer[this.offers.length + 1];
            System.arraycopy(this.offers, 0, newOffers, 0, this.offers.length);
            newOffers[this.offers.length] = offer;
            this.offers = newOffers;
        }

        public String toString() {
            return super.toString() + "(" + this.offers.length + ")";
        }
    }
}

