/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.crypt.BlockCipher;
import freenet.crypt.DSA;
import freenet.crypt.DSAGroup;
import freenet.crypt.DSASignature;
import freenet.crypt.DiffieHellman;
import freenet.crypt.DiffieHellmanLightContext;
import freenet.crypt.EntropySource;
import freenet.crypt.Global;
import freenet.crypt.HMAC;
import freenet.crypt.PCFBMode;
import freenet.crypt.SHA256;
import freenet.crypt.UnsupportedCipherException;
import freenet.crypt.ciphers.Rijndael;
import freenet.io.comm.AsyncMessageCallback;
import freenet.io.comm.FreenetInetAddress;
import freenet.io.comm.IncomingPacketFilter;
import freenet.io.comm.Message;
import freenet.io.comm.MessageCore;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.PacketSocketHandler;
import freenet.io.comm.Peer;
import freenet.io.comm.PeerContext;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.io.comm.SocketHandler;
import freenet.l10n.L10n;
import freenet.node.BlockedTooLongException;
import freenet.node.FSParseException;
import freenet.node.KeyChangedException;
import freenet.node.MessageItem;
import freenet.node.Node;
import freenet.node.NodeCrypto;
import freenet.node.OpennetManager;
import freenet.node.OutgoingPacketMangler;
import freenet.node.PacketSequenceException;
import freenet.node.PacketTracker;
import freenet.node.PeerNode;
import freenet.node.PrioRunnable;
import freenet.node.ResendPacketItem;
import freenet.node.SeedClientPeerNode;
import freenet.node.SessionKey;
import freenet.node.StillNotAckedException;
import freenet.node.useralerts.UserAlert;
import freenet.support.ByteArrayWrapper;
import freenet.support.Fields;
import freenet.support.HTMLNode;
import freenet.support.HexUtil;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.TimeUtil;
import freenet.support.WouldBlockException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import net.i2p.util.NativeBigInteger;

public class FNPPacketMangler
implements OutgoingPacketMangler,
IncomingPacketFilter {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private final Node node;
    private final NodeCrypto crypto;
    private final MessageCore usm;
    private final PacketSocketHandler sock;
    private final EntropySource fnpTimingSource;
    private final EntropySource myPacketDataSource;
    private final HashMap<ByteArrayWrapper, byte[]> authenticatorCache;
    private static final byte[] JFK_PREFIX_INITIATOR;
    private static final byte[] JFK_PREFIX_RESPONDER;
    public static final int DH_GENERATION_INTERVAL = 30000;
    public static final int DH_CONTEXT_BUFFER_SIZE = 20;
    private final LinkedList<DiffieHellmanLightContext> dhContextFIFO = new LinkedList();
    private DiffieHellmanLightContext dhContextToBePrunned = null;
    private long jfkDHLastGenerationTimestamp = 0L;
    protected static final int NONCE_SIZE = 8;
    private static final int AUTHENTICATOR_CACHE_SIZE = 30;
    private static final int MAX_PACKETS_IN_FLIGHT = 256;
    private static final int RANDOM_BYTES_LENGTH = 12;
    private static final int HASH_LENGTH;
    private static final int TRANSIENT_KEY_SIZE;
    private final byte[] transientKey = new byte[TRANSIENT_KEY_SIZE];
    public static final int TRANSIENT_KEY_REKEYING_MIN_INTERVAL = 1800000;
    public static final int SESSION_KEY_REKEYING_INTERVAL = 3600000;
    public static final int MAX_SESSION_KEY_REKEYING_DELAY = 300000;
    public static final int AMOUNT_OF_BYTES_ALLOWED_BEFORE_WE_REKEY = 0x40000000;
    private final Runnable transientKeyRekeyer = new Runnable(){

        public void run() {
            FNPPacketMangler.this.maybeResetTransientKey();
        }
    };
    private static final int HEADERS_LENGTH_MINIMUM;
    public static final int HEADERS_LENGTH_ONE_MESSAGE;
    static boolean LOG_UNMATCHABLE_ERROR;
    final int fullHeadersLengthMinimum;
    final int fullHeadersLengthOneMessage;
    static final byte SETUP_OPENNET_SEEDNODE = 1;
    private HashSet<Peer> peersWithProblems = new HashSet();
    private UserAlert disconnectedStillNotAckedAlert = new UserAlert(){

        public String anchor() {
            return "disconnectedStillNotAcked";
        }

        public String dismissButtonText() {
            return null;
        }

        public short getPriorityClass() {
            return 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getShortText() {
            int sz;
            HashSet hashSet = FNPPacketMangler.this.peersWithProblems;
            synchronized (hashSet) {
                sz = FNPPacketMangler.this.peersWithProblems.size();
            }
            return FNPPacketMangler.this.l10n("somePeersDisconnectedStillNotAcked", "count", Integer.toString(sz));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HTMLNode getHTMLText() {
            Peer[] peers;
            HTMLNode div = new HTMLNode("div");
            HashSet hashSet = FNPPacketMangler.this.peersWithProblems;
            synchronized (hashSet) {
                peers = FNPPacketMangler.this.peersWithProblems.toArray(new Peer[FNPPacketMangler.this.peersWithProblems.size()]);
            }
            L10n.addL10nSubstitution(div, "FNPPacketMangler.somePeersDisconnectedStillNotAckedDetail", new String[]{"count", "link", "/link"}, new String[]{Integer.toString(peers.length), "<a href=\"/?_CHECKED_HTTP_=https://bugs.freenetproject.org/\">", "</a>"});
            HTMLNode list = div.addChild("ul");
            for (Peer peer : peers) {
                list.addChild("li", peer.toString());
            }
            return div;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getText() {
            Peer[] peers;
            StringBuffer sb = new StringBuffer();
            HashSet hashSet = FNPPacketMangler.this.peersWithProblems;
            synchronized (hashSet) {
                peers = FNPPacketMangler.this.peersWithProblems.toArray(new Peer[FNPPacketMangler.this.peersWithProblems.size()]);
            }
            sb.append(FNPPacketMangler.this.l10n("somePeersDisconnectedStillNotAckedDetail", new String[]{"count", "link", "/link"}, new String[]{Integer.toString(peers.length), "", ""}));
            sb.append('\n');
            for (Peer peer : peers) {
                sb.append('\t');
                sb.append(peer.toString());
                sb.append('\n');
            }
            return sb.toString();
        }

        public String getTitle() {
            return this.getShortText();
        }

        public Object getUserIdentifier() {
            return FNPPacketMangler.this;
        }

        public boolean isEventNotification() {
            return false;
        }

        public boolean isValid() {
            return true;
        }

        public void isValid(boolean validity) {
        }

        public void onDismiss() {
        }

        public boolean shouldUnregisterOnDismiss() {
            return false;
        }

        public boolean userCanDismiss() {
            return false;
        }
    };
    private long timeLastReset = -1L;

    public FNPPacketMangler(Node node, NodeCrypto crypt, PacketSocketHandler sock) {
        this.node = node;
        this.crypto = crypt;
        this.usm = node.usm;
        this.sock = sock;
        this.fnpTimingSource = new EntropySource();
        this.myPacketDataSource = new EntropySource();
        this.authenticatorCache = new HashMap();
        this.fullHeadersLengthMinimum = HEADERS_LENGTH_MINIMUM + sock.getHeadersLength();
        this.fullHeadersLengthOneMessage = HEADERS_LENGTH_ONE_MESSAGE + sock.getHeadersLength();
    }

    public void start() {
        this.maybeResetTransientKey();
        for (int i = 0; i < 20; ++i) {
            this._fillJFKDHFIFO();
        }
    }

    public void process(byte[] buf, int offset, int length, Peer peer, long now) {
        OpennetManager opennet;
        PeerNode pn;
        int i;
        PeerNode opn;
        this.node.random.acceptTimerEntropy(this.fnpTimingSource, 0.25);
        if (logMINOR) {
            Logger.minor(this, "Packet length " + length + " from " + peer);
        }
        if ((opn = this.node.peers.getByPeer(peer)) != null && opn.getOutgoingMangler() != this) {
            Logger.error(this, "Apparently contacted by " + opn + ") on " + this);
            opn = null;
        }
        if (opn != null) {
            if (logMINOR) {
                Logger.minor(this, "Trying exact match");
            }
            if (length > HEADERS_LENGTH_MINIMUM) {
                if (logMINOR) {
                    Logger.minor(this, "Trying current key tracker for exact match");
                }
                if (this.tryProcess(buf, offset, length, opn.getCurrentKeyTracker(), now)) {
                    return;
                }
                if (logMINOR) {
                    Logger.minor(this, "Trying previous key tracker for exact match");
                }
                if (this.tryProcess(buf, offset, length, opn.getPreviousKeyTracker(), now)) {
                    return;
                }
                if (logMINOR) {
                    Logger.minor(this, "Trying unverified key tracker for exact match");
                }
                if (this.tryProcess(buf, offset, length, opn.getUnverifiedKeyTracker(), now)) {
                    return;
                }
            }
            if (length > 32 + HASH_LENGTH + 2 && !this.node.isStopping()) {
                if (this.tryProcessAuth(buf, offset, length, opn, peer, false, now)) {
                    return;
                }
                if (this.tryProcessAuthAnonReply(buf, offset, length, opn, peer, now)) {
                    return;
                }
            }
        }
        PeerNode[] peers = this.crypto.getPeerNodes();
        if (length > HASH_LENGTH + 12 + 4 + 6) {
            for (i = 0; i < peers.length; ++i) {
                pn = peers[i];
                if (pn == opn) continue;
                if (logMINOR) {
                    Logger.minor(this, "Trying current key tracker for loop");
                }
                if (this.tryProcess(buf, offset, length, pn.getCurrentKeyTracker(), now)) {
                    pn.changedIP(peer);
                    return;
                }
                if (logMINOR) {
                    Logger.minor(this, "Trying previous key tracker for loop");
                }
                if (this.tryProcess(buf, offset, length, pn.getPreviousKeyTracker(), now)) {
                    pn.changedIP(peer);
                    return;
                }
                if (logMINOR) {
                    Logger.minor(this, "Trying unverified key tracker for loop");
                }
                if (!this.tryProcess(buf, offset, length, pn.getUnverifiedKeyTracker(), now)) continue;
                pn.changedIP(peer);
                return;
            }
        }
        if (this.node.isStopping()) {
            return;
        }
        if (length > 32 + HASH_LENGTH + 2) {
            for (i = 0; i < peers.length; ++i) {
                pn = peers[i];
                if (pn == opn || !this.tryProcessAuth(buf, offset, length, pn, peer, false, now)) continue;
                return;
            }
        }
        PeerNode[] anonPeers = this.crypto.getAnonSetupPeerNodes();
        if (length > 32 + HASH_LENGTH + 3) {
            for (int i2 = 0; i2 < anonPeers.length; ++i2) {
                pn = anonPeers[i2];
                if (pn == opn) continue;
                if (this.tryProcessAuthAnonReply(buf, offset, length, pn, peer, now)) {
                    return;
                }
                if (this.tryProcess(buf, offset, length, pn.getCurrentKeyTracker(), now)) {
                    pn.changedIP(peer);
                    return;
                }
                if (this.tryProcess(buf, offset, length, pn.getPreviousKeyTracker(), now)) {
                    pn.changedIP(peer);
                    return;
                }
                if (!this.tryProcess(buf, offset, length, pn.getUnverifiedKeyTracker(), now)) continue;
                pn.changedIP(peer);
                return;
            }
        }
        if ((opennet = this.node.getOpennet()) != null && opennet.wantPeer(null, false, true, true)) {
            PeerNode[] oldPeers = opennet.getOldPeers();
            for (int i3 = 0; i3 < oldPeers.length; ++i3) {
                if (!this.tryProcessAuth(buf, offset, length, oldPeers[i3], peer, true, now)) continue;
                return;
            }
        }
        if (this.node.wantAnonAuth() && this.tryProcessAuthAnon(buf, offset, length, peer)) {
            return;
        }
        if (LOG_UNMATCHABLE_ERROR) {
            System.err.println("Unmatchable packet from " + peer + " on " + this.node.getDarknetPortNumber());
        }
        Logger.normal(this, "Unmatchable packet from " + peer);
    }

    private boolean tryProcessAuth(byte[] buf, int offset, int length, PeerNode pn, Peer peer, boolean oldOpennetPeer, long now) {
        PCFBMode pcfb;
        int ivLength;
        int digestLength;
        BlockCipher authKey = pn.incomingSetupCipher;
        if (logMINOR) {
            Logger.minor(this, "Decrypt key: " + HexUtil.bytesToHex(pn.incomingSetupKey) + " for " + peer + " : " + pn + " in tryProcessAuth");
        }
        if (length < (digestLength = HASH_LENGTH) + (ivLength = (pcfb = PCFBMode.create(authKey)).lengthIV()) + 4) {
            if (logMINOR) {
                if (buf.length < length) {
                    Logger.debug(this, "The packet is smaller than the decrypted size: it's probably the wrong tracker (" + buf.length + '<' + length + ')');
                } else {
                    Logger.minor(this, "Too short: " + length + " should be at least " + (digestLength + ivLength + 4));
                }
            }
            return false;
        }
        pcfb.reset(buf, offset);
        byte[] hash = new byte[digestLength];
        System.arraycopy(buf, offset + ivLength, hash, 0, digestLength);
        pcfb.blockDecipher(hash, 0, hash.length);
        int dataStart = ivLength + digestLength + offset + 2;
        int byte1 = pcfb.decipher(buf[dataStart - 2]) & 0xFF;
        int byte2 = pcfb.decipher(buf[dataStart - 1]) & 0xFF;
        int dataLength = (byte1 << 8) + byte2;
        if (logMINOR) {
            Logger.minor(this, "Data length: " + dataLength + " (1 = " + byte1 + " 2 = " + byte2 + ')');
        }
        if (dataLength > length - (ivLength + hash.length + 2)) {
            if (logMINOR) {
                Logger.minor(this, "Invalid data length " + dataLength + " (" + (length - (ivLength + hash.length + 2)) + ") in tryProcessAuth");
            }
            return false;
        }
        MessageDigest md = SHA256.getMessageDigest();
        byte[] payload = new byte[dataLength];
        System.arraycopy(buf, dataStart, payload, 0, dataLength);
        pcfb.blockDecipher(payload, 0, payload.length);
        md.update(payload);
        byte[] realHash = md.digest();
        SHA256.returnMessageDigest(md);
        md = null;
        if (Arrays.equals(realHash, hash)) {
            this.processDecryptedAuth(payload, pn, peer, oldOpennetPeer);
            pn.reportIncomingPacket(buf, offset, length, now);
            return true;
        }
        if (logMINOR) {
            Logger.minor(this, "Incorrect hash in tryProcessAuth for " + peer + " (length=" + dataLength + "): \nreal hash=" + HexUtil.bytesToHex(realHash) + "\n bad hash=" + HexUtil.bytesToHex(hash));
        }
        return false;
    }

    private boolean tryProcessAuthAnon(byte[] buf, int offset, int length, Peer peer) {
        BlockCipher authKey = this.crypto.getAnonSetupCipher();
        PCFBMode pcfb = PCFBMode.create(authKey);
        int ivLength = pcfb.lengthIV();
        MessageDigest md = SHA256.getMessageDigest();
        int digestLength = HASH_LENGTH;
        if (length < digestLength + ivLength + 5) {
            if (logMINOR) {
                Logger.minor(this, "Too short: " + length + " should be at least " + (digestLength + ivLength + 5));
            }
            SHA256.returnMessageDigest(md);
            return false;
        }
        pcfb.reset(buf, offset);
        byte[] hash = new byte[digestLength];
        System.arraycopy(buf, offset + ivLength, hash, 0, digestLength);
        pcfb.blockDecipher(hash, 0, hash.length);
        int dataStart = ivLength + digestLength + offset + 2;
        int byte1 = pcfb.decipher(buf[dataStart - 2]) & 0xFF;
        int byte2 = pcfb.decipher(buf[dataStart - 1]) & 0xFF;
        int dataLength = (byte1 << 8) + byte2;
        if (logMINOR) {
            Logger.minor(this, "Data length: " + dataLength + " (1 = " + byte1 + " 2 = " + byte2 + ')');
        }
        if (dataLength > length - (ivLength + hash.length + 2)) {
            if (logMINOR) {
                Logger.minor(this, "Invalid data length " + dataLength + " (" + (length - (ivLength + hash.length + 2)) + ") in tryProcessAuthAnon");
            }
            SHA256.returnMessageDigest(md);
            return false;
        }
        byte[] payload = new byte[dataLength];
        System.arraycopy(buf, dataStart, payload, 0, dataLength);
        pcfb.blockDecipher(payload, 0, payload.length);
        md.update(payload);
        byte[] realHash = md.digest();
        SHA256.returnMessageDigest(md);
        md = null;
        if (Arrays.equals(realHash, hash)) {
            this.processDecryptedAuthAnon(payload, peer);
            return true;
        }
        if (logMINOR) {
            Logger.minor(this, "Incorrect hash in tryProcessAuthAnon for " + peer + " (length=" + dataLength + "): \nreal hash=" + HexUtil.bytesToHex(realHash) + "\n bad hash=" + HexUtil.bytesToHex(hash));
        }
        return false;
    }

    private boolean tryProcessAuthAnonReply(byte[] buf, int offset, int length, PeerNode pn, Peer peer, long now) {
        int digestLength = HASH_LENGTH;
        BlockCipher authKey = pn.anonymousInitiatorSetupCipher;
        PCFBMode pcfb = PCFBMode.create(authKey);
        int ivLength = pcfb.lengthIV();
        if (length < digestLength + ivLength + 5) {
            if (logMINOR) {
                Logger.minor(this, "Too short: " + length + " should be at least " + (digestLength + ivLength + 5));
            }
            return false;
        }
        pcfb.reset(buf, offset);
        byte[] hash = new byte[digestLength];
        System.arraycopy(buf, offset + ivLength, hash, 0, digestLength);
        pcfb.blockDecipher(hash, 0, hash.length);
        int dataStart = ivLength + digestLength + offset + 2;
        int byte1 = pcfb.decipher(buf[dataStart - 2]) & 0xFF;
        int byte2 = pcfb.decipher(buf[dataStart - 1]) & 0xFF;
        int dataLength = (byte1 << 8) + byte2;
        if (logMINOR) {
            Logger.minor(this, "Data length: " + dataLength + " (1 = " + byte1 + " 2 = " + byte2 + ')');
        }
        if (dataLength > length - (ivLength + hash.length + 2)) {
            if (logMINOR) {
                Logger.minor(this, "Invalid data length " + dataLength + " (" + (length - (ivLength + hash.length + 2)) + ") in tryProcessAuth");
            }
            return false;
        }
        byte[] payload = new byte[dataLength];
        System.arraycopy(buf, dataStart, payload, 0, dataLength);
        pcfb.blockDecipher(payload, 0, payload.length);
        byte[] realHash = SHA256.digest(payload);
        if (Arrays.equals(realHash, hash)) {
            this.processDecryptedAuthAnonReply(payload, peer, pn);
            return true;
        }
        if (logMINOR) {
            Logger.minor(this, "Incorrect hash in tryProcessAuth for " + peer + " (length=" + dataLength + "): \nreal hash=" + HexUtil.bytesToHex(realHash) + "\n bad hash=" + HexUtil.bytesToHex(hash));
        }
        return false;
    }

    private void processDecryptedAuthAnon(byte[] payload, Peer replyTo) {
        if (logMINOR) {
            Logger.minor(this, "Processing decrypted auth packet from " + replyTo + " length " + payload.length);
        }
        byte version = payload[0];
        byte negType = payload[1];
        byte packetType = payload[2];
        byte setupType = payload[3];
        if (logMINOR) {
            Logger.minor(this, "Received anonymous auth packet (phase=" + packetType + ", v=" + version + ", nt=" + negType + ", setup type=" + setupType + ") from " + replyTo + "");
        }
        if (version != 1) {
            Logger.error(this, "Decrypted auth packet but invalid version: " + version);
            return;
        }
        if (negType != 2 && negType != 4) {
            Logger.error(this, "Unknown neg type: " + negType);
            return;
        }
        if (setupType != 1) {
            Logger.error(this, "Unknown setup type " + negType);
            return;
        }
        if (packetType == 0) {
            this.processJFKMessage1(payload, 4, null, replyTo, true, setupType, negType);
        } else if (packetType == 2) {
            this.processJFKMessage3(payload, 4, null, replyTo, false, true, setupType, negType);
        } else {
            Logger.error(this, "Invalid phase " + packetType + " for anonymous-initiator (we are the responder) from " + replyTo);
        }
    }

    private void processDecryptedAuthAnonReply(byte[] payload, Peer replyTo, PeerNode pn) {
        if (logMINOR) {
            Logger.minor(this, "Processing decrypted auth packet from " + replyTo + " for " + pn + " length " + payload.length);
        }
        byte version = payload[0];
        byte negType = payload[1];
        byte packetType = payload[2];
        byte setupType = payload[3];
        if (logMINOR) {
            Logger.minor(this, "Received anonymous auth packet (phase=" + packetType + ", v=" + version + ", nt=" + negType + ", setup type=" + setupType + ") from " + replyTo + "");
        }
        if (version != 1) {
            Logger.error(this, "Decrypted auth packet but invalid version: " + version);
            return;
        }
        if (negType != 2 && negType != 4) {
            Logger.error(this, "Unknown neg type: " + negType);
            return;
        }
        if (setupType != 1) {
            Logger.error(this, "Unknown setup type " + negType);
            return;
        }
        if (packetType == 1) {
            this.processJFKMessage2(payload, 4, pn, replyTo, true, setupType, negType);
        } else if (packetType == 3) {
            this.processJFKMessage4(payload, 4, pn, replyTo, false, true, setupType, negType);
        } else {
            Logger.error(this, "Invalid phase " + packetType + " for anonymous-initiator (we are the initiator) from " + replyTo);
        }
    }

    private void processDecryptedAuth(byte[] payload, PeerNode pn, Peer replyTo, boolean oldOpennetPeer) {
        if (logMINOR) {
            Logger.minor(this, "Processing decrypted auth packet from " + replyTo + " for " + pn);
        }
        if (pn.isDisabled()) {
            if (logMINOR) {
                Logger.minor(this, "Won't connect to a disabled peer (" + pn + ')');
            }
            return;
        }
        byte negType = payload[1];
        byte packetType = payload[2];
        byte version = payload[0];
        if (logMINOR) {
            long now = System.currentTimeMillis();
            long last = pn.lastSentPacketTime();
            String delta = "never";
            if (last > 0L) {
                delta = TimeUtil.formatTime(now - last, 2, true) + " ago";
            }
            Logger.minor(this, "Received auth packet for " + pn.getPeer() + " (phase=" + packetType + ", v=" + version + ", nt=" + negType + ") (last packet sent " + delta + ") from " + replyTo + "");
        }
        if (version != 1) {
            Logger.error(this, "Decrypted auth packet but invalid version: " + version);
            return;
        }
        if (negType == 0) {
            Logger.error(this, "Old ephemeral Diffie-Hellman (negType 0) not supported.");
            return;
        }
        if (negType == 1) {
            Logger.error(this, "Old StationToStation (negType 1) not supported.");
            return;
        }
        if (negType == 2 || negType == 4) {
            if (packetType < 0 || packetType > 3) {
                Logger.error(this, "Unknown PacketType" + packetType + "from" + replyTo + "from" + pn);
                return;
            }
            if (packetType == 0) {
                this.processJFKMessage1(payload, 3, pn, replyTo, false, -1, negType);
            } else if (packetType == 1) {
                this.processJFKMessage2(payload, 3, pn, replyTo, false, -1, negType);
            } else if (packetType == 2) {
                this.processJFKMessage3(payload, 3, pn, replyTo, oldOpennetPeer, false, -1, negType);
            } else if (packetType == 3) {
                this.processJFKMessage4(payload, 3, pn, replyTo, oldOpennetPeer, false, -1, negType);
            }
        } else {
            Logger.error(this, "Decrypted auth packet but unknown negotiation type " + negType + " from " + replyTo + " possibly from " + pn);
            return;
        }
    }

    private void processJFKMessage1(byte[] payload, int offset, PeerNode pn, Peer replyTo, boolean unknownInitiator, int setupType, int negType) {
        long t1 = System.currentTimeMillis();
        if (logMINOR) {
            Logger.minor(this, "Got a JFK(1) message, processing it - " + pn);
        }
        if (payload.length < 8 + DiffieHellman.modulusLengthInBytes() + 3 + (unknownInitiator ? 32 : 0)) {
            Logger.error(this, "Packet too short from " + pn + ": " + payload.length + " after decryption in JFK(1), should be " + (8 + DiffieHellman.modulusLengthInBytes()));
            return;
        }
        byte[] nonceInitiator = new byte[8];
        System.arraycopy(payload, offset, nonceInitiator, 0, 8);
        int modulusLength = DiffieHellman.modulusLengthInBytes();
        byte[] hisExponential = new byte[modulusLength];
        System.arraycopy(payload, offset += 8, hisExponential, 0, modulusLength);
        if (unknownInitiator) {
            byte[] expectedIdentityHash = new byte[32];
            System.arraycopy(payload, offset += DiffieHellman.modulusLengthInBytes(), expectedIdentityHash, 0, expectedIdentityHash.length);
            if (!Arrays.equals(expectedIdentityHash, this.crypto.identityHash)) {
                Logger.error(this, "Invalid unknown-initiator JFK(1), IDr' is " + HexUtil.bytesToHex(expectedIdentityHash) + " should be " + HexUtil.bytesToHex(this.crypto.identityHash));
                return;
            }
        }
        NativeBigInteger _hisExponential = new NativeBigInteger(1, hisExponential);
        if (DiffieHellman.checkDHExponentialValidity(this.getClass(), _hisExponential)) {
            this.sendJFKMessage2(nonceInitiator, hisExponential, pn, replyTo, unknownInitiator, setupType, negType);
        } else {
            Logger.error(this, "We can't accept the exponential " + pn + " sent us!! REDFLAG: IT CAN'T HAPPEN UNLESS AGAINST AN ACTIVE ATTACKER!!");
        }
        long t2 = System.currentTimeMillis();
        if (t2 - t1 > 500L) {
            Logger.error(this, "Message1 timeout error:Processing packet for" + pn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendJFKMessage1(PeerNode pn, Peer replyTo, boolean unknownInitiator, int setupType, int negType) {
        if (logMINOR) {
            Logger.minor(this, "Sending a JFK(1) message to " + replyTo + " for " + pn.getPeer());
        }
        long now = System.currentTimeMillis();
        DiffieHellmanLightContext ctx = (DiffieHellmanLightContext)pn.getKeyAgreementSchemeContext();
        if (ctx == null || pn.jfkContextLifetime + 600000L < now) {
            pn.jfkContextLifetime = now;
            ctx = this.getLightDiffieHellmanContext();
            pn.setKeyAgreementSchemeContext(ctx);
        }
        int offset = 0;
        byte[] myExponential = this.stripBigIntegerToNetworkFormat(ctx.myExponential);
        byte[] nonce = new byte[8];
        this.node.random.nextBytes(nonce);
        PeerNode peerNode = pn;
        synchronized (peerNode) {
            pn.jfkNoncesSent.put(replyTo.dropHostName(), nonce);
        }
        int modulusLength = DiffieHellman.modulusLengthInBytes();
        byte[] message1 = new byte[8 + modulusLength + (unknownInitiator ? 32 : 0)];
        System.arraycopy(nonce, 0, message1, offset, 8);
        System.arraycopy(myExponential, 0, message1, offset += 8, modulusLength);
        if (unknownInitiator) {
            System.arraycopy(pn.identityHash, 0, message1, offset += modulusLength, pn.identityHash.length);
            this.sendAnonAuthPacket(1, negType, 0, setupType, message1, pn, replyTo, pn.anonymousInitiatorSetupCipher);
        } else {
            this.sendAuthPacket(1, negType, 0, message1, pn, replyTo);
        }
        long t2 = System.currentTimeMillis();
        if (t2 - now > 500L) {
            Logger.error(this, "Message1 timeout error:Sending packet for" + pn.getPeer());
        }
    }

    private void sendJFKMessage2(byte[] nonceInitator, byte[] hisExponential, PeerNode pn, Peer replyTo, boolean unknownInitiator, int setupType, int negType) {
        if (logMINOR) {
            Logger.minor(this, "Sending a JFK(2) message to " + pn);
        }
        DiffieHellmanLightContext ctx = this.getLightDiffieHellmanContext();
        byte[] myExponential = this.stripBigIntegerToNetworkFormat(ctx.myExponential);
        byte[] myNonce = new byte[8];
        this.node.random.nextBytes(myNonce);
        byte[] r = ctx.signature.getRBytes(32);
        byte[] s = ctx.signature.getSBytes(32);
        byte[] authenticator = HMAC.macWithSHA256(this.getTransientKey(), this.assembleJFKAuthenticator(myExponential, hisExponential, myNonce, nonceInitator, replyTo.getAddress().getAddress()), HASH_LENGTH);
        if (logMINOR) {
            Logger.minor(this, "We are using the following HMAC : " + HexUtil.bytesToHex(authenticator));
        }
        byte[] message2 = new byte[16 + DiffieHellman.modulusLengthInBytes() + 64 + HASH_LENGTH];
        int offset = 0;
        System.arraycopy(nonceInitator, 0, message2, offset, 8);
        System.arraycopy(myNonce, 0, message2, offset += 8, 8);
        System.arraycopy(myExponential, 0, message2, offset += 8, DiffieHellman.modulusLengthInBytes());
        System.arraycopy(r, 0, message2, offset += DiffieHellman.modulusLengthInBytes(), 32);
        System.arraycopy(s, 0, message2, offset += 32, 32);
        System.arraycopy(authenticator, 0, message2, offset += 32, HASH_LENGTH);
        if (unknownInitiator) {
            this.sendAnonAuthPacket(1, negType, 1, setupType, message2, pn, replyTo, this.crypto.anonSetupCipher);
        } else {
            this.sendAuthPacket(1, negType, 1, message2, pn, replyTo);
        }
    }

    private byte[] assembleJFKAuthenticator(byte[] gR, byte[] gI, byte[] nR, byte[] nI, byte[] address) {
        byte[] authData = new byte[gR.length + gI.length + nR.length + nI.length + address.length];
        int offset = 0;
        System.arraycopy(gR, 0, authData, offset, gR.length);
        System.arraycopy(gI, 0, authData, offset += gR.length, gI.length);
        System.arraycopy(nR, 0, authData, offset += gI.length, nR.length);
        System.arraycopy(nI, 0, authData, offset += nR.length, nI.length);
        System.arraycopy(address, 0, authData, offset += nI.length, address.length);
        return authData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJFKMessage2(byte[] payload, int inputOffset, PeerNode pn, Peer replyTo, boolean unknownInitiator, int setupType, int negType) {
        byte[] myNi;
        int expectedLength;
        long t1 = System.currentTimeMillis();
        if (logMINOR) {
            Logger.minor(this, "Got a JFK(2) message, processing it - " + pn.getPeer());
        }
        if (payload.length < (expectedLength = 16 + DiffieHellman.modulusLengthInBytes() + HASH_LENGTH * 2) + 3) {
            Logger.error(this, "Packet too short from " + pn.getPeer() + ": " + payload.length + " after decryption in JFK(2), should be " + (expectedLength + 3));
            return;
        }
        byte[] nonceInitiator = new byte[8];
        System.arraycopy(payload, inputOffset, nonceInitiator, 0, 8);
        byte[] nonceResponder = new byte[8];
        System.arraycopy(payload, inputOffset += 8, nonceResponder, 0, 8);
        byte[] hisExponential = new byte[DiffieHellman.modulusLengthInBytes()];
        System.arraycopy(payload, inputOffset += 8, hisExponential, 0, DiffieHellman.modulusLengthInBytes());
        NativeBigInteger _hisExponential = new NativeBigInteger(1, hisExponential);
        byte[] r = new byte[32];
        System.arraycopy(payload, inputOffset += DiffieHellman.modulusLengthInBytes(), r, 0, 32);
        byte[] s = new byte[32];
        System.arraycopy(payload, inputOffset += 32, s, 0, 32);
        byte[] authenticator = new byte[HASH_LENGTH];
        System.arraycopy(payload, inputOffset += 32, authenticator, 0, HASH_LENGTH);
        inputOffset += HASH_LENGTH;
        byte[] message3 = null;
        HashMap<ByteArrayWrapper, byte[]> hashMap = this.authenticatorCache;
        synchronized (hashMap) {
            message3 = this.authenticatorCache.get(new ByteArrayWrapper(authenticator));
        }
        if (message3 != null) {
            Logger.normal(this, "We replayed a message from the cache (shouldn't happen often) - " + pn.getPeer());
            this.sendAuthPacket(1, negType, 3, message3, pn, replyTo);
            return;
        }
        PeerNode peerNode = pn;
        synchronized (peerNode) {
            myNi = pn.jfkNoncesSent.get(replyTo.dropHostName());
        }
        if (myNi == null) {
            if (this.shouldLogErrorInHandshake(t1)) {
                Logger.normal(this, "We received an unexpected JFK(2) message from " + pn.getPeer() + " (time since added: " + pn.timeSinceAddedOrRestarted() + " time last receive:" + pn.lastReceivedPacketTime() + ')');
            }
            return;
        }
        if (!Arrays.equals(myNi, nonceInitiator)) {
            if (this.shouldLogErrorInHandshake(t1)) {
                Logger.normal(this, "Ignoring old JFK(2) (different nonce to the one we sent - either a timing artefact or an attempt to change the nonce)");
            }
            return;
        }
        if (!DiffieHellman.checkDHExponentialValidity(this.getClass(), _hisExponential)) {
            Logger.error(this, "We can't accept the exponential " + pn.getPeer() + " sent us!! REDFLAG: IT CAN'T HAPPEN UNLESS AGAINST AN ACTIVE ATTACKER!!");
            return;
        }
        DSASignature remoteSignature = new DSASignature(new NativeBigInteger(1, r), new NativeBigInteger(1, s));
        byte[] locallyExpectedExponentials = this.assembleDHParams(_hisExponential, pn.peerCryptoGroup);
        if (!DSA.verify(pn.peerPubKey, remoteSignature, new NativeBigInteger(1, SHA256.digest(locallyExpectedExponentials)), false)) {
            Logger.error(this, "The signature verification has failed in JFK(2)!! " + pn.getPeer());
            return;
        }
        pn.receivedPacket(true, false);
        this.sendJFKMessage3(1, negType, 3, nonceInitiator, nonceResponder, hisExponential, authenticator, pn, replyTo, unknownInitiator, setupType);
        long t2 = System.currentTimeMillis();
        if (t2 - t1 > 500L) {
            Logger.error(this, "Message2 timeout error:Processing packet for" + pn.getPeer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJFKMessage3(byte[] payload, int inputOffset, PeerNode pn, Peer replyTo, boolean oldOpennetPeer, boolean unknownInitiator, int setupType, int negType) {
        long newTrackerID;
        long trackerID;
        long t1 = System.currentTimeMillis();
        if (logMINOR) {
            Logger.minor(this, "Got a JFK(3) message, processing it - " + pn);
        }
        Rijndael c = null;
        try {
            c = new Rijndael(256, 256);
        }
        catch (UnsupportedCipherException e) {
            throw new RuntimeException(e);
        }
        int expectedLength = 16 + DiffieHellman.modulusLengthInBytes() * 2 + HASH_LENGTH + HASH_LENGTH + (c.getBlockSize() >> 3) + HASH_LENGTH + 8 + (negType >= 4 ? 8 : 0) + 1;
        if (payload.length < expectedLength + 3) {
            Logger.error(this, "Packet too short from " + pn + ": " + payload.length + " after decryption in JFK(3), should be " + (expectedLength + 3));
            return;
        }
        byte[] nonceInitiator = new byte[8];
        System.arraycopy(payload, inputOffset, nonceInitiator, 0, 8);
        byte[] nonceResponder = new byte[8];
        System.arraycopy(payload, inputOffset += 8, nonceResponder, 0, 8);
        byte[] initiatorExponential = new byte[DiffieHellman.modulusLengthInBytes()];
        System.arraycopy(payload, inputOffset += 8, initiatorExponential, 0, DiffieHellman.modulusLengthInBytes());
        byte[] responderExponential = new byte[DiffieHellman.modulusLengthInBytes()];
        System.arraycopy(payload, inputOffset += DiffieHellman.modulusLengthInBytes(), responderExponential, 0, DiffieHellman.modulusLengthInBytes());
        byte[] authenticator = new byte[HASH_LENGTH];
        System.arraycopy(payload, inputOffset += DiffieHellman.modulusLengthInBytes(), authenticator, 0, HASH_LENGTH);
        inputOffset += HASH_LENGTH;
        if (!HMAC.verifyWithSHA256(this.getTransientKey(), this.assembleJFKAuthenticator(responderExponential, initiatorExponential, nonceResponder, nonceInitiator, replyTo.getAddress().getAddress()), authenticator)) {
            if (this.shouldLogErrorInHandshake(t1)) {
                Logger.normal(this, "The HMAC doesn't match; let's discard the packet (either we rekeyed or we are victim of forgery) - JFK3 - " + pn);
            }
            return;
        }
        byte[] message4 = null;
        HashMap<ByteArrayWrapper, byte[]> hashMap = this.authenticatorCache;
        synchronized (hashMap) {
            message4 = this.authenticatorCache.get(new ByteArrayWrapper(authenticator));
        }
        if (message4 != null) {
            Logger.normal(this, "We replayed a message from the cache (shouldn't happen often) - " + pn);
            if (unknownInitiator) {
                this.sendAnonAuthPacket(1, negType, 3, setupType, message4, null, replyTo, this.crypto.anonSetupCipher);
            } else {
                this.sendAuthPacket(1, negType, 3, message4, pn, replyTo);
            }
            return;
        }
        if (logDEBUG) {
            Logger.debug(this, "No message4 found for " + HexUtil.bytesToHex(authenticator) + " responderExponential " + Fields.hashCode(responderExponential) + " initiatorExponential " + Fields.hashCode(initiatorExponential) + " nonceResponder " + Fields.hashCode(nonceResponder) + " nonceInitiator " + Fields.hashCode(nonceInitiator) + " address " + HexUtil.bytesToHex(replyTo.getAddress().getAddress()));
        }
        NativeBigInteger _hisExponential = new NativeBigInteger(1, initiatorExponential);
        NativeBigInteger _ourExponential = new NativeBigInteger(1, responderExponential);
        byte[] hmac = new byte[HASH_LENGTH];
        System.arraycopy(payload, inputOffset, hmac, 0, HASH_LENGTH);
        inputOffset += HASH_LENGTH;
        DiffieHellmanLightContext ctx = this.findContextByExponential(_ourExponential);
        if (ctx == null) {
            Logger.error(this, "WTF? the HMAC verified but we don't know about that exponential! SHOULDN'T HAPPEN! - JFK3 - " + pn);
            return;
        }
        NativeBigInteger computedExponential = ctx.getHMACKey(_hisExponential, Global.DHgroupA);
        byte[] Ks = this.computeJFKSharedKey(computedExponential, nonceInitiator, nonceResponder, "0");
        byte[] Ke = this.computeJFKSharedKey(computedExponential, nonceInitiator, nonceResponder, "1");
        byte[] Ka = this.computeJFKSharedKey(computedExponential, nonceInitiator, nonceResponder, "2");
        c.initialize(Ke);
        PCFBMode pk = PCFBMode.create(c);
        int ivLength = pk.lengthIV();
        int decypheredPayloadOffset = 0;
        byte[] decypheredPayload = new byte[JFK_PREFIX_INITIATOR.length + payload.length - inputOffset];
        System.arraycopy(JFK_PREFIX_INITIATOR, 0, decypheredPayload, decypheredPayloadOffset, JFK_PREFIX_INITIATOR.length);
        System.arraycopy(payload, inputOffset, decypheredPayload, decypheredPayloadOffset += JFK_PREFIX_INITIATOR.length, decypheredPayload.length - decypheredPayloadOffset);
        if (!HMAC.verifyWithSHA256(Ka, decypheredPayload, hmac)) {
            Logger.error(this, "The inner-HMAC doesn't match; let's discard the packet JFK(3) - " + pn);
            return;
        }
        pk.reset(decypheredPayload, decypheredPayloadOffset);
        pk.blockDecipher(decypheredPayload, decypheredPayloadOffset += ivLength, decypheredPayload.length - decypheredPayloadOffset);
        byte[] r = new byte[32];
        System.arraycopy(decypheredPayload, decypheredPayloadOffset, r, 0, 32);
        byte[] s = new byte[32];
        System.arraycopy(decypheredPayload, decypheredPayloadOffset += 32, s, 0, 32);
        byte[] data = new byte[decypheredPayload.length - (decypheredPayloadOffset += 32)];
        System.arraycopy(decypheredPayload, decypheredPayloadOffset, data, 0, decypheredPayload.length - decypheredPayloadOffset);
        int ptr = 0;
        if (negType >= 4) {
            trackerID = Fields.bytesToLong(data, ptr);
            if (trackerID < 0L) {
                trackerID = -1L;
            }
            ptr += 8;
        } else {
            trackerID = -1L;
        }
        long bootID = Fields.bytesToLong(data, ptr);
        byte[] hisRef = new byte[data.length - (ptr += 8)];
        System.arraycopy(data, ptr, hisRef, 0, hisRef.length);
        if (unknownInitiator) {
            pn = this.getPeerNodeFromUnknownInitiator(hisRef, setupType, pn, replyTo);
        }
        if (pn == null) {
            if (unknownInitiator) {
                Logger.normal(this, "Rejecting... unable to construct PeerNode");
            } else {
                Logger.error(this, "PeerNode is null and unknownInitiator is false!");
            }
            return;
        }
        DSASignature remoteSignature = new DSASignature(new NativeBigInteger(1, r), new NativeBigInteger(1, s));
        if (!DSA.verify(pn.peerPubKey, remoteSignature, new NativeBigInteger(1, SHA256.digest(this.assembleDHParams(nonceInitiator, nonceResponder, _hisExponential, _ourExponential, this.crypto.myIdentity, data))), false)) {
            Logger.error(this, "The signature verification has failed!! JFK(3) - " + pn.getPeer());
            return;
        }
        pn.receivedPacket(true, false);
        Rijndael cs = null;
        try {
            cs = new Rijndael(256, 256);
        }
        catch (UnsupportedCipherException e) {
            throw new RuntimeException(e);
        }
        cs.initialize(Ks);
        boolean dontWant = false;
        if (oldOpennetPeer) {
            OpennetManager opennet = this.node.getOpennet();
            if (opennet == null) {
                Logger.normal(this, "Dumping incoming old-opennet peer as opennet just turned off: " + pn + ".");
                return;
            }
            if (!opennet.wantPeer(pn, false, false, true)) {
                Logger.normal(this, "No longer want peer " + pn + " - dumping it after connecting");
                dontWant = true;
                opennet.purgeOldOpennetPeer(pn);
            }
        }
        if ((newTrackerID = pn.completedHandshake(bootID, hisRef, 0, hisRef.length, cs, Ks, replyTo, true, negType, trackerID, false, false)) > 0L) {
            this.sendJFKMessage4(1, negType, 3, nonceInitiator, nonceResponder, initiatorExponential, responderExponential, c, Ke, Ka, authenticator, hisRef, pn, replyTo, unknownInitiator, setupType, newTrackerID, newTrackerID == trackerID);
            if (dontWant) {
                this.node.peers.disconnect(pn, true, true, true);
            } else {
                pn.maybeSendInitialMessages();
            }
        } else {
            Logger.error(this, "Handshake failure! with " + pn.getPeer());
        }
        long t2 = System.currentTimeMillis();
        if (t2 - t1 > 500L) {
            Logger.error(this, "Message3 Processing packet for" + pn.getPeer() + " took " + TimeUtil.formatTime(t2 - t1, 3, true));
        }
    }

    private PeerNode getPeerNodeFromUnknownInitiator(byte[] hisRef, int setupType, PeerNode pn, Peer from) {
        if (setupType == 1) {
            SeedClientPeerNode seed;
            OpennetManager om = this.node.getOpennet();
            if (om == null) {
                Logger.error(this, "Opennet disabled, ignoring seednode connect attempt");
                return null;
            }
            SimpleFieldSet ref = om.validateNoderef(hisRef, 0, hisRef.length, null, true);
            if (ref == null) {
                Logger.error(this, "Invalid noderef");
                return null;
            }
            try {
                seed = new SeedClientPeerNode(ref, this.node, this.crypto, this.node.peers, false, true, this.crypto.packetMangler);
            }
            catch (FSParseException e) {
                Logger.error(this, "Invalid seed client noderef: " + e + " from " + from, e);
                return null;
            }
            catch (PeerParseException e) {
                Logger.error(this, "Invalid seed client noderef: " + e + " from " + from, e);
                return null;
            }
            catch (ReferenceSignatureVerificationException e) {
                Logger.error(this, "Invalid seed client noderef: " + e + " from " + from, e);
                return null;
            }
            if (((PeerNode)seed).equals(pn)) {
                Logger.normal(this, "Already connected to seednode");
                return pn;
            }
            this.node.peers.addPeer(seed);
            return seed;
        }
        Logger.error(this, "Unknown setup type");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processJFKMessage4(byte[] payload, int inputOffset, PeerNode pn, Peer replyTo, boolean oldOpennetPeer, boolean unknownInitiator, int setupType, int negType) {
        Object opennet;
        boolean reusedTracker;
        long trackerID;
        long t1 = System.currentTimeMillis();
        if (logMINOR) {
            Logger.minor(this, "Got a JFK(4) message, processing it - " + pn.getPeer());
        }
        if (pn.jfkMyRef == null) {
            String error = "Got a JFK(4) message but no pn.jfkMyRef for " + pn;
            if (this.node.getUptime() < 60000L) {
                Logger.minor(this, error);
            } else {
                Logger.error(this, error);
            }
        }
        Rijndael c = null;
        try {
            c = new Rijndael(256, 256);
        }
        catch (UnsupportedCipherException e) {
            throw new RuntimeException(e);
        }
        int expectedLength = HASH_LENGTH + (c.getBlockSize() >> 3) + 64 + (negType >= 4 ? 9 : 0) + 8 + 1;
        if (payload.length - inputOffset < expectedLength + 3) {
            Logger.error(this, "Packet too short from " + pn.getPeer() + ": " + payload.length + " after decryption in JFK(4), should be " + (expectedLength + 3));
            return false;
        }
        byte[] jfkBuffer = pn.getJFKBuffer();
        if (jfkBuffer == null) {
            Logger.normal(this, "We have already handled this message... might be a replay or a bug - " + pn);
            return false;
        }
        byte[] hmac = new byte[HASH_LENGTH];
        System.arraycopy(payload, inputOffset, hmac, 0, HASH_LENGTH);
        c.initialize(pn.jfkKe);
        PCFBMode pk = PCFBMode.create(c);
        int ivLength = pk.lengthIV();
        int decypheredPayloadOffset = 0;
        byte[] decypheredPayload = new byte[JFK_PREFIX_RESPONDER.length + (payload.length - (inputOffset += HASH_LENGTH))];
        System.arraycopy(JFK_PREFIX_RESPONDER, 0, decypheredPayload, decypheredPayloadOffset, JFK_PREFIX_RESPONDER.length);
        System.arraycopy(payload, inputOffset, decypheredPayload, decypheredPayloadOffset += JFK_PREFIX_RESPONDER.length, payload.length - inputOffset);
        if (!HMAC.verifyWithSHA256(pn.jfkKa, decypheredPayload, hmac)) {
            Logger.normal(this, "The digest-HMAC doesn't match; let's discard the packet - " + pn.getPeer());
            return false;
        }
        byte[] message4Timestamp = null;
        HashMap<ByteArrayWrapper, byte[]> hashMap = this.authenticatorCache;
        synchronized (hashMap) {
            ByteArrayWrapper hmacBAW = new ByteArrayWrapper(hmac);
            message4Timestamp = this.authenticatorCache.get(hmacBAW);
            if (message4Timestamp == null) {
                this.authenticatorCache.put(hmacBAW, Fields.longToBytes(t1));
            }
        }
        if (message4Timestamp != null) {
            Logger.normal(this, "We got a replayed message4 (first handled at " + TimeUtil.formatTime(t1 - Fields.bytesToLong(message4Timestamp)) + ") from - " + pn);
            return true;
        }
        pk.reset(decypheredPayload, decypheredPayloadOffset);
        pk.blockDecipher(decypheredPayload, decypheredPayloadOffset += ivLength, decypheredPayload.length - decypheredPayloadOffset);
        byte[] r = new byte[32];
        System.arraycopy(decypheredPayload, decypheredPayloadOffset, r, 0, 32);
        byte[] s = new byte[32];
        System.arraycopy(decypheredPayload, decypheredPayloadOffset += 32, s, 0, 32);
        byte[] data = new byte[decypheredPayload.length - (decypheredPayloadOffset += 32)];
        System.arraycopy(decypheredPayload, decypheredPayloadOffset, data, 0, decypheredPayload.length - decypheredPayloadOffset);
        int ptr = 0;
        if (negType >= 4) {
            trackerID = Fields.bytesToLong(data, ptr);
            ptr += 8;
            reusedTracker = data[ptr++] != 0;
        } else {
            trackerID = -1L;
            reusedTracker = false;
        }
        long bootID = Fields.bytesToLong(data, ptr);
        byte[] hisRef = new byte[data.length - (ptr += 8)];
        System.arraycopy(data, ptr, hisRef, 0, hisRef.length);
        DSASignature remoteSignature = new DSASignature(new NativeBigInteger(1, r), new NativeBigInteger(1, s));
        int dataLen = hisRef.length + 8 + (negType >= 4 ? 9 : 0);
        byte[] locallyGeneratedText = new byte[16 + DiffieHellman.modulusLengthInBytes() * 2 + this.crypto.myIdentity.length + dataLen + pn.jfkMyRef.length];
        int bufferOffset = 16 + DiffieHellman.modulusLengthInBytes() * 2;
        System.arraycopy(jfkBuffer, 0, locallyGeneratedText, 0, bufferOffset);
        byte[] identity = this.crypto.getIdentity(unknownInitiator);
        System.arraycopy(identity, 0, locallyGeneratedText, bufferOffset, identity.length);
        System.arraycopy(data, 0, locallyGeneratedText, bufferOffset += identity.length, dataLen);
        System.arraycopy(pn.jfkMyRef, 0, locallyGeneratedText, bufferOffset += dataLen, pn.jfkMyRef.length);
        byte[] messageHash = SHA256.digest(locallyGeneratedText);
        if (!DSA.verify(pn.peerPubKey, remoteSignature, new NativeBigInteger(1, messageHash), false)) {
            String error = "The signature verification has failed!! JFK(4) -" + pn.getPeer() + " message hash " + HexUtil.bytesToHex(messageHash) + " length " + locallyGeneratedText.length + " hisRef " + hisRef.length + " hash " + Fields.hashCode(hisRef) + " myRef " + pn.jfkMyRef.length + " hash " + Fields.hashCode(pn.jfkMyRef) + " boot ID " + bootID;
            Logger.error(this, error);
            return true;
        }
        pn.receivedPacket(true, false);
        boolean dontWant = false;
        if (oldOpennetPeer) {
            opennet = this.node.getOpennet();
            if (opennet == null) {
                Logger.normal(this, "Dumping incoming old-opennet peer as opennet just turned off: " + pn + ".");
                return true;
            }
            if (!((OpennetManager)opennet).wantPeer(pn, false, false, true)) {
                Logger.normal(this, "No longer want peer " + pn + " - dumping it after connecting");
                dontWant = true;
                ((OpennetManager)opennet).purgeOldOpennetPeer(pn);
            }
        }
        c.initialize(pn.jfkKs);
        if (pn.completedHandshake(bootID, hisRef, 0, hisRef.length, c, pn.jfkKs, replyTo, false, negType, trackerID, true, reusedTracker) >= 0L) {
            if (dontWant) {
                this.node.peers.disconnect(pn, true, true, true);
            } else {
                pn.maybeSendInitialMessages();
            }
        } else {
            Logger.error(this, "Handshake failed!");
        }
        pn.setJFKBuffer(null);
        pn.jfkKa = null;
        pn.jfkKe = null;
        pn.jfkKs = null;
        pn.setKeyAgreementSchemeContext(null);
        opennet = pn;
        synchronized (opennet) {
            pn.jfkNoncesSent.clear();
        }
        long t2 = System.currentTimeMillis();
        if (t2 - t1 > 500L) {
            Logger.error(this, "Message4 timeout error:Processing packet from " + pn.getPeer());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendJFKMessage3(int version, final int negType, int phase, byte[] nonceInitiator, byte[] nonceResponder, byte[] hisExponential, byte[] authenticator, final PeerNode pn, final Peer replyTo, final boolean unknownInitiator, final int setupType) {
        if (logMINOR) {
            Logger.minor(this, "Sending a JFK(3) message to " + pn.getPeer());
        }
        long t1 = System.currentTimeMillis();
        Rijndael c = null;
        try {
            c = new Rijndael(256, 256);
        }
        catch (UnsupportedCipherException e) {
            throw new RuntimeException(e);
        }
        DiffieHellmanLightContext ctx = (DiffieHellmanLightContext)pn.getKeyAgreementSchemeContext();
        if (ctx == null) {
            return;
        }
        byte[] ourExponential = this.stripBigIntegerToNetworkFormat(ctx.myExponential);
        pn.jfkMyRef = unknownInitiator ? this.crypto.myCompressedHeavySetupRef() : this.crypto.myCompressedSetupRef();
        byte[] data = new byte[(negType >= 4 ? 8 : 0) + 8 + pn.jfkMyRef.length];
        int ptr = 0;
        if (negType >= 4) {
            long trackerID = pn == null ? -1L : pn.getReusableTrackerID();
            System.arraycopy(Fields.longToBytes(trackerID), 0, data, ptr, 8);
            ptr += 8;
            if (logMINOR) {
                Logger.minor(this, "Sending tracker ID " + trackerID + " in JFK(3)");
            }
        }
        System.arraycopy(Fields.longToBytes(this.node.bootID), 0, data, ptr, 8);
        System.arraycopy(pn.jfkMyRef, 0, data, ptr += 8, pn.jfkMyRef.length);
        final byte[] message3 = new byte[16 + DiffieHellman.modulusLengthInBytes() * 2 + HASH_LENGTH + HASH_LENGTH + (c.getBlockSize() >> 3) + 64 + data.length];
        int offset = 0;
        System.arraycopy(nonceInitiator, 0, message3, offset, 8);
        System.arraycopy(nonceResponder, 0, message3, offset += 8, 8);
        System.arraycopy(ourExponential, 0, message3, offset += 8, ourExponential.length);
        System.arraycopy(hisExponential, 0, message3, offset += ourExponential.length, hisExponential.length);
        System.arraycopy(authenticator, 0, message3, offset += hisExponential.length, HASH_LENGTH);
        offset += HASH_LENGTH;
        NativeBigInteger _ourExponential = new NativeBigInteger(1, ourExponential);
        NativeBigInteger _hisExponential = new NativeBigInteger(1, hisExponential);
        byte[] toSign = this.assembleDHParams(nonceInitiator, nonceResponder, _ourExponential, _hisExponential, pn.identity, data);
        pn.setJFKBuffer(toSign);
        DSASignature localSignature = this.crypto.sign(SHA256.digest(toSign));
        byte[] r = localSignature.getRBytes(32);
        byte[] s = localSignature.getSBytes(32);
        NativeBigInteger computedExponential = ctx.getHMACKey(_hisExponential, Global.DHgroupA);
        pn.jfkKs = this.computeJFKSharedKey(computedExponential, nonceInitiator, nonceResponder, "0");
        pn.jfkKe = this.computeJFKSharedKey(computedExponential, nonceInitiator, nonceResponder, "1");
        pn.jfkKa = this.computeJFKSharedKey(computedExponential, nonceInitiator, nonceResponder, "2");
        c.initialize(pn.jfkKe);
        PCFBMode pcfb = PCFBMode.create(c);
        int ivLength = pcfb.lengthIV();
        byte[] iv = new byte[ivLength];
        this.node.random.nextBytes(iv);
        pcfb.reset(iv);
        int cleartextOffset = 0;
        byte[] cleartext = new byte[JFK_PREFIX_INITIATOR.length + ivLength + 64 + data.length];
        System.arraycopy(JFK_PREFIX_INITIATOR, 0, cleartext, cleartextOffset, JFK_PREFIX_INITIATOR.length);
        System.arraycopy(iv, 0, cleartext, cleartextOffset += JFK_PREFIX_INITIATOR.length, ivLength);
        System.arraycopy(r, 0, cleartext, cleartextOffset += ivLength, 32);
        System.arraycopy(s, 0, cleartext, cleartextOffset += 32, 32);
        System.arraycopy(data, 0, cleartext, cleartextOffset += 32, data.length);
        cleartextOffset += data.length;
        int cleartextToEncypherOffset = JFK_PREFIX_INITIATOR.length + ivLength;
        pcfb.blockEncipher(cleartext, cleartextToEncypherOffset, cleartext.length - cleartextToEncypherOffset);
        byte[] hmac = HMAC.macWithSHA256(pn.jfkKa, cleartext, HASH_LENGTH);
        System.arraycopy(hmac, 0, message3, offset, HASH_LENGTH);
        System.arraycopy(iv, 0, message3, offset += HASH_LENGTH, ivLength);
        System.arraycopy(cleartext, cleartextToEncypherOffset, message3, offset += ivLength, cleartext.length - cleartextToEncypherOffset);
        HashMap<ByteArrayWrapper, byte[]> hashMap = this.authenticatorCache;
        synchronized (hashMap) {
            if (!this.maybeResetTransientKey()) {
                this.authenticatorCache.put(new ByteArrayWrapper(authenticator), message3);
            }
        }
        final long timeSent = System.currentTimeMillis();
        if (unknownInitiator) {
            this.sendAnonAuthPacket(1, negType, 2, setupType, message3, pn, replyTo, pn.anonymousInitiatorSetupCipher);
        } else {
            this.sendAuthPacket(1, negType, 2, message3, pn, replyTo);
        }
        this.node.getTicker().queueTimedJob(new Runnable(){

            public void run() {
                if (pn.timeLastConnectionCompleted() < timeSent) {
                    if (logMINOR) {
                        Logger.minor(this, "Resending JFK(3) to " + pn + " for " + FNPPacketMangler.this.node.getDarknetPortNumber());
                    }
                    if (unknownInitiator) {
                        FNPPacketMangler.this.sendAnonAuthPacket(1, negType, 2, setupType, message3, pn, replyTo, pn.anonymousInitiatorSetupCipher);
                    } else {
                        FNPPacketMangler.this.sendAuthPacket(1, negType, 2, message3, pn, replyTo);
                    }
                }
            }
        }, 5000L);
        long t2 = System.currentTimeMillis();
        if (t2 - t1 > 500L) {
            Logger.error(this, "Message3 timeout error:Sending packet for" + pn.getPeer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendJFKMessage4(int version, int negType, int phase, byte[] nonceInitiator, byte[] nonceResponder, byte[] initiatorExponential, byte[] responderExponential, BlockCipher c, byte[] Ke, byte[] Ka, byte[] authenticator, byte[] hisRef, PeerNode pn, Peer replyTo, boolean unknownInitiator, int setupType, long newTrackerID, boolean sameAsOldTrackerID) {
        if (logMINOR) {
            Logger.minor(this, "Sending a JFK(4) message to " + pn.getPeer());
        }
        long t1 = System.currentTimeMillis();
        NativeBigInteger _responderExponential = new NativeBigInteger(1, responderExponential);
        NativeBigInteger _initiatorExponential = new NativeBigInteger(1, initiatorExponential);
        byte[] myRef = this.crypto.myCompressedSetupRef();
        byte[] data = new byte[(negType >= 4 ? 9 : 0) + 8 + myRef.length + hisRef.length];
        int ptr = 0;
        if (negType >= 4) {
            System.arraycopy(Fields.longToBytes(newTrackerID), 0, data, ptr, 8);
            ptr += 8;
            data[ptr++] = (byte)(sameAsOldTrackerID ? 1 : 0);
        }
        System.arraycopy(Fields.longToBytes(this.node.bootID), 0, data, ptr, 8);
        System.arraycopy(myRef, 0, data, ptr += 8, myRef.length);
        System.arraycopy(hisRef, 0, data, ptr += myRef.length, hisRef.length);
        byte[] params = this.assembleDHParams(nonceInitiator, nonceResponder, _initiatorExponential, _responderExponential, pn.identity, data);
        byte[] messageHash = SHA256.digest(params);
        if (logMINOR) {
            Logger.minor(this, "Message hash: " + HexUtil.bytesToHex(messageHash) + " length " + params.length + " myRef: " + myRef.length + " hash " + Fields.hashCode(myRef) + " hisRef: " + hisRef.length + " hash " + Fields.hashCode(hisRef) + " boot ID " + this.node.bootID);
        }
        DSASignature localSignature = this.crypto.sign(messageHash);
        byte[] r = localSignature.getRBytes(32);
        byte[] s = localSignature.getSBytes(32);
        PCFBMode pk = PCFBMode.create(c);
        int ivLength = pk.lengthIV();
        byte[] iv = new byte[ivLength];
        this.node.random.nextBytes(iv);
        pk.reset(iv);
        int dataLength = data.length - hisRef.length;
        byte[] cyphertext = new byte[JFK_PREFIX_RESPONDER.length + ivLength + 64 + dataLength];
        int cleartextOffset = 0;
        System.arraycopy(JFK_PREFIX_RESPONDER, 0, cyphertext, cleartextOffset, JFK_PREFIX_RESPONDER.length);
        System.arraycopy(iv, 0, cyphertext, cleartextOffset += JFK_PREFIX_RESPONDER.length, ivLength);
        System.arraycopy(r, 0, cyphertext, cleartextOffset += ivLength, 32);
        System.arraycopy(s, 0, cyphertext, cleartextOffset += 32, 32);
        System.arraycopy(data, 0, cyphertext, cleartextOffset += 32, dataLength);
        cleartextOffset += dataLength;
        int cleartextToEncypherOffset = JFK_PREFIX_RESPONDER.length + ivLength;
        pk.blockEncipher(cyphertext, cleartextToEncypherOffset, cyphertext.length - cleartextToEncypherOffset);
        byte[] hmac = HMAC.macWithSHA256(Ka, cyphertext, HASH_LENGTH);
        byte[] message4 = new byte[HASH_LENGTH + ivLength + (cyphertext.length - cleartextToEncypherOffset)];
        int offset = 0;
        System.arraycopy(hmac, 0, message4, offset, HASH_LENGTH);
        System.arraycopy(iv, 0, message4, offset += HASH_LENGTH, ivLength);
        System.arraycopy(cyphertext, cleartextToEncypherOffset, message4, offset += ivLength, cyphertext.length - cleartextToEncypherOffset);
        HashMap<ByteArrayWrapper, byte[]> hashMap = this.authenticatorCache;
        synchronized (hashMap) {
            if (!this.maybeResetTransientKey()) {
                this.authenticatorCache.put(new ByteArrayWrapper(authenticator), message4);
            }
            if (logDEBUG) {
                Logger.debug(this, "Storing JFK(4) for " + HexUtil.bytesToHex(authenticator));
            }
        }
        if (unknownInitiator) {
            this.sendAnonAuthPacket(1, negType, 3, setupType, message4, pn, replyTo, this.crypto.anonSetupCipher);
        } else {
            this.sendAuthPacket(1, negType, 3, message4, pn, replyTo);
        }
        long t2 = System.currentTimeMillis();
        if (t2 - t1 > 500L) {
            Logger.error(this, "Message4 timeout error:Sending packet for" + pn.getPeer());
        }
    }

    private void sendAuthPacket(int version, int negType, int phase, byte[] data, PeerNode pn, Peer replyTo) {
        if (pn == null) {
            throw new IllegalArgumentException("pn shouldn't be null here!");
        }
        byte[] output = new byte[data.length + 3];
        output[0] = (byte)version;
        output[1] = (byte)negType;
        output[2] = (byte)phase;
        System.arraycopy(data, 0, output, 3, data.length);
        if (logMINOR) {
            long now = System.currentTimeMillis();
            String delta = "never";
            long last = pn.lastSentPacketTime();
            delta = TimeUtil.formatTime(now - last, 2, true) + " ago";
            Logger.minor(this, "Sending auth packet for " + String.valueOf(pn.getPeer()) + " (phase=" + phase + ", ver=" + version + ", nt=" + negType + ") (last packet sent " + delta + ") to " + replyTo + " data.length=" + data.length + " to " + replyTo);
        }
        this.sendAuthPacket(output, pn.outgoingSetupCipher, pn, replyTo, false);
    }

    private void sendAnonAuthPacket(int version, int negType, int phase, int setupType, byte[] data, PeerNode pn, Peer replyTo, BlockCipher cipher) {
        byte[] output = new byte[data.length + 4];
        output[0] = (byte)version;
        output[1] = (byte)negType;
        output[2] = (byte)phase;
        output[3] = (byte)setupType;
        System.arraycopy(data, 0, output, 4, data.length);
        if (logMINOR) {
            Logger.minor(this, "Sending anon auth packet (phase=" + phase + ", ver=" + version + ", nt=" + negType + ", setup=" + setupType + ") data.length=" + data.length);
        }
        this.sendAuthPacket(output, cipher, pn, replyTo, true);
    }

    private void sendAuthPacket(byte[] output, BlockCipher cipher, PeerNode pn, Peer replyTo, boolean anonAuth) {
        int paddingLength;
        int maxPacketSize;
        int prePaddingLength;
        int length = output.length;
        if (length > this.sock.getMaxPacketSize()) {
            throw new IllegalStateException("Cannot send auth packet: too long: " + length);
        }
        PCFBMode pcfb = PCFBMode.create(cipher);
        byte[] iv = new byte[pcfb.lengthIV()];
        this.node.random.nextBytes(iv);
        byte[] hash = SHA256.digest(output);
        if (logMINOR) {
            Logger.minor(this, "Data hash: " + HexUtil.bytesToHex(hash));
        }
        if ((prePaddingLength = iv.length + hash.length + 2 + output.length) < (maxPacketSize = this.sock.getMaxPacketSize() - this.sock.getHeadersLength())) {
            paddingLength = this.node.fastWeakRandom.nextInt(Math.min(100, maxPacketSize - prePaddingLength));
        } else {
            paddingLength = 0;
            Logger.error(this, "Warning: sending oversize auth packet (anonAuth=" + anonAuth + ") of " + prePaddingLength + " bytes!");
        }
        if (paddingLength < 0) {
            paddingLength = 0;
        }
        byte[] data = new byte[prePaddingLength + paddingLength];
        pcfb.reset(iv);
        System.arraycopy(iv, 0, data, 0, iv.length);
        pcfb.blockEncipher(hash, 0, hash.length);
        System.arraycopy(hash, 0, data, iv.length, hash.length);
        if (logMINOR) {
            Logger.minor(this, "Payload length: " + length);
        }
        data[hash.length + iv.length] = (byte)pcfb.encipher((byte)(length >> 8));
        data[hash.length + iv.length + 1] = (byte)pcfb.encipher((byte)length);
        pcfb.blockEncipher(output, 0, output.length);
        System.arraycopy(output, 0, data, hash.length + iv.length + 2, output.length);
        byte[] random = new byte[paddingLength];
        this.node.fastWeakRandom.nextBytes(random);
        System.arraycopy(random, 0, data, hash.length + iv.length + 2 + output.length, random.length);
        this.node.nodeStats.reportAuthBytes(data.length + this.sock.getHeadersLength());
        try {
            this.sendPacket(data, replyTo, pn);
        }
        catch (Peer.LocalAddressException e) {
            Logger.error(this, "Tried to send auth packet to local address: " + replyTo + " for " + pn + " - maybe you should set allowLocalAddresses for this peer??");
        }
    }

    private void sendPacket(byte[] data, Peer replyTo, PeerNode pn) throws Peer.LocalAddressException {
        Peer p;
        if (pn != null && pn.isIgnoreSource() && (p = pn.getPeer()) != null) {
            replyTo = p;
        }
        this.sock.sendPacket(data, replyTo, pn == null ? this.crypto.config.alwaysAllowLocalAddresses() : pn.allowLocalAddresses());
        if (pn != null) {
            pn.reportOutgoingPacket(data, 0, data.length, System.currentTimeMillis());
        }
        if (PeerNode.shouldThrottle(replyTo, this.node)) {
            this.node.outputThrottle.forceGrab(data.length);
        }
    }

    private boolean shouldLogErrorInHandshake(long now) {
        return now - this.node.startupTime >= 9600L;
    }

    private boolean tryProcess(byte[] buf, int offset, int length, SessionKey tracker, long now) {
        BlockCipher sessionCipher;
        if (tracker == null) {
            if (logDEBUG) {
                Logger.debug(this, "Tracker == null");
            }
            return false;
        }
        if (logMINOR) {
            Logger.minor(this, "Entering tryProcess: " + Fields.hashCode(buf) + ',' + offset + ',' + length + ',' + tracker);
        }
        if ((sessionCipher = tracker.sessionCipher) == null) {
            if (logMINOR) {
                Logger.minor(this, "No cipher");
            }
            return false;
        }
        if (logMINOR) {
            Logger.minor(this, "Decrypting with " + HexUtil.bytesToHex(tracker.sessionKey));
        }
        int blockSize = sessionCipher.getBlockSize() >> 3;
        if (sessionCipher.getKeySize() != sessionCipher.getBlockSize()) {
            throw new IllegalStateException("Block size must be equal to key size");
        }
        if (HASH_LENGTH != blockSize) {
            throw new IllegalStateException("Block size must be digest length!");
        }
        byte[] packetHash = new byte[HASH_LENGTH];
        System.arraycopy(buf, offset, packetHash, 0, HASH_LENGTH);
        PCFBMode pcfb = PCFBMode.create(sessionCipher);
        pcfb.reset(packetHash);
        byte[] seqBuf = new byte[4];
        System.arraycopy(buf, offset + HASH_LENGTH, seqBuf, 0, 4);
        pcfb.blockDecipher(seqBuf, 0, 4);
        int seqNumber = ((((seqBuf[0] & 0xFF) << 8) + (seqBuf[1] & 0xFF) << 8) + (seqBuf[2] & 0xFF) << 8) + (seqBuf[3] & 0xFF);
        PacketTracker packets = tracker.packets;
        int targetSeqNumber = packets.highestReceivedIncomingSeqNumber();
        if (logMINOR) {
            Logger.minor(this, "Seqno: " + seqNumber + " (highest seen " + targetSeqNumber + ") receiving packet from " + tracker.pn.getPeer());
        }
        if (seqNumber != -1 && targetSeqNumber != -1 && Math.abs(targetSeqNumber - seqNumber) > 256) {
            return false;
        }
        if (logMINOR) {
            Logger.minor(this, "Sequence number received: " + seqNumber);
        }
        byte[] plaintext = new byte[length - (4 + HASH_LENGTH)];
        System.arraycopy(buf, offset + HASH_LENGTH + 4, plaintext, 0, length - (HASH_LENGTH + 4));
        pcfb.blockDecipher(plaintext, 0, length - (HASH_LENGTH + 4));
        MessageDigest md = SHA256.getMessageDigest();
        md.update(seqBuf);
        md.update(plaintext);
        byte[] realHash = md.digest();
        SHA256.returnMessageDigest(md);
        md = null;
        byte[] temp = new byte[blockSize];
        System.arraycopy(buf, offset, temp, 0, blockSize);
        sessionCipher.decipher(temp, temp);
        System.arraycopy(temp, 0, packetHash, 0, blockSize);
        if (!Arrays.equals(packetHash, realHash)) {
            if (logMINOR) {
                Logger.minor(this, "Packet possibly from " + tracker + " hash does not match:\npacketHash=" + HexUtil.bytesToHex(packetHash) + "\n  realHash=" + HexUtil.bytesToHex(realHash) + " (" + (length - HASH_LENGTH) + " bytes payload)");
            }
            return false;
        }
        tracker.pn.verified(tracker);
        for (int i = 0; i < HASH_LENGTH; ++i) {
            int n = i;
            packetHash[n] = (byte)(packetHash[n] ^ buf[offset + i]);
        }
        if (logMINOR) {
            Logger.minor(this, "Contributing entropy");
        }
        this.node.random.acceptEntropyBytes(this.myPacketDataSource, packetHash, 0, HASH_LENGTH, 0.5);
        if (logMINOR) {
            Logger.minor(this, "Contributed entropy");
        }
        this.processDecryptedData(plaintext, seqNumber, tracker, length - plaintext.length);
        tracker.pn.reportIncomingPacket(buf, offset, length, now);
        return true;
    }

    private void processDecryptedData(byte[] decrypted, int seqNumber, SessionKey tracker, int overhead) {
        int ptr = 12;
        byte version = decrypted[ptr++];
        if (ptr > decrypted.length) {
            Logger.error(this, "Packet not long enough at byte " + ptr + " on " + tracker);
            return;
        }
        if (version != 0) {
            Logger.error(this, "Packet from " + tracker + " decrypted but invalid version: " + version);
            return;
        }
        int realSeqNumber = seqNumber;
        if (seqNumber == -1) {
            if (ptr + 4 > decrypted.length) {
                Logger.error(this, "Packet not long enough at byte " + ptr + " on " + tracker);
                return;
            }
            realSeqNumber = ((((decrypted[ptr + 0] & 0xFF) << 8) + (decrypted[ptr + 1] & 0xFF) << 8) + (decrypted[ptr + 2] & 0xFF) << 8) + (decrypted[ptr + 3] & 0xFF);
            ptr += 4;
        } else {
            if (ptr > decrypted.length) {
                Logger.error(this, "Packet not long enough at byte " + ptr + " on " + tracker);
                return;
            }
            realSeqNumber = seqNumber + (decrypted[ptr++] & 0xFF);
        }
        if (logMINOR) {
            Logger.minor(this, "Real sequence number: " + realSeqNumber);
        }
        if (ptr + 4 > decrypted.length) {
            Logger.error(this, "Packet not long enough at byte " + ptr + " on " + tracker);
            return;
        }
        int referenceSeqNumber = ((((decrypted[ptr + 0] & 0xFF) << 8) + (decrypted[ptr + 1] & 0xFF) << 8) + (decrypted[ptr + 2] & 0xFF) << 8) + (decrypted[ptr + 3] & 0xFF);
        ptr += 4;
        if (logMINOR) {
            Logger.minor(this, "Reference sequence number: " + referenceSeqNumber);
        }
        int ackCount = decrypted[ptr++] & 0xFF;
        if (logMINOR) {
            Logger.minor(this, "Acks: " + ackCount);
        }
        int[] acks = new int[ackCount];
        for (int i = 0; i < ackCount; ++i) {
            int offset = decrypted[ptr++] & 0xFF;
            if (ptr > decrypted.length) {
                Logger.error(this, "Packet not long enough at byte " + ptr + " on " + tracker);
                return;
            }
            acks[i] = referenceSeqNumber - offset;
        }
        PacketTracker packets = tracker.packets;
        packets.acknowledgedPackets(acks);
        int retransmitCount = decrypted[ptr++] & 0xFF;
        if (logMINOR) {
            Logger.minor(this, "Retransmit requests: " + retransmitCount);
        }
        for (int i = 0; i < retransmitCount; ++i) {
            int offset = decrypted[ptr++] & 0xFF;
            if (ptr > decrypted.length) {
                Logger.error(this, "Packet not long enough at byte " + ptr + " on " + tracker);
            }
            int realSeqNo = referenceSeqNumber - offset;
            if (logMINOR) {
                Logger.minor(this, "RetransmitRequest: " + realSeqNo);
            }
            packets.resendPacket(realSeqNo);
        }
        int ackRequestsCount = decrypted[ptr++] & 0xFF;
        if (logMINOR) {
            Logger.minor(this, "Ack requests: " + ackRequestsCount);
        }
        for (int i = 0; i < ackRequestsCount; ++i) {
            int offset = decrypted[ptr++] & 0xFF;
            if (ptr > decrypted.length) {
                Logger.error(this, "Packet not long enough at byte " + ptr + " on " + tracker);
            }
            int realSeqNo = realSeqNumber - offset;
            if (logMINOR) {
                Logger.minor(this, "AckRequest: " + realSeqNo);
            }
            packets.receivedAckRequest(realSeqNo);
        }
        int forgottenCount = decrypted[ptr++] & 0xFF;
        if (logMINOR) {
            Logger.minor(this, "Forgotten packets: " + forgottenCount);
        }
        for (int i = 0; i < forgottenCount; ++i) {
            int offset = decrypted[ptr++] & 0xFF;
            if (ptr > decrypted.length) {
                Logger.error(this, "Packet not long enough at byte " + ptr + " on " + tracker);
            }
            int realSeqNo = realSeqNumber - offset;
            packets.destForgotPacket(realSeqNo);
        }
        tracker.pn.receivedPacket(false, true);
        if (seqNumber != -1 && packets.alreadyReceived(seqNumber)) {
            packets.queueAck(seqNumber);
            if (logMINOR) {
                Logger.minor(this, "Received packet twice (" + seqNumber + ") from " + tracker.pn.getPeer() + ": " + seqNumber + " (" + TimeUtil.formatTime((long)tracker.pn.averagePingTime(), 2, true) + " ping avg)");
            }
            return;
        }
        packets.receivedPacket(seqNumber);
        if (seqNumber == -1) {
            if (logMINOR) {
                Logger.minor(this, "Returning because seqno = " + seqNumber);
            }
            return;
        }
        int messages = decrypted[ptr++] & 0xFF;
        overhead += ptr;
        for (int i = 0; i < messages; ++i) {
            int length;
            if (ptr + 1 >= decrypted.length) {
                Logger.error(this, "Packet not long enough at byte " + ptr + " on " + tracker);
            }
            if ((length = ((decrypted[ptr++] & 0xFF) << 8) + (decrypted[ptr++] & 0xFF)) > decrypted.length - ptr) {
                Logger.error(this, "Message longer than remaining space: " + length);
                return;
            }
            if (logMINOR) {
                Logger.minor(this, "Message " + i + " length " + length + ", hash code: " + Fields.hashCode(decrypted, ptr, length));
            }
            Message m = this.usm.decodeSingleMessage(decrypted, ptr, length, tracker.pn, 1 + overhead / messages);
            ptr += length;
            if (m == null) continue;
            this.usm.checkFilters(m, this.sock);
        }
        tracker.pn.maybeRekey();
        if (logMINOR) {
            Logger.minor(this, "Done");
        }
    }

    public boolean processOutgoingOrRequeue(MessageItem[] messages, PeerNode pn, boolean dontRequeue, boolean onePacket) throws BlockedTooLongException {
        int i;
        String requeueLogString = "";
        if (!dontRequeue) {
            requeueLogString = ", requeueing";
        }
        if (logMINOR) {
            Logger.minor(this, "processOutgoingOrRequeue " + messages.length + " messages for " + pn);
        }
        byte[][] messageData = new byte[messages.length][];
        MessageItem[] newMsgs = new MessageItem[messages.length];
        SessionKey kt = pn.getCurrentKeyTracker();
        if (kt == null) {
            Logger.error(this, "Not connected while sending packets: " + pn);
            if (!dontRequeue) {
                for (MessageItem item : messages) {
                    item.onDisconnect();
                }
            }
            return false;
        }
        PacketTracker packets = kt.packets;
        if (packets.wouldBlock(false)) {
            if (logMINOR) {
                Logger.minor(this, "Would block: " + kt);
            }
            if (!dontRequeue) {
                pn.requeueMessageItems(messages, 0, messages.length, false, "WouldBlock");
            }
            return false;
        }
        int length = 1;
        length += packets.countAcks() + packets.countAckRequests() + packets.countResendRequests();
        int callbacksCount = 0;
        int x = 0;
        String mi_name = null;
        for (int i2 = 0; i2 < messageData.length; ++i2) {
            MessageItem mi = messages[i2];
            if (logMINOR) {
                Logger.minor(this, "Handling " + (mi.formatted ? "formatted " : "") + "MessageItem " + mi + " : " + mi.getLength());
            }
            String string = mi_name = mi.msg == null ? "(not a Message)" : mi.msg.getSpec().getName();
            if (mi.formatted) {
                try {
                    byte[] buf = mi.getData();
                    int packetNumber = packets.allocateOutgoingPacketNumberNeverBlock();
                    int size = this.processOutgoingPreformatted(buf, 0, buf.length, kt, packetNumber, mi.cb, mi.getPriority());
                    mi.onSent(size);
                    continue;
                }
                catch (NotConnectedException e) {
                    Logger.normal(this, "Caught " + e + " while sending messages (" + mi_name + ") to " + pn.getPeer() + requeueLogString);
                    if (!dontRequeue) {
                        pn.requeueMessageItems(newMsgs, 0, x, false, "NotConnectedException(1a)");
                        pn.requeueMessageItems(messages, i2, messages.length - i2, false, "NotConnectedException(1b)");
                    }
                    return false;
                }
                catch (WouldBlockException e) {
                    if (logMINOR) {
                        Logger.minor(this, "Caught " + e + " while sending messages (" + mi_name + ") to " + pn.getPeer() + requeueLogString, (Throwable)e);
                    }
                    if (!dontRequeue) {
                        pn.requeueMessageItems(newMsgs, 0, x, false, "WouldBlockException(1a)");
                        pn.requeueMessageItems(messages, i2, messages.length - i2, false, "WouldBlockException(1b)");
                    }
                    return false;
                }
                catch (KeyChangedException e) {
                    if (logMINOR) {
                        Logger.minor(this, "Caught " + e + " while sending messages (" + mi_name + ") to " + pn.getPeer() + requeueLogString, (Throwable)e);
                    }
                    if (!dontRequeue) {
                        pn.requeueMessageItems(newMsgs, 0, x, false, "KeyChangedException(1a)");
                        pn.requeueMessageItems(messages, i2, messages.length - i2, false, "KeyChangedException(1b)");
                    }
                    return false;
                }
                catch (Throwable e) {
                    Logger.error(this, "Caught " + e + " while sending messages (" + mi_name + ") to " + pn.getPeer() + requeueLogString, e);
                    if (!dontRequeue) {
                        pn.requeueMessageItems(newMsgs, 0, x, false, "Throwable(1)");
                        pn.requeueMessageItems(messages, i2, messages.length - i2, false, "Throwable(1)");
                    }
                    return false;
                }
            }
            byte[] data = mi.getData();
            messageData[x] = data;
            if (data.length > this.sock.getMaxPacketSize()) {
                Logger.error(this, "Message exceeds packet size: " + messages[i2] + " size " + data.length + " message " + mi.msg);
            }
            newMsgs[x] = mi;
            ++x;
            if (mi.cb != null) {
                callbacksCount += mi.cb.length;
            }
            if (logMINOR) {
                Logger.minor(this, "Sending: " + mi + " length " + data.length + " cb " + Arrays.toString(mi.cb));
            }
            length += data.length + 2;
        }
        if (x != messageData.length) {
            byte[][] newMessageData = new byte[x][];
            System.arraycopy(messageData, 0, newMessageData, 0, x);
            messageData = newMessageData;
            messages = newMsgs;
            newMsgs = new MessageItem[x];
            System.arraycopy(messages, 0, newMsgs, 0, x);
            messages = newMsgs;
        }
        AsyncMessageCallback[] callbacks = new AsyncMessageCallback[callbacksCount];
        x = 0;
        short priority = 4;
        for (int i3 = 0; i3 < messages.length; ++i3) {
            short messagePrio;
            if (messages[i3].formatted) continue;
            if (messages[i3].cb != null) {
                System.arraycopy(messages[i3].cb, 0, callbacks, x, messages[i3].cb.length);
                x += messages[i3].cb.length;
            }
            if ((messagePrio = messages[i3].getPriority()) >= priority) continue;
            priority = messagePrio;
        }
        if (x != callbacksCount) {
            throw new IllegalStateException();
        }
        if (length + HEADERS_LENGTH_MINIMUM < this.sock.getMaxPacketSize() && messageData.length < 256) {
            mi_name = null;
            try {
                int size = this.innerProcessOutgoing(messageData, 0, messageData.length, length, pn, callbacks, priority);
                int totalMessageSize = 0;
                for (i = 0; i < messageData.length; ++i) {
                    totalMessageSize += messageData[i].length;
                }
                int overhead = size - totalMessageSize;
                for (int i4 = 0; i4 < messageData.length; ++i4) {
                    MessageItem mi = newMsgs[i4];
                    mi_name = mi.msg == null ? "(not a Message)" : mi.msg.getSpec().getName();
                    mi.onSent(messageData[i4].length + overhead / messageData.length);
                }
            }
            catch (NotConnectedException e) {
                Logger.normal(this, "Caught " + e + " while sending messages (" + mi_name + ") to " + pn.getPeer() + requeueLogString);
                if (!dontRequeue) {
                    pn.requeueMessageItems(messages, 0, messages.length, false, "NotConnectedException(2)");
                }
                return false;
            }
            catch (WouldBlockException e) {
                if (logMINOR) {
                    Logger.minor(this, "Caught " + e + " while sending messages (" + mi_name + ") to " + pn.getPeer() + requeueLogString, (Throwable)e);
                }
                if (!dontRequeue) {
                    pn.requeueMessageItems(messages, 0, messages.length, false, "WouldBlockException(2)");
                }
                return false;
            }
            catch (Throwable e) {
                Logger.error(this, "Caught " + e + " while sending messages (" + mi_name + ") to " + pn.getPeer() + requeueLogString, e);
                if (!dontRequeue) {
                    pn.requeueMessageItems(messages, 0, messages.length, false, "Throwable(2)");
                }
                return false;
            }
        }
        if (!dontRequeue) {
            requeueLogString = ", requeueing remaining messages";
        }
        length = 1;
        length += packets.countAcks() + packets.countAckRequests() + packets.countResendRequests();
        int count = 0;
        int lastIndex = 0;
        if (logMINOR) {
            Logger.minor(this, "Sending " + messageData.length + " messages");
        }
        for (i = 0; i <= messageData.length; ++i) {
            int thisLength;
            int newLength;
            if (logMINOR) {
                Logger.minor(this, "Sending message " + i);
            }
            if ((newLength = length + (thisLength = i == messages.length ? 0 : messageData[i].length + 2)) + HEADERS_LENGTH_MINIMUM > this.sock.getMaxPacketSize() || ++count > 255 || i == messages.length) {
                if (lastIndex != i) {
                    mi_name = null;
                    try {
                        int size = this.innerProcessOutgoing(messageData, lastIndex, i - lastIndex, length, pn, callbacks, priority);
                        int totalMessageSize = 0;
                        for (int j = lastIndex; j < i; ++j) {
                            totalMessageSize += messageData[j].length;
                        }
                        int overhead = size - totalMessageSize;
                        for (int j = lastIndex; j < i; ++j) {
                            MessageItem mi = newMsgs[j];
                            mi_name = mi.msg == null ? "(not a Message)" : mi.msg.getSpec().getName();
                            mi.onSent(messageData[j].length + overhead / (i - lastIndex));
                        }
                    }
                    catch (NotConnectedException e) {
                        Logger.normal(this, "Caught " + e + " while sending messages (" + mi_name + ") to " + pn.getPeer() + requeueLogString);
                        if (!dontRequeue) {
                            pn.requeueMessageItems(messages, lastIndex, messages.length - lastIndex, false, "NotConnectedException(3)");
                        }
                        return false;
                    }
                    catch (WouldBlockException e) {
                        if (logMINOR) {
                            Logger.minor(this, "Caught " + e + " while sending messages (" + mi_name + ") to " + pn.getPeer() + requeueLogString, (Throwable)e);
                        }
                        if (!dontRequeue) {
                            pn.requeueMessageItems(messages, lastIndex, messages.length - lastIndex, false, "WouldBlockException(3)");
                        }
                        return false;
                    }
                    catch (Throwable e) {
                        Logger.error(this, "Caught " + e + " while sending messages (" + mi_name + ") to " + pn.getPeer() + requeueLogString, e);
                        if (!dontRequeue) {
                            pn.requeueMessageItems(messages, lastIndex, messages.length - lastIndex, false, "Throwable(3)");
                        }
                        return false;
                    }
                    if (onePacket) {
                        pn.requeueMessageItems(messages, i, messageData.length - i, true, "Didn't fit in single packet");
                        return false;
                    }
                }
                lastIndex = i;
                if (i != messageData.length) {
                    length = 1 + (messageData[i].length + 2);
                }
                count = 0;
                continue;
            }
            length = newLength;
        }
        return true;
    }

    private int innerProcessOutgoing(byte[][] messageData, int start, int length, int bufferLength, PeerNode pn, AsyncMessageCallback[] callbacks, short priority) throws NotConnectedException, WouldBlockException, PacketSequenceException {
        if (logMINOR) {
            Logger.minor(this, "innerProcessOutgoing(...," + start + ',' + length + ',' + bufferLength + ',' + callbacks.length + ')');
        }
        byte[] buf = new byte[bufferLength];
        buf[0] = (byte)length;
        int loc = 1;
        for (int i = start; i < start + length; ++i) {
            byte[] data = messageData[i];
            int len = data.length;
            buf[loc++] = (byte)(len >> 8);
            buf[loc++] = (byte)len;
            System.arraycopy(data, 0, buf, loc, len);
            loc += len;
        }
        return this.processOutgoingPreformatted(buf, 0, loc, pn, callbacks, priority);
    }

    public int processOutgoing(byte[] buf, int offset, int length, SessionKey tracker, short priority) throws KeyChangedException, NotConnectedException, PacketSequenceException, WouldBlockException {
        byte[] newBuf = this.preformat(buf, offset, length);
        return this.processOutgoingPreformatted(newBuf, 0, newBuf.length, tracker, -1, null, priority);
    }

    int processOutgoingPreformatted(byte[] buf, int offset, int length, PeerNode peer, AsyncMessageCallback[] callbacks, short priority) throws NotConnectedException, WouldBlockException, PacketSequenceException {
        SessionKey last = null;
        while (true) {
            try {
                SessionKey tracker;
                if (!peer.isConnected()) {
                    throw new NotConnectedException();
                }
                last = tracker = peer.getCurrentKeyTracker();
                if (tracker == null) {
                    Logger.normal(this, "Dropping packet: Not connected to " + peer.getPeer() + " yet(2)");
                    throw new NotConnectedException();
                }
                PacketTracker packets = tracker.packets;
                int seqNo = packets.allocateOutgoingPacketNumberNeverBlock();
                return this.processOutgoingPreformatted(buf, offset, length, tracker, seqNo, callbacks, priority);
            }
            catch (KeyChangedException e) {
                Logger.normal(this, "Key changed(2) for " + peer.getPeer());
                if (last != peer.getCurrentKeyTracker() || !peer.isConnected()) continue;
                Logger.error(this, "Peer is connected, yet current tracker is deprecated !! (rekey ?): " + e, e);
                throw new NotConnectedException("Peer is connected, yet current tracker is deprecated !! (rekey ?): " + e);
            }
            break;
        }
    }

    byte[] preformat(byte[] buf, int offset, int length) {
        byte[] newBuf;
        if (buf != null) {
            newBuf = new byte[length + 3];
            newBuf[0] = 1;
            newBuf[1] = (byte)(length >> 8);
            newBuf[2] = (byte)length;
            System.arraycopy(buf, offset, newBuf, 3, length);
        } else {
            newBuf = new byte[]{0};
        }
        return newBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processOutgoingPreformatted(byte[] buf, int offset, int length, SessionKey tracker, int packetNumber, AsyncMessageCallback[] callbacks, short priority) throws KeyChangedException, NotConnectedException, PacketSequenceException, WouldBlockException {
        int offsetSeq;
        int i;
        int paddedLen;
        int otherSideSeqNumber;
        int realSeqNumber;
        int[] ackRequests;
        int[] resendRequests;
        int[] forgotPackets;
        int[] acks;
        if (logMINOR) {
            String log = "processOutgoingPreformatted(" + Fields.hashCode(buf) + ", " + offset + ',' + length + ',' + tracker + ',' + packetNumber + ',';
            log = callbacks == null ? log + "null" : log + "" + callbacks.length + Arrays.toString(callbacks);
            Logger.minor(this, log);
        }
        if (tracker == null || !tracker.pn.isConnected()) {
            throw new NotConnectedException();
        }
        PacketTracker packets = tracker.packets;
        int seqNumber = packetNumber > 0 ? packetNumber : (buf.length == 1 ? -1 : packets.allocateOutgoingPacketNumberNeverBlock());
        if (logMINOR) {
            Logger.minor(this, "Sequence number (sending): " + seqNumber + " (" + packetNumber + ") to " + tracker.pn.getPeer());
        }
        try {
            SessionKey sessionKey = tracker;
            synchronized (sessionKey) {
                acks = packets.grabAcks();
                forgotPackets = packets.grabForgotten();
                resendRequests = packets.grabResendRequests();
                ackRequests = packets.grabAckRequests();
                realSeqNumber = packets.getLastOutgoingSeqNumber();
                otherSideSeqNumber = packets.highestReceivedIncomingSeqNumber();
                if (logMINOR) {
                    Logger.minor(this, "Sending packet to " + tracker.pn.getPeer() + ", other side max seqno: " + otherSideSeqNumber);
                }
            }
        }
        catch (StillNotAckedException e) {
            Logger.error(this, "Forcing disconnect on " + tracker.pn + " for " + tracker + " because packets not acked after 10 minutes!");
            tracker.pn.forceDisconnect(true);
            this.disconnectedStillNotAcked(tracker);
            throw new NotConnectedException();
        }
        int packetLength = 17 + (packetNumber == -1 ? 4 : 1) + 4 + 1 + acks.length + 1 + resendRequests.length + 1 + ackRequests.length + 1 + forgotPackets.length + length;
        boolean paddThisPacket = this.crypto.config.paddDataPackets();
        if (paddThisPacket) {
            if (logMINOR) {
                Logger.minor(this, "Pre-padding length: " + packetLength);
            }
            if (packetLength < 64) {
                paddedLen = 64 + this.node.fastWeakRandom.nextInt(32);
            } else {
                int maxPacketSize;
                paddedLen = ((packetLength += 32) + 63) / 64 * 64;
                if (packetLength <= 1280 && (paddedLen += this.node.fastWeakRandom.nextInt(64)) > 1280) {
                    paddedLen = 1280;
                }
                if (packetLength <= (maxPacketSize = this.sock.getMaxPacketSize()) && paddedLen > maxPacketSize) {
                    paddedLen = maxPacketSize;
                }
                packetLength -= 32;
                paddedLen -= 32;
            }
        } else {
            if (logMINOR) {
                Logger.minor(this, "Don't padd the packet: we have been asked not to.");
            }
            paddedLen = packetLength;
        }
        if (paddThisPacket) {
            packetLength = paddedLen;
        }
        if (logMINOR) {
            Logger.minor(this, "Packet length: " + packetLength + " (" + length + ")");
        }
        byte[] plaintext = new byte[packetLength];
        byte[] randomJunk = new byte[12];
        int ptr = offset;
        plaintext[ptr++] = (byte)(seqNumber >> 24);
        plaintext[ptr++] = (byte)(seqNumber >> 16);
        plaintext[ptr++] = (byte)(seqNumber >> 8);
        plaintext[ptr++] = (byte)seqNumber;
        if (logMINOR) {
            Logger.minor(this, "Getting random junk");
        }
        this.node.random.nextBytes(randomJunk);
        System.arraycopy(randomJunk, 0, plaintext, ptr, 12);
        ptr += 12;
        plaintext[ptr++] = 0;
        if (seqNumber == -1) {
            plaintext[ptr++] = (byte)(realSeqNumber >> 24);
            plaintext[ptr++] = (byte)(realSeqNumber >> 16);
            plaintext[ptr++] = (byte)(realSeqNumber >> 8);
            plaintext[ptr++] = (byte)realSeqNumber;
        } else {
            plaintext[ptr++] = (byte)(realSeqNumber - seqNumber);
        }
        plaintext[ptr++] = (byte)(otherSideSeqNumber >> 24);
        plaintext[ptr++] = (byte)(otherSideSeqNumber >> 16);
        plaintext[ptr++] = (byte)(otherSideSeqNumber >> 8);
        plaintext[ptr++] = (byte)otherSideSeqNumber;
        plaintext[ptr++] = (byte)acks.length;
        for (i = 0; i < acks.length; ++i) {
            int ackSeq = acks[i];
            if (logMINOR) {
                Logger.minor(this, "Acking " + ackSeq);
            }
            if ((offsetSeq = otherSideSeqNumber - ackSeq) > 255 || offsetSeq < 0) {
                throw new PacketSequenceException("bad ack offset " + offsetSeq + " - seqNumber=" + otherSideSeqNumber + ", ackNumber=" + ackSeq + " talking to " + tracker.pn.getPeer());
            }
            plaintext[ptr++] = (byte)offsetSeq;
        }
        plaintext[ptr++] = (byte)resendRequests.length;
        for (i = 0; i < resendRequests.length; ++i) {
            int reqSeq = resendRequests[i];
            if (logMINOR) {
                Logger.minor(this, "Resend req: " + reqSeq);
            }
            if ((offsetSeq = otherSideSeqNumber - reqSeq) > 255 || offsetSeq < 0) {
                throw new PacketSequenceException("bad resend request offset " + offsetSeq + " - reqSeq=" + reqSeq + ", otherSideSeqNumber=" + otherSideSeqNumber + " talking to " + tracker.pn.getPeer());
            }
            plaintext[ptr++] = (byte)offsetSeq;
        }
        plaintext[ptr++] = (byte)ackRequests.length;
        if (logMINOR) {
            Logger.minor(this, "Ackrequests: " + ackRequests.length);
        }
        for (i = 0; i < ackRequests.length; ++i) {
            int ackReqSeq = ackRequests[i];
            if (logMINOR) {
                Logger.minor(this, "Ack request " + i + ": " + ackReqSeq);
            }
            if ((offsetSeq = realSeqNumber - ackReqSeq) > 255 || offsetSeq < 0) {
                throw new PacketSequenceException("bad ack requests offset: " + offsetSeq + " - ackReqSeq=" + ackReqSeq + ", packetNumber=" + realSeqNumber + " talking to " + tracker.pn.getPeer());
            }
            plaintext[ptr++] = (byte)offsetSeq;
        }
        byte[] forgotOffsets = null;
        int forgotCount = 0;
        if (forgotPackets.length > 0) {
            for (int i2 = 0; i2 < forgotPackets.length; ++i2) {
                int offsetSeq2;
                int seq = forgotPackets[i2];
                if (logMINOR) {
                    Logger.minor(this, "Forgot packet " + i2 + ": " + seq);
                }
                if ((offsetSeq2 = realSeqNumber - seq) > 255 || offsetSeq2 < 0) {
                    if (packets.isDeprecated()) {
                        Logger.error(this, "Dropping forgot-packet notification on deprecated tracker: " + seq + " on " + tracker + " - real seq=" + realSeqNumber);
                        continue;
                    }
                    Logger.error(this, "bad forgot packet offset: " + offsetSeq2 + " - forgotSeq=" + seq + ", packetNumber=" + realSeqNumber + " talking to " + tracker.pn.getPeer(), new Exception("error"));
                    continue;
                }
                if (forgotOffsets == null) {
                    forgotOffsets = new byte[forgotPackets.length - i2];
                }
                if (forgotCount >= 256) {
                    packets.requeueForgot(forgotPackets, forgotCount, forgotPackets.length - forgotCount);
                    break;
                }
                forgotOffsets[forgotCount++] = (byte)offsetSeq2;
            }
            if (forgotCount >= 256) {
                forgotCount = 255;
            }
        }
        plaintext[ptr++] = (byte)forgotCount;
        if (forgotOffsets != null) {
            System.arraycopy(forgotOffsets, 0, plaintext, ptr, forgotCount);
            ptr += forgotCount;
        }
        System.arraycopy(buf, offset, plaintext, ptr, length);
        ptr += length;
        if (paddThisPacket) {
            byte[] padding = new byte[packetLength - ptr];
            this.node.fastWeakRandom.nextBytes(padding);
            System.arraycopy(padding, 0, plaintext, ptr, padding.length);
            ptr += padding.length;
        } else if (ptr != plaintext.length) {
            Logger.error(this, "Inconsistent length: " + plaintext.length + " buffer but " + ptr + " actual");
            byte[] newBuf = new byte[ptr];
            System.arraycopy(plaintext, 0, newBuf, 0, ptr);
            plaintext = newBuf;
        }
        if (seqNumber != -1) {
            byte[] saveable = new byte[length];
            System.arraycopy(buf, offset, saveable, 0, length);
            packets.sentPacket(saveable, seqNumber, callbacks, priority);
        }
        if (logMINOR) {
            Logger.minor(this, "Sending... " + seqNumber);
        }
        int ret = this.processOutgoingFullyFormatted(plaintext, tracker);
        if (logMINOR) {
            Logger.minor(this, "Sent packet " + seqNumber);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectedStillNotAcked(SessionKey tracker) {
        HashSet<Peer> hashSet = this.peersWithProblems;
        synchronized (hashSet) {
            this.peersWithProblems.add(tracker.pn.getPeer());
            if (this.peersWithProblems.size() > 1) {
                return;
            }
        }
        if (this.node.clientCore == null || this.node.clientCore.alerts == null) {
            return;
        }
        this.node.clientCore.alerts.register(this.disconnectedStillNotAckedAlert);
    }

    private int processOutgoingFullyFormatted(byte[] plaintext, SessionKey kt) {
        BlockCipher sessionCipher = kt.sessionCipher;
        if (logMINOR) {
            Logger.minor(this, "Encrypting with " + HexUtil.bytesToHex(kt.sessionKey));
        }
        if (sessionCipher == null) {
            Logger.error(this, "Dropping packet send - have not handshaked yet");
            return 0;
        }
        int blockSize = sessionCipher.getBlockSize() >> 3;
        if (sessionCipher.getKeySize() != sessionCipher.getBlockSize()) {
            throw new IllegalStateException("Block size must be half key size: blockSize=" + sessionCipher.getBlockSize() + ", keySize=" + sessionCipher.getKeySize());
        }
        MessageDigest md = SHA256.getMessageDigest();
        int digestLength = md.getDigestLength();
        if (digestLength != blockSize) {
            throw new IllegalStateException("Block size must be digest length!");
        }
        byte[] output = new byte[plaintext.length + digestLength];
        System.arraycopy(plaintext, 0, output, digestLength, plaintext.length);
        md.update(plaintext);
        byte[] digestTemp = md.digest();
        SHA256.returnMessageDigest(md);
        md = null;
        if (logMINOR) {
            Logger.minor(this, "\nHash:      " + HexUtil.bytesToHex(digestTemp));
        }
        sessionCipher.encipher(digestTemp, digestTemp);
        System.arraycopy(digestTemp, 0, output, 0, digestLength);
        if (logMINOR) {
            Logger.minor(this, "\nEncrypted: " + HexUtil.bytesToHex(digestTemp) + " (" + plaintext.length + " bytes plaintext)");
        }
        PCFBMode pcfb = PCFBMode.create(sessionCipher, digestTemp);
        pcfb.blockEncipher(output, digestLength, plaintext.length);
        if (logMINOR) {
            Logger.minor(this, "Sending packet of length " + output.length + " (" + Fields.hashCode(output) + ") to " + kt.pn);
        }
        try {
            this.sendPacket(output, kt.pn.getPeer(), kt.pn);
        }
        catch (Peer.LocalAddressException e) {
            Logger.error(this, "Tried to send data packet to local address: " + kt.pn.getPeer() + " for " + kt.pn.allowLocalAddresses());
        }
        kt.pn.sentPacket();
        return output.length + this.sock.getHeadersLength();
    }

    protected String l10n(String key, String[] patterns, String[] values) {
        return L10n.getString("FNPPacketMangler." + key, patterns, values);
    }

    protected String l10n(String key, String pattern, String value) {
        return L10n.getString("FNPPacketMangler." + key, pattern, value);
    }

    public void sendHandshake(PeerNode pn, boolean notRegistered) {
        Peer peer;
        int negType = pn.selectNegType(this);
        if (negType == -1) {
            int[] negTypes = this.supportedNegTypes();
            negType = negTypes[this.node.random.nextInt(negTypes.length)];
            Logger.normal(this, "Cannot send handshake to " + pn + " because no common negTypes, choosing random negType of " + negType);
        }
        if (logMINOR) {
            Logger.minor(this, "Possibly sending handshake to " + pn + " negotiation type " + negType);
        }
        if ((peer = pn.getHandshakeIP()) == null) {
            pn.couldNotSendHandshake(notRegistered);
            return;
        }
        Peer oldPeer = peer;
        if ((peer = peer.dropHostName()) == null) {
            Logger.error(this, "No address for peer " + oldPeer + " so cannot send handshake");
            pn.couldNotSendHandshake(notRegistered);
            return;
        }
        this.sendJFKMessage1(pn, peer, pn.handshakeUnknownInitiator(), pn.handshakeSetupType(), negType);
        if (logMINOR) {
            Logger.minor(this, "Sending handshake to " + peer + " for " + pn);
        }
        pn.sentHandshake(notRegistered);
    }

    public boolean isDisconnected(PeerContext context) {
        if (context == null) {
            return false;
        }
        return !((PeerNode)context).isConnected();
    }

    public void resend(ResendPacketItem item, SessionKey tracker) throws PacketSequenceException, WouldBlockException, KeyChangedException, NotConnectedException {
        int size = this.processOutgoingPreformatted(item.buf, 0, item.buf.length, tracker, item.packetNumber, item.callbacks, item.priority);
        item.pn.resendByteCounter.sentBytes(size);
    }

    public int[] supportedNegTypes() {
        return new int[]{2, 4};
    }

    public int fullHeadersLengthOneMessage() {
        return this.fullHeadersLengthOneMessage;
    }

    public SocketHandler getSocketHandler() {
        return this.sock;
    }

    public Peer[] getPrimaryIPAddress() {
        return this.crypto.detector.getPrimaryPeers();
    }

    public byte[] getCompressedNoderef() {
        return this.crypto.myCompressedFullRef();
    }

    public boolean alwaysAllowLocalAddresses() {
        return this.crypto.config.alwaysAllowLocalAddresses();
    }

    private DiffieHellmanLightContext _genLightDiffieHellmanContext() {
        DiffieHellmanLightContext ctx = DiffieHellman.generateLightContext();
        ctx.setSignature(this.crypto.sign(SHA256.digest(this.assembleDHParams(ctx.myExponential, this.crypto.getCryptoGroup()))));
        return ctx;
    }

    private final void _fillJFKDHFIFOOffThread() {
        this.node.executor.execute(new PrioRunnable(){

            public void run() {
                FNPPacketMangler.this._fillJFKDHFIFO();
            }

            public int getPriority() {
                return 7;
            }
        }, "DiffieHellman exponential signing");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _fillJFKDHFIFO() {
        LinkedList<DiffieHellmanLightContext> linkedList = this.dhContextFIFO;
        synchronized (linkedList) {
            if (this.dhContextFIFO.size() + 1 > 20) {
                DiffieHellmanLightContext result = null;
                long oldestSeen = Long.MAX_VALUE;
                for (DiffieHellmanLightContext tmp : this.dhContextFIFO) {
                    if (tmp.lifetime >= oldestSeen) continue;
                    oldestSeen = tmp.lifetime;
                    result = tmp;
                }
                this.dhContextToBePrunned = result;
                this.dhContextFIFO.remove(this.dhContextToBePrunned);
            }
            this.dhContextFIFO.addLast(this._genLightDiffieHellmanContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiffieHellmanLightContext getLightDiffieHellmanContext() {
        long now = System.currentTimeMillis();
        DiffieHellmanLightContext result = null;
        LinkedList<DiffieHellmanLightContext> linkedList = this.dhContextFIFO;
        synchronized (linkedList) {
            result = this.dhContextFIFO.removeFirst();
            if (this.jfkDHLastGenerationTimestamp + 30000L < now) {
                this.jfkDHLastGenerationTimestamp = now;
                this._fillJFKDHFIFOOffThread();
            }
            this.dhContextFIFO.addLast(result);
        }
        Logger.minor(this, "getLightDiffieHellmanContext() is serving " + result.hashCode());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiffieHellmanLightContext findContextByExponential(BigInteger exponential) {
        LinkedList<DiffieHellmanLightContext> linkedList = this.dhContextFIFO;
        synchronized (linkedList) {
            for (DiffieHellmanLightContext result : this.dhContextFIFO) {
                if (!exponential.equals(result.myExponential)) continue;
                return result;
            }
            if (this.dhContextToBePrunned != null && this.dhContextToBePrunned.myExponential.equals(exponential)) {
                return this.dhContextToBePrunned;
            }
        }
        return null;
    }

    private byte[] assembleDHParams(BigInteger exponential, DSAGroup group) {
        byte[] _myExponential = this.stripBigIntegerToNetworkFormat(exponential);
        byte[] _myGroup = group.getP().toByteArray();
        byte[] toSign = new byte[_myExponential.length + _myGroup.length];
        System.arraycopy(_myExponential, 0, toSign, 0, _myExponential.length);
        System.arraycopy(_myGroup, 0, toSign, _myExponential.length, _myGroup.length);
        return toSign;
    }

    private byte[] assembleDHParams(byte[] nonceInitiator, byte[] nonceResponder, BigInteger initiatorExponential, BigInteger responderExponential, byte[] id, byte[] sa) {
        byte[] _initiatorExponential = this.stripBigIntegerToNetworkFormat(initiatorExponential);
        byte[] _responderExponential = this.stripBigIntegerToNetworkFormat(responderExponential);
        byte[] result = new byte[nonceInitiator.length + nonceResponder.length + _initiatorExponential.length + _responderExponential.length + id.length + sa.length];
        int offset = 0;
        System.arraycopy(nonceInitiator, 0, result, offset, nonceInitiator.length);
        System.arraycopy(nonceResponder, 0, result, offset += nonceInitiator.length, nonceResponder.length);
        System.arraycopy(_initiatorExponential, 0, result, offset += nonceResponder.length, _initiatorExponential.length);
        System.arraycopy(_responderExponential, 0, result, offset += _initiatorExponential.length, _responderExponential.length);
        System.arraycopy(id, 0, result, offset += _responderExponential.length, id.length);
        System.arraycopy(sa, 0, result, offset += id.length, sa.length);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getTransientKey() {
        HashMap<ByteArrayWrapper, byte[]> hashMap = this.authenticatorCache;
        synchronized (hashMap) {
            return this.transientKey;
        }
    }

    private byte[] computeJFKSharedKey(BigInteger exponential, byte[] nI, byte[] nR, String what) {
        assert ("0".equals(what) || "1".equals(what) || "2".equals(what));
        byte[] number = null;
        try {
            number = what.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
        }
        byte[] toHash = new byte[16 + number.length];
        int offset = 0;
        System.arraycopy(nI, 0, toHash, offset, 8);
        System.arraycopy(nR, 0, toHash, offset += 8, 8);
        System.arraycopy(number, 0, toHash, offset += 8, number.length);
        return HMAC.macWithSHA256(exponential.toByteArray(), toHash, HASH_LENGTH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean maybeResetTransientKey() {
        long now = System.currentTimeMillis();
        boolean isCacheTooBig = true;
        int authenticatorCacheSize = 0;
        HashMap<ByteArrayWrapper, byte[]> hashMap = this.authenticatorCache;
        synchronized (hashMap) {
            authenticatorCacheSize = this.authenticatorCache.size();
            if (authenticatorCacheSize < 30) {
                isCacheTooBig = false;
                if (now - this.timeLastReset < 1800000L) {
                    return false;
                }
            }
            this.timeLastReset = now;
            this.node.random.nextBytes(this.transientKey);
            this.authenticatorCache.clear();
        }
        this.node.getTicker().queueTimedJob(this.transientKeyRekeyer, "JFKmaybeResetTransientKey" + now, 1800000L, false, false);
        Logger.normal(this, "JFK's TransientKey has been changed and the message cache flushed because " + (isCacheTooBig ? "the cache is oversized (" + authenticatorCacheSize + ')' : "it's time to rekey") + " on " + this);
        return true;
    }

    private byte[] stripBigIntegerToNetworkFormat(BigInteger exponential) {
        int targetLength;
        byte[] data = exponential.toByteArray();
        if (data.length != (targetLength = DiffieHellman.modulusLengthInBytes())) {
            byte[] newData = new byte[targetLength];
            if (data.length == targetLength + 1 && data[0] == 0) {
                System.arraycopy(data, 1, newData, 0, targetLength);
            } else if (data.length < targetLength) {
                System.arraycopy(data, 0, newData, targetLength - data.length, data.length);
            } else {
                throw new IllegalStateException("Too long!");
            }
            data = newData;
        }
        return data;
    }

    public int getConnectivityStatus() {
        if (this.crypto.config.alwaysHandshakeAggressively()) {
            return -2;
        }
        return this.sock.getDetectedConnectivityStatus();
    }

    public boolean allowConnection(PeerNode pn, FreenetInetAddress addr) {
        return this.crypto.allowConnection(pn, addr);
    }

    public void setPortForwardingBroken() {
        this.crypto.setPortForwardingBroken();
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
                logDEBUG = Logger.shouldLog(2, this);
            }
        });
        byte[] I = null;
        byte[] R = null;
        try {
            I = "I".getBytes("UTF-8");
            R = "R".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
        }
        JFK_PREFIX_INITIATOR = I;
        JFK_PREFIX_RESPONDER = R;
        TRANSIENT_KEY_SIZE = HASH_LENGTH = SHA256.getDigestLength();
        HEADERS_LENGTH_MINIMUM = 26 + HASH_LENGTH + 1;
        HEADERS_LENGTH_ONE_MESSAGE = HEADERS_LENGTH_MINIMUM + 2;
        LOG_UNMATCHABLE_ERROR = false;
    }
}

