/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.client.DefaultMIMETypes;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.FreenetInetAddress;
import freenet.io.comm.Message;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.Peer;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.io.xfer.BulkReceiver;
import freenet.io.xfer.BulkTransmitter;
import freenet.io.xfer.PartiallyReceivedBulk;
import freenet.l10n.L10n;
import freenet.node.DarknetPeerNodeStatus;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.node.NodeCrypto;
import freenet.node.OutgoingPacketMangler;
import freenet.node.PeerManager;
import freenet.node.PeerNode;
import freenet.node.PeerNodeStatus;
import freenet.node.useralerts.AbstractUserAlert;
import freenet.node.useralerts.N2NTMUserAlert;
import freenet.node.useralerts.UserAlert;
import freenet.support.Base64;
import freenet.support.Fields;
import freenet.support.HTMLNode;
import freenet.support.IllegalBase64Exception;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.SizeUtil;
import freenet.support.io.FileUtil;
import freenet.support.io.RandomAccessFileWrapper;
import freenet.support.io.RandomAccessThing;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;

public class DarknetPeerNode
extends PeerNode {
    String myName;
    private boolean isDisabled;
    private boolean isListenOnly;
    private boolean isBurstOnly;
    private boolean ignoreSourcePort;
    private boolean allowLocalAddresses;
    private LinkedHashSet<Integer> extraPeerDataFileNumbers;
    private String privateDarknetComment;
    private int privateDarknetCommentFileNumber;
    private LinkedHashSet<Integer> queuedToSendN2NMExtraPeerDataFileNumbers;
    private static boolean logMINOR;
    private final HashMap<Long, FileOffer> myFileOffersByUID = new HashMap();
    private final HashMap<Long, FileOffer> hisFileOffersByUID = new HashMap();

    public DarknetPeerNode(SimpleFieldSet fs, Node node2, NodeCrypto crypto, PeerManager peers, boolean fromLocal, OutgoingPacketMangler mangler) throws FSParseException, PeerParseException, ReferenceSignatureVerificationException {
        super(fs, node2, crypto, peers, fromLocal, false, mangler, false);
        logMINOR = Logger.shouldLog(4, this);
        String name = fs.get("myName");
        if (name == null) {
            throw new FSParseException("No name");
        }
        this.myName = name;
        if (fromLocal) {
            SimpleFieldSet metadata = fs.subset("metadata");
            this.isDisabled = Fields.stringToBool(metadata.get("isDisabled"), false);
            this.isListenOnly = Fields.stringToBool(metadata.get("isListenOnly"), false);
            this.isBurstOnly = Fields.stringToBool(metadata.get("isBurstOnly"), false);
            this.disableRouting = this.disableRoutingHasBeenSetLocally = Fields.stringToBool(metadata.get("disableRoutingHasBeenSetLocally"), false);
            this.ignoreSourcePort = Fields.stringToBool(metadata.get("ignoreSourcePort"), false);
            this.allowLocalAddresses = Fields.stringToBool(metadata.get("allowLocalAddresses"), false);
        }
        this.privateDarknetComment = "";
        this.privateDarknetCommentFileNumber = -1;
        this.extraPeerDataFileNumbers = new LinkedHashSet();
        this.queuedToSendN2NMExtraPeerDataFileNumbers = new LinkedHashSet();
    }

    public synchronized Peer getPeer() {
        Peer detectedPeer = super.getPeer();
        if (this.ignoreSourcePort) {
            int port;
            FreenetInetAddress addr = detectedPeer == null ? null : detectedPeer.getFreenetAddress();
            int n = port = detectedPeer == null ? -1 : detectedPeer.getPort();
            if (this.nominalPeer == null) {
                return detectedPeer;
            }
            for (Peer p : this.nominalPeer) {
                if (p.getPort() == port || !p.getFreenetAddress().equals(addr)) continue;
                return p;
            }
        }
        return detectedPeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldSendHandshake() {
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            if (this.isDisabled) {
                return false;
            }
            if (this.isListenOnly) {
                return false;
            }
            if (!super.shouldSendHandshake()) {
                return false;
            }
        }
        return true;
    }

    protected synchronized boolean innerProcessNewNoderef(SimpleFieldSet fs, boolean forARK, boolean forDiffNodeRef) throws FSParseException {
        boolean changedAnything = super.innerProcessNewNoderef(fs, forARK, forDiffNodeRef);
        String name = fs.get("myName");
        if (name != null && !name.equals(this.myName)) {
            changedAnything = true;
            this.myName = name;
        }
        return changedAnything;
    }

    public synchronized SimpleFieldSet exportFieldSet() {
        SimpleFieldSet fs = super.exportFieldSet();
        fs.putSingle("myName", this.getName());
        return fs;
    }

    public synchronized SimpleFieldSet exportMetadataFieldSet() {
        SimpleFieldSet fs = super.exportMetadataFieldSet();
        if (this.isDisabled) {
            fs.putSingle("isDisabled", "true");
        }
        if (this.isListenOnly) {
            fs.putSingle("isListenOnly", "true");
        }
        if (this.isBurstOnly) {
            fs.putSingle("isBurstOnly", "true");
        }
        if (this.ignoreSourcePort) {
            fs.putSingle("ignoreSourcePort", "true");
        }
        if (this.allowLocalAddresses) {
            fs.putSingle("allowLocalAddresses", "true");
        }
        if (this.disableRoutingHasBeenSetLocally) {
            fs.putSingle("disableRoutingHasBeenSetLocally", "true");
        }
        return fs;
    }

    public synchronized String getName() {
        return this.myName;
    }

    protected synchronized int getPeerNodeStatus(long now, long backedOffUntil) {
        if (this.isDisabled) {
            return 7;
        }
        int status = super.getPeerNodeStatus(now, backedOffUntil);
        if (status == 1 || status == 11 || status == 2 || status == 12 || status == 3 || status == 4 || status == 14 || status == 13) {
            return status;
        }
        if (this.isListenOnly) {
            return 10;
        }
        if (this.isBurstOnly) {
            return 9;
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enablePeer() {
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            this.isDisabled = false;
        }
        this.setPeerNodeStatus(System.currentTimeMillis());
        this.node.peers.writePeers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disablePeer() {
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            this.isDisabled = true;
        }
        if (this.isConnected()) {
            this.forceDisconnect(true);
        }
        this.stopARKFetcher();
        this.setPeerNodeStatus(System.currentTimeMillis());
        this.node.peers.writePeers();
    }

    public synchronized boolean isDisabled() {
        return this.isDisabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListenOnly(boolean setting) {
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            this.isListenOnly = setting;
        }
        if (setting && this.isBurstOnly()) {
            this.setBurstOnly(false);
        }
        if (setting) {
            this.stopARKFetcher();
        }
        this.setPeerNodeStatus(System.currentTimeMillis());
        this.node.peers.writePeers();
    }

    public synchronized boolean isListenOnly() {
        return this.isListenOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBurstOnly(boolean setting) {
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            this.isBurstOnly = setting;
        }
        if (setting && this.isListenOnly()) {
            this.setListenOnly(false);
        }
        long now = System.currentTimeMillis();
        if (!setting) {
            DarknetPeerNode darknetPeerNode2 = this;
            synchronized (darknetPeerNode2) {
                this.sendHandshakeTime = now;
            }
        }
        this.setPeerNodeStatus(now);
        this.node.peers.writePeers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIgnoreSourcePort(boolean setting) {
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            this.ignoreSourcePort = setting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRoutingStatus(boolean shouldRoute, boolean localRequest) {
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            if (localRequest) {
                this.disableRoutingHasBeenSetLocally = !shouldRoute;
            } else {
                this.disableRoutingHasBeenSetRemotely = !shouldRoute;
            }
            this.disableRouting = this.disableRoutingHasBeenSetLocally || this.disableRoutingHasBeenSetRemotely;
        }
        if (localRequest) {
            Message msg = DMT.createRoutingStatus(shouldRoute);
            try {
                this.sendAsync(msg, null, this.node.nodeStats.setRoutingStatusCtr);
            }
            catch (NotConnectedException e) {
                // empty catch block
            }
        }
        this.setPeerNodeStatus(System.currentTimeMillis());
        this.node.peers.writePeers();
    }

    public boolean isIgnoreSourcePort() {
        return this.ignoreSourcePort;
    }

    public boolean isIgnoreSource() {
        return this.ignoreSourcePort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBurstOnly() {
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            if (this.isBurstOnly) {
                return true;
            }
        }
        return super.isBurstOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allowLocalAddresses() {
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            if (this.allowLocalAddresses) {
                return true;
            }
        }
        return super.allowLocalAddresses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowLocalAddresses(boolean setting) {
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            this.allowLocalAddresses = setting;
        }
        this.node.peers.writePeers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readExtraPeerData() {
        String extraPeerDataDirPath = this.node.getExtraPeerDataDir();
        File extraPeerDataPeerDir = new File(extraPeerDataDirPath + File.separator + this.getIdentityString());
        if (!extraPeerDataPeerDir.exists()) {
            return false;
        }
        if (!extraPeerDataPeerDir.isDirectory()) {
            Logger.error(this, "Extra peer data directory for peer not a directory: " + extraPeerDataPeerDir.getPath());
            return false;
        }
        File[] extraPeerDataFiles = extraPeerDataPeerDir.listFiles();
        if (extraPeerDataFiles == null) {
            return false;
        }
        boolean gotError = false;
        boolean readResult = false;
        for (File extraPeerDataFile : extraPeerDataFiles) {
            Integer fileNumber;
            try {
                fileNumber = Integer.valueOf(extraPeerDataFile.getName());
            }
            catch (NumberFormatException e) {
                gotError = true;
                continue;
            }
            LinkedHashSet<Integer> linkedHashSet = this.extraPeerDataFileNumbers;
            synchronized (linkedHashSet) {
                this.extraPeerDataFileNumbers.add(fileNumber);
            }
            readResult = this.readExtraPeerDataFile(extraPeerDataFile, fileNumber);
            if (readResult) continue;
            gotError = true;
        }
        return !gotError;
    }

    public boolean rereadExtraPeerDataFile(int fileNumber) {
        String extraPeerDataDirPath;
        File extraPeerDataPeerDir;
        if (logMINOR) {
            Logger.minor(this, "Rereading peer data file " + fileNumber + " for " + this.shortToString());
        }
        if (!(extraPeerDataPeerDir = new File((extraPeerDataDirPath = this.node.getExtraPeerDataDir()) + File.separator + this.getIdentityString())).exists()) {
            Logger.error(this, "Extra peer data directory for peer does not exist: " + extraPeerDataPeerDir.getPath());
            return false;
        }
        if (!extraPeerDataPeerDir.isDirectory()) {
            Logger.error(this, "Extra peer data directory for peer not a directory: " + extraPeerDataPeerDir.getPath());
            return false;
        }
        File extraPeerDataFile = new File(extraPeerDataDirPath + File.separator + this.getIdentityString() + File.separator + fileNumber);
        if (!extraPeerDataFile.exists()) {
            Logger.error(this, "Extra peer data file for peer does not exist: " + extraPeerDataFile.getPath());
            return false;
        }
        return this.readExtraPeerDataFile(extraPeerDataFile, fileNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean readExtraPeerDataFile(File extraPeerDataFile, int fileNumber) {
        SimpleFieldSet fs;
        boolean gotError;
        block21: {
            InputStreamReader isr;
            FileInputStream fis;
            if (logMINOR) {
                Logger.minor(this, "Reading " + extraPeerDataFile + " : " + fileNumber + " for " + this.shortToString());
            }
            gotError = false;
            if (!extraPeerDataFile.exists()) {
                if (logMINOR) {
                    Logger.minor(this, "Does not exist");
                }
                return false;
            }
            Logger.normal(this, "extraPeerDataFile: " + extraPeerDataFile.getPath());
            try {
                fis = new FileInputStream(extraPeerDataFile);
            }
            catch (FileNotFoundException e1) {
                Logger.normal(this, "Extra peer data file not found: " + extraPeerDataFile.getPath());
                return false;
            }
            try {
                isr = new InputStreamReader((InputStream)fis, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
            }
            BufferedReader br = new BufferedReader(isr);
            fs = null;
            fs = new SimpleFieldSet(br, false, true);
            Object var10_10 = null;
            try {
                br.close();
            }
            catch (IOException e5) {
                Logger.error(this, "Ignoring " + e5 + " caught reading " + extraPeerDataFile.getPath(), e5);
            }
            break block21;
            {
                catch (EOFException e3) {
                    Object var10_11 = null;
                    try {
                        br.close();
                    }
                    catch (IOException e5) {
                        Logger.error(this, "Ignoring " + e5 + " caught reading " + extraPeerDataFile.getPath(), e5);
                    }
                    break block21;
                }
                catch (IOException e4) {
                    Logger.error(this, "Could not read extra peer data file: " + e4, e4);
                    Object var10_12 = null;
                    try {
                        br.close();
                    }
                    catch (IOException e5) {
                        Logger.error(this, "Ignoring " + e5 + " caught reading " + extraPeerDataFile.getPath(), e5);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    br.close();
                }
                catch (IOException e5) {
                    Logger.error(this, "Ignoring " + e5 + " caught reading " + extraPeerDataFile.getPath(), e5);
                }
                throw throwable;
            }
        }
        if (fs == null) {
            Logger.normal(this, "Deleting corrupt (too short?) file: " + extraPeerDataFile);
            this.deleteExtraPeerDataFile(fileNumber);
            return true;
        }
        boolean parseResult = false;
        try {
            parseResult = this.parseExtraPeerData(fs, extraPeerDataFile, fileNumber);
            if (!parseResult) {
                gotError = true;
            }
        }
        catch (FSParseException e2) {
            Logger.error(this, "Could not parse extra peer data: " + e2 + '\n' + fs.toString(), e2);
            gotError = true;
        }
        return !gotError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseExtraPeerData(SimpleFieldSet fs, File extraPeerDataFile, int fileNumber) throws FSParseException {
        String extraPeerDataTypeString = fs.get("extraPeerDataType");
        int extraPeerDataType = -1;
        try {
            extraPeerDataType = Integer.parseInt(extraPeerDataTypeString);
        }
        catch (NumberFormatException e) {
            Logger.error(this, "NumberFormatException parsing extraPeerDataType (" + extraPeerDataTypeString + ") in file " + extraPeerDataFile.getPath());
            return false;
        }
        if (extraPeerDataType == 1) {
            this.node.handleNodeToNodeTextMessageSimpleFieldSet(fs, this, fileNumber);
            return true;
        }
        if (extraPeerDataType == 2) {
            String peerNoteTypeString = fs.get("peerNoteType");
            int peerNoteType = -1;
            try {
                peerNoteType = Integer.parseInt(peerNoteTypeString);
            }
            catch (NumberFormatException e) {
                Logger.error(this, "NumberFormatException parsing peerNoteType (" + peerNoteTypeString + ") in file " + extraPeerDataFile.getPath());
                return false;
            }
            if (peerNoteType == 1) {
                String e = this.privateDarknetComment;
                synchronized (e) {
                    try {
                        this.privateDarknetComment = new String(Base64.decode(fs.get("privateDarknetComment")));
                    }
                    catch (IllegalBase64Exception e2) {
                        Logger.error(this, "Bad Base64 encoding when decoding a private darknet comment SimpleFieldSet", e2);
                        return false;
                    }
                    this.privateDarknetCommentFileNumber = fileNumber;
                }
                return true;
            }
            Logger.error(this, "Read unknown peer note type '" + peerNoteType + "' from file " + extraPeerDataFile.getPath());
            return false;
        }
        if (extraPeerDataType == 3) {
            boolean sendSuccess = false;
            int type = fs.getInt("n2nType");
            if (this.isConnected()) {
                Message n2nm;
                if (fs.get("extraPeerDataType") != null) {
                    fs.removeValue("extraPeerDataType");
                }
                if (fs.get("senderFileNumber") != null) {
                    fs.removeValue("senderFileNumber");
                }
                fs.putOverwrite("senderFileNumber", String.valueOf(fileNumber));
                if (fs.get("sentTime") != null) {
                    fs.removeValue("sentTime");
                }
                fs.putOverwrite("sentTime", Long.toString(System.currentTimeMillis()));
                try {
                    n2nm = DMT.createNodeToNodeMessage(type, fs.toString().getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    Logger.error(this, "UnsupportedEncodingException processing extraPeerDataType (" + extraPeerDataTypeString + ") in file " + extraPeerDataFile.getPath(), e);
                    throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
                }
                try {
                    LinkedHashSet<Integer> e = this.queuedToSendN2NMExtraPeerDataFileNumbers;
                    synchronized (e) {
                        this.node.usm.send(this, n2nm, null);
                        Logger.normal(this, "Sent queued (" + fileNumber + ") N2NM to '" + this.getName() + "': " + n2nm);
                        sendSuccess = true;
                        this.queuedToSendN2NMExtraPeerDataFileNumbers.remove(fileNumber);
                    }
                    this.deleteExtraPeerDataFile(fileNumber);
                }
                catch (NotConnectedException e) {
                    sendSuccess = false;
                }
            }
            if (!sendSuccess) {
                LinkedHashSet<Integer> linkedHashSet = this.queuedToSendN2NMExtraPeerDataFileNumbers;
                synchronized (linkedHashSet) {
                    fs.putOverwrite("extraPeerDataType", Integer.toString(extraPeerDataType));
                    fs.removeValue("sentTime");
                    this.queuedToSendN2NMExtraPeerDataFileNumbers.add(fileNumber);
                }
            }
            return true;
        }
        Logger.error(this, "Read unknown extra peer data type '" + extraPeerDataType + "' from file " + extraPeerDataFile.getPath());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeNewExtraPeerDataFile(SimpleFieldSet fs, int extraPeerDataType) {
        OutputStreamWriter w;
        FileOutputStream fos;
        File extraPeerDataPeerDir;
        String extraPeerDataDirPath = this.node.getExtraPeerDataDir();
        if (extraPeerDataType > 0) {
            fs.putOverwrite("extraPeerDataType", Integer.toString(extraPeerDataType));
        }
        if (!(extraPeerDataPeerDir = new File(extraPeerDataDirPath + File.separator + this.getIdentityString())).exists() && !extraPeerDataPeerDir.mkdir()) {
            Logger.error(this, "Extra peer data directory for peer could not be created: " + extraPeerDataPeerDir.getPath());
            return -1;
        }
        if (!extraPeerDataPeerDir.isDirectory()) {
            Logger.error(this, "Extra peer data directory for peer not a directory: " + extraPeerDataPeerDir.getPath());
            return -1;
        }
        int nextFileNumber = 0;
        LinkedHashSet<Integer> linkedHashSet = this.extraPeerDataFileNumbers;
        synchronized (linkedHashSet) {
            int localFileNumber;
            Object[] localFileNumbers = this.extraPeerDataFileNumbers.toArray(new Integer[this.extraPeerDataFileNumbers.size()]);
            Arrays.sort(localFileNumbers);
            Object[] arr$ = localFileNumbers;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (localFileNumber = ((Integer)arr$[i$]).intValue()) <= nextFileNumber; ++i$) {
                nextFileNumber = localFileNumber + 1;
            }
            this.extraPeerDataFileNumbers.add(nextFileNumber);
        }
        File extraPeerDataFile = new File(extraPeerDataPeerDir.getPath() + File.separator + nextFileNumber);
        if (extraPeerDataFile.exists()) {
            Logger.error(this, "Extra peer data file already exists: " + extraPeerDataFile.getPath());
            return -1;
        }
        String f = extraPeerDataFile.getPath();
        try {
            fos = new FileOutputStream(f);
        }
        catch (FileNotFoundException e2) {
            Logger.error(this, "Cannot write extra peer data file to disk: Cannot create " + f + " - " + e2, e2);
            return -1;
        }
        try {
            w = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e2, e2);
        }
        BufferedWriter bw = new BufferedWriter(w);
        try {
            fs.writeTo(bw);
            bw.close();
        }
        catch (IOException e) {
            try {
                fos.close();
            }
            catch (IOException e1) {
                Logger.error(this, "Cannot close extra peer data file: " + e, e);
            }
            Logger.error(this, "Cannot write file: " + e, e);
            return -1;
        }
        return nextFileNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteExtraPeerDataFile(int fileNumber) {
        String extraPeerDataDirPath = this.node.getExtraPeerDataDir();
        File extraPeerDataPeerDir = new File(extraPeerDataDirPath, this.getIdentityString());
        if (!extraPeerDataPeerDir.exists()) {
            Logger.error(this, "Extra peer data directory for peer does not exist: " + extraPeerDataPeerDir.getPath());
            return;
        }
        if (!extraPeerDataPeerDir.isDirectory()) {
            Logger.error(this, "Extra peer data directory for peer not a directory: " + extraPeerDataPeerDir.getPath());
            return;
        }
        File extraPeerDataFile = new File(extraPeerDataPeerDir, Integer.toString(fileNumber));
        if (!extraPeerDataFile.exists()) {
            Logger.error(this, "Extra peer data file for peer does not exist: " + extraPeerDataFile.getPath());
            return;
        }
        LinkedHashSet<Integer> linkedHashSet = this.extraPeerDataFileNumbers;
        synchronized (linkedHashSet) {
            this.extraPeerDataFileNumbers.remove(fileNumber);
        }
        if (!extraPeerDataFile.delete()) {
            if (extraPeerDataFile.exists()) {
                Logger.error(this, "Cannot delete file " + extraPeerDataFile + " after sending message to " + this.getPeer() + " - it may be resent on resting the node");
            } else {
                Logger.normal(this, "File does not exist when deleting: " + extraPeerDataFile + " after sending message to " + this.getPeer());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExtraPeerDataDir() {
        Integer[] localFileNumbers;
        String extraPeerDataDirPath = this.node.getExtraPeerDataDir();
        File extraPeerDataPeerDir = new File(extraPeerDataDirPath + File.separator + this.getIdentityString());
        if (!extraPeerDataPeerDir.exists()) {
            Logger.error(this, "Extra peer data directory for peer does not exist: " + extraPeerDataPeerDir.getPath());
            return;
        }
        if (!extraPeerDataPeerDir.isDirectory()) {
            Logger.error(this, "Extra peer data directory for peer not a directory: " + extraPeerDataPeerDir.getPath());
            return;
        }
        LinkedHashSet<Integer> linkedHashSet = this.extraPeerDataFileNumbers;
        synchronized (linkedHashSet) {
            localFileNumbers = this.extraPeerDataFileNumbers.toArray(new Integer[this.extraPeerDataFileNumbers.size()]);
        }
        for (Integer localFileNumber : localFileNumbers) {
            this.deleteExtraPeerDataFile(localFileNumber);
        }
        extraPeerDataPeerDir.delete();
    }

    public boolean rewriteExtraPeerDataFile(SimpleFieldSet fs, int extraPeerDataType, int fileNumber) {
        OutputStreamWriter w;
        FileOutputStream fos;
        File extraPeerDataPeerDir;
        String extraPeerDataDirPath = this.node.getExtraPeerDataDir();
        if (extraPeerDataType > 0) {
            fs.putOverwrite("extraPeerDataType", Integer.toString(extraPeerDataType));
        }
        if (!(extraPeerDataPeerDir = new File(extraPeerDataDirPath + File.separator + this.getIdentityString())).exists()) {
            Logger.error(this, "Extra peer data directory for peer does not exist: " + extraPeerDataPeerDir.getPath());
            return false;
        }
        if (!extraPeerDataPeerDir.isDirectory()) {
            Logger.error(this, "Extra peer data directory for peer not a directory: " + extraPeerDataPeerDir.getPath());
            return false;
        }
        File extraPeerDataFile = new File(extraPeerDataDirPath + File.separator + this.getIdentityString() + File.separator + fileNumber);
        if (!extraPeerDataFile.exists()) {
            Logger.error(this, "Extra peer data file for peer does not exist: " + extraPeerDataFile.getPath());
            return false;
        }
        String f = extraPeerDataFile.getPath();
        try {
            fos = new FileOutputStream(f);
        }
        catch (FileNotFoundException e2) {
            Logger.error(this, "Cannot write extra peer data file to disk: Cannot open " + f + " - " + e2, e2);
            return false;
        }
        try {
            w = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e2, e2);
        }
        BufferedWriter bw = new BufferedWriter(w);
        try {
            fs.writeTo(bw);
            bw.close();
        }
        catch (IOException e) {
            try {
                fos.close();
            }
            catch (IOException e1) {
                Logger.error(this, "Cannot close extra peer data file: " + e, e);
            }
            Logger.error(this, "Cannot write file: " + e, e);
            return false;
        }
        return true;
    }

    public synchronized String getPrivateDarknetCommentNote() {
        return this.privateDarknetComment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setPrivateDarknetCommentNote(String comment) {
        int localFileNumber;
        String string = this.privateDarknetComment;
        synchronized (string) {
            this.privateDarknetComment = comment;
            localFileNumber = this.privateDarknetCommentFileNumber;
        }
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.put("peerNoteType", 1);
        try {
            fs.putSingle("privateDarknetComment", Base64.encode(comment.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
        }
        if (localFileNumber == -1) {
            localFileNumber = this.writeNewExtraPeerDataFile(fs, 2);
            String string2 = this.privateDarknetComment;
            synchronized (string2) {
                this.privateDarknetCommentFileNumber = localFileNumber;
            }
        } else {
            this.rewriteExtraPeerDataFile(fs, 2, localFileNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueN2NM(SimpleFieldSet fs) {
        int fileNumber = this.writeNewExtraPeerDataFile(fs, 3);
        LinkedHashSet<Integer> linkedHashSet = this.queuedToSendN2NMExtraPeerDataFileNumbers;
        synchronized (linkedHashSet) {
            this.queuedToSendN2NMExtraPeerDataFileNumbers.add(fileNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendQueuedN2NMs() {
        Object[] localFileNumbers;
        if (logMINOR) {
            Logger.minor(this, "Sending queued N2NMs for " + this.shortToString());
        }
        LinkedHashSet<Integer> linkedHashSet = this.queuedToSendN2NMExtraPeerDataFileNumbers;
        synchronized (linkedHashSet) {
            localFileNumbers = this.queuedToSendN2NMExtraPeerDataFileNumbers.toArray(new Integer[this.queuedToSendN2NMExtraPeerDataFileNumbers.size()]);
        }
        Arrays.sort(localFileNumbers);
        for (Object localFileNumber : localFileNumbers) {
            this.rereadExtraPeerDataFile((Integer)localFileNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startARKFetcher() {
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            if (this.isListenOnly) {
                Logger.minor(this, "Not starting ark fetcher for " + this + " as it's in listen-only mode.");
                return;
            }
        }
        super.startARKFetcher();
    }

    public String getTMCIPeerInfo() {
        return this.getName() + '\t' + super.getTMCIPeerInfo();
    }

    protected void onConnect() {
        super.onConnect();
        this.sendQueuedN2NMs();
    }

    private void storeOffers() {
    }

    public int sendTextMessage(String message) {
        long now = System.currentTimeMillis();
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.put("type", 1);
        try {
            fs.putSingle("source_nodename", Base64.encode(this.node.getMyName().getBytes("UTF-8")));
            fs.putSingle("target_nodename", Base64.encode(this.getName().getBytes("UTF-8")));
            fs.putSingle("text", Base64.encode(message.getBytes("UTF-8")));
            fs.put("composedTime", now);
            this.sendNodeToNodeMessage(fs, 1, true, now, true);
            this.setPeerNodeStatus(System.currentTimeMillis());
            return this.getPeerNodeStatus();
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
        }
    }

    public int sendFileOfferAccepted(long uid) {
        this.storeOffers();
        long now = System.currentTimeMillis();
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.put("n2nType", 1);
        fs.put("type", 3);
        try {
            fs.putSingle("source_nodename", Base64.encode(this.node.getMyName().getBytes("UTF-8")));
            fs.putSingle("target_nodename", Base64.encode(this.getName().getBytes("UTF-8")));
            fs.put("composedTime", now);
            fs.put("sentTime", now);
            fs.put("uid", uid);
            if (logMINOR) {
                Logger.minor(this, "Sending node to node message (file offer accepted):\n" + fs);
            }
            Message n2ntm = DMT.createNodeToNodeMessage(1, fs.toString().getBytes("UTF-8"));
            try {
                this.sendAsync(n2ntm, null, this.node.nodeStats.nodeToNodeCounter);
            }
            catch (NotConnectedException e) {
                fs.removeValue("sentTime");
                this.queueN2NM(fs);
                this.setPeerNodeStatus(System.currentTimeMillis());
                return this.getPeerNodeStatus();
            }
            this.setPeerNodeStatus(System.currentTimeMillis());
            return this.getPeerNodeStatus();
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
        }
    }

    public int sendFileOfferRejected(long uid) {
        this.storeOffers();
        long now = System.currentTimeMillis();
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.put("n2nType", 1);
        fs.put("type", 4);
        try {
            fs.putSingle("source_nodename", Base64.encode(this.node.getMyName().getBytes("UTF-8")));
            fs.putSingle("target_nodename", Base64.encode(this.getName().getBytes("UTF-8")));
            fs.put("composedTime", now);
            fs.put("sentTime", now);
            fs.put("uid", uid);
            if (logMINOR) {
                Logger.minor(this, "Sending node to node message (file offer rejected):\n" + fs);
            }
            Message n2ntm = DMT.createNodeToNodeMessage(1, fs.toString().getBytes("UTF-8"));
            try {
                this.sendAsync(n2ntm, null, this.node.nodeStats.nodeToNodeCounter);
            }
            catch (NotConnectedException e) {
                fs.removeValue("sentTime");
                this.queueN2NM(fs);
                this.setPeerNodeStatus(System.currentTimeMillis());
                return this.getPeerNodeStatus();
            }
            this.setPeerNodeStatus(System.currentTimeMillis());
            return this.getPeerNodeStatus();
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendFileOffer(File filename, String message) throws IOException {
        String fnam = filename.getName();
        String mime = DefaultMIMETypes.guessMIMEType(fnam, false);
        long uid = this.node.random.nextLong();
        RandomAccessFileWrapper data = new RandomAccessFileWrapper(filename, "r");
        FileOffer fo = new FileOffer(uid, data, fnam, mime, message);
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            this.myFileOffersByUID.put(uid, fo);
        }
        this.storeOffers();
        long now = System.currentTimeMillis();
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.put("n2nType", 1);
        fs.put("type", 2);
        try {
            fs.putSingle("source_nodename", Base64.encode(this.node.getMyName().getBytes("UTF-8")));
            fs.putSingle("target_nodename", Base64.encode(this.getName().getBytes("UTF-8")));
            fs.put("composedTime", now);
            fs.put("sentTime", now);
            fo.toFieldSet(fs);
            if (logMINOR) {
                Logger.minor(this, "Sending node to node message (file offer):\n" + fs);
            }
            int status = this.getPeerNodeStatus();
            Message n2ntm = DMT.createNodeToNodeMessage(1, fs.toString().getBytes("UTF-8"));
            try {
                this.sendAsync(n2ntm, null, this.node.nodeStats.nodeToNodeCounter);
            }
            catch (NotConnectedException e) {
                fs.removeValue("sentTime");
                this.queueN2NM(fs);
                this.setPeerNodeStatus(System.currentTimeMillis());
                return this.getPeerNodeStatus();
            }
            return status;
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
        }
    }

    public void handleFproxyN2NTM(SimpleFieldSet fs, int fileNumber) {
        long receivedTime;
        long sentTime;
        long composedTime;
        String source_nodename = null;
        String target_nodename = null;
        String text = null;
        try {
            source_nodename = new String(Base64.decode(fs.get("source_nodename")));
            target_nodename = new String(Base64.decode(fs.get("target_nodename")));
            text = new String(Base64.decode(fs.get("text")));
            composedTime = fs.getLong("composedTime", -1L);
            sentTime = fs.getLong("sentTime", -1L);
            receivedTime = fs.getLong("receivedTime", -1L);
        }
        catch (IllegalBase64Exception e) {
            Logger.error(this, "Bad Base64 encoding when decoding a N2NTM SimpleFieldSet", e);
            return;
        }
        N2NTMUserAlert userAlert = new N2NTMUserAlert(this, source_nodename, target_nodename, text, fileNumber, composedTime, sentTime, receivedTime);
        this.node.clientCore.alerts.register(userAlert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFproxyFileOffer(SimpleFieldSet fs, int fileNumber) {
        FileOffer offer;
        try {
            offer = new FileOffer(fs, false);
        }
        catch (FSParseException e) {
            Logger.error(this, "Could not parse offer: " + e + " on " + this + " :\n" + fs, e);
            return;
        }
        Long u = offer.uid;
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            if (this.hisFileOffersByUID.containsKey(u)) {
                return;
            }
            this.hisFileOffersByUID.put(u, offer);
        }
        this.deleteExtraPeerDataFile(fileNumber);
        UserAlert alert = offer.askUserUserAlert();
        this.node.clientCore.alerts.register(alert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptTransfer(long id) {
        FileOffer fo;
        if (logMINOR) {
            Logger.minor(this, "Accepting transfer " + id + " on " + this);
        }
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            fo = this.hisFileOffersByUID.get(id);
        }
        fo.accept();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rejectTransfer(long id) {
        FileOffer fo;
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            fo = this.hisFileOffersByUID.remove(id);
        }
        fo.reject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFproxyFileOfferAccepted(SimpleFieldSet fs, int fileNumber) {
        FileOffer fo;
        long uid;
        this.deleteExtraPeerDataFile(fileNumber);
        try {
            uid = fs.getLong("uid");
        }
        catch (FSParseException e) {
            Logger.error(this, "Could not parse offer accepted: " + e + " on " + this + " :\n" + fs, e);
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Offer accepted for " + uid);
        }
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            fo = this.myFileOffersByUID.get(uid);
        }
        if (fo == null) {
            Logger.error(this, "No such offer: " + uid);
            try {
                this.sendAsync(DMT.createFNPBulkSendAborted(uid), null, this.node.nodeStats.nodeToNodeCounter);
            }
            catch (NotConnectedException e) {
                // empty catch block
            }
            return;
        }
        try {
            fo.send();
        }
        catch (DisconnectedException e) {
            Logger.error(this, "Cannot send because node disconnected: " + e + " for " + uid + ":" + fo.filename, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFproxyFileOfferRejected(SimpleFieldSet fs, int fileNumber) {
        FileOffer fo;
        long uid;
        this.deleteExtraPeerDataFile(fileNumber);
        try {
            uid = fs.getLong("uid");
        }
        catch (FSParseException e) {
            Logger.error(this, "Could not parse offer rejected: " + e + " on " + this + " :\n" + fs, e);
            return;
        }
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            fo = this.myFileOffersByUID.remove(uid);
        }
        fo.onRejected();
    }

    public String userToString() {
        return "" + this.getPeer() + " : " + this.getName();
    }

    public PeerNodeStatus getStatus(boolean noHeavy) {
        return new DarknetPeerNodeStatus(this, noHeavy);
    }

    public boolean isDarknet() {
        return true;
    }

    public boolean isOpennet() {
        return false;
    }

    public boolean isSeed() {
        return false;
    }

    public void onSuccess(boolean insert, boolean ssk) {
    }

    public void onRemove() {
    }

    public boolean isRealConnection() {
        return true;
    }

    public boolean recordStatus() {
        return true;
    }

    protected boolean generateIdentityFromPubkey() {
        return false;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DarknetPeerNode) {
            return super.equals(o);
        }
        return false;
    }

    public final boolean shouldDisconnectAndRemoveNow() {
        return false;
    }

    class FileOffer {
        final long uid;
        final String filename;
        final String mimeType;
        final String comment;
        private RandomAccessThing data;
        final long size;
        final boolean amIOffering;
        private PartiallyReceivedBulk prb;
        private BulkTransmitter transmitter;
        private BulkReceiver receiver;
        private boolean acceptedOrRejected;

        FileOffer(long uid, RandomAccessThing data, String filename, String mimeType, String comment) throws IOException {
            this.uid = uid;
            this.data = data;
            this.filename = filename;
            this.mimeType = mimeType;
            this.comment = comment;
            this.size = data.size();
            this.amIOffering = true;
        }

        public FileOffer(SimpleFieldSet fs, boolean amIOffering) throws FSParseException {
            this.uid = fs.getLong("uid");
            this.size = fs.getLong("size");
            this.mimeType = fs.get("metadata.contentType");
            this.filename = FileUtil.sanitize(fs.get("filename"), this.mimeType);
            String s = fs.get("comment");
            if (s != null) {
                try {
                    s = new String(Base64.decode(s), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
                }
                catch (IllegalBase64Exception e) {
                    // empty catch block
                }
            }
            this.comment = s;
            this.amIOffering = amIOffering;
        }

        public void toFieldSet(SimpleFieldSet fs) {
            fs.put("uid", this.uid);
            fs.putSingle("filename", this.filename);
            fs.putSingle("metadata.contentType", this.mimeType);
            try {
                fs.putSingle("comment", Base64.encode(this.comment.getBytes("UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
            }
            fs.put("size", this.size);
        }

        public void accept() {
            this.acceptedOrRejected = true;
            File dest = new File(DarknetPeerNode.this.node.clientCore.downloadDir, "direct-" + FileUtil.sanitize(DarknetPeerNode.this.getName()) + "-" + this.filename);
            try {
                this.data = new RandomAccessFileWrapper(dest, "rw");
            }
            catch (FileNotFoundException e) {
                throw new Error("Impossible: FileNotFoundException opening with RAF with rw! " + e, e);
            }
            this.prb = new PartiallyReceivedBulk(DarknetPeerNode.this.node.usm, this.size, 1024, this.data, false);
            this.receiver = new BulkReceiver(this.prb, DarknetPeerNode.this, this.uid, null);
            DarknetPeerNode.this.node.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (logMINOR) {
                        Logger.minor(this, "Received file");
                    }
                    try {
                        block7: {
                            try {
                                if (!FileOffer.this.receiver.receive()) {
                                    String err = "Failed to receive " + this;
                                    Logger.error(this, err);
                                    System.err.println(err);
                                    FileOffer.this.onReceiveFailure();
                                    break block7;
                                }
                                FileOffer.this.onReceiveSuccess();
                            }
                            catch (Throwable t) {
                                Logger.error(this, "Caught " + t + " receiving file", t);
                                FileOffer.this.onReceiveFailure();
                                Object var3_4 = null;
                                FileOffer.this.remove();
                            }
                        }
                        Object var3_3 = null;
                        FileOffer.this.remove();
                    }
                    catch (Throwable throwable) {
                        Object var3_5 = null;
                        FileOffer.this.remove();
                        throw throwable;
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Received file");
                    }
                }
            }, "Receiver for bulk transfer " + this.uid + ":" + this.filename);
            DarknetPeerNode.this.sendFileOfferAccepted(this.uid);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void remove() {
            Long l = this.uid;
            DarknetPeerNode darknetPeerNode = DarknetPeerNode.this;
            synchronized (darknetPeerNode) {
                DarknetPeerNode.this.myFileOffersByUID.remove(l);
                DarknetPeerNode.this.hisFileOffersByUID.remove(l);
            }
            this.data.close();
        }

        public void send() throws DisconnectedException {
            this.prb = new PartiallyReceivedBulk(DarknetPeerNode.this.node.usm, this.size, 1024, this.data, true);
            this.transmitter = new BulkTransmitter(this.prb, DarknetPeerNode.this, this.uid, false, DarknetPeerNode.this.node.nodeStats.nodeToNodeCounter);
            if (logMINOR) {
                Logger.minor(this, "Sending " + this.uid);
            }
            DarknetPeerNode.this.node.executor.execute(new Runnable(){

                public void run() {
                    if (logMINOR) {
                        Logger.minor(this, "Sending file");
                    }
                    try {
                        if (!FileOffer.this.transmitter.send()) {
                            String err = "Failed to send " + FileOffer.this.uid + " for " + FileOffer.this;
                            Logger.error(this, err);
                            System.err.println(err);
                        }
                    }
                    catch (Throwable t) {
                        Logger.error(this, "Caught " + t + " sending file", t);
                        FileOffer.this.remove();
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Sent file");
                    }
                }
            }, "Sender for bulk transfer " + this.uid + ":" + this.filename);
        }

        public void reject() {
            this.acceptedOrRejected = true;
            DarknetPeerNode.this.sendFileOfferRejected(this.uid);
        }

        public void onRejected() {
            this.transmitter.cancel("FileOffer: Offer rejected");
            this.prb.abort(9, "Cancelled by receiver");
        }

        protected void onReceiveFailure() {
            AbstractUserAlert alert = new AbstractUserAlert(){

                public String dismissButtonText() {
                    return L10n.getString("UserAlert.hide");
                }

                public HTMLNode getHTMLText() {
                    HTMLNode div = new HTMLNode("div");
                    div.addChild("p", FileOffer.this.l10n("failedReceiveHeader", new String[]{"filename", "node"}, new String[]{FileOffer.this.filename, DarknetPeerNode.this.getName()}));
                    FileOffer.this.describeFile(div);
                    return div;
                }

                public short getPriorityClass() {
                    return 3;
                }

                public String getText() {
                    StringBuilder sb = new StringBuilder();
                    sb.append(FileOffer.this.l10n("failedReceiveHeader", new String[]{"filename", "node"}, new String[]{FileOffer.this.filename, DarknetPeerNode.this.getName()}));
                    sb.append('\n');
                    sb.append(FileOffer.this.l10n("fileLabel"));
                    sb.append(' ');
                    sb.append(FileOffer.this.filename);
                    sb.append('\n');
                    sb.append(FileOffer.this.l10n("sizeLabel"));
                    sb.append(' ');
                    sb.append(SizeUtil.formatSize(FileOffer.this.size));
                    sb.append('\n');
                    sb.append(FileOffer.this.l10n("mimeLabel"));
                    sb.append(' ');
                    sb.append(FileOffer.this.mimeType);
                    sb.append('\n');
                    sb.append(FileOffer.this.l10n("senderLabel"));
                    sb.append(' ');
                    sb.append(DarknetPeerNode.this.getName());
                    sb.append('\n');
                    if (FileOffer.this.comment != null && FileOffer.this.comment.length() > 0) {
                        sb.append(FileOffer.this.l10n("commentLabel"));
                        sb.append(' ');
                        sb.append(FileOffer.this.comment);
                    }
                    return sb.toString();
                }

                public String getTitle() {
                    return FileOffer.this.l10n("failedReceiveTitle");
                }

                public boolean isValid() {
                    return true;
                }

                public void isValid(boolean validity) {
                }

                public void onDismiss() {
                }

                public boolean shouldUnregisterOnDismiss() {
                    return true;
                }

                public boolean userCanDismiss() {
                    return true;
                }

                public String getShortText() {
                    return FileOffer.this.l10n("failedReceiveShort", new String[]{"filename", "node"}, new String[]{FileOffer.this.filename, DarknetPeerNode.this.getName()});
                }
            };
            DarknetPeerNode.this.node.clientCore.alerts.register(alert);
        }

        private void onReceiveSuccess() {
            AbstractUserAlert alert = new AbstractUserAlert(){

                public String dismissButtonText() {
                    return L10n.getString("UserAlert.hide");
                }

                public HTMLNode getHTMLText() {
                    HTMLNode div = new HTMLNode("div");
                    div.addChild("p", FileOffer.this.l10n("succeededReceiveHeader", new String[]{"filename", "node"}, new String[]{FileOffer.this.filename, DarknetPeerNode.this.getName()}));
                    FileOffer.this.describeFile(div);
                    return div;
                }

                public short getPriorityClass() {
                    return 3;
                }

                public String getText() {
                    String header = FileOffer.this.l10n("succeededReceiveHeader", new String[]{"filename", "node"}, new String[]{FileOffer.this.filename, DarknetPeerNode.this.getName()});
                    return FileOffer.this.describeFileText(header);
                }

                public String getTitle() {
                    return FileOffer.this.l10n("succeededReceiveTitle");
                }

                public boolean isValid() {
                    return true;
                }

                public void isValid(boolean validity) {
                }

                public void onDismiss() {
                }

                public boolean shouldUnregisterOnDismiss() {
                    return true;
                }

                public boolean userCanDismiss() {
                    return true;
                }

                public String getShortText() {
                    return FileOffer.this.l10n("succeededReceiveShort", new String[]{"filename", "node"}, new String[]{FileOffer.this.filename, DarknetPeerNode.this.getName()});
                }
            };
            DarknetPeerNode.this.node.clientCore.alerts.register(alert);
        }

        public UserAlert askUserUserAlert() {
            return new AbstractUserAlert(){

                public String dismissButtonText() {
                    return null;
                }

                public HTMLNode getHTMLText() {
                    HTMLNode div = new HTMLNode("div");
                    div.addChild("p", FileOffer.this.l10n("offeredFileHeader", "name", DarknetPeerNode.this.getName()));
                    FileOffer.this.describeFile(div);
                    HTMLNode form = DarknetPeerNode.this.node.clientCore.getToadletContainer().addFormChild(div, "/friends/", "f2fFileOfferAcceptForm");
                    form.addChild("input", new String[]{"type", "name"}, new String[]{"hidden", "node_" + DarknetPeerNode.this.hashCode()});
                    form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "id", Long.toString(FileOffer.this.uid)});
                    form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "acceptTransfer", FileOffer.this.l10n("acceptTransferButton")});
                    form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "rejectTransfer", FileOffer.this.l10n("rejectTransferButton")});
                    return div;
                }

                public short getPriorityClass() {
                    return 3;
                }

                public String getText() {
                    String header = FileOffer.this.l10n("offeredFileHeader", "name", DarknetPeerNode.this.getName());
                    return FileOffer.this.describeFileText(header);
                }

                public String getTitle() {
                    return FileOffer.this.l10n("askUserTitle");
                }

                public boolean isValid() {
                    if (FileOffer.this.acceptedOrRejected) {
                        DarknetPeerNode.this.node.clientCore.alerts.unregister(this);
                        return false;
                    }
                    return true;
                }

                public void isValid(boolean validity) {
                }

                public void onDismiss() {
                }

                public boolean shouldUnregisterOnDismiss() {
                    return false;
                }

                public boolean userCanDismiss() {
                    return false;
                }

                public String getShortText() {
                    return FileOffer.this.l10n("offeredFileShort", new String[]{"filename", "node"}, new String[]{FileOffer.this.filename, DarknetPeerNode.this.getName()});
                }
            };
        }

        protected void addComment(HTMLNode node) {
            String[] lines = this.comment.split("\n");
            int c = lines.length;
            for (int i = 0; i < c; ++i) {
                node.addChild("#", lines[i]);
                if (i == lines.length - 1) continue;
                node.addChild("br");
            }
        }

        private String l10n(String key) {
            return L10n.getString("FileOffer." + key);
        }

        private String l10n(String key, String pattern, String value) {
            return L10n.getString("FileOffer." + key, pattern, value);
        }

        private String l10n(String key, String[] pattern, String[] value) {
            return L10n.getString("FileOffer." + key, pattern, value);
        }

        private String describeFileText(String header) {
            StringBuilder sb = new StringBuilder();
            sb.append(header);
            sb.append('\n');
            sb.append(this.l10n("fileLabel"));
            sb.append(' ');
            sb.append(this.filename);
            sb.append('\n');
            sb.append(this.l10n("sizeLabel"));
            sb.append(' ');
            sb.append(SizeUtil.formatSize(this.size));
            sb.append('\n');
            sb.append(this.l10n("mimeLabel"));
            sb.append(' ');
            sb.append(this.mimeType);
            sb.append('\n');
            sb.append(this.l10n("senderLabel"));
            sb.append(' ');
            sb.append(DarknetPeerNode.this.userToString());
            sb.append('\n');
            if (this.comment != null && this.comment.length() > 0) {
                sb.append(this.l10n("commentLabel"));
                sb.append(' ');
                sb.append(this.comment);
            }
            return sb.toString();
        }

        private void describeFile(HTMLNode div) {
            HTMLNode table = div.addChild("table", "border", "0");
            HTMLNode row = table.addChild("tr");
            row.addChild("td").addChild("#", this.l10n("fileLabel"));
            row.addChild("td").addChild("#", this.filename);
            row = table.addChild("tr");
            row.addChild("td").addChild("#", this.l10n("sizeLabel"));
            row.addChild("td").addChild("#", SizeUtil.formatSize(this.size));
            row = table.addChild("tr");
            row.addChild("td").addChild("#", this.l10n("mimeLabel"));
            row.addChild("td").addChild("#", this.mimeType);
            row = table.addChild("tr");
            row.addChild("td").addChild("#", this.l10n("senderLabel"));
            row.addChild("td").addChild("#", DarknetPeerNode.this.getName());
            row = table.addChild("tr");
            if (this.comment != null && this.comment.length() > 0) {
                row.addChild("td").addChild("#", this.l10n("commentLabel"));
                this.addComment(row.addChild("td"));
            }
        }
    }
}

