/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.support.Logger;
import freenet.support.OOMHandler;

public class DNSRequester
implements Runnable {
    final Node node;
    private long lastLogTime;
    static boolean DISABLE = false;

    DNSRequester(Node node) {
        this.node = node;
    }

    void start() {
        Logger.normal(this, "Starting DNSRequester");
        System.out.println("Starting DNSRequester");
        this.node.executor.execute(this, "DNSRequester thread for " + this.node.getDarknetPortNumber());
    }

    public void run() {
        Logger.OSThread.logPID(this);
        while (true) {
            try {
                while (true) {
                    this.realRun();
                }
            }
            catch (OutOfMemoryError e) {
                OOMHandler.handleOOM(e);
                System.err.println("Will retry above failed operation...");
                continue;
            }
            catch (Throwable t) {
                Logger.error(this, "Caught in DNSRequester: " + t, t);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realRun() {
        PeerNode[] nodes = this.node.peers.myPeers;
        long now = System.currentTimeMillis();
        if (now - this.lastLogTime > 1000L) {
            if (Logger.shouldLog(4, this)) {
                Logger.minor(this, "Processing DNS Requests (log rate-limited)");
            }
            this.lastLogTime = now;
        }
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i].isConnected()) continue;
            nodes[i].maybeUpdateHandshakeIPs(false);
        }
        try {
            DNSRequester i = this;
            synchronized (i) {
                this.wait(10000L);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceRun() {
        DNSRequester dNSRequester = this;
        synchronized (dNSRequester) {
            this.notifyAll();
        }
    }
}

