/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.config.InvalidConfigValueException;
import freenet.config.SubConfig;
import freenet.l10n.L10n;
import freenet.node.NodeInitException;
import freenet.node.PacketSender;
import freenet.node.Persistable;
import freenet.node.Persister;
import freenet.support.api.StringCallback;
import java.io.File;
import java.io.IOException;

public class ConfigurablePersister
extends Persister {
    public ConfigurablePersister(Persistable t, SubConfig nodeConfig, String optionName, String defaultFilename, int sortOrder, boolean expert, boolean forceWrite, String shortDesc, String longDesc, PacketSender ps, File baseDir) throws NodeInitException {
        super(t, ps);
        nodeConfig.register(optionName, new File(baseDir, defaultFilename).toString(), sortOrder, expert, forceWrite, shortDesc, longDesc, new StringCallback(){

            public String get() {
                return ConfigurablePersister.this.persistTarget.toString();
            }

            public void set(String val) throws InvalidConfigValueException {
                ConfigurablePersister.this.setThrottles(val);
            }
        });
        String throttleFile = nodeConfig.getString(optionName);
        try {
            this.setThrottles(throttleFile);
        }
        catch (InvalidConfigValueException e2) {
            throw new NodeInitException(23, e2.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setThrottles(String val) throws InvalidConfigValueException {
        File f = new File(val);
        File tmp = new File(f.toString() + ".tmp");
        while (true) {
            if (f.exists()) {
                if (!f.canRead()) throw new InvalidConfigValueException(this.l10n("existsCannotReadWrite") + " : " + tmp);
                if (f.canWrite()) break;
                throw new InvalidConfigValueException(this.l10n("existsCannotReadWrite") + " : " + tmp);
            }
            try {
                if (f.createNewFile()) continue;
                if (!f.exists()) throw new InvalidConfigValueException(this.l10n("doesNotExistCannotCreate") + " : " + tmp);
            }
            catch (IOException e) {
                throw new InvalidConfigValueException(this.l10n("doesNotExistCannotCreate") + " : " + tmp);
            }
        }
        while (true) {
            if (tmp.exists()) {
                if (!tmp.canRead()) throw new InvalidConfigValueException(this.l10n("existsCannotReadWrite") + " : " + tmp);
                if (tmp.canWrite()) break;
                throw new InvalidConfigValueException(this.l10n("existsCannotReadWrite") + " : " + tmp);
            }
            try {
                tmp.createNewFile();
            }
            catch (IOException e) {
                throw new InvalidConfigValueException(this.l10n("doesNotExistCannotCreate") + " : " + tmp);
            }
        }
        ConfigurablePersister configurablePersister = this;
        synchronized (configurablePersister) {
            this.persistTarget = f;
            this.persistTemp = tmp;
            return;
        }
    }

    private String l10n(String key) {
        return L10n.getString("ConfigurablePersister." + key);
    }
}

