/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.AsyncMessageFilterCallback;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.PeerContext;
import freenet.io.xfer.AbortedException;
import freenet.io.xfer.BlockTransmitter;
import freenet.io.xfer.PartiallyReceivedBlock;
import freenet.keys.CHKBlock;
import freenet.keys.CHKVerifyException;
import freenet.keys.NodeCHK;
import freenet.node.AnyInsertSender;
import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.node.PrioRunnable;
import freenet.support.Logger;
import freenet.support.OOMHandler;
import java.util.HashSet;
import java.util.Vector;

public final class CHKInsertSender
implements PrioRunnable,
AnyInsertSender,
ByteCounter {
    static boolean logMINOR;
    static final int ACCEPTED_TIMEOUT = 10000;
    static final int SEARCH_TIMEOUT = 120000;
    static final int TRANSFER_COMPLETION_ACK_TIMEOUT = 120000;
    final NodeCHK myKey;
    final double target;
    final long uid;
    short htl;
    final PeerNode source;
    final Node node;
    final byte[] headers;
    final PartiallyReceivedBlock prb;
    final boolean fromStore;
    private boolean receiveFailed;
    final long startTime;
    private boolean sentRequest;
    private Vector<BackgroundTransfer> backgroundTransfers;
    private boolean allTransfersCompleted;
    private volatile boolean transferTimedOut;
    private int status = -1;
    static final int NOT_FINISHED = -1;
    static final int SUCCESS = 0;
    static final int ROUTE_NOT_FOUND = 1;
    static final int INTERNAL_ERROR = 3;
    static final int TIMED_OUT = 4;
    static final int GENERATED_REJECTED_OVERLOAD = 5;
    static final int ROUTE_REALLY_NOT_FOUND = 6;
    static final int RECEIVE_FAILED = 7;
    private boolean hasForwardedRejectedOverload;
    private final Object totalBytesSync = new Object();
    private int totalBytesSent;
    private int totalBytesReceived;

    CHKInsertSender(NodeCHK myKey, long uid, byte[] headers, short htl, PeerNode source, Node node, PartiallyReceivedBlock prb, boolean fromStore) {
        this.myKey = myKey;
        this.target = myKey.toNormalizedDouble();
        this.uid = uid;
        this.headers = headers;
        this.htl = htl;
        this.source = source;
        this.node = node;
        this.prb = prb;
        this.fromStore = fromStore;
        this.startTime = System.currentTimeMillis();
        this.backgroundTransfers = new Vector();
        logMINOR = Logger.shouldLog(4, this);
    }

    void start() {
        this.node.executor.execute(this, "CHKInsertSender for UID " + this.uid + " on " + this.node.getDarknetPortNumber() + " at " + System.currentTimeMillis());
    }

    public String toString() {
        return super.toString() + " for " + this.uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        Logger.OSThread.logPID(this);
        CHKInsertSender cHKInsertSender2 = this;
        // MONITORENTER : cHKInsertSender2
        short origHTL = this.htl;
        // MONITOREXIT : cHKInsertSender2
        this.node.addInsertSender(this.myKey, origHTL, this);
        try {
            try {
                this.realRun();
            }
            catch (OutOfMemoryError e) {
                OOMHandler.handleOOM(e);
                Object var5_6 = null;
                CHKInsertSender cHKInsertSender = this;
                // MONITORENTER : cHKInsertSender
                int myStatus2222 = this.status;
                // MONITOREXIT : cHKInsertSender
                if (myStatus2222 == -1) {
                    this.finish(3, null);
                }
                this.node.removeInsertSender(this.myKey, origHTL, this);
                return;
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t, t);
                Object var5_7 = null;
                CHKInsertSender cHKInsertSender4 = this;
                // MONITORENTER : cHKInsertSender4
                int myStatus2222 = this.status;
                // MONITOREXIT : cHKInsertSender4
                if (myStatus2222 == -1) {
                    this.finish(3, null);
                }
                this.node.removeInsertSender(this.myKey, origHTL, this);
                return;
            }
            Object var5_5 = null;
            CHKInsertSender cHKInsertSender = this;
            // MONITORENTER : cHKInsertSender
            int myStatus2222 = this.status;
            // MONITOREXIT : cHKInsertSender
            if (myStatus2222 == -1) {
                this.finish(3, null);
            }
            this.node.removeInsertSender(this.myKey, origHTL, this);
            return;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            CHKInsertSender cHKInsertSender5 = this;
            // MONITORENTER : cHKInsertSender5
            int myStatus2222 = this.status;
            // MONITOREXIT : cHKInsertSender5
            if (myStatus2222 == -1) {
                this.finish(3, null);
            }
            this.node.removeInsertSender(this.myKey, origHTL, this);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realRun() {
        HashSet<PeerNode> nodesRoutedTo = new HashSet<PeerNode>();
        PeerNode next = null;
        while (true) {
            block66: {
                if (this.receiveFailed) {
                    return;
                }
                this.htl = this.node.decrementHTL(this.sentRequest ? next : this.source, this.htl);
                CHKInsertSender cHKInsertSender = this;
                synchronized (cHKInsertSender) {
                    if (this.htl == 0) {
                        this.finish(0, null);
                        return;
                    }
                }
                next = this.node.peers.closerPeer(this.source, nodesRoutedTo, this.target, true, this.node.isAdvancedModeEnabled(), -1, null, null);
                if (next == null) {
                    this.finish(1, null);
                    return;
                }
                if (logMINOR) {
                    Logger.minor(this, "Routing insert to " + next);
                }
                nodesRoutedTo.add(next);
                Message req = DMT.createFNPInsertRequest(this.uid, this.htl, this.myKey);
                MessageFilter mfAccepted = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(10000).setType(DMT.FNPAccepted);
                MessageFilter mfRejectedLoop = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(10000).setType(DMT.FNPRejectedLoop);
                MessageFilter mfRejectedOverload = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(10000).setType(DMT.FNPRejectedOverload);
                mfRejectedOverload.clearOr();
                MessageFilter mf = mfAccepted.or(mfRejectedLoop.or(mfRejectedOverload));
                try {
                    next.sendAsync(req, null, this);
                }
                catch (NotConnectedException e1) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "Not connected to " + next);
                    continue;
                }
                CHKInsertSender e1 = this;
                synchronized (e1) {
                    this.sentRequest = true;
                }
                if (this.receiveFailed) {
                    return;
                }
                Message msg = null;
                while (msg == null || msg.getSpec() != DMT.FNPAccepted) {
                    try {
                        msg = this.node.usm.waitFor(mf, this);
                    }
                    catch (DisconnectedException e) {
                        Logger.normal(this, "Disconnected from " + next + " while waiting for Accepted");
                        break;
                    }
                    if (this.receiveFailed) {
                        return;
                    }
                    if (msg == null) {
                        if (logMINOR) {
                            Logger.minor(this, "Timeout");
                        }
                        next.localRejectedOverload("Timeout3");
                        this.forwardRejectedOverload();
                        break;
                    }
                    if (msg.getSpec() == DMT.FNPRejectedOverload) {
                        if (msg.getBoolean("isLocal")) {
                            next.localRejectedOverload("ForwardRejectedOverload5");
                            if (!logMINOR) break;
                            Logger.minor(this, "Local RejectedOverload, moving on to next peer");
                            break;
                        }
                        this.forwardRejectedOverload();
                        continue;
                    }
                    if (msg.getSpec() == DMT.FNPRejectedLoop) {
                        next.successNotOverload();
                        break;
                    }
                    if (msg.getSpec() == DMT.FNPAccepted) continue;
                    Logger.error(this, "Unexpected message waiting for Accepted: " + msg);
                    break;
                }
                if (msg == null || msg.getSpec() != DMT.FNPAccepted) continue;
                if (logMINOR) {
                    Logger.minor(this, "Got Accepted on " + this);
                }
                Message dataInsert = DMT.createFNPDataInsert(this.uid, this.headers);
                MessageFilter mfInsertReply = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(120000).setType(DMT.FNPInsertReply);
                mfRejectedOverload.setTimeout(120000);
                mfRejectedOverload.clearOr();
                MessageFilter mfRouteNotFound = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(120000).setType(DMT.FNPRouteNotFound);
                MessageFilter mfDataInsertRejected = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(120000).setType(DMT.FNPDataInsertRejected);
                MessageFilter mfTimeout = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(120000).setType(DMT.FNPRejectedTimeout);
                mf = mfInsertReply.or(mfRouteNotFound.or(mfDataInsertRejected.or(mfTimeout.or(mfRejectedOverload))));
                if (logMINOR) {
                    Logger.minor(this, "Sending DataInsert");
                }
                if (this.receiveFailed) {
                    return;
                }
                try {
                    next.sendSync(dataInsert, this);
                }
                catch (NotConnectedException e12) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "Not connected sending DataInsert: " + next + " for " + this.uid);
                    continue;
                }
                if (logMINOR) {
                    Logger.minor(this, "Sending data");
                }
                this.startBackgroundTransfer(next, this.prb);
                while (true) {
                    if (this.receiveFailed) {
                        return;
                    }
                    try {
                        msg = this.node.usm.waitFor(mf, this);
                    }
                    catch (DisconnectedException e) {
                        Logger.normal(this, "Disconnected from " + next + " while waiting for InsertReply on " + this);
                        break block66;
                    }
                    if (this.receiveFailed) {
                        return;
                    }
                    if (msg == null || msg.getSpec() == DMT.FNPRejectedTimeout) {
                        Logger.error(this, "Timeout (" + msg + ") after Accepted in insert");
                        next.localRejectedOverload("AfterInsertAcceptedTimeout2");
                        this.finish(4, next);
                        return;
                    }
                    if (msg.getSpec() != DMT.FNPRejectedOverload) break;
                    if (msg.getBoolean("isLocal")) {
                        next.localRejectedOverload("ForwardRejectedOverload6");
                        if (logMINOR) {
                            Logger.minor(this, "Local RejectedOverload, moving on to next peer");
                        }
                        break block66;
                    }
                    this.forwardRejectedOverload();
                }
                if (msg.getSpec() == DMT.FNPRouteNotFound) {
                    if (logMINOR) {
                        Logger.minor(this, "Rejected: RNF");
                    }
                    short newHtl = msg.getShort("hopsToLive");
                    CHKInsertSender cHKInsertSender2 = this;
                    synchronized (cHKInsertSender2) {
                        if (this.htl > newHtl) {
                            this.htl = newHtl;
                        }
                    }
                    next.successNotOverload();
                } else if (msg.getSpec() == DMT.FNPDataInsertRejected) {
                    next.successNotOverload();
                    short reason = msg.getShort("dataInsertRejectedReason");
                    if (logMINOR) {
                        Logger.minor(this, "DataInsertRejected: " + reason);
                    }
                    if (reason == 1) {
                        if (this.fromStore) {
                            Logger.error(this, "Verify failed on next node " + next + " for DataInsert but we were sending from the store!");
                        } else {
                            try {
                                if (!this.prb.allReceived()) {
                                    Logger.error(this, "Did not receive all packets but next node says invalid anyway!");
                                    break block66;
                                }
                                new CHKBlock(this.prb.getBlock(), this.headers, this.myKey);
                                Logger.error(this, "Verify failed on " + next + " but data was valid!");
                            }
                            catch (CHKVerifyException e) {
                                Logger.normal(this, "Verify failed because data was invalid");
                            }
                            catch (AbortedException e) {
                                this.receiveFailed();
                            }
                        }
                    } else {
                        if (reason == 2) {
                            if (this.receiveFailed) {
                                if (logMINOR) {
                                    Logger.minor(this, "Failed to receive data, so failed to send data");
                                }
                            } else {
                                try {
                                    if (this.prb.allReceived()) {
                                        Logger.error(this, "Received all data but send failed to " + next);
                                    } else if (this.prb.isAborted()) {
                                        Logger.normal(this, "Send failed: aborted: " + this.prb.getAbortReason() + ": " + this.prb.getAbortDescription());
                                    } else {
                                        Logger.normal(this, "Send failed; have not yet received all data but not aborted: " + next);
                                    }
                                }
                                catch (AbortedException e) {
                                    this.receiveFailed();
                                }
                            }
                        }
                        Logger.error(this, "DataInsert rejected! Reason=" + DMT.getDataInsertRejectedReason(reason));
                    }
                } else {
                    if (msg.getSpec() != DMT.FNPInsertReply) {
                        Logger.error(this, "Unknown reply: " + msg);
                        this.finish(3, next);
                        return;
                    }
                    this.finish(0, next);
                    return;
                }
            }
            if (!logMINOR) continue;
            Logger.debug(this, "Trying alternate node for insert");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startBackgroundTransfer(PeerNode node, PartiallyReceivedBlock prb) {
        BackgroundTransfer ac = new BackgroundTransfer(node, prb);
        Vector<BackgroundTransfer> vector = this.backgroundTransfers;
        synchronized (vector) {
            this.backgroundTransfers.add(ac);
            this.backgroundTransfers.notifyAll();
        }
        ac.start();
    }

    synchronized boolean receivedRejectedOverload() {
        return this.hasForwardedRejectedOverload;
    }

    private synchronized void forwardRejectedOverload() {
        if (this.hasForwardedRejectedOverload) {
            return;
        }
        this.hasForwardedRejectedOverload = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTransferTimedOut() {
        if (this.transferTimedOut) {
            return;
        }
        CHKInsertSender cHKInsertSender = this;
        synchronized (cHKInsertSender) {
            if (!this.transferTimedOut) {
                this.transferTimedOut = true;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void finish(int code, PeerNode next) {
        boolean failedRecv;
        if (logMINOR) {
            Logger.minor(this, "Finished: " + code + " on " + this, (Throwable)new Exception("debug"));
        }
        CHKInsertSender cHKInsertSender = this;
        synchronized (cHKInsertSender) {
            if (code == 1 && !this.sentRequest) {
                code = 6;
            }
            if (this.status != -1) {
                if (this.status != 7) throw new IllegalStateException("finish() called with " + code + " when was already " + this.status);
                if (code == 0) {
                    Logger.error(this, "Request succeeded despite receive failed?! on " + this);
                }
            } else {
                this.status = code;
            }
            this.notifyAll();
            if (logMINOR) {
                Logger.minor(this, "Set status code: " + this.getStatusString() + " on " + this.uid);
            }
        }
        Object object = this.backgroundTransfers;
        synchronized (object) {
            if (!this.backgroundTransfers.isEmpty()) {
                this.waitForBackgroundTransferCompletions();
            } else if (logMINOR) {
                Logger.minor(this, "No background transfers");
            }
            failedRecv = this.receiveFailed;
        }
        object = this;
        synchronized (object) {
            if (failedRecv) {
                this.status = 7;
            }
            this.allTransfersCompleted = true;
            this.notifyAll();
        }
        if (this.status == 0 && next != null) {
            next.onSuccess(true, false);
        }
        if (!logMINOR) return;
        Logger.minor(this, "Returning from finish()");
    }

    public synchronized int getStatus() {
        return this.status;
    }

    public synchronized short getHTL() {
        return this.htl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFailed() {
        Object object = this.backgroundTransfers;
        synchronized (object) {
            this.receiveFailed = true;
            this.backgroundTransfers.notifyAll();
        }
        object = this;
        synchronized (object) {
            this.status = 7;
            this.allTransfersCompleted = true;
            this.notifyAll();
        }
    }

    public synchronized String getStatusString() {
        if (this.status == 0) {
            return "SUCCESS";
        }
        if (this.status == 1) {
            return "ROUTE NOT FOUND";
        }
        if (this.status == -1) {
            return "NOT FINISHED";
        }
        if (this.status == 3) {
            return "INTERNAL ERROR";
        }
        if (this.status == 4) {
            return "TIMED OUT";
        }
        if (this.status == 5) {
            return "GENERATED REJECTED OVERLOAD";
        }
        if (this.status == 6) {
            return "ROUTE REALLY NOT FOUND";
        }
        return "UNKNOWN STATUS CODE: " + this.status;
    }

    public synchronized boolean sentRequest() {
        return this.sentRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForBackgroundTransferCompletions() {
        block13: {
            CHKInsertSender cHKInsertSender;
            try {
                BackgroundTransfer[] transfers;
                Logger.OSThread.logPID(this);
                if (logMINOR) {
                    Logger.minor(this, "Waiting for background transfer completions: " + this);
                }
                Vector<BackgroundTransfer> vector = this.backgroundTransfers;
                synchronized (vector) {
                    transfers = new BackgroundTransfer[this.backgroundTransfers.size()];
                    transfers = this.backgroundTransfers.toArray(transfers);
                }
                if (this.waitForBackgroundTransfers(transfers)) break block13;
                this.setTransferTimedOut();
                Object var5_4 = null;
                cHKInsertSender = this;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                CHKInsertSender cHKInsertSender2 = this;
                synchronized (cHKInsertSender2) {
                    this.allTransfersCompleted = true;
                    this.notifyAll();
                }
                throw throwable;
            }
            synchronized (cHKInsertSender) {
                this.allTransfersCompleted = true;
                this.notifyAll();
            }
            return;
        }
        Object var5_5 = null;
        CHKInsertSender cHKInsertSender = this;
        synchronized (cHKInsertSender) {
            this.allTransfersCompleted = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForBackgroundTransfers(BackgroundTransfer[] transfers) {
        long start = System.currentTimeMillis();
        long deadline = start + 360000L;
        while (true) {
            if (System.currentTimeMillis() > deadline) {
                Logger.normal(this, "Timed out waiting for background transfers! Probably caused by async filter not getting a timeout notification! DEBUG ME!");
                return false;
            }
            Vector<BackgroundTransfer> vector = this.backgroundTransfers;
            synchronized (vector) {
                if (this.receiveFailed) {
                    return false;
                }
                boolean noneRouteable = true;
                boolean completedTransfers = true;
                boolean completedNotifications = true;
                for (int i = 0; i < transfers.length; ++i) {
                    if (!transfers[i].pn.isRoutable()) continue;
                    noneRouteable = false;
                    if (!transfers[i].completedTransfer) {
                        if (logMINOR) {
                            Logger.minor(this, "Waiting for transfer completion to " + transfers[i].pn + " : " + transfers[i]);
                        }
                        completedTransfers = false;
                        break;
                    }
                    if (!transfers[i].receivedCompletionNotice) {
                        if (logMINOR) {
                            Logger.minor(this, "Waiting for completion notice from " + transfers[i].pn + " : " + transfers[i]);
                        }
                        completedNotifications = false;
                        break;
                    }
                    if (transfers[i].completionSucceeded) continue;
                    return false;
                }
                if (noneRouteable) {
                    return false;
                }
                if (completedTransfers && completedNotifications) {
                    return true;
                }
                if (logMINOR) {
                    Logger.minor(this, "Waiting: transfer completion=" + completedTransfers + " notification=" + completedNotifications);
                }
                try {
                    this.backgroundTransfers.wait(100000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized boolean completed() {
        return this.allTransfersCompleted;
    }

    public synchronized void waitForStatus() {
        while (this.status == -1) {
            try {
                this.wait(100000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean anyTransfersFailed() {
        return this.transferTimedOut;
    }

    public byte[] getPubkeyHash() {
        return this.headers;
    }

    public byte[] getHeaders() {
        return this.headers;
    }

    public long getUID() {
        return this.uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sentBytes(int x) {
        Object object = this.totalBytesSync;
        synchronized (object) {
            this.totalBytesSent += x;
        }
        this.node.nodeStats.insertSentBytes(false, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalSentBytes() {
        Object object = this.totalBytesSync;
        synchronized (object) {
            return this.totalBytesSent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedBytes(int x) {
        Object object = this.totalBytesSync;
        synchronized (object) {
            this.totalBytesReceived += x;
        }
        this.node.nodeStats.insertReceivedBytes(false, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalReceivedBytes() {
        Object object = this.totalBytesSync;
        synchronized (object) {
            return this.totalBytesReceived;
        }
    }

    public void sentPayload(int x) {
        this.node.sentPayload(x);
        this.node.nodeStats.insertSentBytes(false, -x);
    }

    public boolean failedReceive() {
        return this.receiveFailed;
    }

    public synchronized boolean startedSendingData() {
        return !this.backgroundTransfers.isEmpty();
    }

    public int getPriority() {
        return 7;
    }

    private class BackgroundTransfer
    implements PrioRunnable,
    AsyncMessageFilterCallback {
        final PeerNode pn;
        BlockTransmitter bt;
        boolean receivedCompletionNotice;
        boolean completionSucceeded;
        boolean completedTransfer;
        boolean transferSucceeded;

        BackgroundTransfer(PeerNode pn, PartiallyReceivedBlock prb) {
            this.pn = pn;
            this.bt = new BlockTransmitter(CHKInsertSender.this.node.usm, pn, CHKInsertSender.this.uid, prb, CHKInsertSender.this);
        }

        void start() {
            CHKInsertSender.this.node.executor.execute(this, "CHKInsert-BackgroundTransfer for " + CHKInsertSender.this.uid + " to " + this.pn.getPeer());
        }

        public void run() {
            Logger.OSThread.logPID(this);
            try {
                this.realRun();
            }
            catch (Throwable t) {
                this.completedTransfer(false);
                this.receivedNotice(false);
                Logger.error(this, "Caught " + t, t);
            }
        }

        private void realRun() {
            this.completedTransfer(this.bt.send(CHKInsertSender.this.node.executor));
            if (this.pn.isConnected() && this.transferSucceeded) {
                try {
                    CHKInsertSender.this.node.usm.addAsyncFilter(this.getNotificationMessageFilter(), this);
                }
                catch (DisconnectedException e) {
                    if (logMINOR) {
                        Logger.minor(this, "Disconnected while adding filter");
                    }
                    this.completedTransfer(false);
                    this.receivedNotice(false);
                }
            } else {
                this.receivedNotice(false);
                this.pn.localRejectedOverload("TransferFailedInsert");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void completedTransfer(boolean success) {
            Object object = this;
            synchronized (object) {
                this.transferSucceeded = success;
                this.completedTransfer = true;
                this.notifyAll();
            }
            object = CHKInsertSender.this.backgroundTransfers;
            synchronized (object) {
                CHKInsertSender.this.backgroundTransfers.notifyAll();
            }
            if (!success) {
                CHKInsertSender.this.setTransferTimedOut();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void receivedNotice(boolean success) {
            Object object = this;
            synchronized (object) {
                if (this.receivedCompletionNotice) {
                    Logger.error(this, "receivedNotice(" + success + "), already had receivedNotice(" + this.completionSucceeded + ")");
                } else {
                    this.completionSucceeded = success;
                    this.receivedCompletionNotice = true;
                    this.notifyAll();
                }
            }
            object = CHKInsertSender.this.backgroundTransfers;
            synchronized (object) {
                CHKInsertSender.this.backgroundTransfers.notifyAll();
            }
            if (!success) {
                CHKInsertSender.this.setTransferTimedOut();
            }
        }

        public void onMatched(Message m) {
            this.pn.successNotOverload();
            PeerNode pn = (PeerNode)m.getSource();
            if (this.pn.equals(pn)) {
                boolean anyTimedOut = m.getBoolean("anyTimedOut");
                if (anyTimedOut) {
                    CHKInsertSender.this.setTransferTimedOut();
                }
                this.receivedNotice(!anyTimedOut);
            } else {
                Logger.error(this, "received completion notice for wrong node: " + pn + " != " + this.pn);
            }
        }

        public boolean shouldTimeout() {
            return this.receivedCompletionNotice;
        }

        private MessageFilter getNotificationMessageFilter() {
            return MessageFilter.create().setField("uid", CHKInsertSender.this.uid).setType(DMT.FNPInsertTransfersCompleted).setSource(this.pn).setTimeout(120000);
        }

        public void onTimeout() {
            Logger.normal(this, "Timed out waiting for a final ack from: " + this.pn + " on " + this);
            this.pn.localRejectedOverload("InsertTimeoutNoFinalAck");
            this.receivedNotice(false);
        }

        public void onDisconnect(PeerContext ctx) {
            Logger.normal(this, "Disconnected " + ctx + " for " + this);
            this.receivedNotice(true);
        }

        public void onRestarted(PeerContext ctx) {
            Logger.normal(this, "Restarted " + ctx + " for " + this);
            this.receivedNotice(true);
        }

        public int getPriority() {
            return 7;
        }
    }
}

