/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.RetrievalException;
import freenet.io.xfer.AbortedException;
import freenet.io.xfer.BlockReceiver;
import freenet.io.xfer.PartiallyReceivedBlock;
import freenet.keys.CHKBlock;
import freenet.keys.CHKVerifyException;
import freenet.keys.NodeCHK;
import freenet.node.CHKInsertSender;
import freenet.node.InsertTag;
import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.node.PrioRunnable;
import freenet.support.HexUtil;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.OOMHandler;
import freenet.support.ShortBuffer;

public class CHKInsertHandler
implements PrioRunnable,
ByteCounter {
    private static volatile boolean logMINOR;
    static final int DATA_INSERT_TIMEOUT = 10000;
    final Message req;
    final Node node;
    final long uid;
    final PeerNode source;
    final NodeCHK key;
    final long startTime;
    private short htl;
    private CHKInsertSender sender;
    private byte[] headers;
    private BlockReceiver br;
    private Thread runThread;
    PartiallyReceivedBlock prb;
    final InsertTag tag;
    private boolean canCommit = false;
    private boolean sentCompletion = false;
    private Object sentCompletionLock = new Object();
    private boolean receiveFailed;
    private boolean receiveStarted;
    private boolean receiveCompleted;
    private final Object totalSync = new Object();
    private int totalSentBytes;
    private int totalReceivedBytes;

    CHKInsertHandler(Message req, PeerNode source, long id, Node node, long startTime, InsertTag tag) {
        this.req = req;
        this.node = node;
        this.uid = id;
        this.source = source;
        this.startTime = startTime;
        this.tag = tag;
        this.key = (NodeCHK)req.getObject("freenetRoutingKey");
        this.htl = req.getShort("hopsToLive");
        if (this.htl <= 0) {
            this.htl = 1;
        }
        this.receivedBytes(req.receivedByteCount());
    }

    public String toString() {
        return super.toString() + " for " + this.uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block9: {
            Logger.OSThread.logPID(this);
            try {
                try {
                    this.realRun();
                }
                catch (OutOfMemoryError e) {
                    OOMHandler.handleOOM(e);
                    this.tag.handlerThrew(e);
                    Object var3_2 = null;
                    if (logMINOR) {
                        Logger.minor(this, "Exiting CHKInsertHandler.run() for " + this.uid);
                    }
                    this.node.unlockUID(this.uid, false, true, false, false, false, this.tag);
                    return;
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught in run() " + t, t);
                    this.tag.handlerThrew(t);
                    Object var3_3 = null;
                    if (logMINOR) {
                        Logger.minor(this, "Exiting CHKInsertHandler.run() for " + this.uid);
                    }
                    this.node.unlockUID(this.uid, false, true, false, false, false, this.tag);
                    return;
                }
                Object var3_1 = null;
                if (!logMINOR) break block9;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                if (logMINOR) {
                    Logger.minor(this, "Exiting CHKInsertHandler.run() for " + this.uid);
                }
                this.node.unlockUID(this.uid, false, true, false, false, false, this.tag);
                throw throwable;
            }
            Logger.minor(this, "Exiting CHKInsertHandler.run() for " + this.uid);
        }
        this.node.unlockUID(this.uid, false, true, false, false, false, this.tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realRun() {
        int status;
        Message msg;
        this.runThread = Thread.currentThread();
        Message accepted = DMT.createFNPAccepted(this.uid);
        try {
            this.source.sendSync(accepted, this);
        }
        catch (NotConnectedException e1) {
            if (logMINOR) {
                Logger.minor(this, "Lost connection to source");
            }
            return;
        }
        MessageFilter mf = MessageFilter.create().setType(DMT.FNPDataInsert).setField("uid", this.uid).setSource(this.source).setTimeout(10000);
        try {
            msg = this.node.usm.waitFor(mf, this);
        }
        catch (DisconnectedException e) {
            Logger.normal(this, "Disconnected while waiting for DataInsert on " + this.uid);
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Received " + msg);
        }
        if (msg == null) {
            try {
                if (this.source.isConnected() && this.startTime > this.source.timeLastConnectionCompleted() + 19200L) {
                    Logger.error(this, "Did not receive DataInsert on " + this.uid + " from " + this.source + " !");
                }
                Message tooSlow = DMT.createFNPRejectedTimeout(this.uid);
                this.source.sendAsync(tooSlow, null, this);
                Message m = DMT.createFNPInsertTransfersCompleted(this.uid, true);
                this.source.sendAsync(m, null, this);
                this.prb = new PartiallyReceivedBlock(32, 1024);
                this.br = new BlockReceiver(this.node.usm, this.source, this.uid, this.prb, this, this.node.getTicker(), false);
                this.prb.abort(8, "No DataInsert");
                this.br.sendAborted(8, "No DataInsert");
                return;
            }
            catch (NotConnectedException e) {
                if (logMINOR) {
                    Logger.minor(this, "Lost connection to source");
                }
                return;
            }
        }
        this.headers = ((ShortBuffer)msg.getObject("blockHeaders")).getData();
        this.prb = new PartiallyReceivedBlock(32, 1024);
        if (this.htl > 0) {
            this.sender = this.node.makeInsertSender(this.key, this.htl, this.uid, this.source, this.headers, this.prb, false, true);
        }
        this.br = new BlockReceiver(this.node.usm, this.source, this.uid, this.prb, this, this.node.getTicker(), false);
        DataReceiver dataReceiver = new DataReceiver();
        this.receiveStarted = true;
        this.node.executor.execute(dataReceiver, "CHKInsertHandler$DataReceiver for UID " + this.uid);
        if (this.htl == 0) {
            this.canCommit = true;
            msg = DMT.createFNPInsertReply(this.uid);
            try {
                this.source.sendSync(msg, this);
            }
            catch (NotConnectedException e) {
                // empty catch block
            }
            this.finish(0);
            return;
        }
        boolean receivedRejectedOverload = false;
        do {
            CHKInsertSender cHKInsertSender = this.sender;
            synchronized (cHKInsertSender) {
                try {
                    if (this.sender.getStatus() == -1) {
                        this.sender.wait(5000L);
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (this.receiveFailed()) {
                this.finish(7);
                return;
            }
            if (receivedRejectedOverload || !this.sender.receivedRejectedOverload()) continue;
            receivedRejectedOverload = true;
            Message m = DMT.createFNPRejectedOverload(this.uid, false);
            try {
                this.source.sendSync(m, this);
            }
            catch (NotConnectedException e) {
                if (logMINOR) {
                    Logger.minor(this, "Lost connection to source");
                }
                return;
            }
        } while ((status = this.sender.getStatus()) == -1);
        if (status == 4 || status == 5 || status == 3) {
            msg = DMT.createFNPRejectedOverload(this.uid, true);
            try {
                this.source.sendSync(msg, this);
            }
            catch (NotConnectedException e) {
                if (logMINOR) {
                    Logger.minor(this, "Lost connection to source");
                }
                return;
            }
            if (status == 4 || status == 5) {
                this.canCommit = true;
            }
            this.finish(status);
            return;
        }
        if (status == 1 || status == 6) {
            msg = DMT.createFNPRouteNotFound(this.uid, this.sender.getHTL());
            try {
                this.source.sendSync(msg, this);
            }
            catch (NotConnectedException e) {
                if (logMINOR) {
                    Logger.minor(this, "Lost connection to source");
                }
                return;
            }
            this.canCommit = true;
            this.finish(status);
            return;
        }
        if (status == 7) {
            this.finish(status);
            return;
        }
        if (status == 0) {
            msg = DMT.createFNPInsertReply(this.uid);
            try {
                this.source.sendSync(msg, this);
            }
            catch (NotConnectedException e) {
                Logger.minor(this, "Lost connection to source");
                return;
            }
            this.canCommit = true;
            this.finish(status);
            return;
        }
        Logger.error(this, "Unknown status code: " + this.sender.getStatusString());
        msg = DMT.createFNPRejectedOverload(this.uid, true);
        try {
            this.source.sendSync(msg, this);
        }
        catch (NotConnectedException e) {
            // empty catch block
        }
        this.finish(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(int code) {
        block28: {
            boolean sentCompletionWasSet;
            if (logMINOR) {
                Logger.minor(this, "Waiting for receive");
            }
            CHKInsertHandler cHKInsertHandler = this;
            synchronized (cHKInsertHandler) {
                while (this.receiveStarted && !this.receiveCompleted) {
                    try {
                        this.wait(100000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
            this.maybeCommit();
            if (logMINOR) {
                Logger.minor(this, "Waiting for completion");
            }
            Object e = this.sentCompletionLock;
            synchronized (e) {
                sentCompletionWasSet = this.sentCompletion;
                this.sentCompletion = true;
            }
            Message m = null;
            if (this.sender != null && !sentCompletionWasSet) {
                while (true) {
                    CHKInsertSender cHKInsertSender = this.sender;
                    synchronized (cHKInsertSender) {
                        if (this.sender.completed()) {
                            break;
                        }
                        try {
                            this.sender.wait(10000L);
                        }
                        catch (InterruptedException e2) {
                            // empty catch block
                        }
                    }
                }
                boolean failed = this.sender.anyTransfersFailed();
                m = DMT.createFNPInsertTransfersCompleted(this.uid, failed);
            }
            if (this.sender == null && !sentCompletionWasSet && this.canCommit) {
                m = DMT.createFNPInsertTransfersCompleted(this.uid, false);
            }
            try {
                this.source.sendSync(m, this);
                if (logMINOR) {
                    Logger.minor(this, "Sent completion: " + m + " for " + this);
                }
            }
            catch (NotConnectedException e1) {
                if (!logMINOR) break block28;
                Logger.minor(this, "Not connected: " + this.source + " for " + this);
            }
        }
        if (code != 4 && code != 5 && code != 3 && code != 6 && code != 7 && !this.receiveFailed()) {
            int totalSent = this.getTotalSentBytes();
            int totalReceived = this.getTotalReceivedBytes();
            if (this.sender != null) {
                totalSent += this.sender.getTotalSentBytes();
                totalReceived += this.sender.getTotalReceivedBytes();
            }
            if (logMINOR) {
                Logger.minor(this, "Remote CHK insert cost " + totalSent + '/' + totalReceived + " bytes (" + code + ") receive failed = " + this.receiveFailed());
            }
            this.node.nodeStats.remoteChkInsertBytesSentAverage.report(totalSent);
            this.node.nodeStats.remoteChkInsertBytesReceivedAverage.report(totalReceived);
            if (code == 0) {
                if (this.sender != null && this.sender.startedSendingData()) {
                    this.node.nodeStats.successfulChkInsertBytesSentAverage.report(totalSent);
                }
                this.node.nodeStats.successfulChkInsertBytesReceivedAverage.report(totalReceived);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeCommit() {
        block13: {
            Message toSend = null;
            CHKInsertHandler cHKInsertHandler = this;
            synchronized (cHKInsertHandler) {
                if (this.prb == null || this.prb.isAborted()) {
                    return;
                }
                try {
                    if (!this.canCommit) {
                        return;
                    }
                    if (!this.prb.allReceived()) {
                        return;
                    }
                    CHKBlock block = new CHKBlock(this.prb.getBlock(), this.headers, this.key);
                    this.node.store(block);
                    if (logMINOR) {
                        Logger.minor(this, "Committed");
                    }
                }
                catch (CHKVerifyException e) {
                    Logger.error(this, "Verify failed in CHKInsertHandler: " + e + " - headers: " + HexUtil.bytesToHex(this.headers), e);
                    toSend = DMT.createFNPDataInsertRejected(this.uid, (short)1);
                }
                catch (AbortedException e) {
                    Logger.error(this, "Receive failed: " + e);
                }
            }
            if (toSend != null) {
                try {
                    this.source.sendAsync(toSend, null, this);
                }
                catch (NotConnectedException e) {
                    if (!logMINOR) break block13;
                    Logger.minor(this, "Lost connection in " + this + " when sending FNPDataInsertRejected");
                }
            }
        }
    }

    private synchronized boolean receiveFailed() {
        return this.receiveFailed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sentBytes(int x) {
        Object object = this.totalSync;
        synchronized (object) {
            this.totalSentBytes += x;
        }
        this.node.nodeStats.insertSentBytes(false, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedBytes(int x) {
        Object object = this.totalSync;
        synchronized (object) {
            this.totalReceivedBytes += x;
        }
        this.node.nodeStats.insertReceivedBytes(false, x);
    }

    public int getTotalSentBytes() {
        return this.totalSentBytes;
    }

    public int getTotalReceivedBytes() {
        return this.totalReceivedBytes;
    }

    public void sentPayload(int x) {
        this.node.sentPayload(x);
        this.node.nodeStats.insertSentBytes(false, -x);
    }

    public int getPriority() {
        return 7;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }

    public class DataReceiver
    implements PrioRunnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Logger.OSThread.logPID(this);
            if (logMINOR) {
                Logger.minor(this, "Receiving data for " + CHKInsertHandler.this);
            }
            try {
                CHKInsertHandler.this.br.receive();
                if (logMINOR) {
                    Logger.minor(this, "Received data for " + CHKInsertHandler.this);
                }
                CHKInsertHandler cHKInsertHandler = CHKInsertHandler.this;
                synchronized (cHKInsertHandler) {
                    CHKInsertHandler.this.receiveCompleted = true;
                    CHKInsertHandler.this.notifyAll();
                }
                CHKInsertHandler.this.node.nodeStats.successfulBlockReceive();
            }
            catch (RetrievalException e) {
                block16: {
                    CHKInsertHandler cHKInsertHandler = CHKInsertHandler.this;
                    synchronized (cHKInsertHandler) {
                        CHKInsertHandler.this.receiveCompleted = true;
                        CHKInsertHandler.this.receiveFailed = true;
                        CHKInsertHandler.this.notifyAll();
                    }
                    if (CHKInsertHandler.this.sender != null) {
                        CHKInsertHandler.this.sender.receiveFailed();
                    }
                    CHKInsertHandler.this.runThread.interrupt();
                    Message msg = DMT.createFNPDataInsertRejected(CHKInsertHandler.this.uid, (short)2);
                    try {
                        CHKInsertHandler.this.source.sendSync(msg, CHKInsertHandler.this);
                    }
                    catch (NotConnectedException ex) {
                        if (!logMINOR) break block16;
                        Logger.minor(this, "Can't send " + msg + " to " + CHKInsertHandler.this.source + ": " + ex);
                    }
                }
                if (e.getReason() == 7) {
                    Logger.normal(this, "Failed to retrieve (disconnect): " + e, e);
                } else {
                    Logger.normal(this, "Failed to retrieve (" + e.getReason() + "/" + RetrievalException.getErrString(e.getReason()) + "): " + e, e);
                }
                CHKInsertHandler.this.node.nodeStats.failedBlockReceive(false, false, false);
                return;
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t, t);
            }
        }

        public String toString() {
            return super.toString() + " for " + CHKInsertHandler.this.uid;
        }

        public int getPriority() {
            return 7;
        }
    }
}

