/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.l10n.L10n;
import freenet.node.AnnounceSender;
import freenet.node.AnnouncementCallback;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.node.OpennetManager;
import freenet.node.PeerNode;
import freenet.node.SeedServerPeerNode;
import freenet.node.useralerts.SimpleUserAlert;
import freenet.node.useralerts.UserAlert;
import freenet.support.ByteArrayWrapper;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.TimeUtil;
import freenet.support.io.Closer;
import freenet.support.transport.ip.IPUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Announcer {
    private static boolean logMINOR;
    private final Node node;
    private final OpennetManager om;
    private int status;
    private static final int STATUS_LOADING = 0;
    private static final int STATUS_CONNECTING_SEEDNODES = 1;
    private static final int STATUS_NO_SEEDNODES = -1;
    private int runningAnnouncements;
    private static final int WANT_ANNOUNCEMENTS = 5;
    private int sentAnnouncements;
    private long startTime;
    private long timeAddedSeeds;
    private static final long MIN_ADDED_SEEDS_INTERVAL = 60000L;
    static final int COOLING_OFF_PERIOD = 30000;
    private final HashSet<ByteArrayWrapper> announcedToIdentities;
    private final HashSet<InetAddress> announcedToIPs;
    private static final int CONNECT_AT_ONCE = 15;
    private static final int MIN_OPENNET_CONNECTED_PEERS = 10;
    private static final long NOT_ALL_CONNECTED_DELAY = 60000L;
    private final HashSet<ByteArrayWrapper> connectedToIdentities;
    private int announcementAddedNodes;
    private int announcementNotWantedNodes;
    private long timeGotEnoughPeers = -1L;
    private final Object timeGotEnoughPeersLock = new Object();
    private boolean killedAnnouncementTooOld;
    private boolean ignoreIPUndetected;
    private static final int FORCE_ANNOUNCEMENT_NO_IP = 120000;
    private static final int FINAL_DELAY = 60000;
    static final int RETRY_DELAY = 60000;
    private boolean started = false;
    private long toldUserNoIP = -1L;
    private boolean dontKnowOurIPAddress;
    private final Runnable checker = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int running;
            Announcer announcer = Announcer.this;
            synchronized (announcer) {
                running = Announcer.this.runningAnnouncements;
            }
            if (Announcer.this.enoughPeers()) {
                for (SeedServerPeerNode pn : ((Announcer)Announcer.this).node.peers.getConnectedSeedServerPeersVector(null)) {
                    ((Announcer)Announcer.this).node.peers.disconnect(pn, true, true, false);
                }
                Announcer.this.node.getTicker().queueTimedJob(new Runnable(){

                    public void run() {
                        Announcer.this.maybeSendAnnouncement();
                    }
                }, "Check whether we need to announce", 60000L, false, true);
            } else {
                Announcer.this.node.getTicker().queueTimedJob(new Runnable(){

                    public void run() {
                        Announcer.this.maybeSendAnnouncement();
                    }
                }, "Check whether we need to announce", 60000L, false, true);
                if (running != 0) {
                    Announcer.this.maybeSendAnnouncement();
                }
            }
        }
    };

    Announcer(OpennetManager om) {
        this.om = om;
        this.node = om.node;
        this.announcedToIdentities = new HashSet();
        this.announcedToIPs = new HashSet();
        this.connectedToIdentities = new HashSet();
        logMINOR = Logger.shouldLog(4, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() {
        if (!this.node.isOpennetEnabled()) {
            return;
        }
        this.registerAlert();
        int darkPeers = this.node.peers.getDarknetPeers().length;
        int openPeers = this.node.peers.getOpennetPeers().length;
        int oldOpenPeers = this.om.countOldOpennetPeers();
        if (darkPeers + openPeers + oldOpenPeers == 0) {
            System.err.println("Attempting announcement to seednodes...");
            Announcer announcer = this;
            synchronized (announcer) {
                this.status = 0;
                this.started = true;
            }
            this.connectSomeSeednodes();
        } else {
            System.out.println("Not attempting immediate announcement: dark peers=" + darkPeers + " open peers=" + openPeers + " old open peers=" + oldOpenPeers + " - will wait 1 minute...");
            this.node.getTicker().queueTimedJob(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Announcer announcer = Announcer.this;
                    synchronized (announcer) {
                        Announcer.this.started = true;
                    }
                    try {
                        Announcer.this.maybeSendAnnouncement();
                    }
                    catch (Throwable t) {
                        Logger.error(this, "Caught " + t + " trying to send announcements", t);
                    }
                }
            }, 60000L);
        }
    }

    private void registerAlert() {
        this.node.clientCore.alerts.register(new AnnouncementUserAlert());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectSomeSeednodes() {
        if (!this.node.isOpennetEnabled()) {
            return;
        }
        boolean announceNow = false;
        if (logMINOR) {
            Logger.minor(this, "Connecting some seednodes...");
        }
        List<SimpleFieldSet> seeds = Announcer.readSeednodes(this.node.nodeDir);
        long now = System.currentTimeMillis();
        Announcer announcer = this;
        synchronized (announcer) {
            if (now - this.timeAddedSeeds < 60000L) {
                return;
            }
            this.timeAddedSeeds = now;
            if (seeds.size() == 0) {
                this.status = -1;
                return;
            }
            this.status = 1;
        }
        int count = this.connectSomeNodesInner(seeds);
        Announcer announcer2 = this;
        synchronized (announcer2) {
            if (logMINOR) {
                Logger.minor(this, "count = " + count + " connected = " + this.connectedToIdentities.size() + " announced = " + this.announcedToIdentities.size() + " running = " + this.runningAnnouncements);
            }
            if (count == 0 && this.runningAnnouncements == 0) {
                if (this.connectedToIdentities.size() > this.announcedToIdentities.size()) {
                    if (logMINOR) {
                        Logger.minor(this, "Will clear announced-to in 1 minute...");
                    }
                    this.node.getTicker().queueTimedJob(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            if (logMINOR) {
                                Logger.minor(this, "Clearing old announced-to list");
                            }
                            Announcer announcer = Announcer.this;
                            synchronized (announcer) {
                                if (Announcer.this.runningAnnouncements != 0) {
                                    return;
                                }
                                Announcer.this.announcedToIdentities.clear();
                                Announcer.this.announcedToIPs.clear();
                                Announcer.this.connectedToIdentities.clear();
                            }
                            Announcer.this.maybeSendAnnouncement();
                        }
                    }, 60000L);
                } else if (this.connectedToIdentities.size() == this.announcedToIdentities.size()) {
                    this.announcedToIdentities.clear();
                    this.announcedToIPs.clear();
                    this.connectedToIdentities.clear();
                    announceNow = true;
                }
            }
        }
        this.node.dnsr.forceRun();
        this.node.getTicker().queueTimedJob(new Runnable(){

            public void run() {
                try {
                    Announcer.this.maybeSendAnnouncement();
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught " + t + " trying to send announcements", t);
                }
            }
        }, announceNow ? 0L : 60000L);
    }

    private synchronized int connectSomeNodesInner(List<SimpleFieldSet> seeds) {
        if (logMINOR) {
            Logger.minor(this, "Connecting some seednodes from " + seeds.size());
        }
        int count = 0;
        while (count < 15 && seeds.size() != 0) {
            SimpleFieldSet fs = seeds.remove(this.node.random.nextInt(seeds.size()));
            try {
                SeedServerPeerNode seed = new SeedServerPeerNode(fs, this.node, this.om.crypto, this.node.peers, false, this.om.crypto.packetMangler);
                if (this.announcedToIdentities.contains(new ByteArrayWrapper(seed.identity))) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "Not adding: already announced-to: " + seed.userToString());
                    continue;
                }
                if (logMINOR) {
                    Logger.minor(this, "Trying to connect to seednode " + seed);
                }
                if (this.node.peers.addPeer(seed)) {
                    ++count;
                    this.connectedToIdentities.add(new ByteArrayWrapper(seed.identity));
                    if (!logMINOR) continue;
                    Logger.minor(this, "Connecting to seednode " + seed);
                    continue;
                }
                if (!logMINOR) continue;
                Logger.minor(this, "Not connecting to seednode " + seed);
            }
            catch (FSParseException e) {
                Logger.error(this, "Invalid seed in file: " + e + " for\n" + fs, e);
            }
            catch (PeerParseException e) {
                Logger.error(this, "Invalid seed in file: " + e + " for\n" + fs, e);
            }
            catch (ReferenceSignatureVerificationException e) {
                Logger.error(this, "Invalid seed in file: " + e + " for\n" + fs, e);
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SimpleFieldSet> readSeednodes(File nodeDir) {
        File file = new File(nodeDir, "seednodes.fref");
        ArrayList<SimpleFieldSet> list = new ArrayList<SimpleFieldSet>();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            BufferedInputStream bis = new BufferedInputStream(fis);
            InputStreamReader isr = new InputStreamReader((InputStream)bis, "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            try {
                while (true) {
                    SimpleFieldSet fs;
                    if ((fs = new SimpleFieldSet(br, false, false)).isEmpty()) {
                        continue;
                    }
                    list.add(fs);
                }
            }
            catch (EOFException e) {
                ArrayList<SimpleFieldSet> arrayList = list;
                Object var10_12 = null;
                Closer.close(fis);
                return arrayList;
            }
        }
        catch (IOException e) {
            ArrayList<SimpleFieldSet> arrayList;
            try {
                arrayList = list;
                Object var10_13 = null;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                Closer.close(fis);
                throw throwable;
            }
            Closer.close(fis);
            return arrayList;
        }
    }

    protected void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean enoughPeers() {
        int target;
        int opennetCount = this.node.peers.countConnectedOpennetPeers();
        if (opennetCount >= (target = Math.min(10, this.om.getNumberOfConnectedPeersToAim() / 2))) {
            if (logMINOR) {
                Logger.minor(this, "We have enough opennet peers: " + opennetCount + " > " + target + " since " + (System.currentTimeMillis() - this.timeGotEnoughPeers) + " ms");
            }
            Object object = this.timeGotEnoughPeersLock;
            synchronized (object) {
                if (this.timeGotEnoughPeers <= 0L) {
                    this.timeGotEnoughPeers = System.currentTimeMillis();
                }
            }
            return true;
        }
        if ((this.node.nodeUpdater == null || !this.node.nodeUpdater.isEnabled() || this.node.nodeUpdater.canUpdateNow() && !this.node.nodeUpdater.isArmed()) && this.node.peers.getPeerNodeStatusSize(3, true) + this.node.peers.getPeerNodeStatusSize(3, false) > 10) {
            Announcer announcer = this;
            synchronized (announcer) {
                if (this.killedAnnouncementTooOld) {
                    return true;
                }
                this.killedAnnouncementTooOld = true;
            }
            Logger.error(this, "Shutting down announcement as we are older than the current mandatory build and auto-update is disabled or waiting for user input.");
            System.err.println("Shutting down announcement as we are older than the current mandatory build and auto-update is disabled or waiting for user input.");
            if (this.node.clientCore != null) {
                this.node.clientCore.alerts.register(new SimpleUserAlert(false, this.l10n("announceDisabledTooOldTitle"), this.l10n("announceDisabledTooOld"), this.l10n("announceDisabledTooOldShort"), 0));
            }
            return true;
        }
        Object object = this.timeGotEnoughPeersLock;
        synchronized (object) {
            this.timeGotEnoughPeers = -1L;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long timeGotEnoughPeers() {
        Object object = this.timeGotEnoughPeersLock;
        synchronized (object) {
            return this.timeGotEnoughPeers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void maybeSendAnnouncement() {
        Announcer announcer = this;
        synchronized (announcer) {
            if (!this.started) {
                return;
            }
        }
        logMINOR = Logger.shouldLog(4, this);
        if (logMINOR) {
            Logger.minor(this, "maybeSendAnnouncement()");
        }
        long now = System.currentTimeMillis();
        if (!this.node.isOpennetEnabled()) {
            return;
        }
        if (this.enoughPeers()) {
            this.node.getTicker().queueTimedJob(this.checker, 60000L);
            return;
        }
        if (!this.ignoreIPUndetected && !this.node.ipDetector.hasValidIP() && this.node.ipDetector.ipDetectorManager.hasDetectors()) {
            if (now - this.toldUserNoIP > 60000L) {
                System.out.println("Don't know our IP address, waiting for another 2 minutes...");
            }
            Announcer announcer2 = this;
            synchronized (announcer2) {
                this.dontKnowOurIPAddress = true;
            }
            this.node.getTicker().queueTimedJob(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Announcer announcer = Announcer.this;
                    synchronized (announcer) {
                        if (Announcer.this.ignoreIPUndetected) {
                            return;
                        }
                        Announcer.this.ignoreIPUndetected = true;
                    }
                    Announcer.this.maybeSendAnnouncement();
                }
            }, 120000L);
            return;
        }
        Announcer announcer3 = this;
        synchronized (announcer3) {
            this.dontKnowOurIPAddress = false;
            if (this.enoughPeers()) {
                return;
            }
            if (this.runningAnnouncements > 5) {
                if (logMINOR) {
                    Logger.minor(this, "Running announcements already");
                }
                return;
            }
            if (System.currentTimeMillis() < this.startTime) {
                if (logMINOR) {
                    Logger.minor(this, "In cooling-off period for next " + TimeUtil.formatTime(this.startTime - System.currentTimeMillis()));
                }
                return;
            }
            if (this.sentAnnouncements >= 5) {
                if (logMINOR) {
                    Logger.minor(this, "Sent enough announcements");
                }
                return;
            }
            Vector<SeedServerPeerNode> seeds = this.node.peers.getConnectedSeedServerPeersVector(this.announcedToIdentities);
            while (this.sentAnnouncements < 5) {
                if (seeds.isEmpty()) {
                    if (!logMINOR) break;
                    Logger.minor(this, "No more seednodes, announcedTo = " + this.announcedToIdentities.size());
                    break;
                }
                SeedServerPeerNode seed = seeds.remove(this.node.random.nextInt(seeds.size()));
                InetAddress[] addrs = seed.getInetAddresses();
                if (!this.newAnnouncedIPs(addrs)) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "Not announcing to " + seed + " because already used those IPs");
                    continue;
                }
                this.addAnnouncedIPs(addrs);
                ++this.sentAnnouncements;
                ++this.runningAnnouncements;
                this.announcedToIdentities.add(new ByteArrayWrapper(seed.getIdentity()));
                this.sendAnnouncement(seed);
            }
            if (this.runningAnnouncements >= 5) {
                if (logMINOR) {
                    Logger.minor(this, "Running " + this.runningAnnouncements + " announcements");
                }
                return;
            }
            if (now - this.timeAddedSeeds < 60000L) {
                Logger.minor(this, "Waiting for MIN_ADDED_SEEDS_INTERVAL");
                this.node.getTicker().queueTimedJob(new Runnable(){

                    public void run() {
                        try {
                            Announcer.this.maybeSendAnnouncement();
                        }
                        catch (Throwable t) {
                            Logger.error(this, "Caught " + t + " trying to send announcements", t);
                        }
                    }
                }, this.timeAddedSeeds + 60000L - now);
                return;
            }
        }
        this.connectSomeSeednodes();
    }

    private synchronized void addAnnouncedIPs(InetAddress[] addrs) {
        for (InetAddress addr : addrs) {
            this.announcedToIPs.add(addr);
        }
    }

    private synchronized boolean newAnnouncedIPs(InetAddress[] addrs) {
        boolean hasNonLocalAddresses = false;
        for (int i = 0; i < addrs.length; ++i) {
            if (!IPUtil.isValidAddress(addrs[i], false)) continue;
            hasNonLocalAddresses = true;
            if (this.announcedToIPs.contains(addrs[i])) continue;
            return true;
        }
        return !hasNonLocalAddresses;
    }

    protected void sendAnnouncement(final SeedServerPeerNode seed) {
        if (!this.node.isOpennetEnabled()) {
            if (logMINOR) {
                Logger.minor(this, "Not announcing to " + seed + " because opennet is disabled");
            }
            return;
        }
        System.out.println("Announcement to " + seed.userToString() + " starting...");
        if (logMINOR) {
            Logger.minor(this, "Announcement to " + seed.userToString() + " starting...");
        }
        AnnounceSender sender = new AnnounceSender(this.node.getLocation(), this.om, this.node, new AnnouncementCallback(){
            private int totalAdded;
            private int totalNotWanted;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void addedNode(PeerNode pn) {
                Announcer announcer = Announcer.this;
                synchronized (announcer) {
                    Announcer.this.announcementAddedNodes++;
                    ++this.totalAdded;
                }
                Logger.normal(this, "Announcement to " + seed.userToString() + " added node " + pn + " for a total of " + Announcer.this.announcementAddedNodes + " (" + this.totalAdded + " from this announcement)");
                System.out.println("Announcement to " + seed.userToString() + " added node " + pn.userToString() + '.');
            }

            public void bogusNoderef(String reason) {
                Logger.normal(this, "Announcement to " + seed.userToString() + " got bogus noderef: " + reason, new Exception("debug"));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed() {
                boolean announceNow = false;
                Announcer announcer = Announcer.this;
                synchronized (announcer) {
                    Announcer.this.runningAnnouncements--;
                    Logger.normal(this, "Announcement to " + seed.userToString() + " completed, now running " + Announcer.this.runningAnnouncements + " announcements");
                    if (Announcer.this.runningAnnouncements == 0 && Announcer.this.announcementAddedNodes > 0) {
                        Announcer.this.startTime = System.currentTimeMillis() + 30000L;
                        Announcer.this.sentAnnouncements = 0;
                        Announcer.this.node.getTicker().queueTimedJob(new Runnable(){

                            public void run() {
                                Announcer.this.maybeSendAnnouncement();
                            }
                        }, 30000L);
                    } else if (Announcer.this.runningAnnouncements == 0) {
                        Announcer.this.sentAnnouncements = 0;
                        announceNow = true;
                    }
                }
                ((Announcer)Announcer.this).node.peers.disconnect(seed, true, false, false);
                System.out.println("Announcement to " + seed.userToString() + " completed.");
                if (announceNow) {
                    Announcer.this.maybeSendAnnouncement();
                }
            }

            public void nodeFailed(PeerNode pn, String reason) {
                Logger.normal(this, "Announcement to node " + pn.userToString() + " failed: " + reason);
            }

            public void noMoreNodes() {
                Logger.normal(this, "Announcement to " + seed.userToString() + " ran out of nodes (route not found)");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void nodeNotWanted() {
                Announcer announcer = Announcer.this;
                synchronized (announcer) {
                    Announcer.this.announcementNotWantedNodes++;
                    ++this.totalNotWanted;
                }
                Logger.normal(this, "Announcement to " + seed.userToString() + " returned node not wanted for a total of " + Announcer.this.announcementNotWantedNodes + " (" + this.totalNotWanted + " from this announcement)");
            }

            public void nodeNotAdded() {
                Logger.normal(this, "Announcement to " + seed.userToString() + " : node not wanted (maybe already have it, opennet just turned off, etc)");
            }
        }, seed);
        this.node.executor.execute(sender, "Announcer to " + seed);
    }

    private String l10n(String key) {
        return L10n.getString("Announcer." + key);
    }

    protected String l10n(String key, String[] patterns, String[] values) {
        return L10n.getString("Announcer." + key, patterns, values);
    }

    private String l10n(String key, String pattern, String value) {
        return L10n.getString("Announcer." + key, pattern, value);
    }

    class AnnouncementUserAlert
    implements UserAlert {
        AnnouncementUserAlert() {
        }

        public String dismissButtonText() {
            return L10n.getString("UserAlert.hide");
        }

        public HTMLNode getHTMLText() {
            return new HTMLNode("#", this.getText());
        }

        public short getPriorityClass() {
            return 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getText() {
            boolean dontKnowAddress;
            int status;
            StringBuilder sb = new StringBuilder();
            sb.append(Announcer.this.l10n("announceAlertIntro"));
            AnnouncementUserAlert announcementUserAlert = this;
            synchronized (announcementUserAlert) {
                status = Announcer.this.status;
                dontKnowAddress = Announcer.this.dontKnowOurIPAddress;
            }
            if (status == -1) {
                return Announcer.this.l10n("announceAlertNoSeednodes");
            }
            if (status == 0) {
                return Announcer.this.l10n("announceLoading");
            }
            if (((Announcer)Announcer.this).node.clientCore.isAdvancedModeEnabled()) {
                int runningAnnouncements;
                int recentSentAnnouncements;
                int refusedNodes;
                int addedNodes;
                sb.append(' ');
                int connectedSeednodes = 0;
                int disconnectedSeednodes = 0;
                long coolingOffSeconds = Math.max(0L, Announcer.this.startTime - System.currentTimeMillis()) / 1000L;
                AnnouncementUserAlert announcementUserAlert2 = this;
                synchronized (announcementUserAlert2) {
                    addedNodes = Announcer.this.announcementAddedNodes;
                    refusedNodes = Announcer.this.announcementNotWantedNodes;
                    recentSentAnnouncements = Announcer.this.sentAnnouncements;
                    runningAnnouncements = Announcer.this.runningAnnouncements;
                }
                List<SeedServerPeerNode> nodes = ((Announcer)Announcer.this).node.peers.getSeedServerPeersVector();
                for (SeedServerPeerNode seed : nodes) {
                    if (seed.isConnected()) {
                        ++connectedSeednodes;
                        continue;
                    }
                    ++disconnectedSeednodes;
                }
                if (dontKnowAddress) {
                    sb.append(Announcer.this.l10n("dontKnowAddress"));
                } else {
                    sb.append(Announcer.this.l10n("announceDetails", new String[]{"addedNodes", "refusedNodes", "recentSentAnnouncements", "runningAnnouncements", "connectedSeednodes", "disconnectedSeednodes"}, new String[]{Integer.toString(addedNodes), Integer.toString(refusedNodes), Integer.toString(recentSentAnnouncements), Integer.toString(runningAnnouncements), Integer.toString(connectedSeednodes), Integer.toString(disconnectedSeednodes)}));
                }
                if (coolingOffSeconds > 0L) {
                    sb.append(' ');
                    sb.append(Announcer.this.l10n("coolingOff", "time", Long.toString(coolingOffSeconds)));
                }
            }
            return sb.toString();
        }

        public String getTitle() {
            return Announcer.this.l10n("announceAlertTitle");
        }

        public Object getUserIdentifier() {
            return null;
        }

        public boolean isValid() {
            return !Announcer.this.enoughPeers() && Announcer.this.node.isOpennetEnabled();
        }

        public void isValid(boolean validity) {
        }

        public void onDismiss() {
        }

        public boolean shouldUnregisterOnDismiss() {
            return true;
        }

        public boolean userCanDismiss() {
            return true;
        }

        public String anchor() {
            return "announcer:" + this.hashCode();
        }

        public String getShortText() {
            return Announcer.this.l10n("announceAlertShort");
        }

        public boolean isEventNotification() {
            return false;
        }
    }
}

