/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.node.AnnouncementCallback;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.node.OpennetManager;
import freenet.node.OpennetPeerNode;
import freenet.node.PeerNode;
import freenet.node.PrioRunnable;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import java.util.HashSet;

public class AnnounceSender
implements PrioRunnable,
ByteCounter {
    private static volatile boolean logMINOR;
    static final int ACCEPTED_TIMEOUT = 10000;
    static final int ANNOUNCE_TIMEOUT = 240000;
    static final int END_TIMEOUT = 30000;
    private final PeerNode source;
    private final long uid;
    private final OpennetManager om;
    private final Node node;
    private Message msg;
    private byte[] noderefBuf;
    private int noderefLength;
    private short htl;
    private double target;
    private final AnnouncementCallback cb;
    private final PeerNode onlyNode;

    public AnnounceSender(Message m, long uid, PeerNode source, OpennetManager om, Node node) {
        this.source = source;
        this.uid = uid;
        this.msg = m;
        this.om = om;
        this.node = node;
        this.onlyNode = null;
        this.htl = (short)Math.min(m.getShort("hopsToLive"), node.maxHTL());
        this.target = m.getDouble("targetLocation");
        this.cb = null;
    }

    public AnnounceSender(double target, OpennetManager om, Node node, AnnouncementCallback cb, PeerNode onlyNode) {
        this.source = null;
        this.uid = node.random.nextLong();
        this.msg = null;
        this.om = om;
        this.node = node;
        this.htl = node.maxHTL();
        this.target = target;
        this.cb = cb;
        this.onlyNode = onlyNode;
        this.noderefBuf = om.crypto.myCompressedFullRef();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block7: {
            try {
                try {
                    this.realRun();
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught " + t + " announcing " + this.uid + " from " + this.source, t);
                    Object var3_2 = null;
                    if (this.source != null) {
                        this.source.completedAnnounce(this.uid);
                    }
                    this.node.completed(this.uid);
                    if (this.cb == null) return;
                    this.cb.completed();
                    return;
                }
                Object var3_1 = null;
                if (this.source == null) break block7;
                this.source.completedAnnounce(this.uid);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.source != null) {
                    this.source.completedAnnounce(this.uid);
                }
                this.node.completed(this.uid);
                if (this.cb == null) throw throwable;
                this.cb.completed();
                throw throwable;
            }
        }
        this.node.completed(this.uid);
        if (this.cb == null) return;
        this.cb.completed();
    }

    private void realRun() {
        boolean hasForwarded = false;
        if (this.source != null) {
            try {
                this.source.sendAsync(DMT.createFNPAccepted(this.uid), null, this);
            }
            catch (NotConnectedException e) {
                return;
            }
            if (!this.transferNoderef()) {
                return;
            }
        }
        HashSet<PeerNode> nodesRoutedTo = new HashSet<PeerNode>();
        PeerNode next = null;
        block14: while (true) {
            MessageFilter mfRejectedOverload;
            if (logMINOR) {
                Logger.minor(this, "htl=" + this.htl);
            }
            this.htl = this.node.decrementHTL(hasForwarded ? next : this.source, this.htl);
            if (this.htl == 0) {
                this.complete();
                return;
            }
            if (!this.node.isOpennetEnabled()) {
                this.complete();
                return;
            }
            if (this.onlyNode == null) {
                next = this.node.peers.closerPeer(this.source, nodesRoutedTo, this.target, true, this.node.isAdvancedModeEnabled(), -1, null, null);
            } else {
                next = this.onlyNode;
                if (nodesRoutedTo.contains(this.onlyNode)) {
                    this.rnf(this.onlyNode);
                    return;
                }
            }
            if (next == null) {
                this.rnf(next);
                return;
            }
            if (logMINOR) {
                Logger.minor(this, "Routing request to " + next);
            }
            nodesRoutedTo.add(next);
            long xferUID = this.sendTo(next);
            if (xferUID == -1L) continue;
            hasForwarded = true;
            Message msg = null;
            while (true) {
                block49: {
                    MessageFilter mfAccepted = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(10000).setType(DMT.FNPAccepted);
                    MessageFilter mfRejectedLoop = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(10000).setType(DMT.FNPRejectedLoop);
                    mfRejectedOverload = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(10000).setType(DMT.FNPRejectedOverload);
                    MessageFilter mfOpennetDisabled = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(10000).setType(DMT.FNPOpennetDisabled);
                    MessageFilter mf = mfAccepted.or(mfRejectedLoop.or(mfRejectedOverload.or(mfOpennetDisabled)));
                    try {
                        msg = this.node.usm.waitFor(mf, this);
                        if (!logMINOR) break block49;
                        Logger.minor(this, "first part got " + msg);
                    }
                    catch (DisconnectedException e) {
                        Logger.normal(this, "Disconnected from " + next + " while waiting for Accepted on " + this.uid);
                        break;
                    }
                }
                if (msg == null) {
                    if (logMINOR) {
                        Logger.minor(this, "Timeout waiting for Accepted");
                    }
                    msg = null;
                    break;
                }
                if (msg.getSpec() == DMT.FNPRejectedLoop) {
                    if (logMINOR) {
                        Logger.minor(this, "Rejected loop");
                    }
                    msg = null;
                    break;
                }
                if (msg.getSpec() == DMT.FNPRejectedOverload) {
                    if (logMINOR) {
                        Logger.minor(this, "Rejected: overload");
                    }
                    msg = null;
                    break;
                }
                if (msg.getSpec() == DMT.FNPOpennetDisabled) {
                    if (logMINOR) {
                        Logger.minor(this, "Opennet disabled");
                    }
                    msg = null;
                    break;
                }
                if (msg.getSpec() == DMT.FNPAccepted) break;
                Logger.error(this, "Unrecognized message: " + msg);
            }
            if (msg == null || msg.getSpec() != DMT.FNPAccepted) continue;
            if (logMINOR) {
                Logger.minor(this, "Got Accepted");
            }
            try {
                this.sendRest(next, xferUID);
            }
            catch (NotConnectedException e1) {
                if (!logMINOR) continue;
                Logger.minor(this, "Not connected while sending noderef on " + next);
                continue;
            }
            while (true) {
                MessageFilter mfAnnounceCompleted = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(240000).setType(DMT.FNPOpennetAnnounceCompleted);
                MessageFilter mfRouteNotFound = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(240000).setType(DMT.FNPRouteNotFound);
                mfRejectedOverload = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(240000).setType(DMT.FNPRejectedOverload);
                MessageFilter mfAnnounceReply = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(240000).setType(DMT.FNPOpennetAnnounceReply);
                MessageFilter mfOpennetDisabled = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(240000).setType(DMT.FNPOpennetDisabled);
                MessageFilter mfNotWanted = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(240000).setType(DMT.FNPOpennetAnnounceNodeNotWanted);
                MessageFilter mfOpennetNoderefRejected = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(10000).setType(DMT.FNPOpennetNoderefRejected);
                MessageFilter mf = mfAnnounceCompleted.or(mfRouteNotFound.or(mfRejectedOverload.or(mfAnnounceReply.or(mfOpennetDisabled.or(mfNotWanted.or(mfOpennetNoderefRejected))))));
                try {
                    msg = this.node.usm.waitFor(mf, this);
                }
                catch (DisconnectedException e) {
                    Logger.normal(this, "Disconnected from " + next + " while waiting for announcement");
                    continue block14;
                }
                if (logMINOR) {
                    Logger.minor(this, "second part got " + msg);
                }
                if (msg == null) {
                    this.timedOut(next);
                    return;
                }
                if (msg.getSpec() == DMT.FNPOpennetNoderefRejected) {
                    int reason = msg.getInt("rejectCode");
                    Logger.normal(this, "Announce rejected by " + next + " : " + DMT.getOpennetRejectedCode(reason));
                    msg = null;
                    continue block14;
                }
                if (msg.getSpec() == DMT.FNPOpennetAnnounceCompleted) {
                    this.complete();
                    mfAnnounceReply.setTimeout(30000).setTimeoutRelativeToCreation(true);
                    mfNotWanted.setTimeout(30000).setTimeoutRelativeToCreation(true);
                    mfAnnounceReply.clearOr();
                    mfNotWanted.clearOr();
                    mf = mfAnnounceReply.or(mfNotWanted);
                    while (true) {
                        try {
                            msg = this.node.usm.waitFor(mf, this);
                        }
                        catch (DisconnectedException e) {
                            return;
                        }
                        if (msg == null) {
                            return;
                        }
                        if (msg.getSpec() == DMT.FNPOpennetAnnounceReply) {
                            this.validateForwardReply(msg, next);
                            continue;
                        }
                        if (msg.getSpec() != DMT.FNPOpennetAnnounceNodeNotWanted) continue;
                        if (this.cb != null) {
                            this.cb.nodeNotWanted();
                        }
                        if (this.source == null) continue;
                        try {
                            this.sendNotWanted();
                        }
                        catch (NotConnectedException e) {
                            Logger.error(this, "Lost connection to source");
                            return;
                        }
                    }
                }
                if (msg.getSpec() == DMT.FNPRouteNotFound) {
                    short newHtl = msg.getShort("hopsToLive");
                    if (newHtl >= this.htl) continue block14;
                    this.htl = newHtl;
                    continue block14;
                }
                if (msg.getSpec() == DMT.FNPRejectedOverload) continue block14;
                if (msg.getSpec() == DMT.FNPOpennetDisabled) {
                    Logger.minor(this, "Opennet disabled");
                    msg = null;
                    continue block14;
                }
                if (msg.getSpec() == DMT.FNPOpennetAnnounceReply) {
                    this.validateForwardReply(msg, next);
                    continue;
                }
                if (msg.getSpec() == DMT.FNPOpennetAnnounceNodeNotWanted) {
                    if (this.cb != null) {
                        this.cb.nodeNotWanted();
                    }
                    if (this.source == null) continue;
                    try {
                        this.sendNotWanted();
                    }
                    catch (NotConnectedException e) {
                        Logger.error(this, "Lost connection to source");
                        return;
                    }
                }
                Logger.error(this, "Unexpected message: " + msg);
            }
            break;
        }
    }

    private boolean validateForwardReply(Message msg, PeerNode next) {
        block14: {
            long xferUID = msg.getLong("transferUID");
            int noderefLength = msg.getInt("noderefLength");
            int paddedLength = msg.getInt("paddedLength");
            byte[] noderefBuf = this.om.innerWaitForOpennetNoderef(xferUID, paddedLength, noderefLength, next, false, this.uid, true, this);
            if (noderefBuf == null) {
                return true;
            }
            SimpleFieldSet fs = this.om.validateNoderef(noderefBuf, 0, noderefLength, next, false);
            if (fs == null) {
                if (this.cb != null) {
                    this.cb.bogusNoderef("invalid noderef");
                }
                return true;
            }
            if (this.source != null) {
                try {
                    this.om.sendAnnouncementReply(this.uid, this.source, noderefBuf, this);
                }
                catch (NotConnectedException e) {
                    return false;
                }
            }
            try {
                OpennetPeerNode pn = this.node.addNewOpennetNode(fs);
                if (pn != null) {
                    this.cb.addedNode(pn);
                } else {
                    this.cb.nodeNotAdded();
                }
            }
            catch (FSParseException e) {
                Logger.normal(this, "Failed to parse reply: " + e, e);
                if (this.cb != null) {
                    this.cb.bogusNoderef("parse failed: " + e);
                }
            }
            catch (PeerParseException e) {
                Logger.normal(this, "Failed to parse reply: " + e, e);
                if (this.cb != null) {
                    this.cb.bogusNoderef("parse failed: " + e);
                }
            }
            catch (ReferenceSignatureVerificationException e) {
                Logger.normal(this, "Failed to parse reply: " + e, e);
                if (this.cb == null) break block14;
                this.cb.bogusNoderef("parse failed: " + e);
            }
        }
        return true;
    }

    private long sendTo(PeerNode next) {
        try {
            return this.om.startSendAnnouncementRequest(this.uid, next, this.noderefBuf, this, this.target, this.htl);
        }
        catch (NotConnectedException e) {
            if (logMINOR) {
                Logger.minor(this, "Disconnected");
            }
            return -1L;
        }
    }

    private void sendRest(PeerNode next, long xferUID) throws NotConnectedException {
        this.om.finishSentAnnouncementRequest(next, this.noderefBuf, this, xferUID);
    }

    private void timedOut(PeerNode next) {
        Message msg = DMT.createFNPRejectedOverload(this.uid, true);
        if (this.source != null) {
            try {
                this.source.sendAsync(msg, null, this);
            }
            catch (NotConnectedException notConnectedException) {
                // empty catch block
            }
        }
        if (this.cb != null) {
            this.cb.nodeFailed(next, "timed out");
        }
    }

    private void rnf(PeerNode next) {
        Message msg = DMT.createFNPRouteNotFound(this.uid, this.htl);
        if (this.source != null) {
            try {
                this.source.sendAsync(msg, null, this);
            }
            catch (NotConnectedException notConnectedException) {
                // empty catch block
            }
        }
        if (this.cb != null) {
            if (next != null) {
                this.cb.nodeFailed(next, "route not found");
            } else {
                this.cb.noMoreNodes();
            }
        }
    }

    private void complete() {
        Message msg = DMT.createFNPOpennetAnnounceCompleted(this.uid);
        if (this.source != null) {
            try {
                this.source.sendAsync(msg, null, this);
            }
            catch (NotConnectedException notConnectedException) {
                // empty catch block
            }
        }
    }

    private boolean transferNoderef() {
        long xferUID = this.msg.getLong("transferUID");
        this.noderefLength = this.msg.getInt("noderefLength");
        int paddedLength = this.msg.getInt("paddedLength");
        this.noderefBuf = this.om.innerWaitForOpennetNoderef(xferUID, paddedLength, this.noderefLength, this.source, false, this.uid, true, this);
        if (this.noderefBuf == null) {
            return false;
        }
        SimpleFieldSet fs = this.om.validateNoderef(this.noderefBuf, 0, this.noderefLength, this.source, false);
        if (fs == null) {
            this.om.rejectRef(this.uid, this.source, 4, this);
            return false;
        }
        try {
            if (this.om.addNewOpennetNode(fs) != null) {
                this.sendOurRef(this.source, this.om.crypto.myCompressedFullRef());
            } else {
                if (logMINOR) {
                    Logger.minor(this, "Don't need the node");
                }
                this.sendNotWanted();
            }
        }
        catch (FSParseException e) {
            if (logMINOR) {
                Logger.minor(this, "Rejecting noderef: " + e, (Throwable)e);
            }
            this.om.rejectRef(this.uid, this.source, 4, this);
            return false;
        }
        catch (PeerParseException e) {
            if (logMINOR) {
                Logger.minor(this, "Rejecting noderef: " + e, (Throwable)e);
            }
            this.om.rejectRef(this.uid, this.source, 4, this);
            return false;
        }
        catch (ReferenceSignatureVerificationException e) {
            if (logMINOR) {
                Logger.minor(this, "Rejecting noderef: " + e, (Throwable)e);
            }
            this.om.rejectRef(this.uid, this.source, 4, this);
            return false;
        }
        catch (NotConnectedException e) {
            Logger.normal(this, "Could not receive noderef, disconnected");
            return false;
        }
        return true;
    }

    private void sendNotWanted() throws NotConnectedException {
        Message msg = DMT.createFNPOpennetAnnounceNodeNotWanted(this.uid);
        this.source.sendAsync(msg, null, this);
    }

    private void sendOurRef(PeerNode next, byte[] ref) throws NotConnectedException {
        this.om.sendAnnouncementReply(this.uid, next, ref, this);
    }

    public void sentBytes(int x) {
        this.node.nodeStats.announceByteCounter.sentBytes(x);
    }

    public void receivedBytes(int x) {
        this.node.nodeStats.announceByteCounter.receivedBytes(x);
    }

    public void sentPayload(int x) {
    }

    public int getPriority() {
        return 7;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(4, this);
            }
        });
    }
}

